/*
 * ANSI definitions for GNU cc.
 * [atw] 19-Sep-89.
 */

#ifndef STDDEF_H
#define STDDEF_H

#ifdef __STRICT_ANSI__
#define TYPEOF __typeof__
#else
#define TYPEOF typeof
#endif

/*
 * ptrdiff_t : "the signed integral type of the result of subtracting two pointers."
 */

typedef TYPEOF((void *)1-(void *)0) ptrdiff_t;

/*
 * size_t : "the unsigned integral type of the result of the sizeof operator."
 */

typedef TYPEOF(sizeof(0)) size_t;

/*
 * NULL : null pointer constant.
 */
#ifndef NULL
#define NULL         ((void *)0)
#endif

/*
 * offsetof(type, identifier) : "offset in bytes from identifier to the beginning
 *                               of its structure (type)."
 */
#define offsetof(type,id) ((size_t)&(((type *)0)->id))

#endif
