/*			s t d i o
 *
 *		Author: C. E. Chew
 *		Date:   August 1989
 *
 * (C) Copyright C E Chew
 *
 * Feel free to copy, use and distribute this software provided:
 *
 *	1. you do not pretend that you wrote it
 *	2. you leave this copyright notice intact.
 *
 * Definitions and user interface for the stream io package.
 *
 * Patchlevel 1.2
 *
 * Edit History:
 * 17-Oct-1989  Added inline versions of the traditional macro functions
 *              (getc, putc, etc.).  This lets the compiler do type-checking
 *              and gets us through Plum Hall, which insists that they have
 *              callable versions for people who don't use headers. 
 *              Defined a bunch of ANSI-isms such as "fsetpos". [atw]
 * 16-Oct-1989  Removed <varargs.h> (can you say "yo-yo"??), added
 *              my own definition of the type "va_list" if needed
 *              (i.e. this program doesn't already include either
 *              <varargs.h> or <stdarg.h>). [atw]
 * 22-Sep-1989  Include <varargs.h>, modify protos of "v****" print
 *              functions to take type va_list. [atw]
 * 06-Sep-1989	Cast (x) to (unsigned char) in call to _flsbuf().
 * 05-Sep-1989  Mods for Gnu C (really for any ansi C) ++jrb
 * 05-Sep-1989	Make self reliant by removing dependency on proto.h
 *		and varargs.h.
 * 04-Sep-1989	Undo change to putc() since it makes it so much
 *		more complicated and makes so little difference
 *		to the speed.
 * 03-Sep-1989	Alter putc() to cope with line buffered streams.
 *		This makes processing of line buffered streams
 *		faster since no calls to _flsbuf is required
 *		unless the buffer fills.
 * 31-Aug-1989	Change to use _end as suggested by Bruce Evans
 *		many moons ago.
 */

#if	!defined(__STDIO__)
#define __STDIO__

/*
 * be sure size_t is defined & define CONST & VOIDSTAR
 */
#include <stddef.h>
#if defined(__GNUC__)
#ifndef CONST
#define CONST const
#endif
#ifndef VOIDSTAR
#define VOIDSTAR void *
#endif
#else
/*
 * not GNUC
 */
#ifndef CONST
#define CONST /* */
#endif
#ifndef VOIDSTAR
#define VOIDSTAR char *
#endif
#endif

#if	defined(__STDC__)
#  if    !defined(__NO_PROTO__)
#   define	__STDIO_P__(x)	x
#  else
#   define	__STDIO_P__(x)	()
#  endif
#else
# define	__STDIO_P__(x)	()
#endif
/*
 * "number of tmp file names generated"
 */
#define TMP_MAX 100
/*
 * "buffer big enough to hold a tmp file name"
 */
#define L_tmpnam 9
#define BUFSIZ 1024
#define _NFILE 20
#define NFILES _NFILE			/* backward compatibilty */
#define FOPEN_MAX _NFILE                /* ANSI compatibility */

extern struct _iobuf {
 unsigned char *_end;			/* point at end of buffer */
 unsigned char *_ptr;			/* pointer into buffer */
 unsigned char *_base;			/* base of buffer */
 int _bufsiz;				/* size of buffer */
 short _flag;				/* flags */
 char _file;				/* channel number */
 unsigned char _buf;			/* small buffer */
} *_iop[_NFILE];

#define _IOFBF		0000		/* fully buffered io */
#define _IOREAD		0001		/* opened for reading */
#define _IOWRITE	0002		/* opened for writing */
#define _IONBF		0004		/* unbuffered */
#define _IOMYBUF	0010		/* allocated buffer */
#define _IOEOF		0020		/* eof encountered */
#define _IOERR		0040		/* error encountered */
#define _IOSTRING	0100		/* strings */
#define _IOLBF		0200		/* line buffered */
#define _IORW		0400		/* opened for reading and writing */

#define SEEK_SET	0		/* seek from beginning */
#define SEEK_CUR	1		/* seek from here */
#define SEEK_END	2		/* seek from end */

#if !defined(NULL)
#  define NULL		((void *)0L)	/* null pointer */
#endif

typedef unsigned long fpos_t;
#define FILE		struct _iobuf	/* FILE structure */
#define EOF		(-1)		/* eof flag */

#define stdin		(_iop[0])
#define stdout		(_iop[1])
#define stderr		(_iop[2])

#if !defined(__GNUC__)
/*
 * traditional macro implementation.
 */
#define getc(p)		((p)->_ptr<(p)->_end?(int)(*(p)->_ptr++)\
					    :_filbuf(p))
#define getchar()	getc(stdin)

#define putc(x,p)	((p)->_ptr<(p)->_end\
                         ?(int)(*(p)->_ptr++=(unsigned char)(x))\
	                 :_flsbuf((unsigned char)(x),(p)))
#define	putchar(x)	putc(x,stdout)

#define fileno(p)	((p)->_file)

#define feof(p)		(((p)->_flag&_IOEOF)!=0)
#define ferror(p)	(((p)->_flag&_IOERR)!=0)
#define clearerr(p)	((p)->_flag&=~(_IOEOF|_IOERR))
#else
/*
 * Snazzy GNU inline version.
 */
#if defined(_INSTANTIATE_STDIO_)
#define INLINE
#define STATIC
#else
#define INLINE __inline__
#define STATIC static
#endif

INLINE STATIC int
  getc(FILE *p)
{
  return ((p)->_ptr<(p)->_end?(int)(*(p)->_ptr++)\
	  :_filbuf(p));
}

INLINE STATIC int
  getchar()
{
  return getc(stdin);
}

INLINE STATIC int
  putc(int x, FILE *p)
{
  return ((p)->_ptr<(p)->_end\
	  ?(int)(*(p)->_ptr++=(unsigned char)(x))\
	  :_flsbuf((unsigned char)(x),(p)));
}

INLINE STATIC int
  putchar(int x)
{
  return putc(x,stdout);
}

INLINE STATIC int
  fileno(FILE *p)
{
  return ((p)->_file);
}

INLINE STATIC int
  feof(FILE *p)
{
  return (((p)->_flag&_IOEOF)!=0);
}

INLINE STATIC int
  ferror(FILE *p)
{
  return (((p)->_flag&_IOERR)!=0);
}

INLINE STATIC void
  clearerr(FILE *p)
{	
  ((p)->_flag&=~(_IOEOF|_IOERR));
}
#undef INLINE
#undef STATIC
#endif

int	_filbuf		__STDIO_P__((FILE *));
int	_flsbuf		__STDIO_P__((unsigned char, FILE *));

FILE 	*fopen		__STDIO_P__((CONST char *, CONST char *));
FILE	*fdopen		__STDIO_P__((int, CONST char *));
FILE	*freopen	__STDIO_P__((CONST char *, CONST char *, FILE *));
int	fflush		__STDIO_P__((FILE *));
int	fclose		__STDIO_P__((FILE *));

int	fgetpos		__STDIO_P__((FILE *, fpos_t *));
int	fsetpos		__STDIO_P__((FILE *, const fpos_t *));
long	ftell		__STDIO_P__((FILE *));
int	fseek		__STDIO_P__((FILE *, long, int));
void	rewind		__STDIO_P__((FILE *));

int	fgetc		__STDIO_P__((FILE *));
int	fputc		__STDIO_P__((int, FILE *));
size_t	fread		__STDIO_P__((void *, size_t,
                                     size_t, FILE *));
size_t	fwrite		__STDIO_P__((CONST void *, size_t,
                                     size_t, FILE *));
int	getw		__STDIO_P__((FILE *));
int	putw		__STDIO_P__((int, FILE *));
char	*gets		__STDIO_P__((char *));
char	*fgets		__STDIO_P__((char *, int, FILE *));
int	puts		__STDIO_P__((CONST char *));
int	fputs		__STDIO_P__((CONST char *, FILE *));

int	ungetc		__STDIO_P__((int, FILE *));

#if    !defined(__SRC__)
int	printf		__STDIO_P__((CONST char *, ...));
int	fprintf		__STDIO_P__((FILE *, CONST char *, ...));
int	sprintf		__STDIO_P__((char *, CONST char *, ...));
int	scanf		__STDIO_P__((CONST char *, ...));
int	fscanf		__STDIO_P__((FILE *, CONST char *, ...));
int	sscanf		__STDIO_P__((CONST char *, CONST char *, ...));
#else
int	printf		__STDIO_P__((CONST char *, int));
int	fprintf		__STDIO_P__((FILE *, CONST char *, int));
int	sprintf		__STDIO_P__((char *, CONST char *, int));
int	scanf		__STDIO_P__((CONST char *, int));
int	fscanf		__STDIO_P__((FILE *, CONST char *, int));
int	sscanf		__STDIO_P__((CONST char *, CONST char *, int));
#endif /* __SRC__ */

int 	remove		__STDIO_P__((CONST char *));
int 	rename		__STDIO_P__((CONST char *, CONST char *));
FILE *	tmpfile		__STDIO_P__((void));
char *	tmpnam		__STDIO_P__((char *));
void    perror          __STDIO_P__((CONST char *));

#if defined(va_start)
#define __VA_LIST__ va_list
#else
#define __VA_LIST__ unsigned[2]
#endif
int	vprintf		__STDIO_P__((CONST char *, __VA_LIST__));
int	vfprintf	__STDIO_P__((FILE *, CONST char *, __VA_LIST__));
int	vsprintf	__STDIO_P__((char *, CONST char *, __VA_LIST__));
int	vscanf		__STDIO_P__((CONST char *, __VA_LIST__));
int	vfscanf		__STDIO_P__((FILE *, CONST char *, __VA_LIST__));
int	vsscanf		__STDIO_P__((CONST char *, CONST char *, __VA_LIST__));

void	setbuf		__STDIO_P__((FILE *, char *));
int	setvbuf		__STDIO_P__((FILE *, char *, int, unsigned int));
#endif /* __STDIO__ */

