/*			_ f i l b u f
 *
 * Allocate and fill a stream IO buffer. This function is
 * intimately tied to the macro getc() in the stdio library.
 *
 * The function will get a buffer full of data then return
 * the first character. EOF is returned on error.
 *
 * Patchlevel 1.1
 *
 * Edit History:
 * 05-Sep-1989	Add EINTR repeat code after read().
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

int _filbuf(fp)

FILE *fp;				/* stream */

{
  int bytes;				/* bytes read */
  int read();				/* read from channel */

  if (GETFLAG(fp, (_IORW | _IOREAD | _IOWRITE)) == _IORW)
    SETFLAG(fp, _IOREAD);

  if (GETFLAG(fp, (_IOREAD | _IOERR | _IOEOF | _IOSTRING)) != _IOREAD)
    return EOF;

/* Locate buffer space for this stream */
  if (fp->_base == NULL && _allocbuf(fp) < 0) {
    SETFLAG(fp, _IOERR);
    return EOF;
  }

/* Flush stdout if we're reading from stdin */
  if (fp == stdin && TESTFLAG(stdout, _IOLBF))
    (void) fflush(stdout);

/* Read data into the buffer */
  do
    bytes = read(fp->_file, (char *) fp->_base,
		 TESTFLAG(fp, _IONBF) ? 1 : fp->_bufsiz);
  while (bytes == -1 && errno == EINTR);

  INITREADBUFFER(fp, bytes == -1 ? 0 : bytes);

  switch (bytes) {
  case -1: SETFLAG(fp, _IOERR); return EOF;
  case 0:  SETFLAG(fp, _IOEOF); return EOF;
  default:                      return *fp->_ptr++;
  }
}
