#include "lib.h"

#define ODD(x) (((short)(x)) & 1)	/* word ops are faster */

/*
 * zero out a chunk efficiently
 * handles odd address
 *
 *   ++jrb  bammi@dsrgsun.ces.cwru.edu
 */
void bzero(b, n)
register VOIDSTAR b;
register long n;
{
    register long l, w;
    
    
    if(ODD(b))
    {
	*(char *)b++ = (char)0;
	n--;
    }

    l = (n >> 2); /* # of longs */
    n -= (l << 2);
    w = (n >> 1); /* # of words */
    n -= (w << 1); /* n == # of residual bytes */

    while(l--)
	*((long *)b)++ = 0L;
    while(w--)
	*((short *)b)++ = (short)0;
    while(n--)
	*(char *)b++ = (char)0;
}

