/*				f r e o p e n
 *
 * Open the named file and associate it with the stream indicated.
 * The type of the stream is interpreted in the same manner as
 * for fopen(). The original stream is closed using fclose()
 * regardless of whether the open succeeds or not.
 *
 * The function returns a pointer to the stream on success, otherwise
 * it returns NULL.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

FILE *freopen(name, mode, fp)

CONST char *name;				/* name to open */
CONST char *mode;				/* mode to open with */
FILE       *fp;					/* stream */

{
  int fd;				/* opened file descriptor */
  short flags;				/* flag settings */
  int close();				/* close a channel */
  void free();				/* free memory */

/* Close this stream */
  (void) fflush(fp);
  (void) close(fp->_file);

/* Free any buffers */
  if (TESTFLAG(fp, _IOMYBUF))
    free((void *) fp->_base);

/* Open according to the specified mode */
  return (fd = _fopen(name, mode, -1, &flags)) == -1
    ? NULL
    : _file(fp, fd, flags);
}
