/*				f s e e k
 *
 * Set the position of a stream. The new position is at the signed
 * distance offset bytes from either the beginning, current position
 * of end of the file. Any effects of ungetc() are undone.
 *
 * The function returns EOF for improper seeks, otherwise zero.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 *     19-Oct-89  Added "rewind" to this module (a natural companion
 *                for fseek) and wrote its ANSI cousin, fsetpos.  [atw]
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

int fseek(fp, offset, ptr)

FILE *fp;				/* stream */
long offset;				/* offset */
int ptr;				/* reference */

{
  long lseek();				/* seek on file */

  if (fflush(fp) || lseek(fp->_file, offset, ptr) == EOF)
    return EOF;

  CLEARFLAG(fp, _IOEOF);

  if (TESTFLAG(fp, _IORW)) {
    CLEARFLAG(fp, (_IOREAD | _IOWRITE));
    FLUSHNEXTACCESS(fp);
  }

  return 0;
}

void rewind(fp)

FILE *fp;				/* stream */

{
  (void) fseek(fp, 0L, SEEK_SET);
}

int
  fsetpos(FILE *s, const fpos_t *pos)
{
  if (fseek(s, *pos, SEEK_SET))
    {
     errno = EIO;
     return errno;
    }
  else
    return 0;
}
