/*
 *	rename() - rename a file
 */
#include "lib.h"
#include <signal.h>
#include <errno.h>

#define	PUBLIC

#ifndef	NULL
#define NULL	(void *) 0
#endif

/*========================================================================*\
**				rename()				  **
\*========================================================================*/
PUBLIC int
rename( from, to )
CONST char *from, *to;
{
/*
 *	Attempts to link 'from' as 'to'.  If 'to' exists it is unlinked.
 *
 *	NOTE:  	extremely naive implementation.  [atw]
 */
  void		(*s_int)(), (*s_quit)();
  int		ret = 0;
  
  /*
   *	Ignore SIGINT & SIGABRT until
   *	we're finished.
   */
  s_int  = signal( SIGINT,  SIG_IGN );
  s_quit = signal( SIGABRT, SIG_IGN );  
  /*	
   *	does 'to' exist? if so remove it
   */
  ret = unlink( to );
  if ((ret = link( from, to )) == 0) 
    ret = unlink( from );
  /*
   *	Restore signals
   */
  signal( SIGINT,  s_int  );
  signal( SIGABRT, s_quit );
  return( ret );

}
