# Copyright (c) 2009 David Sugar, Tycho Softworks.
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

Name: ccaudio2
Summary: C++ class framework for telephonic audio applications
Version: 2.0.0
Release: 0%{?dist}
License: LGPLv3+
URL: http://www.gnu.org/software/ccaudio
Group: System Environment/Libraries
Source0: http://www.gnutelephony.org/dist/tarballs/ccaudio2-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: ucommon-devel >= 4.1.0

%description
The GNU telephonic audio library covers a range of functionality including
tone generation and detection, streaming and transcoding of encoded audio
frames, accessing of audio files on disk, phrasebook management, and audio
utilities.

%package devel
Requires: %{name} = %{version}-%{release}
Requires: ucommon-devel >= 4.1.0
Group: Development/Libraries
Summary: Headers for building ccaudio applications

%description devel
This package provides header and support files for building applications
that use GNU ccAudio.

%prep
%setup -q
%build

%configure --disable-static
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
%{__make} DESTDIR=%{buildroot} INSTALL="install -p" install
%{__rm} %{buildroot}%{_libdir}/*.la

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root,-)
%doc AUTHORS README COPYING NEWS SUPPORT ChangeLog
%{_libdir}/*.so.*
%{_bindir}/audiotool
%{_bindir}/tonetool

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.so
%{_includedir}/ccaudio2.h
%{_libdir}/pkgconfig/*.pc
%{_bindir}/ccaudio2-config
%{_mandir}/man1/ccaudio2-config.*

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%changelog
* Sat Jan 1 2011 - David Sugar <dyfet@gnutelephony.org> - 2.0.0-0
- initial packaging for redhat/fedora submission policies.

