/* The basic idea of this module is to create lisp callable functions
   for the T symbols in the cygwin library libgdi32.a.  To do this, I
   used a awk program which parsed the function headers, and created
   the functions here.  So most of them are not tested.
   Once a function is tested remove the untested comment from the function.
   This file is LGPL'd, and copyright assigned to the FSF.
   Dan Stanger 4/9/02
*/
#include "lispbibl.c"
#define DEFMODULE(a,b)
#define DEFUN(funname,lambdalist,signature) LISPFUN signature
#define DEFVAR(varname)
#define WIDECHAR(o,e)  &TheSstring(o)->data[0]
#define memclr(p,n) memset(p,0,n)
#define NO_STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#define encoding (C_terminal_encoding(),value1)
DEFMODULE(gdi,"GDI")

local object lookupHash(int hwnd, int message);

LRESULT CALLBACK WindowProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
printf("HWND %x UINT %d WPARAM %d LPARAM %d\n",hWnd,message,wParam,lParam);
  switch (message) {
   // When window is created, the callback gets done before the createwindow
   // returns with a handle.  To get around this, and this is NOT thread
   // safe, store a alist of messages and functions.  Then call a
   // lisp function with the window handle and the alist, and store
   // the new list in the hash table.
   case WM_NCCREATE:
   {
     object p;
     begin_callback();
     p = allocate_fpointer(hWnd);
     pushSTACK(p);
     funcall(O(onCreate),1);
     end_callback();
     return TRUE;
   }
   case WM_CREATE:
   {
      break;
   }
   case WM_PAINT:
   {
     PAINTSTRUCT paintStruct;
     object func;
//asm("int3");
     BeginPaint(hWnd,&paintStruct);
     begin_callback();
     func = lookupHash(hWnd, message);
     if(!nullp(func))
     {
        pushSTACK(allocate_fpointer(paintStruct.hdc));
        funcall(func,1);
     }
     end_callback();
     EndPaint(hWnd,&paintStruct);
     break;
   }
   case WM_CLOSE:
   {
     object func;
//asm("int3");
     begin_callback();
     func = lookupHash(hWnd, message);
     if(!nullp(func))
     {
        pushSTACK(allocate_fpointer(hWnd));
        funcall(func,1);
        end_callback();
     }
     else
     {
        end_callback();
        return (DefWindowProc(hWnd, message, wParam, lParam));
     }
     break;
   }
   case WM_KEYDOWN:
     switch (wParam)
     {
       case VK_CANCEL:
       case VK_CLEAR:
       case VK_PAUSE:
       case VK_PRIOR:
       case VK_NEXT:
       case VK_END:
       case VK_HOME:
       case VK_LEFT:
       case VK_UP:
       case VK_RIGHT:
       case VK_DOWN:
       case VK_SELECT:
       case VK_PRINT:
       case VK_EXECUTE:
       case VK_INSERT:
       case VK_DELETE:
       case VK_HELP:
       case VK_NUMLOCK:
       case VK_SCROLL:
       case VK_F1:
       case VK_F2:
       case VK_F3:
       case VK_F4:
       case VK_F5:
       case VK_F6:
       case VK_F7:
       case VK_F8:
       case VK_F9:
       case VK_F10:
       case VK_F11:
       case VK_F12:
       default:
       {
         begin_callback();
         object func = lookupHash(hWnd, message);
         if(!nullp(func))
         {
            pushSTACK(allocate_fpointer(lParam));
            pushSTACK(fixnum(wParam));
            funcall(func,2);
         }
         end_callback();
         break;
       }
     }
     break;
   case WM_LBUTTONDOWN:
   case WM_MBUTTONDOWN:
   case WM_RBUTTONDOWN:
   case WM_MBUTTONUP:
   case WM_LBUTTONUP:
   case WM_RBUTTONUP:
   case WM_MOUSEMOVE:
   case WM_MOUSEWHEEL:
   case WM_ERASEBKGND:
   case WM_KILLFOCUS:
   case WM_SETFOCUS:
   case WM_QUIT:
   case WM_DESTROY:
   case WM_SYSCHAR: /* alt-keys go here */
   case WM_CHAR:
   case WM_LBUTTONDBLCLK:
   case WM_MBUTTONDBLCLK:
   case WM_RBUTTONDBLCLK:
   case WM_MOVE:	
   case WM_SIZE:			
   case WM_DESTROYCLIPBOARD:
   default:        /* Passes it on if unproccessed    */
     return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return 0L;
}
local object lookupHash(int hwnd, int message){
printf("lookupHash hwnd %x message %d\n",hwnd,message);
   Car(O(localCons)) = allocate_fpointer(hwnd);
   Cdr(O(localCons)) = fixnum(message);
   pushSTACK(O(localCons));
   pushSTACK(O(functions));
   funcall(S(gethash),2);
   return value1;
}

DEFVAR(functions,`nil`)
DEFVAR(localCons,`nil`)
DEFVAR(onCreate,`nil`)
DEFUN( GDI:INITC, h f)
{
  O(localCons) = allocate_cons();
  O(onCreate) = popSTACK();
  O(functions) = popSTACK();
  value1 = allocate_fpointer(GetModuleHandle(0));
  mv_count=1;
  return;
}
local LPSTR idc[] ={
   0,
   IDC_ARROW,
   IDC_IBEAM,
   IDC_WAIT,
   IDC_CROSS,
   IDC_UPARROW,
   IDC_SIZENWSE,
   IDC_SIZENESW,
   IDC_SIZEWE,
   IDC_SIZENS,
   IDC_SIZEALL,
   IDC_NO,
   IDC_HAND,
   IDC_APPSTARTING,
   IDC_HELP,
   IDC_ICON,
   IDC_SIZE
};
DEFUN( GDI:GETIDC, h)
{
  object arg = popSTACK();
  check_uint32(arg);
  value1 = allocate_fpointer(idc[I_to_uint32(arg)]);
  mv_count=1;
  return;
}
 
DEFUN( GDI:MAKEFPOINTER, h)
{
  value1 = allocate_fpointer(I_to_uint32(popSTACK()));
  mv_count=1;
  return;
}
DEFUN( GDI:MESSAGELOOP,)
{
  MSG m;
  while (GetMessage(&m, (HWND) NULL, 0, 0)) { 
    TranslateMessage(&m); 
    DispatchMessage(&m); 
  } 
  value1 = fixnum(m.wParam);
  mv_count=1;
  return;
}
#line 1 "local.c"
local void processBOOL(void *p,object arg){}
local void processFINDEX_INFO_LEVELS(void *p,object arg){}
local void processFINDEX_SEARCH_OPS(void *p,object arg){}
local void processLPSTR(void *p,object arg){}
local void processLPWSTR(void *p,object arg){}
local void processPBITMAPINFO(void *p,object arg){}
local void processPINT(void *p,object arg){}
local void processPPOINT(void *p,object arg){}
local void processSTR_P(void *p,object arg){}
local void processWSTR_P(void *p,object arg){}
local void outputCOLORADJUSTMENT(COLORADJUSTMENT *p, object arg){}
local void outputXFORM(XFORM *p, object arg){}
local void processABC(ABC *p, object arg){}
local void processPBYTE(BYTE *p, object arg){}
local void processBYTE(BYTE *p, object arg){}
local void processABCFLOAT(ABCFLOAT *p, object arg){}
local void processENHMETAHEADER(void *p, object arg){}
local void processFONTSIGNATURE(void *p, object arg){}
local void processKERNINGPAIR(void *p, object arg){}
local void processOUTLINETEXTMETRICA(void *p, object arg){}
local void processOUTLINETEXTMETRICW(void *p, object arg){}
local void processRASTERIZER_STATUS(void *p, object arg){}
local void processRGBQUAD(RGBQUAD *p, object arg){}
local void processTEXTMETRICW(TEXTMETRICW*p, object arg){}
local void outputGLYPHMETRICS(GLYPHMETRICS* p, object arg){}
local void processGCP_RESULTSA(GCP_RESULTSA* p, object arg){}
local void processGCP_RESULTSW(GCP_RESULTSW* p, object arg){}
local void processHANDLETABLE_C(HANDLETABLE* p, object arg, unsigned int count){}
local void processLOGCOLORSPACEA(LOGCOLORSPACEA* p, object arg){}
local void processLOGCOLORSPACEW(LOGCOLORSPACEW* p, object arg){}
local void processMETARECORD(METARECORD* p, object arg){}
local void processPOLYTEXTW(POLYTEXTW* p, object arg){}
local void processSIZE(SIZE* p, object arg){}
local void processvoid(void* p, object arg){}

local void processABORTPROC(ABORTPROC *p,object arg){}
local void processBITMAPINFO(BITMAPINFO *p,object arg){}
local void processBITMAPINFOHEADER(BITMAPINFOHEADER *p,object arg){}
local void processDEVMODEA(DEVMODEA *p,object arg){}
local void processDEVMODEW(DEVMODEW *p,object arg){}
local void processDOCINFOA(DOCINFOA *p,object arg){}
local void processDOCINFOW(DOCINFOW *p,object arg){}
local void processENHMETARECORD(ENHMETARECORD *p,object arg){}
local void processENHMFENUMPROC(ENHMFENUMPROC *p,object arg){}
local void processFONTENUMPROCA(FONTENUMPROCA *p,object arg){}
local void processFONTENUMPROCW(FONTENUMPROCW *p,object arg){}
local void processGLYPHMETRICS(GLYPHMETRICS *p,object arg){}
local void processGOBJENUMPROC(GOBJENUMPROC *p,object arg){}
local void processICMENUMPROCA(ICMENUMPROCA *p,object arg){}
local void processICMENUMPROCW(ICMENUMPROCW *p,object arg){}
local void processLINEDDAPROC(LINEDDAPROC *p,object arg){}
local void processLOGPALETTE(LOGPALETTE *p,object arg){}
local void processLOGPEN(LOGPEN *p,object arg){}
local void processLPABC(LPABC *p,object arg){}
local void processLPABCFLOAT(LPABCFLOAT *p,object arg){}
local void processLPBITMAPINFO(LPBITMAPINFO *p,object arg){}
local void processLPCHARSETINFO(LPCHARSETINFO *p,object arg){}
local void processLPCOLORADJUSTMENT(LPCOLORADJUSTMENT *p,object arg){}
local void processLPCRECT(LPCRECT *p,object arg){}
local void processLPENHMETAHEADER(LPENHMETAHEADER *p,object arg){}
local void processLPFONTSIGNATURE(LPFONTSIGNATURE *p,object arg){}
local void processLPGCP_RESULTSA(LPGCP_RESULTSA *p,object arg){}
local void processLPGCP_RESULTSW(LPGCP_RESULTSW *p,object arg){}
local void processLPHANDLETABLE(LPHANDLETABLE *p,object arg){}
local void processLPINT(LPINT *p,object arg){}
local void processLPKERNINGPAIR(LPKERNINGPAIR *p,object arg){}
local void processLPLOGCOLORSPACEA(LPLOGCOLORSPACEA *p,object arg){}
local void processLPLOGCOLORSPACEW(LPLOGCOLORSPACEW *p,object arg){}
local void processLPMETARECORD(LPMETARECORD *p,object arg){}
local void processLPOUTLINETEXTMETRICA(LPOUTLINETEXTMETRICA *p,object arg){}
local void processLPOUTLINETEXTMETRICW(LPOUTLINETEXTMETRICW *p,object arg){}
local void processLPPALETTEENTRY(LPPALETTEENTRY *p,object arg){}
local void processLPPIXELFORMATDESCRIPTOR(LPPIXELFORMATDESCRIPTOR *p,object arg){}
local void processLPPOINT(LPPOINT *p,object arg){}
local void processLPRASTERIZER_STATUS(LPRASTERIZER_STATUS *p,object arg){}
local void processLPRECT(LPRECT *p,object arg){}
local void processLPSIZE(LPSIZE *p,object arg){}
local void processLPTEXTMETRICA(LPTEXTMETRICA *p,object arg){}
local void processLPTEXTMETRICW(LPTEXTMETRICW *p,object arg){}
//local void processLPXFORM(LPXFORM *p,object arg){}
local void processMFENUMPROC(MFENUMPROC *p,object arg){}
local void processPFLOAT(PFLOAT *p,object arg){}
local void processRGNDATA(RGNDATA *p,object arg){}
local void processRGNDATA_C(RGNDATA *p,object arg, int count){}

local void processICONINFO(ICONINFO *p,object arg)
{
   int i = 1;
   p->fIcon = nullp(TheRecord(arg)->recdata[i++]);
   p->xHotspot = I_to_L(TheRecord(arg)->recdata[i++]);
   p->yHotspot = I_to_L(TheRecord(arg)->recdata[i++]);
   p->hbmMask = TheFpointer(TheRecord(arg)->recdata[i++])->fp_pointer;
   p->hbmColor = TheFpointer(TheRecord(arg)->recdata[i++])->fp_pointer;
}
local void processLOGFONTA(LOGFONTA *p,object arg)
{
   int i = 1;
   p->lfHeight = I_to_L(TheRecord(arg)->recdata[i++]);
   p->lfWidth = I_to_L(TheRecord(arg)->recdata[i++]);
   p->lfEscapement = I_to_L(TheRecord(arg)->recdata[i++]);
   p->lfOrientation = I_to_L(TheRecord(arg)->recdata[i++]);
   p->lfWeight = I_to_L(TheRecord(arg)->recdata[i++]);
   p->lfItalic = I_to_uint8(TheRecord(arg)->recdata[i++]);
   p->lfUnderline = I_to_uint8(TheRecord(arg)->recdata[i++]);
   p->lfStrikeOut = I_to_uint8(TheRecord(arg)->recdata[i++]);
   p->lfCharSet = I_to_uint8(TheRecord(arg)->recdata[i++]);
   p->lfOutPrecision = I_to_uint8(TheRecord(arg)->recdata[i++]);
   p->lfClipPrecision = I_to_uint8(TheRecord(arg)->recdata[i++]);
   p->lfQuality = I_to_uint8(TheRecord(arg)->recdata[i++]);
   p->lfPitchAndFamily = I_to_uint8(TheRecord(arg)->recdata[i++]);
   strncpy(p->lfFaceName,
      TheAsciz(string_to_asciz(TheRecord(arg)->recdata[i++],encoding)),
      sizeof(p->lfFaceName));
}
local void processLOGFONTW(LOGFONTW *p,object arg){}
local void outputRECT(object p, RECT *r)
{
  int i = 0;
  object num;
  pushSTACK(p); // Push the record to keep it safe from gc
  num = UL_to_I(r->left); // Can cause gc
  TheRecord(STACK_0)->recdata[i++] = num;
  num = UL_to_I(r->top); // Can cause gc
  TheRecord(STACK_0)->recdata[i++] = num;
  num = UL_to_I(r->right); // Can cause gc
  TheRecord(STACK_0)->recdata[i++] = num;
  num = UL_to_I(r->bottom); // Can cause gc
  TheRecord(popSTACK())->recdata[i++] = num;
}
// untested - was never called
local void processPALETTEENTRY(PALETTEENTRY* p, object arg)
{
   int i = 0;
   p->peRed = I_to_uint8(TheRecord(arg)->recdata[i++]);
   p->peGreen = I_to_uint8(TheRecord(arg)->recdata[i++]);
   p->peBlue = I_to_uint8(TheRecord(arg)->recdata[i++]);
   p->peFlags = I_to_uint8(TheRecord(arg)->recdata[i++]);
}
// untested - was never called
local void processRGBQUAD_C(RGBQUAD* p, object args,DWORD length)
{
   int j;
   for(j = 0; j < length; j++,p++)
   {
      int i = 0;
      object arg = TheSvector(args)->data[j];
      p->rgbRed = I_to_uint8(TheRecord(arg)->recdata[i++]);
      p->rgbGreen = I_to_uint8(TheRecord(arg)->recdata[i++]);
      p->rgbBlue = I_to_uint8(TheRecord(arg)->recdata[i++]);
      p->rgbReserved = 0;
   }
}
local DWORD processCOLORREF(object arg)
{
    int i = 0;
    BYTE r = I_to_uint8(TheRecord(arg)->recdata[i++]);
    BYTE g = I_to_uint8(TheRecord(arg)->recdata[i++]);
    BYTE b = I_to_uint8(TheRecord(arg)->recdata[i++]);
    return RGB(r,g,b);
}
// untested - was never called
// uninspected - compiles but code was not checked
local void processXFORM(XFORM *p, object arg)
{
    int i = 0;
    p->eM11 = ffloat_value(TheRecord(arg)->recdata[i++]);
    p->eM12 = ffloat_value(TheRecord(arg)->recdata[i++]);
    p->eM21 = ffloat_value(TheRecord(arg)->recdata[i++]); 
    p->eM22 = ffloat_value(TheRecord(arg)->recdata[i++]); 
    p->eDx = ffloat_value(TheRecord(arg)->recdata[i++]); 
    p->eDy = ffloat_value(TheRecord(arg)->recdata[i++]);
}
// untested - was never called
// uninspected - compiles but code was not checked
local void outputLPSIZE(LPSIZE lpsize,object arg)
{
}
// untested - was never called
// uninspected - compiles but code was not checked
local void processPOINT(POINT* p, object arg)
{
   int i = 0;
   p->x = I_to_sint32(TheRecord(arg)->recdata[i++]);
   p->y = I_to_sint32(TheRecord(arg)->recdata[i++]);
}
// untested - was never called
// uninspected - compiles but code was not checked
local void processRECT(RECT* p, object arg)
{
  int i = 0;
  p->left = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->top = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->right = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->bottom = I_to_sint32(TheRecord(arg)->recdata[i++]);
}
local void processPOLYTEXTA(POLYTEXTA* p, object arg)
{
  int i = 0;
  p->x = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->y = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->n = I_to_uint32(TheRecord(arg)->recdata[i++]);
  p->lpstr = TheAsciz(TheRecord(arg)->recdata[i++]);
  p->uiFlags = I_to_uint32(TheRecord(arg)->recdata[i++]);
  processRECT(&p->rcl, TheRecord(arg)->recdata[i++]);
  p->pdx = I_to_sint32(TheRecord(arg)->recdata[i++]);
}
// untested - was never called
local void processCOLORADJUSTMENT(COLORADJUSTMENT *p, object arg)
{
   int i;
   WORD *w = (WORD*)p;
   SHORT *s = (SHORT*)p;
   for(i = 0; i < 8; i++)w[i]= I_to_uint16(TheRecord(arg)->recdata[i]);
   for(; i < 12; i++)s[i] = I_to_sint16(TheRecord(arg)->recdata[i]);
}
// untested - was never called
local void processPIXELFORMATDESCRIPTOR(PIXELFORMATDESCRIPTOR* p,object arg)
{
  int i = 0;
  p->nSize = I_to_uint16(TheRecord(arg)->recdata[i++]);
  p->nVersion = I_to_uint16(TheRecord(arg)->recdata[i++]);
  p->dwFlags = I_to_uint32(TheRecord(arg)->recdata[i++]);
  p->iPixelType = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cColorBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cRedBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cRedShift = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cGreenBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cGreenShift = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cBlueBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cBlueShift = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cAlphaBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cAlphaShift = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cAccumBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cAccumRedBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cAccumGreenBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cAccumBlueBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cAccumAlphaBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cDepthBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cStencilBits = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->cAuxBuffers = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->iLayerType = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->bReserved = I_to_uint8(TheRecord(arg)->recdata[i++]);
  p->dwLayerMask = I_to_uint32(TheRecord(arg)->recdata[i++]);
  p->dwVisibleMask = I_to_uint32(TheRecord(arg)->recdata[i++]);
  p->dwDamageMask = I_to_uint32(TheRecord(arg)->recdata[i++]);
}
// untested - was never called
// uninspected - compiles but code was not checked
// known not to work
local FIXED toFixed(float f)
{
  FIXED fixed;
  int i;
  fixed.value = (int)f;
  fixed.fract = (WORD)(10000*(f - i));
  return fixed;
}

local void processMAT2(MAT2 *p, object arg)
{
  int i = 0;
  p->eM11 = toFixed(ffloat_value(TheRecord(arg)->recdata[i++]));
  p->eM12 = toFixed(ffloat_value(TheRecord(arg)->recdata[i++]));
  p->eM21 = toFixed(ffloat_value(TheRecord(arg)->recdata[i++]));
  p->eM22 = toFixed(ffloat_value(TheRecord(arg)->recdata[i++]));
}
// untested - was never called
// uninspected - compiles but code was not checked
local void processBITMAP(BITMAP *p,object arg)
{
  int i = 0;
  p->bmType = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->bmWidth = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->bmHeight = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->bmWidthBytes = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->bmPlanes = I_to_uint16(TheRecord(arg)->recdata[i++]);
  p->bmBitsPixel = I_to_uint16(TheRecord(arg)->recdata[i++]);
  p->bmBits = &TheSbvector( TheRecord(arg)->recdata[i++])->data[0];
}
// untested - was never called
// uninspected - compiles but code was not checked
local void processLOGBRUSH(LOGBRUSH* p, object arg)
{
   int i = 0;
   p->lbStyle = I_to_uint32(TheRecord(arg)->recdata[i++]);
   p->lbColor = processCOLORREF(TheRecord(arg)->recdata[i++]);
   p->lbHatch = I_to_sint32(TheRecord(arg)->recdata[i++]);
}
// untested - was never called
// uninspected - compiles but code was not checked
local void processMETAFILEPICT(METAFILEPICT *p,object arg)
{
  int i = 0;
  p->mm = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->xExt = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->yExt = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->hMF = TheFpointer(TheRecord(arg)->recdata[i++])->fp_pointer;
}

local void processWNDCLASSA(WNDCLASSA *p, object arg)
{
  object s;
  int i = 1;
  p->style = I_to_uint32(TheRecord(arg)->recdata[i++]);
  p->lpfnWndProc  = WindowProc;
  p->cbClsExtra = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->cbWndExtra = I_to_sint32(TheRecord(arg)->recdata[i++]);
  p->hInstance = TheFpointer(TheRecord(arg)->recdata[i++])->fp_pointer;
  s = TheRecord(arg)->recdata[i++];
  p->hIcon = nullp(s)?0:TheFpointer(s)->fp_pointer;
  p->hCursor = TheFpointer(TheRecord(arg)->recdata[i++])->fp_pointer;
  p->hbrBackground = TheFpointer(TheRecord(arg)->recdata[i++])->fp_pointer;
  s = TheRecord(arg)->recdata[i++];
  if(nullp(s))
  {
     p->lpszMenuName = NULL;
  }
  else if(stringp(s))
  {
     p->lpszMenuName = TheAsciz(string_to_asciz(s,encoding));
  }
  else if(fpointerp(s))
  {
     p->lpszMenuName = TheFpointer(s)->fp_pointer;
  }
  else argumentum_inritum(s);
  s = TheRecord(arg)->recdata[i++];
  p->lpszClassName = stringp(s)?
       TheAsciz(string_to_asciz(s,encoding)):
       TheFpointer(s)->fp_pointer;
}

local void processWNDCLASSW(WNDCLASSW *p, object arg){}

local void processCREATESTRUCTA(CREATESTRUCT *p, object arg)
{
  object s;
  int i = 1;
  p->dwExStyle = I_to_uint32(TheRecord(arg)->recdata[i++]);
  s = TheRecord(arg)->recdata[i++];
  p->lpszClass = stringp(s)?
       TheAsciz(string_to_asciz(s,encoding)):
       TheFpointer(s)->fp_pointer;
  p->lpszName = TheAsciz(string_to_asciz(TheRecord(arg)->recdata[i++],encoding));
  p->style = I_to_uint32(TheRecord(arg)->recdata[i++]);
  p->x = I_to_L(TheRecord(arg)->recdata[i++]);
  p->y = I_to_L(TheRecord(arg)->recdata[i++]);
  p->cx = I_to_L(TheRecord(arg)->recdata[i++]);
  p->cy = I_to_L(TheRecord(arg)->recdata[i++]);
  s = TheRecord(arg)->recdata[i++];
  p->hwndParent = nullp(s)?0:TheFpointer(s)->fp_pointer;
  s = TheRecord(arg)->recdata[i++];
  p->hMenu = nullp(s)?0:TheFpointer(s)->fp_pointer;
  s = TheRecord(arg)->recdata[i++];
  p->hInstance = nullp(s)?0:TheFpointer(s)->fp_pointer;
  p->lpCreateParams = 0;  //= I_to_uint8(TheRecord(arg)->recdata[i++]);
}
local void outputCREATESTRUCTA(CREATESTRUCT *p, object arg)
{
  int i = 1;
  pushSTACK(arg);
  TheRecord(STACK_0)->recdata[i++] = UL_to_I(p->dwExStyle);
  TheRecord(STACK_0)->recdata[i++] = asciz_to_string(p->lpszClass,encoding);
  TheRecord(STACK_0)->recdata[i++] = asciz_to_string(p->lpszName,encoding);
  TheRecord(STACK_0)->recdata[i++] = UL_to_I(p->style);
  TheRecord(STACK_0)->recdata[i++] = L_to_I(p->x);
  TheRecord(STACK_0)->recdata[i++] = L_to_I(p->y);
  TheRecord(STACK_0)->recdata[i++] = L_to_I(p->cx);
  TheRecord(STACK_0)->recdata[i++] = L_to_I(p->cy);
  TheRecord(STACK_0)->recdata[i++] = allocate_fpointer(p->hwndParent);
  TheRecord(STACK_0)->recdata[i++] = allocate_fpointer(p->hMenu);
  TheRecord(STACK_0)->recdata[i++] = allocate_fpointer(p->hInstance);
  TheRecord(popSTACK())->recdata[i++] = NIL; //L_to_I(p->lpCreateParams);
}
local void outputTEXTMETRICA(TEXTMETRICA *p, object arg)
{
  int i = 1;
  pushSTACK(arg);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmHeight);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmAscent);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmDescent);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmInternalLeading);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmExternalLeading);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmAveCharWidth);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmMaxCharWidth);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmWeight);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmOverhang);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmDigitizedAspectX);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmDigitizedAspectY);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmFirstChar);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmLastChar);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmDefaultChar);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmBreakChar);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmItalic);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmUnderlined);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmStruckOut);
  TheRecord(STACK_0)->recdata[i++] = fixnum(p->tmPitchAndFamily);
  TheRecord(popSTACK())->recdata[i++] = fixnum(p->tmCharSet);
}
local object outputFLOATS(FLOAT *p, UINT length){}

nonreturning_function(local, argumentum_inritum, (object obj)) {
  pushSTACK(obj);
  fehler(error,GETTEXT("~ is a invalid argument"));
}
#line 1 "funcs.c"
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ABORTDOC, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = AbortDoc(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ABORTPATH, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = AbortPath(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ADDATOMA, lpcstr)
{
  object arg;
  ATOM atom;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  atom = AddAtomA(lpcstr);
  end_system_call();
  if(0 ==atom){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(atom);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ADDATOMW, lpcwstr)
{
  object arg;
  ATOM atom;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  atom = AddAtomW(lpcwstr);
  end_system_call();
  if(0 ==atom){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(atom);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:BEGINPATH, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = BeginPath(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CANCELDC, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = CancelDC(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CLOSEENHMETAFILE, hdc)
{
  object arg;
  HENHMETAFILE henhmetafile;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  henhmetafile = CloseEnhMetaFile(hdc);
  end_system_call();
  if(NULL ==henhmetafile){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(henhmetafile);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CLOSEFIGURE, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = CloseFigure(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CLOSEMETAFILE, hdc)
{
  object arg;
  HMETAFILE hmetafile;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hmetafile = CloseMetaFile(hdc);
  end_system_call();
  if(NULL ==hmetafile){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hmetafile);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:COLORMATCHTOTARGET, hdc hdc0 dword)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HDC hdc0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc0 = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = ColorMatchToTarget(hdc,hdc0,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:COMBINERGN, hrgn hrgn0 hrgn1 int0)
{
  object arg;
  int int1;
  HRGN hrgn;
  HRGN hrgn0;
  HRGN hrgn1;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn1 = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn0 = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = CombineRgn(hrgn,hrgn0,hrgn1,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATECOMPATIBLEBITMAP, hdc int0 int1)
{
  object arg;
  HBITMAP hbitmap;
  HDC hdc;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hbitmap = CreateCompatibleBitmap(hdc,int0,int1);
  end_system_call();
  if(NULL ==hbitmap){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbitmap);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATECOMPATIBLEDC, hdc)
{
  object arg;
  HDC hdc0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hdc0 = CreateCompatibleDC(hdc);
  end_system_call();
  if(NULL ==hdc0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEDIBPATTERNBRUSH, hglobal uint)
{
  object arg;
  HBRUSH hbrush;
  HGLOBAL hglobal;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hglobal = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hbrush = CreateDIBPatternBrush(hglobal,uint);
  end_system_call();
  if(NULL ==hbrush){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbrush);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEDISCARDABLEBITMAP, hdc int0 int1)
{
  object arg;
  HBITMAP hbitmap;
  HDC hdc;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hbitmap = CreateDiscardableBitmap(hdc,int0,int1);
  end_system_call();
  if(NULL ==hbitmap){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbitmap);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEELLIPTICRGN, int0 int1 int2 int3)
{
  object arg;
  HRGN hrgn;
  int int0;
  int int1;
  int int2;
  int int3;
  arg = popSTACK();
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  begin_system_call();
  hrgn = CreateEllipticRgn(int0,int1,int2,int3);
  end_system_call();
  if(NULL ==hrgn){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hrgn);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEHALFTONEPALETTE, hdc)
{
  object arg;
  HPALETTE hpalette;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hpalette = CreateHalftonePalette(hdc);
  end_system_call();
  if(NULL ==hpalette){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hpalette);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEHATCHBRUSH, int0 colorref)
{
  object arg;
  HBRUSH hbrush;
  int int0;
  COLORREF colorref;
  arg = popSTACK();
  check_uint(arg);
  colorref = I_to_uint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  begin_system_call();
  hbrush = CreateHatchBrush(int0,colorref);
  end_system_call();
  if(NULL ==hbrush){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbrush);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEPATTERNBRUSH, hbitmap)
{
  object arg;
  HBRUSH hbrush;
  HBITMAP hbitmap;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbitmap = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hbrush = CreatePatternBrush(hbitmap);
  end_system_call();
  if(NULL ==hbrush){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbrush);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEPEN, int0 int1 colorref)
{
  object arg;
  HPEN hpen;
  int int0;
  int int1;
  COLORREF colorref;
  arg = popSTACK();
  check_uint(arg);
  colorref = I_to_uint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  begin_system_call();
  hpen = CreatePen(int0,int1,colorref);
  end_system_call();
  if(NULL ==hpen){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hpen);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATERECTRGN, int0 int1 int2 int3)
{
  object arg;
  HRGN hrgn;
  int int0;
  int int1;
  int int2;
  int int3;
  arg = popSTACK();
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  begin_system_call();
  hrgn = CreateRectRgn(int0,int1,int2,int3);
  end_system_call();
  if(NULL ==hrgn){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hrgn);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATESOLIDBRUSH, colorref)
{
  object arg;
  HBRUSH hbrush;
  COLORREF colorref;
  arg = popSTACK();
  check_uint(arg);
  colorref = I_to_uint32(arg);
  begin_system_call();
  hbrush = CreateSolidBrush(colorref);
  end_system_call();
  if(NULL ==hbrush){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbrush);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:DELETECOLORSPACE, hcolorspace)
{
  object arg;
  BOOL bool0;
  HCOLORSPACE hcolorspace;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hcolorspace = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = DeleteColorSpace(hcolorspace);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:DELETEDC, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = DeleteDC(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:DELETEENHMETAFILE, henhmetafile)
{
  object arg;
  BOOL bool0;
  HENHMETAFILE henhmetafile;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = DeleteEnhMetaFile(henhmetafile);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:DELETEMETAFILE, hmetafile)
{
  object arg;
  BOOL bool0;
  HMETAFILE hmetafile;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hmetafile = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = DeleteMetaFile(hmetafile);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:DELETEOBJECT, hgdiobj)
{
  object arg;
  BOOL bool0;
  HGDIOBJ hgdiobj;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hgdiobj = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = DeleteObject(hgdiobj);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ELLIPSE, hdc int0 int1 int2 int3)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  arg = popSTACK();
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = Ellipse(hdc,int0,int1,int2,int3);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENDDOC, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = EndDoc(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENDPAGE, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = EndPage(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENDPATH, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = EndPath(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:EQUALRGN, hrgn hrgn0)
{
  object arg;
  BOOL bool0;
  HRGN hrgn;
  HRGN hrgn0;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn0 = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = EqualRgn(hrgn,hrgn0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ESCAPECOMMFUNCTION, handle dword)
{
  object arg;
  BOOL bool0;
  HANDLE handle;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  handle = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = EscapeCommFunction(handle,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:EXCLUDECLIPRECT, hdc int0 int1 int2 int3)
{
  object arg;
  int int4;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  arg = popSTACK();
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int4 = ExcludeClipRect(hdc,int0,int1,int2,int3);
  end_system_call();
  if(0 <=int4){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int4);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:EXTFLOODFILL, hdc int0 int1 colorref uint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  COLORREF colorref;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  colorref = I_to_uint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = ExtFloodFill(hdc,int0,int1,colorref,uint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:EXTSELECTCLIPRGN, hdc hrgn int0)
{
  object arg;
  int int1;
  HDC hdc;
  HRGN hrgn;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = ExtSelectClipRgn(hdc,hrgn,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FILLPATH, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = FillPath(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FILLRGN, hdc hrgn hbrush)
{
  object arg;
  int int0;
  HDC hdc;
  HRGN hrgn;
  HBRUSH hbrush;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbrush = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = FillRgn(hdc,hrgn,hbrush);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FINDATOMA, lpcstr)
{
  object arg;
  ATOM atom;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  atom = FindAtomA(lpcstr);
  end_system_call();
  if(0 ==atom){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(atom);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FINDATOMW, lpcwstr)
{
  object arg;
  ATOM atom;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  atom = FindAtomW(lpcwstr);
  end_system_call();
  if(0 ==atom){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(atom);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FLATTENPATH, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = FlattenPath(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FLOODFILL, hdc int0 int1 colorref)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  COLORREF colorref;
  arg = popSTACK();
  check_uint(arg);
  colorref = I_to_uint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = FloodFill(hdc,int0,int1,colorref);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FRAMERGN, hdc hrgn hbrush int0 int1)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HRGN hrgn;
  HBRUSH hbrush;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbrush = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = FrameRgn(hdc,hrgn,hbrush,int0,int1);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GDISETBATCHLIMIT, dword)
{
  object arg;
  DWORD dword0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  begin_system_call();
  dword0 = GdiSetBatchLimit(dword);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETARCDIRECTION, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetArcDirection(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETBKCOLOR, hdc)
{
  object arg;
  COLORREF colorref;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  colorref = GetBkColor(hdc);
  end_system_call();
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETBKMODE, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetBkMode(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCLIPRGN, hdc hrgn)
{
  object arg;
  int int0;
  HDC hdc;
  HRGN hrgn;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetClipRgn(hdc,hrgn);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCOLORSPACE, hdc)
{
  object arg;
  HANDLE handle;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  handle = GetColorSpace(hdc);
  end_system_call();
  if(NULL ==handle){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(handle);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCURRENTOBJECT, hdc uint)
{
  object arg;
  HGDIOBJ hgdiobj;
  HDC hdc;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hgdiobj = GetCurrentObject(hdc,uint);
  end_system_call();
  if(NULL ==hgdiobj){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hgdiobj);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETFONTLANGUAGEINFO, hdc)
{
  object arg;
  DWORD dword;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  dword = GetFontLanguageInfo(hdc);
  end_system_call();
  if(0 <=dword){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETGRAPHICSMODE, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetGraphicsMode(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETMAPMODE, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetMapMode(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETMETARGN, hdc hrgn)
{
  object arg;
  int int0;
  HDC hdc;
  HRGN hrgn;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetMetaRgn(hdc,hrgn);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETNEARESTCOLOR, hdc colorref)
{
  object arg;
  COLORREF colorref0;
  HDC hdc;
  COLORREF colorref;
  arg = popSTACK();
  check_uint(arg);
  colorref = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  colorref0 = GetNearestColor(hdc,colorref);
  end_system_call();
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETNEARESTPALETTEINDEX, hpalette colorref)
{
  object arg;
  UINT uint;
  HPALETTE hpalette;
  COLORREF colorref;
  arg = popSTACK();
  check_uint(arg);
  colorref = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hpalette = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  uint = GetNearestPaletteIndex(hpalette,colorref);
  end_system_call();
  if(0 <=uint){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETOBJECTTYPE, hgdiobj)
{
  object arg;
  DWORD dword;
  HGDIOBJ hgdiobj;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hgdiobj = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  dword = GetObjectType(hgdiobj);
  end_system_call();
  if(0 <=dword){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETPIXEL, hdc int0 int1)
{
  object arg;
  COLORREF colorref;
  HDC hdc;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  colorref = GetPixel(hdc,int0,int1);
  end_system_call();
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETPIXELFORMAT, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetPixelFormat(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETPOLYFILLMODE, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetPolyFillMode(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETROP2, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetROP2(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETSTOCKOBJECT, int0)
{
  object arg;
  HGDIOBJ hgdiobj;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  begin_system_call();
  hgdiobj = GetStockObject(int0);
  end_system_call();
  if(NULL ==hgdiobj){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hgdiobj);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETSTRETCHBLTMODE, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetStretchBltMode(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETSYSTEMPALETTEUSE, hdc)
{
  object arg;
  UINT uint;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  uint = GetSystemPaletteUse(hdc);
  end_system_call();
  if(0 <=uint){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTALIGN, hdc)
{
  object arg;
  UINT uint;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  uint = GetTextAlign(hdc);
  end_system_call();
  if(0 <=uint){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTCHARACTEREXTRA, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetTextCharacterExtra(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTCHARSET, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = GetTextCharset(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTCOLOR, hdc)
{
  object arg;
  COLORREF colorref;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  colorref = GetTextColor(hdc);
  end_system_call();
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GLOBALADDATOMA, lpcstr)
{
  object arg;
  ATOM atom;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  atom = GlobalAddAtomA(lpcstr);
  end_system_call();
  if(0 ==atom){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(atom);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GLOBALADDATOMW, lpcwstr)
{
  object arg;
  ATOM atom;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  atom = GlobalAddAtomW(lpcwstr);
  end_system_call();
  if(0 ==atom){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(atom);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GLOBALFINDATOMA, lpcstr)
{
  object arg;
  ATOM atom;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  atom = GlobalFindAtomA(lpcstr);
  end_system_call();
  if(0 ==atom){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(atom);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GLOBALFINDATOMW, lpcwstr)
{
  object arg;
  ATOM atom;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  atom = GlobalFindAtomW(lpcwstr);
  end_system_call();
  if(0 ==atom){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(atom);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:INTERSECTCLIPRECT, hdc int0 int1 int2 int3)
{
  object arg;
  int int4;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  arg = popSTACK();
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int4 = IntersectClipRect(hdc,int0,int1,int2,int3);
  end_system_call();
  if(0 <=int4){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int4);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:INVERTRGN, hdc hrgn)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HRGN hrgn;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = InvertRgn(hdc,hrgn);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:LINETO, hdc int0 int1)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = LineTo(hdc,int0,int1);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:LOADCURSORFROMFILEA, lpcstr)
{
  object arg;
  HCURSOR hcursor;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  hcursor = LoadCursorFromFileA(lpcstr);
  end_system_call();
  if(NULL ==hcursor){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hcursor);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:LOADCURSORFROMFILEW, lpcwstr)
{
  object arg;
  HCURSOR hcursor;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  hcursor = LoadCursorFromFileW(lpcwstr);
  end_system_call();
  if(NULL ==hcursor){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hcursor);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:OFFSETCLIPRGN, hdc int0 int1)
{
  object arg;
  int int2;
  HDC hdc;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int2 = OffsetClipRgn(hdc,int0,int1);
  end_system_call();
  if(0 <=int2){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int2);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:OFFSETRGN, hrgn int0 int1)
{
  object arg;
  int int2;
  HRGN hrgn;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int2 = OffsetRgn(hrgn,int0,int1);
  end_system_call();
  if(0 <=int2){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int2);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PAINTRGN, hdc hrgn)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HRGN hrgn;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = PaintRgn(hdc,hrgn);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PATHTOREGION, hdc)
{
  object arg;
  HRGN hrgn;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hrgn = PathToRegion(hdc);
  end_system_call();
  if(NULL ==hrgn){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hrgn);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PLAYMETAFILE, hdc hmetafile)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HMETAFILE hmetafile;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hmetafile = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = PlayMetaFile(hdc,hmetafile);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PTINREGION, hrgn int0 int1)
{
  object arg;
  BOOL bool0;
  HRGN hrgn;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = PtInRegion(hrgn,int0,int1);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PTVISIBLE, hdc int0 int1)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = PtVisible(hdc,int0,int1);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:REALIZEPALETTE, hdc)
{
  object arg;
  UINT uint;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  uint = RealizePalette(hdc);
  end_system_call();
  if(0 <=uint){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:RECTANGLE, hdc int0 int1 int2 int3)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  arg = popSTACK();
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = Rectangle(hdc,int0,int1,int2,int3);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:RESIZEPALETTE, hpalette uint)
{
  object arg;
  BOOL bool0;
  HPALETTE hpalette;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hpalette = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = ResizePalette(hpalette,uint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:RESTOREDC, hdc int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = RestoreDC(hdc,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SAVEDC, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = SaveDC(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SELECTCLIPPATH, hdc int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SelectClipPath(hdc,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SELECTCLIPRGN, hdc hrgn)
{
  object arg;
  int int0;
  HDC hdc;
  HRGN hrgn;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = SelectClipRgn(hdc,hrgn);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SELECTOBJECT, hdc hgdiobj)
{
  object arg;
  HGDIOBJ hgdiobj0;
  HDC hdc;
  HGDIOBJ hgdiobj;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hgdiobj = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hgdiobj0 = SelectObject(hdc,hgdiobj);
  end_system_call();
  if(NULL ==hgdiobj0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hgdiobj0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETARCDIRECTION, hdc int0)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = SetArcDirection(hdc,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETBKCOLOR, hdc colorref)
{
  object arg;
  COLORREF colorref0;
  HDC hdc;
  COLORREF colorref;
  arg = popSTACK();
  check_uint(arg);
  colorref = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  colorref0 = SetBkColor(hdc,colorref);
  end_system_call();
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETBKMODE, hdc int0)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = SetBkMode(hdc,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETCOLORSPACE, hdc hcolorspace)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HCOLORSPACE hcolorspace;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hcolorspace = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SetColorSpace(hdc,hcolorspace);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETGRAPHICSMODE, hdc int0)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = SetGraphicsMode(hdc,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETICMMODE, hdc int0)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = SetICMMode(hdc,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETMAPMODE, hdc int0)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = SetMapMode(hdc,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETMAPPERFLAGS, hdc dword)
{
  object arg;
  DWORD dword0;
  HDC hdc;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  dword0 = SetMapperFlags(hdc,dword);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETMETARGN, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = SetMetaRgn(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETPOLYFILLMODE, hdc int0)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = SetPolyFillMode(hdc,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETROP2, hdc int0)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = SetROP2(hdc,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETRECTRGN, hrgn int0 int1 int2 int3)
{
  object arg;
  BOOL bool0;
  HRGN hrgn;
  int int0;
  int int1;
  int int2;
  int int3;
  arg = popSTACK();
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SetRectRgn(hrgn,int0,int1,int2,int3);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETSTRETCHBLTMODE, hdc int0)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = SetStretchBltMode(hdc,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETSYSTEMPALETTEUSE, hdc uint)
{
  object arg;
  UINT uint0;
  HDC hdc;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  uint0 = SetSystemPaletteUse(hdc,uint);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETTEXTALIGN, hdc uint)
{
  object arg;
  UINT uint0;
  HDC hdc;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  uint0 = SetTextAlign(hdc,uint);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETTEXTCHARACTEREXTRA, hdc int0)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = SetTextCharacterExtra(hdc,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETTEXTJUSTIFICATION, hdc int0 int1)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SetTextJustification(hdc,int0,int1);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SHOWWINDOW, hwnd int0)
{
  object arg;
  BOOL bool0;
  HWND hwnd;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hwnd = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = ShowWindow(hwnd,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SHOWWINDOWASYNC, hwnd int0)
{
  object arg;
  BOOL bool0;
  HWND hwnd;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hwnd = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = ShowWindowAsync(hwnd,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:STARTPAGE, hdc)
{
  object arg;
  int int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = StartPage(hdc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:STROKEANDFILLPATH, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = StrokeAndFillPath(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:STROKEPATH, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = StrokePath(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SWAPBUFFERS, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SwapBuffers(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:UNREALIZEOBJECT, hgdiobj)
{
  object arg;
  BOOL bool0;
  HGDIOBJ hgdiobj;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hgdiobj = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = UnrealizeObject(hgdiobj);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:UPDATECOLORS, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = UpdateColors(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:UPDATEWINDOW, hwnd)
{
  object arg;
  BOOL bool0;
  HWND hwnd;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hwnd = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = UpdateWindow(hwnd);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:WIDENPATH, hdc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = WidenPath(hdc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
#line 1 "funcs.c"
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ANGLEARC,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  DWORD dword;
  FLOAT float0;
  FLOAT float1;
  arg = BEFORE(args_end_pointer);
  check_ffloat(arg);
  float1 = ffloat_value(arg);
  arg = BEFORE(args_end_pointer);
  check_ffloat(arg);
  float0 = ffloat_value(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = AngleArc(hdc,int0,int1,dword,float0,float1);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ARC,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  int int4;
  int int5;
  int int6;
  int int7;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int7 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int6 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = Arc(hdc,int0,int1,int2,int3,int4,int5,int6,int7);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ARCTO,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  int int4;
  int int5;
  int int6;
  int int7;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int7 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int6 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = ArcTo(hdc,int0,int1,int2,int3,int4,int5,int6,int7);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:BITBLT,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  HDC hdc0;
  int int4;
  int int5;
  DWORD dword;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc0 = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = BitBlt(hdc,int0,int1,int2,int3,hdc0,int4,int5,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CHORD,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  int int4;
  int int5;
  int int6;
  int int7;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int7 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int6 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = Chord(hdc,int0,int1,int2,int3,int4,int5,int6,int7);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEDIBITMAP,&rest r)
{
  object arg;
  HBITMAP hbitmap;
  HDC hdc;
  BITMAPINFOHEADER* bitmapinfoheader_p = alloca(sizeof(BITMAPINFOHEADER));
  object arg0;
  DWORD dword;
  void* pcvoid;
  BITMAPINFO* bitmapinfo_p = alloca(sizeof(BITMAPINFO));
  UINT uint;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processBITMAPINFO(bitmapinfo_p,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pcvoid = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processBITMAPINFOHEADER(bitmapinfoheader_p,arg0);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processBITMAPINFOHEADER(bitmapinfoheader_p,arg0);
  processBITMAPINFO(bitmapinfo_p,arg0);
  begin_system_call();
  hbitmap = CreateDIBitmap(hdc,bitmapinfoheader_p,dword,pcvoid,bitmapinfo_p,uint);
  end_system_call();
  if(NULL ==hbitmap){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbitmap);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEFONTA,&rest r)
{
  object arg;
  HFONT hfont;
  int int0;
  int int1;
  int int2;
  int int3;
  int int4;
  DWORD dword;
  DWORD dword0;
  DWORD dword1;
  DWORD dword2;
  DWORD dword3;
  DWORD dword4;
  DWORD dword5;
  DWORD dword6;
  LPCSTR lpcstr;
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword6 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword5 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword4 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword3 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword2 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword1 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  begin_system_call();
  hfont = CreateFontA(int0,int1,int2,int3,int4,dword,dword0,dword1,dword2,dword3,dword4,dword5,dword6,lpcstr);
  end_system_call();
  if(NULL ==hfont){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hfont);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEFONTW,&rest r)
{
  object arg;
  HFONT hfont;
  int int0;
  int int1;
  int int2;
  int int3;
  int int4;
  DWORD dword;
  DWORD dword0;
  DWORD dword1;
  DWORD dword2;
  DWORD dword3;
  DWORD dword4;
  DWORD dword5;
  DWORD dword6;
  LPCWSTR lpcwstr;
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword6 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword5 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword4 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword3 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword2 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword1 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  begin_system_call();
  hfont = CreateFontW(int0,int1,int2,int3,int4,dword,dword0,dword1,dword2,dword3,dword4,dword5,dword6,lpcwstr);
  end_system_call();
  if(NULL ==hfont){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hfont);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEICON,&rest r)
{
  object arg;
  object arg0;
  HICON hicon;
  HINSTANCE hinstance;
  int int0;
  int int1;
  BYTE byte;
  BYTE byte0;
  PBYTE pbyte;
  PBYTE pbyte0;
  arg0 = BEFORE(args_end_pointer);
  processPBYTE(pbyte0,arg0);
  arg0 = BEFORE(args_end_pointer);
  processPBYTE(pbyte,arg0);
  arg0 = BEFORE(args_end_pointer);
  processBYTE(byte0,arg0);
  arg0 = BEFORE(args_end_pointer);
  processBYTE(byte,arg0);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hinstance = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hicon = CreateIcon(hinstance,int0,int1,byte,byte0,pbyte,pbyte0);
  end_system_call();
  if(NULL ==hicon){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hicon);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEICONFROMRESOURCEEX,&rest r)
{
  object arg;
  object arg0;
  HICON hicon;
  PBYTE pbyte;
  DWORD dword;
  BOOL bool0;
  DWORD dword0;
  int int0;
  int int1;
  UINT uint;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processBOOL(bool0,arg0);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processPBYTE(pbyte,arg0);
  begin_system_call();
  hicon = CreateIconFromResourceEx(pbyte,dword,bool0,dword0,int0,int1,uint);
  end_system_call();
  if(NULL ==hicon){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hicon);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEROUNDRECTRGN,&rest r)
{
  object arg;
  HRGN hrgn;
  int int0;
  int int1;
  int int2;
  int int3;
  int int4;
  int int5;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  begin_system_call();
  hrgn = CreateRoundRectRgn(int0,int1,int2,int3,int4,int5);
  end_system_call();
  if(NULL ==hrgn){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hrgn);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEWINDOWEXA,&rest r)
{
  object arg;
  HWND hwnd0;
  DWORD dword;
  LPCSTR lpcstr;
  LPCSTR lpcstr0;
  DWORD dword0;
  int int0;
  int int1;
  int int2;
  int int3;
  HWND hwnd;
  HMENU hmenu;
  HINSTANCE hinstance;
  void* lpvoid = alloca(sizeof(long));
  object arg0;
  arg0 = BEFORE(args_end_pointer);
  arg = BEFORE(args_end_pointer);
  processvoid(lpvoid,arg0);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hinstance = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hmenu = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hwnd = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr0 = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  begin_system_call();
  hwnd0 = CreateWindowExA(dword,lpcstr,lpcstr0,dword0,int0,int1,int2,int3,hwnd,hmenu,hinstance,lpvoid);
  end_system_call();
  if(NULL ==hwnd0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hwnd0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEWINDOWEXW,&rest r)
{
  object arg;
  HWND hwnd0;
  DWORD dword;
  LPCWSTR lpcwstr;
  LPCWSTR lpcwstr0;
  DWORD dword0;
  int int0;
  int int1;
  int int2;
  int int3;
  HWND hwnd;
  HMENU hmenu;
  HINSTANCE hinstance;
  void* lpvoid = alloca(sizeof(long));
  object arg0;
  arg0 = BEFORE(args_end_pointer);
  processvoid(lpvoid,arg0);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hinstance = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hmenu = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hwnd = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr0 = 0; //(WIDECHAR(arg,encoding));
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = 0; //(WIDECHAR(arg,encoding));
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  processvoid(lpvoid,arg0);
  begin_system_call();
  hwnd0 = CreateWindowExW(dword,lpcwstr,lpcwstr0,dword0,int0,int1,int2,int3,hwnd,hmenu,hinstance,lpvoid);
  end_system_call();
  if(NULL ==hwnd0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hwnd0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:EXTESCAPE,&rest r)
{
  object arg;
  int int3;
  HDC hdc;
  int int0;
  int int1;
  LPCSTR lpcstr;
  int int2;
  LPSTR lpstr;
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int3 = ExtEscape(hdc,int0,int1,lpcstr,int2,lpstr);
  end_system_call();
  if(0 <=int3){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int3);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:EXTTEXTOUTA,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  UINT uint;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  LPCSTR lpcstr;
  UINT uint0;
  PINT pint;
  arg0 = BEFORE(args_end_pointer);
  processPINT(pint,arg0);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg0 = BEFORE(args_end_pointer);
  processRECT(lpcrect,arg0);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lpcrect,arg0);
  begin_system_call();
  bool0 = ExtTextOutA(hdc,int0,int1,uint,lpcrect,lpcstr,uint0,pint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:EXTTEXTOUTW,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  UINT uint;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  LPCWSTR lpcwstr;
  UINT uint0;
  PINT pint;
  arg0 = BEFORE(args_end_pointer);
  processPINT(pint,arg0);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg0 = BEFORE(args_end_pointer);
  processRECT(lpcrect,arg0);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lpcrect,arg0);
  begin_system_call();
  bool0 = ExtTextOutW(hdc,int0,int1,uint,lpcrect,lpcwstr,uint0,pint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FINDFIRSTFILEEXA,&rest r)
{
  object arg;
  object arg0;
  HANDLE handle;
  LPCSTR lpcstr;
  FINDEX_INFO_LEVELS findex_info_levels;
  void* pvoid;
  FINDEX_SEARCH_OPS findex_search_ops;
  void* pvoid0;
  DWORD dword;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid0 = &(TheSbvector(arg)->data);
  arg0 = BEFORE(args_end_pointer);
  processFINDEX_SEARCH_OPS(&findex_search_ops,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg0 = BEFORE(args_end_pointer);
  processFINDEX_INFO_LEVELS(&findex_info_levels,arg0);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  handle = FindFirstFileExA(lpcstr,findex_info_levels,pvoid,findex_search_ops,pvoid0,dword);
  end_system_call();
  if(NULL ==handle){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(handle);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FINDFIRSTFILEEXW,&rest r)
{
  object arg;
  object arg0;
  HANDLE handle;
  LPCWSTR lpcwstr;
  FINDEX_INFO_LEVELS findex_info_levels;
  void* pvoid;
  FINDEX_SEARCH_OPS findex_search_ops;
  void* pvoid0;
  DWORD dword;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid0 = &(TheSbvector(arg)->data);
  arg0 = BEFORE(args_end_pointer);
  processFINDEX_SEARCH_OPS(&findex_search_ops,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg0 = BEFORE(args_end_pointer);
  processFINDEX_INFO_LEVELS(&findex_info_levels,arg0);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  handle = FindFirstFileExW(lpcwstr,findex_info_levels,pvoid,findex_search_ops,pvoid0,dword);
  end_system_call();
  if(NULL ==handle){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(handle);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARACTERPLACEMENTA,&rest r)
{
  object arg;
  DWORD dword0;
  HDC hdc;
  LPCSTR lpcstr;
  int int0;
  int int1;
  GCP_RESULTSA* lpgcp_resultsa = alloca(sizeof(GCP_RESULTSA));
  object arg0;
  DWORD dword;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processGCP_RESULTSA(lpgcp_resultsa,arg0);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processGCP_RESULTSA(lpgcp_resultsa,arg0);
  begin_system_call();
  dword0 = GetCharacterPlacementA(hdc,lpcstr,int0,int1,lpgcp_resultsa,dword);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARACTERPLACEMENTW,&rest r)
{
  object arg;
  DWORD dword0;
  HDC hdc;
  LPCWSTR lpcwstr;
  int int0;
  int int1;
  GCP_RESULTSW* lpgcp_resultsw = alloca(sizeof(GCP_RESULTSW));
  object arg0;
  DWORD dword;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processGCP_RESULTSW(lpgcp_resultsw,arg0);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processGCP_RESULTSW(lpgcp_resultsw,arg0);
  begin_system_call();
  dword0 = GetCharacterPlacementW(hdc,lpcwstr,int0,int1,lpgcp_resultsw,dword);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETDIBITS,&rest r)
{
  object arg;
  int int0;
  HDC hdc;
  HBITMAP hbitmap;
  UINT uint;
  UINT uint0;
  void* pvoid;
  BITMAPINFO* lpbitmapinfo = alloca(sizeof(BITMAPINFO));
  object arg0;
  UINT uint1;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint1 = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processBITMAPINFO(lpbitmapinfo,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbitmap = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processBITMAPINFO(lpbitmapinfo,arg0);
  begin_system_call();
  int0 = GetDIBits(hdc,hbitmap,uint,uint0,pvoid,lpbitmapinfo,uint1);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETGLYPHOUTLINEA,&rest r)
{
  object arg;
  DWORD dword0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  GLYPHMETRICS* lpglyphmetrics = alloca(sizeof(GLYPHMETRICS));
  object arg0;
  DWORD dword;
  void* pvoid;
  MAT2 pmat2;
  arg0 = BEFORE(args_end_pointer);
  processMAT2(&pmat2,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processGLYPHMETRICS(lpglyphmetrics,arg0);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processGLYPHMETRICS(lpglyphmetrics,arg0);
  begin_system_call();
  dword0 = GetGlyphOutlineA(hdc,uint,uint0,lpglyphmetrics,dword,pvoid,&pmat2);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETGLYPHOUTLINEW,&rest r)
{
  object arg;
  DWORD dword0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  GLYPHMETRICS* lpglyphmetrics = alloca(sizeof(GLYPHMETRICS));
  object arg0;
  DWORD dword;
  void* pvoid;
  MAT2 pmat2;
  arg0 = BEFORE(args_end_pointer);
  processMAT2(&pmat2,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processGLYPHMETRICS(lpglyphmetrics,arg0);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processGLYPHMETRICS(lpglyphmetrics,arg0);
  begin_system_call();
  dword0 = GetGlyphOutlineW(hdc,uint,uint0,lpglyphmetrics,dword,pvoid,&pmat2);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTEXTENTEXPOINTA,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  LPCSTR lpcstr;
  int int0;
  int int1;
  int* lpint;
  int* lpint0;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = BEFORE(args_end_pointer);
  processSIZE(lpsize,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  lpint0 = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  lpint = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = GetTextExtentExPointA(hdc,lpcstr,int0,int1,lpint,lpint0,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTEXTENTEXPOINTW,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  LPCWSTR lpcwstr;
  int int0;
  int int1;
  int* lpint;
  int* lpint0;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = BEFORE(args_end_pointer);
  processSIZE(lpsize,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  lpint0 = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  lpint = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = GetTextExtentExPointW(hdc,lpcwstr,int0,int1,lpint,lpint0,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:MASKBLT,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  HDC hdc0;
  int int4;
  int int5;
  HBITMAP hbitmap;
  int int6;
  int int7;
  DWORD dword;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int7 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int6 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbitmap = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc0 = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = MaskBlt(hdc,int0,int1,int2,int3,hdc0,int4,int5,hbitmap,int6,int7,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PATBLT,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  DWORD dword;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = PatBlt(hdc,int0,int1,int2,int3,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PIE,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  int int4;
  int int5;
  int int6;
  int int7;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int7 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int6 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = Pie(hdc,int0,int1,int2,int3,int4,int5,int6,int7);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PLGBLT,&rest r)
{
  object arg;
  object arg0;
  BOOL bool0;
  HDC hdc;
  PPOINT ppoint;
  HDC hdc0;
  int int0;
  int int1;
  int int2;
  int int3;
  HBITMAP hbitmap;
  int int4;
  int int5;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbitmap = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc0 = TheFpointer(arg)->fp_pointer;
  arg0 = BEFORE(args_end_pointer);
  processPPOINT(ppoint,arg0);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = PlgBlt(hdc,ppoint,hdc0,int0,int1,int2,int3,hbitmap,int4,int5);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ROUNDRECT,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  int int4;
  int int5;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = RoundRect(hdc,int0,int1,int2,int3,int4,int5);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SCALEVIEWPORTEXTEX,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = BEFORE(args_end_pointer);
  processSIZE(lpsize,arg0);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = ScaleViewportExtEx(hdc,int0,int1,int2,int3,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SCALEWINDOWEXTEX,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = BEFORE(args_end_pointer);
  processSIZE(lpsize,arg0);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = ScaleWindowExtEx(hdc,int0,int1,int2,int3,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETDIBITS,&rest r)
{
  object arg;
  object arg0;
  int int0;
  HDC hdc;
  HBITMAP hbitmap;
  UINT uint;
  UINT uint0;
  void* pcvoid;
  PBITMAPINFO pbitmapinfo;
  UINT uint1;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint1 = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processPBITMAPINFO(pbitmapinfo,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pcvoid = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbitmap = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = SetDIBits(hdc,hbitmap,uint,uint0,pcvoid,pbitmapinfo,uint1);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETDIBITSTODEVICE,&rest r)
{
  object arg;
  object arg0;
  int int4;
  HDC hdc;
  int int0;
  int int1;
  DWORD dword;
  DWORD dword0;
  int int2;
  int int3;
  UINT uint;
  UINT uint0;
  void* pcvoid;
  PBITMAPINFO pbitmapinfo;
  UINT uint1;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint1 = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processPBITMAPINFO(pbitmapinfo,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pcvoid = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int4 = SetDIBitsToDevice(hdc,int0,int1,dword,dword0,int2,int3,uint,uint0,pcvoid,pbitmapinfo,uint1);
  end_system_call();
  if(0 <=int4){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int4);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:STRETCHBLT,&rest r)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  HDC hdc0;
  int int4;
  int int5;
  int int6;
  int int7;
  DWORD dword;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int7 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int6 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc0 = TheFpointer(arg)->fp_pointer;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = StretchBlt(hdc,int0,int1,int2,int3,hdc0,int4,int5,int6,int7,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:STRETCHDIBITS,&rest r)
{
  object arg;
  object arg0;
  int int8;
  HDC hdc;
  int int0;
  int int1;
  int int2;
  int int3;
  int int4;
  int int5;
  int int6;
  int int7;
  void* pvoid;
  PBITMAPINFO pbitmapinfo;
  UINT uint;
  DWORD dword;
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg0 = BEFORE(args_end_pointer);
  processPBITMAPINFO(pbitmapinfo,arg0);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int7 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int6 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int5 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int8 = StretchDIBits(hdc,int0,int1,int2,int3,int4,int5,int6,int7,pvoid,pbitmapinfo,uint,dword);
  end_system_call();
  if(0 <=int8){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int8);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:TABBEDTEXTOUTA,&rest r)
{
  object arg;
  LONG long0;
  HDC hdc;
  int int0;
  int int1;
  LPCSTR lpcstr;
  int int2;
  int int3;
  int* lpint;
  int int4;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  lpint = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  long0 = TabbedTextOutA(hdc,int0,int1,lpcstr,int2,int3,lpint,int4);
  end_system_call();
  if(0 <=long0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(long0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:TABBEDTEXTOUTW,&rest r)
{
  object arg;
  LONG long0;
  HDC hdc;
  int int0;
  int int1;
  LPCWSTR lpcwstr;
  int int2;
  int int3;
  int* lpint;
  int int4;
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int4 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  lpint = &(TheSbvector(arg)->data);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int3 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  long0 = TabbedTextOutW(hdc,int0,int1,lpcwstr,int2,int3,lpint,int4);
  end_system_call();
  if(0 <=long0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(long0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SEARCHPATHA,&rest r)
{
  object arg;
  DWORD dword0;
  LPCSTR lpcstr;
  LPCSTR lpcstr0;
  LPCSTR lpcstr1;
  DWORD dword;
  LPSTR lpstr;
  LPSTR* lpstr_p = alloca(sizeof(LPSTR));
  object arg0;
  arg0 = BEFORE(args_end_pointer);
  processSTR_P(lpstr_p,arg0);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr1 = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr0 = TheAsciz(string_to_asciz(arg,encoding));
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  processLPSTR(lpstr_p,arg0);
  begin_system_call();
  dword0 = SearchPathA(lpcstr,lpcstr0,lpcstr1,dword,lpstr,lpstr_p);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SEARCHPATHW,&rest r)
{
  object arg;
  DWORD dword0;
  LPCWSTR lpcwstr;
  LPCWSTR lpcwstr0;
  LPCWSTR lpcwstr1;
  DWORD dword;
  LPWSTR lpwstr;
  LPWSTR* lpwstr_p = alloca(sizeof(LPWSTR));
  object arg0;
  arg0 = BEFORE(args_end_pointer);
  processWSTR_P(lpwstr_p,arg0);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpwstr = 0; //WIDECHAR(arg,encoding);
  arg = BEFORE(args_end_pointer);
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr1 = 0; //WIDECHAR(arg,encoding);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr0 = 0; //WIDECHAR(arg,encoding);
  arg = BEFORE(args_end_pointer);
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = 0; //WIDECHAR(arg,encoding);
  processLPWSTR(lpwstr_p,arg0);
  begin_system_call();
  dword0 = SearchPathW(lpcwstr,lpcwstr0,lpcwstr1,dword,lpwstr,lpwstr_p);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
#line 1 "funcs.c"
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ADDFONTRESOURCEA, lpcstr)
{
  object arg;
  int int0;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  int0 = AddFontResourceA(lpcstr);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ADDFONTRESOURCEW, lpcwstr)
{
  object arg;
  int int0;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  int0 = AddFontResourceW(lpcwstr);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:COPYENHMETAFILEA, henhmetafile lpcstr)
{
  object arg;
  HENHMETAFILE henhmetafile0;
  HENHMETAFILE henhmetafile;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  henhmetafile0 = CopyEnhMetaFileA(henhmetafile,lpcstr);
  end_system_call();
  if(NULL ==henhmetafile0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(henhmetafile0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:COPYENHMETAFILEW, henhmetafile lpcwstr)
{
  object arg;
  HENHMETAFILE henhmetafile0;
  HENHMETAFILE henhmetafile;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = 0; //WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  henhmetafile0 = CopyEnhMetaFileW(henhmetafile,lpcwstr);
  end_system_call();
  if(NULL ==henhmetafile0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(henhmetafile0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:COPYMETAFILEA, hmetafile lpcstr)
{
  object arg;
  HMETAFILE hmetafile0;
  HMETAFILE hmetafile;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hmetafile = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hmetafile0 = CopyMetaFileA(hmetafile,lpcstr);
  end_system_call();
  if(NULL ==hmetafile0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hmetafile0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:COPYMETAFILEW, hmetafile lpcwstr)
{
  object arg;
  HMETAFILE hmetafile0;
  HMETAFILE hmetafile;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hmetafile = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hmetafile0 = CopyMetaFileW(hmetafile,lpcwstr);
  end_system_call();
  if(NULL ==hmetafile0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hmetafile0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEBITMAPINDIRECT, bitmap_p)
{
  object arg;
  HBITMAP hbitmap;
  BITMAP* bitmap_p = alloca(sizeof(BITMAP));
  object arg0;
  arg0 = popSTACK();
  processBITMAP(bitmap_p,arg0);
  processBITMAP(bitmap_p,arg0);
  begin_system_call();
  hbitmap = CreateBitmapIndirect(bitmap_p);
  end_system_call();
  if(NULL ==hbitmap){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbitmap);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEBRUSHINDIRECT, logbrush_p)
{
  object arg;
  HBRUSH hbrush;
  LOGBRUSH* logbrush_p = alloca(sizeof(LOGBRUSH));
  object arg0;
  arg0 = popSTACK();
  processLOGBRUSH(logbrush_p,arg0);
  processLOGBRUSH(logbrush_p,arg0);
  begin_system_call();
  hbrush = CreateBrushIndirect(logbrush_p);
  end_system_call();
  if(NULL ==hbrush){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbrush);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATECOLORSPACEA, lplogcolorspacea)
{
  object arg;
  HCOLORSPACE hcolorspace;
  LOGCOLORSPACEA* lplogcolorspacea = alloca(sizeof(LOGCOLORSPACEA));
  object arg0;
  arg0 = popSTACK();
  processLOGCOLORSPACEA(lplogcolorspacea,arg0);
  processLOGCOLORSPACEA(lplogcolorspacea,arg0);
  begin_system_call();
  hcolorspace = CreateColorSpaceA(lplogcolorspacea);
  end_system_call();
  if(NULL ==hcolorspace){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hcolorspace);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATECOLORSPACEW, lplogcolorspacew)
{
  object arg;
  HCOLORSPACE hcolorspace;
  LOGCOLORSPACEW* lplogcolorspacew = alloca(sizeof(LOGCOLORSPACEW));
  object arg0;
  arg0 = popSTACK();
  processLOGCOLORSPACEW(lplogcolorspacew,arg0);
  processLOGCOLORSPACEW(lplogcolorspacew,arg0);
  begin_system_call();
  hcolorspace = CreateColorSpaceW(lplogcolorspacew);
  end_system_call();
  if(NULL ==hcolorspace){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hcolorspace);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEDCA, lpcstr lpcstr0 lpcstr1 devmodea_p)
{
  object arg;
  HDC hdc;
  LPCSTR lpcstr;
  LPCSTR lpcstr0;
  LPCSTR lpcstr1;
  DEVMODEA* devmodea_p = alloca(sizeof(DEVMODEA));
  object arg0;
  arg0 = popSTACK();
  processDEVMODEA(devmodea_p,arg0);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr1 = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr0 = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  processDEVMODEA(devmodea_p,arg0);
  begin_system_call();
  hdc = CreateDCA(lpcstr,lpcstr0,lpcstr1,devmodea_p);
  end_system_call();
  if(NULL ==hdc){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEDCW, lpcwstr lpcwstr0 lpcwstr1 devmodew_p)
{
  object arg;
  HDC hdc;
  LPCWSTR lpcwstr;
  LPCWSTR lpcwstr0;
  LPCWSTR lpcwstr1;
  DEVMODEW* devmodew_p = alloca(sizeof(DEVMODEW));
  object arg0;
  arg0 = popSTACK();
  processDEVMODEW(devmodew_p,arg0);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr1 = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr0 = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  processDEVMODEW(devmodew_p,arg0);
  begin_system_call();
  hdc = CreateDCW(lpcwstr,lpcwstr0,lpcwstr1,devmodew_p);
  end_system_call();
  if(NULL ==hdc){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEELLIPTICRGNINDIRECT, lpcrect)
{
  object arg;
  HRGN hrgn;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  arg0 = popSTACK();
  processRECT(lpcrect,arg0);
  begin_system_call();
  hrgn = CreateEllipticRgnIndirect(lpcrect);
  end_system_call();
  if(NULL ==hrgn){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hrgn);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEENHMETAFILEA, hdc lpcstr lpcrect lpcstr0)
{
  object arg;
  HDC hdc0;
  HDC hdc;
  LPCSTR lpcstr;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  LPCSTR lpcstr0;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr0 = TheAsciz(string_to_asciz(arg,encoding));
  arg0 = popSTACK();
  processRECT(lpcrect,arg0);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lpcrect,arg0);
  begin_system_call();
  hdc0 = CreateEnhMetaFileA(hdc,lpcstr,lpcrect,lpcstr0);
  end_system_call();
  if(NULL ==hdc0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEENHMETAFILEW, hdc lpcwstr lpcrect lpcwstr0)
{
  object arg;
  HDC hdc0;
  HDC hdc;
  LPCWSTR lpcwstr;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  LPCWSTR lpcwstr0;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr0 = WIDECHAR(arg,encoding);
  arg0 = popSTACK();
  processRECT(lpcrect,arg0);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lpcrect,arg0);
  begin_system_call();
  hdc0 = CreateEnhMetaFileW(hdc,lpcwstr,lpcrect,lpcwstr0);
  end_system_call();
  if(NULL ==hdc0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEFONTINDIRECTA, logfonta_p)
{
  object arg;
  HFONT hfont;
  LOGFONTA* logfonta_p = alloca(sizeof(LOGFONTA));
  object arg0;
  arg0 = popSTACK();
  processLOGFONTA(logfonta_p,arg0);
  begin_system_call();
  hfont = CreateFontIndirectA(logfonta_p);
  end_system_call();
  if(NULL ==hfont){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hfont);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEFONTINDIRECTW, logfontw_p)
{
  object arg;
  HFONT hfont;
  LOGFONTW* logfontw_p = alloca(sizeof(LOGFONTW));
  object arg0;
  arg0 = popSTACK();
  processLOGFONTW(logfontw_p,arg0);
  processLOGFONTW(logfontw_p,arg0);
  begin_system_call();
  hfont = CreateFontIndirectW(logfontw_p);
  end_system_call();
  if(NULL ==hfont){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hfont);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEICA, lpcstr lpcstr0 lpcstr1 devmodea_p)
{
  object arg;
  HDC hdc;
  LPCSTR lpcstr;
  LPCSTR lpcstr0;
  LPCSTR lpcstr1;
  DEVMODEA* devmodea_p = alloca(sizeof(DEVMODEA));
  object arg0;
  arg0 = popSTACK();
  processDEVMODEA(devmodea_p,arg0);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr1 = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr0 = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  processDEVMODEA(devmodea_p,arg0);
  begin_system_call();
  hdc = CreateICA(lpcstr,lpcstr0,lpcstr1,devmodea_p);
  end_system_call();
  if(NULL ==hdc){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEICW, lpcwstr lpcwstr0 lpcwstr1 devmodew_p)
{
  object arg;
  HDC hdc;
  LPCWSTR lpcwstr;
  LPCWSTR lpcwstr0;
  LPCWSTR lpcwstr1;
  DEVMODEW* devmodew_p = alloca(sizeof(DEVMODEW));
  object arg0;
  arg0 = popSTACK();
  processDEVMODEW(devmodew_p,arg0);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr1 = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr0 = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  processDEVMODEW(devmodew_p,arg0);
  begin_system_call();
  hdc = CreateICW(lpcwstr,lpcwstr0,lpcwstr1,devmodew_p);
  end_system_call();
  if(NULL ==hdc){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEICONFROMRESOURCE, pbyte dword bool0 dword0)
{
  object arg;
  object arg0;
  HICON hicon;
  PBYTE pbyte;
  DWORD dword;
  BOOL bool0;
  DWORD dword0;
  arg = popSTACK();
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg0 = popSTACK();
  processBOOL(bool0,arg0);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = popSTACK();
  processPBYTE(pbyte,arg0);
  begin_system_call();
  hicon = CreateIconFromResource(pbyte,dword,bool0,dword0);
  end_system_call();
  if(NULL ==hicon){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hicon);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEICONINDIRECT, piconinfo)
{
  object arg;
  HICON hicon;
  ICONINFO iconinfo;
  arg = popSTACK();
  processICONINFO(&iconinfo,arg);
  begin_system_call();
  hicon = CreateIconIndirect(&iconinfo);
  end_system_call();
  if(NULL ==hicon){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hicon);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEMETAFILEA, lpcstr)
{
  object arg;
  HDC hdc;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  hdc = CreateMetaFileA(lpcstr);
  end_system_call();
  if(NULL ==hdc){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEMETAFILEW, lpcwstr)
{
  object arg;
  HDC hdc;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  hdc = CreateMetaFileW(lpcwstr);
  end_system_call();
  if(NULL ==hdc){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEPALETTE, logpalette_p)
{
  object arg;
  HPALETTE hpalette;
  LOGPALETTE* logpalette_p = alloca(sizeof(LOGPALETTE));
  object arg0;
  arg0 = popSTACK();
  processLOGPALETTE(logpalette_p,arg0);
  processLOGPALETTE(logpalette_p,arg0);
  begin_system_call();
  hpalette = CreatePalette(logpalette_p);
  end_system_call();
  if(NULL ==hpalette){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hpalette);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEPENINDIRECT, logpen_p)
{
  object arg;
  HPEN hpen;
  LOGPEN* logpen_p = alloca(sizeof(LOGPEN));
  object arg0;
  arg0 = popSTACK();
  processLOGPEN(logpen_p,arg0);
  processLOGPEN(logpen_p,arg0);
  begin_system_call();
  hpen = CreatePenIndirect(logpen_p);
  end_system_call();
  if(NULL ==hpen){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hpen);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATERECTRGNINDIRECT, lpcrect)
{
  object arg;
  HRGN hrgn;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  arg0 = popSTACK();
  processRECT(lpcrect,arg0);
  processRECT(lpcrect,arg0);
  begin_system_call();
  hrgn = CreateRectRgnIndirect(lpcrect);
  end_system_call();
  if(NULL ==hrgn){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hrgn);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEWINDOWINDIRECTA, cs)
{
  object arg;
  HWND hwnd;
  CREATESTRUCT* p = alloca(sizeof(CREATESTRUCT));
  object arg0;
//asm("int3");
  arg0 = popSTACK();
  processCREATESTRUCTA(p,arg0);
  begin_system_call();
  hwnd = CreateWindowEx(p->dwExStyle, p->lpszClass, p->lpszName, p->style,
    p->x, p->y, p->cx, p->cy, p->hwndParent, p->hMenu, p->hInstance,
    p->lpCreateParams);
  end_system_call();
  if(NULL ==hwnd){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hwnd);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FILLRECT, hdc lpcrect hbrush)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  HBRUSH hbrush;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbrush = TheFpointer(arg)->fp_pointer;
  arg0 = popSTACK();
  processRECT(lpcrect,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lpcrect,arg0);
  begin_system_call();
  bool0 = FillRect(hdc,lpcrect,hbrush);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN(GDI:GETDC, dc)
{
  object arg = popSTACK();
  DWORD e = 0;
  HWND h = (nullp(arg))?0:(TheFpointer(arg)->fp_pointer);
  begin_system_call();
  h = GetDC(h);
  end_system_call();
  if(NULL == h){
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(h);
    mv_count=2;
  }
  return;
}
// Nothing in the docs indicates that this function can return a error code,
// so to be consistant, I will return T and the result.
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETDEVICECAPS, hdc int0)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = GetDeviceCaps(hdc,int0);
  end_system_call();
  if(0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETSYSTEMMETRICS, int0)
{
  object arg;
  int int1;
  int int0;
  arg = popSTACK();
  int0 = I_to_sint32(arg);
  begin_system_call();
  int1 = GetSystemMetrics(int0);
  end_system_call();
  value1 = sint32_to_I(int1);
  mv_count=1;
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:LOADCURSORA, hinstance lpcstr)
{
  object arg;
  HCURSOR hcursor;
  HINSTANCE hinstance;
  void* lpcstr;
  arg = popSTACK();

  if(stringp(arg))
  {
     lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  }
  else if(fpointerp(arg))
  {
     lpcstr = TheFpointer(arg)->fp_pointer;
  }
  else argumentum_inritum(arg);
  arg = popSTACK();
  if(nullp(arg))
  {
     hinstance = NULL;
  }
  else if(fpointerp(arg))
  {
     hinstance = TheFpointer(arg)->fp_pointer;
  }
  else argumentum_inritum(arg);
  begin_system_call();
  hcursor = LoadCursorA(hinstance,lpcstr);
  end_system_call();
  if(NULL ==hcursor){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hcursor);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:LOADCURSORW, hinstance lpcwstr)
{
  object arg;
  HCURSOR hcursor;
  HINSTANCE hinstance;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hinstance = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hcursor = LoadCursorW(hinstance,lpcwstr);
  end_system_call();
  if(NULL ==hcursor){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hcursor);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PLAYENHMETAFILE, hdc henhmetafile lpcrect)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HENHMETAFILE henhmetafile;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  arg0 = popSTACK();
  processRECT(lpcrect,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lpcrect,arg0);
  begin_system_call();
  bool0 = PlayEnhMetaFile(hdc,henhmetafile,lpcrect);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:RECTINREGION, hrgn lpcrect)
{
  object arg;
  BOOL bool0;
  HRGN hrgn;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  arg0 = popSTACK();
  processRECT(lpcrect,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  processRECT(lpcrect,arg0);
  begin_system_call();
  bool0 = RectInRegion(hrgn,lpcrect);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:RECTVISIBLE, hdc lpcrect)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  arg0 = popSTACK();
  processRECT(lpcrect,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lpcrect,arg0);
  begin_system_call();
  bool0 = RectVisible(hdc,lpcrect);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:REGISTERCLASSA, wndclassa_p)
{
  object arg;
  ATOM atom;
  WNDCLASSA* wndclassa_p = alloca(sizeof(WNDCLASSA));
  object arg0;
  arg0 = popSTACK();
//asm("int3");
  processWNDCLASSA(wndclassa_p,arg0);
  begin_system_call();
  atom = RegisterClassA(wndclassa_p);
  end_system_call();
  if(0 ==atom){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(atom);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:REGISTERCLASSW, wndclassw_p)
{
  object arg;
  ATOM atom;
  WNDCLASSW* wndclassw_p = alloca(sizeof(WNDCLASSW));
  object arg0;
  arg0 = popSTACK();
  processWNDCLASSW(wndclassw_p,arg0);
  begin_system_call();
  atom = RegisterClassW(wndclassw_p);
  end_system_call();
  if(0 ==atom){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(atom);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:REMOVEFONTRESOURCEA, lpcstr)
{
  object arg;
  BOOL bool0;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  bool0 = RemoveFontResourceA(lpcstr);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:REMOVEFONTRESOURCEW, lpcwstr)
{
  object arg;
  BOOL bool0;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  bool0 = RemoveFontResourceW(lpcwstr);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:RESETDCA, hdc devmodea_p)
{
  object arg;
  HDC hdc0;
  HDC hdc;
  DEVMODEA* devmodea_p = alloca(sizeof(DEVMODEA));
  object arg0;
  arg0 = popSTACK();
  processDEVMODEA(devmodea_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processDEVMODEA(devmodea_p,arg0);
  begin_system_call();
  hdc0 = ResetDCA(hdc,devmodea_p);
  end_system_call();
  if(NULL ==hdc0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:RESETDCW, hdc devmodew_p)
{
  object arg;
  HDC hdc0;
  HDC hdc;
  DEVMODEW* devmodew_p = alloca(sizeof(DEVMODEW));
  object arg0;
  arg0 = popSTACK();
  processDEVMODEW(devmodew_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processDEVMODEW(devmodew_p,arg0);
  begin_system_call();
  hdc0 = ResetDCW(hdc,devmodew_p);
  end_system_call();
  if(NULL ==hdc0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hdc0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SELECTPALETTE, hdc hpalette bool0)
{
  object arg;
  HPALETTE hpalette0;
  HDC hdc;
  HPALETTE hpalette;
  BOOL bool0;
  arg = popSTACK();
  bool0 = nullp(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hpalette = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hpalette0 = SelectPalette(hdc,hpalette,bool0);
  end_system_call();
  if(NULL ==hpalette0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hpalette0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETCOLORADJUSTMENT, hdc coloradjustment_p)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  COLORADJUSTMENT* coloradjustment_p = alloca(sizeof(COLORADJUSTMENT));
  object arg0;
  arg0 = popSTACK();
  processCOLORADJUSTMENT(coloradjustment_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processCOLORADJUSTMENT(coloradjustment_p,arg0);
  begin_system_call();
  bool0 = SetColorAdjustment(hdc,coloradjustment_p);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETDEVICEGAMMARAMP, hdc pvoid)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  void* pvoid;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SetDeviceGammaRamp(hdc,pvoid);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETICMPROFILEA, hdc lpstr)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  LPSTR lpstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SetICMProfileA(hdc,lpstr);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETICMPROFILEW, hdc lpwstr)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  LPWSTR lpwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SetICMProfileW(hdc,lpwstr);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETPIXEL, hdc int0 int1 colorref)
{
  object arg;
  COLORREF colorref0;
  HDC hdc;
  int int0;
  int int1;
  COLORREF colorref;
  arg = popSTACK();
  colorref = processCOLORREF(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  colorref0 = SetPixel(hdc,int0,int1,colorref);
  end_system_call();
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETPIXELV, hdc int0 int1 colorref)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  COLORREF colorref;
  arg = popSTACK();
  colorref = processCOLORREF(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SetPixelV(hdc,int0,int1,colorref);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETTEXTCOLOR, hdc colorref)
{
  object arg;
  COLORREF colorref0;
  HDC hdc;
  COLORREF colorref;
  arg = popSTACK();
  colorref = processCOLORREF(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  colorref0 = SetTextColor(hdc,colorref);
  end_system_call();
  if(CLR_INVALID == colorref0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = fixnum(colorref0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETWORLDTRANSFORM, hdc xform_p)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  XFORM* xform_p = alloca(sizeof(XFORM));
  object arg0;
  arg0 = popSTACK();
  processXFORM(xform_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processXFORM(xform_p,arg0);
  begin_system_call();
  bool0 = SetWorldTransform(hdc,xform_p);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
#line 1 "funcs.c"
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ANIMATEPALETTE, hpalette uint uint0 paletteentry_p)
{
  object arg;
  BOOL bool0;
  HPALETTE hpalette;
  UINT uint;
  UINT uint0;
  PALETTEENTRY* paletteentry_p = alloca(sizeof(PALETTEENTRY));
  object arg0;
  arg0 = popSTACK();
  processPALETTEENTRY(paletteentry_p,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hpalette = TheFpointer(arg)->fp_pointer;
  processPALETTEENTRY(paletteentry_p,arg0);
  begin_system_call();
  bool0 = AnimatePalette(hpalette,uint,uint0,paletteentry_p);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CHOOSEPIXELFORMAT, hdc pixelformatdescriptor_p)
{
  object arg;
  int int0;
  HDC hdc;
  PIXELFORMATDESCRIPTOR* pixelformatdescriptor_p = alloca(sizeof(PIXELFORMATDESCRIPTOR));
  object arg0;
  arg0 = popSTACK();
  processPIXELFORMATDESCRIPTOR(pixelformatdescriptor_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPIXELFORMATDESCRIPTOR(pixelformatdescriptor_p,arg0);
  begin_system_call();
  int0 = ChoosePixelFormat(hdc,pixelformatdescriptor_p);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEBITMAP, int0 int1 uint uint0 pcvoid)
{
  object arg;
  HBITMAP hbitmap;
  int int0;
  int int1;
  UINT uint;
  UINT uint0;
  void* pcvoid;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pcvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  begin_system_call();
  hbitmap = CreateBitmap(int0,int1,uint,uint0,pcvoid);
  end_system_call();
  if(NULL ==hbitmap){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbitmap);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEDIBPATTERNBRUSHPT, pcvoid uint)
{
  object arg;
  HBRUSH hbrush;
  void* pcvoid;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pcvoid = &(TheSbvector(arg)->data);
  begin_system_call();
  hbrush = CreateDIBPatternBrushPt(pcvoid,uint);
  end_system_call();
  if(NULL ==hbrush){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbrush);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEPOLYPOLYGONRGN, point_p int_p int0 int1)
{
  object arg;
  HRGN hrgn;
  POINT* point_p = alloca(sizeof(POINT));
  object arg0;
  INT* int_p;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  int_p = &(TheSbvector(arg)->data);
  arg0 = popSTACK();
  processPOINT(point_p,arg0);
  processPOINT(point_p,arg0);
  begin_system_call();
  hrgn = CreatePolyPolygonRgn(point_p,int_p,int0,int1);
  end_system_call();
  if(NULL ==hrgn){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hrgn);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEPOLYGONRGN, point_p int0 int1)
{
  object arg;
  HRGN hrgn;
  POINT* point_p = alloca(sizeof(POINT));
  object arg0;
  int int0;
  int int1;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg0 = popSTACK();
  processPOINT(point_p,arg0);
  processPOINT(point_p,arg0);
  begin_system_call();
  hrgn = CreatePolygonRgn(point_p,int0,int1);
  end_system_call();
  if(NULL ==hrgn){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hrgn);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATESCALABLEFONTRESOURCEA, dword lpcstr lpcstr0 lpcstr1)
{
  object arg;
  BOOL bool0;
  DWORD dword;
  LPCSTR lpcstr;
  LPCSTR lpcstr0;
  LPCSTR lpcstr1;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr1 = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr0 = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  begin_system_call();
  bool0 = CreateScalableFontResourceA(dword,lpcstr,lpcstr0,lpcstr1);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATESCALABLEFONTRESOURCEW, dword lpcwstr lpcwstr0 lpcwstr1)
{
  object arg;
  BOOL bool0;
  DWORD dword;
  LPCWSTR lpcwstr;
  LPCWSTR lpcwstr0;
  LPCWSTR lpcwstr1;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr1 = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr0 = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  begin_system_call();
  bool0 = CreateScalableFontResourceW(dword,lpcwstr,lpcwstr0,lpcwstr1);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:DPTOLP, hdc lppoint int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = DPtoLP(hdc,lppoint,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:DESCRIBEPIXELFORMAT, hdc int0 uint lppixelformatdescriptor)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  UINT uint;
  PIXELFORMATDESCRIPTOR* lppixelformatdescriptor = alloca(sizeof(PIXELFORMATDESCRIPTOR));
  object arg0;
  arg0 = popSTACK();
  processPIXELFORMATDESCRIPTOR(lppixelformatdescriptor,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPIXELFORMATDESCRIPTOR(lppixelformatdescriptor,arg0);
  begin_system_call();
  int1 = DescribePixelFormat(hdc,int0,uint,lppixelformatdescriptor);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:DRAWESCAPE, hdc int0 int1 lpcstr)
{
  object arg;
  int int2;
  HDC hdc;
  int int0;
  int int1;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int2 = DrawEscape(hdc,int0,int1,lpcstr);
  end_system_call();
  if(0 <=int2){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int2);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:EXTCREATEPEN, dword dword0 logbrush_p dword1 dword_p)
{
  object arg;
  HPEN hpen;
  DWORD dword;
  DWORD dword0;
  LOGBRUSH* logbrush_p = alloca(sizeof(LOGBRUSH));
  object arg0;
  DWORD dword1;
  DWORD* dword_p;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  dword_p = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  dword1 = I_to_uint32(arg);
  arg0 = popSTACK();
  processLOGBRUSH(logbrush_p,arg0);
  arg = popSTACK();
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  processLOGBRUSH(logbrush_p,arg0);
  begin_system_call();
  hpen = ExtCreatePen(dword,dword0,logbrush_p,dword1,dword_p);
  end_system_call();
  if(NULL ==hpen){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hpen);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:EXTCREATEREGION, xform_p dword rgndata_p)
{
  object arg;
  HRGN hrgn;
  XFORM* xform_p = alloca(sizeof(XFORM));
  object arg0;
  DWORD dword;
  RGNDATA* rgndata_p;
  arg0 = popSTACK();
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = popSTACK();
  processXFORM(xform_p,arg);
  rgndata_p = alloca(dword*sizeof(RGNDATA));
  processRGNDATA_C(rgndata_p,arg0,dword);
  begin_system_call();
  hrgn = ExtCreateRegion(xform_p,dword,rgndata_p);
  end_system_call();
  if(NULL ==hrgn){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hrgn);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:FIXBRUSHORGEX, hdc int0 int1 lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = FixBrushOrgEx(hdc,int0,int1,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GDICOMMENT, hdc uint byte_p)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  BYTE* byte_p;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  byte_p = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GdiComment(hdc,uint,byte_p);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GDIFLUSH, )
{
  object arg;
  BOOL bool0;
  begin_system_call();
  bool0 = GdiFlush();
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GDIGETBATCHLIMIT, )
{
  object arg;
  DWORD dword;
  begin_system_call();
  dword = GdiGetBatchLimit();
  end_system_call();
  if(0 <=dword){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:LPTODP, hdc lppoint int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = LPtoDP(hdc,lppoint,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:MODIFYWORLDTRANSFORM, hdc xform_p dword)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  XFORM* xform_p = alloca(sizeof(XFORM));
  object arg0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = popSTACK();
  processXFORM(xform_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processXFORM(xform_p,arg0);
  begin_system_call();
  bool0 = ModifyWorldTransform(hdc,xform_p,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:MOVETOEX, hdc int0 int1 lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = MoveToEx(hdc,int0,int1,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:OFFSETVIEWPORTORGEX, hdc int0 int1 lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = OffsetViewportOrgEx(hdc,int0,int1,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:OFFSETWINDOWORGEX, hdc int0 int1 lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = OffsetWindowOrgEx(hdc,int0,int1,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PLAYENHMETAFILERECORD, hdc lphandletable enhmetarecord_p uint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HANDLETABLE* lphandletable;
  ENHMETARECORD* enhmetarecord_p = alloca(sizeof(ENHMETARECORD));
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  processENHMETARECORD(enhmetarecord_p,arg);
  arg = popSTACK();
  lphandletable = alloca(uint*sizeof(HANDLETABLE));
  processHANDLETABLE_C(lphandletable,arg,uint);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = PlayEnhMetaFileRecord(hdc,lphandletable,enhmetarecord_p,uint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:PLAYMETAFILERECORD, hdc lphandletable lpmetarecord uint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HANDLETABLE* lphandletable;
  METARECORD* lpmetarecord = alloca(sizeof(METARECORD));
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  processMETARECORD(lpmetarecord,arg);
  arg = popSTACK();
  lphandletable = alloca(uint*sizeof(HANDLETABLE));
  processHANDLETABLE_C(lphandletable,arg,uint);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = PlayMetaFileRecord(hdc,lphandletable,lpmetarecord,uint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:POLYBEZIER, hdc point_p dword)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* point_p = alloca(sizeof(POINT));
  object arg0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = popSTACK();
  processPOINT(point_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(point_p,arg0);
  begin_system_call();
  bool0 = PolyBezier(hdc,point_p,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:POLYBEZIERTO, hdc point_p dword)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* point_p = alloca(sizeof(POINT));
  object arg0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = popSTACK();
  processPOINT(point_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(point_p,arg0);
  begin_system_call();
  bool0 = PolyBezierTo(hdc,point_p,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:POLYDRAW, hdc point_p byte_p int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* point_p = alloca(sizeof(POINT));
  object arg0;
  BYTE* byte_p;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  byte_p = &(TheSbvector(arg)->data);
  arg0 = popSTACK();
  processPOINT(point_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(point_p,arg0);
  begin_system_call();
  bool0 = PolyDraw(hdc,point_p,byte_p,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:POLYPOLYGON, hdc point_p int_p int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* point_p = alloca(sizeof(POINT));
  object arg0;
  INT* int_p;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  int_p = &(TheSbvector(arg)->data);
  arg0 = popSTACK();
  processPOINT(point_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(point_p,arg0);
  begin_system_call();
  bool0 = PolyPolygon(hdc,point_p,int_p,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:POLYPOLYLINE, hdc point_p dword_p dword)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* point_p = alloca(sizeof(POINT));
  object arg0;
  DWORD* dword_p;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  dword_p = &(TheSbvector(arg)->data);
  arg0 = popSTACK();
  processPOINT(point_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(point_p,arg0);
  begin_system_call();
  bool0 = PolyPolyline(hdc,point_p,dword_p,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:POLYTEXTOUTA, hdc polytexta_p int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POLYTEXTA* polytexta_p = alloca(sizeof(POLYTEXTA));
  object arg0;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg0 = popSTACK();
  processPOLYTEXTA(polytexta_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOLYTEXTA(polytexta_p,arg0);
  begin_system_call();
  bool0 = PolyTextOutA(hdc,polytexta_p,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:POLYTEXTOUTW, hdc polytextw_p int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POLYTEXTW* polytextw_p = alloca(sizeof(POLYTEXTW));
  object arg0;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg0 = popSTACK();
  processPOLYTEXTW(polytextw_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOLYTEXTW(polytextw_p,arg0);
  begin_system_call();
  bool0 = PolyTextOutW(hdc,polytextw_p,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:POLYGON, hdc point_p int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* point_p = alloca(sizeof(POINT));
  object arg0;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg0 = popSTACK();
  processPOINT(point_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(point_p,arg0);
  begin_system_call();
  bool0 = Polygon(hdc,point_p,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:POLYLINE, hdc point_p int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* point_p = alloca(sizeof(POINT));
  object arg0;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg0 = popSTACK();
  processPOINT(point_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(point_p,arg0);
  begin_system_call();
  bool0 = Polyline(hdc,point_p,int0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:POLYLINETO, hdc point_p dword)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* point_p = alloca(sizeof(POINT));
  object arg0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = popSTACK();
  processPOINT(point_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(point_p,arg0);
  begin_system_call();
  bool0 = PolylineTo(hdc,point_p,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETBITMAPBITS, hbitmap dword pcvoid)
{
  object arg;
  LONG long0;
  HBITMAP hbitmap;
  DWORD dword;
  void* pcvoid;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pcvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbitmap = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  long0 = SetBitmapBits(hbitmap,dword,pcvoid);
  end_system_call();
  if(0 <=long0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(long0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETBITMAPDIMENSIONEX, hbitmap int0 int1)
{
  object arg;
  BOOL bool0;
  HBITMAP hbitmap;
  int int0;
  int int1;
  SIZE lpsize;
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbitmap = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SetBitmapDimensionEx(hbitmap,int0,int1,&lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    pushSTACK( uint32_to_I(lpsize.cy));
    value2 = uint32_to_I(lpsize.cx);
    value3 = popSTACK();
    value1 = T;
    mv_count=3;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETBOUNDSRECT, hdc lpcrect uint)
{
  object arg;
  UINT uint0;
  HDC hdc;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg0 = popSTACK();
  processRECT(lpcrect,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lpcrect,arg0);
  begin_system_call();
  uint0 = SetBoundsRect(hdc,lpcrect,uint);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETBRUSHORGEX, hdc int0 int1 lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = SetBrushOrgEx(hdc,int0,int1,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETDIBCOLORTABLE, hdc uint uint0 rgbquad_p)
{
  object arg;
  UINT uint1;
  HDC hdc;
  UINT uint;
  UINT uint0;
  RGBQUAD* rgbquad_p;
  object arg0;
  arg0 = popSTACK();
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  rgbquad_p = alloca(uint0*sizeof(RGBQUAD));
  processRGBQUAD_C(rgbquad_p,arg0,uint0);
  begin_system_call();
  uint1 = SetDIBColorTable(hdc,uint,uint0,rgbquad_p);
  end_system_call();
  if(0 <=uint1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETENHMETAFILEBITS, uint byte_p)
{
  object arg;
  HENHMETAFILE henhmetafile;
  UINT uint;
  BYTE* byte_p;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  byte_p = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  begin_system_call();
  henhmetafile = SetEnhMetaFileBits(uint,byte_p);
  end_system_call();
  if(NULL ==henhmetafile){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(henhmetafile);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETMETAFILEBITSEX, uint byte_p)
{
  object arg;
  HMETAFILE hmetafile;
  UINT uint;
  BYTE* byte_p;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  byte_p = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  begin_system_call();
  hmetafile = SetMetaFileBitsEx(uint,byte_p);
  end_system_call();
  if(NULL ==hmetafile){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hmetafile);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETPALETTEENTRIES, hpalette uint uint0 paletteentry_p)
{
  object arg;
  UINT uint1;
  HPALETTE hpalette;
  UINT uint;
  UINT uint0;
  PALETTEENTRY* paletteentry_p = alloca(sizeof(PALETTEENTRY));
  object arg0;
  arg0 = popSTACK();
  processPALETTEENTRY(paletteentry_p,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hpalette = TheFpointer(arg)->fp_pointer;
  processPALETTEENTRY(paletteentry_p,arg0);
  begin_system_call();
  uint1 = SetPaletteEntries(hpalette,uint,uint0,paletteentry_p);
  end_system_call();
  if(0 <=uint1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETPIXELFORMAT, hdc int0 pixelformatdescriptor_p)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  PIXELFORMATDESCRIPTOR* pixelformatdescriptor_p = alloca(sizeof(PIXELFORMATDESCRIPTOR));
  object arg0;
  arg0 = popSTACK();
  processPIXELFORMATDESCRIPTOR(pixelformatdescriptor_p,arg0);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPIXELFORMATDESCRIPTOR(pixelformatdescriptor_p,arg0);
  begin_system_call();
  bool0 = SetPixelFormat(hdc,int0,pixelformatdescriptor_p);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETVIEWPORTEXTEX, hdc int0 int1 lpsize)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = popSTACK();
  processSIZE(lpsize,arg0);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = SetViewportExtEx(hdc,int0,int1,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETVIEWPORTORGEX, hdc int0 int1 lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = SetViewportOrgEx(hdc,int0,int1,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETWINMETAFILEBITS, uint byte_p hdc metafilepict_p)
{
  object arg;
  HENHMETAFILE henhmetafile;
  UINT uint;
  BYTE* byte_p;
  HDC hdc;
  METAFILEPICT* metafilepict_p = alloca(sizeof(METAFILEPICT));
  object arg0;
  arg0 = popSTACK();
  processMETAFILEPICT(metafilepict_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  byte_p = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  processMETAFILEPICT(metafilepict_p,arg0);
  begin_system_call();
  henhmetafile = SetWinMetaFileBits(uint,byte_p,hdc,metafilepict_p);
  end_system_call();
  if(NULL ==henhmetafile){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(henhmetafile);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETWINDOWEXTEX, hdc int0 int1 lpsize)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = popSTACK();
  processSIZE(lpsize,arg0);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = SetWindowExtEx(hdc,int0,int1,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETWINDOWORGEX, hdc int0 int1 lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = SetWindowOrgEx(hdc,int0,int1,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:STARTDOCA, hdc docinfoa_p)
{
  object arg;
  int int0;
  HDC hdc;
  DOCINFOA* docinfoa_p = alloca(sizeof(DOCINFOA));
  object arg0;
  arg0 = popSTACK();
  processDOCINFOA(docinfoa_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processDOCINFOA(docinfoa_p,arg0);
  begin_system_call();
  int0 = StartDocA(hdc,docinfoa_p);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:STARTDOCW, hdc docinfow_p)
{
  object arg;
  int int0;
  HDC hdc;
  DOCINFOW* docinfow_p = alloca(sizeof(DOCINFOW));
  object arg0;
  arg0 = popSTACK();
  processDOCINFOW(docinfow_p,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processDOCINFOW(docinfow_p,arg0);
  begin_system_call();
  int0 = StartDocW(hdc,docinfow_p);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:TEXTOUTA, hdc int0 int1 lpcstr int2)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  LPCSTR lpcstr;
  int int2;
  arg = popSTACK();
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = TextOutA(hdc,int0,int1,lpcstr,int2);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:TEXTOUTW, hdc int0 int1 lpcwstr int2)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  int int0;
  int int1;
  LPCWSTR lpcwstr;
  int int2;
  arg = popSTACK();
  check_sint(arg);
  int2 = I_to_sint32(arg);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = TextOutW(hdc,int0,int1,lpcwstr,int2);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:UPDATEICMREGKEYA, dword dword0 lpstr uint)
{
  object arg;
  BOOL bool0;
  DWORD dword;
  DWORD dword0;
  LPSTR lpstr;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  begin_system_call();
  bool0 = UpdateICMRegKeyA(dword,dword0,lpstr,uint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:UPDATEICMREGKEYW, dword dword0 lpwstr uint)
{
  object arg;
  BOOL bool0;
  DWORD dword;
  DWORD dword0;
  LPWSTR lpwstr;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  begin_system_call();
  bool0 = UpdateICMRegKeyW(dword,dword0,lpwstr,uint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
#line 1 "funcs.c"
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CHECKCOLORSINGAMUT, hdc pvoid pvoid0 dword)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  void* pvoid;
  void* pvoid0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid0 = &(TheSbvector(arg)->data);
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = CheckColorsInGamut(hdc,pvoid,pvoid0,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:COMBINETRANSFORM, lpxform xform_p xform_p0)
{
  object arg0;
  BOOL bool0;
  XFORM lpxform;
  XFORM xform_p;
  XFORM xform_p0;
  arg0 = popSTACK();
  processXFORM(&xform_p0,arg0);
  arg0 = popSTACK();
  processXFORM(&xform_p,arg0);
  arg0 = popSTACK();
  begin_system_call();
  bool0 = CombineTransform(&lpxform,&xform_p,&xform_p0);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    outputXFORM(&lpxform,arg0);
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:CREATEDIBSECTION, hdc bitmapinfo_p uint handle dword)
{
  object arg;
  HBITMAP hbitmap;
  HDC hdc;
  BITMAPINFO* bitmapinfo_p = alloca(sizeof(BITMAPINFO));
  UINT uint;
  void *voidp;
  HANDLE handle;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  handle = (nullp(arg))?0:(TheFpointer(arg)->fp_pointer);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  processBITMAPINFO(bitmapinfo_p,arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  hbitmap = CreateDIBSection(hdc,bitmapinfo_p,uint,&voidp,handle,dword);
  end_system_call();
  if(NULL ==hbitmap){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hbitmap);
    value3 = allocate_fpointer(voidp);
    mv_count=3;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENUMENHMETAFILE, hdc henhmetafile enhmfenumproc pvoid lpcrect)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HENHMETAFILE henhmetafile;
  ENHMFENUMPROC enhmfenumproc;
  void* pvoid;
  RECT* lpcrect = alloca(sizeof(RECT));
  object arg0;
  arg0 = popSTACK();
  processRECT(lpcrect,arg0);
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg0 = popSTACK();
  processENHMFENUMPROC(enhmfenumproc,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lpcrect,arg0);
  begin_system_call();
  bool0 = EnumEnhMetaFile(hdc,henhmetafile,enhmfenumproc,pvoid,lpcrect);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
/*
DEFUN( GDI:ENUMFONTFAMILIESA, hdc lpcstr fontenumproca lparam)
{
  object arg;
  int int0;
  HDC hdc;
  LPCSTR lpcstr;
  FONTENUMPROCA fontenumproca;
  ARAM* lparam = alloca(sizeof(ARAM));
  object arg0;
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg0 = popSTACK();
  processFONTENUMPROCA(fontenumproca,arg0);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processARAM(lparam,arg0);
  begin_system_call();
  int0 = EnumFontFamiliesA(hdc,lpcstr,fontenumproca,lparam);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENUMFONTFAMILIESEXA, hdc plogfonta fontenumproca lparam dword)
{
  object arg;
  int int0;
  HDC hdc;
  PLOGFONTA plogfonta;
  FONTENUMPROCA fontenumproca;
  ARAM* lparam = alloca(sizeof(ARAM));
  object arg0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg0 = popSTACK();
  processFONTENUMPROCA(fontenumproca,arg0);
  arg0 = popSTACK();
  processPLOGFONTA(plogfonta,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processARAM(lparam,arg0);
  begin_system_call();
  int0 = EnumFontFamiliesExA(hdc,plogfonta,fontenumproca,lparam,dword);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENUMFONTFAMILIESEXW, hdc plogfontw fontenumprocw lparam dword)
{
  object arg;
  int int0;
  HDC hdc;
  PLOGFONTW plogfontw;
  FONTENUMPROCW fontenumprocw;
  ARAM* lparam = alloca(sizeof(ARAM));
  object arg0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg0 = popSTACK();
  processFONTENUMPROCW(fontenumprocw,arg0);
  arg0 = popSTACK();
  processPLOGFONTW(plogfontw,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processARAM(lparam,arg0);
  begin_system_call();
  int0 = EnumFontFamiliesExW(hdc,plogfontw,fontenumprocw,lparam,dword);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENUMFONTFAMILIESW, hdc lpcwstr fontenumprocw lparam)
{
  object arg;
  int int0;
  HDC hdc;
  LPCWSTR lpcwstr;
  FONTENUMPROCW fontenumprocw;
  ARAM* lparam = alloca(sizeof(ARAM));
  object arg0;
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg0 = popSTACK();
  processFONTENUMPROCW(fontenumprocw,arg0);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processARAM(lparam,arg0);
  begin_system_call();
  int0 = EnumFontFamiliesW(hdc,lpcwstr,fontenumprocw,lparam);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENUMFONTSA, hdc lpcstr fontenumproca lparam)
{
  object arg;
  int int0;
  HDC hdc;
  LPCSTR lpcstr;
  FONTENUMPROCA fontenumproca;
  ARAM* lparam = alloca(sizeof(ARAM));
  object arg0;
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg0 = popSTACK();
  processFONTENUMPROCA(fontenumproca,arg0);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processARAM(lparam,arg0);
  begin_system_call();
  int0 = EnumFontsA(hdc,lpcstr,fontenumproca,lparam);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENUMFONTSW, hdc lpcwstr fontenumproca lparam)
{
  object arg;
  int int0;
  HDC hdc;
  LPCWSTR lpcwstr;
  FONTENUMPROCA fontenumproca;
  ARAM* lparam = alloca(sizeof(ARAM));
  object arg0;
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg0 = popSTACK();
  processFONTENUMPROCA(fontenumproca,arg0);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processARAM(lparam,arg0);
  begin_system_call();
  int0 = EnumFontsW(hdc,lpcwstr,fontenumproca,lparam);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENUMICMPROFILESA, hdc icmenumproca lparam)
{
  object arg;
  int int0;
  HDC hdc;
  ICMENUMPROCA icmenumproca;
  ARAM* lparam = alloca(sizeof(ARAM));
  object arg0;
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg0 = popSTACK();
  processICMENUMPROCA(icmenumproca,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processARAM(lparam,arg0);
  begin_system_call();
  int0 = EnumICMProfilesA(hdc,icmenumproca,lparam);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENUMICMPROFILESW, hdc icmenumprocw lparam)
{
  object arg;
  int int0;
  HDC hdc;
  ICMENUMPROCW icmenumprocw;
  ARAM* lparam = alloca(sizeof(ARAM));
  object arg0;
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg0 = popSTACK();
  processICMENUMPROCW(icmenumprocw,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processARAM(lparam,arg0);
  begin_system_call();
  int0 = EnumICMProfilesW(hdc,icmenumprocw,lparam);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENUMMETAFILE, hdc hmetafile mfenumproc lparam)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  HMETAFILE hmetafile;
  MFENUMPROC mfenumproc;
  ARAM* lparam = alloca(sizeof(ARAM));
  object arg0;
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg0 = popSTACK();
  processMFENUMPROC(mfenumproc,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hmetafile = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processARAM(lparam,arg0);
  begin_system_call();
  bool0 = EnumMetaFile(hdc,hmetafile,mfenumproc,lparam);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ENUMOBJECTS, hdc int0 gobjenumproc lparam)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  GOBJENUMPROC gobjenumproc;
  ARAM* lparam = alloca(sizeof(ARAM));
  object arg0;
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg0 = popSTACK();
  processGOBJENUMPROC(gobjenumproc,arg0);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processARAM(lparam,arg0);
  begin_system_call();
  int1 = EnumObjects(hdc,int0,gobjenumproc,lparam);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
*/
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETASPECTRATIOFILTEREX, hdc lpsize)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = popSTACK();
  processSIZE(lpsize,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = GetAspectRatioFilterEx(hdc,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETBITMAPBITS, hbitmap long0 pvoid)
{
  object arg;
  LONG long1;
  HBITMAP hbitmap;
  LONG long0;
  void* pvoid;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_sint(arg);
  long0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbitmap = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  long1 = GetBitmapBits(hbitmap,long0,pvoid);
  end_system_call();
  if(0 <=long1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(long1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETBITMAPDIMENSIONEX, hbitmap)
{
  object arg;
  BOOL bool0;
  HBITMAP hbitmap;
  SIZE lpsize;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hbitmap = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetBitmapDimensionEx(hbitmap,&lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    pushSTACK( uint32_to_I(lpsize.cy));
    value2 = uint32_to_I(lpsize.cx);
    value3 = popSTACK();
    value1 = T;
    mv_count=3;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETBOUNDSRECT, hdc lprect uint)
{
  object arg;
  UINT uint0;
  HDC hdc;
  RECT* lprect = alloca(sizeof(RECT));
  object arg0;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg0 = popSTACK();
  processRECT(lprect,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lprect,arg0);
  begin_system_call();
  uint0 = GetBoundsRect(hdc,lprect,uint);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETBRUSHORGEX, hdc lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = GetBrushOrgEx(hdc,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARABCWIDTHSA, hdc uint uint0 lpabc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  ABC* lpabc = alloca(sizeof(ABC));
  object arg0;
  arg0 = popSTACK();
  processABC(lpabc,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processABC(lpabc,arg0);
  begin_system_call();
  bool0 = GetCharABCWidthsA(hdc,uint,uint0,lpabc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARABCWIDTHSFLOATA, hdc uint uint0 lpabcfloat)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  ABCFLOAT* lpabcfloat = alloca(sizeof(ABCFLOAT));
  object arg0;
  arg0 = popSTACK();
  processABCFLOAT(lpabcfloat,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processABCFLOAT(lpabcfloat,arg0);
  begin_system_call();
  bool0 = GetCharABCWidthsFloatA(hdc,uint,uint0,lpabcfloat);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARABCWIDTHSFLOATW, hdc uint uint0 lpabcfloat)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  ABCFLOAT* lpabcfloat = alloca(sizeof(ABCFLOAT));
  object arg0;
  arg0 = popSTACK();
  processABCFLOAT(lpabcfloat,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processABCFLOAT(lpabcfloat,arg0);
  begin_system_call();
  bool0 = GetCharABCWidthsFloatW(hdc,uint,uint0,lpabcfloat);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARABCWIDTHSW, hdc uint uint0 lpabc)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  ABC* lpabc = alloca(sizeof(ABC));
  object arg0;
  arg0 = popSTACK();
  processABC(lpabc,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processABC(lpabc,arg0);
  begin_system_call();
  bool0 = GetCharABCWidthsW(hdc,uint,uint0,lpabc);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARWIDTH32A, hdc uint uint0 lpint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  int* lpint;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  lpint = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetCharWidth32A(hdc,uint,uint0,lpint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARWIDTH32W, hdc uint uint0 lpint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  int* lpint;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  lpint = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetCharWidth32W(hdc,uint,uint0,lpint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARWIDTHA, hdc uint uint0 lpint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  int* lpint;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  lpint = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetCharWidthA(hdc,uint,uint0,lpint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARWIDTHW, hdc uint uint0 lpint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  int* lpint;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  lpint = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetCharWidthW(hdc,uint,uint0,lpint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCLIPBOX, hdc lprect)
{
  object arg;
  int int0;
  HDC hdc;
  RECT* lprect = alloca(sizeof(RECT));
  object arg0;
  arg0 = popSTACK();
  processRECT(lprect,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRECT(lprect,arg0);
  begin_system_call();
  int0 = GetClipBox(hdc,lprect);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCOLORADJUSTMENT, hdc lpcoloradjustment)
{
  BOOL bool0;
  HDC hdc;
  COLORADJUSTMENT lpcoloradjustment;
  object arg0 = popSTACK();
  object arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetColorAdjustment(hdc,&lpcoloradjustment);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    outputCOLORADJUSTMENT(&lpcoloradjustment,arg0);
    value2 = arg0;
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCURRENTPOSITIONEX, hdc lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = GetCurrentPositionEx(hdc,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETDCORGEX, hdc lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = GetDCOrgEx(hdc,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETDIBCOLORTABLE, hdc uint uint0 rgbquad_p)
{
  object arg;
  UINT uint1;
  HDC hdc;
  UINT uint;
  UINT uint0;
  RGBQUAD* rgbquad_p = alloca(sizeof(RGBQUAD));
  object arg0;
  arg0 = popSTACK();
  processRGBQUAD(rgbquad_p,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processRGBQUAD(rgbquad_p,arg0);
  begin_system_call();
  uint1 = GetDIBColorTable(hdc,uint,uint0,rgbquad_p);
  end_system_call();
  if(0 <=uint1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETDEVICEGAMMARAMP, hdc pvoid)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  void* pvoid;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetDeviceGammaRamp(hdc,pvoid);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETENHMETAFILEA, lpcstr)
{
  object arg;
  HENHMETAFILE henhmetafile;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  henhmetafile = GetEnhMetaFileA(lpcstr);
  end_system_call();
  if(NULL ==henhmetafile){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(henhmetafile);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETENHMETAFILEDESCRIPTIONA, henhmetafile uint lpstr)
{
  object arg;
  UINT uint0;
  HENHMETAFILE henhmetafile;
  UINT uint;
  LPSTR lpstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  uint0 = GetEnhMetaFileDescriptionA(henhmetafile,uint,lpstr);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETENHMETAFILEDESCRIPTIONW, henhmetafile uint lpwstr)
{
  object arg;
  UINT uint0;
  HENHMETAFILE henhmetafile;
  UINT uint;
  LPWSTR lpwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  uint0 = GetEnhMetaFileDescriptionW(henhmetafile,uint,lpwstr);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETENHMETAFILEHEADER, henhmetafile uint lpenhmetaheader)
{
  object arg;
  UINT uint0;
  HENHMETAFILE henhmetafile;
  UINT uint;
  ENHMETAHEADER* lpenhmetaheader = alloca(sizeof(ENHMETAHEADER));
  object arg0;
  arg0 = popSTACK();
  processENHMETAHEADER(lpenhmetaheader,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  processENHMETAHEADER(lpenhmetaheader,arg0);
  begin_system_call();
  uint0 = GetEnhMetaFileHeader(henhmetafile,uint,lpenhmetaheader);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETENHMETAFILEPALETTEENTRIES, henhmetafile uint lppaletteentry)
{
  object arg;
  UINT uint0;
  HENHMETAFILE henhmetafile;
  UINT uint;
  PALETTEENTRY* lppaletteentry = alloca(sizeof(PALETTEENTRY));
  object arg0;
  arg0 = popSTACK();
  processPALETTEENTRY(lppaletteentry,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  processPALETTEENTRY(lppaletteentry,arg0);
  begin_system_call();
  uint0 = GetEnhMetaFilePaletteEntries(henhmetafile,uint,lppaletteentry);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETENHMETAFILEPIXELFORMAT, henhmetafile dword pixelformatdescriptor_p)
{
  object arg;
  UINT uint;
  HENHMETAFILE henhmetafile;
  DWORD dword;
  PIXELFORMATDESCRIPTOR* pixelformatdescriptor_p = alloca(sizeof(PIXELFORMATDESCRIPTOR));
  object arg0;
  arg0 = popSTACK();
  processPIXELFORMATDESCRIPTOR(pixelformatdescriptor_p,arg0);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  processPIXELFORMATDESCRIPTOR(pixelformatdescriptor_p,arg0);
  begin_system_call();
  uint = GetEnhMetaFilePixelFormat(henhmetafile,dword,pixelformatdescriptor_p);
  end_system_call();
  if(0 <=uint){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETENHMETAFILEW, lpcwstr)
{
  object arg;
  HENHMETAFILE henhmetafile;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  henhmetafile = GetEnhMetaFileW(lpcwstr);
  end_system_call();
  if(NULL ==henhmetafile){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(henhmetafile);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETFONTDATA, hdc dword dword0 pvoid dword1)
{
  object arg;
  DWORD dword2;
  HDC hdc;
  DWORD dword;
  DWORD dword0;
  void* pvoid;
  DWORD dword1;
  arg = popSTACK();
  check_uint(arg);
  dword1 = I_to_uint32(arg);
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  dword0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  dword2 = GetFontData(hdc,dword,dword0,pvoid,dword1);
  end_system_call();
  if(0 <=dword2){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword2);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETICMPROFILEA, hdc dword lpstr)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  DWORD dword;
  LPSTR lpstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetICMProfileA(hdc,dword,lpstr);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETICMPROFILEW, hdc dword lpwstr)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  DWORD dword;
  LPWSTR lpwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetICMProfileW(hdc,dword,lpwstr);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETKERNINGPAIRSA, hdc dword lpkerningpair)
{
  object arg;
  DWORD dword0;
  HDC hdc;
  DWORD dword;
  KERNINGPAIR* lpkerningpair = alloca(sizeof(KERNINGPAIR));
  object arg0;
  arg0 = popSTACK();
  processKERNINGPAIR(lpkerningpair,arg0);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processKERNINGPAIR(lpkerningpair,arg0);
  begin_system_call();
  dword0 = GetKerningPairsA(hdc,dword,lpkerningpair);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETKERNINGPAIRSW, hdc dword lpkerningpair)
{
  object arg;
  DWORD dword0;
  HDC hdc;
  DWORD dword;
  KERNINGPAIR* lpkerningpair = alloca(sizeof(KERNINGPAIR));
  object arg0;
  arg0 = popSTACK();
  processKERNINGPAIR(lpkerningpair,arg0);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processKERNINGPAIR(lpkerningpair,arg0);
  begin_system_call();
  dword0 = GetKerningPairsW(hdc,dword,lpkerningpair);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETLOGCOLORSPACEA, hcolorspace lplogcolorspacea dword)
{
  object arg;
  BOOL bool0;
  HCOLORSPACE hcolorspace;
  LOGCOLORSPACEA* lplogcolorspacea = alloca(sizeof(LOGCOLORSPACEA));
  object arg0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = popSTACK();
  processLOGCOLORSPACEA(lplogcolorspacea,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hcolorspace = TheFpointer(arg)->fp_pointer;
  processLOGCOLORSPACEA(lplogcolorspacea,arg0);
  begin_system_call();
  bool0 = GetLogColorSpaceA(hcolorspace,lplogcolorspacea,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETLOGCOLORSPACEW, hcolorspace lplogcolorspacew dword)
{
  object arg;
  BOOL bool0;
  HCOLORSPACE hcolorspace;
  LOGCOLORSPACEW* lplogcolorspacew = alloca(sizeof(LOGCOLORSPACEW));
  object arg0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = popSTACK();
  processLOGCOLORSPACEW(lplogcolorspacew,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hcolorspace = TheFpointer(arg)->fp_pointer;
  processLOGCOLORSPACEW(lplogcolorspacew,arg0);
  begin_system_call();
  bool0 = GetLogColorSpaceW(hcolorspace,lplogcolorspacew,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETMETAFILEA, lpcstr)
{
  object arg;
  HMETAFILE hmetafile;
  LPCSTR lpcstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  begin_system_call();
  hmetafile = GetMetaFileA(lpcstr);
  end_system_call();
  if(NULL ==hmetafile){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hmetafile);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETMETAFILEBITSEX, hmetafile uint pvoid)
{
  object arg;
  UINT uint0;
  HMETAFILE hmetafile;
  UINT uint;
  void* pvoid;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hmetafile = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  uint0 = GetMetaFileBitsEx(hmetafile,uint,pvoid);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETMETAFILEW, lpcwstr)
{
  object arg;
  HMETAFILE hmetafile;
  LPCWSTR lpcwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  begin_system_call();
  hmetafile = GetMetaFileW(lpcwstr);
  end_system_call();
  if(NULL ==hmetafile){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = allocate_fpointer(hmetafile);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETOBJECTA, hgdiobj int0 pvoid)
{
  object arg;
  int int1;
  HGDIOBJ hgdiobj;
  int int0;
  void* pvoid;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hgdiobj = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = GetObjectA(hgdiobj,int0,pvoid);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETOBJECTW, hgdiobj int0 pvoid)
{
  object arg;
  int int1;
  HGDIOBJ hgdiobj;
  int int0;
  void* pvoid;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hgdiobj = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = GetObjectW(hgdiobj,int0,pvoid);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETOUTLINETEXTMETRICSA, hdc uint lpoutlinetextmetrica)
{
  object arg;
  UINT uint0;
  HDC hdc;
  UINT uint;
  OUTLINETEXTMETRICA* lpoutlinetextmetrica = alloca(sizeof(OUTLINETEXTMETRICA));
  object arg0;
  arg0 = popSTACK();
  processOUTLINETEXTMETRICA(lpoutlinetextmetrica,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processOUTLINETEXTMETRICA(lpoutlinetextmetrica,arg0);
  begin_system_call();
  uint0 = GetOutlineTextMetricsA(hdc,uint,lpoutlinetextmetrica);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETOUTLINETEXTMETRICSW, hdc uint lpoutlinetextmetricw)
{
  object arg;
  UINT uint0;
  HDC hdc;
  UINT uint;
  OUTLINETEXTMETRICW* lpoutlinetextmetricw = alloca(sizeof(OUTLINETEXTMETRICW));
  object arg0;
  arg0 = popSTACK();
  processOUTLINETEXTMETRICW(lpoutlinetextmetricw,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processOUTLINETEXTMETRICW(lpoutlinetextmetricw,arg0);
  begin_system_call();
  uint0 = GetOutlineTextMetricsW(hdc,uint,lpoutlinetextmetricw);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETPALETTEENTRIES, hpalette uint uint0 lppaletteentry)
{
  object arg;
  UINT uint1;
  HPALETTE hpalette;
  UINT uint;
  UINT uint0;
  PALETTEENTRY* lppaletteentry = alloca(sizeof(PALETTEENTRY));
  object arg0;
  arg0 = popSTACK();
  processPALETTEENTRY(lppaletteentry,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hpalette = TheFpointer(arg)->fp_pointer;
  processPALETTEENTRY(lppaletteentry,arg0);
  begin_system_call();
  uint1 = GetPaletteEntries(hpalette,uint,uint0,lppaletteentry);
  end_system_call();
  if(0 <=uint1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETPATH, hdc lppoint pbyte int0)
{
  object arg;
  int int1;
  HDC hdc;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  PBYTE pbyte;
  int int0;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg0 = popSTACK();
  processPBYTE(pbyte,arg0);
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  int1 = GetPath(hdc,lppoint,pbyte,int0);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETRASTERIZERCAPS, lprasterizer_status uint)
{
  object arg;
  BOOL bool0;
  RASTERIZER_STATUS* lprasterizer_status = alloca(sizeof(RASTERIZER_STATUS));
  object arg0;
  UINT uint;
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg0 = popSTACK();
  processRASTERIZER_STATUS(lprasterizer_status,arg0);
  processRASTERIZER_STATUS(lprasterizer_status,arg0);
  begin_system_call();
  bool0 = GetRasterizerCaps(lprasterizer_status,uint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETREGIONDATA, hrgn dword lprgndata)
{
  object arg;
  DWORD dword0;
  HRGN hrgn;
  DWORD dword;
  RGNDATA* lprgndata = alloca(sizeof(RGNDATA));
  object arg0;
  arg0 = popSTACK();
  processRGNDATA(lprgndata,arg0);
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  processRGNDATA(lprgndata,arg0);
  begin_system_call();
  dword0 = GetRegionData(hrgn,dword,lprgndata);
  end_system_call();
  if(0 <=dword0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(dword0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETRGNBOX, hrgn lprect)
{
  object arg;
  int int0;
  HRGN hrgn;
  RECT* lprect = alloca(sizeof(RECT));
  object arg0;
  arg0 = popSTACK();
  processRECT(lprect,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hrgn = TheFpointer(arg)->fp_pointer;
  processRECT(lprect,arg0);
  begin_system_call();
  int0 = GetRgnBox(hrgn,lprect);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETSYSTEMPALETTEENTRIES, hdc uint uint0 lppaletteentry)
{
  object arg;
  UINT uint1;
  HDC hdc;
  UINT uint;
  UINT uint0;
  PALETTEENTRY* lppaletteentry = alloca(sizeof(PALETTEENTRY));
  object arg0;
  arg0 = popSTACK();
  processPALETTEENTRY(lppaletteentry,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPALETTEENTRY(lppaletteentry,arg0);
  begin_system_call();
  uint1 = GetSystemPaletteEntries(hdc,uint,uint0,lppaletteentry);
  end_system_call();
  if(0 <=uint1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTCHARSETINFO, hdc lpfontsignature dword)
{
  object arg;
  int int0;
  HDC hdc;
  FONTSIGNATURE* lpfontsignature = alloca(sizeof(FONTSIGNATURE));
  object arg0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = popSTACK();
  processFONTSIGNATURE(lpfontsignature,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processFONTSIGNATURE(lpfontsignature,arg0);
  begin_system_call();
  int0 = GetTextCharsetInfo(hdc,lpfontsignature,dword);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTEXTENTPOINT32A, hdc lpcstr int0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  LPCSTR lpcstr;
  int int0;
  SIZE lpsize;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg); // fixme remove this argument, and get string length
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetTextExtentPoint32A(hdc,lpcstr,int0,&lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    pushSTACK( uint32_to_I(lpsize.cy));
    value2 = uint32_to_I(lpsize.cx);
    value3 = popSTACK();
    value1 = T;
    mv_count=3;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTEXTENTPOINT32W, hdc lpcwstr int0 lpsize)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  LPCWSTR lpcwstr;
  int int0;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = popSTACK();
  processSIZE(lpsize,arg0);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = GetTextExtentPoint32W(hdc,lpcwstr,int0,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTEXTENTPOINTA, hdc lpcstr int0 lpsize)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  LPCSTR lpcstr;
  int int0;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = popSTACK();
  processSIZE(lpsize,arg0);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = GetTextExtentPointA(hdc,lpcstr,int0,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTEXTENTPOINTW, hdc lpcwstr int0 lpsize)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  LPCWSTR lpcwstr;
  int int0;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = popSTACK();
  processSIZE(lpsize,arg0);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = GetTextExtentPointW(hdc,lpcwstr,int0,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTFACEA, hdc int0 lpstr)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  LPSTR lpstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = GetTextFaceA(hdc,int0,lpstr);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTFACEW, hdc int0 lpwstr)
{
  object arg;
  int int1;
  HDC hdc;
  int int0;
  LPWSTR lpwstr;
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpwstr = WIDECHAR(arg,encoding);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int1 = GetTextFaceW(hdc,int0,lpwstr);
  end_system_call();
  if(0 <=int1){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int1);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTMETRICSA, hdc lptextmetrica)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  TEXTMETRICA lptextmetrica;
  object arg0 = popSTACK();
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetTextMetricsA(hdc,&lptextmetrica);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    outputTEXTMETRICA(&lptextmetrica,arg0);
    value2 = arg0;
    value1 = T;
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETTEXTMETRICSW, hdc lptextmetricw)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  TEXTMETRICW* lptextmetricw = alloca(sizeof(TEXTMETRICW));
  object arg0;
  arg0 = popSTACK();
  processTEXTMETRICW(lptextmetricw,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processTEXTMETRICW(lptextmetricw,arg0);
  begin_system_call();
  bool0 = GetTextMetricsW(hdc,lptextmetricw);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETVIEWPORTEXTEX, hdc lpsize)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = popSTACK();
  processSIZE(lpsize,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = GetViewportExtEx(hdc,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETVIEWPORTORGEX, hdc lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = GetViewportOrgEx(hdc,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETWINMETAFILEBITS, henhmetafile uint lpbyte int0 hdc)
{
  object arg;
  UINT uint0;
  HENHMETAFILE henhmetafile;
  UINT uint;
  BYTE* lpbyte = alloca(sizeof(BYTE));
  object arg0;
  INT int0;
  HDC hdc;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg0 = popSTACK();
  processBYTE(lpbyte,arg0);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  henhmetafile = TheFpointer(arg)->fp_pointer;
  processBYTE(lpbyte,arg0);
  begin_system_call();
  uint0 = GetWinMetaFileBits(henhmetafile,uint,lpbyte,int0,hdc);
  end_system_call();
  if(0 <=uint0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = uint32_to_I(uint0);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETWINDOWEXTEX, hdc lpsize)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  SIZE* lpsize = alloca(sizeof(SIZE));
  object arg0;
  arg0 = popSTACK();
  processSIZE(lpsize,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processSIZE(lpsize,arg0);
  begin_system_call();
  bool0 = GetWindowExtEx(hdc,lpsize);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETWINDOWORGEX, hdc lppoint)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  POINT* lppoint = alloca(sizeof(POINT));
  object arg0;
  arg0 = popSTACK();
  processPOINT(lppoint,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processPOINT(lppoint,arg0);
  begin_system_call();
  bool0 = GetWindowOrgEx(hdc,lppoint);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETWORLDTRANSFORM, hdc lpxform)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  XFORM* lpxform = alloca(sizeof(XFORM));
  object arg0;
  arg0 = popSTACK();
  processXFORM(lpxform,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  processXFORM(lpxform,arg0);
  begin_system_call();
  bool0 = GetWorldTransform(hdc,lpxform);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:ESCAPE, hdc int0 int1 lpcstr pvoid)
{
  object arg;
  int int2;
  HDC hdc;
  int int0;
  int int1;
  LPCSTR lpcstr;
  void* pvoid;
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_8Bit,arg))argumentum_inritum(arg);
  pvoid = &(TheSbvector(arg)->data);
  arg = popSTACK();
  if(!stringp(arg))argumentum_inritum(arg);
  lpcstr = TheAsciz(string_to_asciz(arg,encoding));
  arg = popSTACK();
  check_sint(arg);
  int1 = I_to_sint32(arg);
  arg = popSTACK();
  check_sint(arg);
  int0 = I_to_sint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int2 = Escape(hdc,int0,int1,lpcstr,pvoid);
  end_system_call();
  if(0 <=int2){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int2);
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
/*
DEFUN( GDI:SETABORTPROC, hdc abortproc)
{
  object arg;
  int int0;
  HDC hdc;
  ABORTPROC abortproc;
  arg0 = popSTACK();
  processABORTPROC(abortproc,arg0);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  int0 = SetAbortProc(hdc,abortproc);
  end_system_call();
  if(0 <=int0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    value2 = sint32_to_I(int0);
    mv_count=2;
  }
  return;
}
*/
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARWIDTHFLOATA, hdc uint uint0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  UINT length;
  FLOAT* pfloat;
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  length = uint0 - uint + 1;
  pfloat = alloca(sizeof(FLOAT)*length);
  begin_system_call();
  bool0 = GetCharWidthFloatA(hdc,uint,uint0,pfloat);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value2 = outputFLOATS(pfloat,length);
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETCHARWIDTHFLOATW, hdc uint uint0 pfloat)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  UINT uint;
  UINT uint0;
  FLOAT* pfloat;
  arg = popSTACK();
  check_uint(arg);
  uint0 = I_to_uint32(arg);
  arg = popSTACK();
  check_uint(arg);
  uint = I_to_uint32(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  pfloat = alloca(sizeof(FLOAT)*(uint0 - uint + 1));
  begin_system_call();
  bool0 = GetCharWidthFloatW(hdc,uint,uint0,pfloat);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value2 = outputFLOATS(pfloat,0);
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:GETMITERLIMIT, hdc pfloat)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  FLOAT pfloat;
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = GetMiterLimit(hdc,&pfloat);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value2 = allocate_ffloat(pfloat);
    value1 = T;
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:SETMITERLIMIT, hdc float0)
{
  object arg;
  BOOL bool0;
  HDC hdc;
  FLOAT float0;
  FLOAT pfloat;
  arg = popSTACK();
  check_ffloat(arg);
  float0 = ffloat_value(arg);
  arg = popSTACK();
  if(!fpointerp(arg))argumentum_inritum(arg);
  hdc = TheFpointer(arg)->fp_pointer;
  begin_system_call();
  bool0 = SetMiterLimit(hdc,float0,&pfloat);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value2 = allocate_ffloat(pfloat);
    value1 = T;
    mv_count=2;
  }
  return;
}
// untested - was never called
// uninspected - compiles but code was not checked
DEFUN( GDI:LINEDDA, lppoint lppoint0 lineddaproc lparam)
{
  object arg;
  BOOL bool0;
  POINT lppoint;
  POINT lppoint0;
  LINEDDAPROC lineddaproc;
  void* lparam;
  arg = popSTACK();
  check_sint(arg);
  lparam = I_to_sint32(arg);
  arg = popSTACK();
  processLINEDDAPROC(lineddaproc,arg);
  arg = popSTACK();
  processPOINT(&lppoint0,arg);
  arg = popSTACK();
  processPOINT(&lppoint,arg);
  begin_system_call();
  bool0 = LineDDA(lppoint.x,lppoint.y,lppoint0.x,lppoint0.y,lineddaproc,lparam);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
// untested - was never called
// Not implemented in Windows NT
/*
DEFUN( GDI:TRANSLATECHARSETINFO, dword_p lpcharsetinfo dword)
{
  object arg;
  BOOL bool0;
  DWORD* dword_p;
  HARSETINFO* lpcharsetinfo = alloca(sizeof(CHARSETINFO));
  object arg0;
  DWORD dword;
  arg = popSTACK();
  check_uint(arg);
  dword = I_to_uint32(arg);
  arg0 = popSTACK();
  processCHARSETINFO(lpcharsetinfo,arg0);
  arg = popSTACK();
  if(!simple_bit_vector_p(Atype_32Bit,arg))argumentum_inritum(arg);
  dword_p = &(TheSbvector(arg)->data);
  processHARSETINFO(lpcharsetinfo,arg0);
  begin_system_call();
  bool0 = TranslateCharsetInfo(dword_p,lpcharsetinfo,dword);
  end_system_call();
  if(!bool0){
    DWORD e;
    begin_system_call();
    e = GetLastError();
    end_system_call();
    value1 = NIL;
    value2 = uint32_to_I(e);
    mv_count=2;
  }
  else
  {
    value1 = T;
    mv_count=1;
  }
  return;
}
*/
