(use-package "GDI")
(defun f ()
  (let* ((hwnd (multiple-value-bind (retval h)
                  (gdi::createfonta (- (gdi::getdevicecaps hdc LOGPIXELSY))
                                    0 0 0 FW_BOLD T NIL NIL ANSI_CHARSET
                                    OUT_TT_PRECIS CLIP_DEFAULT_PRECIS
                                    PROOF_QUALITY VARIABLE_PITCH
                                    "Times New Roman")
                  (if retval h (error "createfonta ~S" h))))
         (x (/ (gdi::getsystemmetrics SM_CXSCREEN) 2))
         (y (/ (gdi::getsystemmetrics SM_CYSCREEN) 2))
         (hold (multiple-value-bind (retval h) (gdi::selectobject hdc hfont)
                 (if retval h (error "getdc ~S" h)))))
     (gdi::settextalign hdc (logior TA_CENTER TA_BASELINE))
     (gdi::setbkmode hdc TRANSPARENT)
     (gdi::settextcolor hdc (gdi::make-rgb 0 0 #xff))
     (gdi::textouta hdc x y "HELLO WORLD" 11)
     (gdi::selectobject hdc hold)
     (gdi::deleteobject hfont)))

(defun onDraw (hdc)
     (gdi::textouta hdc 0 0 "HELLO WORLD" 11))

(defun onKeyDown (wparam lparam) (quit))

(defun main ()
   (add-callbacks WM_NCCREATE (list (cons WM_PAINT #'onDraw) (cons WM_KEYDOWN #'onKeyDown)))
   (let* (
           (cn "HelloWorld")
           (wc (or (gdi::findatoma cn) (gdi::globalfindatoma cn)
                     (multiple-value-bind (retval h)
                      (gdi::registerclassa
                         (gdi::make-wndclass 0 0 0 gdi::*hinstance* NIL
                           (multiple-value-bind (retval h)
                               (gdi::loadcursora NIL (gdi::getidc IDC_ARROW))
                             (if retval h (error "loadcursor ~S" h)))
                           (multiple-value-bind (retval h) (gdi::getstockobject WHITE_BRUSH)
                             (if retval h (error "getstockobject ~S" h)))
                           NIL cn))
                          (if retval h (error "registerclassa ~S" h)))))
           (cr (gdi::make-createstruct 0 wc "Hello World"
                  WS_POPUP 0 0 (/ (gdi::getsystemmetrics SM_CXSCREEN) 2)
                  (/ (gdi::getsystemmetrics SM_CYSCREEN) 2)
                  NIL NIL gdi::*hinstance* NIL))
           (win (multiple-value-bind (retval h) (gdi::createwindowindirecta cr)
                  (if retval h (error "createwindowindirect ~S" h)))))
        (gdi::showwindow win SW_SHOWNORMAL)
        (gdi::updatewindow win)
        (gdi::messageloop)))
(trace gdi:make-wndclass)
(trace gdi:make-createstruct)
(trace gdi::add-callbacks)
(trace onDraw)
(trace gdi::oncreate)
(main)
