------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                      S Y S T E M . V A L _ C H A R                       --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--          Copyright (C) 1992-2010, Free Software Foundation, Inc.         --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
-- As a special exception under Section 7 of GPL version 3, you are granted --
-- additional permissions described in the GCC Runtime Library Exception,   --
-- version 3.1, as published by the Free Software Foundation.               --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with System.Val_Util; use System.Val_Util;

package body System.Val_Char is

   ---------------------
   -- Value_Character --
   ---------------------

   function Value_Character (Str : String) return Character is
      F : Natural;
      L : Natural;
      S : String (Str'Range) := Str;

   begin
      Normalize_String (S, F, L);

      --  Accept any single character enclosed in quotes

      if L - F = 2 and then S (F) = ''' and then S (L) = ''' then
         return Character'Val (Character'Pos (S (F + 1)));

      --  Check control character cases

      else
         for C in Character'Val (16#00#) .. Character'Val (16#1F#) loop
            if S (F .. L) = Character'Image (C) then
               return C;
            end if;
         end loop;

         for C in Character'Val (16#7F#) .. Character'Val (16#9F#) loop
            if S (F .. L) = Character'Image (C) then
               return C;
            end if;
         end loop;

         if S (F .. L) = "SOFT_HYPHEN" then
            return Character'Val (16#AD#);
         end if;

         raise Constraint_Error;
      end if;
   end Value_Character;

end System.Val_Char;
