// 2007-02-04  Edward Smith-Rowland <3dw4rd@verizon.net>
//
// Copyright (C) 2007-2015 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  sph_neumann


//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/

#include <tr1/cmath>
#if defined(__TEST_DEBUG)
#include <iostream>
#define VERIFY(A) \
if (!(A)) \
  { \
    std::cout << "line " << __LINE__ \
      << "  max_abs_frac = " << max_abs_frac \
      << std::endl; \
  }
#else
#include <testsuite_hooks.h>
#endif
#include "../testcase.h"


// Test data for n=0.
testcase_sph_neumann<double> data001[] = {
  { -0.056732437092645263, 0, 5.0000000000000000 },
  { 0.083907152907645249, 0, 10.000000000000000 },
  { 0.050645860857254754, 0, 15.000000000000000 },
  { -0.020404103090669597, 0, 20.000000000000000 },
  { -0.039648112474538942, 0, 25.000000000000000 },
  { -0.0051417149962528020, 0, 30.000000000000000 },
  { 0.025819777288328762, 0, 35.000000000000000 },
  { 0.016673451541306544, 0, 40.000000000000000 },
  { -0.011673821973727327, 0, 45.000000000000000 },
  { -0.019299320569842265, 0, 50.000000000000000 },
  { -0.00040230465930828606, 0, 55.000000000000000 },
  { 0.015873549673585938, 0, 60.000000000000000 },
  { 0.0086531361728949541, 0, 65.000000000000000 },
  { -0.0090474171869471404, 0, 70.000000000000000 },
  { -0.012290016929663325, 0, 75.000000000000000 },
  { 0.0013798405479880946, 0, 80.000000000000000 },
  { 0.011580901686988727, 0, 85.000000000000000 },
  { 0.0049785957347685574, 0, 90.000000000000000 },
  { -0.0076860374841559963, 0, 95.000000000000000 },
  { -0.0086231887228768386, 0, 100.00000000000000 },
};

// Test function for n=0.
template <typename Tp>
void test001()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data001)
                         / sizeof(testcase_sph_neumann<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::sph_neumann(Tp(data001[i].n), Tp(data001[i].x));
      const Tp f0 = data001[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(5.0000000000000028e-11));
}

// Test data for n=1.
testcase_sph_neumann<double> data002[] = {
  { 0.18043836751409864, 1, 5.0000000000000000 },
  { 0.062792826379701516, 1, 10.000000000000000 },
  { -0.039976131953324147, 1, 15.000000000000000 },
  { -0.046667467690914864, 1, 20.000000000000000 },
  { 0.0037081455049293634, 1, 25.000000000000000 },
  { 0.032762996969886965, 1, 30.000000000000000 },
  { 0.012971498479556564, 1, 35.000000000000000 },
  { -0.018210992723451058, 1, 40.000000000000000 },
  { -0.019168385477952129, 1, 45.000000000000000 },
  { 0.0048615106626817301, 1, 50.000000000000000 },
  { 0.018170052158169303, 1, 55.000000000000000 },
  { 0.0053447361795967109, 1, 60.000000000000000 },
  { -0.012587316051033977, 1, 65.000000000000000 },
  { -0.011184829982069090, 1, 70.000000000000000 },
  { 0.0050065549130635621, 1, 75.000000000000000 },
  { 0.012440856180892041, 1, 80.000000000000000 },
  { 0.0022077237839479508, 1, 85.000000000000000 },
  { -0.0098779785318421041, 1, 90.000000000000000 },
  { -0.0072731342338976518, 1, 95.000000000000000 },
  { 0.0049774245238688201, 1, 100.00000000000000 },
};

// Test function for n=1.
template <typename Tp>
void test002()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data002)
                         / sizeof(testcase_sph_neumann<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::sph_neumann(Tp(data002[i].n), Tp(data002[i].x));
      const Tp f0 = data002[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000014e-11));
}

// Test data for n=2.
testcase_sph_neumann<double> data003[] = {
  { 0.16499545760110443, 2, 5.0000000000000000 },
  { -0.065069304993734797, 2, 10.000000000000000 },
  { -0.058641087247919589, 2, 15.000000000000000 },
  { 0.013403982937032370, 2, 20.000000000000000 },
  { 0.040093089935130465, 2, 25.000000000000000 },
  { 0.0084180146932414986, 2, 30.000000000000000 },
  { -0.024707934561509628, 2, 35.000000000000000 },
  { -0.018039275995565374, 2, 40.000000000000000 },
  { 0.010395929608530519, 2, 45.000000000000000 },
  { 0.019591011209603170, 2, 50.000000000000000 },
  { 0.0013933984133902479, 2, 55.000000000000000 },
  { -0.015606312864606103, 2, 60.000000000000000 },
  { -0.0092340892214042153, 2, 65.000000000000000 },
  { 0.0085680673305727519, 2, 70.000000000000000 },
  { 0.012490279126185866, 2, 75.000000000000000 },
  { -0.00091330844120464307, 2, 80.000000000000000 },
  { -0.011502982024025860, 2, 85.000000000000000 },
  { -0.0053078616858299602, 2, 90.000000000000000 },
  { 0.0074563595609802805, 2, 95.000000000000000 },
  { 0.0087725114585929034, 2, 100.00000000000000 },
};

// Test function for n=2.
template <typename Tp>
void test003()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data003)
                         / sizeof(testcase_sph_neumann<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::sph_neumann(Tp(data003[i].n), Tp(data003[i].x));
      const Tp f0 = data003[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(5.0000000000000028e-11));
}

// Test data for n=5.
testcase_sph_neumann<double> data004[] = {
  { -0.32046504674973919, 5, 5.0000000000000000 },
  { 0.093833541678691818, 5, 10.000000000000000 },
  { 0.020475698281859061, 5, 15.000000000000000 },
  { -0.048172347757372780, 5, 20.000000000000000 },
  { -0.018309489232548347, 5, 25.000000000000000 },
  { 0.026639390496569996, 5, 30.000000000000000 },
  { 0.022006038985576210, 5, 35.000000000000000 },
  { -0.011268975348057965, 5, 40.000000000000000 },
  { -0.021770388372274862, 5, 45.000000000000000 },
  { -0.00069711319645853712, 5, 50.000000000000000 },
  { 0.017439589450220897, 5, 55.000000000000000 },
  { 0.0088699170919343089, 5, 60.000000000000000 },
  { -0.010421334444951861, 5, 65.000000000000000 },
  { -0.012746769858008551, 5, 70.000000000000000 },
  { 0.0026282888028967737, 5, 75.000000000000000 },
  { 0.012477658581324189, 5, 80.000000000000000 },
  { 0.0040771816818182642, 5, 85.000000000000000 },
  { -0.0089777759570579801, 5, 90.000000000000000 },
  { -0.0083184557896676149, 5, 95.000000000000000 },
  { 0.0037206784862748965, 5, 100.00000000000000 },
};

// Test function for n=5.
template <typename Tp>
void test004()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data004)
                         / sizeof(testcase_sph_neumann<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::sph_neumann(Tp(data004[i].n), Tp(data004[i].x));
      const Tp f0 = data004[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(5.0000000000000028e-11));
}

// Test data for n=10.
testcase_sph_neumann<double> data005[] = {
  { -26.656114405718704, 10, 5.0000000000000000 },
  { -0.17245367208805784, 10, 10.000000000000000 },
  { 0.078461689849642580, 10, 15.000000000000000 },
  { -0.036843410496289961, 10, 20.000000000000000 },
  { -0.021158339301097472, 10, 25.000000000000000 },
  { 0.031219591064754935, 10, 30.000000000000000 },
  { 0.012840593422414804, 10, 35.000000000000000 },
  { -0.021803068636888072, 10, 40.000000000000000 },
  { -0.014071636804469047, 10, 45.000000000000000 },
  { 0.013524687511158756, 10, 50.000000000000000 },
  { 0.015684932653180592, 10, 55.000000000000000 },
  { -0.0056356895567262122, 10, 60.000000000000000 },
  { -0.015364490270315362, 10, 65.000000000000000 },
  { -0.0014525575672261291, 10, 70.000000000000000 },
  { 0.012648951699549433, 10, 75.000000000000000 },
  { 0.0068571608061120358, 10, 80.000000000000000 },
  { -0.0080151152941401460, 10, 85.000000000000000 },
  { -0.0098139742219019131, 10, 90.000000000000000 },
  { 0.0025002854072314951, 10, 95.000000000000000 },
  { 0.010025777373636153, 10, 100.00000000000000 },
};

// Test function for n=10.
template <typename Tp>
void test005()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data005)
                         / sizeof(testcase_sph_neumann<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::sph_neumann(Tp(data005[i].n), Tp(data005[i].x));
      const Tp f0 = data005[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(5.0000000000000028e-11));
}

// Test data for n=20.
testcase_sph_neumann<double> data006[] = {
  { -926795140.30575454, 20, 5.0000000000000000 },
  { -1211.2106053526034, 20, 10.000000000000000 },
  { -1.5559965765652188, 20, 15.000000000000000 },
  { -0.093401132250914426, 20, 20.000000000000000 },
  { 0.044031985675276435, 20, 25.000000000000000 },
  { -0.036078033606613907, 20, 30.000000000000000 },
  { 0.029828405631319641, 20, 35.000000000000000 },
  { -0.0048414810986760785, 20, 40.000000000000000 },
  { -0.020504694681516944, 20, 45.000000000000000 },
  { 0.013759531302541211, 20, 50.000000000000000 },
  { 0.012783038861734196, 20, 55.000000000000000 },
  { -0.013117009421906418, 20, 60.000000000000000 },
  { -0.010338106075674407, 20, 65.000000000000000 },
  { 0.010538610814111246, 20, 70.000000000000000 },
  { 0.010200029094273743, 20, 75.000000000000000 },
  { -0.0073123450945617122, 20, 80.000000000000000 },
  { -0.010581510354950906, 20, 85.000000000000000 },
  { 0.0036866374015298714, 20, 90.000000000000000 },
  { 0.010498384318338270, 20, 95.000000000000000 },
  { 5.6317293788333982e-05, 20, 100.00000000000000 },
};

// Test function for n=20.
template <typename Tp>
void test006()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data006)
                         / sizeof(testcase_sph_neumann<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::sph_neumann(Tp(data006[i].n), Tp(data006[i].x));
      const Tp f0 = data006[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(1.0000000000000007e-09));
}

// Test data for n=50.
testcase_sph_neumann<double> data007[] = {
  { -6.9641091882698388e+42, 50, 5.0000000000000000 },
  { -4.5282272723512023e+27, 50, 10.000000000000000 },
  { -9.0004902645887027e+18, 50, 15.000000000000000 },
  { -9542541667002.5098, 50, 20.000000000000000 },
  { -363518140.71026677, 50, 25.000000000000000 },
  { -152551.57233157745, 50, 30.000000000000000 },
  { -386.26599186208625, 50, 35.000000000000000 },
  { -4.3290507947291035, 50, 40.000000000000000 },
  { -0.19968460851503764, 50, 45.000000000000000 },
  { -0.041900001504607758, 50, 50.000000000000000 },
  { 0.010696040672421900, 50, 55.000000000000000 },
  { 0.0078198768555268507, 50, 60.000000000000000 },
  { -0.010088474938191242, 50, 65.000000000000000 },
  { 0.0062423671279824801, 50, 70.000000000000000 },
  { 0.0011284242794941733, 50, 75.000000000000000 },
  { -0.0093934266037485562, 50, 80.000000000000000 },
  { 0.013108079602843424, 50, 85.000000000000000 },
  { -0.0075396607225722626, 50, 90.000000000000000 },
  { -0.0042605703552836558, 50, 95.000000000000000 },
  { 0.010747822973682470, 50, 100.00000000000000 },
};

// Test function for n=50.
template <typename Tp>
void test007()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data007)
                         / sizeof(testcase_sph_neumann<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::sph_neumann(Tp(data007[i].n), Tp(data007[i].x));
      const Tp f0 = data007[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000014e-11));
}

// Test data for n=100.
testcase_sph_neumann<double> data008[] = {
  { -1.7997139826259744e+116, 100, 5.0000000000000000 },
  { -8.5732263093296254e+85, 100, 10.000000000000000 },
  { -1.9270658593711675e+68, 100, 15.000000000000000 },
  { -7.2208893582952363e+55, 100, 20.000000000000000 },
  { -2.0868752613007946e+46, 100, 25.000000000000000 },
  { -4.2496124023612646e+38, 100, 30.000000000000000 },
  { -1.7042898348910271e+32, 100, 35.000000000000000 },
  { -6.3021565260724554e+26, 100, 40.000000000000000 },
  { -1.3199917400494369e+22, 100, 45.000000000000000 },
  { -1.1256928913265985e+18, 100, 50.000000000000000 },
  { -309801083340341.00, 100, 55.000000000000000 },
  { -232585620046.64737, 100, 60.000000000000000 },
  { -421135935.93756086, 100, 65.000000000000000 },
  { -1680637.4531202619, 100, 70.000000000000000 },
  { -13868.302591128842, 100, 75.000000000000000 },
  { -227.24385709173322, 100, 80.000000000000000 },
  { -7.2807038787139486, 100, 85.000000000000000 },
  { -0.46648154448250878, 100, 90.000000000000000 },
  { -0.067270772720654542, 100, 95.000000000000000 },
  { -0.022983850491562267, 100, 100.00000000000000 },
};

// Test function for n=100.
template <typename Tp>
void test008()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data008)
                         / sizeof(testcase_sph_neumann<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::sph_neumann(Tp(data008[i].n), Tp(data008[i].x));
      const Tp f0 = data008[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000015e-12));
}

int main(int, char**)
{
  test001<double>();
  test002<double>();
  test003<double>();
  test004<double>();
  test005<double>();
  test006<double>();
  test007<double>();
  test008<double>();
  return 0;
}
