/*
  File autogenerated by gengetopt version 2.2  
  generated with the following command:
  ../src/gengetopt -isample1.ggo -Fcmdline1 --long-help -u 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#include "cmdline1.h"


static void
print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

static void
print_help (void)
{
  print_version ();
  printf ("Usage: %s -iINT|--int-opt=INT [-h|--help] [-V|--version] -sSTRING|--str-opt=STRING -mINT|--my-opt=INT [--flag-opt] [-F|--funct-opt] --long-opt=LONG  [FILES]...\n\
   -h         --help            Print help and exit\n\
   -V         --version         Print version and exit\n\
   -sSTRING   --str-opt=STRING  A string option\n\
   -mINT      --my-opt=INT      Another integer option\n\
   -iINT      --int-opt=INT     A int option\n\
              --flag-opt        A flag option (default=off)\n\
   -F         --funct-opt       A function option\n\
              --long-opt=LONG   A long option\n\
", PACKAGE);
}


static char *
gengetopt_strdup (char * s)
{
  char * n, * pn, * ps = s;
  while (*ps) ps++;
  n = (char *) malloc (1 + ps - s);
  if (n != NULL)
    {
      for (ps=s,pn=n; *ps; ps++,pn++)
        *pn = *ps;
      *pn = 0;
    }
  return n;
}


int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;	

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->str_opt_given = 0 ;
  args_info->my_opt_given = 0 ;
  args_info->int_opt_given = 0 ;
  args_info->flag_opt_given = 0 ;
  args_info->funct_opt_given = 0 ;
  args_info->long_opt_given = 0 ;
#define clear_args() { \
  args_info->str_opt_arg = NULL; \
  args_info->flag_opt_flag = 0;\
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "str-opt",	1, NULL, 's' },
        { "my-opt",	1, NULL, 'm' },
        { "int-opt",	1, NULL, 'i' },
        { "flag-opt",	0, NULL, 0 },
        { "funct-opt",	0, NULL, 'F' },
        { "long-opt",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVs:m:i:F", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          print_help ();
          exit (0);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          print_version ();
          exit (0);

        case 's':	/* A string option.  */
          if (args_info->str_opt_given)
            {
              fprintf (stderr, "%s: `--str-opt' (`-s') option given more than once\n", PACKAGE);
              clear_args ();
              print_help ();
              exit (1);
            }
          args_info->str_opt_given = 1;
          args_info->str_opt_arg = gengetopt_strdup (optarg);
          break;

        case 'm':	/* Another integer option.  */
          if (args_info->my_opt_given)
            {
              fprintf (stderr, "%s: `--my-opt' (`-m') option given more than once\n", PACKAGE);
              clear_args ();
              print_help ();
              exit (1);
            }
          args_info->my_opt_given = 1;
          args_info->my_opt_arg = atoi (optarg);
          break;

        case 'i':	/* A int option.  */
          if (args_info->int_opt_given)
            {
              fprintf (stderr, "%s: `--int-opt' (`-i') option given more than once\n", PACKAGE);
              clear_args ();
              print_help ();
              exit (1);
            }
          args_info->int_opt_given = 1;
          args_info->int_opt_arg = atoi (optarg);
          break;

        
        case 'F':	/* A function option.  */
          if (args_info->funct_opt_given)
            {
              fprintf (stderr, "%s: `--funct-opt' (`-F') option given more than once\n", PACKAGE);
              clear_args ();
              print_help ();
              exit (1);
            }
          args_info->funct_opt_given = 1;
          break;

        
        case 0:	/* Long option with no short option */
          /* A flag option.  */
          if (strcmp (long_options[option_index].name, "flag-opt") == 0)
          {
            args_info->flag_opt_flag = !(args_info->flag_opt_flag);
            break;
          }
          /* A long option.  */
          else if (strcmp (long_options[option_index].name, "long-opt") == 0)
          {
            if (args_info->long_opt_given)
              {
                fprintf (stderr, "%s: `--long-opt' option given more than once\n", PACKAGE);
                clear_args ();
                print_help ();
                exit (1);
              }
            args_info->long_opt_given = 1;
            args_info->long_opt_arg = atol (optarg);
            break;
          }

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (1);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if (! args_info->int_opt_given)
    {
      fprintf (stderr, "%s: `--int-opt' (`-i') option required!\n", PACKAGE);
      missing_required_options = 1;
    }

  if ( missing_required_options )
    exit (1);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = strdup (argv[optind++]) ; 
    }

  return 0;
}
