# x86 architecture documentation

This section contains documentation about coreboot on x86 architecture.

* [x86 PAE support](pae.md)

## State of x86_64 support
At the moment there's no single board that supports x86_64 or to be exact
`ARCH_RAMSTAGE_X86_64` and `ARCH_ROMSTAGE_X86_64`.

In order to add support for x86_64 the following assumptions are made:
* The CPU supports long mode
* All memory returned by malloc must be below 4GiB in physical memory
* All code that is to be run must be below 4GiB in physical memory
* The high dword of pointers is always zero
* The reference implementation is qemu
* The CPU supports 1GiB hugepages

## Assuptions for all stages using the reference implementation
* 0-4GiB are identity mapped using 2MiB-pages as WB
* Memory above 4GiB isn't accessible
* page tables reside in memory mapped ROM
* A stage can install new page tables in RAM

## Page tables
Page tables are generated by a tool in `util/pgtblgen/pgtblgen`. It writes
the page tables to a file which is then included into the CBFS as file called
`pagetables`.

To generate the static page tables it must know the physical address where to
place the file.

The page tables contains the following structure:
* PML4E pointing to PDPE
* PDPE with *$n* entries each pointing to PDE
* *$n* PDEs with 512 entries each

At the moment *$n* is 4, which results in identity mapping the lower 4 GiB.

## Steps to add basic support for x86_64
* Add x86_64 toolchain support - *DONE*
* Fix compilation errors - *DONE*
* Fix linker errors - *TODO*
* Add x86_64 rmodule support - *DONE*
* Add x86_64 exception handlers - *TODO*
* Setup page tables for long mode - *DONE*
* Add assembly code for long mode - *DONE*
* Add assembly code for postcar stage - *TODO*
* Add assembly code to return to protected mode - *TODO*
* Implement reference code for mainboard `emulation/qemu-q35` - *TODO*

## Porting other boards
* Fix compilation errors
* Test how well CAR works with x86_64 and paging
* Improve mode switches
* Test libgfxinit / VGA Option ROMs / FSP
