/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2017 Intel Corporation
 * (Written by Naresh G Solanki <naresh.solanki@intel.com> for Intel Corp.)
 * Copyright (C) 2019 Maxim Polyakov <max.senia.poliak@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <device/azalia_device.h>

const u32 cim_verb_data[] = {
	/* coreboot specific header ALC887 */
	0x10ec0887, /* Codec Vendor / Device ID: Realtek */
	0x10438445, /* Subsystem ID */
	15, /* Number of 4 dword sets */
	AZALIA_SUBVENDOR(0x0, 0x10438445),
	AZALIA_PIN_CFG(0x0, 0x11, 0x40000000),
	AZALIA_PIN_CFG(0x0, 0x12, 0x411111f0),
	AZALIA_PIN_CFG(0x0, 0x14, 0x01014020),
	AZALIA_PIN_CFG(0x0, 0x15, 0x90170110),
	AZALIA_PIN_CFG(0x0, 0x16, 0x411111f0),
	AZALIA_PIN_CFG(0x0, 0x17, 0x411111f0),
	AZALIA_PIN_CFG(0x0, 0x18, 0x01a19040),
	AZALIA_PIN_CFG(0x0, 0x19, 0x02a19050),
	AZALIA_PIN_CFG(0x0, 0x1a, 0x0181304f),
	AZALIA_PIN_CFG(0x0, 0x1b, 0x02214030),
	AZALIA_PIN_CFG(0x0, 0x1c, 0x411111f0),
	AZALIA_PIN_CFG(0x0, 0x1d, 0x4026c629),
	AZALIA_PIN_CFG(0x0, 0x1e, 0x411111f0),
	AZALIA_PIN_CFG(0x0, 0x1f, 0x411111f0),

	/* coreboot specific header */
	0x80862809, /* Codec Vendor / Device ID: Intel Skylake HDMI */
	0x80860101,
	0x00000004,
	/* NID 0x01, HDA Codec Subsystem ID Verb Table: 0x80860101 */
	AZALIA_SUBVENDOR(0x2, 0x80860101),

	/* Pin Complex (NID 0x05) Digital Out at Int HDMI */
	AZALIA_PIN_CFG(0x2, 0x05, 0x18560010),

	/* Pin Complex (NID 0x06) Digital Out at Int HDMI */
	AZALIA_PIN_CFG(0x2, 0x06, 0x18560020),

	/* Pin Complex (NID 0x07) Digital Out at Int HDMI */
	AZALIA_PIN_CFG(0x2, 0x07, 0x18560030)
};

const u32 pc_beep_verbs[] = {
};
AZALIA_ARRAY_SIZES;
