/*$Id: mg_out_root.cc,v 21.14 2002/03/26 09:20:13 al Exp $ -*- C++ -*-
 * Copyright (C) 2001 Albert Davis
 * Author: Albert Davis <aldavis@ieee.org>
 *
 * This file is part of "Gnucap", the Gnu Circuit Analysis Package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "mg_out.h"
/*--------------------------------------------------------------------------*/
static void make_header(std::ofstream& out, const File& in,
			const std::string& dump_name)
{
  out << in.head()
      << "/* This file is automatically generated. DO NOT EDIT */\n"
      << in.cc_headers()
      << "#include \"ap.h\"\n"
    "#include \"" << dump_name << ".h\"\n"
    "/*--------------------------------------"
    "------------------------------------*/\n"
    "const double NA(NOT_INPUT);\n"
    "const double INF(BIGBIG);\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_tail(std::ofstream& out, const File& in)
{
  out << in.cc_direct() <<
    "/*--------------------------------------"
    "------------------------------------*/\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
void make_cc_file(const File& in)
{
  std::string dump_name = in.name();
  {
    std::string::size_type loc = dump_name.rfind(".model");
    if (loc != std::string::npos) {
      dump_name.erase(loc);
    }else{
      untested();
    }
  }
  std::ofstream out((dump_name+".cc").c_str());
  if (!out) {
    untested();
    os_error(dump_name);
  }
  {
    std::string::size_type loc = dump_name.find("../");
    if (loc != std::string::npos) {
      dump_name.erase(loc,3);
    }
  }
  make_header(out, in, dump_name);

  {for (Model_List::const_iterator
	 m = in.models().begin();  m != in.models().end();  ++m) {
    make_cc_model(out, **m);
  }}
  {for (Device_List::const_iterator
	 m = in.devices().begin();  m != in.devices().end();  ++m) {
    out << "int DEV_" << (**m).name() << "::_count = 0;\n"
      "int COMMON_" << (**m).name() << "::_count = -1;\n"
      "static COMMON_" << (**m).name() << " Default_" << (**m).name() 
	<< "(CC_STATIC);\n"
      "/*--------------------------------------"
      "------------------------------------*/\n";
    make_cc_common(out, **m);
    make_cc_dev(out, **m);
  }}
  make_tail(out, in);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
