                       Welcome to GNUnet

ToC
===

* ToC
* What is GNUnet?
* Joining GNU
* Dependencies
  o Build tools
  o Dependencies of GNUnet
  o Dependencies of optional components/functionality
  o Test suite dependencies
  o Recommended developer tools
* Notes on setuid
* Scope of Operating System support
* How to install
  o binary packages
  o Building GNUnet from source
  o Notes on compiling from Git
* Configuration
* Usage
* Hacking GNUnet
* Running HTTP on port 80 and HTTPS on port 443
* Further Reading
* Stay tuned


What is GNUnet?
===============

GNUnet is peer-to-peer framework providing a network abstractions and
applications focusing on security and privacy.  So far, we have
created applications for anonymous file-sharing, decentralized naming
and identity management, decentralized and confidential telephony and
tunneling IP traffic over GNUnet.  GNUnet is currently developed by a
worldwide group of independent free software developers.  GNUnet is a
GNU package (http://www.gnu.org/).

This is an ALPHA release.  There are known and significant bugs as
well as many missing features in this release.

GNUnet is free software released under the GNU Affero General Public
License (v3 or later). For details see the COPYING file in this
directory.  If you fork this software, you MUST adjust GNUNET_AGPL_URL
in src/include/gnunet_util_lib.h to point to the source code of your
fork!

Additional documentation about GNUnet can be found at
https://gnunet.org/ and in the 'doc/' folder.
Online documentation is provided at
'https://docs.gnunet.org' and 'https://tutorial.gnunet.org'.


Joining GNU
===========

This is a GNU program, developed by the GNU Project and part of the
GNU Operating System. If you are the author of an awesome program and
want to join us in writing Free Software, please consider making it an
official GNU program and become a GNU maintainer.  You can find
instructions on how to do so at http://www.gnu.org/help/evaluation.
We are looking forward to hacking with you!


Dependencies:
=============

The dependencies for building GNUnet will require around 0.74 GiB
diskspace. GNUnet itself will require 8 - 9.2 MiB depending on
configuration.

Build tools for compiling GNUnet from source:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

- gcc or clang
- meson              >= 1.0.0
- recutils           >= 1.0         (building from git)
- libtool            >= 2.2
- makeinfo           >= 4.8
- make[*3]
- pkgconf or pkg-config
- sphinx
- sphinx-rtd-theme
- sphinx-multiversion

Direct dependencies of GNUnet:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

- Bash                              (for some scripts)
- gettext            >= 0.21
- gnutls             >= 3.2.12      (highly recommended a gnutls
                                     linked against libunbound)
- libcurl            >= 7.85.0      (ideally built against gnutls)
- libgcrypt          >= 1.6
- libgmp             any            (is also an indirect dependency of gcrypt)
- libunistring       >= 0.9.2
- libidn:
  * libidn2 (preferred)
  or
  * libidn           >= 1.0
- libmicrohttpd      >= 0.9.63
- libjansson
- nss                               (certutil binary, for
                                     gnunet-gns-proxy-setup-ca)
- openssl            >= 1.0         (binary, used to generate
                                     X.509 certificate
                                     for gnunet-gns-proxy-setup-ca)
- libltdl            >= 2.2         (part of GNU libtool)
- sqlite             >= 3.35.0      (default database, required)
- which                             (contrib/apparmor(?), gnunet-bugreport,
                                     and possibly more)
- zlib
- libsodium          >= 1.0.17      (for elliptic curve cryptography)
- certtool (gnutls or openssl)      (certtool binary (for convenient
                                     installation of GNS proxy))

Dependencies of optional components/functionality:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
- Database plugins (alternatives to sqlite):
  * postgres         >= 9.5
- Transport plugins:
  * bluez (bluetooth transport)
- Conversation service:
  * libopus            >= 1.0.1
  * libpulse           >= 2.0
  * libogg             >= 1.3.0
- File-sharing metadata (highly recommended[*5]):
  * libextractor       >= 0.6.1
- NAT uPnP support:
  * miniupnpc
- gnunet-qr (Read/write GNUnet URIs from/to QR codes):
  * libzbar            >= 0.10
- gnunet-bcd (GNS business card generator):
  * TeX Live           >= 2012        (for gnunet-bcd[*])
- Documentation:
  * TeX Live           >= 2012        (for gnunet-bcd[*])

- PABC credential support
  * libpabc            any            (for re:claimID zero-knowledge privacy
                                      credentials)
- re:claimID OpenID Connect plugin
  * libjose            any            (for re:claimID OpenID Connect support)


Additional dependencies to run the GNUnet testsuite:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

- Bash                              (for some tests[*4])
- A Posix Shell                     (for some tests)
- python             >= 3.4         (3.4 and higher technically supported,
                                     at least python 3.7 tested to work)
- base tools
  - mostly:
    - bc,
    - curl,
    - sed,
    - awk,
    - which


Recommended software for developer tools:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

- awk                               (for linting tests)
- Bash                              (for Docker and Vagrant)
- grof                              (for linting of man pages)
- mandoc                            (for linting of man pages, generation of
                                     html output of man pages (not part of
                                     the regular build))
- perl5                             (for some utilities)


[*] Mandatory for compiling the info output of the documentation,
    a limited subset ('texlive-tiny' in Guix) is enough.

[*1] The default configuration is to build the info output of the
     documentation, and therefore require sphinx.  You can pass
     '--disable-documentation' to the configure script to change this.

[*3] GNU make introduced the != operator in version 4.0.
     GNU make was released in october 2013, reasonable to
     be widespread by now. If this is not working out for
     you, open a bug so that we can get a more portable
     fix in.

[*4] We are committed  to portable tools and solutions
     where possible. New scripts should be Posix sh
     compatible, current and older scripts are
     in the process of being rewritten to comply
     with this requirement.

[*5] While libextractor ("LE") is optional, it is recommended to
     build gnunet against it. If you install it later,
     you won't benefit from libextractor.
     If you are a distributor, we recommend to split
     LE into basis + plugins rather than making LE
     an option as an afterthought by the user.
     LE itself is very small, but its dependency chain
     on first, second, third etc level can be big.
     There is a small effect on privacy if your LE build
     differs from one which includes all
     plugins (plugins are build as shared objects):
     if users publish a directory with a mixture of file
     types (for example mpeg, jpeg, png, gif) the
     configuration of LE could leak which plugins are
     installed for which filetypes are not providing
     more details.
     However, this leak is just a minor concern.

Notes on setuid
===============

For a correct functionality depending on the host OS, you need
to run the equivalent of these steps after installation.
Replace $(DESTDIR)$(libexecdir) with the appropriate paths,
for example /usr/local/lib/gnunet/libexec/. Note that this
obviously must be run as privileged user.

chown root:root $(DESTDIR)$(libexecdir)/gnunet-helper-vpn
chmod u+s $(DESTDIR)$(libexecdir)/gnunet-helper-vpn
chown root:root $(DESTDIR)$(libexecdir)/gnunet-helper-transport-wlan
chmod u+s $(DESTDIR)$(libexecdir)/gnunet-helper-transport-wlan
chown root:root $(DESTDIR)$(libexecdir)/gnunet-helper-transport-bluetooth
chmod u+s $(DESTDIR)$(libexecdir)/gnunet-helper-transport-bluetooth
chown root $(DESTDIR)$(libexecdir)/gnunet-helper-dns
chgrp $(GNUNETDNS_GROUP) $(DESTDIR)$(libexecdir)/gnunet-helper-dns
chmod 4750 $(DESTDIR)$(libexecdir)/gnunet-helper-dns
chgrp $(GNUNETDNS_GROUP) $(DESTDIR)$(libexecdir)/gnunet-service-dns
chown gnunet:$(GNUNETDNS_GROUP) $(DESTDIR)$(libexecdir)/gnunet-service-dns
chmod 2750 $(DESTDIR)$(libexecdir)/gnunet-service-dns
chown root:root $(DESTDIR)$(libexecdir)/gnunet-helper-exit
chmod u+s $(DESTDIR)$(libexecdir)/gnunet-helper-exit
chown root:root $(DESTDIR)$(libexecdir)/gnunet-helper-nat-server
chown root:root $(DESTDIR)$(libexecdir)/gnunet-helper-nat-client
chmod u+s $(DESTDIR)$(libexecdir)/gnunet-helper-nat-server
chmod u+s $(DESTDIR)$(libexecdir)/gnunet-helper-nat-client


Scope of Operating System support
=================================

We actively support GNUnet on a broad range of Free Software Operating
Systems.

For proprietary Operating Systems, like for example Microsoft Windows
or Apple OS X, we accept patches if they don't break anything for
other Operating Systems.
If you are implementing support for a proprietary Operating System,
you should be aware that progress in our codebase could break
functionality on your OS and cause unpredicted behavior we can
not test. However, we do not break support on Operating Systems
with malicious intent.
Regressions which do occur on these Operating Systems are 3rd
class issues and we expect users and developers of these
Operating Systems to send proposed patches to fix regressions.

For more information about our stand on some of the motivating
points here, read the 'Philosophy' Chapter of our handbook.


How to install?
===============

binary packages
~~~~~~~~~~~~~~~

We recommend to use binary packages provided by the package manager integrated
within your Operating System. GNUnet is reportedly available for at least:

ALT Linux, Archlinux, Debian, Deepin, Devuan, GNU Guix, Hyperbola,
Kali Linux, LEDE/OpenWRT, Manjaro, Nix, Parabola, Pardus, Parrot,
PureOS, Raspbian, Rosa, Trisquel, and Ubuntu.

If GNUnet is available for your Operating System and it is missing,
send us feedback so that we can add it to this list. Furthermore, if
you are interested in packaging GNUnet for your Operating System,
get in touch with us at gnunet-developers@gnu.org if you require
help with this job.

If you were using an Operating System with the apt package manager,
GNUnet could be installed as simple as:

$ apt-get install gnunet

Generic installation instructions are in the INSTALL file in this
directory.

Building GNUnet from source
~~~~~~~~~~~~~~~~~~~~~~~~~~~

IMPORTANT: You can read further notes about compilation from source in
the handbook under doc/handbook/, which includes notes about specific
requirements for operating systems as well. If you are a package
maintainer for an Operating System we invite you to add your notes if
you feel it is necessary and can not be covered in your Operating
System's documentation.

Two prominent examples which currently lack cross-compilation
support in GNUnet (and native binaries) are MS Windows and Apple macOS.
For macOS we recommend you to do the build process via Homebrew and a
recent XCode installation. We don't recommend using GNUnet with any
recent MS Windows system as it officially spies on its users (according
to its T&C), defying some of the purposes of GNUnet.

Note that some functions of GNUnet require "root" access.  GNUnet will
install (tiny) SUID binaries for those functions is you install as root.
If you do not, GNUnet will still work, but some
functionality will not be available (including certain forms of NAT
traversal).

GNUnet requires the GNU MP library (https://www.gnu.org/software/gmp/)
and libgcrypt (https://www.gnupg.org/).  You can specify the path to
libgcrypt by passing "--with-gcrypt=PATH" to configure.

If you install from source, you need to install GNU libextractor first
(download from https://www.gnu.org/software/libextractor/).  We also
recommend installing GNU libmicrohttpd (download from
https://www.gnu.org/software/libmicrohttpd/). Furthermore we recommend
libgnurl (from https://gnunet.org/en/gnurl.html).
Then you can start the actual GNUnet compilation process with:


$ export GNUNET_PREFIX=/usr/local/lib # or other directory of your choice
# addgroup gnunetdns
# adduser --system --home "/var/lib/gnunet" --group gnunet --shell /bin/sh
# meson setup -Dprefix=$GNUNET_PREFIX/.. -C $BUILDDIR
$ meson compile -C $BUILDDIR

You can alternatively also use the configure script and Makefile:

$ ./configure --prefix=$GNUNET_PREFIX/..
$ make

And finally install GNUnet with:

# meson install -C $BUILDDIR

or

# make install

Complete the process by either adjusting one of our example service files
in 'contrib/services' or by running:

# sudo -u gnunet gnunet-arm -s


Note that you must read paragraph "Notes on setuid", which documents steps you
have to follow after the installation, as a privileged user. We require some
binaries to be setuid. The most portable approach across all supported
platforms and targets is to let this be handled manually.
The installation will work if you do not run these steps as root, but some
components may not be installed in the perfect place or with the right
permissions and thus won't work.

This will create the users and groups needed for running GNUnet
securely and then compile and install GNUnet to $GNUNET_PREFIX/../bin/,
$GNUNET_PREFIX/ and $GNUNET_PREFIX/../share/ and start the system
with the default configuration.  It is strongly recommended that you
add a user "gnunet" to run "gnunet-arm".  You can then still run the
end-user applications as another user.

If you create a system user "gnunet", it is recommended that you edit
the configuration file slightly so that data can be stored in the
system user home directory at "/var/lib/gnunet".  Depending on what
the $HOME-directory of your "gnunet" user is, you might need to set
the SERVICEHOME option in section "[PATHS]" to "/var/lib/gnunet" to
do this.  Depending on your personal preferences, you may also want to
use "/etc/gnunet.conf" for the location of the configuration file in
this case (instead of ~gnunet/.config/gnunet.conf").  In this case,
you need to start GNUnet using "gnunet-arm -s -c /etc/gnunet.conf" or
set "XDG_CONFIG_HOME=/etc/".

You can avoid running 'make install' as root if you have extensive sudo rights
(can run "chmod +s" and "chown" via 'sudo').  If you run 'make install' as a
normal user without sudo rights (or the configure option), certain binaries
that require additional privileges will not be installed properly (and
autonomous NAT traversal, WLAN, DNS/GNS and the VPN will then not work).

If you run 'configure' and 'make install' as root, GNUnet's build system will
install "libnss_gns*" libraries to "/lib/" regardless (!) of the
$GNUNET_PREFIX you might have specified, as those libraries must be in
"/lib/".  If you are packaging GNUnet for binary distribution, this may cause
your packaging script to miss those plugins, so you might need to do some
additional manual work to include those libraries in your binary package(s).
Similarly, if you want to use the GNUnet Name System and did NOT run
GNUnet's 'make install' process with privileged rights, the libraries will be
installed to "$GNUNET_PREFIX" and you will have to move them to "/lib/"
manually.

Configuration
=============

Note that additional, per-user configuration files can be created by
each user.  However, this is usually not necessary as there are few
per-user options that normal users would want to modify.  The defaults
that are shipped with the installation are usually just fine.

The gnunet-setup tool is particularly useful to generate the master
configuration for the peer.  gnunet-setup can be used to configure and
test (!) the network settings, choose which applications should be run
and configure databases.  Other options you might want to control
include system limitations (such as disk space consumption, bandwidth,
etc).  The resulting configuration files are human-readable and can
theoretically be created or edited by hand.

gnunet-setup is a separate download and requires somewhat recent
versions of GTK+ and Glade. You can also create the configuration file
by hand, but this is not recommended.  For more general information
about the GNU build process read the INSTALL file.

GNUnet uses two types of configuration files, one that specifies the
system-wide defaults (typically located in
$GNUNET_PREFIX/../share/gnunet/config.d/) and a second one that overrides
default values with user-specific preferences.  The user-specific
configuration file should be located in "~/.config/gnunet.conf" or its
location can be specified by giving the "-c" option to the respective
GNUnet application.

For more information about the configuration (as well as usage) refer
to the 'GNUnet User Handbook' chapter of the documentation, included
in this software distribution.


Usage
=====

For detailed usage notes, instructions and examples, refer to the
included 'GNUnet Handbook'.

First, you must obtain an initial list of GNUnet hosts.  Knowing a
single peer is sufficient since after that GNUnet propagates
information about other peers.  Note that the default configuration
contains URLs from where GNUnet downloads an initial hostlist
whenever it is started.  If you want to create an alternative URL for
others to use, the file can be generated on any machine running
GNUnet by periodically executing

$ cat $SERVICEHOME/data/hosts/* > the_file

and offering 'the_file' via your web server.  Alternatively, you can
run the built-in web server by adding '-p' to the OPTIONS value
in the "hostlist" section of gnunet.conf and opening the respective
HTTPPORT to the public.

If the solution with the hostlist URL is not feasible for your
situation, you can also add hosts manually.  Simply copy the hostkeys
to "$SERVICEHOME/data/hosts/" (where $SERVICEHOME is the directory
specified in the gnunet.conf configuration file).  You can also use
"gnunet-peerinfo -g" to GET a URI for a peer and "gnunet-peerinfo -p
URI" to add a URI from another peer.  Finally, GNUnet peers that use
UDP or WLAN will discover each other automatically (if they are in the
vicinity of each other) using broadcasts (IPv4/WLAN) or multicasts
(IPv6).

The local node is started using "gnunet-arm -s".  We recommend to run
GNUnet 24/7 if you want to maximize your anonymity, as this makes
partitioning attacks harder.

Once your peer is running, you should then be able to access GNUnet
using the shell:

$ gnunet-search KEYWORD

This will display a list of results to the console.  You can abort
the command using "CTRL-C".  Then use

$ gnunet-download -o FILENAME GNUNET_URI

to retrieve a file.  The GNUNET_URI is printed by gnunet-search
together with a description.  To publish files on GNUnet, use the
"gnunet-publish" command.


The GTK user interface is shipped separately.
After installing gnunet-gtk, you can invoke the setup tool and
the file-sharing GUI with:

$ gnunet-setup
$ gnunet-fs-gtk

For further documentation, see our webpage or the 'GNUnet User Handbook',
included in this software distribution.


Hacking GNUnet
==============

Contributions are welcome. Please submit bugs you find to
https://bugs.gnunet.org/ or our bugs mailinglist.
Please make sure to run the script "contrib/scripts/gnunet-bugreport"
and include the output with your bug reports.  More about how to
report bugs can be found in the GNUnet FAQ on the webpage.  Submit
patches via E-Mail to gnunet-developers@gnu.org, formatted with
`git format-patch`.

In order to run the unit tests by hand (instead of using "make check"),
you need to set the environment variable "GNUNET_PREFIX" to the
directory where GNUnet's libraries are installed.
Before running any testcases, you must complete the installation.

Quick summary:

$ meson setup -Dprefix=$SOMEWHERE $BUILDDIR
$ meson compile -C $BUILDDIR
$ make install -C $BUILDDIR
$ export $GNUNET_PREFIX=$SOMEWHERE
$ meson test -C $BUILDDIR

If any testcases fail to pass on your system, run
"contrib/scripts/gnunet-bugreport" (in the repository) or "gnunet-bugreport"
when you already have GNUnet installed and report its output together with
information about the failing testcase(s) to the Mantis bugtracking
system at https://bugs.gnunet.org/.


Running HTTP on port 80 and HTTPS on port 443
=============================================

In order to hide GNUnet's HTTP/HTTPS traffic perfectly, you might
consider running GNUnet's HTTP/HTTPS transport on port 80/443.
However, we do not recommend running GNUnet as root.  Instead, forward
port 80 to say 1080 with this command (as root, in your startup
scripts):

# iptables -t nat -A PREROUTING -p tcp -m tcp --dport 80 -j REDIRECT --to-ports 1080

or for HTTPS

# iptables -t nat -A PREROUTING -p tcp -m tcp --dport 443 -j REDIRECT --to-ports 4433

Then set in the HTTP section of gnunet.conf the "ADVERTISED_PORT" to
"80" and "PORT" to 1080 and similarly in the HTTPS section the
"ADVERTISED_PORT" to "443" and "PORT" to 4433.

You can do the same trick for the TCP and UDP transports if you want
to map them to a privileged port (from the point of view of the
network).  However, we are not aware of this providing any advantages
at this point.

If you are already running an HTTP or HTTPS server on port 80 (or 443),
you may be able to configure it as a "ReverseProxy".  Here, you tell
GNUnet that the externally visible URI is some sub-page on your website,
and GNUnet can then tunnel its traffic via your existing HTTP server.
This is particularly powerful if your existing server uses HTTPS, as
it makes it harder for an adversary to distinguish normal traffic to
your server from GNUnet traffic.  Finally, even if you just use HTTP,
you might benefit (!) from ISP's traffic shaping as opposed to being
throttled by ISPs that dislike P2P.  Details for configuring the
reverse proxy are documented on our website.


Further Reading
===============

* Documentation

  An HTML version of the GNUnet manual is deployed at

    https://docs.gnunet.org

  which currently displays just GNUnet documentation. In the future
  we will add more reading material.

* Academia / papers

  In almost 20 years various people in our community have written and
  collected a good number of papers which have been implemented in
  GNUnet or projects around GNUnet.
  There are currently 2 ways to get them:

  * Using git (NOTE: 1.1 GiB as of 2019-03-09):
    git clone https://git.gnunet.org/bibliography.git
  * Using the webbrowser:
    https://bib.gnunet.org/

Notes on Packaging
==================

* GNUnet installs binaries which should not be called by the user into
  $PREFIX/lib/gnunet/libexec. This folder must not be confused with the
  $PREFIX/libexec. GNUnet does not install anything into the libexec dir
  to compliant with https://refspecs.linuxfoundation.org/FHS_3.0/fhs/ch04s07.html

Stay tuned
==========

* https://gnunet.org/
* https://bugs.gnunet.org
* https://git.gnunet.org
* http://www.gnu.org/software/gnunet/
* http://mail.gnu.org/mailman/listinfo/gnunet-developers
* http://mail.gnu.org/mailman/listinfo/help-gnunet
* http://mail.gnu.org/mailman/listinfo/info-gnunet
* http://mail.gnu.org/mailman/listinfo/gnunet-svn
