/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VrAudioEncoder_H_
#define _VrAudioEncoder_H_
#include <math.h>

#include <../G711_G721_G723/g72x.h>


#include <VrDecimatingSigProc.h>

int pack_output(unsigned,int,char *);
const unsigned outputBytes=120; //120 is smallest number divisible by 3,4,5,8,
const int headerSize=3;
const unsigned outputBlockSize=outputBytes+headerSize;

 #if defined (ENABLE_MMX)
 #include <VrMMX.h>
 #endif


// ********************************************************

// FIXME why is this a subclass of VrDecimatingSigProc instead of VrSigProc???

 template<class iType> 
 class VrAudioEncoder : public VrDecimatingSigProc<iType,iType> {
   short blockNum;
   int position;
   int enc_bits;
   int in_coding;
   struct g72x_state	state;
   int (*enc_routine)(int, int, g72x_state *);
 protected:

 #if defined (ENABLE_MMX)
   mmxTaps** processedTaps; //Precomputed constants, shifted four times
 #endif

 public: 
   VrAudioEncoder(int bits){

     enc_bits=bits;
     in_coding = AUDIO_ENCODING_ULAW;
     g72x_init_state(&state);

     switch (bits){
     case 3:
       enc_routine = g723_24_encoder;
       break;
     case 4:
       enc_routine = g721_encoder;
       break;
     case 5:
       enc_routine = g723_40_encoder;
       break;
     } 
   } 
   virtual const char *name() { return "VrAudioEncoder"; } 
   virtual int work(VrSampleRange output, iType *o[],
		    VrSampleRange inputs[], iType *i[]);
   virtual int forecast(VrSampleRange output, VrSampleRange inputs[]); 
   virtual void initialize(); 
 int num;
 };

 template<class iType> int
 VrAudioEncoder<iType>::forecast(VrSampleRange output,
				 VrSampleRange inputs[]) {

   double inbits= sizeof(iType)*8;
   double ratio = inbits/double(enc_bits);
   int numBlocks=output.size/outputBlockSize;

   inputs[0].size=(unsigned long)(numBlocks*outputBytes*ratio); 
   inputs[0].index=(unsigned)(double(output.index)*ratio); 
   //inputs[0].size=(unsigned)ceil(ratio*double(output.size)); 
   cout <<"ratio= "<<ratio<<" numblocks= "<< numBlocks<<" to get outputsize of "<<output.size<<" starting at " <<output.index<< " you need "<<inputs[0].size<< " starting at "<<inputs[0].index<<endl; 
   return 0;
} 

template<class iType> int
VrAudioEncoder<iType>::work(VrSampleRange output, iType *o[],
			    VrSampleRange inputs[], iType *i[]) {

  int numBlocks=output.size/outputBlockSize;
  cout <<__FUNCTION__<<" starting output.size ="<<output.size<<" numblocks= "<<numBlocks<<endl;  
  
  iType *curOutPos=o[0];
  iType *curInPos=i[0];
  char code;
  unsigned int	out_buffer = 0;
  int		out_bits = 0;
  char		out_byte;
  
  unsigned bytes_written=0,total_bytes_written=0;;

  for (int count=0;count<numBlocks;count++){
   *curOutPos=(char)(enc_bits); //put the encoding scheme in
   curOutPos++;
   *curOutPos=(char)(blockNum>>8); //put upper 8 bits into place
   curOutPos++;
   *curOutPos=(char)(blockNum);
   curOutPos++; //now its at the real start of the data...
   blockNum++;
   bytes_written=headerSize;

   while (bytes_written<outputBlockSize){
     code = (*enc_routine)(*curInPos,
			   in_coding, &state);
     //     cout <<"read "<<out_bits<<endl;
     curInPos++;
     //actually outputs the byte
     out_buffer |= (code << out_bits);
     out_bits += enc_bits;
     if (out_bits >= 8) {
       out_byte = out_buffer & 0xff;
       out_bits -= 8;
       out_buffer >>= 8;
       //cout <<"write"<<out_bits<<endl;
       *(curOutPos++)=out_byte;
       bytes_written++;
     }

   }
   total_bytes_written+=bytes_written;
  }   

  if (total_bytes_written !=output.size)
    cout <<__FUNCTION__<<" not outputting correct amount of data "<<bytes_written <<" instead of "<<output.size<<endl;

  cout <<__FUNCTION__<<" ending"<<endl;

  return output.size;
  
}
  



template<class iType> 
void VrAudioEncoder<iType>::initialize()
{
  setOutputSize(outputBlockSize); 
  blockNum=0;
}

#endif
