#ifndef _CBRADIO_H_
#define _CBRADIO_H_

#include <qwidget.h>

#include <VrTypes.h>

class Tuner;
class QLCDNumber;
class QButton;
class QwtKnob;

template<class oType> class VrAR5000Source;
template<class iType> class VrComplexFIRfilter;
template<class oType> class VrComplexCascadefilter;
template<class iType, class oType> class VrRealFIRfilter;
template<class oType> class VrAmplitudeDemod;
template<class iType> class VrAudioSink;

class CBRadio : public QWidget
{
  Q_OBJECT

  Tuner *tuner;
  QLCDNumber *disp;
  QwtKnob *vol;
  QwtKnob *squelch;
  QButton *chanUp;
  QButton *chanDown;
  QButton *talk;

  VrAR5000Source<char> *source;
  VrComplexFIRfilter<char> *chanFilter;
  VrComplexCascadefilter<complex> *cascFilter;
  VrAmplitudeDemod<float> *demod;
  VrRealFIRfilter<float, short> *ifFilter;
  VrAudioSink<short> *audio;

public:
  CBRadio(VrAR5000Source<char> *source, 
	  QWidget *p = 0, const char *name = 0);
  ~CBRadio();

private slots:
  void run();

public slots:
  void setChannel(int channel);
  void setVolume(double vol);
  
};

#endif
