// -*- verilog -*-
//
//  USRP - Universal Software Radio Peripheral
//
//  Copyright (C) 2003 Matt Ettus
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

// Clock, enable, and reset controls for whole system

module master_control
  ( input master_clk,
    input usbclk,

    input [7:0] master_controls,

    output tx_bus_reset,
    output rx_bus_reset,

    output tx_dsp_reset,
    output rx_dsp_reset,

    output enable_tx,
    output enable_rx
    );

   // Master Controls assignments
   wire    enable_tx_sclk = master_controls[0];
   wire    enable_rx_sclk = master_controls[1];
   wire    tx_reset_sclk = master_controls[2];
   wire    rx_reset_sclk = master_controls[3];
   // Unused - 4-7
   
   // Enables coming from serial bus must be synced to master clock
   reg 	   enable_tx_sync1, enable_tx_sync2, enable_rx_sync1, enable_rx_sync2;

   always @(posedge master_clk)
     begin
	enable_tx_sync1 <= #1 enable_tx_sclk;
	enable_rx_sync1 <= #1 enable_rx_sclk;
	enable_tx_sync2 <= #1 enable_tx_sync1;
	enable_rx_sync2 <= #1 enable_rx_sync1;
     end
   
   assign  enable_tx = enable_tx_sync2;
   assign  enable_rx = enable_rx_sync2;
   
   // We need to generate 4 separate resets

   // Reset syncs for dsp (master_clk) side
   reg 	   tx_reset_dsp_sync1, rx_reset_dsp_sync1, tx_reset_dsp_sync2, rx_reset_dsp_sync2;
 	   
   always @(posedge master_clk)
     begin
	tx_reset_dsp_sync1 <= #1 tx_reset_sclk;
	rx_reset_dsp_sync1 <= #1 rx_reset_sclk;
	tx_reset_dsp_sync2 <= #1 tx_reset_dsp_sync1;
	rx_reset_dsp_sync2 <= #1 rx_reset_dsp_sync1;
     end

   assign tx_dsp_reset = tx_reset_dsp_sync2;
   assign rx_dsp_reset = rx_reset_dsp_sync2;

   // Reset syncs for bus (usbclk) side
   // The RX bus side reset isn't used, the TX bus side one may not be needed
   reg 	   tx_reset_bus_sync1, rx_reset_bus_sync1, tx_reset_bus_sync2, rx_reset_bus_sync2;
 	   
   always @(posedge usbclk)
     begin
	tx_reset_bus_sync1 <= #1 tx_reset_sclk;
	rx_reset_bus_sync1 <= #1 rx_reset_sclk;
	tx_reset_bus_sync2 <= #1 tx_reset_bus_sync1;
	rx_reset_bus_sync2 <= #1 rx_reset_bus_sync1;
     end

   assign tx_bus_reset = tx_reset_bus_sync2;
   assign rx_bus_reset = rx_reset_bus_sync2;
   
endmodule // master_control
