#include <stdio.h>

#include <gh.h>

#include "c_builtins.h"

void main_prog(int argc, char *argv[]);

main(int argc, char *argv[])
{
  printf ("loading Guile .. please wait\n");
  gh_enter(argc, argv, main_prog);
}

void main_prog(int argc, char *argv[])
{
  char input_str[200];          /* ugly hack: assume strlen(line) < 200 */
  int done;

  /* gh_startup();		/* no longer needed in guile 1.2? */

  /* for fun, evaluate some simple Scheme expressions here */
  gh_eval_str("(define (square x) (* x x))");
  gh_eval_str("(define (fact n) (if (= n 1) 1 (* n (fact (- n 1)))))");
  gh_eval_str("(square 9)");
  gh_eval_str("(fact 100)");

  /* now try to define some new builtins, coded in C, so that they are
     available in Scheme. */

  gh_new_procedure1_0("c-random", c_rand);
  gh_new_procedure0_0("c-randomize", c_srand);

  /* now sit in a Scheme eval loop: I input the expressions, have
     Guile evaluate them, and then get another expression.  */
  done = 0;
  fputs("learn1> ", stdout);
  while (!done) {
#if 0				/* using fgets is better */
    if (gets(input_str) == NULL) {
#endif
    if (fgets(input_str, 199, stdin) == NULL) {
      done = 1;
    } else {
      gh_eval_str(input_str);
      fputs("\nlearn1> ", stdout);
    }
  }

  exit(0);
}
