.\" -*- nroff -*-
.de TQ
.br
.ns
.TP \\$1
..
.TH GROFF @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff \- front end for the groff document formatting system
.SH SYNOPSIS
.B groff
[
.B \-tpeszaivhblCENRVZ
]
[
.BI \-w name
]
[
.BI \-W name
]
[
.BI \-H file
]
[
.BI \-m name
]
[
.BI \-F dir
]
[
.BI \-T dev
]
[
.BI \-f fam
]
[
.BI \-M dir
]
[
.BI \-d cs
]
[
.BI \-r cn
]
[
.BI \-n num
]
[
.BI \-o list
]
[
.BI \-P arg
]
[
.IR files \|.\|.\|.\|
]
.SH DESCRIPTION
.B groff
is a front-end to the groff document formatting systems.
Normally it runs the
.B gtroff
program and a postprocessor appropriate for the selected
device.
Available devices are:
.TP
.B ps
For PostScript printers and previewers
.TP
.B dvi
For TeX dvi format
.TP
.B X75
For a 75 dpi X11 previewer
.TP
.B X100
For a 100dpi X11 previewer
.TP
.B Xps
For X11 previewer used with intermediate output for
.B ps
device.
.TP
.B ascii
For typewriter-like devices
.TP
.B latin1
For typewriter-like devices using the ISO Latin-1 character set.
.LP
The default device is
.BR @DEVICE@ .
It can optionally preprocess with any of
.BR gpic ,
.BR geqn ,
.BR gtbl ,
.BR grefer ,
or
.B gsoelim.
It will also load any macros and eqn definitions
required for a particular device.
It can also spool the resulting output.
.LP
Options without an argument can be grouped behind a single
.BR \- .
A filename of
.B \-
denotes the standard input.
.SH OPTIONS
.TP
.B \-h
Print a help message.
.TP
.B \-e
Preprocess with geqn.
.TP
.B \-t
Preprocess with gtbl.
.TP
.B \-p
Preprocess with gpic.
.TP
.B \-s
Preprocess with gsoelim.
.TP
.B \-R
Preprocess with grefer.
No mechanism is provided for passing arguments to 
.B grefer
because most grefer options have equivalent commands
which can be included in the file.
See
.BR grefer (1)
for more details.
.TP
.B \-v
Make programs run by
.B groff
print out their version number.
.TP
.B \-V
Print the pipeline on stdout instead of executing it.
.TP
.B \-z
Suppress output from
.BR gtroff .
Only error messages will be printed.
.TP
.B \-Z
Do not postprocess the output of
.BR gtroff .
Normally
.B groff
will automatically run the appropriate postprocessor.
.TP
.BI \-P arg
Pass
.I arg
to the postprocessor.
Each argument should be passed with a separate
.B \-P
option.
.TP
.B \-l
Spool the output.
.TP
.BI \-L arg
Pass
.I arg
to the spooler.
Each argument should be passed with a separate
.B \-L
option.
.TP
.BI \-T dev
Prepare output for device
.IR dev .
The default device is
.BR @DEVICE@ .
.TP
.B \-N
Don't allow newlines with eqn delimiters.
This is the same as the
.B \-N
option in
.BR geqn .
.TP
.B \-a
.TQ
.B \-b
.TQ
.B \-i
.TQ
.B \-C
.TQ
.B \-E
.TQ
.BI \-w name
.TQ
.BI \-W name
.TQ
.BI \-m name
.TQ
.BI \-o list
.TQ
.BI \-d cs
.TQ
.BI \-r cn
.TQ
.BI \-F dir
.TQ
.BI \-M dir
.TQ
.BI \-H file
.TQ
.BI \-f fam
.TQ
.BI \-n num
These are as described in
.BR gtroff (@MAN1EXT@) .
.SH ENVIRONMENT
.TP
.SM
.B GROFF_TMAC_PATH
A colon separated list of directories in which to search for
macro files.
.TP
.SM
.B GROFF_TYPESETTER
Default device.
.TP
.SM
.B GROFF_FONT_PATH
A colon separated list of directories in which to search for the
.BI dev name
directory.
.TP
.SM
.B GROFF_HYPHEN
File containing hyphenation patterns.
.TP
.SM
.B PATH
The search path for commands executed by
.BR groff .
.SH FILES
.TP \w'\fB@FONTDIR@/dev\fIname\fB/eqnchar'u+3n
.B @HYPHENFILE@
Hyphenation patterns
.TP
.BI @MACRODIR@/tmac. name
Macro file used by
.BI \-m name\fR.
.TP
.BI @FONTDIR@/dev name /DESC
Device description file for device
.IR name .
.TP
.BI @FONTDIR@/dev name / F
Font file for font
.I F
of device
.IR name .
.TP
.BI @FONTDIR@/dev name /eqnchar
.B geqn
definitions for device
.IR name .
.SH "SEE ALSO"
.BR grog (@MAN1EXT@),
.BR gtroff (@MAN1EXT@),
.BR gtbl (@MAN1EXT@),
.BR gpic (@MAN1EXT@),
.BR geqn (@MAN1EXT@),
.BR gsoelim (@MAN1EXT@) ,
.BR grefer (@MAN1EXT@),
.BR grops (@MAN1EXT@),
.BR grodvi (@MAN1EXT@),
.BR grotty (@MAN1EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_ms (@MAN7EXT@),
.BR groff_me (@MAN7EXT@)
.br
.I "Groff Character Names"
