
;;; d-hippie.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-hippie.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Hippie functionality
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(safe-require 'hippie-exp)

(setq hippie-expand-try-functions-list '(
;;                                       try-complete-file-name-partially
;;                                       try-complete-file-name
;;                                       try-expand-all-abbrevs
;;                                       try-expand-list
;;                                       try-expand-line
                                         try-expand-dabbrev-from-kill
                                         try-expand-dabbrev
                                         try-expand-dabbrev-all-buffers
;;                                       try-complete-lisp-symbol-partially
;;                                       try-complete-lisp-symbol
))

(fset 'd-complete-file (make-hippie-expand-function
                         '(try-complete-file-name-partially
                           try-complete-file-name)))

(fset 'd-complete-visible (make-hippie-expand-function
                            '(try-expand-dabbrev-visible)))

(fset 'd-complete-list (make-hippie-expand-function
                         '(try-expand-list
                           try-expand-list-all-buffers)))

(fset 'd-complete-line (make-hippie-expand-function
                            '(try-expand-line
                              try-expand-line-all-buffers)))

(fset 'd-complete-lisp (make-hippie-expand-function
                         '(try-complete-lisp-symbol-partially
                           try-complete-lisp-symbol)))

(define-key minibuffer-local-map "\t" 'd-complete-file)

(provide 'd-hippie)
;;; d-hippie.el ends here
