/* -*-c-*- -------------- mixgtk.c :
 * Main functions of the mix gtk front-end
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "2001-05-04 01:33:02 jao"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

#include <stdio.h>

#include "mixgtk_widgets.h"
#include "mixgtk_cmd_dispatcher.h"
#include "mixgtk_device.h"
#include "mixgtk_mixvm.h"
#include "mixgtk_mixal.h"
#include "mixgtk_input.h"
#include "mixgtk_colorsel.h"
#include "mixgtk_fontsel.h"
#include "mixgtk_config.h"
#include "mixgtk.h"


/* initialise the app */
gboolean
mixgtk_init (int argc, char *argv[])
{
  mix_vm_t *vm;

  const gchar *gfile = GLADE_FILE;
  FILE *f = fopen (gfile, "r");
  if (!f && !(f = fopen ((gfile = LOCAL_GLADE_FILE), "r")))
    {
      g_error ("Configuration file not found (tried %s and %s)",
	       GLADE_FILE, LOCAL_GLADE_FILE);
      return FALSE;
    }
  fclose (f);
  
  gtk_init (&argc, &argv);

  mix_init_lib ();
  
  if (!mixgtk_config_load ())
    {
      g_error ("Unable to read configuration\n");
      return FALSE;
    }
  
  if (!mixgtk_widget_factory_init (gfile))
    {
      g_error ("Unable to initialise application using %s\n", gfile);
      return FALSE;
    }

  if (!mixgtk_cmd_dispatcher_init ())
    {
      g_error ("Unable to initialise application (command dispatcher)\n");
      return FALSE;
    }

  vm = mixgtk_cmd_dispatcher_get_vm ();
  
  if (!mixgtk_device_init (GTK_NOTEBOOK
			   (mixgtk_widget_factory_get (MIXGTK_WIDGET_DEVICE)),
			   vm))
    {
      g_error ("Unable to initialise application (devices)\n");
      return FALSE;
    }

  if (!mixgtk_mixvm_init (vm))
    {
      g_error ("Unable to initialise application (mixvm widgets)\n");
      return FALSE;
    }

  if (!mixgtk_mixal_init (vm))
    {
      g_error ("Unable to initialise application (mixal widgets)\n");
      return FALSE;
    }

  if (!mixgtk_input_init ())
    {
      g_error ("Unable to initialise application (word input widgets)\n");
      return FALSE;
    }

  if (!mixgtk_fontsel_init () || !mixgtk_colorsel_init ())
    {
      g_error ("Unable to initialise application (customization widgets)\n");
      return FALSE;
    }
    
  return TRUE;
}

/* clean up */
void
mixgtk_release (void) 
{
  if (mixgtk_config_is_autosave ()) mixgtk_config_save ();
  
  mix_release_lib ();
}
