/* definitions of all parser constants/structs
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/* <==================================================================> */
/*  by Isaac Tsai @ 1994                                                */

#ifndef _CAPA_PARSER_H_
#define _CAPA_PARSER_H_

#include  <stdio.h>    /* for FILE *  */
#ifdef DMALLOC
#include <dmalloc.h>
#endif
#ifdef __STDC__   /* sun ansi cc compiler use this flag */
#define  CAPA_ARG(x)  x
#else
#define  CAPA_ARG(x)  ()
#endif

#define  CAPA_ERROR(xx)   {             }
#define  CAPA_WARNING(xx) {             }
#define  MESSAGE_WARN 1
#define  MESSAGE_ERROR 2


#ifdef   SYMBOL_DBUG
#define  SSDBUG_PR1(xx)        { printf(xx);       fflush(stdout); }
#define  SSDBUG_PR2(xx,yy)     { printf(xx,yy);    fflush(stdout); }
#define  SSDBUG_PR3(xx,yy,zz)  { printf(xx,yy,zz); fflush(stdout); }
#else
#define  SSDBUG_PR1(xx)        { }
#define  SSDBUG_PR2(xx,yy)     { }
#define  SSDBUG_PR3(xx,yy,zz)  { }

#endif



/* Some useful numbers */

/*#define  EIGHT                8*/
/*#define  SIXTEEN             16*/
/*#define  THIRTY_TWO          32*/
/*#define  SIXTY_FOUR          64*/
#define  ONE_TWO_EIGHT      128
#define  QUARTER_K          256
#define  HALF_K             512
#define  ONE_K             1024
#define  TWO_K             2048
#define  FOUR_K            4096



#define    ANSWER_STRING_LENG       81
#define  MAX_OPENED_FILE   4096    /* maximum number of files opened */
#define  MAX_SYMB_COUNT    4096    /* symbol table size    */
#define  MAX_FUNC_NAME      256    /* function name length */
#define  MAX_FUNC_NEST     1024    /* sin(cos(tan(...)))   */
/*#define  MAX_QTEXT_LEN     4096     overall question text in a set *NO LONGER NEEDED */
#define  WARN_MSG_LENGTH   1024    /* for warning messages */


#define  ASCII_MODE           1
#define  TeX_MODE             2
#define  HTML_MODE            3
#define  BUBBLE_MODE          4

#define  ANSWER_STRING_MODE   5   /* used in answers_string() */


/* parameters used in array_sorted_index() */

#define  ASCEND_SORT          1
#define  DESCEND_SORT         2
#define  NUMERICAL_SORT       3



typedef struct _symbol {
  char              *s_name;           /* IDENTIFIER or FUNCTION_ID  or ARRAY_ID name */
  int                s_type;
  int                s_array_cnt;
  int                s_argc;
  struct _argNode   *s_argp;
  struct _treeNode  *s_treep;
  struct _symbol    *s_nextp;
  struct _symbol    *s_prevp;
  struct _symbol    *s_arrayp;
  struct _pts_list  *s_ptslist;
  int                s_access_cnt;
  int                s_distype;
  char              *s_format;
  union {  char      *s_sval;
           long       s_ival;
           double     s_rval;
        } s_val;
} Symbol;

typedef Symbol *Symbol_p;

#define s_int   s_val.s_ival
#define s_real  s_val.s_rval
#define s_str   s_val.s_sval

#define  E_FORMAT             1
#define  F_FORMAT             3
#define  DEFAULT_FORMAT       9

typedef struct _argNode {
    Symbol          *a_sp;
    int              a_idx; 
    struct _argNode *a_next;
    struct _argNode *a_prev;
 } ArgNode_t;
 
#define   FIRST_SYMBOLP(aaa)      (aaa->a_sp)
#define   SECOND_SYMBOLP(aaa)   ( (aaa->a_next)->a_sp )
#define   THIRD_SYMBOLP(aaa)    ( ((aaa->a_next)->a_next)->a_sp )
#define   FOURTH_SYMBOLP(aaa)   ( (((aaa->a_next)->a_next)->a_next)->a_sp )
#define   FIFTH_SYMBOLP(aaa)    ( ((((aaa->a_next)->a_next)->a_next)->a_next)->a_sp )
#define   SIXTH_SYMBOLP(aaa)    ( (((((aaa->a_next)->a_next)->a_next)->a_next)->a_next)->a_sp )
#define   FIRST_ARGNAME(aaa)    ( FIRST_SYMBOLP(aaa)->s_name )
#define   FIRST_ARGTYPE(aaa)    ( FIRST_SYMBOLP(aaa)->s_type )
#define   FIRST_ARGINT(aaa)     ( FIRST_SYMBOLP(aaa)->s_int )
#define   FIRST_ARGREAL(aaa)    ( FIRST_SYMBOLP(aaa)->s_real )
#define   FIRST_ARGSTR(aaa)     ( FIRST_SYMBOLP(aaa)->s_str )
#define   SECOND_ARGNAME(aaa)   ( SECOND_SYMBOLP(aaa)->s_name )
#define   SECOND_ARGTYPE(aaa)   ( SECOND_SYMBOLP(aaa)->s_type)
#define   SECOND_ARGINT(aaa)    ( SECOND_SYMBOLP(aaa)->s_int)
#define   SECOND_ARGREAL(aaa)   ( SECOND_SYMBOLP(aaa)->s_real)
#define   SECOND_ARGSTR(aaa)    ( SECOND_SYMBOLP(aaa)->s_str)
#define   THIRD_ARGNAME(aaa)    ( THIRD_SYMBOLP(aaa)->s_name )
#define   THIRD_ARGTYPE(aaa)    ( THIRD_SYMBOLP(aaa)->s_type)
#define   THIRD_ARGINT(aaa)     ( THIRD_SYMBOLP(aaa)->s_int)
#define   THIRD_ARGREAL(aaa)    ( THIRD_SYMBOLP(aaa)->s_real)
#define   THIRD_ARGSTR(aaa)     ( THIRD_SYMBOLP(aaa)->s_str)
#define   FOURTH_ARGTYPE(aaa)   ( FOURTH_SYMBOLP(aaa)->s_type)
#define   FOURTH_ARGNAME(aaa)   ( FOURTH_SYMBOLP(aaa)->s_name )
#define   FOURTH_ARGINT(aaa)    ( FOURTH_SYMBOLP(aaa)->s_int)
#define   FOURTH_ARGREAL(aaa)   ( FOURTH_SYMBOLP(aaa)->s_real)
#define   FOURTH_ARGSTR(aaa)    ( FOURTH_SYMBOLP(aaa)->s_str)
#define   FIFTH_ARGTYPE(aaa)    ( FIFTH_SYMBOLP(aaa)->s_type)
#define   FIFTH_ARGNAME(aaa)    ( FIFTH_SYMBOLP(aaa)->s_name )
#define   FIFTH_ARGINT(aaa)     ( FIFTH_SYMBOLP(aaa)->s_int)
#define   FIFTH_ARGREAL(aaa)    ( FIFTH_SYMBOLP(aaa)->s_real)
#define   FIFTH_ARGSTR(aaa)     ( FIFTH_SYMBOLP(aaa)->s_str)
#define   SIXTH_ARGTYPE(aaa)    ( SIXTH_SYMBOLP(aaa)->s_type)
#define   SIXTH_ARGNAME(aaa)    ( SIXTH_SYMBOLP(aaa)->s_name )
#define   SIXTH_ARGINT(aaa)     ( SIXTH_SYMBOLP(aaa)->s_int)
#define   SIXTH_ARGREAL(aaa)    ( SIXTH_SYMBOLP(aaa)->s_real)
#define   SIXTH_ARGSTR(aaa)     ( SIXTH_SYMBOLP(aaa)->s_str)




typedef struct _treeNode {
    Symbol           *t_sp;
    int               t_idx;
    struct _treeNode *t_left;
    struct _treeNode *t_right;
 } TreeNode_t;

typedef struct _expNode {
    int              e_type;
    struct _expNode *e_parentp;
    struct _expNode *e_lsibp;
    struct _expNode *e_rsibp;
    Symbol          *e_sp;
 } ExpNode;
 
typedef ExpNode  *ExpNode_p;

/* ================================================================ */
/*   While loop data structure */

typedef struct _WhileLoop {
    int             input_idx; /* stores Input_idx */
    int             line_idx;  /* stores Current_line[Input_idx] */
    long int        pos_idx;   /* stores next line position in the input stream */
 } WhileLoop_t;


/* ================================================================ */
/*    Warning message data structure */

typedef  struct  _WarnMsg {
    int              warn_type;
    char            *warn_str;
    struct _WarnMsg *warn_next;
  } WarnMsg_t;






/* ================================================================ */

#define    SYMBOL_MAXLEN     16      /* unit symbol name length */
#define    NAME_MAXLEN       48      /* unit name length */
#define    BASEUNIT_LIMIT    32      /* maximum number of base units */
#define    ONE_K_SIZE        1024 

/* ================================================================ */

typedef  struct  _unit_elem {
  struct  _unit_elem  *ue_nextp;
  char    ue_symbol[SYMBOL_MAXLEN];
  int     ue_index;   /* -1 means this is composite */
#define          UE_COMPOSITE     -1
  double  ue_scale;
  double  ue_exp;
} Unit_E;

typedef struct  _unit_t {
  char       u_symbol[SYMBOL_MAXLEN];
  char       u_name[NAME_MAXLEN];
  char      *u_comment;
  int        u_index;
  struct _unit_t  *u_left;
  struct _unit_t  *u_right;
  int        u_type;
#define          U_BASE            1
#define          U_DERIVED         2
#define          U_PREFIX          3
#define          U_CONSTANT        4
#define          U_OP_POWER        5
#define          U_OP_TIMES        6
#define          U_OP_PLUS         7
#define          U_OP_MINUS        8
#define          U_OP_DIVIDE       9
#define          U_UNKNOWN         10
#define          U_DEFAULT         11
  double     u_scale;
  double     u_offset;
  int        u_count;
  Unit_E    *u_list;
}  Unit_t;

#define   U_LEFT(x)   ((x)->u_left)
#define   U_RIGHT(x)  ((x)->u_right)
#define   U_SYMB(x)   ((x)->u_symbol)
#define   U_NAME(x)   ((x)->u_name)
#define   U_COUNT(x)  ((x)->u_count)
#define   U_TYPE(x)   ((x)->u_type)
#define   U_SCALE(x)  ((x)->u_scale)

/* ==================================================================== */
/* Answer    tolerance    sig     string   */
/*  int        abs/rel                     */
/*  real       abs/rel    [l,u]            */
/*  string                         cs/ci   */
/*                                 mc      */

typedef struct _problem {
   char               *question;    /* Question text                   */
   char               *answer;      /* Answer string                   */
   char               *hint;        /* Hint text                       */
   char               *explain;     /* Explain text                    */
   char               *capaidplus;  /* Quizzes extra unique identifier 
                                       Only set in the first problem   */
   int                 ans_cnt;     
   int                 weight;
   int                 tol_type;
   double              tolerance;
   int                 ans_type;    /* Type of answer expecting        */
   int                 sig_ubound;
   int                 sig_lbound;
   int                 partial_cdt;
   
   int                 calc;         /* calculate correct answers based on 
                                       formated/unformated exact answer */
   int                 tries;       /* Number of tries allowed         */
   int                 show_hint;
   int                 show_explain;
   int                 show_br;      /* web only, <BR> on is by default */
   int                 show_ans_box; /* web only, answer box is shown by default */
   int                 verbatim; /* do verbatim protection around answers */
   int                 ans_op;   /* ANS_AND or ANS_OR */
   char               *id_list;
   struct   _pts_list *pts_list;
   char                ans_fmt[ANSWER_STRING_LENG];
   char                unit_str[ANSWER_STRING_LENG];
   Unit_t              *ans_unit;
   struct _answer_info *ans_list;
   struct _answer_info *ans_list_last;
   struct _problem     *next;        /* Pointer to next problem         */
} Problem_t;

#define   P_TOLTYPE(p)  ((p)->tol_type)


typedef struct _pts_list {
   char     *pts_str;
   int       pts_idx;
   struct   _pts_list *pts_next;
} PointsList_t;



/* Answer related data structure */
/* 
   char     *ans_str
   int       ans_type
   int       ans_calc
   int       ans_tol_type
   double    ans_tol
   int       ans_sig_ub
   int       ans_sig_lb
   char     *ans_id_list;
   struct   _pts_list *ans_pts_list;
   char      ans_fmt
   char      ans_unit_str
   
*/
/* 
    some information in the answer specification should be 
    problem-wise, such as problem weight, problem tries
    
*/

typedef struct _answer_info {
   char     *ans_str;           /* correct answer in string form */
   int       ans_type;          /* answer type */
   int       ans_calc;
   int       ans_tol_type;      /* answer tolerence type */
   double    ans_tol;           /* the tolerence itself */
   int       ans_sig_ub;
   int       ans_sig_lb;
   char     *ans_id_list;
   struct   _pts_list *ans_pts_list;
   char      ans_fmt[ANSWER_STRING_LENG];
   char      ans_unit_str[ANSWER_STRING_LENG];
   Unit_t   *ans_unit;
   struct   _answer_info *ans_next;
} AnswerInfo_t;



/******************************************************************************/
/* STRUCTURE FOR A PROBLEM                                                    */
/******************************************************************************/

#define    SPEC_TOLERANCE       1
#define    SPEC_SIG             2
#define    SPEC_WEIGHT          4
#define    SPEC_TYPE            8
#define    SPEC_PCREDIT         16
#define    SPEC_TRY             32
#define    SPEC_UNIT            64

/* ---------------------------- tol_type -------------------------- */
#define    TOL_ABSOLUTE         1
#define    TOL_PERCENTAGE       2

/* ------------------------------------------ */
#define    CALC_UNFORMATED      1
#define    CALC_FORMATED        2

#define    CALC_DEFAULT         CALC_UNFORMATED  /* for answer calculation */

/* ----------------------------------------  web option only */
#define    DO_SHOW              1
#define    DONOT_SHOW           0

#define    DO_VERBATIM          1
#define    DONOT_VERBATIM       0

#define    SHOW_BR_DEFAULT      DO_SHOW
#define    VERBATIM_DEFAULT     DO_VERBATIM
#define    SHOW_ANSBOX_DEFAULT  DO_SHOW

#define    SIG_LB_DEFAULT       0        /* ---- sig_lbound ------- */
#define    SIG_UB_DEFAULT       15       /* ---- sig_ubound ------- */
#define    PCREDIT_DEFAULT      0        /* ---- partial_cdt ------ */
#define    TOL_DEFAULT          (0.0)    /* ---- tolerance  ------- */
#define    WEIGHT_DEFAULT       1        /* ---- weight     ------- */
#define    NO_LIMIT_TRY         (0)      /* ---- tries      ------- */
#define    MAX_TRIES            99       /* ---- tries ------------ */
#define    SHOW_HINT_DEFAULT    1        /* show hints immediately */

/* ---------------------------  ans_type -------------------------- */
#define    ANSWER_IS_INTEGER       1
#define    ANSWER_IS_FLOAT         2
#define    ANSWER_IS_STRING_CI     3
#define    ANSWER_IS_STRING_CS     4
#define    ANSWER_IS_CHOICE        5
#define    ANSWER_IS_ARITH         6
#define    ANSWER_IS_SUBJECTIVE    7
#define    ANSWER_IS_FORMULA       8
#define    ANSWER_IS_EXTERNAL      9

#define    YAK                     1
#define    NAY                     0

/* -------- results given by capa_check_answer() and capa_check_answers() */

#define    EXACT_ANS           1
#define    APPROX_ANS          2 
#define    SIG_FAIL            3
#define    UNIT_FAIL           4
#define    NO_UNIT             5
#define    UNIT_OK             6
#define    INCORRECT           7
#define    UNIT_NOTNEEDED      8
#define    ANS_CNT_NOT_MATCH   9
#define    SUB_RECORDED        10
#define    BAD_FORMULA         11
#define    WANTED_NUMERIC      12



/* =============================================================== */

#define    T_SPACE           9
#define    T_PREFIX          8
#define    T_NUMBER          7
#define    T_BASIC_UNIT      6
#define    T_DERIVED_UNIT    5
#define    T_LP              4
#define    T_RP              3
#define    T_MULTIPLY        2
#define    T_POWER           1
#define    T_END             0

/* for IFstatus[] */

#define    IF_FALSE          0
#define    IF_TRUE           1
#define    IF_DONT_CARE      2

/* for IFcurrent[] */
#define    RUN_IF_PORTION    1
#define    RUN_ELSE_PORTION  2

/* ================================================================ */
/********************** for random(), /MAP(), capa_PIN() */
/* BETA_DIS is used for genbet() */
/* CHI_DIS  is for genchi() */
/* EXPONENTIAL_DIS    genexp() */
/* GAMMA_DIS    gengam() */
/* MULTI_NORM_DIS    genmn() */
/* NONCEN_CHI_DIS    gennch() */
/* NORMAL_DIS        gennor() */
/* POISSON_DIS       long ignpoi(float mu) */

#define    RANDOM_G            1L
#define    PERMUTATION_G       2L
#define    PIN_G               3L

#define    NORMAL_DIS          10 
#define    POISSON_DIS         11
#define    EXPONENTIAL_DIS     12 
#define    BETA_DIS            13
#define    GAMMA_DIS           14
#define    CHI_DIS             15
#define    NONCENTRAL_CHI_DIS  16
#define    FORMULA_PICK_POINTS 17
#define    MULTIVARIATE_NORMAL_DIS  18

#define    GET_GENERATOR        0L
#define    SET_GENERATOR        1L

#define    FORWARD_MAP           0
#define    REVERSE_MAP           1



/* ---------------------------------------------- capaLexerDef.flex */ 
void        begin_if_skip      CAPA_ARG(());
void        begin_while_skip   CAPA_ARG(());
void        begin_next_line    CAPA_ARG(());
void        begin_var          CAPA_ARG(());
void        begin_let          CAPA_ARG(());
void        begin_def          CAPA_ARG(()); 
void        begin_ans          CAPA_ARG(());     
void        begin_map          CAPA_ARG(()); 
void        begin_ignore       CAPA_ARG(());    
void        begin_text         CAPA_ARG(());    
void        begin_question     CAPA_ARG(());
void        end_problemset     CAPA_ARG(());
int         match_keyword      CAPA_ARG((char *key));
int         match_functionid   CAPA_ARG((char *key));    
void        init_funcstack     CAPA_ARG(()); 

#ifdef DMALLOC
#define strsave(s) strcpy(capa_malloc(strlen(s)+1,1),s)
#define capa_malloc(num,sz) memset(calloc(num,sz),'\0',num*sz)
#define capa_mfree(p) free(p);
#else
char       *strsave             CAPA_ARG((char *s));          
char       *capa_malloc         CAPA_ARG((unsigned int num, unsigned int sz));
void        capa_mfree          CAPA_ARG((char *p));
#endif
void        capa_msg            CAPA_ARG((int type, char *p));
void        capa_warn_header    CAPA_ARG(()); 
void        parse_filename      CAPA_ARG((char *line));
void        parse_import_id     CAPA_ARG((char *line));
char       *parse_endinput      CAPA_ARG((char *line));
void        append_dynamic_buf  CAPA_ARG((char *new_str));
char*       parser_status       CAPA_ARG((void));
/*------------------------------------------------- capaGrammarDef.y */

ExpNode_p   mk_node             CAPA_ARG((int op, ExpNode_p left, ExpNode_p right));
ExpNode_p   mk_leaf             CAPA_ARG((int type, Symbol_p valp));
void        append_text         CAPA_ARG((char *str));
void        append_hint         CAPA_ARG((char *str));
void        append_explain      CAPA_ARG((char *str));
void        append_error        CAPA_ARG((char *str));
void        append_warn         CAPA_ARG((int type, char *str));
Symbol     *symbols_op          CAPA_ARG((Symbol *a, Symbol *b, int op));
char       *format_toTeX        CAPA_ARG((char *real));
char       *format_toHTML       CAPA_ARG((char *real));
void        init_answerinfo     CAPA_ARG(());
void        display_var         CAPA_ARG((Symbol *s));
void        assign_answer       CAPA_ARG((Symbol *s));
void        assign_tolerance    CAPA_ARG((int tol_type, Symbol *s));
void        assign_weight       CAPA_ARG((Symbol *s));
void        assign_try_limits   CAPA_ARG((Symbol *s));
void        assign_hint         CAPA_ARG((Symbol *s));
void        assign_units        CAPA_ARG((Symbol *s));
void        assign_sigs         CAPA_ARG((int lb, int ub));
void        assign_id_list      CAPA_ARG((Symbol *s));
void        init_new_prob       CAPA_ARG(());
void        add_answer_cnt      CAPA_ARG((int op));
void        finish_answer_info  CAPA_ARG(());
void        start_question_over CAPA_ARG(());

Symbol*     get_array_symbol    CAPA_ARG((Symbol* name,Symbol* index,int free_symbols));
Symbol*     build_array_list    CAPA_ARG((Symbol* ar_name,int num_elem)); 
/*---------------------------------------------------- capaParserUtils.c */ 
Symbol*     negate              CAPA_ARG((Symbol* symb));
void        problem_default     CAPA_ARG((Problem_t  *p));
int         comp_name           CAPA_ARG((char *a,char *b));
int         comp_namesymbol     CAPA_ARG((char *a, Symbol *b));
int         itis_empty          CAPA_ARG((TreeNode_t *root_p));
void        print_symb_stat     CAPA_ARG(());
int         preorder_tree       CAPA_ARG((TreeNode_t *node_p));
int         inorder_tree        CAPA_ARG((TreeNode_t *node_p));
int         postorder_tree      CAPA_ARG((TreeNode_t *node_p));
int         destroy_tree        CAPA_ARG((TreeNode_t *node_p));
int         free_symtree        CAPA_ARG(());
char       *btree_search        CAPA_ARG((char *key,TreeNode_t  **root_pp,int  (*compar)()));
Symbol     *find_identifier     CAPA_ARG((register char *name));  

ArgNode_t  *new_arglist         CAPA_ARG((Symbol *sp));
ArgNode_t  *addto_arglist       CAPA_ARG((ArgNode_t *argp, Symbol *sp));
void        walk_arglist        CAPA_ARG((ArgNode_t *argp));
void        free_arglist        CAPA_ARG((ArgNode_t *argp));
int         purge_tree          CAPA_ARG((TreeNode_t  **root_pp));
int         calc_sig            CAPA_ARG((char *a_num ));
int         endian              CAPA_ARG(());
TreeNode_t *new_treenode        CAPA_ARG((char *name_p, int type));
TreeNode_t *new_formulanode     CAPA_ARG((char *name_p, double val));

TreeNode_t *t_splay             CAPA_ARG((char *name, TreeNode_t *t));
void        print_array_element CAPA_ARG((Symbol *array_p));
Symbol     *find_arrayid        CAPA_ARG((char *name_p));
Symbol     *find_array_by_index CAPA_ARG((Symbol *array_p,char *idx_p));
int         free_array          CAPA_ARG((char *name_p));
Symbol     *array_min_max       CAPA_ARG((char *name_p,int min));
Symbol     *array_moments       CAPA_ARG((char *result_p,char *name_p));
Symbol     *gen_multivariate_normal  CAPA_ARG((char *output_p,char *seed,int
item_cnt,int dimen,char *m_vec_str,char *c_vec_str));
Symbol     *gen_random_by_selector  CAPA_ARG((char *output_p,int sel,char *seed,int item_cnt,float p1,float p2));
int         setup_formula_id    CAPA_ARG((char *v_str, char *pt_str));
void        free_formula_tree   CAPA_ARG(());

Symbol     *find_formula_id     CAPA_ARG((char *name_p));
int         f_eval_formula      CAPA_ARG((double *f_val,char *f_str,char *v_str, char *pt_str));

int         f_u_parse_formula   CAPA_ARG((char *f_str));
int         f_str_to_numbers    CAPA_ARG((double **f_ar, char *n_str));
int         f_str_to_ids        CAPA_ARG((char ***v_ar, char *n_str));

PointsList_t *f_gen_pts         CAPA_ARG((char *ap, char *bp, int n));
PointsList_t *gen_ptslist_str   CAPA_ARG((char *range_str ));
char   *eval_formula_range_str  CAPA_ARG((char *f_str,char *var_list,char *range_str));

PointsList_t *gen_ptslist       CAPA_ARG((Symbol *ap,Symbol *bp,Symbol *np));
PointsList_t *new_ptslist       CAPA_ARG((Symbol *sp ));
void          free_ptslist      CAPA_ARG((PointsList_t *pts_p)) ;
/* ====================================== capaUnit.c */

void        c_ignorewhite       CAPA_ARG((FILE *f));
double      c_getdouble         CAPA_ARG((FILE *f));
int         c_getint            CAPA_ARG((FILE *f));
int         c_getsec_range      CAPA_ARG((FILE *f,int *low,int *high));
char       *c_getword           CAPA_ARG((FILE *f));
char       *c_getstring         CAPA_ARG((FILE *f));
char       *c_getcomment        CAPA_ARG((FILE *f));
int         c_gettype           CAPA_ARG((FILE *f));

Unit_t     *u_find_symb         CAPA_ARG((char *name, Unit_t *t, int *result));
void        u_find_name         CAPA_ARG((Unit_t *t));
void        print_matches       CAPA_ARG((Unit_t *t));
double      u_squared_diff      CAPA_ARG((Unit_t *a, Unit_t *b));
double      u_sq_diff           CAPA_ARG((Unit_t *b));

void        print_unit_tree     CAPA_ARG(());
int         alphaorder_utree    CAPA_ARG((Unit_t *node_p));
int         inorder_diff        CAPA_ARG((Unit_t *node_p));
int         inorder_utree       CAPA_ARG((Unit_t *node_p));
int         postorder_utree     CAPA_ARG((Unit_t *node_p));
int         postwalk_utree      CAPA_ARG((Unit_t *n_p));
void        process_op          CAPA_ARG((int op));
void        process_utree       CAPA_ARG((Unit_t *t));
int         check_correct_unit  CAPA_ARG((char *u_symb,Unit_t *t,double *scale));
int         free_utree          CAPA_ARG((Unit_t *t));
int         u_postfree          CAPA_ARG((Unit_t *t));
void        print_unit_t        CAPA_ARG((Unit_t *t));
void        u_copy_unit         CAPA_ARG((Unit_t *a_p,Unit_t *b_p,double exp_scale));
int         u_pm_op             CAPA_ARG((Unit_t *a_p, Unit_t *b_p, int op));

int         u_parsepower        CAPA_ARG((char *unit_str));
double      s_scan_number       CAPA_ARG((char *buf, int idx, int *r_idx));
double      s_scan_symbol       CAPA_ARG((char *buf,char *symb_p,int idx,int *r_idx));
int         s_process_symb      CAPA_ARG((char *symb_str, Unit_t  *cu_p,double exp));
Unit_t     *u_parse_unit        CAPA_ARG((char *unit_str));
int         comp_unit_symb      CAPA_ARG((char *a,char *b));
Unit_t     *u_splay             CAPA_ARG((char *name, Unit_t *t));
int         u_insert_baseunit   CAPA_ARG((char *n_p,char *s_p,char *c_p));
int         u_insert_derived    CAPA_ARG((char *n_p,char *s_p,char *c_p,char *u_p));
void        u_getunit           CAPA_ARG((FILE *f));
void        simplify_unit       CAPA_ARG((Unit_t *u_p));
void        freelist_unit_e     CAPA_ARG((Unit_E *ue_p));
int         is_units_equal      CAPA_ARG((Unit_t *u1_p, Unit_t *u2_p));
double      units_ratio         CAPA_ARG((Unit_t *u1_p, Unit_t *u2_p));
Unit_t     *p_new_op            CAPA_ARG((Unit_t *left_p, int op, Unit_t *right_p));
Unit_t     *p_new_num           CAPA_ARG((Unit_t *left_p, double num, Unit_t *right_p));
Unit_t     *p_new_unit          CAPA_ARG((Unit_t *left_p, Unit_t *right_p));
int         s_getnext           CAPA_ARG(());
int         s_peeknext          CAPA_ARG(());
double      scan_FLOAT          CAPA_ARG(());
Unit_t     *scan_num_item       CAPA_ARG(());
Unit_t     *scan_unit_item      CAPA_ARG(());
Unit_t     *scan_basic_term     CAPA_ARG(());
Unit_t     *scan_num_term       CAPA_ARG(());
Unit_t     *scan_basic_block    CAPA_ARG(());
Unit_t     *scan_num_block      CAPA_ARG(());
Unit_t     *scan_unit_expr      CAPA_ARG(());
Unit_t     *scan_num_expr       CAPA_ARG(());
Unit_t     *parse_unit_expr     CAPA_ARG((char *symb_str));
void        print_remains       CAPA_ARG(());
/* =================================================  capaMapExpr.c */

int         do_map             CAPA_ARG((char *seed,ArgNode_t *varp,ArgNode_t *argp,int argc, int dir));

/* ===============================================  capaFormulaLexer.c -- */
double      f_get_float         CAPA_ARG(());
char       *f_get_id            CAPA_ARG(());
int         f_peek_next_token   CAPA_ARG(());
int         fml_lex             CAPA_ARG(());

/* ===============================================  capaFormula.y      == */
int         fml_parse           CAPA_ARG(()); 
Symbol     *f_symbol_pow        CAPA_ARG((Symbol *ap, Symbol *bp));
/* ====================================================================== */

#ifdef  __sun
#define index(xx,cc)  strchr(xx,cc)
#define rindex(xx,cc) strrchr(xx,cc)
#endif

#endif  /* _CAPA_PARSER_H_ */

