/**
 *  Time-stamp:  <2011-03-18 19:04:03 raskolnikov>
 *
 *  @file        observer.hpp
 *  @author      Juan Pedro Bolívar Puente <raskolnikov@es.gnu.org>
 *  @date        Wed Apr  8 13:42:05 2009
 *
 *  Implementation of the observer design pattern. It is based
 *  on an underlying signaling mechanism -SigC++ by now- but added
 *  a convenient wrapper to ease registration and de-registration of
 *  full interfaces.
 */

/*
 *  Copyright (C) 2009 Juan Pedro Bolívar Puente
 *
 *  This file is part of Psychosynth.
 *   
 *  Psychosynth is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Psychosynth is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef PSYNTH_OBSERVER_H_
#define PSYNTH_OBSERVER_H_

#include <boost/bind.hpp>
#include <boost/signal.hpp>
#include <boost/signals/trackable.hpp>

namespace psynth
{
namespace base
{

#if 0
/**
 * @todo Use template aliases when they are availible.
 * @note Even this implementation is not working now.
 */
template <typename ...Types>
class signal : public sigc::signal <Types...> { };
#endif

/**
 * This should be the base of all listener types. This class
 * aids by providing:
 *    - A virtual destructor.
 *    - A trackable interface so you don't have to manually disconnect
 *      from your signal/subjects before destruction.
 *    - A method to manually disconnect form all callbacks.
 */
class listener_base : public boost::signals::trackable
{
public:
    /** Virtual destructor. */
    virtual ~listener_base ()
    {}

    /**
     * Disconnects this listener from all signals/subjects.
     *
     * @todo This is implemented using boost::trackable::operator=.
     * boost::trackable documentation states that operator= is a
     * no-op, but its implementation reveals that it actually clears
     * the target connection list.
     *
     */
    void disconnect_all ()
    {
        listener_base empty;
        boost::signals::trackable::operator= (empty);
    }

protected:
};

/**
 * This provides a basic interface for an observable entity
 * and some helper functions.
 * @param Listener The listener type that can listen on this
 *                 subject.
 */
template <class Listener>
class subject_base
{
public:
    /** Virtual destructor. */
    virtual ~subject_base ()
    {}

    /**
     * Must connect all subject signals with pairing methods on the
     * listener side.
     * @param l The listener to connect.
     */
    virtual void add_listener (Listener& l) = 0;

    /**
     * Must disconnect the listener from the signals in this subject.
     * @param l The listener to disconnect.
     */
    virtual void del_listener (Listener& l) = 0;

protected:
    /**
     * Helper function that will aid derived classes on the implementation
     * of @a del_listener. It disconnect a specific slot from a signal.
     * @param sig The signal.
     * @param s   The slot.
     *
     * @todo Is this function useless under boost::signals ?? 
     * @todo This also relies on equality of objects generated by
     * boost::bind, make sure that our asumptions are right.
     */
    template <class Signal, class Slot>
    void remove_slot (Signal& sig, const Slot& s);
};

template <class Listener>
template <class Signal, class Slot>
void subject_base<Listener>::remove_slot (Signal& sig,
					  const Slot& s)
{
    sig.disconnect (s);
}

} /* namespace base */
} /* namespace psynth */

#endif /* PSYNTH_OBSERVER_H_ */
