/*
	Runtime Engine
		By Craig Kadziolka ( Nov 1999 - Dec 2000 )

	Modifications and copying is permitted providing this header
	is retained
*/

#include "gc.h"
#include <stdlib.h>

#define RTE_INTEGRATION

#define ROOTSETSIZE 2024
#define MAXOBJSIZE 8096	/* 8k objects max */
#define ALLOCATION_SPURT_SIZE 1024

int * rootset [ ROOTSETSIZE ];

extern struct sLargeBlock * large_free_list;

#ifndef RTE_INTEGRATION
int main()
#else
int Main()
#endif
{
	int start_brk;
	int final_brk;
	int i;
	int temp_brk1, temp_brk2;

	struct sLargeBlock * scanner; int counter = 0;
	
#ifndef RTE_INTEGRATION
	GC_init();
#endif

	start_brk = sbrk(0);
	
	printf("Initial break is %u\n", start_brk);

	for (i = 0; i < ROOTSETSIZE; i++) {

		rootset [ i ] = (int *) alloc ( random() % MAXOBJSIZE + 64 );
			
	}

	for (i = 0; i < ALLOCATION_SPURT_SIZE; i ++) {


	}
	

	/* Now free up the memory */
	for (i = 0; i < ROOTSETSIZE; i++) {

		rootset [ i ] = 0;

	}

	temp_brk1 = sbrk(0);
	temp_brk2 = 0;
	
	printf("Total mem allocated is %u\n", temp_brk1 - start_brk);

	while (temp_brk1 != temp_brk2) {

		garbage_collect();
		heap_return();

		temp_brk2 = temp_brk1;
		temp_brk1 = sbrk(0);
	}

	final_brk = sbrk(0);
	
	printf("Final break is %u\n", final_brk);

	printf("Total loss is %u\n", final_brk - start_brk);

	while (scanner != NULL) {
		counter++;
		scanner = scanner -> next;
	}
	
	
	exit(0); /* Explicit termination */
	
}
