dnl I'd like this to be edited in -*- Autoconf -*- mode...
dnl
dnl Calls several commonly used macros; also provides support for
dnl selectively enabling or disabling optimizations and warnings
dnl

AC_DEFUN(GST_PROG_CC, [
AC_REQUIRE([AC_PROG_CC])
AC_REQUIRE([AC_PROG_CPP])
AC_REQUIRE([AC_PROG_GCC_TRADITIONAL])
AC_REQUIRE([AC_AIX])
AC_REQUIRE([AC_MINIX])
AC_REQUIRE([AC_ISC_POSIX])

AC_ARG_ENABLE(warnings, 
[  --enable-warnings       enable compiler warnings (default=no)], ,
enable_warnings=no)

if test "$GCC" = yes; then
ifelse([$1$2], , , [dnl
  changequote(<<, >>)
  case "`$CC --version 2>&1`" in
    # This assumes egcs 1.1.2
    *gcc-2.9[0-4]*) gcc_help="-fbranch-probabilities \
	 -foptimize-register-moves -fcaller-saves -fcse-follow-jumps \
	 -fcse-skip-blocks -fdelayed-branch -fexpensive-optimizations \
	 -ffast-math -ffloat-store -fforce-addr -fforce-mem \
	 -ffunction-sections -fgcse -finline-functions \
	 -fkeep-inline-functions -fno-default-inline -fno-defer-pop \
	 -fno-function-cse -fno-inline -fno-peephole -fomit-frame-pointer \
	 -fregmove -frerun-cse-after-loop -frerun-loop-opt -fschedule-insns \
         -fschedule-insns2 -fstrength-reduce -fthread-jumps \
	 -funroll-all-loops -funroll-loops -fmove-all-movables \
	 -freduce-all-givs -fstrict-aliasing -fstructure-noalias" ;;

    # This assumes GCC 2.7
    *gcc-2.[0-8]*) gcc_help="-ffloat-store -fdefault-inline -fdefer-pop \
        -fforce-mem -fforce-addr -fomit-frame-pointer -finline \
        -finline-functions -fkeep-inline-functions -ffunction-cse -ffast-math \
	-fstrength-reduce -fthread-jumps -fcse-follow-jumps \
	-fcse-skip-blocks -frerun-cse-after-loop -fexpensive-optimizations \
	-fdelayed-branch -fschedule-insns -fschedule-insns2 \
	-fcaller-saves -funroll-loops -funroll-all-loops -fpeephole " ;;

    # For GCC 2.95 and later, we have help available
    *) gcc_help="`$CC -v --help 2>&1`" ;;
  esac
  changequote([, ])

  ifelse([$1], , , [
    for i in $1; do
      case "$gcc_help" in
        *-f$i*) CFLAGS="$CFLAGS -f$i" ;;
        *)	;;
      esac
    done
  ])dnl
  ifelse([$2], , , [
    for i in $2; do
      case "$gcc_help" in
        *-f$i*) CFLAGS="$CFLAGS -fno-$i" ;;
        *)	;;
      esac
    done
  ])dnl
])dnl

  wall=" -Wall"
  wparanoid=" -W"
  ifelse([$3], , , [
    for i in $3; do
      test "x$i" = xall && wall=""
      test "x$i" = x && wparanoid=""
      CFLAGS="$CFLAGS -W$i"
    done
  ])dnl
  ifelse([$4], , , [
    for i in $4; do
      CFLAGS="$CFLAGS -Wno-$i"
    done
  ])dnl
  if test "$enable_warnings" != no; then
    CFLAGS="$CFLAGS${wall}${wparanoid}"
    ifelse([$5], , , [
      for i in $5; do
        CFLAGS="$CFLAGS -W$i"
      done
    ])dnl
  fi
fi

])dnl
