# GNU Solfege - ear training for GNOME
# Copyright (C) 2000, 2001, 2002, 2003, 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
import os
import gtk, gnome, gnome.ui
import gu, mpd
import configureoutput
import widgets
from instrumentselector import NewReadOnlyInstrumentSelector
import cfg
import app
import soundcard

def find_wav_player_programs():
    ret = []
    for p, cmd in (('/usr/bin/play', '/usr/bin/play %s'),
                   ('/usr/bin/aplay', '/usr/bin/aplay %s'),
                   ('/usr/bin/esdplay', '/usr/bin/esdplay %s')):
        if os.path.exists(p):
            ret.append(cmd)
    return ret

def find_midi_player_programs():
    ret = []
    for p, cmd in (('/usr/bin/timidity', '/usr/bin/timidity -idqq %s'),
                   ('/usr/bin/drvmidi', '/usr/bin/drvmidi'),
                   ('/usr/bin/playmidi', '/usr/bin/playmidi')):
        if os.path.exists(p):
            ret.append(p)
    return ret

class ConfigWindow(gnome.ui.PropertyBox, cfg.ConfigUtils):
    def on_destroy(self, widget):
        self.m_app.m_ui.g_config_window.destroy()
        self.m_app.m_ui.g_config_window = None
    def __init__(self, app):
        gnome.ui.PropertyBox.__init__(self)
        cfg.ConfigUtils.__init__(self, 'configwindow')
        self.m_app = app
        self._is_alive = 0
        self.__apply_tag = self.connect('apply', self.on_apply)
        self.connect('help', self.on_help)
        self.connect('destroy', self.on_destroy)
        ########
        # midi #
        ########
        page_vbox = gu.hig_dlg_vbox()
        self.append_page(page_vbox, gtk.Label(_("Midi stuff")))

        vbox, category_vbox = gu.hig_category_vbox(_("Tempo"))
        page_vbox.pack_start(vbox, False)
        sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)

        self.g_default_bpm = gtk.SpinButton(
            gtk.Adjustment(self.get_int('config/default_bpm'), 10, 500, 1, 10))
        self.g_default_bpm.connect('value-changed', self.on_changed)
        box = gu.hig_label_widget(_("_Default bpm:"), self.g_default_bpm, sizegroup)
        category_vbox.pack_start(box, False)

        self.g_arpeggio_bpm = gtk.SpinButton(
            gtk.Adjustment(self.get_int('config/arpeggio_bpm'), 10, 500, 1, 10))
        self.g_arpeggio_bpm.connect('value-changed', self.on_changed)
        box = gu.hig_label_widget(_("A_rpeggio bpm:"), self.g_arpeggio_bpm, sizegroup)
        category_vbox.pack_start(box, False)

        box, category_vbox = gu.hig_category_vbox(_("Preferred instrument"))
        page_vbox.pack_start(box, False)
        self.g_instrsel = NewReadOnlyInstrumentSelector('config',
                        'preferred_instrument', sizegroup, self.on_changed)
        category_vbox.pack_start(self.g_instrsel, False)
        ########
        # user #
        ########
        page_vbox = gu.hig_dlg_vbox()
        self.append_page(page_vbox, gtk.Label(_("User")))

        box, category_vbox = gu.hig_category_vbox(_("Users voice"))
        page_vbox.pack_start(box, False)
        sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)

        self.g_highest_singable = widgets.NotenameSpinButton(
            self.get_string('user/highest_pitch'))
        self.g_highest_singable.connect('value-changed', self.on_changed)
        box = gu.hig_label_widget(_("Highest note user can sing:"),
                                  self.g_highest_singable,
                                  sizegroup)
        category_vbox.pack_start(box)

        self.g_lowest_singable = widgets.NotenameSpinButton(
            self.get_string('user/lowest_pitch'))
        self.g_lowest_singable.connect('value-changed', self.on_changed)
        box = gu.hig_label_widget(_("Lowest note user can sing:"),
                                  self.g_lowest_singable,
                                  sizegroup)
        category_vbox.pack_start(box)
        widgets.NotenameRangeController(
                  self.g_lowest_singable, self.g_highest_singable,
                  mpd.LOWEST_NOTENAME, mpd.HIGHEST_NOTENAME)


        box, category_vbox = gu.hig_category_vbox(_("Sex"))
        page_vbox.pack_start(box, False)
        self.g_sex_male = gtk.RadioButton(None, _("_Male"))
        self.g_sex_male.connect('clicked', self.on_changed)
        category_vbox.pack_start(self.g_sex_male, False)
        self.g_sex_female = gtk.RadioButton(self.g_sex_male, _("_Female"))
        self.g_sex_female.connect('clicked', self.on_changed)
        category_vbox.pack_start(self.g_sex_female, False)
        if self.get_string('user/sex') == 'female':
            self.g_sex_female.set_active(True)
        #######
        # gui #
        #######
        page_vbox = gu.hig_dlg_vbox()
        self.append_page(page_vbox, gtk.Label(_("Gui")))

        box, category_vbox = gu.hig_category_vbox(_("Main toolbar"))
        page_vbox.pack_start(box, False)

        self.g_toolbar_checkbutton = gtk.CheckButton(_("Show"))
        self.g_toolbar_checkbutton.connect('clicked', lambda w: self.g_toolbar_radio_box.set_sensitive(w.get_active()))
        self.g_toolbar_checkbutton.connect('clicked', self.on_changed)
        category_vbox.pack_start(self.g_toolbar_checkbutton)

        self.g_toolbar_radio_box = hbox = gtk.HBox()
        category_vbox.pack_start(hbox)
        self.g_toolbar_checkbutton.set_active(self.get_bool('gui/toolbar_visible'))
        self.g_toolbar_radio_box.set_sensitive(self.get_bool('gui/toolbar_visible'))
        self.add_watch('gui/toolbar_visible', self._watch_toolbar_radios)

        self.g_toolbar_icons = gu.RadioButton(None, _("Icons"), self.on_changed)
        hbox.pack_start(self.g_toolbar_icons, False)
        self.g_toolbar_text = gu.RadioButton(self.g_toolbar_icons, _("Text"), self.on_changed)
        hbox.pack_start(self.g_toolbar_text, False)
        self.g_toolbar_both = gu.RadioButton(self.g_toolbar_icons, _("Both"), self.on_changed)
        hbox.pack_start(self.g_toolbar_both, False)
        self.__dict__['g_toolbar_'+self.get_string('gui/toolbar_style=icons')].set_active(True)

        box, category_vbox = gu.hig_category_vbox(_("Navigation toolbar"))
        page_vbox.pack_start(box, False)

        self.g_navbar_checkbutton = gtk.CheckButton(_("Show"))
        self.g_navbar_checkbutton.connect('clicked', lambda w: self.g_navbar_radio_box.set_sensitive(w.get_active()))
        self.g_navbar_checkbutton.connect('clicked', self.on_changed)
        category_vbox.pack_start(self.g_navbar_checkbutton)

        self.g_navbar_radio_box = hbox = gtk.HBox()
        category_vbox.pack_start(hbox)
        self.g_navbar_checkbutton.set_active(self.get_bool('gui/navbar_visible'))
        self.g_navbar_radio_box.set_sensitive(self.get_bool('gui/navbar_visible'))
        self.add_watch('gui/navbar_visible', self._watch_navbar_radios)

        self.g_navbar_icons = gu.RadioButton(None, _("Icons"), self.on_changed)
        hbox.pack_start(self.g_navbar_icons, False)
        self.g_navbar_text = gu.RadioButton(self.g_navbar_icons, _("Text"), self.on_changed)
        hbox.pack_start(self.g_navbar_text, False)
        self.g_navbar_both = gu.RadioButton(self.g_navbar_icons, _("Both"), self.on_changed)
        hbox.pack_start(self.g_navbar_both, False)
        self.__dict__['g_navbar_'+self.get_string('gui/navbar_style=icons')].set_active(True)

        self._is_alive = 1#FIXME move farther down??

        box, category_vbox = gu.hig_category_vbox(_("External programs"))
        page_vbox.pack_start(box, False)
        sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)

        self.g_mail_program = gtk.Entry()
        self.g_mail_program.set_text(self.get_string("config/mua"))
        self.g_mail_program.connect('changed', self.on_changed)
        box = gu.hig_label_widget(_("_Mail program:"), self.g_mail_program, sizegroup)
        category_vbox.pack_start(box)

        box, category_vbox = gu.hig_category_vbox(_("Misc"))
        page_vbox.pack_start(box, False)

        self.g_mainwin_user_resizeable = gtk.CheckButton(
              _("_User resizeable main window"))
        self.g_mainwin_user_resizeable.connect('clicked', self.on_changed)
        self.g_mainwin_user_resizeable.set_active(
                        self.get_bool('gui/mainwin_user_resizeable'))
        self.add_watch('gui/mainwin_user_resizeable',
                lambda key: self.g_mainwin_user_resizeable.set_active(
                            self.get_bool('gui/mainwin_user_resizeable')))
        category_vbox.pack_start(self.g_mainwin_user_resizeable, False)
        ############
        # Practise #
        ############
        page_vbox = gu.hig_dlg_vbox()
        self.append_page(page_vbox, gtk.Label(_("Practise")))

        box, category_vbox = gu.hig_category_vbox(_("Practise"))
        page_vbox.pack_start(box, False)

        self.g_picky_on_new_question = gtk.CheckButton(_("_Not allow new question before the old is solved"))
        self.g_picky_on_new_question.set_active(self.get_bool('config/picky_on_new_question'))
        category_vbox.pack_start(self.g_picky_on_new_question, False)

        self.g_autorepeat_if_wrong = gtk.CheckButton(_("_Repeat question if the answer was wrong"))
        self.g_autorepeat_if_wrong.set_active(self.get_bool('config/auto_repeat_question_if_wrong_answer'))
        category_vbox.pack_start(self.g_autorepeat_if_wrong, False)

        self.g_picky_on_new_question.connect('clicked', self.on_changed)
        self.g_autorepeat_if_wrong.connect('clicked', self.on_changed)

        #########
        # sound #
        #########
        if sys.platform == 'win32':
            self.create_win32_sound_page()
        else:
            self.create_linux_sound_page()
        self.show_all()
    def _watch_toolbar_radios(self, key):
        self.g_toolbar_checkbutton.set_active(self.get_bool('gui/toolbar_visible'))
    def _watch_navbar_radios(self, key):
        self.g_navbar_checkbutton.set_active(self.get_bool('gui/navbar_visible'))
    def create_linux_sound_page(self):
        page_vbox = gu.hig_dlg_vbox()
        self.append_page(page_vbox, gtk.Label(_("Sound setup")))

        box, category_vbox = gu.hig_category_vbox(_("External programs"))
        page_vbox.pack_start(box, False)

        sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        self.g_wav_player = gtk.Combo()
        self.g_wav_player.set_popdown_strings(find_wav_player_programs())
        self.g_wav_player.entry.set_text(cfg.get_string('sound/wav_player'))
        self.g_wav_player.entry.connect('changed', self.on_changed)
        button = gtk.Button(_("Test"))
        button.connect('clicked', self.test_wav_player)
        box = gu.hig_label_widget(".wav file player",
                                  [self.g_wav_player, button],
                                  sizegroup)
        category_vbox.pack_start(box)

        self.g_midi_player = gtk.Combo()
        self.g_midi_player.set_popdown_strings(find_midi_player_programs())
        self.g_midi_player.entry.set_text(cfg.get_string('sound/midi_player'))
        self.g_midi_player.entry.connect('changed', self.on_changed)
        button = gtk.Button(_("Test"))
        button.connect('clicked', self.test_midi_player)
        box = gu.hig_label_widget(".midi file player",
                                  [self.g_midi_player, button],
                                  sizegroup)
        category_vbox.pack_start(box)

        box, category_vbox = gu.hig_category_vbox(_("Sound setup"))
        page_vbox.pack_start(box)

        self.g_fakesynth_radio = gu.RadioButton(None, _("_No sound"), None)
        category_vbox.pack_start(self.g_fakesynth_radio, False)
        hbox = gu.bHBox(category_vbox, False)
        self.g_device_radio = gu.RadioButton(self.g_fakesynth_radio,
              _("Use _device"), None)
        hbox.pack_start(self.g_device_radio, False)
        combo = gtk.Combo()
        combo.set_popdown_strings(('/dev/sequencer', '/dev/sequencer2',
                                   '/dev/music'))
        self.g_device_entry = combo.entry
        self.g_device_entry.set_text(self.get_string('sound/device_file'))
        self.g_synth_num = gtk.SpinButton(gtk.Adjustment(0, 0, 100, 1, 1),
                             digits=0)
        self.g_synth_num.set_value(self.get_int('sound/synth_number'))
        hbox.pack_start(combo, False)
        hbox.pack_start(self.g_synth_num, False)

        # checkbox to enable awe support
        hbox = gtk.HBox()
        category_vbox.pack_start(hbox, False)
        hbox.pack_start(gtk.Label("    "))
        self.g_awe_checkbutton = gtk.CheckButton(_("_My sound card is Sound Blaster AWE32, AWE64 or pnp32"))
        self.g_awe_checkbutton.set_active(self.get_string('sound/card_info') == 'awe')
        if not configureoutput.HAVE_LINUX_AWE_VOICE_H:
            self.g_awe_checkbutton.set_sensitive(False)
        else:
            self.g_awe_checkbutton.set_sensitive(self.get_string("sound/type") == "sequencer-device")
        hbox.pack_start(self.g_awe_checkbutton, False)
        ###
        hbox = gu.bHBox(category_vbox, False)
        self.g_midiplayer_radio = gu.RadioButton(self.g_fakesynth_radio,
             _("Use _external midiplayer"), None)
        hbox.pack_start(self.g_midiplayer_radio, False)
        if self.get_string("sound/type") == "external-midiplayer":
            self.g_midiplayer_radio.set_active(True)
        elif self.get_string("sound/type") == "sequencer-device":
            self.g_device_radio.set_active(True)
        else:
            self.g_fakesynth_radio.set_active(True)


        gu.bButton(category_vbox, _("Sound _test. Hit 'Apply' before testing."), self.on_sound_test, False, False)

        self.g_fakesynth_radio.connect('clicked', self.on_changed)
        self.g_midiplayer_radio.connect('clicked', self.on_changed)
        self.g_device_radio.connect('clicked', self.on_changed)
        self.g_device_radio.connect('toggled', lambda w: self.g_awe_checkbutton.set_sensitive(w.get_active()))
        self.g_device_entry.connect('changed', self.on_changed)
        self.g_synth_num.connect('value-changed', self.on_changed)
        self.g_awe_checkbutton.connect('clicked', self.on_changed)
    def create_win32_sound_page(self):
        page_vbox = gu.hig_dlg_vbox()
        self.append_page(page_vbox, gtk.Label(_("Sound setup")))

        box, category_vbox = gu.hig_category_vbox(_("External programs"))
        page_vbox.pack_start(box, False)

        sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)

        self.g_midi_player = gtk.Combo()
        self.g_midi_player.set_popdown_strings(('/usr/bin/timidity -idqq %s',
                                               '/usr/bin/playmidi -f %s'))
        self.g_midi_player.entry.set_text(cfg.get_string('sound/midi_player'))
        self.g_midi_player.entry.connect('changed', self.on_changed)
        button = gtk.Button(_("Test"))
        button.connect('clicked', self.test_midi_player)
        box = gu.hig_label_widget(".midi file player",
                                  [self.g_midi_player, button],
                                  sizegroup)
        category_vbox.pack_start(box)

        box, category_vbox = gu.hig_category_vbox(_("Sound setup"))
        page_vbox.pack_start(box)
        txt = gtk.Label(_("""Solfege has two ways to play midi files. It is recommended to use Windows multimedia output. An external midiplayer can be useful if your soundcard lack a hardware synth, and you have to use a program like timidity to play the music."""))
        txt.set_line_wrap(1)
        txt.set_justify(gtk.JUSTIFY_FILL)
        txt.set_alignment(0.0, 0.0)
        category_vbox.pack_start(txt, False)
        self.g_fakesynth_radio = gu.RadioButton(None, _("_No sound"), None)
        category_vbox.pack_start(self.g_fakesynth_radio, False)
        hbox = gu.bHBox(category_vbox, False)
        self.g_device_radio = gu.RadioButton(self.g_fakesynth_radio,
              _("_Windows multimedia output, synth number:"), None)
        self.g_synth_num = gtk.SpinButton(gtk.Adjustment(0, 0, 100, 1, 1),
                             digits=0)
        self.g_synth_num.set_value(self.get_int('sound/synth_number'))
        hbox.pack_start(self.g_device_radio, False)
        hbox.pack_start(self.g_synth_num, False)

        hbox = gu.bHBox(category_vbox, False)
        self.g_midiplayer_radio = gu.RadioButton(self.g_fakesynth_radio,
             _("Use _external midiplayer"), None)
        hbox.pack_start(self.g_midiplayer_radio, False)
        if self.get_string("sound/type") == "external-midiplayer":
            self.g_midiplayer_radio.set_active(True)
        elif self.get_string("sound/type") == "winsynth":
            self.g_device_radio.set_active(True)
        else:
            self.g_fakesynth_radio.set_active(True)

        gu.bButton(category_vbox, _("Sound _test. Hit 'Apply' before testing."), self.on_sound_test)

        self.g_fakesynth_radio.connect('clicked', self.on_changed)
        self.g_midiplayer_radio.connect('clicked', self.on_changed)
        self.g_synth_num.connect('changed', self.on_changed)
        self.g_device_radio.connect('clicked', self.on_changed)
    def test_midi_player(self, w):
        app.run_external_program(self.g_midi_player.entry.get_text(),
                        'lesson-files/share', 'fanfare.midi')
    def test_wav_player(self, w):
        app.run_external_program(self.g_wav_player.entry.get_text(),
                        'lesson-files/share', 'fifth-small-220.00.wav')
    def on_sound_test(self, w):
        mpd.play_music(r"""
        \staff\relative c{
          c16 e g c e, g c e g, c e g c4
        }
        \staff{
          c4 e g8 e c4
        }
        """, 130, 0, 100)
    def on_help(self, *v):
        #FIXME It is stupid to display this help in the main window.
        self.m_app.handle_href("preferences-window.html")
    def on_changed(self, *_o):
        if self._is_alive:
            self.set_modified(True)
    def on_apply(self, _o, pagenum):
        card_info = ""
        if pagenum == 0:
            #self.set_int('config/slow_bpm', int(self.g_slow_bpm.get_text()))
            self.set_int('config/default_bpm',
                         int(self.g_default_bpm.get_text()))
            self.set_int('config/arpeggio_bpm',
                         int(self.g_arpeggio_bpm.get_text()))
            self.set_int('config/preferred_instrument',
                         self.g_instrsel.m_instrument)
            self.set_int('config/preferred_instrument_velocity',
                         self.g_instrsel.g_velocity.get_value_as_int())
        if pagenum == 1:
            self.set_string('user/lowest_pitch',
                mpd.int_to_notename(self.g_lowest_singable.get_value()))
            self.set_string('user/highest_pitch',
                mpd.int_to_notename(self.g_highest_singable.get_value()))
            if self.g_sex_male.get_active():
                self.set_string('user/sex', 'male')
            else:
                self.set_string('user/sex', 'female')
        if pagenum == 2:
            if self.g_toolbar_text.get_active():
                self.m_app.m_ui.g_toolbar.set_style(gtk.TOOLBAR_TEXT)
                self.set_string('gui/toolbar_style', 'text')
            elif self.g_toolbar_icons.get_active():
                self.m_app.m_ui.g_toolbar.set_style(gtk.TOOLBAR_ICONS)
                self.set_string('gui/toolbar_style', 'icons')
            elif self.g_toolbar_both.get_active():
                self.m_app.m_ui.g_toolbar.set_style(gtk.TOOLBAR_BOTH)
                self.set_string('gui/toolbar_style', 'both')
            if self.g_toolbar_checkbutton.get_active():
                self.m_app.m_ui.get_dock_item_by_name('toolbar').show()
                self.set_bool('gui/toolbar_visible', 1)
            else:
                self.set_bool('gui/toolbar_visible', 0)
                self.m_app.m_ui.get_dock_item_by_name('toolbar').hide()

            if self.g_navbar_text.get_active():
                self.m_app.m_ui.g_navbar.set_style(gtk.TOOLBAR_TEXT)
                self.set_string('gui/navbar_style', 'text')
            elif self.g_navbar_icons.get_active():
                self.m_app.m_ui.g_navbar.set_style(gtk.TOOLBAR_ICONS)
                self.set_string('gui/navbar_style', 'icons')
            elif self.g_navbar_both.get_active():
                self.m_app.m_ui.g_navbar.set_style(gtk.TOOLBAR_BOTH)
                self.set_string('gui/navbar_style', 'both')
            if self.g_navbar_checkbutton.get_active():
                self.m_app.m_ui.get_dock_item_by_name('navbar').show()
                self.set_bool('gui/navbar_visible', 1)
            else:
                self.m_app.m_ui.get_dock_item_by_name('navbar').hide()
                self.set_bool('gui/navbar_visible', 0)
            self.set_bool('gui/mainwin_user_resizeable',
                          self.g_mainwin_user_resizeable.get_active())
            self.m_app.m_ui.set_resizable(self.get_bool('gui/mainwin_user_resizeable'))
            self.set_string("config/mua", self.g_mail_program.get_text())
        if pagenum == 3:
            self.set_bool('config/picky_on_new_question',
                          self.g_picky_on_new_question.get_active())
            self.set_bool('config/auto_repeat_question_if_wrong_answer',
                          self.g_autorepeat_if_wrong.get_active())
        if pagenum == 4:
            if soundcard.synth:
                soundcard.synth.close()
            if self.g_midiplayer_radio.get_active():
                soundcard.initialise_external_midiplayer(
                      self.g_midi_player.entry.get_text())
            elif self.g_device_radio.get_active():
                if sys.platform != 'win32' and configureoutput.HAVE_LINUX_AWE_VOICE_H and \
                    self.g_awe_checkbutton.get_active():
                    card_info = "awe"
                else:
                    card_info = ""
                try:
                    if sys.platform == 'win32':
                        soundcard.initialise_winsynth(self.g_synth_num.get_value_as_int())
                    else:
                        soundcard.initialise_devicefile(
                            self.g_device_entry.get_text(),
                            self.g_synth_num.get_value_as_int(),
                            card_info)
                except (soundcard.SoundInitException, OSError), e:
                    self.m_app.display_sound_init_error_message(e)
                    return
            else: # no sound
                assert self.g_fakesynth_radio.get_active()
                soundcard.initialise_using_fake_synth(0)
            if self.g_midiplayer_radio.get_active():
                self.set_string("sound/type", "external-midiplayer")
            elif self.g_device_radio.get_active():
                if sys.platform == "win32":
                    self.set_string("sound/type", "winsynth")
                else:
                    self.set_string("sound/type", "sequencer-device")
            else:
                assert self.g_fakesynth_radio.get_active()
                self.set_string("sound/type", "fake-synth")
            if sys.platform != 'win32':
                self.set_string("sound/device_file", self.g_device_entry.get_text())
                self.set_string("sound/card_info", card_info)
            if soundcard.synth.m_type_major not in ('Midifile', 'Fake'):
                self.set_int("sound/synth_number", soundcard.synth.m_devnum)
                # we set the spin just in case m_devnum was changed by the
                # soundcard setup code, if it was out of range
                self.g_synth_num.set_value(soundcard.synth.m_devnum)
            self.set_string("sound/midi_player",
                            self.g_midi_player.entry.get_text())
        if pagenum == -1:
            pass
    def _watch_toggle_callback(self, widget, key):
        widget.set_active(self.get_bool(key))

