/* 
   This file is public domain.

   The data is a matter of public record, and comes from
   http://www.letadla.info/
 */


SET search_path TO sqltutor;

DROP TABLE letecke_spolecnosti CASCADE;

CREATE TABLE letecke_spolecnosti (
    id          INTEGER PRIMARY KEY,
    spolecnost  VARCHAR(40)  NOT NULL,
    zeme        VARCHAR(20),
    svetadil    VARCHAR(20),
    aliance     VARCHAR(20)  NULL,
    zalozeno    INTEGER
);

DROP TABLE letecke_flotily CASCADE;

CREATE TABLE letecke_flotily (
    spolecnost_id  INTEGER REFERENCES letecke_spolecnosti(id),
    letadlo_id     INTEGER REFERENCES dopravni_letadla(id),
    pocet_letadel  INTEGER,

    PRIMARY KEY (spolecnost_id, letadlo_id)    
);

BEGIN;

CREATE TEMPORARY TABLE tmp_letecke_flotily (
    spolecnost_id  INTEGER,
    letadlo_id     INTEGER,
    pocet_letadel  INTEGER
);

INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 1, 'Air Algerie', 'Alžírsko', 'Afrika', NULL, 1947 );
INSERT INTO tmp_letecke_flotily VALUES ( 1, 6, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 1, 6, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 1, 7, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 1, 16, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 1, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 1, 30, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 1, 30, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 1, 33, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 1, 56, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 1, 65, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 2, 'Tassilli Airlines', 'Alžírsko', 'Afrika', NULL, 1997 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 3, 'Ethiopian Airlines', 'Etiopie', 'Afrika', NULL, 1945 );
INSERT INTO tmp_letecke_flotily VALUES ( 3, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 3, 30, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 3, 32, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 3, 32, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 3, 33, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 3, 33, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 3, 66, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 3, 58, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 3, 65, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 4, 'Aerogem Aviation', 'Ghana', 'Afrika', NULL, 2000 );
INSERT INTO tmp_letecke_flotily VALUES ( 4, 26, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 5, 'Antrak Air', 'Ghana', 'Afrika', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 5, 68, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 6, 'Cargoplus Aviation', 'Ghana', 'Afrika', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 6, 26, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 6, 67, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 7, 'Ghana International Airlines', 'Ghana', 'Afrika', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 7, 33, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 8, 'Johnsons Air', 'Ghana', 'Afrika', NULL, 1996 );
INSERT INTO tmp_letecke_flotily VALUES ( 8, 67, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 9, 'MK Airlines', 'Ghana', 'Afrika', NULL, 1990 );
INSERT INTO tmp_letecke_flotily VALUES ( 9, 31, 7 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 10, 'Atlas Blue', 'Maroko', 'Afrika', NULL, 2004 );
INSERT INTO tmp_letecke_flotily VALUES ( 10, 6, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 10, 30, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 11, 'Jet4you', 'Maroko', 'Afrika', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 11, 30, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 12, 'Regional Air Lines', 'Maroko', 'Afrika', NULL, 1997 );
INSERT INTO tmp_letecke_flotily VALUES ( 12, 15, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 13, 'Royal Air Maroc', 'Maroko', 'Afrika', NULL, 1957 );
INSERT INTO tmp_letecke_flotily VALUES ( 13, 6, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 13, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 13, 30, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 13, 30, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 13, 30, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 13, 31, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 13, 32, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 13, 33, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 14, 'Air Hong Kong', 'Hong Kong', 'Asie', NULL, 1986 );
INSERT INTO tmp_letecke_flotily VALUES ( 14, 1, 8 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 15, 'Cathay Pacific', 'Hong Kong', 'Asie', 'oneworld', 1946 );
INSERT INTO tmp_letecke_flotily VALUES ( 15, 7, 27 );
INSERT INTO tmp_letecke_flotily VALUES ( 15, 8, 15 );
INSERT INTO tmp_letecke_flotily VALUES ( 15, 8, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 15, 31, 8 );
INSERT INTO tmp_letecke_flotily VALUES ( 15, 31, 22 );
INSERT INTO tmp_letecke_flotily VALUES ( 15, 31, 11 );
INSERT INTO tmp_letecke_flotily VALUES ( 15, 34, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 15, 34, 12 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 16, 'Dragonair', 'Hong Kong', 'Asie', NULL, 1985 );
INSERT INTO tmp_letecke_flotily VALUES ( 16, 5, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 16, 6, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 16, 7, 12 );
INSERT INTO tmp_letecke_flotily VALUES ( 16, 31, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 16, 31, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 16, 31, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 17, 'Hong Kong Airlines', 'Hong Kong', 'Asie', NULL, 2001 );
INSERT INTO tmp_letecke_flotily VALUES ( 17, 30, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 18, 'Hong Kong Express Airways', 'Hong Kong', 'Asie', NULL, 1997 );
INSERT INTO tmp_letecke_flotily VALUES ( 18, 30, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 19, 'Oasis Hong Kong Airlines', 'Hong Kong', 'Asie', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 19, 31, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 20, 'Arkia Israel Airlines', 'Izrael', 'Asie', NULL, 1949 );
INSERT INTO tmp_letecke_flotily VALUES ( 20, 16, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 20, 32, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 20, 42, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 21, 'CAL Cargo Air Lines', 'Izrael', 'Asie', NULL, 1976 );
INSERT INTO tmp_letecke_flotily VALUES ( 21, 31, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 22, 'El Al', 'Izrael', 'Asie', NULL, 1948 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 30, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 31, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 31, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 31, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 31, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 32, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 33, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 33, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 33, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 22, 34, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 23, 'Israir', 'Izrael', 'Asie', NULL, 1989 );
INSERT INTO tmp_letecke_flotily VALUES ( 23, 5, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 23, 15, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 23, 33, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 24, 'Sun D''Or', 'Izrael', 'Asie', NULL, 1977 );
INSERT INTO tmp_letecke_flotily VALUES ( 24, 32, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 25, 'Asiana Airlines', 'Jižní Korea', 'Asie', 'Star Alliance', 1988 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 5, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 6, 11 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 7, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 30, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 30, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 31, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 31, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 31, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 33, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 33, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 25, 34, 8 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 26, 'Hansung Airlines', 'Jižní Korea', 'Asie', NULL, 2004 );
INSERT INTO tmp_letecke_flotily VALUES ( 26, 16, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 27, 'Jeju Air', 'Jižní Korea', 'Asie', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 27, 43, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 28, 'Korean Air', 'Jižní Korea', 'Asie', 'SkyTeam', 1962 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 1, 8 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 1, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 7, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 7, 16 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 30, 16 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 30, 16 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 31, 23 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 31, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 31, 8 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 31, 13 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 34, 13 );
INSERT INTO tmp_letecke_flotily VALUES ( 28, 34, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 29, 'AirAsia', 'Malajsie', 'Asie', NULL, 1993 );
INSERT INTO tmp_letecke_flotily VALUES ( 29, 5, 22 );
INSERT INTO tmp_letecke_flotily VALUES ( 29, 30, 11 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 30, 'Berjaya Air', 'Malajsie', 'Asie', NULL, 1989 );
INSERT INTO tmp_letecke_flotily VALUES ( 30, 42, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 31, 'Firefly', 'Malajsie', 'Asie', NULL, 2007 );
INSERT INTO tmp_letecke_flotily VALUES ( 31, 58, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 32, 'FlyAsianXpress', 'Malajsie', 'Asie', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 32, 58, 7 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 33, 'Malaysia Airlines', 'Malajsie', 'Asie', NULL, 1947 );
INSERT INTO tmp_letecke_flotily VALUES ( 33, 7, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 33, 7, 11 );
INSERT INTO tmp_letecke_flotily VALUES ( 33, 30, 36 );
INSERT INTO tmp_letecke_flotily VALUES ( 33, 31, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 33, 31, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 33, 31, 15 );
INSERT INTO tmp_letecke_flotily VALUES ( 33, 31, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 33, 34, 17 );
INSERT INTO tmp_letecke_flotily VALUES ( 33, 58, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 34, 'Transmile Air Services', 'Malajsie', 'Asie', NULL, 1993 );
INSERT INTO tmp_letecke_flotily VALUES ( 34, 29, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 34, 72, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 35, 'Aircruising Australia', 'Austrálie', 'Austrálie', NULL, 1983 );
INSERT INTO tmp_letecke_flotily VALUES ( 35, 56, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 36, 'AirNorth Regional', 'Austrálie', 'Austrálie', NULL, 1978 );
INSERT INTO tmp_letecke_flotily VALUES ( 36, 47, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 36, 48, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 36, 53, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 37, 'Aliance Airlines', 'Austrálie', 'Austrálie', NULL, 2002 );
INSERT INTO tmp_letecke_flotily VALUES ( 37, 60, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 37, 58, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 38, 'Asian Express Airlines', 'Austrálie', 'Austrálie', NULL, 1996 );
INSERT INTO tmp_letecke_flotily VALUES ( 38, 29, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 39, 'Australian Air Express', 'Austrálie', 'Austrálie', NULL, 1992 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 40, 'Eastern Australia Airlines', 'Austrálie', 'Austrálie', NULL, 1949 );
INSERT INTO tmp_letecke_flotily VALUES ( 40, 43, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 40, 43, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 40, 43, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 40, 43, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 41, 'Jetstar Airways', 'Austrálie', 'Austrálie', NULL, 2004 );
INSERT INTO tmp_letecke_flotily VALUES ( 41, 5, 23 );
INSERT INTO tmp_letecke_flotily VALUES ( 41, 7, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 42, 'Macair Airlines', 'Austrálie', 'Austrálie', NULL, 1992 );
INSERT INTO tmp_letecke_flotily VALUES ( 42, 15, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 42, 20, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 42, 53, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 42, 54, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 42, 55, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 42, 8, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 42, 81, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 43, 'Maroomba Airlines', 'Austrálie', 'Austrálie', NULL, 1985 );
INSERT INTO tmp_letecke_flotily VALUES ( 43, 43, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 44, 'National Jet Systems', 'Austrálie', 'Austrálie', NULL, 1989 );
INSERT INTO tmp_letecke_flotily VALUES ( 44, 17, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 44, 18, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 44, 19, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 44, 24, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 44, 27, 8 );
INSERT INTO tmp_letecke_flotily VALUES ( 44, 43, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 45, 'OzJet', 'Austrálie', 'Austrálie', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 45, 30, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 46, 'Qantas', 'Austrálie', 'Austrálie', 'oneworld', 1920 );
INSERT INTO tmp_letecke_flotily VALUES ( 46, 7, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 46, 30, 18 );
INSERT INTO tmp_letecke_flotily VALUES ( 46, 30, 33 );
INSERT INTO tmp_letecke_flotily VALUES ( 46, 31, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 46, 31, 24 );
INSERT INTO tmp_letecke_flotily VALUES ( 46, 31, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 46, 33, 28 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 47, 'QantasLink', 'Austrálie', 'Austrálie', NULL, 2002 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 48, 'Queensland Regional Airlines', 'Austrálie', 'Austrálie', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 48, 43, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 49, 'Regional Express Airlines', 'Austrálie', 'Austrálie', NULL, 2002 );
INSERT INTO tmp_letecke_flotily VALUES ( 49, 53, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 49, 8, 32 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 50, 'Skippers Aviation', 'Austrálie', 'Austrálie', NULL, 1990 );
INSERT INTO tmp_letecke_flotily VALUES ( 50, 43, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 50, 43, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 50, 48, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 50, 53, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 51, 'Skytrans Airlines', 'Austrálie', 'Austrálie', NULL, 1993 );
INSERT INTO tmp_letecke_flotily VALUES ( 51, 43, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 52, 'Skywest Airlines', 'Austrálie', 'Austrálie', NULL, 1963 );
INSERT INTO tmp_letecke_flotily VALUES ( 52, 60, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 52, 58, 7 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 53, 'Sunstate Airlines', 'Austrálie', 'Austrálie', NULL, 1974 );
INSERT INTO tmp_letecke_flotily VALUES ( 53, 43, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 53, 43, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 53, 43, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 53, 43, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 54, 'Virgin Blue', 'Austrálie', 'Austrálie', NULL, 2000 );
INSERT INTO tmp_letecke_flotily VALUES ( 54, 30, 22 );
INSERT INTO tmp_letecke_flotily VALUES ( 54, 30, 27 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 55, 'Air Chathams', 'Nový Zéland', 'Austrálie', NULL, 1986 );
INSERT INTO tmp_letecke_flotily VALUES ( 55, 40, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 55, 55, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 56, 'Air Freight NZ', 'Nový Zéland', 'Austrálie', NULL, 1989 );
INSERT INTO tmp_letecke_flotily VALUES ( 56, 40, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 57, 'Air Nelson', 'Nový Zéland', 'Austrálie', NULL, 1979 );
INSERT INTO tmp_letecke_flotily VALUES ( 57, 43, 15 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 58, 'Air New Zealand', 'Nový Zéland', 'Austrálie', 'Star Alliance', 1940 );
INSERT INTO tmp_letecke_flotily VALUES ( 58, 5, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 58, 30, 13 );
INSERT INTO tmp_letecke_flotily VALUES ( 58, 31, 8 );
INSERT INTO tmp_letecke_flotily VALUES ( 58, 33, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 58, 34, 8 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 59, 'Air Post', 'Nový Zéland', 'Austrálie', NULL, 1990 );
INSERT INTO tmp_letecke_flotily VALUES ( 59, 55, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 60, 'Airwork', 'Nový Zéland', 'Austrálie', NULL, 1984 );
INSERT INTO tmp_letecke_flotily VALUES ( 60, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 60, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 60, 53, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 60, 55, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 60, 56, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 61, 'Eagle Airways', 'Nový Zéland', 'Austrálie', NULL, 1969 );
INSERT INTO tmp_letecke_flotily VALUES ( 61, 78, 17 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 62, 'Freedom Air', 'Nový Zéland', 'Austrálie', NULL, 1995 );
INSERT INTO tmp_letecke_flotily VALUES ( 62, 5, 9 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 63, 'JetConnect', 'Nový Zéland', 'Austrálie', NULL, 2002 );
INSERT INTO tmp_letecke_flotily VALUES ( 63, 30, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 63, 30, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 64, 'Mount Cook Airline', 'Nový Zéland', 'Austrálie', NULL, 1920 );
INSERT INTO tmp_letecke_flotily VALUES ( 64, 16, 11 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 65, 'Pacific Blue Airlines', 'Nový Zéland', 'Austrálie', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 65, 30, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 66, 'Vincent Aviation', 'Nový Zéland', 'Austrálie', NULL, 1992 );
INSERT INTO tmp_letecke_flotily VALUES ( 66, 43, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 67, 'Ada Air', 'Albánie', 'Evropa', NULL, 1991 );
INSERT INTO tmp_letecke_flotily VALUES ( 67, 47, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 68, 'Albanian Airlines', 'Albánie', 'Evropa', NULL, 1992 );
INSERT INTO tmp_letecke_flotily VALUES ( 68, 17, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 68, 18, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 68, 19, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 68, 58, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 69, 'Belle Air', 'Albánie', 'Evropa', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 69, 18, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 69, 19, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 69, 60, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 69, 73, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 70, 'Brussels Airlines', 'Belgie', 'Evropa', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 70, 4, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 70, 7, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 70, 18, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 70, 23, 12 );
INSERT INTO tmp_letecke_flotily VALUES ( 70, 25, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 70, 30, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 70, 30, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 71, 'European Air Transport', 'Belgie', 'Evropa', NULL, 1971 );
INSERT INTO tmp_letecke_flotily VALUES ( 71, 1, 15 );
INSERT INTO tmp_letecke_flotily VALUES ( 71, 32, 11 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 72, 'Jetairfly', 'Belgie', 'Evropa', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 72, 5, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 72, 30, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 72, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 72, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 72, 33, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 72, 60, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 73, 'Thomas Cook Airlines', 'Belgie', 'Evropa', NULL, 2001 );
INSERT INTO tmp_letecke_flotily VALUES ( 73, 5, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 74, 'TNT Airways', 'Belgie', 'Evropa', NULL, 1999 );
INSERT INTO tmp_letecke_flotily VALUES ( 74, 1, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 74, 18, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 74, 19, 8 );
INSERT INTO tmp_letecke_flotily VALUES ( 74, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 74, 30, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 74, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 74, 31, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 75, 'VLM Airlines', 'Belgie', 'Evropa', NULL, 1992 );
INSERT INTO tmp_letecke_flotily VALUES ( 75, 19, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 75, 58, 19 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 76, 'Air Sofia', 'Bulharsko', 'Evropa', NULL, 1992 );
INSERT INTO tmp_letecke_flotily VALUES ( 76, 11, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 77, 'Air Via', 'Bulharsko', 'Evropa', NULL, 1990 );
INSERT INTO tmp_letecke_flotily VALUES ( 77, 5, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 78, 'BH Air - Balkan Holidays', 'Bulharsko', 'Evropa', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 78, 5, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 78, 86, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 79, 'Bulgaria Air', 'Bulharsko', 'Evropa', NULL, 2002 );
INSERT INTO tmp_letecke_flotily VALUES ( 79, 30, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 79, 30, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 80, 'Bulgarian Air Charter', 'Bulharsko', 'Evropa', NULL, 2000 );
INSERT INTO tmp_letecke_flotily VALUES ( 80, 73, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 80, 74, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 81, 'Hemus Air', 'Bulharsko', 'Evropa', NULL, 1991 );
INSERT INTO tmp_letecke_flotily VALUES ( 81, 18, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 81, 19, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 81, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 81, 85, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 82, 'Scorpion Air', 'Bulharsko', 'Evropa', NULL, 1990 );
INSERT INTO tmp_letecke_flotily VALUES ( 82, 11, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 82, 12, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 83, 'Vega Airlines', 'Bulharsko', 'Evropa', NULL, 1997 );
INSERT INTO tmp_letecke_flotily VALUES ( 83, 11, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 84, 'Viaggio Air', 'Bulharsko', 'Evropa', NULL, 2002 );
INSERT INTO tmp_letecke_flotily VALUES ( 84, 15, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 85, 'Wizz Air Bulgaria', 'Bulharsko', 'Evropa', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 85, 5, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 86, 'Croatia Airlines', 'Chorvatsko', 'Evropa', 'Star Alliance', 1989 );
INSERT INTO tmp_letecke_flotily VALUES ( 86, 4, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 86, 5, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 86, 15, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 87, 'Dubrovnik Airline', 'Chorvatsko', 'Evropa', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 87, 73, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 87, 74, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 88, 'Trade Air', 'Chorvatsko', 'Evropa', NULL, 1994 );
INSERT INTO tmp_letecke_flotily VALUES ( 88, 60, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 89, 'Aero Airlines', 'Estonsko', 'Evropa', NULL, 2000 );
INSERT INTO tmp_letecke_flotily VALUES ( 89, 16, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 90, 'Airest', 'Estonsko', 'Evropa', NULL, 2001 );
INSERT INTO tmp_letecke_flotily VALUES ( 90, 12, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 91, 'Avies', 'Estonsko', 'Evropa', NULL, 1991 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 92, 'Enimex', 'Estonsko', 'Evropa', NULL, 1994 );
INSERT INTO tmp_letecke_flotily VALUES ( 92, 13, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 92, 21, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 93, 'Estonian Air', 'Estonsko', 'Evropa', NULL, 1991 );
INSERT INTO tmp_letecke_flotily VALUES ( 93, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 93, 30, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 94, 'Air Aland', 'Finsko', 'Evropa', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 94, 8, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 95, 'Air Finland', 'Finsko', 'Evropa', NULL, 2002 );
INSERT INTO tmp_letecke_flotily VALUES ( 95, 32, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 96, 'Blue1', 'Finsko', 'Evropa', NULL, 1987 );
INSERT INTO tmp_letecke_flotily VALUES ( 96, 23, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 96, 25, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 96, 77, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 97, 'Finnair', 'Finsko', 'Evropa', 'oneworld', 1923 );
INSERT INTO tmp_letecke_flotily VALUES ( 97, 4, 11 );
INSERT INTO tmp_letecke_flotily VALUES ( 97, 5, 12 );
INSERT INTO tmp_letecke_flotily VALUES ( 97, 6, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 97, 8, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 97, 32, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 97, 51, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 97, 52, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 97, 69, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 97, 71, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 98, 'Finncomm Airlines', 'Finsko', 'Evropa', NULL, 1993 );
INSERT INTO tmp_letecke_flotily VALUES ( 98, 15, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 98, 16, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 98, 50, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 98, 8, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 99, 'Aigle Azur', 'Francie', 'Evropa', NULL, 1946 );
INSERT INTO tmp_letecke_flotily VALUES ( 99, 4, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 99, 5, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 99, 6, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 100, 'Air France', 'Francie', 'Evropa', 'SkyTeam', 1933 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 3, 18 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 4, 46 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 5, 13 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 5, 55 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 6, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 6, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 7, 16 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 8, 19 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 15, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 16, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 18, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 19, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 25, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 31, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 31, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 31, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 31, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 34, 25 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 34, 23 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 36, 17 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 38, 11 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 49, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 50, 28 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 52, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 60, 25 );
INSERT INTO tmp_letecke_flotily VALUES ( 100, 59, 8 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 101, 'Air Méditerranée', 'Francie', 'Evropa', NULL, 1997 );
INSERT INTO tmp_letecke_flotily VALUES ( 101, 5, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 101, 6, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 101, 6, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 102, 'Airlinair', 'Francie', 'Evropa', NULL, 1999 );
INSERT INTO tmp_letecke_flotily VALUES ( 102, 15, 18 );
INSERT INTO tmp_letecke_flotily VALUES ( 102, 16, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 103, 'Axis Airways', 'Francie', 'Evropa', NULL, 2001 );
INSERT INTO tmp_letecke_flotily VALUES ( 103, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 103, 30, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 104, 'Blue Line', 'Francie', 'Evropa', NULL, 2002 );
INSERT INTO tmp_letecke_flotily VALUES ( 104, 60, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 104, 74, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 105, 'Brit Air', 'Francie', 'Evropa', NULL, 1973 );
INSERT INTO tmp_letecke_flotily VALUES ( 105, 36, 19 );
INSERT INTO tmp_letecke_flotily VALUES ( 105, 38, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 105, 60, 13 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 106, 'CCM Airlines', 'Francie', 'Evropa', NULL, 2000 );
INSERT INTO tmp_letecke_flotily VALUES ( 106, 4, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 106, 5, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 106, 16, 7 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 107, 'Corsairfly', 'Francie', 'Evropa', NULL, 1981 );
INSERT INTO tmp_letecke_flotily VALUES ( 107, 7, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 107, 31, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 108, 'Eagle Aviation France', 'Francie', 'Evropa', NULL, 1998 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 109, 'Europe Air Post', 'Francie', 'Evropa', NULL, 1991 );
INSERT INTO tmp_letecke_flotily VALUES ( 109, 30, 15 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 110, 'L''Avion', 'Francie', 'Evropa', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 110, 32, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 111, 'Pan Européenne Air Service', 'Francie', 'Evropa', NULL, 1977 );
INSERT INTO tmp_letecke_flotily VALUES ( 111, 50, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 112, 'Régional', 'Francie', 'Evropa', NULL, 2001 );
INSERT INTO tmp_letecke_flotily VALUES ( 112, 48, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 112, 49, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 112, 50, 28 );
INSERT INTO tmp_letecke_flotily VALUES ( 112, 52, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 112, 60, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 112, 59, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 113, 'Transavia France', 'Francie', 'Evropa', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 113, 30, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 114, 'XL Airways France', 'Francie', 'Evropa', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 114, 5, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 114, 7, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 115, 'Arkefly', 'Holandsko', 'Evropa', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 115, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 115, 33, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 116, 'Denim Air', 'Holandsko', 'Evropa', NULL, 1996 );
INSERT INTO tmp_letecke_flotily VALUES ( 116, 58, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 117, 'Interstate Airlines', 'Holandsko', 'Evropa', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 117, 15, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 118, 'KLM Cityhopper', 'Holandsko', 'Evropa', NULL, 1991 );
INSERT INTO tmp_letecke_flotily VALUES ( 118, 60, 20 );
INSERT INTO tmp_letecke_flotily VALUES ( 118, 58, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 118, 59, 21 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 119, 'KLM Royal Dutch Airlines', 'Holandsko', 'Evropa', 'SkyTeam', 1919 );
INSERT INTO tmp_letecke_flotily VALUES ( 119, 7, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 119, 30, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 119, 30, 13 );
INSERT INTO tmp_letecke_flotily VALUES ( 119, 30, 15 );
INSERT INTO tmp_letecke_flotily VALUES ( 119, 30, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 119, 31, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 119, 31, 11 );
INSERT INTO tmp_letecke_flotily VALUES ( 119, 31, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 119, 34, 15 );
INSERT INTO tmp_letecke_flotily VALUES ( 119, 69, 10 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 120, 'Martinair', 'Holandsko', 'Evropa', NULL, 1958 );
INSERT INTO tmp_letecke_flotily VALUES ( 120, 5, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 120, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 120, 31, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 120, 31, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 120, 31, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 120, 33, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 120, 70, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 120, 72, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 121, 'transavia.com', 'Holandsko', 'Evropa', NULL, 1966 );
INSERT INTO tmp_letecke_flotily VALUES ( 121, 30, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 121, 30, 21 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 122, 'Aer Arann', 'Irsko', 'Evropa', NULL, 1970 );
INSERT INTO tmp_letecke_flotily VALUES ( 122, 15, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 122, 16, 9 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 123, 'Aer Lingus', 'Irsko', 'Evropa', NULL, 1936 );
INSERT INTO tmp_letecke_flotily VALUES ( 123, 5, 24 );
INSERT INTO tmp_letecke_flotily VALUES ( 123, 6, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 123, 7, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 123, 7, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 124, 'Air Contractors', 'Irsko', 'Evropa', NULL, 1972 );
INSERT INTO tmp_letecke_flotily VALUES ( 124, 1, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 124, 15, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 124, 16, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 124, 65, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 125, 'CityJet', 'Irsko', 'Evropa', NULL, 1994 );
INSERT INTO tmp_letecke_flotily VALUES ( 125, 18, 15 );
INSERT INTO tmp_letecke_flotily VALUES ( 125, 19, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 125, 25, 8 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 126, 'Futura Gael', 'Irsko', 'Evropa', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 126, 30, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 127, 'Ryanair', 'Irsko', 'Evropa', NULL, 1985 );
INSERT INTO tmp_letecke_flotily VALUES ( 127, 30, 137 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 128, 'Air Atlanta Icelandic', 'Island', 'Evropa', NULL, 1986 );
INSERT INTO tmp_letecke_flotily VALUES ( 128, 1, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 128, 31, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 128, 31, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 128, 31, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 128, 31, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 129, 'Air Iceland', 'Island', 'Evropa', NULL, 1997 );
INSERT INTO tmp_letecke_flotily VALUES ( 129, 43, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 129, 58, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 130, 'Bluebird Cargo', 'Island', 'Evropa', NULL, 2001 );
INSERT INTO tmp_letecke_flotily VALUES ( 130, 30, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 130, 30, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 131, 'Iceland Express', 'Island', 'Evropa', NULL, 2002 );
INSERT INTO tmp_letecke_flotily VALUES ( 131, 77, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 132, 'Icelandair', 'Island', 'Evropa', NULL, 1937 );
INSERT INTO tmp_letecke_flotily VALUES ( 132, 32, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 132, 32, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 132, 32, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 133, 'JetX Airlines', 'Island', 'Evropa', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 133, 30, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 133, 32, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 133, 73, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 134, 'Aurela', 'Litva', 'Evropa', NULL, 1996 );
INSERT INTO tmp_letecke_flotily VALUES ( 134, 30, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 135, 'Aviavilsa', 'Litva', 'Evropa', NULL, 1999 );
INSERT INTO tmp_letecke_flotily VALUES ( 135, 12, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 136, 'DOT LT', 'Litva', 'Evropa', NULL, 2004 );
INSERT INTO tmp_letecke_flotily VALUES ( 136, 15, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 136, 8, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 137, 'FlyLal', 'Litva', 'Evropa', NULL, 1938 );
INSERT INTO tmp_letecke_flotily VALUES ( 137, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 137, 30, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 137, 79, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 138, 'airBaltic', 'Lotyšsko', 'Evropa', NULL, 1995 );
INSERT INTO tmp_letecke_flotily VALUES ( 138, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 138, 30, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 138, 58, 8 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 139, 'Inversija', 'Lotyšsko', 'Evropa', NULL, 1991 );
INSERT INTO tmp_letecke_flotily VALUES ( 139, 63, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 140, 'KS Avia', 'Lotyšsko', 'Evropa', NULL, 2004 );
INSERT INTO tmp_letecke_flotily VALUES ( 140, 14, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 141, 'LatCharter', 'Lotyšsko', 'Evropa', NULL, 1993 );
INSERT INTO tmp_letecke_flotily VALUES ( 141, 5, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 141, 89, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 142, 'RAF-Avia', 'Lotyšsko', 'Evropa', NULL, 1991 );
INSERT INTO tmp_letecke_flotily VALUES ( 142, 12, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 142, 14, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 142, 8, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 143, 'Farnair Hungary', 'Maďarsko', 'Evropa', NULL, 1990 );
INSERT INTO tmp_letecke_flotily VALUES ( 143, 56, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 144, 'Malév Hungarian Airlines', 'Maďarsko', 'Evropa', 'oneworld', 1946 );
INSERT INTO tmp_letecke_flotily VALUES ( 144, 30, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 144, 30, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 144, 30, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 144, 33, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 144, 33, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 144, 37, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 144, 59, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 145, 'Sky Europe Hungary', 'Maďarsko', 'Evropa', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 145, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 145, 30, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 146, 'Travel Service (Hungary)', 'Maďarsko', 'Evropa', NULL, NULL );
INSERT INTO tmp_letecke_flotily VALUES ( 146, 30, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 147, 'Wizz Air', 'Maďarsko', 'Evropa', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 147, 5, 10 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 148, 'Air Berlin', 'Německo', 'Evropa', NULL, 1978 );
INSERT INTO tmp_letecke_flotily VALUES ( 148, 4, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 148, 5, 21 );
INSERT INTO tmp_letecke_flotily VALUES ( 148, 30, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 148, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 148, 30, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 148, 30, 37 );
INSERT INTO tmp_letecke_flotily VALUES ( 148, 60, 14 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 149, 'Augsburg Airways', 'Německo', 'Evropa', NULL, 1986 );
INSERT INTO tmp_letecke_flotily VALUES ( 149, 43, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 149, 43, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 150, 'Avanti Air', 'Německo', 'Evropa', NULL, 1994 );
INSERT INTO tmp_letecke_flotily VALUES ( 150, 15, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 150, 16, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 151, 'Blue Wings', 'Německo', 'Evropa', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 151, 5, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 152, 'Cirrus Airlines', 'Německo', 'Evropa', NULL, 1995 );
INSERT INTO tmp_letecke_flotily VALUES ( 152, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 152, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 152, 43, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 152, 43, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 152, 44, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 152, 45, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 152, 49, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 152, 50, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 152, 51, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 153, 'Condor Airlines', 'Německo', 'Evropa', NULL, 1955 );
INSERT INTO tmp_letecke_flotily VALUES ( 153, 5, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 153, 32, 13 );
INSERT INTO tmp_letecke_flotily VALUES ( 153, 33, 9 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 154, 'Contact Air', 'Německo', 'Evropa', NULL, 1974 );
INSERT INTO tmp_letecke_flotily VALUES ( 154, 15, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 154, 16, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 155, 'European Air Express', 'Německo', 'Evropa', NULL, 1999 );
INSERT INTO tmp_letecke_flotily VALUES ( 155, 15, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 155, 55, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 156, 'Eurowings', 'Německo', 'Evropa', NULL, 1993 );
INSERT INTO tmp_letecke_flotily VALUES ( 156, 18, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 156, 19, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 156, 37, 17 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 157, 'Germania', 'Německo', 'Evropa', NULL, 1978 );
INSERT INTO tmp_letecke_flotily VALUES ( 157, 30, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 158, 'Germanwings', 'Německo', 'Evropa', NULL, 1997 );
INSERT INTO tmp_letecke_flotily VALUES ( 158, 4, 23 );
INSERT INTO tmp_letecke_flotily VALUES ( 158, 5, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 158, 73, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 158, 74, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 159, 'Hamburg International', 'Německo', 'Evropa', NULL, 1999 );
INSERT INTO tmp_letecke_flotily VALUES ( 159, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 159, 30, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 160, 'LTU International', 'Německo', 'Evropa', NULL, 1955 );
INSERT INTO tmp_letecke_flotily VALUES ( 160, 5, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 160, 6, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 160, 7, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 160, 7, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 160, 19, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 161, 'Lufthansa', 'Německo', 'Evropa', 'Star Alliance', 1926 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 1, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 4, 19 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 5, 36 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 6, 20 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 6, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 7, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 8, 28 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 8, 17 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 30, 33 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 30, 30 );
INSERT INTO tmp_letecke_flotily VALUES ( 161, 31, 30 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 162, 'Lufthansa Cargo', 'Německo', 'Evropa', NULL, 1994 );
INSERT INTO tmp_letecke_flotily VALUES ( 162, 72, 19 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 163, 'Lufthansa CityLine', 'Německo', 'Evropa', NULL, 1958 );
INSERT INTO tmp_letecke_flotily VALUES ( 163, 25, 18 );
INSERT INTO tmp_letecke_flotily VALUES ( 163, 36, 16 );
INSERT INTO tmp_letecke_flotily VALUES ( 163, 37, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 163, 37, 20 );
INSERT INTO tmp_letecke_flotily VALUES ( 163, 39, 12 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 164, 'Ostfriesische Lufttransport', 'Německo', 'Evropa', NULL, 1958 );
INSERT INTO tmp_letecke_flotily VALUES ( 164, 53, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 164, 55, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 164, 79, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 164, 8, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 165, 'TUIfly', 'Německo', 'Evropa', NULL, 2007 );
INSERT INTO tmp_letecke_flotily VALUES ( 165, 30, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 165, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 165, 30, 11 );
INSERT INTO tmp_letecke_flotily VALUES ( 165, 30, 40 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 166, 'WDL Aviation', 'Německo', 'Evropa', NULL, NULL );
INSERT INTO tmp_letecke_flotily VALUES ( 166, 17, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 166, 18, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 166, 56, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 167, 'XL Airways Germany', 'Německo', 'Evropa', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 167, 5, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 168, 'Air Norway', 'Norsko', 'Evropa', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 168, 55, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 169, 'Coast Air', 'Norsko', 'Evropa', NULL, 1986 );
INSERT INTO tmp_letecke_flotily VALUES ( 169, 15, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 169, 22, 8 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 170, 'Kato Airline', 'Norsko', 'Evropa', NULL, 1995 );
INSERT INTO tmp_letecke_flotily VALUES ( 170, 46, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 171, 'Norwegian Air Shuttle', 'Norsko', 'Evropa', NULL, 1993 );
INSERT INTO tmp_letecke_flotily VALUES ( 171, 30, 22 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 172, 'SAS Scandinavian Airlines Norge', 'Norsko', 'Evropa', 'Star Alliance', 2007 );
INSERT INTO tmp_letecke_flotily VALUES ( 172, 24, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 172, 30, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 172, 30, 13 );
INSERT INTO tmp_letecke_flotily VALUES ( 172, 30, 16 );
INSERT INTO tmp_letecke_flotily VALUES ( 172, 30, 11 );
INSERT INTO tmp_letecke_flotily VALUES ( 172, 30, 8 );
INSERT INTO tmp_letecke_flotily VALUES ( 172, 58, 6 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 173, 'Vildanden', 'Norsko', 'Evropa', NULL, 2004 );
INSERT INTO tmp_letecke_flotily VALUES ( 173, 8, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 174, 'Wideroe', 'Norsko', 'Evropa', NULL, 1934 );
INSERT INTO tmp_letecke_flotily VALUES ( 174, 43, 16 );
INSERT INTO tmp_letecke_flotily VALUES ( 174, 43, 8 );
INSERT INTO tmp_letecke_flotily VALUES ( 174, 43, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 175, 'Aegean Airlines', 'Řecko', 'Evropa', NULL, 1987 );
INSERT INTO tmp_letecke_flotily VALUES ( 175, 5, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 175, 23, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 175, 30, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 175, 30, 9 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 176, 'Alexandair', 'Řecko', 'Evropa', NULL, 2004 );
INSERT INTO tmp_letecke_flotily VALUES ( 176, 73, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 177, 'Hellas Jet', 'Řecko', 'Evropa', NULL, 2002 );
INSERT INTO tmp_letecke_flotily VALUES ( 177, 5, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 178, 'Hellenic Imperial Airways', 'Řecko', 'Evropa', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 178, 31, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 179, 'Mediterranean Air Freight', 'Řecko', 'Evropa', NULL, 2003 );
INSERT INTO tmp_letecke_flotily VALUES ( 179, 53, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 179, 55, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 180, 'Olympic Airlines', 'Řecko', 'Evropa', NULL, 1957 );
INSERT INTO tmp_letecke_flotily VALUES ( 180, 1, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 180, 8, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 180, 15, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 180, 16, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 180, 30, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 180, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 180, 30, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 180, 43, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 181, 'Sky Express', 'Řecko', 'Evropa', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 181, 31, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 182, 'Sky Wings Airlines', 'Řecko', 'Evropa', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 182, 73, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 182, 74, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 183, 'Aerolineas Argentinas', 'Argentina', 'Jižní Amerika', NULL, 1949 );
INSERT INTO tmp_letecke_flotily VALUES ( 183, 2, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 183, 8, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 183, 30, 14 );
INSERT INTO tmp_letecke_flotily VALUES ( 183, 30, 12 );
INSERT INTO tmp_letecke_flotily VALUES ( 183, 31, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 183, 74, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 184, 'Andes Lineas Aereas', 'Argentina', 'Jižní Amerika', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 184, 73, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 185, 'Austral Lineas Aereas', 'Argentina', 'Jižní Amerika', NULL, 1971 );
INSERT INTO tmp_letecke_flotily VALUES ( 185, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 185, 74, 11 );
INSERT INTO tmp_letecke_flotily VALUES ( 185, 76, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 186, 'LAN Argentina', 'Argentina', 'Jižní Amerika', 'oneworld', 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 186, 5, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 186, 33, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 187, 'Aerosur', 'Bolívie', 'Jižní Amerika', NULL, 1992 );
INSERT INTO tmp_letecke_flotily VALUES ( 187, 29, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 187, 30, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 187, 32, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 188, 'Aerolines del Sur', 'Chile', 'Jižní Amerika', NULL, 2004 );
INSERT INTO tmp_letecke_flotily VALUES ( 188, 30, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 189, 'LAN Airlines', 'Chile', 'Jižní Amerika', 'oneworld', 1929 );
INSERT INTO tmp_letecke_flotily VALUES ( 189, 3, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 189, 4, 13 );
INSERT INTO tmp_letecke_flotily VALUES ( 189, 5, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 189, 8, 4 );
INSERT INTO tmp_letecke_flotily VALUES ( 189, 30, 15 );
INSERT INTO tmp_letecke_flotily VALUES ( 189, 30, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 189, 33, 19 );
INSERT INTO tmp_letecke_flotily VALUES ( 189, 33, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 190, 'LAN Express', 'Chile', 'Jižní Amerika', NULL, 1958 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 191, 'Sky Airline', 'Chile', 'Jižní Amerika', NULL, 2001 );
INSERT INTO tmp_letecke_flotily VALUES ( 191, 30, 7 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 192, 'Aerogal Aerolineas Galapagos', 'Ekvádor', 'Jižní Amerika', NULL, 1986 );
INSERT INTO tmp_letecke_flotily VALUES ( 192, 29, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 192, 30, 8 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 193, 'Icaro Air', 'Ekvádor', 'Jižní Amerika', NULL, 1971 );
INSERT INTO tmp_letecke_flotily VALUES ( 193, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 193, 43, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 193, 57, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 194, 'LAN Ecuador', 'Ekvádor', 'Jižní Amerika', NULL, 2002 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 195, 'TAME', 'Ekvádor', 'Jižní Amerika', NULL, 1962 );
INSERT INTO tmp_letecke_flotily VALUES ( 195, 5, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 195, 29, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 195, 51, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 195, 52, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 195, 57, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 196, 'Aerolineas Sosa', 'Honduras', 'Severní Amerika', NULL, 1984 );
INSERT INTO tmp_letecke_flotily VALUES ( 196, 22, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 196, 47, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 197, 'Atlantic Airlines de Honduras', 'Honduras', 'Severní Amerika', NULL, 2001 );
INSERT INTO tmp_letecke_flotily VALUES ( 197, 20, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 197, 30, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 197, 56, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 198, 'Islena Airlines', 'Honduras', 'Severní Amerika', NULL, 1981 );
INSERT INTO tmp_letecke_flotily VALUES ( 198, 15, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 198, 47, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 199, 'Air Jamaica', 'Jamajka', 'Severní Amerika', NULL, 1968 );
INSERT INTO tmp_letecke_flotily VALUES ( 199, 5, 9 );
INSERT INTO tmp_letecke_flotily VALUES ( 199, 6, 6 );
INSERT INTO tmp_letecke_flotily VALUES ( 199, 8, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 200, 'International AirLink', 'Jamajka', 'Severní Amerika', NULL, NULL );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 201, 'TimAir', 'Jamajka', 'Severní Amerika', NULL, 1983 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 202, 'Aero California', 'Mexiko', 'Severní Amerika', NULL, 1960 );
INSERT INTO tmp_letecke_flotily VALUES ( 202, 68, 13 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 203, 'Aerolitoral', 'Mexiko', 'Severní Amerika', NULL, 1991 );
INSERT INTO tmp_letecke_flotily VALUES ( 203, 50, 26 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 204, 'Aeromar', 'Mexiko', 'Severní Amerika', NULL, 1987 );
INSERT INTO tmp_letecke_flotily VALUES ( 204, 15, 15 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 205, 'Aeroméxico', 'Mexiko', 'Severní Amerika', 'SkyTeam', 1934 );
INSERT INTO tmp_letecke_flotily VALUES ( 205, 30, 30 );
INSERT INTO tmp_letecke_flotily VALUES ( 205, 30, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 205, 32, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 205, 33, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 205, 33, 1 );
INSERT INTO tmp_letecke_flotily VALUES ( 205, 34, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 205, 73, 3 );
INSERT INTO tmp_letecke_flotily VALUES ( 205, 74, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 205, 75, 11 );
INSERT INTO tmp_letecke_flotily VALUES ( 205, 76, 10 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 206, 'Aeromexpress', 'Mexiko', 'Severní Amerika', NULL, 1990 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 207, 'Aerounion', 'Mexiko', 'Severní Amerika', NULL, 1998 );
INSERT INTO tmp_letecke_flotily VALUES ( 207, 1, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 208, 'Aladia', 'Mexiko', 'Severní Amerika', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 208, 32, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 209, 'ALMA de Mexico', 'Mexiko', 'Severní Amerika', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 209, 36, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 209, 37, 9 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 210, 'Aviacsa', 'Mexiko', 'Severní Amerika', NULL, 1990 );
INSERT INTO tmp_letecke_flotily VALUES ( 210, 30, 23 );
INSERT INTO tmp_letecke_flotily VALUES ( 210, 30, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 211, 'Avolar', 'Mexiko', 'Severní Amerika', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 211, 30, 5 );
INSERT INTO tmp_letecke_flotily VALUES ( 211, 30, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 212, 'Click Mexicana', 'Mexiko', 'Severní Amerika', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 212, 60, 15 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 213, 'Estafeta Carga Aerea', 'Mexiko', 'Severní Amerika', NULL, 2000 );
INSERT INTO tmp_letecke_flotily VALUES ( 213, 30, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 213, 30, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 214, 'Interjet', 'Mexiko', 'Severní Amerika', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 214, 5, 9 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 215, 'Líneas Aéreas Azteca', 'Mexiko', 'Severní Amerika', NULL, 2001 );
INSERT INTO tmp_letecke_flotily VALUES ( 215, 30, 3 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 216, 'Magnicharters', 'Mexiko', 'Severní Amerika', NULL, 1994 );
INSERT INTO tmp_letecke_flotily VALUES ( 216, 30, 7 );
INSERT INTO tmp_letecke_flotily VALUES ( 216, 30, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 217, 'MasAir', 'Mexiko', 'Severní Amerika', NULL, 1992 );
INSERT INTO tmp_letecke_flotily VALUES ( 217, 33, 2 );
INSERT INTO tmp_letecke_flotily VALUES ( 217, 67, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 218, 'Mexicana de Aviación', 'Mexiko', 'Severní Amerika', NULL, 1921 );
INSERT INTO tmp_letecke_flotily VALUES ( 218, 3, 10 );
INSERT INTO tmp_letecke_flotily VALUES ( 218, 4, 20 );
INSERT INTO tmp_letecke_flotily VALUES ( 218, 5, 30 );
INSERT INTO tmp_letecke_flotily VALUES ( 218, 33, 2 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 219, 'Nova Air', 'Mexiko', 'Severní Amerika', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 219, 30, 4 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 220, 'Planet Airways', 'Mexiko', 'Severní Amerika', NULL, 2007 );
INSERT INTO tmp_letecke_flotily VALUES ( 220, 29, 1 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 221, 'Viva Aerobus', 'Mexiko', 'Severní Amerika', NULL, 2006 );
INSERT INTO tmp_letecke_flotily VALUES ( 221, 30, 5 );
INSERT INTO letecke_spolecnosti ( id, spolecnost, zeme, svetadil, aliance, zalozeno ) VALUES ( 222, 'Volaris', 'Mexiko', 'Severní Amerika', NULL, 2005 );
INSERT INTO tmp_letecke_flotily VALUES ( 222, 4, 12 );

INSERT INTO letecke_flotily 
            SELECT spolecnost_id, letadlo_id, sum(pocet_letadel)
              FROM tmp_letecke_flotily
             GROUP BY spolecnost_id, letadlo_id;

COMMIT;
