//
// C++ Interface: textformatter
//
// Description: 
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef TEXTFORMATTER_H
#define TEXTFORMATTER_H

#include <string>

/**
format text, possibly preprocessing text before generating output

@author Lorenzo Bettini
*/
class TextFormatter
{
  TextFormatter *decorator;
  
  const std::string _preformat(const std::string &text); 
  
public:
  TextFormatter(TextFormatter *f = 0);

  virtual ~TextFormatter();
  
  void setFormatter(TextFormatter *f);

  void format(const std::string &elem, const std::string &text);
  void format_nl(const std::string &elem, const std::string &text = "\n");
    
protected:
 
  virtual const std::string preformat(const std::string &text); 

};

#endif
