/*
 * This file is part of LibEuFin.
 * Copyright (C) 2025 Taler Systems S.A.

 * LibEuFin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation; either version 3, or
 * (at your option) any later version.

 * LibEuFin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General
 * Public License for more details.

 * You should have received a copy of the GNU Affero General Public
 * License along with LibEuFin; see the file COPYING.  If not, see
 * <http://www.gnu.org/licenses/>
 */

import io.ktor.http.*
import io.ktor.client.request.*
import org.junit.Test
import tech.libeufin.bank.*
import tech.libeufin.common.*
import tech.libeufin.common.test.*

class ObservabilityApiTest {
    // GET /taler-observability/config
    @Test
    fun config() = bankSetup {
        client.get("/taler-observability/config").assertOkJson<TalerObservabilityConfig>()
    }

    // GET /taler-observability/metrics
    @Test
    fun metrics() = bankSetup { db ->
        authRoutine(HttpMethod.Get, "/taler-observability/metrics", requireAdmin = true)
        client.getAdmin("/taler-observability/metrics").assertOk()

          // Check observability token
        val response = client.post("/accounts/admin/token") {
            pwAuth()
            json {
                "scope" to "observability"
                "duration" to obj {
                    "d_us" to "forever"
                }
            }
        }.assertOkJson<TokenSuccessResponse>()
        client.get("/taler-observability/metrics") {
            headers[HttpHeaders.Authorization] = "Bearer ${response.access_token}"
        }.assertOk()
    }
}