%{ /* -*- c -*- */
/*
 * A Simple Lexer for PostScript.
 *
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97, 98 Akim Demaille, Miguel Santana
 *
 */

/*
 * This file is part of a2ps.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * $Id: lexps.l,v 1.35 1998/01/28 17:38:11 demaille Exp $
 */

#include "main.h"
#include "lexps.h"

int yylex PARAMS ((void));
void yyerror PARAMS ((const char *));

/* Initilizes the obstacks */
void pslex_initialize PARAMS ((void));
%}

%option yylineno
%option prefix="ps"
%option outfile="lex.yy.c"

%x FINISH

begin_setup	^%%BeginSetup.*\n
white_line      ^[[:space:]]*\n
%%

{begin_setup}	{
  ECHO;
  pagedevice_dump (yyout, job);
  BEGIN FINISH;
}

{white_line}    ;
.*	        ECHO;

<FINISH>{		/* a regular expression */
  {white_line}  ;
  .*	        ECHO;
}
%%

int
yywrap (void)
{
  return 1;
}

/* Dump the file FILENAME on STREAM, while inserting the special
   pagedevice requests of JOB. */

void
pslex_dump (FILE *stream, const char *filename)
{
  yyin = xrfopen (filename);
  yyout = stream;

  pslex ();
}
