/* quantumeffectivepotential.h -- 
   This file is part of Archimedes release 0.1.0.
   Archimedes is a simulator for Submicron 2D III-V semiconductor
   Devices. It implements the Monte Carlo method
   for the simulation of the semiclassical Boltzmann equation for both
   electrons and holes. It also includes the quantum effects by means 
   of effective potential method. It is now able to simulate applied
   magnetic fields along with self consistent Faraday equation.

   Copyright (C) 2004, 2005, 2006, 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


// ######################################################
// Created on 28 aug.2004, Siracusa, J.M.Sellier
// Last modif. : 09 Sep.2007, Siracusa, J.M.Sellier
// ######################################################

// This subroutine transforms the electrostatic potential
// from classical to a quantum effective one. In this way
// we take into account the quantum effects, at least
// at first order. For more informations see the Archimedes Manual
// or the following paper:
// "Quantum effects in MOSFETs: Use of an effective potential
//  in 3D Monte Carlo simulation of ultra-short channel devices",
// D.K.Ferry, R.Akis, and D.Vasileska, IEDM Tech. Dig., pp.287-290, 2000.

void quantum_effective_potential(void)
{
// Per chiarimenti vedi i miei manoscritti e l'articolo seguente:
// "Modeling of Quantum Effects for Ultrthin Oxide MOS Structures
//  With an Effective Potential", Y.Li, T.Tang, X.Wang in Google.
// Il tutto e' sviluppato in serie di Taylor... Vedi Arnold...

 register int i,j;
 real e1;
 for(i=3+1;i<=nx+2-1;i++)
   for(j=3+1;j<=ny+2-1;j++){
     e1=0.25*HBAR*HBAR/(M*MSTAR[i_dom[i][j]][1]*KB*TL);
     u2d[i][j][0]=0.0;
// E' decisamente piu' veloce della precedente implementazione...
    u2d[i][j][0]=PSI[i][j]+e1*((PSI[i+1][j]-2.*PSI[i][j]+PSI[i-1][j])/(dx*dx)
                     +(PSI[i][j+1]-2.*PSI[i][j]+PSI[i][j-1])/(dy*dy));
   }
}

// ===============================================
