// Copyright (C) 2000-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "server.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

unsigned long CallStat::upincoming = 0;
unsigned long CallStat::upoutgoing = 0;
time_t CallStat::uptime = 0;

CallStat::CallStat() :
Mutex()
{
	if(!uptime)
		time(&uptime);
	capacity = 0;
	total.incoming = total.outgoing = lasttotal.incoming = lasttotal.outgoing = 0;
	active.incoming = active.outgoing = max.incoming = max.outgoing = lastmax.incoming = lastmax.outgoing = 0;
}

void CallStat::update(void)
{
	enterMutex();
	memcpy(&lasttotal, &total, sizeof(total));
	memcpy(&lastmax, &max, sizeof(max));
	memcpy(&max, &active, sizeof(active));
	memset(&total, 0, sizeof(total));
	leaveMutex();
}

void CallStat::incIncoming(void)
{
	enterMutex();
	++upincoming;
	++total.incoming;
	if(++active.incoming > max.incoming)
		++max.incoming;
	leaveMutex();
}

void CallStat::decIncoming(void)
{
	enterMutex();
	--active.incoming;
	leaveMutex();
}

void CallStat::incOutgoing(void)
{
	enterMutex();
	++upoutgoing;
	++total.outgoing;
	if(++active.outgoing > max.outgoing)
		++max.outgoing;
	leaveMutex();
}

void CallStat::decOutgoing(void)
{
	enterMutex();
	--active.outgoing;
	leaveMutex();
}

void CallStat::getStat(unsigned long *list)
{
	enterMutex();
	*(list++) = max.incoming;
	*(list++) = max.outgoing;
	*(list++) = lastmax.incoming;
	*(list++) = lastmax.outgoing;
	*(list++) = total.incoming;
	*(list++) = total.outgoing;
	*(list++) = lasttotal.incoming;
	*(list++) = lasttotal.outgoing;
	leaveMutex();
}

long CallStat::getStat(statitem_t item)
{
	long value = 0;
	time_t now;

	enterMutex();
	switch(item)
	{
	case STAT_ACTIVE_CALLS:
		value = active.outgoing + active.incoming;
		break;
	case STAT_CURRENT_CALLS:
		value = total.outgoing + total.incoming;
		break;
	case STAT_CMAX_INCOMING:
		value = max.incoming;
		break;
	case STAT_CMAX_OUTGOING:
		value = max.outgoing;
		break;
	case STAT_MAX_INCOMING:
		value = lastmax.incoming;
		break;
	case STAT_MAX_OUTGOING:
		value = lastmax.outgoing;
		break;
	case STAT_TOT_INCOMING:
		value = lasttotal.incoming;
		break;
	case STAT_TOT_OUTGOING:
		value = lasttotal.outgoing;
		break;
	case STAT_NOW_INCOMING:
		value = total.incoming;
		break;
	case STAT_NOW_OUTGOING:
		value = total.outgoing;
		break;
	case STAT_SYS_INCOMING:
		value = upincoming;
		break;
	case STAT_SYS_OUTGOING:
		value = upoutgoing;
		break;
	case STAT_SYS_UPTIME:
		time(&now);
		value = now - uptime;
		break;
	case STAT_SYS_ACTIVITY:
		value = upincoming + upoutgoing;
		break;
	}
	leaveMutex();
	return value;
}

#ifdef	CCXX_NAMESPACES
};
#endif
