/* translation of file(s)
	"petrinet-patterns-basic.k"
	"petrinet-patterns-structured.k"
	"petrinet-patterns-scopes.k"
	"petrinet-patterns-handlers.k"
	"petrinet-patterns-links.k"
	"petrinet-patterns-shortcuts.k"
	"ast-grammar.k"
	"ast-config.k"
	"ast-to-petrinet.k"
	"ast-to-xml.k"
	"ast-to-cfg.k"
	"ast-postprocess.k"
	"ast-rewrite.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.10 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_UNPARSE

#include <stdio.h>
#include <string>
#include <stdlib.h>
#include "ast-system-k.h"
#include "ast-system-unpk.h"


namespace kc {
base_uview_class base_uview;
petrinetsmall_class petrinetsmall;
petrinetnew_class petrinetnew;
xml_class xml;
cfg_class cfg;
postprocessing_class postprocessing;
evaluation_class evaluation;

impl_uviews uviews[] = {
    {"base_uview",&base_uview},
    {"petrinetsmall",&petrinetsmall},
    {"petrinetnew",&petrinetnew},
    {"xml",&xml},
    {"cfg",&cfg},
    {"postprocessing",&postprocessing},
    {"evaluation",&evaluation},
    {0,0}
};

} // namespace kc
namespace kc { }
using namespace kc;
/* included stuff */
#line 92 "ast-config.k"
#include <iostream>
#include <cmath>
#include <cassert>
#include <map>
#include <set>
#include <climits>
#include <string>

#include "petrinet.h"
#include "petrinet-patterns-basic.h"
#include "petrinet-patterns-structured.h"
#include "petrinet-patterns-scopes.h"
#include "petrinet-patterns-handlers.h"
#include "petrinet-patterns-links.h"
#include "options.h"
#include "cfg.h"
#include "helpers.h"
#include "ast-details.h"
#include "ast-tools.h"
#include "globals.h"

using std::map;
using std::string;
using std::set;
using std::endl;
using std::cerr;

extern PetriNet PN;				// introduced in main.c
extern CFGBlock * CFG;				// introduced in cfg.cc

#line  84 "ast-system-unpk.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void
impl_abstract_phylum::unparse(printer_function opf, uview uv)
{
    printer_functor_function_wrapper pf(opf);
    do_unparse(pf, uv);
}

// Everything given as a pointer is expected to have an unparse-method (we
// believe it's a phylum), unless there's a specialisation for it

void
unparse(abstract_phylum kc_p, printer_functor kc_printer, uview kc_current_view)
{
    kc_p->unparse(kc_printer, kc_current_view);
}

void
unparse(void *kc_p, printer_functor kc_printer, uview kc_current_view)
{
    // MPi: 20020628 there shouldn't be any left
    assertionFailed("Unparse called for untyped pointer");
    // MPi: cast should be unnecessary, but there are still void*
    reinterpret_cast<impl_abstract_phylum*>(kc_p)->unparse(kc_printer, kc_current_view);
}

void
unparse(int kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_char_t kc_string[200];
    kc_print_integer(kc_string, kc_v);
    kc_printer(kc_string, kc_current_view);
}

void
unparse(double kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_char_t kc_string[200];
    kc_print_real(kc_string, kc_v);
    kc_printer(kc_string, kc_current_view);
}

void
unparse(kc_char_t *kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_printer(kc_v, kc_current_view);
}

void
unparse(kc_string_t kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_printer(kc_v.c_str(), kc_current_view);
}

#line  147 "ast-system-unpk.cc"
void
impl_abstract_phylum::default_unparse(printer_functor kc_printer, uview kc_current_view)
{
    register int no_sons = operator_info[prod_sel()].no_sons;
    for (int i=0; i < no_sons; i++)
    subphylum(i)->unparse(kc_printer, kc_current_view);
}

void
impl_casestring__Str::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(name, kc_printer, kc_current_view);
}

void
impl_nocasestring_NoCaseStr::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(name, kc_printer, kc_current_view);
}

void
impl_integer__Int::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(value, kc_printer, kc_current_view);
}

void
impl_real__Real::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(value, kc_printer, kc_current_view);
}

void
impl_voidptr__VoidPtr::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(pointer, kc_printer, kc_current_view);
}


#line  187 "ast-system-unpk.cc"
void
impl_tProcess_Process::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 55 "ast-postprocess.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 55 "ast-postprocess.k"
		const tPartner_list b = this->tPartner_list_1;
#line 55 "ast-postprocess.k"
		const tVariable_list c = this->tVariable_list_1;
#line 55 "ast-postprocess.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 55 "ast-postprocess.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 55 "ast-postprocess.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 55 "ast-postprocess.k"
		const activity i = this->activity_1;
#line 55 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 57 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = myid;
		myself->parentActivityId = myid;
		globals::PPcurrentScope = myid;


		myself->checkAttributes();
		myself->hasEH = (string(g->op_name()) == "EventHandlers");



		assert(globals::ASTEmap[e->id] != NULL);

		assert(globals::ASTEmap[g->id] != NULL);
		assert(globals::ASTEmap[i->id] != NULL);
		globals::ASTEmap[e->id]->parentActivityId = myid;

		globals::ASTEmap[g->id]->parentActivityId = myid;
		globals::ASTEmap[i->id]->parentActivityId = myid;

		myself->enclosedFH = e->id;

#line  239 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 87 "ast-postprocess.k"


		assert(globals::ASTEmap[i->id] != NULL);
		myself->enclosedSourceLinks = globals::ASTEmap[i->id]->enclosedSourceLinks;
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks );

		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[g->id]->enclosedSourceLinks );

		set< unsigned int > innerIds = globals::ASTEmap[ i->id ]->enclosedActivities;
		innerIds.insert( i->id );
		set< unsigned int > faultIds = globals::ASTEmap[ e->id ]->enclosedActivities;
		faultIds.insert( e->id );



		enterConflictingActivities( innerIds, faultIds );






		if (globals::ASTE_startActivities.empty())
		SAerror(15, "", myself->attributes["referenceLine"]);




		bool linksOK = true;
		for(map<string, unsigned int>::iterator it = globals::ASTE_linkIdMap.begin(); it != globals::ASTE_linkIdMap.end(); it++)
		{
		    if ( it-> first != "" )
		    {
			assert(globals::ASTEmap[it->second] != NULL);

			if ((globals::ASTEmap[it->second]->targetActivity == 0) || (globals::ASTEmap[it->second]->sourceActivity == 0))
			{
			    SAerror(66, it->first, globals::ASTEmap[it->second]->attributes["referenceLine"]);
			    linksOK = false;
			}


			if (linksOK)
			{
			    assert(globals::ASTEmap[globals::ASTEmap[it->second]->sourceActivity] != NULL);
			    assert(globals::ASTEmap[globals::ASTEmap[it->second]->targetActivity] != NULL);
			    set<unsigned int> otherSources = globals::ASTEmap[globals::ASTEmap[it->second]->sourceActivity]->sourceLinks;
			    set<unsigned int> otherTargets = globals::ASTEmap[globals::ASTEmap[it->second]->targetActivity]->targetLinks;
			    set<unsigned int> jointLinks = setIntersection(otherSources, otherTargets);
			    jointLinks.erase(it->second);

			    if (jointLinks.size() > 0)
			    SAerror(67, "`" + it->first + "' and <link> `" + globals::ASTEmap[*(jointLinks.begin())]->attributes["name"] + "'", globals::ASTEmap[it->second]->attributes["referenceLine"]);
			}
		    }
		}


		set<string> reallySharedCorrelationSets;
		if (globals::ASTE_startActivities.size() > 1)
		{
		    for (set<unsigned int>::iterator it = globals::ASTE_startActivities.begin(); it != globals::ASTE_startActivities.end(); it++)
		    {
			if (it == globals::ASTE_startActivities.begin())
			reallySharedCorrelationSets = globals::ASTEmap[*it]->sharedCorrelationSets;
			else
			reallySharedCorrelationSets = setIntersection(reallySharedCorrelationSets, globals::ASTEmap[*it]->sharedCorrelationSets);

			if (reallySharedCorrelationSets.empty())
			{
			    SAerror(57, "", globals::ASTEmap[*it]->attributes["referenceLine"]);
			    break;
			}
		    }
		}



		if (linksOK)
		assert(myself->enclosedSourceLinks.size() == globals::ASTE_linkNames.size());



		globals::ASTE_correlationSetNames.clear(); 
		globals::ASTE_partnerLinkNames.clear();    
		globals::ASTE_startActivities.clear();	
		globals::ASTE_linkIdMap.clear();		

#line  336 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 57 "ast-to-cfg.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 57 "ast-to-cfg.k"
		const tPartner_list b = this->tPartner_list_1;
#line 57 "ast-to-cfg.k"
		const tVariable_list c = this->tVariable_list_1;
#line 57 "ast-to-cfg.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 57 "ast-to-cfg.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 57 "ast-to-cfg.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 57 "ast-to-cfg.k"
		const activity i = this->activity_1;
#line 57 "ast-to-cfg.k"
		const integer j = this->integer_1;
#line 58 "ast-to-cfg.k"


		globals::cfgMap = map<std::string, CFGBlock *>();
		sources = map<std::string, CFGBlock *>();
		targets = map<std::string, CFGBlock *>();


		trace(TRACE_DEBUG, "[CFG] Process\n");
		CFGBlock* firstBlock = new CFGBlock(CFGProcess, this->id, "Process_begin"); 
		CFGBlock* lastBlock  = new CFGBlock(CFGProcess, this->id, "Process_end");


		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		CFG = firstBlock;
		globals::cfgMap[toString(this->id)] = CFG; 

#line  378 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 77 "ast-to-cfg.k"


		CFGBlock *fhFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock *fhLast  = globals::cfgMap.find(toString(e->id))->second->lastBlock;


		connectBlocks(firstBlock, fhFirst);
		connectBlocks(fhLast, lastBlock);

#line  390 "ast-system-unpk.cc"
		kc::unparse(g, kc_printer, kc_current_view);
#line 97 "ast-to-cfg.k"

		CFGBlock * ehFirst = globals::cfgMap.find(toString(g->id))->second->firstBlock;
		CFGBlock * ehLast  = globals::cfgMap.find(toString(g->id))->second->lastBlock;

		connectBlocks(firstBlock, ehFirst);
		connectBlocks(ehLast, lastBlock);


#line  401 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 106 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(i->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(i->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  411 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 57 "ast-to-xml.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 57 "ast-to-xml.k"
		const tPartner_list b = this->tPartner_list_1;
#line 57 "ast-to-xml.k"
		const tVariable_list c = this->tVariable_list_1;
#line 57 "ast-to-xml.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 57 "ast-to-xml.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 57 "ast-to-xml.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 57 "ast-to-xml.k"
		const activity i = this->activity_1;
#line 57 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 58 "ast-to-xml.k"
		inup(); 
#line  436 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<process id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 58 "ast-to-xml.k"
		listAttributes( _id ); 
#line  442 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 60 "ast-to-xml.k"
		if (a->length() == 0) 
#line  446 "ast-system-unpk.cc"
		{
		}
#line 62 "ast-to-xml.k"
		else 
#line  451 "ast-system-unpk.cc"
		{
#line 63 "ast-to-xml.k"
		    inup(); 
#line  455 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<partnerLinks>\n"), kc_current_view); }
		    kc::unparse(a, kc_printer, kc_current_view);
#line 63 "ast-to-xml.k"
		    indown(); 
#line  460 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</partnerLinks>\n"), kc_current_view); }
		}
#line 65 "ast-to-xml.k"
		if (b->length() == 0) 
#line  465 "ast-system-unpk.cc"
		{
		}
#line 67 "ast-to-xml.k"
		else 
#line  470 "ast-system-unpk.cc"
		{
#line 68 "ast-to-xml.k"
		    inup(); 
#line  474 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<partners>\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 68 "ast-to-xml.k"
		    indown(); 
#line  479 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</partners>\n"), kc_current_view); }
		}
#line 70 "ast-to-xml.k"
		if (c->length() == 0) 
#line  484 "ast-system-unpk.cc"
		{
		}
#line 72 "ast-to-xml.k"
		else 
#line  489 "ast-system-unpk.cc"
		{
#line 73 "ast-to-xml.k"
		    inup(); 
#line  493 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<variables>\n"), kc_current_view); }
		    kc::unparse(c, kc_printer, kc_current_view);
#line 73 "ast-to-xml.k"
		    indown(); 
#line  498 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</variables>\n"), kc_current_view); }
		}
#line 75 "ast-to-xml.k"
		if (d->length() == 0) 
#line  503 "ast-system-unpk.cc"
		{
		}
#line 77 "ast-to-xml.k"
		else 
#line  508 "ast-system-unpk.cc"
		{
#line 78 "ast-to-xml.k"
		    inup(); 
#line  512 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<correlationSets>\n"), kc_current_view); }
		    kc::unparse(d, kc_printer, kc_current_view);
#line 78 "ast-to-xml.k"
		    indown(); 
#line  517 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</correlationSets>\n"), kc_current_view); }
		}
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
#line 80 "ast-to-xml.k"
		indown(); 
#line  525 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</process>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 160 "ast-to-petrinet.k"
		PProcess(this, kc_current_view_base);


		globals::ASTE_scopeNames.clear(); 
#line  538 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 160 "ast-to-petrinet.k"
		PProcess(this, kc_current_view_base);


		globals::ASTE_scopeNames.clear(); 
#line  550 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  555 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  568 "ast-system-unpk.cc"
void
impl_activity_activityScope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  574 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  587 "ast-system-unpk.cc"
void
impl_activity_activityFlow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  593 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  606 "ast-system-unpk.cc"
void
impl_activity_activityPick::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  612 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  625 "ast-system-unpk.cc"
void
impl_activity_activityForEach::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  631 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  644 "ast-system-unpk.cc"
void
impl_activity_activityRepeatUntil::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  650 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  663 "ast-system-unpk.cc"
void
impl_activity_activityWhile::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  669 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  682 "ast-system-unpk.cc"
void
impl_activity_activityIf::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  688 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  701 "ast-system-unpk.cc"
void
impl_activity_activitySequence::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  707 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  720 "ast-system-unpk.cc"
void
impl_activity_activityCompensate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  726 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  739 "ast-system-unpk.cc"
void
impl_activity_activityRethrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  745 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  758 "ast-system-unpk.cc"
void
impl_activity_activityThrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  764 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  777 "ast-system-unpk.cc"
void
impl_activity_activityExit::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  783 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  796 "ast-system-unpk.cc"
void
impl_activity_activityWait::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  802 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  815 "ast-system-unpk.cc"
void
impl_activity_activityEmpty::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  821 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  834 "ast-system-unpk.cc"
void
impl_activity_activityValidate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  840 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  853 "ast-system-unpk.cc"
void
impl_activity_activityAssign::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  859 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  872 "ast-system-unpk.cc"
void
impl_activity_activityInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  878 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  891 "ast-system-unpk.cc"
void
impl_activity_activityReply::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  897 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  910 "ast-system-unpk.cc"
void
impl_activity_activityReceive::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  916 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_activity_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  936 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (activity_list iterator_ = this; iterator_->activity_list_1 != 0; iterator_ = iterator_->activity_list_1)
		    iterator_->activity_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_activity_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  954 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tPartnerLink_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  973 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tPartnerLink_list iterator_ = this; iterator_->tPartnerLink_list_1 != 0; iterator_ = iterator_->tPartnerLink_list_1)
		    iterator_->tPartnerLink_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tPartnerLink_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  991 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1003 "ast-system-unpk.cc"
void
impl_tPartnerLink_PartnerLink::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 183 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 185 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->definePartnerLink();

#line  1025 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 88 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 89 "ast-to-xml.k"
		in(); 
#line  1036 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<partnerLink id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 89 "ast-to-xml.k"
		listAttributes( _id ); 
#line  1042 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  1048 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tPartner_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1068 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tPartner_list iterator_ = this; iterator_->tPartner_list_1 != 0; iterator_ = iterator_->tPartner_list_1)
		    iterator_->tPartner_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tPartner_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1086 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1098 "ast-system-unpk.cc"
void
impl_tPartner_Partner::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 204 "ast-postprocess.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 204 "ast-postprocess.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 97 "ast-to-xml.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 97 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 98 "ast-to-xml.k"
		inup(); 
#line  1123 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<partner id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 98 "ast-to-xml.k"
		indown(); 
#line  1130 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</partner>\n"), kc_current_view); }
	    }
	    break;
	}

#line  1136 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1149 "ast-system-unpk.cc"
void
impl_tFaultHandlers_FaultHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 213 "ast-postprocess.k"
		const tCatch_list a = this->tCatch_list_1;
#line 213 "ast-postprocess.k"
		const tCatchAll b = this->tCatchAll_1;
#line 213 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 215 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->hasCatchAll = (b->op_name() == "CatchAll");




		{
#line 227 "ast-postprocess.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1180 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 227 "ast-postprocess.k"
			    {
#line 228 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 228 "ast-postprocess.k"
#line 227 "ast-postprocess.k"
				    const tCatch branch = kc_selvar_0_1;
#line 227 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 228 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid; 
				    globals::ASTEmap[branch->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = FHCF;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  1203 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1208 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 227 "ast-postprocess.k"

#line  1213 "ast-system-unpk.cc"
		    }
		}
#line 235 "ast-postprocess.k"



		{
#line 238 "ast-postprocess.k"
		    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(b);
#line 241 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 241 "ast-postprocess.k"
#line 240 "ast-postprocess.k"
			const activity c = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 240 "ast-postprocess.k"
			const integer _id = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->integer_1;
#line 241 "ast-postprocess.k"

			assert(globals::ASTEmap[c->id] != NULL);

			globals::ASTEmap[b->id]->parentActivityId = myid;
			globals::ASTEmap[c->id]->controlFlow = FHCF;
			globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;

#line  1238 "ast-system-unpk.cc"
		    } else
		    {
#line 249 "ast-postprocess.k"
#line 249 "ast-postprocess.k"


			if (a->length() == 0)
			SAerror(80, "", toInt(globals::ASTEmap[myself->parentScopeId]->attributes["referenceLine"]));

#line  1248 "ast-system-unpk.cc"
		    }
		}
#line 255 "ast-postprocess.k"

#line  1253 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 257 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		{
#line 262 "ast-postprocess.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1266 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 262 "ast-postprocess.k"
			    {
#line 263 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 263 "ast-postprocess.k"
#line 262 "ast-postprocess.k"
				    const tCatch branch = kc_selvar_0_1;
#line 262 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 262 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->integer_1;
#line 263 "ast-postprocess.k"

				    {
#line 264 "ast-postprocess.k"
					tCatch_list kc_fe_selvar_1 =  a;

#line  1289 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
					    ) {
					    tCatch kc_selvar_1_1 = kc_fe_selvar_1->tCatch_1;
					    {
#line 264 "ast-postprocess.k"
						{
#line 265 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_Catch)) {
#line 265 "ast-postprocess.k"
#line 264 "ast-postprocess.k"
							const tCatch otherbranch = kc_selvar_1_1;
#line 264 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->activity_1;
#line 264 "ast-postprocess.k"
							const integer _id3 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->integer_1;
#line 265 "ast-postprocess.k"

							assert(_id2 != NULL);
							assert(_id3 != NULL);
							if ( _id2->value < _id3->value )
							{
							    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );
							}

#line  1315 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  1320 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 264 "ast-postprocess.k"

#line  1325 "ast-system-unpk.cc"
					}
				    }
#line 273 "ast-postprocess.k"

#line  1330 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1335 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 262 "ast-postprocess.k"

#line  1340 "ast-system-unpk.cc"
		    }
		}
#line 274 "ast-postprocess.k"

		{
#line 275 "ast-postprocess.k"
		    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(b);
#line 278 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 278 "ast-postprocess.k"
#line 277 "ast-postprocess.k"
			const activity c = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 277 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->integer_1;
#line 278 "ast-postprocess.k"

			{
#line 279 "ast-postprocess.k"
			    tCatch_list kc_fe_selvar_1 =  a;

#line  1361 "ast-system-unpk.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
				) {
				tCatch kc_selvar_1_1 = kc_fe_selvar_1->tCatch_1;
				{
#line 279 "ast-postprocess.k"
				    {
#line 280 "ast-postprocess.k"
					if ((kc_selvar_1_1->prod_sel() == sel_Catch)) {
#line 280 "ast-postprocess.k"
#line 279 "ast-postprocess.k"
					    const tCatch otherbranch = kc_selvar_1_1;
#line 279 "ast-postprocess.k"
					    const activity secondActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->activity_1;
#line 279 "ast-postprocess.k"
					    const integer _id3 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->integer_1;
#line 280 "ast-postprocess.k"

					    assert(_id2 != NULL);
					    assert(_id3 != NULL);
					    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );

#line  1384 "ast-system-unpk.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1389 "ast-system-unpk.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 279 "ast-postprocess.k"

#line  1394 "ast-system-unpk.cc"
			    }
			}
#line 285 "ast-postprocess.k"

#line  1399 "ast-system-unpk.cc"
		    } else
		    {
#line 287 "ast-postprocess.k"
#line 287 "ast-postprocess.k"


#line  1406 "ast-system-unpk.cc"
		    }
		}
#line 290 "ast-postprocess.k"


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  1415 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    if ((this->tCatchAll_1->prod_sel() == sel_CatchAll)) {
#line 130 "ast-to-cfg.k"
		const tFaultHandlers This = this/**/;
#line 130 "ast-to-cfg.k"
		const tCatch_list a = this->tCatch_list_1;
#line 130 "ast-to-cfg.k"
		const tCatchAll catchAll = this->tCatchAll_1;
#line 130 "ast-to-cfg.k"
		const activity b = phylum_cast<const impl_tCatchAll_CatchAll*>(this->tCatchAll_1)->activity_1;
#line 130 "ast-to-cfg.k"
		const integer c = phylum_cast<const impl_tCatchAll_CatchAll*>(this->tCatchAll_1)->integer_1;
#line 130 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 131 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] FaultHandler (user defined)\n");
		CFGBlock* firstBlock = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_begin"); 
		CFGBlock* lastBlock  = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  1444 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 141 "ast-to-cfg.k"

		{
#line 142 "ast-to-cfg.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1452 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 142 "ast-to-cfg.k"
			    {
#line 143 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 143 "ast-to-cfg.k"
#line 142 "ast-to-cfg.k"
				    const activity catchBlock = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 143 "ast-to-cfg.k"

				    CFGBlock * catchIt = new CFGBlock(CFGCatch, kc_selvar_0_1->id, "Catch");
				    CFGBlock * innerFirst = globals::cfgMap.find(toString(catchBlock->id))->second->firstBlock;
				    CFGBlock * innerLast  = globals::cfgMap.find(toString(catchBlock->id))->second->lastBlock;

				    connectBlocks(firstBlock, catchIt);
				    connectBlocks(catchIt, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  1475 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1480 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 142 "ast-to-cfg.k"

#line  1485 "ast-system-unpk.cc"
		    }
		}
#line 152 "ast-to-cfg.k"

#line  1490 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 154 "ast-to-cfg.k"

		CFGBlock * catchAllBlock = new CFGBlock(CFGCatchAll, catchAll->id, "CatchAll");
		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(firstBlock, catchAllBlock);
		connectBlocks(catchAllBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  1502 "ast-system-unpk.cc"
	    } else
		if ((this->tCatchAll_1->prod_sel() == sel_NoCatchAll)) {
#line 165 "ast-to-cfg.k"
		const tFaultHandlers This = this/**/;
#line 165 "ast-to-cfg.k"
		const tCatch_list a = this->tCatch_list_1;
#line 165 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 166 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] FaultHandler (user defined, no catchAll)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  1521 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 176 "ast-to-cfg.k"

		{
#line 177 "ast-to-cfg.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1529 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 177 "ast-to-cfg.k"
			    {
#line 178 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 178 "ast-to-cfg.k"
#line 177 "ast-to-cfg.k"
				    const activity catchBlock = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 178 "ast-to-cfg.k"

				    CFGBlock * catchIt = new CFGBlock(CFGCatch, kc_selvar_0_1->id, "Catch");
				    CFGBlock * innerFirst = globals::cfgMap.find(toString(catchBlock->id))->second->firstBlock;
				    CFGBlock * innerLast  = globals::cfgMap.find(toString(catchBlock->id))->second->lastBlock;

				    connectBlocks(firstBlock, catchIt);
				    connectBlocks(catchIt, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  1552 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1557 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 177 "ast-to-cfg.k"

#line  1562 "ast-system-unpk.cc"
		    }
		}
#line 187 "ast-to-cfg.k"

#line  1567 "ast-system-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 106 "ast-to-xml.k"
		const tCatch_list a = this->tCatch_list_1;
#line 106 "ast-to-xml.k"
		const tCatchAll b = this->tCatchAll_1;
#line 106 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 107 "ast-to-xml.k"
		inup(); 
#line  1583 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<faultHandlers id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 107 "ast-to-xml.k"
		indown(); 
#line  1591 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</faultHandlers>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 181 "ast-to-petrinet.k"
		PFaultHandlers(this, kc_current_view_base); 
#line  1601 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  1606 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1620 "ast-system-unpk.cc"
void
impl_tFaultHandlers_volatile_standardFaultHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1626 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCatch_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1646 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCatch_list iterator_ = this; iterator_->tCatch_list_1 != 0; iterator_ = iterator_->tCatch_list_1)
		    iterator_->tCatch_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCatch_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1664 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1676 "ast-system-unpk.cc"
void
impl_tCatch_Catch::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 298 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 298 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 300 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();


		if (myself->attributes["faultVariable"] != "")
		globals::ASTE_variableNames.insert(toString(globals::PPcurrentScope) + "." + myself->attributes["faultVariable"]);

#line  1701 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 313 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		globals::ASTEmap[a->id]->parentActivityId = myid; 


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00071( myid );


		if (myself->attributes["faultVariable"] != "")
		globals::ASTE_variableNames.erase(toString(globals::PPcurrentScope) + "." + myself->attributes["faultVariable"]);

#line  1724 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 110 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 110 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 111 "ast-to-xml.k"
		inup(); 
#line  1737 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<catch id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 111 "ast-to-xml.k"
		listAttributes( _id ); 
#line  1743 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 111 "ast-to-xml.k"
		indown(); 
#line  1748 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</catch>\n"), kc_current_view); }
	    }
	    break;
	}

#line  1754 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1767 "ast-system-unpk.cc"
void
impl_tCatchAll_NoCatchAll::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1773 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1785 "ast-system-unpk.cc"
void
impl_tCatchAll_CatchAll::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 336 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 336 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 338 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;

#line  1805 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 346 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		globals::ASTEmap[a->id]->parentActivityId = myid; 


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00071( myid );

#line  1824 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 114 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 114 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 115 "ast-to-xml.k"
		inup(); 
#line  1837 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<catchAll id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 115 "ast-to-xml.k"
		listAttributes( _id ); 
#line  1843 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 115 "ast-to-xml.k"
		indown(); 
#line  1848 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</catchAll>\n"), kc_current_view); }
	    }
	    break;
	}

#line  1854 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1867 "ast-system-unpk.cc"
void
impl_tTerminationHandler_TerminationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 600 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 600 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 602 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;



		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;
		globals::ASTEmap[a->id]->controlFlow = THCF;
		globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;

#line  1895 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 618 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00071( myid );


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  1913 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 285 "ast-to-cfg.k"
		const activity a = this->activity_1;
#line 285 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 286 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] TerminationHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGTerminationHandler, this->id, "TerminationHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGTerminationHandler, this->id, "TerminationHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  1934 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 296 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(a->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(a->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  1944 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 165 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 165 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 166 "ast-to-xml.k"
		inup(); 
#line  1957 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<terminationHandler id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 166 "ast-to-xml.k"
		indown(); 
#line  1964 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</terminationHandler>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 185 "ast-to-petrinet.k"
		PTerminationHandler(this, kc_current_view_base); 
#line  1974 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  1979 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1992 "ast-system-unpk.cc"
void
impl_tTerminationHandler_volatile_standardTerminationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1998 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2011 "ast-system-unpk.cc"
void
impl_tCompensationHandler_CompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 542 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 542 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 544 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;



		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;
		globals::ASTEmap[a->id]->controlFlow = CHCF;
		globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;

#line  2039 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 560 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00070( myid );


		vector<unsigned int> ancestors = myself->ancestorActivities();
		if (myself->isUserDefined && ancestors.size() > 1)
		{
		    string ancestor = globals::ASTEmap[ancestors[1]]->activityTypeName();
		    if (ancestor == "catch" ||
			ancestor == "catchAll" ||
			ancestor == "terminationHandler" ||
			ancestor == "compensationHandler")
		    {
			SAerror(79, ancestor);
		    }
		}


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  2074 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 258 "ast-to-cfg.k"
		const activity a = this->activity_1;
#line 258 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 259 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] CompensationHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGCompensationHandler, this->id, "CompensationHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGCompensationHandler, this->id, "CompensationHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  2095 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 269 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(a->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(a->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  2105 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 156 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 156 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 157 "ast-to-xml.k"
		inup(); 
#line  2118 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensationHandler id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 157 "ast-to-xml.k"
		indown(); 
#line  2125 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensationHandler>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 189 "ast-to-petrinet.k"
		PCompensationHandler(this, kc_current_view_base); 
#line  2135 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2140 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2153 "ast-system-unpk.cc"
void
impl_tCompensationHandler_volatile_standardCompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2159 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2172 "ast-system-unpk.cc"
void
impl_tEventHandlers_EventHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 385 "ast-postprocess.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 385 "ast-postprocess.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 385 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 387 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;



		if (a->length() == 0 && b->length() == 0)
		SAerror(83, "", toInt(globals::ASTEmap[myself->parentScopeId]->attributes["referenceLine"]));


		{
#line 401 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  a;

#line  2205 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 401 "ast-postprocess.k"
			    {
#line 402 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 402 "ast-postprocess.k"
#line 401 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 401 "ast-postprocess.k"
				    const tCorrelation_list _cor = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 401 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 401 "ast-postprocess.k"
				    const activity _act = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 401 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 402 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;
				    globals::ASTEmap[_id2->value]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id2->value]->max_occurrences = myself->max_occurrences;


#line  2235 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2240 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 401 "ast-postprocess.k"

#line  2245 "ast-system-unpk.cc"
		    }
		}
#line 410 "ast-postprocess.k"
		{
#line 410 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  b;

#line  2253 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 410 "ast-postprocess.k"
			    {
#line 411 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 411 "ast-postprocess.k"
#line 410 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 410 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 410 "ast-postprocess.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 411 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id3->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id3->value]->max_occurrences = myself->max_occurrences;

#line  2278 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2283 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 410 "ast-postprocess.k"

#line  2288 "ast-system-unpk.cc"
		    }
		}
#line 418 "ast-postprocess.k"

#line  2293 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 420 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  2304 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 195 "ast-to-cfg.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 195 "ast-to-cfg.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 195 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 196 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] EventHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGPick, this->id, "EventHandler_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGPick, this->id, "EventHandler_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;









		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  2336 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 216 "ast-to-cfg.k"

		int i = 1;
		{
#line 218 "ast-to-cfg.k"
		    tOnMessage_list kc_fe_selvar_1 =  a;

#line  2346 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 218 "ast-to-cfg.k"
			    {
#line 219 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 219 "ast-to-cfg.k"
#line 218 "ast-to-cfg.k"
				    const tOnMessage message = kc_selvar_0_1;
#line 218 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 219 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onMessageBlock = new CFGBlock(CFGOnMessage, message->id, "OnMessage_" + toString(i++)); 
				    onMessageBlock->channel_name = globals::ASTEmap[message->id]->channelName;

				    connectBlocks(firstBlock, onMessageBlock);
				    connectBlocks(onMessageBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  2372 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2377 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 218 "ast-to-cfg.k"

#line  2382 "ast-system-unpk.cc"
		    }
		}
#line 229 "ast-to-cfg.k"
		i = 1; 
		{
#line 230 "ast-to-cfg.k"
		    tOnAlarm_list kc_fe_selvar_1 =  b;

#line  2391 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 230 "ast-to-cfg.k"
			    {
#line 231 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 231 "ast-to-cfg.k"
#line 230 "ast-to-cfg.k"
				    const tOnAlarm alarm = kc_selvar_0_1;
#line 230 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 231 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onAlarmBlock = new CFGBlock(CFGOnAlarm, alarm->id, "OnAlarm_" + toString(i++)); 

				    connectBlocks(firstBlock, onAlarmBlock);
				    connectBlocks(onAlarmBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  2416 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2421 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 230 "ast-to-cfg.k"

#line  2426 "ast-system-unpk.cc"
		    }
		}
#line 239 "ast-to-cfg.k"


#line  2432 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 127 "ast-to-xml.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 127 "ast-to-xml.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 127 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 128 "ast-to-xml.k"
		inup(); 
#line  2447 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<eventHandlers id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 128 "ast-to-xml.k"
		indown(); 
#line  2455 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</eventHandlers>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 193 "ast-to-petrinet.k"
		PEventHandlers(this, kc_current_view_base); 
#line  2465 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 193 "ast-to-petrinet.k"
		PEventHandlers(this, kc_current_view_base); 
#line  2474 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2479 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2492 "ast-system-unpk.cc"
void
impl_tEventHandlers_emptyEventHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 370 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 372 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  2513 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 244 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 245 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] EventHandler (implicit)\n");
		CFGBlock * block = new CFGBlock(CFGEventHandler, this->id, "implicitEventHandler"); 
		globals::cfgMap[toString(this->id)] = block;
		trace(TRACE_DEBUG, "[CFG] ~EventHandler (implicit)\n");

#line  2529 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 123 "ast-to-xml.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}

#line  2542 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tOnMessage_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  2562 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tOnMessage_list iterator_ = this; iterator_->tOnMessage_list_1 != 0; iterator_ = iterator_->tOnMessage_list_1)
		    iterator_->tOnMessage_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tOnMessage_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2580 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  2592 "ast-system-unpk.cc"
void
impl_tOnMessage_OnMessage::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 430 "ast-postprocess.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 430 "ast-postprocess.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 430 "ast-postprocess.k"
		const activity c = this->activity_1;
#line 430 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 432 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		myself->checkAttributes();

		myself->checkPartnerLink();


		if (b->length() != 0 && myself->attributes["variable"] != "")
		SAerror(63, "", myself->attributes["referenceLine"]);

		myself->channelName = myself->createChannel();
		myself->variableName = myself->checkVariable("variable");

		assert(globals::ASTEmap[c->id] != NULL);
		globals::ASTEmap[c->id]->parentActivityId = myid;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if(globals::ASTEmap[myself->parentActivityId]->activityTypeName() == "eventHandlers")
		{
		    if(max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		    {
			myself->max_occurrences = max_loops * myself-> max_occurrences;
		    } 
		    else
		    {
			myself->max_occurrences = UINT_MAX;
		    }
		}

		globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;





		{
#line 474 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  a;

#line  2655 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 474 "ast-postprocess.k"
			    {
#line 475 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 475 "ast-postprocess.k"
#line 474 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 474 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 475 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  2676 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2681 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 474 "ast-postprocess.k"

#line  2686 "ast-system-unpk.cc"
		    }
		}
#line 480 "ast-postprocess.k"

#line  2691 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 482 "ast-postprocess.k"


		assert(globals::ASTEmap[c->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[c->id]->enclosedSourceLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  2705 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 131 "ast-to-xml.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 131 "ast-to-xml.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 131 "ast-to-xml.k"
		const activity c = this->activity_1;
#line 131 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 132 "ast-to-xml.k"
		inup(); 
#line  2722 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<onMessage id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 132 "ast-to-xml.k"
		listAttributes( _id ); 
#line  2728 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 134 "ast-to-xml.k"
		if (a->length() == 0) 
#line  2732 "ast-system-unpk.cc"
		{
		}
#line 136 "ast-to-xml.k"
		else 
#line  2737 "ast-system-unpk.cc"
		{
#line 137 "ast-to-xml.k"
		    inup(); 
#line  2741 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<correlations>\n"), kc_current_view); }
		    kc::unparse(a, kc_printer, kc_current_view);
#line 137 "ast-to-xml.k"
		    indown(); 
#line  2746 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</correlations>\n"), kc_current_view); }
		}
#line 139 "ast-to-xml.k"
		if (b->length() == 0) 
#line  2751 "ast-system-unpk.cc"
		{
		}
#line 141 "ast-to-xml.k"
		else 
#line  2756 "ast-system-unpk.cc"
		{
#line 142 "ast-to-xml.k"
		    inup(); 
#line  2760 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<fromParts>\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 142 "ast-to-xml.k"
		    indown(); 
#line  2765 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</fromParts>\n"), kc_current_view); }
		}
		kc::unparse(c, kc_printer, kc_current_view);
#line 144 "ast-to-xml.k"
		indown(); 
#line  2771 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</onMessage>\n"), kc_current_view); }
	    }
	    break;
	}

#line  2777 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tOnAlarm_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  2797 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tOnAlarm_list iterator_ = this; iterator_->tOnAlarm_list_1 != 0; iterator_ = iterator_->tOnAlarm_list_1)
		    iterator_->tOnAlarm_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tOnAlarm_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2815 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  2827 "ast-system-unpk.cc"
void
impl_tOnAlarm_OnAlarm::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 494 "ast-postprocess.k"
		const tRepeatEvery b = this->tRepeatEvery_1;
#line 494 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 494 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 496 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		assert(globals::ASTEmap[myself->parentActivityId] != NULL);

		if(string(b->op_name())=="RepeatEvery")
		{
		    myself->cyclic=true;
		    globals::ASTEmap[a->id]->max_occurrences = UINT_MAX;
		} 
		else
		{

		    unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		    if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		    globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences * max_loops;
		    else
		    globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;
		}


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;

#line  2870 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 525 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  2882 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 147 "ast-to-xml.k"
		const tRepeatEvery a = this->tRepeatEvery_1;
#line 147 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 147 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 148 "ast-to-xml.k"
		inup(); 
#line  2897 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<onAlarm"), kc_current_view); }
#line 148 "ast-to-xml.k"
		listAttributes( _id ); 
#line  2901 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 148 "ast-to-xml.k"
		indown(); 
#line  2906 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</onAlarm>\n"), kc_current_view); }
	    }
	    break;
	}

#line  2912 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2925 "ast-system-unpk.cc"
void
impl_tRepeatEvery_RepeatEvery::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2931 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2944 "ast-system-unpk.cc"
void
impl_tRepeatEvery_emptyRepeatEvery::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2950 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tVariable_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  2970 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tVariable_list iterator_ = this; iterator_->tVariable_list_1 != 0; iterator_ = iterator_->tVariable_list_1)
		    iterator_->tVariable_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tVariable_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2988 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3000 "ast-system-unpk.cc"
void
impl_tVariable_Variable::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 644 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 646 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineVariable();

#line  3021 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 174 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 175 "ast-to-xml.k"
		in(); 
#line  3032 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<variable id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 175 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3038 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3044 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCorrelationSet_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3064 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCorrelationSet_list iterator_ = this; iterator_->tCorrelationSet_list_1 != 0; iterator_ = iterator_->tCorrelationSet_list_1)
		    iterator_->tCorrelationSet_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCorrelationSet_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3082 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3094 "ast-system-unpk.cc"
void
impl_tCorrelationSet_CorrelationSet::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 664 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 666 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineCorrelationSet();

#line  3115 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 183 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 184 "ast-to-xml.k"
		in(); 
#line  3126 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<correlationSet"), kc_current_view); }
#line 184 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3130 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3136 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCorrelation_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3156 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCorrelation_list iterator_ = this; iterator_->tCorrelation_list_1 != 0; iterator_ = iterator_->tCorrelation_list_1)
		    iterator_->tCorrelation_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCorrelation_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3174 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3186 "ast-system-unpk.cc"
void
impl_tCorrelation_Correlation::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 684 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 686 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		string correlationSetName = myself->checkCorrelationSet();


		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		if (globals::ASTEmap[myself->parentActivityId]->isStartActivity &&
		    myself->attributes["initiate"] == "join")
		{
		    globals::ASTEmap[myself->parentActivityId]->sharedCorrelationSets.insert(correlationSetName);
		}

#line  3215 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 192 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 193 "ast-to-xml.k"
		in(); 
#line  3226 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<correlation"), kc_current_view); }
#line 193 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3230 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3236 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tToPart_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3256 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tToPart_list iterator_ = this; iterator_->tToPart_list_1 != 0; iterator_ = iterator_->tToPart_list_1)
		    iterator_->tToPart_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tToPart_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3274 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3286 "ast-system-unpk.cc"
void
impl_tToPart_ToPart::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 712 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 714 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();

#line  3305 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 200 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 201 "ast-to-xml.k"
		in(); 
#line  3316 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<toPart"), kc_current_view); }
#line 201 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3320 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3326 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tFromPart_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3346 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tFromPart_list iterator_ = this; iterator_->tFromPart_list_1 != 0; iterator_ = iterator_->tFromPart_list_1)
		    iterator_->tFromPart_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tFromPart_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3364 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3376 "ast-system-unpk.cc"
void
impl_tFromPart_FromPart::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 725 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 727 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();

#line  3395 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 204 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 205 "ast-to-xml.k"
		in(); 
#line  3406 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<fromPart"), kc_current_view); }
#line 205 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3410 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3416 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3429 "ast-system-unpk.cc"
void
impl_tReceive_Receive::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 816 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 816 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 816 "ast-postprocess.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 816 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 818 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		if (c->length() != 0 && myself->attributes["variable"] != "")
		SAerror(55, "", myself->attributes["referenceLine"]);

		myself->checkPartnerLink();

		myself->channelName = myself->createChannel();
		myself->variableName = myself->checkVariable("variable");

		{
#line 840 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  3472 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 840 "ast-postprocess.k"
			    {
#line 841 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 841 "ast-postprocess.k"
#line 840 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 840 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 841 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  3493 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  3498 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 840 "ast-postprocess.k"

#line  3503 "ast-system-unpk.cc"
		    }
		}
#line 846 "ast-postprocess.k"

#line  3508 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 848 "ast-postprocess.k"

		if (myself->isStartActivity)
		{
		    globals::ASTE_startActivities.insert(myid);


		    if (!globals::ASTEmap[myself->parentActivityId]->checkAncestors() || !myself->targetLinks.empty())
		    SAerror(56, "<receive>", myself->attributes["referenceLine"]);
		}

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  3524 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 388 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 388 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 388 "ast-to-cfg.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 388 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 389 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Receive\n");
		CFGBlock * block = new CFGBlock(CFGReceive, this->id, "Receive"); 


		block->channel_name = globals::ASTEmap[d->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  3549 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 213 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 213 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 213 "ast-to-xml.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 213 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 214 "ast-to-xml.k"
		inup(); 
#line  3567 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<receive id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 214 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3573 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 214 "ast-to-xml.k"
		indown(); 
#line  3580 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</receive>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 72 "ast-to-petrinet.k"
		PReceive(this, kc_current_view_base); 
#line  3590 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 72 "ast-to-petrinet.k"
		PReceive(this, kc_current_view_base); 
#line  3599 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  3604 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3617 "ast-system-unpk.cc"
void
impl_tReply_Reply::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 868 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 868 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 868 "ast-postprocess.k"
		const tToPart_list c = this->tToPart_list_1;
#line 868 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 870 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();



		myself->checkPartnerLink();


		if (c->length() != 0 && myself->attributes["variable"] != "")
		SAerror(59, "", myself->attributes["referenceLine"]);

		myself->channelName = myself->createChannel();
		myself->variableName = myself->checkVariable("variable");

		{
#line 892 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  3660 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 892 "ast-postprocess.k"
			    {
#line 893 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 893 "ast-postprocess.k"
#line 892 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 892 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 893 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  3681 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  3686 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 892 "ast-postprocess.k"

#line  3691 "ast-system-unpk.cc"
		    }
		}
#line 898 "ast-postprocess.k"

#line  3696 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 900 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  3703 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 407 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 407 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 407 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 407 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 408 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Reply\n");
		CFGBlock * block = new CFGBlock(CFGReply, this->id, "Reply"); 


		block->channel_name = globals::ASTEmap[d->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  3728 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 222 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 222 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 222 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 222 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 223 "ast-to-xml.k"
		inup(); 
#line  3746 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<reply id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 223 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3752 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 223 "ast-to-xml.k"
		indown(); 
#line  3759 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</reply>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 76 "ast-to-petrinet.k"
		PReply(this, kc_current_view_base); 
#line  3769 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 76 "ast-to-petrinet.k"
		PReply(this, kc_current_view_base); 
#line  3778 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  3783 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3796 "ast-system-unpk.cc"
void
impl_tInvoke_volatile_annotatedInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3802 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3815 "ast-system-unpk.cc"
void
impl_tInvoke_AsynchronousInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 369 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 369 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 369 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 369 "ast-to-cfg.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 369 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 370 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Invoke\n");
		CFGBlock * block = new CFGBlock(CFGInvoke, this->id, "Invoke");


		block->channel_name = globals::ASTEmap[e->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  3843 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 235 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 235 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 235 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 235 "ast-to-xml.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 235 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 236 "ast-to-xml.k"
		inup(); 
#line  3863 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<invoke id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 236 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3869 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 236 "ast-to-xml.k"
		indown(); 
#line  3877 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</invoke>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 64 "ast-to-petrinet.k"
		PAsynchronousInvoke(this, kc_current_view_base); 
#line  3887 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 64 "ast-to-petrinet.k"
		PAsynchronousInvoke(this, kc_current_view_base); 
#line  3896 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  3901 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3914 "ast-system-unpk.cc"
void
impl_tInvoke_SynchronousInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 356 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 356 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 356 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 356 "ast-to-cfg.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 356 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 357 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Invoke\n");
		CFGBlock * block = new CFGBlock(CFGInvoke, this->id, "Invoke");


		block->channel_name = globals::ASTEmap[e->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  3942 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 231 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 231 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 231 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 231 "ast-to-xml.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 231 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 232 "ast-to-xml.k"
		inup(); 
#line  3962 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<invoke id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 232 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3968 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 232 "ast-to-xml.k"
		indown(); 
#line  3976 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</invoke>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 68 "ast-to-petrinet.k"
		PSynchronousInvoke(this, kc_current_view_base); 
#line  3986 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 68 "ast-to-petrinet.k"
		PSynchronousInvoke(this, kc_current_view_base); 
#line  3995 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4000 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4013 "ast-system-unpk.cc"
void
impl_tInvoke_volatile_Invoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 768 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 768 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 768 "ast-postprocess.k"
		const tToPart_list c = this->tToPart_list_1;
#line 768 "ast-postprocess.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 768 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 770 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		if (c->length() != 0 && myself->attributes["inputVariable"] != "")
		SAerror(51, "", myself->attributes["referenceLine"]);


		if (d->length() != 0 && myself->attributes["outputVariable"] != "")
		SAerror(52, "", myself->attributes["referenceLine"]);

		myself->checkPartnerLink();

		myself->channelName = myself->createChannel((myself->attributes["outputVariable"] != ""));
		myself->inputVariableName = myself->checkVariable("inputVariable");
		myself->outputVariableName = myself->checkVariable("outputVariable");

		{
#line 797 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  4063 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 797 "ast-postprocess.k"
			    {
#line 798 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 798 "ast-postprocess.k"
#line 797 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 797 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 798 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  4084 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4089 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 797 "ast-postprocess.k"

#line  4094 "ast-system-unpk.cc"
		    }
		}
#line 803 "ast-postprocess.k"

#line  4099 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 805 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4106 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4111 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4124 "ast-system-unpk.cc"
void
impl_tAssign_Assign::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 911 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 911 "ast-postprocess.k"
		const tCopy_list b = this->tCopy_list_1;
#line 911 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 913 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  4150 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 925 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4157 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 426 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 426 "ast-to-cfg.k"
		const tCopy_list b = this->tCopy_list_1;
#line 426 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 427 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Assign\n");
		CFGBlock * firstBlock = new CFGBlock(CFGAssign, this->id, "Assign_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGAssign, this->id, "Assign_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 439 "ast-to-cfg.k"
		    tCopy_list kc_fe_selvar_1 =  b;

#line  4187 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCopy_list
			) {
			tCopy kc_selvar_0_1 = kc_fe_selvar_1->tCopy_1;
			{
#line 439 "ast-to-cfg.k"
			    {
#line 440 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Copy)) {
#line 440 "ast-to-cfg.k"
#line 439 "ast-to-cfg.k"
				    const tFrom from = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tFrom_1;
#line 439 "ast-to-cfg.k"
				    const tTo to = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tTo_1;
#line 440 "ast-to-cfg.k"




				    CFGBlock * fromBlock = new CFGBlock(CFGFrom, from->id, "From_" + toString(i));
				    CFGBlock * toBlock   = new CFGBlock(CFGTo,   to->id, "To_" + toString(i++));
				    connectBlocks(last,fromBlock);
				    connectBlocks(fromBlock, toBlock);
				    last = toBlock;

#line  4213 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4218 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCopy_list_1;
#line 439 "ast-to-cfg.k"

#line  4223 "ast-system-unpk.cc"
		    }
		}
#line 449 "ast-to-cfg.k"

		connectBlocks(last, lastBlock);

#line  4230 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 244 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 244 "ast-to-xml.k"
		const tCopy_list b = this->tCopy_list_1;
#line 244 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 245 "ast-to-xml.k"
		inup(); 
#line  4246 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<assign id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 245 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4252 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 245 "ast-to-xml.k"
		indown(); 
#line  4258 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</assign>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 80 "ast-to-petrinet.k"
		PAssign(this, kc_current_view_base); 
#line  4268 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 80 "ast-to-petrinet.k"
		PAssign(this, kc_current_view_base); 
#line  4277 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4282 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCopy_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  4302 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCopy_list iterator_ = this; iterator_->tCopy_list_1 != 0; iterator_ = iterator_->tCopy_list_1)
		    iterator_->tCopy_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCopy_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  4320 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  4332 "ast-system-unpk.cc"
void
impl_tCopy_Copy::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 931 "ast-postprocess.k"
		const tFrom a = this->tFrom_1;
#line 931 "ast-postprocess.k"
		const tTo b = this->tTo_1;
#line 931 "ast-postprocess.k"
		const integer c = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 248 "ast-to-xml.k"
		const tFrom a = this->tFrom_1;
#line 248 "ast-to-xml.k"
		const tTo b = this->tTo_1;
#line 248 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 249 "ast-to-xml.k"
		inup(); 
#line  4362 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<copy id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 249 "ast-to-xml.k"
		indown(); 
#line  4370 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</copy>\n"), kc_current_view); }
	    }
	    break;
	}

#line  4376 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4389 "ast-system-unpk.cc"
void
impl_tFrom_From::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 935 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 937 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->checkPartnerLink();
		myself->variableName = myself->checkVariable("variable");

#line  4412 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 252 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 253 "ast-to-xml.k"
		in(); 
#line  4423 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<from />\n"), kc_current_view); }
	    }
	    break;
	}

#line  4429 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4442 "ast-system-unpk.cc"
void
impl_tTo_To::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 952 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 954 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->checkPartnerLink();
		myself->variableName = myself->checkVariable("variable");

#line  4465 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 256 "ast-to-xml.k"
		const integer b = this->integer_1;
#line 257 "ast-to-xml.k"
		in(); 
#line  4476 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<to />\n"), kc_current_view); }
	    }
	    break;
	}

#line  4482 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4495 "ast-system-unpk.cc"
void
impl_tValidate_Validate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 974 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 974 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 976 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  4519 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 988 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4525 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 327 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 327 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 328 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Validate\n");
		CFGBlock * block = new CFGBlock(CFGValidate, this->id, "Validate"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  4543 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 265 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 265 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 266 "ast-to-xml.k"
		inup(); 
#line  4557 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<validate id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 266 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4563 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 266 "ast-to-xml.k"
		indown(); 
#line  4568 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</validate>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 84 "ast-to-petrinet.k"
		PValidate(this, kc_current_view_base); 
#line  4578 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 84 "ast-to-petrinet.k"
		PValidate(this, kc_current_view_base); 
#line  4587 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4592 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4605 "ast-system-unpk.cc"
void
impl_tEmpty_Empty::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 743 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 743 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 745 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  4629 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 757 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4635 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 341 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 341 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 342 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Empty\n");
		CFGBlock * block = new CFGBlock(CFGEmpty, this->id, "Empty"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  4653 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 273 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 273 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 274 "ast-to-xml.k"
		inup(); 
#line  4667 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<empty id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 274 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4673 "ast-system-unpk.cc"
#line 275 "ast-to-xml.k"

		{
#line 276 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 278 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 278 "ast-to-xml.k"
#line 278 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 278 "ast-to-xml.k"
			*output << " />";  indown(); *output << endl; 
#line  4686 "ast-system-unpk.cc"
				} else
		    {
#line 279 "ast-to-xml.k"
#line 279 "ast-to-xml.k"
			*output << ">\n"; 
#line  4692 "ast-system-unpk.cc"
		    }
		}
#line 281 "ast-to-xml.k"

#line  4697 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 283 "ast-to-xml.k"

		{
#line 284 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 286 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 286 "ast-to-xml.k"
#line 286 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 286 "ast-to-xml.k"

#line  4711 "ast-system-unpk.cc"
		    } else
		    {
#line 287 "ast-to-xml.k"
#line 287 "ast-to-xml.k"
			indown(); *output << "</empty>\n"; 
#line  4717 "ast-system-unpk.cc"
		    }
		}
#line 289 "ast-to-xml.k"

#line  4722 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 60 "ast-to-petrinet.k"
		PEmpty(this, kc_current_view_base); 
#line  4731 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 60 "ast-to-petrinet.k"
		PEmpty(this, kc_current_view_base); 
#line  4740 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4745 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4758 "ast-system-unpk.cc"
void
impl_tWait_Wait::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 999 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 999 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1001 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  4782 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1013 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4788 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 462 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 462 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 463 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Wait\n");
		CFGBlock * block = new CFGBlock(CFGWait, this->id, "Wait"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  4806 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 298 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 298 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 299 "ast-to-xml.k"
		inup(); 
#line  4820 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<wait id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 299 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4826 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 299 "ast-to-xml.k"
		indown(); 
#line  4831 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</wait>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 88 "ast-to-petrinet.k"
		PWait(this, kc_current_view_base); 
#line  4841 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 88 "ast-to-petrinet.k"
		PWait(this, kc_current_view_base); 
#line  4850 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4855 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4868 "ast-system-unpk.cc"
void
impl_tExit_Exit::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1200 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1200 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1202 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  4892 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1214 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4898 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 540 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 540 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 541 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Exit\n");
		CFGBlock * block = new CFGBlock(CFGExit, this->id, "Exit"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  4916 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 307 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 307 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 308 "ast-to-xml.k"
		inup(); 
#line  4930 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<exit id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 308 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4936 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 308 "ast-to-xml.k"
		indown(); 
#line  4941 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</exit>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 100 "ast-to-petrinet.k"
		PExit(this, kc_current_view_base); 
#line  4951 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 100 "ast-to-petrinet.k"
		PExit(this, kc_current_view_base); 
#line  4960 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4965 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4978 "ast-system-unpk.cc"
void
impl_tThrow_Throw::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1024 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1024 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1026 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5002 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1038 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5008 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 478 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 478 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 479 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Throw\n");
		CFGBlock * block = new CFGBlock(CFGThrow, this->id, "Throw"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5026 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 316 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 316 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 317 "ast-to-xml.k"
		inup(); 
#line  5040 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<throw id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 317 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5046 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 317 "ast-to-xml.k"
		indown(); 
#line  5051 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</throw>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 92 "ast-to-petrinet.k"
		PThrow(this, kc_current_view_base); 
#line  5061 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 92 "ast-to-petrinet.k"
		PThrow(this, kc_current_view_base); 
#line  5070 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5075 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5088 "ast-system-unpk.cc"
void
impl_tRethrow_Rethrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1049 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1049 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1051 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();
		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    assert(globals::ASTEmap[*it] != NULL);
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(6, "", myself->attributes["referenceLine"]);

#line  5129 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1080 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5135 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 493 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 493 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 494 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Rethrow\n");
		CFGBlock * block = new CFGBlock(CFGRethrow, this->id, "Rhrow"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5153 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 325 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 325 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 326 "ast-to-xml.k"
		inup(); 
#line  5167 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<rethrow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 326 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5173 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 326 "ast-to-xml.k"
		indown(); 
#line  5178 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</rethrow>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 96 "ast-to-petrinet.k"
		PRethrow(this, kc_current_view_base); 
#line  5188 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5193 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5206 "ast-system-unpk.cc"
void
impl_tCompensate_CompensateScope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1140 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1140 "ast-postprocess.k"
		const casestring b = this->casestring_1;
#line 1140 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1142 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;



		if (myself->attributes["target"] == "")
		myself->attributes["target"] = string(b->name);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();
		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers" ||
			globals::ASTEmap[*it]->activityTypeName() == "compensationHandler" ||
			globals::ASTEmap[*it]->activityTypeName() == "terminationHandler")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(7, "", myself->attributes["referenceLine"]);



		if (globals::ASTE_scopeNames[myself->attributes["target"]] == 0)
		SAerror(78, myself->attributes["target"], myself->attributes["referenceLine"]);
		else if (globals::ASTEmap[myself->parentScopeId]->enclosedScopes.find(globals::ASTE_scopeNames[myself->attributes["target"]]) == globals::ASTEmap[myself->parentScopeId]->enclosedScopes.end())
		SAerror(77, myself->attributes["target"], myself->attributes["referenceLine"]);



		globals::PPhasCompensateMap[globals::PPcurrentScope] = 2;

#line  5267 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1189 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5273 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 524 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 524 "ast-to-cfg.k"
		const casestring name = this->casestring_1;
#line 524 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 525 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] CompensateScope\n");
		CFGBlock * block = new CFGBlock(CFGCompensateScope, this->id, "CompensateScope"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5293 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 338 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 338 "ast-to-xml.k"
		const casestring b = this->casestring_1;
#line 338 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 339 "ast-to-xml.k"
		inup(); 
#line  5309 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensateScope id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" target=\""), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 339 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5317 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 339 "ast-to-xml.k"
		indown(); 
#line  5322 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensateScope>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 108 "ast-to-petrinet.k"
		PCompensateScope(this, kc_current_view_base); 
#line  5332 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 108 "ast-to-petrinet.k"
		PCompensateScope(this, kc_current_view_base); 
#line  5341 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5346 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5359 "ast-system-unpk.cc"
void
impl_tCompensate_Compensate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1091 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1091 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1093 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();

		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers" ||
			globals::ASTEmap[*it]->activityTypeName() == "compensationHandler" ||
			globals::ASTEmap[*it]->activityTypeName() == "terminationHandler")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(8, "", myself->attributes["referenceLine"]);




		globals::PPhasCompensateMap[globals::PPcurrentScope] = 1;

#line  5407 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1129 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5413 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 509 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 509 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 510 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Compensate\n");
		CFGBlock * block = new CFGBlock(CFGCompensate, this->id, "Compensate"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5431 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 334 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 334 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 335 "ast-to-xml.k"
		inup(); 
#line  5445 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensate id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 335 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5451 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 335 "ast-to-xml.k"
		indown(); 
#line  5456 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensate>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 104 "ast-to-petrinet.k"
		PCompensate(this, kc_current_view_base); 
#line  5466 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 104 "ast-to-petrinet.k"
		PCompensate(this, kc_current_view_base); 
#line  5475 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5480 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5493 "ast-system-unpk.cc"
void
impl_tSequence_Sequence::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1538 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1538 "ast-postprocess.k"
		const activity_list b = this->activity_list_1;
#line 1538 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1540 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		{
#line 1554 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  5526 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1554 "ast-postprocess.k"
			    {
				{
#line 1555 "ast-postprocess.k"
#line 1554 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1555 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  5545 "ast-system-unpk.cc"
				}
			    }

#line  5549 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1554 "ast-postprocess.k"

#line  5554 "ast-system-unpk.cc"
		    }
		}
#line 1561 "ast-postprocess.k"

#line  5559 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1563 "ast-postprocess.k"



		int activityCount = 1;
		{
#line 1567 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  5571 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1567 "ast-postprocess.k"
			    {
				{
#line 1568 "ast-postprocess.k"
#line 1567 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1568 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);

				    bool before = true;
				    {
#line 1572 "ast-postprocess.k"
					activity_list kc_fe_selvar_1 =  b;

#line  5592 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
					    ) {
					    activity kc_selvar_1_1 = kc_fe_selvar_1->activity_1;
					    {
#line 1572 "ast-postprocess.k"
						{
						    {
#line 1573 "ast-postprocess.k"
#line 1572 "ast-postprocess.k"
							const activity innerActivity2 = kc_selvar_1_1;
#line 1573 "ast-postprocess.k"

							if ( innerActivity2->id == innerActivity->id)
							{
							    before == false;
							}
							else if (before == true)
							{
							    enterConsecutiveActivities( innerActivity2->id, innerActivity->id );
							}

#line  5615 "ast-system-unpk.cc"
						    }
						}

#line  5619 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1572 "ast-postprocess.k"

#line  5624 "ast-system-unpk.cc"
					}
				    }
#line 1583 "ast-postprocess.k"

				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);


				    if (globals::ASTEmap[innerActivity->id]->isStartActivity && activityCount++ > 1)
				    SAerror(56, "<" + globals::ASTEmap[innerActivity->id]->activityTypeName() + ">", globals::ASTEmap[innerActivity->id]->attributes["referenceLine"]);

#line  5635 "ast-system-unpk.cc"
				}
			    }

#line  5639 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1567 "ast-postprocess.k"

#line  5644 "ast-system-unpk.cc"
		    }
		}
#line 1590 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  5653 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 758 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 758 "ast-to-cfg.k"
		const activity_list b = this->activity_list_1;
#line 758 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 759 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Sequence\n");
		CFGBlock * firstBlock = new CFGBlock(CFGSequence, this->id, "Sequence_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGSequence, this->id, "Sequence_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  5677 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 770 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		{
#line 772 "ast-to-cfg.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  5686 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 772 "ast-to-cfg.k"
			    {
				{
#line 773 "ast-to-cfg.k"
#line 772 "ast-to-cfg.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 773 "ast-to-cfg.k"

				    CFGBlock * current = globals::cfgMap.find(toString(innerActivity->id))->second;

				    connectBlocks(last, current->firstBlock);
				    last = current->lastBlock;

#line  5705 "ast-system-unpk.cc"
				}
			    }

#line  5709 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 772 "ast-to-cfg.k"

#line  5714 "ast-system-unpk.cc"
		    }
		}
#line 778 "ast-to-cfg.k"

		connectBlocks(last, lastBlock);

#line  5721 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 782 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Sequence\n");

#line  5727 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 347 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 347 "ast-to-xml.k"
		const activity_list b = this->activity_list_1;
#line 347 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 348 "ast-to-xml.k"
		inup(); 
#line  5742 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sequence id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 348 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5748 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 348 "ast-to-xml.k"
		indown(); 
#line  5754 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sequence>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 130 "ast-to-petrinet.k"
		PSequence(this, kc_current_view_base); 
#line  5764 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 130 "ast-to-petrinet.k"
		PSequence(this, kc_current_view_base); 
#line  5773 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5778 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5791 "ast-system-unpk.cc"
void
impl_tIf_If::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1323 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1323 "ast-postprocess.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 1323 "ast-postprocess.k"
		const tElse c = this->tElse_1;
#line 1323 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1325 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		{
#line 1340 "ast-postprocess.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  5827 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 1340 "ast-postprocess.k"
			    {
#line 1341 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 1341 "ast-postprocess.k"
#line 1340 "ast-postprocess.k"
				    const tElseIf branch = kc_selvar_0_1;
#line 1340 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 1340 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->integer_1;
#line 1341 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  5851 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  5856 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 1340 "ast-postprocess.k"

#line  5861 "ast-system-unpk.cc"
		    }
		}
#line 1347 "ast-postprocess.k"


		{
#line 1349 "ast-postprocess.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 1352 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 1352 "ast-postprocess.k"
#line 1351 "ast-postprocess.k"
			const tElse c = kc_selvar_0_1;
#line 1351 "ast-postprocess.k"
			const activity d = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 1351 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 1352 "ast-postprocess.k"

			assert(globals::ASTEmap[d->id] != NULL);
			globals::ASTEmap[d->id]->parentActivityId = myid;
			globals::ASTEmap[d->id]->controlFlow = myself->controlFlow;
			globals::ASTEmap[d->id]->max_occurrences = myself->max_occurrences;

#line  5886 "ast-system-unpk.cc"
		    } else
		    {
#line 1358 "ast-postprocess.k"
#line 1358 "ast-postprocess.k"

#line  5892 "ast-system-unpk.cc"
		    }
		}
#line 1360 "ast-postprocess.k"

#line  5897 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 1362 "ast-postprocess.k"


		{
#line 1364 "ast-postprocess.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  5908 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 1364 "ast-postprocess.k"
			    {
#line 1365 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 1365 "ast-postprocess.k"
#line 1364 "ast-postprocess.k"
				    const tElseIf branch = kc_selvar_0_1;
#line 1364 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 1364 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->integer_1;
#line 1365 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);

#line  5930 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  5935 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 1364 "ast-postprocess.k"

#line  5940 "ast-system-unpk.cc"
		    }
		}
#line 1369 "ast-postprocess.k"

		{
#line 1370 "ast-postprocess.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 1373 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 1373 "ast-postprocess.k"
#line 1372 "ast-postprocess.k"
			const tElse c = kc_selvar_0_1;
#line 1372 "ast-postprocess.k"
			const activity d = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 1372 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 1373 "ast-postprocess.k"

			assert(globals::ASTEmap[d->id] != NULL);
			myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[d->id]->enclosedSourceLinks);

#line  5962 "ast-system-unpk.cc"
		    } else
		    {
#line 1377 "ast-postprocess.k"
#line 1377 "ast-postprocess.k"

#line  5968 "ast-system-unpk.cc"
		    }
		}
#line 1379 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  5977 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    if ((this->tElse_1->prod_sel() == sel_Else)) {
#line 590 "ast-to-cfg.k"
		const tIf This = this/**/;
#line 590 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 590 "ast-to-cfg.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 590 "ast-to-cfg.k"
		const activity c = phylum_cast<const impl_tElse_Else*>(this->tElse_1)->activity_1;
#line 590 "ast-to-cfg.k"
		const integer d = phylum_cast<const impl_tElse_Else*>(this->tElse_1)->integer_1;
#line 590 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 591 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] If\n");
		CFGBlock * firstBlock = new CFGBlock(CFGIf, this->id, "If_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGIf, this->id, "If_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  6007 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 603 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 606 "ast-to-cfg.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  6018 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 606 "ast-to-cfg.k"
			    {
#line 607 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 607 "ast-to-cfg.k"
#line 606 "ast-to-cfg.k"
				    const tElseIf elseIfBranch = kc_selvar_0_1;
#line 606 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 607 "ast-to-cfg.k"

				    CFGBlock * elseIfBlock = new CFGBlock(CFGElseIf, This->id, "ElseIf_" + toString(i));

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(last, elseIfBlock);
				    connectBlocks(elseIfBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

				    last = elseIfBlock;	    
				    i++;

#line  6047 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  6052 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 606 "ast-to-cfg.k"

#line  6057 "ast-system-unpk.cc"
		    }
		}
#line 619 "ast-to-cfg.k"

		CFGBlock * elseBlock = new CFGBlock(CFGElse, this->id, "Else");
		CFGBlock * innerFirst = globals::cfgMap.find(toString(c->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(c->id))->second->lastBlock;

		connectBlocks(last, elseBlock);
		connectBlocks(elseBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  6070 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    } else
		if ((this->tElse_1->prod_sel() == sel_NoElse)) {
#line 632 "ast-to-cfg.k"
		const tIf This = this/**/;
#line 632 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 632 "ast-to-cfg.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 632 "ast-to-cfg.k"
		const integer _id = phylum_cast<const impl_tElse_NoElse*>(this->tElse_1)->integer_1;
#line 632 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 633 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] If\n");
		CFGBlock * firstBlock = new CFGBlock(CFGIf, this->id, "If_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGIf, this->id, "If_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  6095 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 644 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 647 "ast-to-cfg.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  6105 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 647 "ast-to-cfg.k"
			    {
#line 648 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 648 "ast-to-cfg.k"
#line 647 "ast-to-cfg.k"
				    const tElseIf elseIfBranch = kc_selvar_0_1;
#line 647 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 648 "ast-to-cfg.k"

				    CFGBlock * elseIfBlock = new CFGBlock(CFGElseIf, This->id, "ElseIf_" + toString(i));

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(last, elseIfBlock);
				    connectBlocks(elseIfBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

				    last = elseIfBlock;	    
				    i++;

#line  6134 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  6139 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 647 "ast-to-cfg.k"

#line  6144 "ast-system-unpk.cc"
		    }
		}
#line 660 "ast-to-cfg.k"










		connectBlocks(last, lastBlock);

#line  6160 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tElseIf_list_1->prod_sel() == sel_ConstElseIf_list) && ((this->tElseIf_list_1)->tElseIf_1->prod_sel() == sel_ElseIf)) {
#line 356 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 356 "ast-to-xml.k"
		const activity b = phylum_cast<const impl_tElseIf_ElseIf*>((this->tElseIf_list_1)->tElseIf_1)->activity_1;
#line 356 "ast-to-xml.k"
		const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>((this->tElseIf_list_1)->tElseIf_1)->integer_1;
#line 356 "ast-to-xml.k"
		const tElseIf_list c = (this->tElseIf_list_1)->tElseIf_list_1;
#line 356 "ast-to-xml.k"
		const tElse d = this->tElse_1;
#line 356 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 357 "ast-to-xml.k"
		inup(); 
#line  6183 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<if id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 357 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6189 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 357 "ast-to-xml.k"

#line  6193 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 357 "ast-to-xml.k"
		indown(); 
#line  6200 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</if>\n"), kc_current_view); }
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 142 "ast-to-petrinet.k"
		PIf(this, kc_current_view_base); 
#line  6211 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 142 "ast-to-petrinet.k"
		PIf(this, kc_current_view_base); 
#line  6220 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6225 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tElseIf_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  6246 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tElseIf_list iterator_ = this; iterator_->tElseIf_list_1 != 0; iterator_ = iterator_->tElseIf_list_1)
		    iterator_->tElseIf_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tElseIf_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  6265 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  6278 "ast-system-unpk.cc"
void
impl_tElseIf_ElseIf::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1387 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 1387 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1389 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  6300 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1399 "ast-postprocess.k"

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  6308 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 360 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 360 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 361 "ast-to-xml.k"
		inup(); 
#line  6321 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<elseif id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 361 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6327 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 361 "ast-to-xml.k"
		indown(); 
#line  6332 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</elseif>\n"), kc_current_view); }
	    }
	    break;
	}

#line  6338 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6351 "ast-system-unpk.cc"
void
impl_tElse_NoElse::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1426 "ast-postprocess.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}

#line  6365 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6378 "ast-system-unpk.cc"
void
impl_tElse_Else::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1407 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 1407 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1409 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;

#line  6399 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1418 "ast-postprocess.k"

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  6407 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 364 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 364 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 365 "ast-to-xml.k"
		inup(); 
#line  6420 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<else id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 365 "ast-to-xml.k"
		indown(); 
#line  6427 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</else>\n"), kc_current_view); }
	    }
	    break;
	}

#line  6433 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6446 "ast-system-unpk.cc"
void
impl_tWhile_While::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1433 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1433 "ast-postprocess.k"
		const activity b = this->activity_1;
#line 1433 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1435 "ast-postprocess.k"


		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		assert(globals::ASTEmap[b->id] != NULL);
		globals::ASTEmap[b->id]->parentActivityId = myid;
		globals::ASTEmap[b->id]->controlFlow = myself->controlFlow;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		globals::ASTEmap[b->id]->max_occurrences = myself->max_occurrences * max_loops;
		else
		globals::ASTEmap[b->id]->max_occurrences = UINT_MAX;

		myself->max_loops = max_loops;

#line  6489 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1464 "ast-postprocess.k"


		assert(globals::ASTEmap[b->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[b->id]->enclosedSourceLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  6504 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 681 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 681 "ast-to-cfg.k"
		const activity b = this->activity_1;
#line 681 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 682 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] While\n");
		CFGBlock * block = new CFGBlock(CFGWhile, this->id, "While"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6524 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 689 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(block, innerFirst);
		connectBlocks(innerLast, block);

#line  6534 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 373 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 373 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 373 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 374 "ast-to-xml.k"
		inup(); 
#line  6550 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<while id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 374 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6556 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 374 "ast-to-xml.k"
		indown(); 
#line  6562 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</while>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 122 "ast-to-petrinet.k"
		PWhile(this, kc_current_view_base); 
#line  6572 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 122 "ast-to-petrinet.k"
		PWhile(this, kc_current_view_base); 
#line  6581 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6586 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6599 "ast-system-unpk.cc"
void
impl_tRepeatUntil_RepeatUntil::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1486 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1486 "ast-postprocess.k"
		const activity b = this->activity_1;
#line 1486 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1488 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		assert(globals::ASTEmap[b->id] != NULL);
		globals::ASTEmap[b->id]->parentActivityId = myid;
		globals::ASTEmap[b->id]->controlFlow = myself->controlFlow;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		globals::ASTEmap[b->id]->max_occurrences = myself->max_occurrences * max_loops;
		else
		globals::ASTEmap[b->id]->max_occurrences = UINT_MAX;

		myself->max_loops = max_loops;

#line  6641 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1516 "ast-postprocess.k"


		assert(globals::ASTEmap[b->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[b->id]->enclosedSourceLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  6656 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 729 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 729 "ast-to-cfg.k"
		const activity b = this->activity_1;
#line 729 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 730 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] RepeatUntil\n");
		CFGBlock * repeat = new CFGBlock(CFGRepeatUntil, this->id, "Repeat"); 
		CFGBlock * until = new CFGBlock(CFGRepeatUntil, this->id, "Until"); 

		repeat->firstBlock = until->firstBlock = repeat;
		repeat->lastBlock  = until->lastBlock  = until;

		globals::cfgMap[toString(this->id)] = repeat; 

#line  6680 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 741 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(repeat, innerFirst);
		connectBlocks(innerLast, until);
		connectBlocks(until, repeat);

#line  6691 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 382 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 382 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 382 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 383 "ast-to-xml.k"
		inup(); 
#line  6707 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<repeatUntil id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 383 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6713 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 383 "ast-to-xml.k"
		indown(); 
#line  6719 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</repeatUntil>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 126 "ast-to-petrinet.k"
		PRepeatUntil(this, kc_current_view_base); 
#line  6729 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 126 "ast-to-petrinet.k"
		PRepeatUntil(this, kc_current_view_base); 
#line  6738 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6743 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6756 "ast-system-unpk.cc"
void
impl_tForEach_ForEach::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1699 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1699 "ast-postprocess.k"
		const casestring b = this->casestring_1;
#line 1699 "ast-postprocess.k"
		const casestring c = this->casestring_2;
#line 1699 "ast-postprocess.k"
		const casestring d = this->casestring_3;
#line 1699 "ast-postprocess.k"
		const tScope e = this->tScope_1;
#line 1699 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1701 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();



		myself->checkVariable("counterName");


		assert(globals::ASTEmap[e->id] != NULL);
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[e->id]->controlFlow = myself->controlFlow;


		unsigned int startCounter = toUInt(b->name);
		unsigned int finalCounter = toUInt(c->name);
		unsigned int completion = toUInt(d->name);
		if (startCounter != UINT_MAX && finalCounter != UINT_MAX)
		{
		    if (startCounter >= finalCounter)
		    {
			string error = "constant <finalCounterValue> `" + toString(finalCounter) +
			"' less or equal than constant <startCounterValue> `" + toString(startCounter) + "'";
			SAerror(74, error, myself->attributes["referenceLine"]);
		    }
		    else
		    {
			if (myself->attributes["hu:maxloops"] != "")
			cerr << "ignoring attribute `hu:maxloops'" << endl; 
			globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences * (finalCounter - startCounter);
			myself->max_loops = (finalCounter - startCounter);
		    }

		    if ((completion != UINT_MAX) && ((completion > (finalCounter-startCounter))))
		    SAerror(75, "", myself->attributes["referenceLine"]);
		}
		else
		{

		    unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		    if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		    globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences * max_loops;
		    else
		    globals::ASTEmap[e->id]->max_occurrences = UINT_MAX;

		    myself->max_loops = max_loops;
		}

#line  6832 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
#line 1757 "ast-postprocess.k"


		{
#line 1759 "ast-postprocess.k"
		    tScope kc_selvar_0_1 = phylum_cast<tScope>(e);
#line 1762 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Scope)) {
#line 1762 "ast-postprocess.k"
#line 1761 "ast-postprocess.k"
			const tScope e = kc_selvar_0_1;
#line 1761 "ast-postprocess.k"
			const tVariable_list _variables = phylum_cast<const impl_tScope_Scope*>(kc_selvar_0_1)->tVariable_list_1;
#line 1762 "ast-postprocess.k"

			{
#line 1763 "ast-postprocess.k"
			    tVariable_list kc_fe_selvar_1 =  _variables;

#line  6854 "ast-system-unpk.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstVariable_list
				) {
				tVariable kc_selvar_1_1 = kc_fe_selvar_1->tVariable_1;
				{
#line 1763 "ast-postprocess.k"
				    {
#line 1764 "ast-postprocess.k"
					if ((kc_selvar_1_1->prod_sel() == sel_Variable)) {
#line 1764 "ast-postprocess.k"
#line 1763 "ast-postprocess.k"
					    const tVariable variable = kc_selvar_1_1;
#line 1763 "ast-postprocess.k"
					    const integer _id2 = phylum_cast<const impl_tVariable_Variable*>(kc_selvar_1_1)->integer_1;
#line 1764 "ast-postprocess.k"

					    assert(_id2 != NULL);
					    assert(globals::ASTEmap[_id2->value] != NULL);
					    if (globals::ASTEmap[_id2->value]->attributes["name"] == globals::ASTEmap[_id->value]->attributes["counterName"])
					    SAerror(76, globals::ASTEmap[_id2->value]->attributes["name"], globals::ASTEmap[_id2->value]->attributes["referenceLine"]);

#line  6876 "ast-system-unpk.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  6881 "ast-system-unpk.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tVariable_list_1;
#line 1763 "ast-postprocess.k"

#line  6886 "ast-system-unpk.cc"
			    }
			}
#line 1769 "ast-postprocess.k"


#line  6892 "ast-system-unpk.cc"
		    } else
			kc_no_default_in_with( "", __LINE__, __FILE__ );
		}
#line 1772 "ast-postprocess.k"


		assert(globals::ASTEmap[e->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  6908 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 705 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 705 "ast-to-cfg.k"
		const casestring b = this->casestring_1;
#line 705 "ast-to-cfg.k"
		const casestring c = this->casestring_2;
#line 705 "ast-to-cfg.k"
		const casestring d = this->casestring_3;
#line 705 "ast-to-cfg.k"
		const tScope e = this->tScope_1;
#line 705 "ast-to-cfg.k"
		const integer f = this->integer_1;
#line 706 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ForEach\n");
		CFGBlock * block = new CFGBlock(CFGForEach, this->id, "ForEach"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6934 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 713 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(e->id))->second->lastBlock;

		connectBlocks(block, innerFirst);
		connectBlocks(innerLast, block);

#line  6944 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 391 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 391 "ast-to-xml.k"
		const casestring b = this->casestring_1;
#line 391 "ast-to-xml.k"
		const casestring c = this->casestring_2;
#line 391 "ast-to-xml.k"
		const casestring d = this->casestring_3;
#line 391 "ast-to-xml.k"
		const tScope e = this->tScope_1;
#line 391 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 392 "ast-to-xml.k"
		inup(); 
#line  6966 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<foreach id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 392 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6972 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 394 "ast-to-xml.k"
		inup(); 
#line  6977 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<startCounterValue>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 394 "ast-to-xml.k"
		indown(); 
#line  6982 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</startCounterValue>\n"), kc_current_view); }
#line 395 "ast-to-xml.k"
		inup(); 
#line  6986 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<finalCounterValue>\n"), kc_current_view); }
		kc::unparse(c, kc_printer, kc_current_view);
#line 395 "ast-to-xml.k"
		indown(); 
#line  6991 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</finalCounterValue>\n"), kc_current_view); }
#line 396 "ast-to-xml.k"
		inup(); 
#line  6995 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<completionCondition>\n"), kc_current_view); }
		kc::unparse(d, kc_printer, kc_current_view);
#line 396 "ast-to-xml.k"
		indown(); 
#line  7000 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</completionCondition>\n"), kc_current_view); }
		kc::unparse(e, kc_printer, kc_current_view);
#line 398 "ast-to-xml.k"
		indown(); 
#line  7005 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</repeatUntil>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 146 "ast-to-petrinet.k"
		PForEach(this, kc_current_view_base); 
#line  7015 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 146 "ast-to-petrinet.k"
		PForEach(this, kc_current_view_base); 
#line  7024 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  7029 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  7042 "ast-system-unpk.cc"
void
impl_tPick_Pick::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1603 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1603 "ast-postprocess.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 1603 "ast-postprocess.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 1603 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1605 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		{
#line 1619 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  7077 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 1619 "ast-postprocess.k"
			    {
#line 1620 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 1620 "ast-postprocess.k"
#line 1619 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 1619 "ast-postprocess.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 1619 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 1619 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 1619 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 1620 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id2->value]->max_occurrences = myself->max_occurrences;

#line  7106 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7111 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 1619 "ast-postprocess.k"

#line  7116 "ast-system-unpk.cc"
		    }
		}
#line 1627 "ast-postprocess.k"
		{
#line 1627 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  7124 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 1627 "ast-postprocess.k"
			    {
#line 1628 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 1628 "ast-postprocess.k"
#line 1627 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 1627 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 1627 "ast-postprocess.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 1628 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id3->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id3->value]->max_occurrences = myself->max_occurrences;

#line  7149 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7154 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 1627 "ast-postprocess.k"

#line  7159 "ast-system-unpk.cc"
		    }
		}
#line 1635 "ast-postprocess.k"

#line  7164 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 1637 "ast-postprocess.k"

		if (myself->isStartActivity)
		{
		    globals::ASTE_startActivities.insert(myid);


		    if (c->length() != 0)
		    SAerror(62, "", myself->attributes["referenceLine"]);


		    if (!globals::ASTEmap[myself->parentActivityId]->checkAncestors() || !myself->targetLinks.empty())
		    SAerror(56, "<pick>", myself->attributes["referenceLine"]);
		}


		{
#line 1652 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  7188 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 1652 "ast-postprocess.k"
			    {
#line 1653 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 1653 "ast-postprocess.k"
#line 1652 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 1652 "ast-postprocess.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 1652 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 1652 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 1652 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 1653 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);

				    {
#line 1657 "ast-postprocess.k"
					tOnMessage_list kc_fe_selvar_1 =  b;

#line  7218 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
					    ) {
					    tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
					    {
#line 1657 "ast-postprocess.k"
						{
#line 1658 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 1658 "ast-postprocess.k"
#line 1657 "ast-postprocess.k"
							const tOnMessage otherbranch = kc_selvar_1_1;
#line 1657 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 1657 "ast-postprocess.k"
							const integer _id3 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->integer_1;
#line 1658 "ast-postprocess.k"

							assert(_id2 != NULL);
							assert(_id3 != NULL);
							if (_id2->value < _id3->value)
							{
							    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );
							}

#line  7244 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  7249 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 1657 "ast-postprocess.k"

#line  7254 "ast-system-unpk.cc"
					}
				    }
#line 1666 "ast-postprocess.k"

#line  7259 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7264 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 1652 "ast-postprocess.k"

#line  7269 "ast-system-unpk.cc"
		    }
		}
#line 1667 "ast-postprocess.k"
		{
#line 1667 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  7277 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 1667 "ast-postprocess.k"
			    {
#line 1668 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 1668 "ast-postprocess.k"
#line 1667 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 1667 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 1668 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);

				    {
#line 1672 "ast-postprocess.k"
					tOnMessage_list kc_fe_selvar_1 =  b;

#line  7301 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
					    ) {
					    tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
					    {
#line 1672 "ast-postprocess.k"
						{
#line 1673 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 1673 "ast-postprocess.k"
#line 1672 "ast-postprocess.k"
							const tOnMessage otherbranch = kc_selvar_1_1;
#line 1672 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 1673 "ast-postprocess.k"

							enterConflictingActivities( globals::ASTEmap[ innerActivity->id ]->enclosedActivities, globals::ASTEmap[ secondActivity->id ]->enclosedActivities );

#line  7320 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  7325 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 1672 "ast-postprocess.k"

#line  7330 "ast-system-unpk.cc"
					}
				    }
#line 1676 "ast-postprocess.k"

				    {
#line 1677 "ast-postprocess.k"
					tOnAlarm_list kc_fe_selvar_1 =  c;

#line  7339 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
					    ) {
					    tOnAlarm kc_selvar_1_1 = kc_fe_selvar_1->tOnAlarm_1;
					    {
#line 1677 "ast-postprocess.k"
						{
#line 1678 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnAlarm)) {
#line 1678 "ast-postprocess.k"
#line 1677 "ast-postprocess.k"
							const tOnAlarm otherbranch = kc_selvar_1_1;
#line 1677 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_1_1)->activity_1;
#line 1678 "ast-postprocess.k"

							if (innerActivity->id < secondActivity->id)
							{
							    enterConflictingActivities( globals::ASTEmap[ innerActivity->id ]->enclosedActivities, globals::ASTEmap[ secondActivity->id ]->enclosedActivities );
							}

#line  7361 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  7366 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 1677 "ast-postprocess.k"

#line  7371 "ast-system-unpk.cc"
					}
				    }
#line 1684 "ast-postprocess.k"

#line  7376 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7381 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 1667 "ast-postprocess.k"

#line  7386 "ast-system-unpk.cc"
		    }
		}
#line 1685 "ast-postprocess.k"


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7396 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 793 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 793 "ast-to-cfg.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 793 "ast-to-cfg.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 793 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 794 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Pick\n");
		CFGBlock * firstBlock = new CFGBlock(CFGPick, this->id, "Pick_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGPick, this->id, "Pick_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7422 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 806 "ast-to-cfg.k"

		int i = 1;
		{
#line 808 "ast-to-cfg.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  7432 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 808 "ast-to-cfg.k"
			    {
#line 809 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 809 "ast-to-cfg.k"
#line 808 "ast-to-cfg.k"
				    const tOnMessage message = kc_selvar_0_1;
#line 808 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 809 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onMessageBlock = new CFGBlock(CFGOnMessage, message->id, "OnMessage_" + toString(i++)); 
				    onMessageBlock->channel_name = globals::ASTEmap[message->id]->channelName;

				    connectBlocks(firstBlock, onMessageBlock);
				    connectBlocks(onMessageBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  7458 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7463 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 808 "ast-to-cfg.k"

#line  7468 "ast-system-unpk.cc"
		    }
		}
#line 818 "ast-to-cfg.k"

		i = 1; 
		{
#line 820 "ast-to-cfg.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  7478 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 820 "ast-to-cfg.k"
			    {
#line 821 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 821 "ast-to-cfg.k"
#line 820 "ast-to-cfg.k"
				    const tOnAlarm alarm = kc_selvar_0_1;
#line 820 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 821 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onAlarmBlock = new CFGBlock(CFGOnAlarm, alarm->id, "OnAlarm_" + toString(i++)); 

				    connectBlocks(firstBlock, onAlarmBlock);
				    connectBlocks(onAlarmBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  7503 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7508 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 820 "ast-to-cfg.k"

#line  7513 "ast-system-unpk.cc"
		    }
		}
#line 829 "ast-to-cfg.k"


#line  7519 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 406 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 406 "ast-to-xml.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 406 "ast-to-xml.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 406 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 407 "ast-to-xml.k"
		inup(); 
#line  7537 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<pick id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 407 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7543 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 407 "ast-to-xml.k"
		indown(); 
#line  7550 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</pick>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 138 "ast-to-petrinet.k"
		PPick(this, kc_current_view_base); 
#line  7560 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 138 "ast-to-petrinet.k"
		PPick(this, kc_current_view_base); 
#line  7569 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  7574 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  7587 "ast-system-unpk.cc"
void
impl_tFlow_Flow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1225 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1225 "ast-postprocess.k"
		const tLink_list b = this->tLink_list_1;
#line 1225 "ast-postprocess.k"
		const activity_list c = this->activity_list_1;
#line 1225 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1227 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		{
#line 1242 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  7623 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1242 "ast-postprocess.k"
			    {
				{
#line 1243 "ast-postprocess.k"
#line 1242 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1243 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  7642 "ast-system-unpk.cc"
				}
			    }

#line  7646 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1242 "ast-postprocess.k"

#line  7651 "ast-system-unpk.cc"
		    }
		}
#line 1249 "ast-postprocess.k"
		{
#line 1249 "ast-postprocess.k"
		    tLink_list kc_fe_selvar_1 =  b;

#line  7659 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstLink_list
			) {
			tLink kc_selvar_0_1 = kc_fe_selvar_1->tLink_1;
			{
#line 1249 "ast-postprocess.k"
			    {
				{
#line 1250 "ast-postprocess.k"
#line 1249 "ast-postprocess.k"
				    const tLink link = kc_selvar_0_1;
#line 1250 "ast-postprocess.k"

				    assert(globals::ASTEmap[link->id] != NULL);
				    globals::ASTEmap[ link->id ]->parentActivityId = myid;
				    globals::ASTEmap[ myid ]->enclosedActivities.insert( link->id );

#line  7677 "ast-system-unpk.cc"
				}
			    }

#line  7681 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tLink_list_1;
#line 1249 "ast-postprocess.k"

#line  7686 "ast-system-unpk.cc"
		    }
		}
#line 1255 "ast-postprocess.k"

#line  7691 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 1257 "ast-postprocess.k"


		unsigned int startActivityId = 0;

		{
#line 1261 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  7704 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1261 "ast-postprocess.k"
			    {
				{
#line 1262 "ast-postprocess.k"
#line 1261 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1262 "ast-postprocess.k"


				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);


				    if (globals::ASTEmap[innerActivity->id]->isStartActivity)
				    startActivityId = innerActivity->id;

#line  7726 "ast-system-unpk.cc"
				}
			    }

#line  7730 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1261 "ast-postprocess.k"

#line  7735 "ast-system-unpk.cc"
		    }
		}
#line 1271 "ast-postprocess.k"


		if (startActivityId != 0)
		{
		    {
#line 1275 "ast-postprocess.k"
			activity_list kc_fe_selvar_1 =  c;

#line  7747 "ast-system-unpk.cc"
			while(
				kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			    ) {
			    activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			    {
#line 1275 "ast-postprocess.k"
				{
				    {
#line 1276 "ast-postprocess.k"
#line 1275 "ast-postprocess.k"
					const activity innerActivity = kc_selvar_0_1;
#line 1276 "ast-postprocess.k"

					assert(globals::ASTEmap[innerActivity->id] != NULL);

					if (!globals::ASTEmap[innerActivity->id]->isStartActivity &&
					    globals::ASTEmap[innerActivity->id]->targetLinks.empty())
					{
					    SAerror(56, "<" + globals::ASTEmap[startActivityId]->activityTypeName() + ">", globals::ASTEmap[startActivityId]->attributes["referenceLine"]);
					    break;
					}

#line  7770 "ast-system-unpk.cc"
				    }
				}

#line  7774 "ast-system-unpk.cc"
			    }
			    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1275 "ast-postprocess.k"

#line  7779 "ast-system-unpk.cc"
			}
		    }
#line 1286 "ast-postprocess.k"
		}




		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7792 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 556 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 556 "ast-to-cfg.k"
		const tLink_list b = this->tLink_list_1;
#line 556 "ast-to-cfg.k"
		const activity_list c = this->activity_list_1;
#line 556 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 557 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Flow\n");
		CFGBlock * firstBlock = new CFGBlock(CFGFlow, this->id, "Flow_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGFlow, this->id, "Flow_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7818 "ast-system-unpk.cc"
		kc::unparse(c, kc_printer, kc_current_view);
#line 568 "ast-to-cfg.k"

		{
#line 569 "ast-to-cfg.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  7826 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 569 "ast-to-cfg.k"
			    {
				{
#line 570 "ast-to-cfg.k"
#line 569 "ast-to-cfg.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 570 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(firstBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  7846 "ast-system-unpk.cc"
				}
			    }

#line  7850 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 569 "ast-to-cfg.k"

#line  7855 "ast-system-unpk.cc"
		    }
		}
#line 576 "ast-to-cfg.k"


#line  7861 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 579 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Flow\n");

#line  7867 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tLink_list_1->prod_sel() == sel_NiltLink_list)) {
#line 415 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 415 "ast-to-xml.k"
		const activity_list c = this->activity_list_1;
#line 415 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 416 "ast-to-xml.k"
		inup(); 
#line  7882 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<flow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 416 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7888 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 416 "ast-to-xml.k"
		indown(); 
#line  7894 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</flow>\n"), kc_current_view); }
	    } else
	    {
#line 419 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 419 "ast-to-xml.k"
		const tLink_list b = this->tLink_list_1;
#line 419 "ast-to-xml.k"
		const activity_list c = this->activity_list_1;
#line 419 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 420 "ast-to-xml.k"
		inup(); 
#line  7908 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<flow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 420 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7914 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 420 "ast-to-xml.k"
		inup(); 
#line  7919 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<links>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 420 "ast-to-xml.k"
		indown(); 
#line  7924 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</links>\n"), kc_current_view); }
		kc::unparse(c, kc_printer, kc_current_view);
#line 420 "ast-to-xml.k"
		indown(); 
#line  7929 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</flow>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 134 "ast-to-petrinet.k"
		PFlow(this, kc_current_view_base); 
#line  7939 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 134 "ast-to-petrinet.k"
		PFlow(this, kc_current_view_base); 
#line  7948 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  7953 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tLink_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  7973 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tLink_list iterator_ = this; iterator_->tLink_list_1 != 0; iterator_ = iterator_->tLink_list_1)
		    iterator_->tLink_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tLink_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  7991 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  8003 "ast-system-unpk.cc"
void
impl_tLink_Link::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1298 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1300 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->linkName = myself->defineLink();

		globals::ASTE_linkIdMap[ myself->linkName ] = myid;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  8029 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 423 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 424 "ast-to-xml.k"
		in(); 
#line  8040 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<link id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 424 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8046 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  8052 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8065 "ast-system-unpk.cc"
void
impl_tScope_Scope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1791 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1791 "ast-postprocess.k"
		const tVariable_list b = this->tVariable_list_1;
#line 1791 "ast-postprocess.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 1791 "ast-postprocess.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 1791 "ast-postprocess.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 1791 "ast-postprocess.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 1791 "ast-postprocess.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 1791 "ast-postprocess.k"
		const activity i = this->activity_1;
#line 1791 "ast-postprocess.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 1791 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1793 "ast-postprocess.k"

		assert(_id != NULL);
		int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);
		a->parentId = myid;


		myself->parentScopeId = globals::PPcurrentScope;


		globals::PPcurrentScope = myid;

		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		assert(globals::ASTEmap[myself->parentScopeId] != NULL);
		myself->checkAttributes();

		for ( std::set<unsigned int>::iterator peerScope = globals::ASTEmap[myself->parentScopeId]->enclosedScopes.begin(); 
		    peerScope != globals::ASTEmap[myself->parentScopeId]->enclosedScopes.end(); 
		    peerScope++)
		{
		    globals::ASTEmap[*peerScope]->peerScopes.insert(myid);
		    globals::ASTEmap[myid]->peerScopes.insert(*peerScope);
		}

		globals::ASTEmap[myself->parentScopeId]->enclosedScopes.insert(myid);

		myself->hasEH = (string(f->op_name()) == "EventHandlers");



		assert(globals::ASTEmap[c->id] != NULL);
		assert(globals::ASTEmap[d->id] != NULL);
		assert(globals::ASTEmap[e->id] != NULL);
		assert(globals::ASTEmap[f->id] != NULL);
		assert(globals::ASTEmap[i->id] != NULL);
		globals::ASTEmap[c->id]->parentActivityId = myid;
		globals::ASTEmap[d->id]->parentActivityId = myid;
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[f->id]->parentActivityId = myid;
		globals::ASTEmap[i->id]->parentActivityId = myid;

		myself->enclosedFH = c->id;
		myself->enclosedCH = d->id;

		globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[d->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[f->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[i->id]->max_occurrences = myself->max_occurrences;


		if (myself->attributes["name"] != "")
		{

		    if (globals::ASTE_scopeNames[myself->attributes["name"]] != 0)
		    SAerror(92, myself->attributes["name"], myself->attributes["referenceLine"]);

		    globals::ASTE_scopeNames[myself->attributes["name"]] = myid;
		}


		if (myself->attributes["isolated"] == "yes" &&
		    globals::ASTEmap[myself->parentScopeId]->findIsolatedAncestor())
		SAerror(91, "", myself->attributes["referenceLine"]);

#line  8160 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(j, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
#line 1862 "ast-postprocess.k"

		set< unsigned int > innerIds = globals::ASTEmap[ i->id ]->enclosedActivities;
		innerIds.insert( i->id );
		set< unsigned int > faultIds = globals::ASTEmap[ c->id ]->enclosedActivities;
		faultIds.insert( c->id );
		set< unsigned int > compIds = globals::ASTEmap[ d->id ]->enclosedActivities;
		compIds.insert( d->id );

		enterConflictingActivities( innerIds, faultIds );
		enterConflictingActivities( faultIds, compIds );


		globals::ASTEmap[d->id]->enclosedScopes = myself->enclosedScopes;


		assert(globals::ASTEmap[i->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[i->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[c->id]->enclosedSourceLinks );
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[d->id]->enclosedSourceLinks );
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks );
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[f->id]->enclosedSourceLinks );


		globals::PPcurrentScope = myself->parentScopeId;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  8200 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 840 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 840 "ast-to-cfg.k"
		const tVariable_list b = this->tVariable_list_1;
#line 840 "ast-to-cfg.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 840 "ast-to-cfg.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 840 "ast-to-cfg.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 840 "ast-to-cfg.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 840 "ast-to-cfg.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 840 "ast-to-cfg.k"
		const activity i = this->activity_1;
#line 840 "ast-to-cfg.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 840 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 841 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Scope\n");
		CFGBlock * firstBlock = new CFGBlock(CFGScope, this->id, "Scope_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGScope, this->id, "Scope_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  8238 "ast-system-unpk.cc"
		kc::unparse(c, kc_printer, kc_current_view);
#line 852 "ast-to-cfg.k"

		CFGBlock * fhFirst = globals::cfgMap.find(toString(c->id))->second->firstBlock;
		CFGBlock * fhLast  = globals::cfgMap.find(toString(c->id))->second->lastBlock;

		connectBlocks(firstBlock, fhFirst);
		connectBlocks(fhLast, lastBlock);


#line  8249 "ast-system-unpk.cc"
		kc::unparse(d, kc_printer, kc_current_view);
#line 861 "ast-to-cfg.k"

		CFGBlock * chFirst = globals::cfgMap.find(toString(d->id))->second->firstBlock;
		CFGBlock * chLast  = globals::cfgMap.find(toString(d->id))->second->lastBlock;

		connectBlocks(firstBlock, chFirst);
		connectBlocks(chLast, lastBlock);


#line  8260 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 870 "ast-to-cfg.k"

		CFGBlock * thFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock * thLast  = globals::cfgMap.find(toString(e->id))->second->lastBlock;

		connectBlocks(firstBlock, thFirst);
		connectBlocks(thLast, lastBlock);


#line  8271 "ast-system-unpk.cc"
		kc::unparse(f, kc_printer, kc_current_view);
#line 879 "ast-to-cfg.k"

		CFGBlock * ehFirst = globals::cfgMap.find(toString(f->id))->second->firstBlock;
		CFGBlock * ehLast  = globals::cfgMap.find(toString(f->id))->second->lastBlock;

		connectBlocks(firstBlock, ehFirst);
		connectBlocks(ehLast, lastBlock);


#line  8282 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 888 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(i->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(i->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  8292 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 896 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Scope\n");

#line  8298 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 432 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 432 "ast-to-xml.k"
		const tVariable_list b = this->tVariable_list_1;
#line 432 "ast-to-xml.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 432 "ast-to-xml.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 432 "ast-to-xml.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 432 "ast-to-xml.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 432 "ast-to-xml.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 432 "ast-to-xml.k"
		const activity i = this->activity_1;
#line 432 "ast-to-xml.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 432 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 433 "ast-to-xml.k"
		inup(); 
#line  8327 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<scope id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 433 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8333 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 437 "ast-to-xml.k"
		if (b->length() == 0) 
#line  8338 "ast-system-unpk.cc"
		{
		}
#line 439 "ast-to-xml.k"
		else 
#line  8343 "ast-system-unpk.cc"
		{
#line 440 "ast-to-xml.k"
		    inup(); 
#line  8347 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<variables id=\""), kc_current_view); }
		    kc::unparse(_id, kc_printer, kc_current_view);
		    { kc_printer(kc_t("\">\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 440 "ast-to-xml.k"
		    indown(); 
#line  8354 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</variables>\n"), kc_current_view); }
		}
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
#line 444 "ast-to-xml.k"
		indown(); 
#line  8365 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</scope>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 167 "ast-to-petrinet.k"
		PScope(this, kc_current_view_base); 
#line  8375 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 167 "ast-to-petrinet.k"
		PScope(this, kc_current_view_base); 
#line  8384 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  8389 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8402 "ast-system-unpk.cc"
void
impl_standardElements_NoStandardElements::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  8408 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  8420 "ast-system-unpk.cc"
void
impl_standardElements_StandardElements::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1899 "ast-postprocess.k"
		const tTarget_list a = this->tTarget_list_1;
#line 1899 "ast-postprocess.k"
		const tSource_list b = this->tSource_list_1;
#line 1899 "ast-postprocess.k"
		const joinCondition _joinCondition = this->joinCondition_1;
#line 1901 "ast-postprocess.k"

		assert(globals::ASTEmap[this->parentId] != NULL);
		this->suppressJF = (globals::ASTEmap[this->parentId]->attributes["suppressJoinFailure"] == "yes");


		_joinCondition->parentId = this->parentId;

#line  8442 "ast-system-unpk.cc"
		kc::unparse(_joinCondition, kc_printer, kc_current_view);
#line 1909 "ast-postprocess.k"

		unsigned int linkCount = 0;
		{
#line 1911 "ast-postprocess.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  8451 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 1911 "ast-postprocess.k"
			    {
				{
#line 1912 "ast-postprocess.k"
#line 1911 "ast-postprocess.k"
				    const tTarget targetLink = kc_selvar_0_1;
#line 1912 "ast-postprocess.k"

				    assert(globals::ASTEmap[targetLink->id] != NULL);
				    globals::ASTEmap[targetLink->id]->controlFlow = globals::ASTEmap[this->parentId]->controlFlow;
				    globals::ASTEmap[targetLink->id]->parentActivityId = this->parentId;


				    globals::joinCondition_links[globals::ASTEmap[targetLink->id]->attributes["linkName"]] = ++linkCount; 

#line  8472 "ast-system-unpk.cc"
				}
			    }

#line  8476 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 1911 "ast-postprocess.k"

#line  8481 "ast-system-unpk.cc"
		    }
		}
#line 1920 "ast-postprocess.k"

		{
#line 1921 "ast-postprocess.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  8490 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 1921 "ast-postprocess.k"
			    {
				{
#line 1922 "ast-postprocess.k"
#line 1921 "ast-postprocess.k"
				    const tSource sourceLink = kc_selvar_0_1;
#line 1922 "ast-postprocess.k"

				    assert(globals::ASTEmap[sourceLink->id] != NULL);
				    globals::ASTEmap[sourceLink->id]->controlFlow = globals::ASTEmap[this->parentId]->controlFlow;
				    globals::ASTEmap[sourceLink->id]->parentActivityId = this->parentId;

#line  8508 "ast-system-unpk.cc"
				}
			    }

#line  8512 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 1921 "ast-postprocess.k"

#line  8517 "ast-system-unpk.cc"
		    }
		}
#line 1927 "ast-postprocess.k"











		unsigned int assignments = (unsigned int)pow(2.0, a->length());
		for (unsigned int assignment = 0; assignment < assignments; assignment++)
		{

		    for (unsigned int link = 0; link < linkCount; link++)
		    {
			if (((assignment >> link) % 2) == 0) 
			globals::joinCondition_linkStatus[link] = true;
			else
			globals::joinCondition_linkStatus[link] = false;
		    }


		    _joinCondition->unparse(pseudoPrinter, evaluation);


		    {
#line 1954 "ast-postprocess.k"
			joinCondition kc_selvar_0_1 = phylum_cast<joinCondition>(_joinCondition);
#line 1957 "ast-postprocess.k"
			if ((kc_selvar_0_1->prod_sel() == sel_userDefinedJoinCondition)) {
#line 1957 "ast-postprocess.k"
#line 1956 "ast-postprocess.k"
			    const joinCondition _joinCondition = kc_selvar_0_1;
#line 1956 "ast-postprocess.k"
			    const expression _exp = phylum_cast<const impl_joinCondition_userDefinedJoinCondition*>(kc_selvar_0_1)->expression_1;
#line 1957 "ast-postprocess.k"
			    globals::joinCondition_result[_joinCondition->parentId][assignment] = _exp->value; 
#line  8560 "ast-system-unpk.cc"
			    	} else
			{
#line 1958 "ast-postprocess.k"
#line 1958 "ast-postprocess.k"

#line  8566 "ast-system-unpk.cc"
			}
		    }
#line 1960 "ast-postprocess.k"
		}


		globals::joinCondition_links.clear();
		globals::joinCondition_linkStatus.clear();


#line  8577 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1968 "ast-postprocess.k"


		set<string> targetLinks;
		{
#line 1971 "ast-postprocess.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  8588 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 1971 "ast-postprocess.k"
			    {
				{
#line 1972 "ast-postprocess.k"
#line 1971 "ast-postprocess.k"
				    const tTarget targetLink = kc_selvar_0_1;
#line 1972 "ast-postprocess.k"


				    string linkName = globals::ASTEmap[targetLink->id]->linkName;
				    if (targetLinks.find(linkName) != targetLinks.end())
				    SAerror(69, "<" + globals::ASTEmap[this->parentId]->activityTypeName() + "> must not use <link> `" +
					linkName + "'", globals::ASTEmap[globals::ASTE_linkIdMap[linkName]]->attributes["referenceLine"]);
				    else
				    targetLinks.insert(linkName);

#line  8610 "ast-system-unpk.cc"
				}
			    }

#line  8614 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 1971 "ast-postprocess.k"

#line  8619 "ast-system-unpk.cc"
		    }
		}
#line 1981 "ast-postprocess.k"

		set<string> sourceLinks;
		{
#line 1983 "ast-postprocess.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  8629 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 1983 "ast-postprocess.k"
			    {
				{
#line 1984 "ast-postprocess.k"
#line 1983 "ast-postprocess.k"
				    const tSource sourceLink = kc_selvar_0_1;
#line 1984 "ast-postprocess.k"


				    string linkName = globals::ASTEmap[sourceLink->id]->linkName;
				    if (sourceLinks.find(linkName) != sourceLinks.end())
				    SAerror(68, "<" + globals::ASTEmap[this->parentId]->activityTypeName() + "> must not use <link> `" +
					linkName + "'", globals::ASTEmap[globals::ASTE_linkIdMap[linkName]]->attributes["referenceLine"]);
				    else
				    sourceLinks.insert(linkName);

#line  8651 "ast-system-unpk.cc"
				}
			    }

#line  8655 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 1983 "ast-postprocess.k"

#line  8660 "ast-system-unpk.cc"
		    }
		}
#line 1993 "ast-postprocess.k"


#line  8666 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 907 "ast-to-cfg.k"
		const standardElements This = this/**/;
#line 907 "ast-to-cfg.k"
		const tTarget_list a = this->tTarget_list_1;
#line 907 "ast-to-cfg.k"
		const tSource_list b = this->tSource_list_1;
#line 907 "ast-to-cfg.k"
		const joinCondition jc = this->joinCondition_1;
#line 909 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(This->parentId))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(This->parentId))->second->lastBlock;
		{
#line 912 "ast-to-cfg.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  8689 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 912 "ast-to-cfg.k"
			    {
				{
#line 913 "ast-to-cfg.k"
#line 912 "ast-to-cfg.k"
				    const tTarget link = kc_selvar_0_1;
#line 913 "ast-to-cfg.k"

				    trace(TRACE_DEBUG, "[CFG] Target\n");



				    CFGBlock * target = new CFGBlock(CFGTarget, link->id, "Target_" + globals::ASTEmap[link->id]->linkName);

				    targets["Source_" + globals::ASTEmap[link->id]->linkName] = target;









				    connectBlocks(target, innerFirst->firstBlock);
				    innerFirst->firstBlock = target;
				    target->lastBlock = innerLast->lastBlock;

#line  8723 "ast-system-unpk.cc"
				}
			    }

#line  8727 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 912 "ast-to-cfg.k"

#line  8732 "ast-system-unpk.cc"
		    }
		}
#line 934 "ast-to-cfg.k"

		{
#line 935 "ast-to-cfg.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  8741 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 935 "ast-to-cfg.k"
			    {
				{
#line 936 "ast-to-cfg.k"
#line 935 "ast-to-cfg.k"
				    const tSource link = kc_selvar_0_1;
#line 936 "ast-to-cfg.k"

				    trace(TRACE_DEBUG, "[CFG] Source\n");



				    CFGBlock * source = new CFGBlock(CFGSource, link->id, "Source_" + globals::ASTEmap[link->id]->linkName);

				    sources["Target_" + globals::ASTEmap[link->id]->linkName] = source;













				    connectBlocks(innerLast->lastBlock, source);
				    innerLast->lastBlock = innerFirst->lastBlock = source;

				    innerFirst->firstBlock->lastBlock = source;
				    trace(TRACE_DEBUG, "[CFG] ~Source\n");


#line  8782 "ast-system-unpk.cc"
				}
			    }

#line  8786 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 935 "ast-to-cfg.k"

#line  8791 "ast-system-unpk.cc"
		    }
		}
#line 964 "ast-to-cfg.k"



#line  8798 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 452 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 453 "ast-to-xml.k"
		const tSource_list a = this->tSource_list_1;
#line 453 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 453 "ast-to-xml.k"
		inup(); 
#line  8815 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sources>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 453 "ast-to-xml.k"
		indown(); 
#line  8820 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sources>\n"), kc_current_view); }
	    } else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 454 "ast-to-xml.k"
		const tTarget_list a = this->tTarget_list_1;
#line 454 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 454 "ast-to-xml.k"
		inup(); 
#line  8830 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<targets>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 454 "ast-to-xml.k"
		indown(); 
#line  8835 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</targets>\n"), kc_current_view); }
	    } else
	    {
#line 455 "ast-to-xml.k"
		const tTarget_list a = this->tTarget_list_1;
#line 455 "ast-to-xml.k"
		const tSource_list b = this->tSource_list_1;
#line 455 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 455 "ast-to-xml.k"
		inup(); 
#line  8847 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<targets>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 455 "ast-to-xml.k"
		indown(); 
#line  8852 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</targets>\n"), kc_current_view); }
#line 455 "ast-to-xml.k"
		inup(); 
#line  8856 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sources>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 455 "ast-to-xml.k"
		indown(); 
#line  8861 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sources>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 206 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 207 "ast-to-petrinet.k"
		P_LinkWrapper0(this, kc_current_view_base); 
#line  8873 "ast-system-unpk.cc"
			} else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 210 "ast-to-petrinet.k"
		const tSource_list a = this->tSource_list_1;
#line 210 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 211 "ast-to-petrinet.k"
		P_LinkWrapper1(this, kc_current_view_base); 
#line  8882 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 214, this))) {
#line 214 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 214 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 214 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 215 "ast-to-petrinet.k"
		P_LinkWrapper2(this, kc_current_view_base); 
#line  8893 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 218, this))) {
#line 218 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 218 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 218 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 219 "ast-to-petrinet.k"
		P_LinkWrapper3(this, kc_current_view_base); 
#line  8904 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 222, this))) {
#line 222 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 222 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 222 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 222 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 223 "ast-to-petrinet.k"
		P_LinkWrapper4(this, kc_current_view_base); 
#line  8917 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 226, this))) {
#line 226 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 226 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 226 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 226 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 227 "ast-to-petrinet.k"
		P_LinkWrapper5(this, kc_current_view_base); 
#line  8930 "ast-system-unpk.cc"
			} else
		    goto kc_unparsing_default;
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 206 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 207 "ast-to-petrinet.k"
		P_LinkWrapper0(this, kc_current_view_base); 
#line  8942 "ast-system-unpk.cc"
			} else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 210 "ast-to-petrinet.k"
		const tSource_list a = this->tSource_list_1;
#line 210 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 211 "ast-to-petrinet.k"
		P_LinkWrapper1(this, kc_current_view_base); 
#line  8951 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 214, this))) {
#line 214 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 214 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 214 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 215 "ast-to-petrinet.k"
		P_LinkWrapper2(this, kc_current_view_base); 
#line  8962 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 218, this))) {
#line 218 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 218 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 218 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 219 "ast-to-petrinet.k"
		P_LinkWrapper3(this, kc_current_view_base); 
#line  8973 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 222, this))) {
#line 222 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 222 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 222 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 222 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 223 "ast-to-petrinet.k"
		P_LinkWrapper4(this, kc_current_view_base); 
#line  8986 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 226, this))) {
#line 226 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 226 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 226 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 226 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 227 "ast-to-petrinet.k"
		P_LinkWrapper5(this, kc_current_view_base); 
#line  8999 "ast-system-unpk.cc"
			} else
		    goto kc_unparsing_default;
	    break;
	}

#line  9005 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tTarget_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  9026 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tTarget_list iterator_ = this; iterator_->tTarget_list_1 != 0; iterator_ = iterator_->tTarget_list_1)
		    iterator_->tTarget_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tTarget_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  9045 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  9058 "ast-system-unpk.cc"
void
impl_tTarget_Target::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1998 "ast-postprocess.k"
		const integer a = this->integer_1;
#line 2000 "ast-postprocess.k"

		ASTE *myself = globals::ASTEmap[this->id];
		assert(myself != NULL);

		myself->checkAttributes();
		myself->linkName = myself->checkLink();



		unsigned int linkId = globals::ASTE_linkIdMap[ myself->linkName ];
		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		globals::ASTEmap[myself->parentActivityId]->targetLinks.insert(linkId);


		assert(globals::ASTEmap[linkId] != NULL);
		if (globals::ASTEmap[linkId]->targetActivity != 0) 
		{
		    SAerror(66, myself->attributes["linkName"], myself->attributes["referenceLine"]);
		}
		else
		{
		    globals::ASTEmap[linkId]->targetActivity = myself->parentActivityId;
		}

#line  9093 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 457 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 458 "ast-to-xml.k"
		in(); 
#line  9104 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<target"), kc_current_view); }
#line 458 "ast-to-xml.k"
		listAttributes( a ); 
#line  9108 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  9114 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tSource_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  9134 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tSource_list iterator_ = this; iterator_->tSource_list_1 != 0; iterator_ = iterator_->tSource_list_1)
		    iterator_->tSource_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tSource_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  9152 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  9164 "ast-system-unpk.cc"
void
impl_tSource_Source::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2027 "ast-postprocess.k"
		const integer a = this->integer_1;
#line 2029 "ast-postprocess.k"

		ASTE *myself = globals::ASTEmap[this->id];
		assert(myself != NULL);

		myself->checkAttributes();
		myself->linkName = myself->checkLink();




		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		unsigned int linkId = globals::ASTE_linkIdMap[ myself->linkName ];
		globals::ASTEmap[myself->parentActivityId]->enclosedSourceLinks.insert(linkId);
		globals::ASTEmap[myself->parentActivityId]->sourceLinks.insert(linkId);


		assert(globals::ASTEmap[linkId] != NULL);
		if (globals::ASTEmap[linkId]->sourceActivity != 0)
		{
		    SAerror(66, myself->attributes["linkName"], myself->attributes["referenceLine"]);
		}
		else
		{
		    globals::ASTEmap[linkId]->sourceActivity = myself->parentActivityId;
		}

#line  9201 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 461 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 462 "ast-to-xml.k"
		in(); 
#line  9212 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<source"), kc_current_view); }
#line 462 "ast-to-xml.k"
		listAttributes( a ); 
#line  9216 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  9222 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  9235 "ast-system-unpk.cc"
void
impl_joinCondition_userDefinedJoinCondition::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2058 "ast-postprocess.k"
		const expression _exp = this->expression_1;
#line 2060 "ast-postprocess.k"
		_exp->parentId = this->parentId; 
#line  9247 "ast-system-unpk.cc"
		kc::unparse(_exp, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  9253 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  9266 "ast-system-unpk.cc"
void
impl_joinCondition_standardJoinCondition::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  9272 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  9284 "ast-system-unpk.cc"
void
impl_expression_Disjunction::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2120 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2120 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
#line 2124 "ast-postprocess.k"
		this->value = (_exp1->value || _exp2->value); 
#line  9300 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2072 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2072 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
#line 2074 "ast-postprocess.k"
		_exp1->parentId = _exp2->parentId = this->parentId; 
#line  9313 "ast-system-unpk.cc"
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  9320 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  9333 "ast-system-unpk.cc"
void
impl_expression_Conjunction::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2112 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2112 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
#line 2116 "ast-postprocess.k"
		this->value = (_exp1->value && _exp2->value); 
#line  9349 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2065 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2065 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
#line 2067 "ast-postprocess.k"
		_exp1->parentId = _exp2->parentId = this->parentId; 
#line  9362 "ast-system-unpk.cc"
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  9369 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  9382 "ast-system-unpk.cc"
void
impl_expression_Term::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2088 "ast-postprocess.k"
		const casestring _linkname = this->casestring_1;
#line 2090 "ast-postprocess.k"


		string linkname_string = string(_linkname->name);
		if (linkname_string[0] == '$')
		linkname_string = linkname_string.substr(1, linkname_string.length() -1);



		if (globals::joinCondition_links[linkname_string] == 0)
		{
		    assert(globals::ASTEmap[this->parentId] != NULL);
		    SAerror(73, linkname_string, globals::ASTEmap[this->parentId]->attributes["referenceLine"]);
		}
		else
		{

		    this->value = globals::joinCondition_linkStatus[globals::joinCondition_links[linkname_string] -1];
		}

#line  9412 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2079 "ast-postprocess.k"
		const casestring _linkname = this->casestring_1;
	    }
	    break;
	}

#line  9425 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


} // namespace kc
