# Makefile for the CLISP binaries
# DO NOT EDIT! GENERATED AUTOMATICALLY!
# This file was created on host honolulu as the output of the command:
# ./makemake acorn ansi

# -------------- Start of configurable section --------------------

# Directories used by "make install":
prefix = 
exec_prefix = $(prefix)
bindir = $(exec_prefix).bin
mandir = $(exec_prefix).man
htmldir = $(exec_prefix).html.share
dvidir = $(exec_prefix).dvi.share
docdir = $(exec_prefix).doc
lispdocdir = $(docdir).clisp
libdir = $(exec_prefix).lib
lisplibdir = $(libdir).clisp
# The value of following variable is prepended to all the paths for
# installation. This is useful when preparing a binary distribution.
DESTDIR =

# List of add-on modules:
# queens               the queens function as a separate module
# If you change this after doing "make", you have to "rm -r full; make".
MODULES =  

# Programs used by "make":
CC = cc
CFLAGS =  -D__arm -D__riscos -wanp -throwback -JUnix: -IUnix: -DUNICODE
CPP = cc -E
CLFLAGS =  -LUnix:o.Unixlib
LIBS = 
X_LIBS = 

MAKE = make
RM = remove
CP = cp ~A~CNF
LN_S = cp ~A~CNF
MV = cp ~A~CDF
CAT = cat
TOUCH = touch
GREP = egrep
SED = sed
AR = ar
RANLIB = ranlib

# Programs used by "make install":
INSTALL = cp ~A~CNF
INSTALL_PROGRAM = $(INSTALL)
INSTALL_DATA = $(INSTALL)

# Programs used by "make distrib":

# formatter for manual page
ROFF_MAN = groff -Tascii -mandoc # try "groff -Tascii -mandoc" or "nroff -man"
ROFF_DVI = groff -Tdvi -mandoc # try "groff -Tdvi -mandoc"

# -------------- End of configurable section --------------------

#
#                       Requirements for add-on modules
#                       -------------------------------
#
# The general layout of add-on modules is described in ^.doc/module.txt.
# The requirements made there (i.e. the existence of a "link.sh" file
# which defines certain variables) make sure that such an add-on module
# can be distributed with CLISP.
#
# If you want an add-on module to be _built_ automatically with CLISP,
# the following additional requirements have to be obeyed.
#
#   1. The module must be located in a subdirectory of clisp's source
#      directory.
#      Examples: clisp/src/ wildcard/
#                clisp/src/ bindings/linuxlibc5/
#
#   2. If the module contains a file called "configure", it is assumed
#      to be a GNU autoconf generated configuration file, and is called
#      with a "--cache-file=..." argument. It should generate platform
#      dependent header files, Makefiles and the like.
#
#   3. The module should contain a Makefile (maybe generated by requirement 2),
#      which defines the following targets:
#
#        clisp-module
#
#           This target builds the file mentioned by the link.sh file.
#           The following makefile variables can be used:
#             CC                 the C compiler used to compile the CLISP source
#             CFLAGS             the C compiler flags
#             INCLUDES           a directory containing CLISP header files
#             LISPBIBL_INCLUDES  if you #include "lispbibl.c", put this onto
#                                the dependency line
#             CLFLAGS            the C compiler flags when linking an executable
#             LIBS               the libraries used when linking an executable
#             RANLIB             the name of the "ranlib" command
#             CLISP              a command which calls the already built
#                                "base" clisp.
#           Typically, you will have rules like this in your Makefile:
#               o.foo : c.foo
#                       $(CC) $(CFLAGS) -I$(INCLUDES) -c c.foo
#               fas.foo : lisp.foo
#                       $(CLISP) -c foo.lisp
#
#        clisp-module-distrib
#
#           This target copies the module into a temporary distribution
#           directory, on the same disk.
#           The following makefile variables can be used:
#             distribdir       the name of temporary distribution directory
#             LN               command to make hard links (works also for
#                              symbolic links)
#           Typically, this target will look like this:
#
#               DISTRIBFILES = <the NEW_FILES mentioned in link.sh> <doc files>
#               clisp-module-distrib : clisp-module force
#                       $(LN) $(DISTRIBFILES) $(distribdir)
#
# If these requirements are obeyed, this Makefile will automatically build
# the add-on module and make it part of the "full" distribution -- all you
# need to do is to add its name to the MODULES definition line above.
#

COMMENT5 = /@.comment5
ANSIDECL = /@.ansidecl
VARBRACE = /@.varbrace
TXT2C = /@.txt2c -I^.

DFILES = \
d.spvw \
d.spvwtabf \
d.spvwtabs \
d.spvwtabo \
d.eval \
d.control \
d.encoding \
d.pathname \
d.stream \
d.io \
d.array \
d.hashtabl \
d.list \
d.package \
d.record \
d.sequence \
d.charstrg \
d.debug \
d.error \
d.misc \
d.time \
d.predtype \
d.symbol \
d.lisparit \
d.unixaux \
d.acornaux \
d.acornsig \
d.lispbibl \
d.fsubr \
d.subr \
d.pseudofun \
d.constsym \
d.constobj \
d.acorn \
d.constpack \
d.avl \
d.sort \
d.subrkw \
d.bytecode \
d.spvw_module \
d.spvw_debug \
d.spvw_alloca \
d.spvw_mmap \
d.spvw_multimap \
d.spvw_singlemap \
d.spvw_page \
d.spvw_heap \
d.spvw_global \
d.spvw_gcstat \
d.spvw_space \
d.spvw_mark \
d.spvw_objsize \
d.spvw_update \
d.spvw_fault \
d.spvw_sigsegv \
d.spvw_sigcld \
d.spvw_sigpipe \
d.spvw_sigint \
d.spvw_sigwinch \
d.spvw_garcol \
d.spvw_genera1 \
d.spvw_genera2 \
d.spvw_genera3 \
d.spvw_allocate \
d.spvw_typealloc \
d.spvw_circ \
d.spvw_walk \
d.spvw_ctype \
d.spvw_language \
d.spvw_memfile \
d.errunix \
d.aridecl \
d.arilev0 \
d.arilev1 \
d.intelem \
d.intlog \
d.intplus \
d.intcomp \
d.intbyte \
d.intmal \
d.intdiv \
d.intgcd \
d.int2adic \
d.intsqrt \
d.intprint \
d.intread \
d.rational \
d.sfloat \
d.ffloat \
d.dfloat \
d.lfloat \
d.flo_konv \
d.flo_rest \
d.realelem \
d.realrand \
d.realtran \
d.compelem \
d.comptran \
d.arilev1c \
d.arilev1e \
d.arilev1i \
d.genclisph \
d.modules \
d.noreadline \
d.ariarm

CFILES = \
c.spvw \
c.spvwtabf \
c.spvwtabs \
c.spvwtabo \
c.eval \
c.control \
c.encoding \
c.pathname \
c.stream \
c.io \
c.array \
c.hashtabl \
c.list \
c.package \
c.record \
c.sequence \
c.charstrg \
c.debug \
c.error \
c.misc \
c.time \
c.predtype \
c.symbol \
c.lisparit \
c.unixaux \
c.acornaux \
c.acornsig \
c.lispbibl \
c.fsubr \
c.subr \
c.pseudofun \
c.constsym \
c.constobj \
c.acorn \
c.constpack \
c.avl \
c.sort \
c.subrkw \
c.bytecode \
c.spvw_module \
c.spvw_debug \
c.spvw_alloca \
c.spvw_mmap \
c.spvw_multimap \
c.spvw_singlemap \
c.spvw_page \
c.spvw_heap \
c.spvw_global \
c.spvw_gcstat \
c.spvw_space \
c.spvw_mark \
c.spvw_objsize \
c.spvw_update \
c.spvw_fault \
c.spvw_sigsegv \
c.spvw_sigcld \
c.spvw_sigpipe \
c.spvw_sigint \
c.spvw_sigwinch \
c.spvw_garcol \
c.spvw_genera1 \
c.spvw_genera2 \
c.spvw_genera3 \
c.spvw_allocate \
c.spvw_typealloc \
c.spvw_circ \
c.spvw_walk \
c.spvw_ctype \
c.spvw_language \
c.spvw_memfile \
c.errunix \
c.aridecl \
c.arilev0 \
c.arilev1 \
c.intelem \
c.intlog \
c.intplus \
c.intcomp \
c.intbyte \
c.intmal \
c.intdiv \
c.intgcd \
c.int2adic \
c.intsqrt \
c.intprint \
c.intread \
c.rational \
c.sfloat \
c.ffloat \
c.dfloat \
c.lfloat \
c.flo_konv \
c.flo_rest \
c.realelem \
c.realrand \
c.realtran \
c.compelem \
c.comptran \
c.arilev1c \
c.arilev1e \
c.arilev1i \
c.genclisph \
c.modules \
c.noreadline \
c.ariarm

OBJECTS = \
o.spvw \
o.spvwtabf \
o.spvwtabs \
o.spvwtabo \
o.eval \
o.control \
o.encoding \
o.pathname \
o.stream \
o.io \
o.array \
o.hashtabl \
o.list \
o.package \
o.record \
o.sequence \
o.charstrg \
o.debug \
o.error \
o.misc \
o.time \
o.predtype \
o.symbol \
o.lisparit \
o.unixaux \
o.acornaux \
o.acornsig \
o.ariarm

LISPFILES = \
lisp.init \
lisp.defseq \
lisp.backquote \
lisp.defmacro \
lisp.macros1 \
lisp.macros2 \
lisp.defs1 \
lisp.timezone \
lisp.places \
lisp.floatprint \
lisp.type \
lisp.defstruct \
lisp.format \
lisp.savemem \
lisp.trace \
lisp.compiler \
lisp.disassem \
lisp.defs2 \
lisp.loop \
lisp.clos \
lisp.condition \
lisp.gstream \
lisp.xcharin \
lisp.keyboard \
lisp.screen \
lisp.beossock \
lisp.runprog \
lisp.query \
lisp.reploop \
lisp.dribble \
lisp.complete \
lisp.describe \
lisp.room \
lisp.edit \
lisp.macros3 \
lisp.posix \
lisp.foreign1 \
lisp.defs3 \
lisp.clhs \
lisp.inspect \
lisp.german \
lisp.french \
lisp.spanish \
lisp.dutch \
lisp.config

FASFILES = \
fas.init \
fas.defseq \
fas.backquote \
fas.defmacro \
fas.macros1 \
fas.macros2 \
fas.defs1 \
fas.timezone \
fas.places \
fas.floatprint \
fas.type \
fas.defstruct \
fas.format \
fas.savemem \
fas.trace \
fas.compiler \
fas.disassem \
fas.defs2 \
fas.loop \
fas.clos \
fas.condition \
fas.gstream \
fas.xcharin \
fas.keyboard \
fas.screen \
fas.beossock \
fas.runprog \
fas.query \
fas.reploop \
fas.dribble \
fas.complete \
fas.describe \
fas.room \
fas.edit \
fas.macros3 \
fas.posix \
fas.foreign1 \
fas.defs3 \
fas.clhs \
fas.inspect \
fas.german \
fas.french \
fas.spanish \
fas.dutch \
fas.config

TXTFILES = \
txt.LISP-tutorial \
txt.CLOS-guide \
txt.editors

TESTLISPFILES = \
stage.lisp.init \
stage.lisp.defseq \
stage.lisp.backquote \
stage.lisp.defmacro \
stage.lisp.macros1 \
stage.lisp.macros2 \
stage.lisp.defs1 \
stage.lisp.timezone \
stage.lisp.places \
stage.lisp.floatprint \
stage.lisp.type \
stage.lisp.defstruct \
stage.lisp.format \
stage.lisp.savemem \
stage.lisp.trace \
stage.lisp.compiler \
stage.lisp.disassem \
stage.lisp.defs2 \
stage.lisp.loop \
stage.lisp.clos \
stage.lisp.condition \
stage.lisp.gstream \
stage.lisp.xcharin \
stage.lisp.keyboard \
stage.lisp.screen \
stage.lisp.beossock \
stage.lisp.runprog \
stage.lisp.query \
stage.lisp.reploop \
stage.lisp.dribble \
stage.lisp.complete \
stage.lisp.describe \
stage.lisp.room \
stage.lisp.edit \
stage.lisp.macros3 \
stage.lisp.posix \
stage.lisp.foreign1 \
stage.lisp.defs3 \
stage.lisp.clhs \
stage.lisp.inspect \
stage.lisp.german \
stage.lisp.french \
stage.lisp.spanish \
stage.lisp.dutch \
stage.lisp.config

TESTFASFILES = \
stage.fas.init \
stage.fas.defseq \
stage.fas.backquote \
stage.fas.defmacro \
stage.fas.macros1 \
stage.fas.macros2 \
stage.fas.defs1 \
stage.fas.timezone \
stage.fas.places \
stage.fas.floatprint \
stage.fas.type \
stage.fas.defstruct \
stage.fas.format \
stage.fas.savemem \
stage.fas.trace \
stage.fas.compiler \
stage.fas.disassem \
stage.fas.defs2 \
stage.fas.loop \
stage.fas.clos \
stage.fas.condition \
stage.fas.gstream \
stage.fas.xcharin \
stage.fas.keyboard \
stage.fas.screen \
stage.fas.beossock \
stage.fas.runprog \
stage.fas.query \
stage.fas.reploop \
stage.fas.dribble \
stage.fas.complete \
stage.fas.describe \
stage.fas.room \
stage.fas.edit \
stage.fas.macros3 \
stage.fas.posix \
stage.fas.foreign1 \
stage.fas.defs3 \
stage.fas.clhs \
stage.fas.inspect \
stage.fas.german \
stage.fas.french \
stage.fas.spanish \
stage.fas.dutch \
stage.fas.config


# The Acorn Make Utility has problems with halfcomp.mem.
# If you have this problem, either swap mem.halfcomp and mem.lispinit in the next line, or use GNU make.
all : init allc allo lisp mem.interpre mem.halfcomp mem.lispinit manual
	$(TOUCH) all


init : comment5 ansidecl varbrace txt2c ccmp2c modprep $(DFILES) h.modules
	$(TOUCH) init

comment5 : ^.utils.c.comment5
	$(CC) $(CFLAGS) $(CLFLAGS) ^.utils.c.comment5 -o comment5

ansidecl : ^.utils.d.ansidecl comment5
	$(LN_S) ^.utils.d.ansidecl d.ansidecl
	$(COMMENT5) ansidecl.d ansidecl.c
	$(RM) d.ansidecl
	$(CC) $(CFLAGS) $(CLFLAGS) c.ansidecl -o ansidecl
	$(RM) c.ansidecl

varbrace : ^.utils.d.varbrace comment5 ansidecl
	$(COMMENT5) ^.utils.d.varbrace > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > varbrace.c
	$(RM) TMPPIPE1
	$(CC) $(CFLAGS) $(CLFLAGS) c.varbrace -o varbrace
	$(RM) c.varbrace

txt2c : ^.utils.c.txt2c ansidecl
	$(ANSIDECL) < ^.utils.c.txt2c > txt2c.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.txt2c -o txt2c
	$(RM) c.txt2c

ccmp2c : ^.utils.d.ccmp2c comment5 ansidecl
	$(COMMENT5) ^.utils.d.ccmp2c > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > ccmp2c.c
	$(RM) TMPPIPE1
	$(CC) $(CFLAGS) $(CLFLAGS) -I. c.ccmp2c -o ccmp2c
	$(RM) c.ccmp2c

modprep : ^.utils.d.modprep comment5 ansidecl
	$(COMMENT5) ^.utils.d.modprep > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > modprep.c
	$(RM) TMPPIPE1
	$(CC) $(CFLAGS) $(CLFLAGS) c.modprep -o modprep
	$(RM) c.modprep


h.stdbool : stdbool.in.h
	-$(LN_S) stdbool.in.h h.stdbool

allc : init $(CFILES)
	$(TOUCH) allc

c.spvw : d.spvw comment5 ansidecl varbrace
	$(COMMENT5) spvw.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw.c
	$(RM) TMPPIPE2

c.spvwtabf : d.spvwtabf comment5 ansidecl varbrace
	$(COMMENT5) spvwtabf.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvwtabf.c
	$(RM) TMPPIPE2

c.spvwtabs : d.spvwtabs comment5 ansidecl varbrace
	$(COMMENT5) spvwtabs.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvwtabs.c
	$(RM) TMPPIPE2

c.spvwtabo : d.spvwtabo comment5 ansidecl varbrace
	$(COMMENT5) spvwtabo.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvwtabo.c
	$(RM) TMPPIPE2

c.eval : d.eval comment5 ansidecl varbrace
	$(COMMENT5) eval.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > eval.c
	$(RM) TMPPIPE2

c.control : d.control comment5 ansidecl varbrace
	$(COMMENT5) control.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > control.c
	$(RM) TMPPIPE2

c.encoding : d.encoding comment5 ansidecl varbrace
	$(COMMENT5) encoding.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > encoding.c
	$(RM) TMPPIPE2

c.pathname : d.pathname comment5 ansidecl varbrace
	$(COMMENT5) pathname.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > pathname.c
	$(RM) TMPPIPE2

c.stream : d.stream comment5 ansidecl varbrace
	$(COMMENT5) stream.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > stream.c
	$(RM) TMPPIPE2

c.io : d.io comment5 ansidecl varbrace
	$(COMMENT5) io.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > io.c
	$(RM) TMPPIPE2

c.array : d.array comment5 ansidecl varbrace
	$(COMMENT5) array.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > array.c
	$(RM) TMPPIPE2

c.hashtabl : d.hashtabl comment5 ansidecl varbrace
	$(COMMENT5) hashtabl.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > hashtabl.c
	$(RM) TMPPIPE2

c.list : d.list comment5 ansidecl varbrace
	$(COMMENT5) list.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > list.c
	$(RM) TMPPIPE2

c.package : d.package comment5 ansidecl varbrace
	$(COMMENT5) package.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > package.c
	$(RM) TMPPIPE2

c.record : d.record comment5 ansidecl varbrace
	$(COMMENT5) record.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > record.c
	$(RM) TMPPIPE2

c.sequence : d.sequence comment5 ansidecl varbrace
	$(COMMENT5) sequence.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > sequence.c
	$(RM) TMPPIPE2

c.charstrg : d.charstrg comment5 ansidecl varbrace
	$(COMMENT5) charstrg.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > charstrg.c
	$(RM) TMPPIPE2

c.debug : d.debug comment5 ansidecl varbrace
	$(COMMENT5) debug.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > debug.c
	$(RM) TMPPIPE2

c.error : d.error comment5 ansidecl varbrace
	$(COMMENT5) error.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > error.c
	$(RM) TMPPIPE2

c.misc : d.misc comment5 ansidecl varbrace
	$(COMMENT5) misc.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > misc.c
	$(RM) TMPPIPE2

c.time : d.time comment5 ansidecl varbrace
	$(COMMENT5) time.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > time.c
	$(RM) TMPPIPE2

c.predtype : d.predtype comment5 ansidecl varbrace
	$(COMMENT5) predtype.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > predtype.c
	$(RM) TMPPIPE2

c.symbol : d.symbol comment5 ansidecl varbrace
	$(COMMENT5) symbol.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > symbol.c
	$(RM) TMPPIPE2

c.lisparit : d.lisparit comment5 ansidecl varbrace
	$(COMMENT5) lisparit.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > lisparit.c
	$(RM) TMPPIPE2

c.unixaux : d.unixaux comment5 ansidecl varbrace
	$(COMMENT5) unixaux.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > unixaux.c
	$(RM) TMPPIPE2

c.acornaux : d.acornaux comment5 ansidecl varbrace
	$(COMMENT5) acornaux.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > acornaux.c
	$(RM) TMPPIPE2

c.acornsig : d.acornsig comment5 ansidecl varbrace
	$(COMMENT5) acornsig.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > acornsig.c
	$(RM) TMPPIPE2

c.lispbibl : d.lispbibl comment5 ansidecl varbrace
	$(COMMENT5) lispbibl.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > lispbibl.c
	$(RM) TMPPIPE2

c.fsubr : d.fsubr comment5 ansidecl varbrace
	$(COMMENT5) fsubr.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > fsubr.c
	$(RM) TMPPIPE2

c.subr : d.subr comment5 ansidecl varbrace
	$(COMMENT5) subr.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > subr.c
	$(RM) TMPPIPE2

c.pseudofun : d.pseudofun comment5 ansidecl varbrace
	$(COMMENT5) pseudofun.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > pseudofun.c
	$(RM) TMPPIPE2

c.constsym : d.constsym comment5 ansidecl varbrace
	$(COMMENT5) constsym.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > constsym.c
	$(RM) TMPPIPE2

c.constobj : d.constobj comment5 ansidecl varbrace
	$(COMMENT5) constobj.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > constobj.c
	$(RM) TMPPIPE2

c.acorn : d.acorn comment5 ansidecl varbrace
	$(COMMENT5) acorn.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > acorn.c
	$(RM) TMPPIPE2

c.constpack : d.constpack comment5 ansidecl varbrace
	$(COMMENT5) constpack.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > constpack.c
	$(RM) TMPPIPE2

c.avl : d.avl comment5 ansidecl varbrace
	$(COMMENT5) avl.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > avl.c
	$(RM) TMPPIPE2

c.sort : d.sort comment5 ansidecl varbrace
	$(COMMENT5) sort.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > sort.c
	$(RM) TMPPIPE2

c.subrkw : d.subrkw comment5 ansidecl varbrace
	$(COMMENT5) subrkw.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > subrkw.c
	$(RM) TMPPIPE2

c.bytecode : d.bytecode comment5 ansidecl varbrace
	$(COMMENT5) bytecode.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > bytecode.c
	$(RM) TMPPIPE2

c.spvw_module : d.spvw_module comment5 ansidecl varbrace
	$(COMMENT5) spvw_module.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_module.c
	$(RM) TMPPIPE2

c.spvw_debug : d.spvw_debug comment5 ansidecl varbrace
	$(COMMENT5) spvw_debug.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_debug.c
	$(RM) TMPPIPE2

c.spvw_alloca : d.spvw_alloca comment5 ansidecl varbrace
	$(COMMENT5) spvw_alloca.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_alloca.c
	$(RM) TMPPIPE2

c.spvw_mmap : d.spvw_mmap comment5 ansidecl varbrace
	$(COMMENT5) spvw_mmap.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_mmap.c
	$(RM) TMPPIPE2

c.spvw_multimap : d.spvw_multimap comment5 ansidecl varbrace
	$(COMMENT5) spvw_multimap.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_multimap.c
	$(RM) TMPPIPE2

c.spvw_singlemap : d.spvw_singlemap comment5 ansidecl varbrace
	$(COMMENT5) spvw_singlemap.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_singlemap.c
	$(RM) TMPPIPE2

c.spvw_page : d.spvw_page comment5 ansidecl varbrace
	$(COMMENT5) spvw_page.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_page.c
	$(RM) TMPPIPE2

c.spvw_heap : d.spvw_heap comment5 ansidecl varbrace
	$(COMMENT5) spvw_heap.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_heap.c
	$(RM) TMPPIPE2

c.spvw_global : d.spvw_global comment5 ansidecl varbrace
	$(COMMENT5) spvw_global.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_global.c
	$(RM) TMPPIPE2

c.spvw_gcstat : d.spvw_gcstat comment5 ansidecl varbrace
	$(COMMENT5) spvw_gcstat.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_gcstat.c
	$(RM) TMPPIPE2

c.spvw_space : d.spvw_space comment5 ansidecl varbrace
	$(COMMENT5) spvw_space.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_space.c
	$(RM) TMPPIPE2

c.spvw_mark : d.spvw_mark comment5 ansidecl varbrace
	$(COMMENT5) spvw_mark.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_mark.c
	$(RM) TMPPIPE2

c.spvw_objsize : d.spvw_objsize comment5 ansidecl varbrace
	$(COMMENT5) spvw_objsize.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_objsize.c
	$(RM) TMPPIPE2

c.spvw_update : d.spvw_update comment5 ansidecl varbrace
	$(COMMENT5) spvw_update.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_update.c
	$(RM) TMPPIPE2

c.spvw_fault : d.spvw_fault comment5 ansidecl varbrace
	$(COMMENT5) spvw_fault.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_fault.c
	$(RM) TMPPIPE2

c.spvw_sigsegv : d.spvw_sigsegv comment5 ansidecl varbrace
	$(COMMENT5) spvw_sigsegv.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_sigsegv.c
	$(RM) TMPPIPE2

c.spvw_sigcld : d.spvw_sigcld comment5 ansidecl varbrace
	$(COMMENT5) spvw_sigcld.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_sigcld.c
	$(RM) TMPPIPE2

c.spvw_sigpipe : d.spvw_sigpipe comment5 ansidecl varbrace
	$(COMMENT5) spvw_sigpipe.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_sigpipe.c
	$(RM) TMPPIPE2

c.spvw_sigint : d.spvw_sigint comment5 ansidecl varbrace
	$(COMMENT5) spvw_sigint.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_sigint.c
	$(RM) TMPPIPE2

c.spvw_sigwinch : d.spvw_sigwinch comment5 ansidecl varbrace
	$(COMMENT5) spvw_sigwinch.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_sigwinch.c
	$(RM) TMPPIPE2

c.spvw_garcol : d.spvw_garcol comment5 ansidecl varbrace
	$(COMMENT5) spvw_garcol.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_garcol.c
	$(RM) TMPPIPE2

c.spvw_genera1 : d.spvw_genera1 comment5 ansidecl varbrace
	$(COMMENT5) spvw_genera1.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_genera1.c
	$(RM) TMPPIPE2

c.spvw_genera2 : d.spvw_genera2 comment5 ansidecl varbrace
	$(COMMENT5) spvw_genera2.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_genera2.c
	$(RM) TMPPIPE2

c.spvw_genera3 : d.spvw_genera3 comment5 ansidecl varbrace
	$(COMMENT5) spvw_genera3.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_genera3.c
	$(RM) TMPPIPE2

c.spvw_allocate : d.spvw_allocate comment5 ansidecl varbrace
	$(COMMENT5) spvw_allocate.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_allocate.c
	$(RM) TMPPIPE2

c.spvw_typealloc : d.spvw_typealloc comment5 ansidecl varbrace
	$(COMMENT5) spvw_typealloc.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_typealloc.c
	$(RM) TMPPIPE2

c.spvw_circ : d.spvw_circ comment5 ansidecl varbrace
	$(COMMENT5) spvw_circ.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_circ.c
	$(RM) TMPPIPE2

c.spvw_walk : d.spvw_walk comment5 ansidecl varbrace
	$(COMMENT5) spvw_walk.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_walk.c
	$(RM) TMPPIPE2

c.spvw_ctype : d.spvw_ctype comment5 ansidecl varbrace
	$(COMMENT5) spvw_ctype.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_ctype.c
	$(RM) TMPPIPE2

c.spvw_language : d.spvw_language comment5 ansidecl varbrace
	$(COMMENT5) spvw_language.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_language.c
	$(RM) TMPPIPE2

c.spvw_memfile : d.spvw_memfile comment5 ansidecl varbrace
	$(COMMENT5) spvw_memfile.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > spvw_memfile.c
	$(RM) TMPPIPE2

c.errunix : d.errunix comment5 ansidecl varbrace
	$(COMMENT5) errunix.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > errunix.c
	$(RM) TMPPIPE2

c.aridecl : d.aridecl comment5 ansidecl varbrace
	$(COMMENT5) aridecl.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > aridecl.c
	$(RM) TMPPIPE2

c.arilev0 : d.arilev0 comment5 ansidecl varbrace
	$(COMMENT5) arilev0.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > arilev0.c
	$(RM) TMPPIPE2

c.arilev1 : d.arilev1 comment5 ansidecl varbrace
	$(COMMENT5) arilev1.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > arilev1.c
	$(RM) TMPPIPE2

c.intelem : d.intelem comment5 ansidecl varbrace
	$(COMMENT5) intelem.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intelem.c
	$(RM) TMPPIPE2

c.intlog : d.intlog comment5 ansidecl varbrace
	$(COMMENT5) intlog.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intlog.c
	$(RM) TMPPIPE2

c.intplus : d.intplus comment5 ansidecl varbrace
	$(COMMENT5) intplus.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intplus.c
	$(RM) TMPPIPE2

c.intcomp : d.intcomp comment5 ansidecl varbrace
	$(COMMENT5) intcomp.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intcomp.c
	$(RM) TMPPIPE2

c.intbyte : d.intbyte comment5 ansidecl varbrace
	$(COMMENT5) intbyte.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intbyte.c
	$(RM) TMPPIPE2

c.intmal : d.intmal comment5 ansidecl varbrace
	$(COMMENT5) intmal.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intmal.c
	$(RM) TMPPIPE2

c.intdiv : d.intdiv comment5 ansidecl varbrace
	$(COMMENT5) intdiv.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intdiv.c
	$(RM) TMPPIPE2

c.intgcd : d.intgcd comment5 ansidecl varbrace
	$(COMMENT5) intgcd.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intgcd.c
	$(RM) TMPPIPE2

c.int2adic : d.int2adic comment5 ansidecl varbrace
	$(COMMENT5) int2adic.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > int2adic.c
	$(RM) TMPPIPE2

c.intsqrt : d.intsqrt comment5 ansidecl varbrace
	$(COMMENT5) intsqrt.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intsqrt.c
	$(RM) TMPPIPE2

c.intprint : d.intprint comment5 ansidecl varbrace
	$(COMMENT5) intprint.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intprint.c
	$(RM) TMPPIPE2

c.intread : d.intread comment5 ansidecl varbrace
	$(COMMENT5) intread.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > intread.c
	$(RM) TMPPIPE2

c.rational : d.rational comment5 ansidecl varbrace
	$(COMMENT5) rational.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > rational.c
	$(RM) TMPPIPE2

c.sfloat : d.sfloat comment5 ansidecl varbrace
	$(COMMENT5) sfloat.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > sfloat.c
	$(RM) TMPPIPE2

c.ffloat : d.ffloat comment5 ansidecl varbrace
	$(COMMENT5) ffloat.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > ffloat.c
	$(RM) TMPPIPE2

c.dfloat : d.dfloat comment5 ansidecl varbrace
	$(COMMENT5) dfloat.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > dfloat.c
	$(RM) TMPPIPE2

c.lfloat : d.lfloat comment5 ansidecl varbrace
	$(COMMENT5) lfloat.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > lfloat.c
	$(RM) TMPPIPE2

c.flo_konv : d.flo_konv comment5 ansidecl varbrace
	$(COMMENT5) flo_konv.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > flo_konv.c
	$(RM) TMPPIPE2

c.flo_rest : d.flo_rest comment5 ansidecl varbrace
	$(COMMENT5) flo_rest.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > flo_rest.c
	$(RM) TMPPIPE2

c.realelem : d.realelem comment5 ansidecl varbrace
	$(COMMENT5) realelem.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > realelem.c
	$(RM) TMPPIPE2

c.realrand : d.realrand comment5 ansidecl varbrace
	$(COMMENT5) realrand.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > realrand.c
	$(RM) TMPPIPE2

c.realtran : d.realtran comment5 ansidecl varbrace
	$(COMMENT5) realtran.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > realtran.c
	$(RM) TMPPIPE2

c.compelem : d.compelem comment5 ansidecl varbrace
	$(COMMENT5) compelem.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > compelem.c
	$(RM) TMPPIPE2

c.comptran : d.comptran comment5 ansidecl varbrace
	$(COMMENT5) comptran.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > comptran.c
	$(RM) TMPPIPE2

c.arilev1c : d.arilev1c comment5 ansidecl varbrace
	$(COMMENT5) arilev1c.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > arilev1c.c
	$(RM) TMPPIPE2

c.arilev1e : d.arilev1e comment5 ansidecl varbrace
	$(COMMENT5) arilev1e.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > arilev1e.c
	$(RM) TMPPIPE2

c.arilev1i : d.arilev1i comment5 ansidecl varbrace
	$(COMMENT5) arilev1i.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > arilev1i.c
	$(RM) TMPPIPE2

c.genclisph : d.genclisph comment5 ansidecl varbrace
	$(COMMENT5) genclisph.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > genclisph.c
	$(RM) TMPPIPE2

c.modules : d.modules comment5 ansidecl varbrace
	$(COMMENT5) modules.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > modules.c
	$(RM) TMPPIPE2

c.noreadline : d.noreadline comment5 ansidecl varbrace
	$(COMMENT5) noreadline.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > TMPPIPE2
	$(RM) TMPPIPE1
	$(VARBRACE) < TMPPIPE2 > noreadline.c
	$(RM) TMPPIPE2

c.ariarm : d.ariarm comment5 
	$(COMMENT5) ariarm.d ariarm.c

s.ariarm : c.ariarm
	$(CPP) c.ariarm > TMPPIPE1
	$(SED) -f ^.acorn.sed.asmfilter < TMPPIPE1 > s.ariarm
	$(RM) TMPPIPE1

allo : allc o.spvw o.spvwtabf o.spvwtabs o.spvwtabo o.eval o.control o.encoding o.pathname o.stream o.io o.array o.hashtabl o.list o.package o.record o.sequence o.charstrg o.debug o.error o.misc o.time o.predtype o.symbol o.lisparit o.unixaux o.acornaux o.acornsig
	$(TOUCH) allo

alls : allc s.spvw s.spvwtabf s.spvwtabs s.spvwtabo s.eval s.control s.encoding s.pathname s.stream s.io s.array s.hashtabl s.list s.package s.record s.sequence s.charstrg s.debug s.error s.misc s.time s.predtype s.symbol s.lisparit s.unixaux s.acornaux s.acornsig
	$(TOUCH) alls

# Normally not used (just for debugging).
alli : allc i.spvw i.spvwtabf i.spvwtabs i.spvwtabo i.eval i.control i.encoding i.pathname i.stream i.io i.array i.hashtabl i.list i.package i.record i.sequence i.charstrg i.debug i.error i.misc i.time i.predtype i.symbol i.lisparit i.unixaux i.acornaux i.acornsig
	$(TOUCH) alli

i.spvw : c.spvw c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.avl c.spvw_module c.spvw_debug c.spvw_alloca c.spvw_mmap c.spvw_multimap c.spvw_singlemap c.spvw_page c.spvw_heap c.spvw_global c.spvw_gcstat c.spvw_space c.spvw_mark c.spvw_objsize c.spvw_update c.spvw_fault c.spvw_sigsegv c.spvw_sigcld c.spvw_sigpipe c.spvw_sigint c.spvw_sigwinch c.spvw_garcol c.spvw_genera1 c.spvw_genera2 c.spvw_genera3 c.spvw_allocate c.spvw_typealloc c.spvw_circ c.spvw_walk c.spvw_ctype c.spvw_language c.spvw_memfile c.sort c.subrkw c.arilev0 c.aridecl h.stdbool h.version
	$(CPP) $(CFLAGS) c.spvw > i.spvw

s.spvw : c.spvw c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.avl c.spvw_module c.spvw_debug c.spvw_alloca c.spvw_mmap c.spvw_multimap c.spvw_singlemap c.spvw_page c.spvw_heap c.spvw_global c.spvw_gcstat c.spvw_space c.spvw_mark c.spvw_objsize c.spvw_update c.spvw_fault c.spvw_sigsegv c.spvw_sigcld c.spvw_sigpipe c.spvw_sigint c.spvw_sigwinch c.spvw_garcol c.spvw_genera1 c.spvw_genera2 c.spvw_genera3 c.spvw_allocate c.spvw_typealloc c.spvw_circ c.spvw_walk c.spvw_ctype c.spvw_language c.spvw_memfile c.sort c.subrkw c.arilev0 c.aridecl h.stdbool h.version
	$(CC) $(CFLAGS) -S c.spvw

o.spvw : c.spvw c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.avl c.spvw_module c.spvw_debug c.spvw_alloca c.spvw_mmap c.spvw_multimap c.spvw_singlemap c.spvw_page c.spvw_heap c.spvw_global c.spvw_gcstat c.spvw_space c.spvw_mark c.spvw_objsize c.spvw_update c.spvw_fault c.spvw_sigsegv c.spvw_sigcld c.spvw_sigpipe c.spvw_sigint c.spvw_sigwinch c.spvw_garcol c.spvw_genera1 c.spvw_genera2 c.spvw_genera3 c.spvw_allocate c.spvw_typealloc c.spvw_circ c.spvw_walk c.spvw_ctype c.spvw_language c.spvw_memfile c.sort c.subrkw c.arilev0 c.aridecl h.stdbool h.version
	$(CC) $(CFLAGS) -c c.spvw

i.spvwtabf : c.spvwtabf c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.spvwtabf > i.spvwtabf

s.spvwtabf : c.spvwtabf c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.spvwtabf

o.spvwtabf : c.spvwtabf c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.spvwtabf

i.spvwtabs : c.spvwtabs c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.spvwtabs > i.spvwtabs

s.spvwtabs : c.spvwtabs c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.spvwtabs

o.spvwtabs : c.spvwtabs c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.spvwtabs

i.spvwtabo : c.spvwtabo c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.spvwtabo > i.spvwtabo

s.spvwtabo : c.spvwtabo c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.spvwtabo

o.spvwtabo : c.spvwtabo c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.spvwtabo

i.eval : c.eval c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.bytecode h.stdbool
	$(CPP) $(CFLAGS) c.eval > i.eval

s.eval : c.eval c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.bytecode h.stdbool
	$(CC) $(CFLAGS) -S c.eval

o.eval : c.eval c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.bytecode h.stdbool
	$(CC) $(CFLAGS) -c c.eval

i.control : c.control c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.control > i.control

s.control : c.control c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.control

o.control : c.control c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.control

i.encoding : c.encoding c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.nls_ascii c.nls_iso8859_1 c.nls_iso8859_2 c.nls_iso8859_3 c.nls_iso8859_4 c.nls_iso8859_5 c.nls_iso8859_6 c.nls_iso8859_7 c.nls_iso8859_8 c.nls_iso8859_9 c.nls_iso8859_10 c.nls_iso8859_13 c.nls_iso8859_14 c.nls_iso8859_15 c.nls_iso8859_16 c.nls_koi8_r c.nls_koi8_u c.nls_mac_arabic c.nls_mac_centraleurope c.nls_mac_croatian c.nls_mac_cyrillic c.nls_mac_dingbat c.nls_mac_greek c.nls_mac_hebrew c.nls_mac_iceland c.nls_mac_roman c.nls_mac_romania c.nls_mac_symbol c.nls_mac_thai c.nls_mac_turkish c.nls_mac_ukraine c.nls_cp437_ms c.nls_cp437_ibm c.nls_cp737 c.nls_cp775 c.nls_cp850 c.nls_cp852_ms c.nls_cp852_ibm c.nls_cp855 c.nls_cp857 c.nls_cp860_ms c.nls_cp860_ibm c.nls_cp861_ms c.nls_cp861_ibm c.nls_cp862_ms c.nls_cp862_ibm c.nls_cp863_ms c.nls_cp863_ibm c.nls_cp864_ms c.nls_cp864_ibm c.nls_cp865_ms c.nls_cp865_ibm c.nls_cp866 c.nls_cp869_ms c.nls_cp869_ibm c.nls_cp874_ms c.nls_cp874_ibm c.nls_cp1250 c.nls_cp1251 c.nls_cp1252 c.nls_cp1253 c.nls_cp1254 c.nls_cp1255 c.nls_cp1256 c.nls_cp1257 c.nls_cp1258 c.nls_hp_roman8 c.nls_nextstep c.nls_jisx0201 h.stdbool h.libcharset
	$(CPP) $(CFLAGS) c.encoding > i.encoding

s.encoding : c.encoding c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.nls_ascii c.nls_iso8859_1 c.nls_iso8859_2 c.nls_iso8859_3 c.nls_iso8859_4 c.nls_iso8859_5 c.nls_iso8859_6 c.nls_iso8859_7 c.nls_iso8859_8 c.nls_iso8859_9 c.nls_iso8859_10 c.nls_iso8859_13 c.nls_iso8859_14 c.nls_iso8859_15 c.nls_iso8859_16 c.nls_koi8_r c.nls_koi8_u c.nls_mac_arabic c.nls_mac_centraleurope c.nls_mac_croatian c.nls_mac_cyrillic c.nls_mac_dingbat c.nls_mac_greek c.nls_mac_hebrew c.nls_mac_iceland c.nls_mac_roman c.nls_mac_romania c.nls_mac_symbol c.nls_mac_thai c.nls_mac_turkish c.nls_mac_ukraine c.nls_cp437_ms c.nls_cp437_ibm c.nls_cp737 c.nls_cp775 c.nls_cp850 c.nls_cp852_ms c.nls_cp852_ibm c.nls_cp855 c.nls_cp857 c.nls_cp860_ms c.nls_cp860_ibm c.nls_cp861_ms c.nls_cp861_ibm c.nls_cp862_ms c.nls_cp862_ibm c.nls_cp863_ms c.nls_cp863_ibm c.nls_cp864_ms c.nls_cp864_ibm c.nls_cp865_ms c.nls_cp865_ibm c.nls_cp866 c.nls_cp869_ms c.nls_cp869_ibm c.nls_cp874_ms c.nls_cp874_ibm c.nls_cp1250 c.nls_cp1251 c.nls_cp1252 c.nls_cp1253 c.nls_cp1254 c.nls_cp1255 c.nls_cp1256 c.nls_cp1257 c.nls_cp1258 c.nls_hp_roman8 c.nls_nextstep c.nls_jisx0201 h.stdbool h.libcharset
	$(CC) $(CFLAGS) -S c.encoding

o.encoding : c.encoding c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.nls_ascii c.nls_iso8859_1 c.nls_iso8859_2 c.nls_iso8859_3 c.nls_iso8859_4 c.nls_iso8859_5 c.nls_iso8859_6 c.nls_iso8859_7 c.nls_iso8859_8 c.nls_iso8859_9 c.nls_iso8859_10 c.nls_iso8859_13 c.nls_iso8859_14 c.nls_iso8859_15 c.nls_iso8859_16 c.nls_koi8_r c.nls_koi8_u c.nls_mac_arabic c.nls_mac_centraleurope c.nls_mac_croatian c.nls_mac_cyrillic c.nls_mac_dingbat c.nls_mac_greek c.nls_mac_hebrew c.nls_mac_iceland c.nls_mac_roman c.nls_mac_romania c.nls_mac_symbol c.nls_mac_thai c.nls_mac_turkish c.nls_mac_ukraine c.nls_cp437_ms c.nls_cp437_ibm c.nls_cp737 c.nls_cp775 c.nls_cp850 c.nls_cp852_ms c.nls_cp852_ibm c.nls_cp855 c.nls_cp857 c.nls_cp860_ms c.nls_cp860_ibm c.nls_cp861_ms c.nls_cp861_ibm c.nls_cp862_ms c.nls_cp862_ibm c.nls_cp863_ms c.nls_cp863_ibm c.nls_cp864_ms c.nls_cp864_ibm c.nls_cp865_ms c.nls_cp865_ibm c.nls_cp866 c.nls_cp869_ms c.nls_cp869_ibm c.nls_cp874_ms c.nls_cp874_ibm c.nls_cp1250 c.nls_cp1251 c.nls_cp1252 c.nls_cp1253 c.nls_cp1254 c.nls_cp1255 c.nls_cp1256 c.nls_cp1257 c.nls_cp1258 c.nls_hp_roman8 c.nls_nextstep c.nls_jisx0201 h.stdbool h.libcharset
	$(CC) $(CFLAGS) -c c.encoding

i.pathname : c.pathname c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.pathname > i.pathname

s.pathname : c.pathname c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.pathname

o.pathname : c.pathname c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.pathname

i.stream : c.stream c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CPP) $(CFLAGS) c.stream > i.stream

s.stream : c.stream c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CC) $(CFLAGS) -S c.stream

o.stream : c.stream c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CC) $(CFLAGS) -c c.stream

i.io : c.io c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CPP) $(CFLAGS) c.io > i.io

s.io : c.io c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CC) $(CFLAGS) -S c.io

o.io : c.io c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CC) $(CFLAGS) -c c.io

i.array : c.array c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CPP) $(CFLAGS) c.array > i.array

s.array : c.array c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CC) $(CFLAGS) -S c.array

o.array : c.array c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CC) $(CFLAGS) -c c.array

i.hashtabl : c.hashtabl c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 c.aridecl h.stdbool
	$(CPP) $(CFLAGS) c.hashtabl > i.hashtabl

s.hashtabl : c.hashtabl c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 c.aridecl h.stdbool
	$(CC) $(CFLAGS) -S c.hashtabl

o.hashtabl : c.hashtabl c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 c.aridecl h.stdbool
	$(CC) $(CFLAGS) -c c.hashtabl

i.list : c.list c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.list > i.list

s.list : c.list c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.list

o.list : c.list c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.list

i.package : c.package c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.arilev0 h.stdbool
	$(CPP) $(CFLAGS) c.package > i.package

s.package : c.package c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.arilev0 h.stdbool
	$(CC) $(CFLAGS) -S c.package

o.package : c.package c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.arilev0 h.stdbool
	$(CC) $(CFLAGS) -c c.package

i.record : c.record c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.record > i.record

s.record : c.record c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.record

o.record : c.record c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.record

i.sequence : c.sequence c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.sequence > i.sequence

s.sequence : c.sequence c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.sequence

o.sequence : c.sequence c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.sequence

i.charstrg : c.charstrg c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.uni_upcase c.uni_downcase c.uni_attribute c.uninames h.stdbool
	$(CPP) $(CFLAGS) c.charstrg > i.charstrg

s.charstrg : c.charstrg c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.uni_upcase c.uni_downcase c.uni_attribute c.uninames h.stdbool
	$(CC) $(CFLAGS) -S c.charstrg

o.charstrg : c.charstrg c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.uni_upcase c.uni_downcase c.uni_attribute c.uninames h.stdbool
	$(CC) $(CFLAGS) -c c.charstrg

i.debug : c.debug c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.debug > i.debug

s.debug : c.debug c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.debug

o.debug : c.debug c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.debug

i.error : c.error c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.errunix h.stdbool
	$(CPP) $(CFLAGS) c.error > i.error

s.error : c.error c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.errunix h.stdbool
	$(CC) $(CFLAGS) -S c.error

o.error : c.error c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.errunix h.stdbool
	$(CC) $(CFLAGS) -c c.error

i.misc : c.misc c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.misc > i.misc

s.misc : c.misc c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.misc

o.misc : c.misc c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.misc

i.time : c.time c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CPP) $(CFLAGS) c.time > i.time

s.time : c.time c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CC) $(CFLAGS) -S c.time

o.time : c.time c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 h.stdbool
	$(CC) $(CFLAGS) -c c.time

i.predtype : c.predtype c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.avl h.stdbool
	$(CPP) $(CFLAGS) c.predtype > i.predtype

s.predtype : c.predtype c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.avl h.stdbool
	$(CC) $(CFLAGS) -S c.predtype

o.predtype : c.predtype c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.avl h.stdbool
	$(CC) $(CFLAGS) -c c.predtype

i.symbol : c.symbol c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.symbol > i.symbol

s.symbol : c.symbol c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.symbol

o.symbol : c.symbol c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.symbol

i.lisparit : c.lisparit c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.aridecl c.arilev0 c.arilev1 c.intelem c.intlog c.intplus c.intcomp c.intbyte c.intmal c.intdiv c.intgcd c.int2adic c.intsqrt c.intprint c.intread c.rational c.sfloat c.ffloat c.dfloat c.lfloat c.flo_konv c.flo_rest c.realelem c.realrand c.realtran c.compelem c.comptran c.arilev1c c.arilev1e c.arilev1i c.ariarm h.stdbool
	$(CPP) $(CFLAGS) c.lisparit > i.lisparit

s.lisparit : c.lisparit c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.aridecl c.arilev0 c.arilev1 c.intelem c.intlog c.intplus c.intcomp c.intbyte c.intmal c.intdiv c.intgcd c.int2adic c.intsqrt c.intprint c.intread c.rational c.sfloat c.ffloat c.dfloat c.lfloat c.flo_konv c.flo_rest c.realelem c.realrand c.realtran c.compelem c.comptran c.arilev1c c.arilev1e c.arilev1i c.ariarm h.stdbool
	$(CC) $(CFLAGS) -S c.lisparit

o.lisparit : c.lisparit c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.aridecl c.arilev0 c.arilev1 c.intelem c.intlog c.intplus c.intcomp c.intbyte c.intmal c.intdiv c.intgcd c.int2adic c.intsqrt c.intprint c.intread c.rational c.sfloat c.ffloat c.dfloat c.lfloat c.flo_konv c.flo_rest c.realelem c.realrand c.realtran c.compelem c.comptran c.arilev1c c.arilev1e c.arilev1i c.ariarm h.stdbool
	$(CC) $(CFLAGS) -c c.lisparit

i.unixaux : c.unixaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.unixaux > i.unixaux

s.unixaux : c.unixaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.unixaux

o.unixaux : c.unixaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.unixaux

i.acornaux : c.acornaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.acornaux > i.acornaux

s.acornaux : c.acornaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.acornaux

o.acornaux : c.acornaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.acornaux

i.acornsig : c.acornsig c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.acornsig > i.acornsig

s.acornsig : c.acornsig c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.acornsig

o.acornsig : c.acornsig c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.acornsig

i.genclisph : c.genclisph c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.genclisph > i.genclisph

s.genclisph : c.genclisph c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.genclisph

o.genclisph : c.genclisph c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.genclisph

i.modules : c.modules c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool h.modules
	$(CPP) $(CFLAGS) -DNO_CLISP_H c.modules > i.modules

s.modules : c.modules c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool h.modules
	$(CC) $(CFLAGS) -DNO_CLISP_H -S c.modules

o.modules : c.modules c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool h.modules
	$(CC) $(CFLAGS) -DNO_CLISP_H -c c.modules

i.noreadline : c.noreadline c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CPP) $(CFLAGS) c.noreadline > i.noreadline

s.noreadline : c.noreadline c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -S c.noreadline

o.noreadline : c.noreadline c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool
	$(CC) $(CFLAGS) -c c.noreadline

o.ariarm : s.ariarm
	objasm -Stamp -Quit -CloseExec -from s.ariarm -o o.ariarm

txt.UnicodeData :
	$(LN_S) ^.utils.unicode.ftp.unicode.org.txt.UnicodeData txt.UnicodeData

lisp : $(OBJECTS) o.modules       txt.UnicodeData
	$(CC) $(CFLAGS) $(CLFLAGS) $(OBJECTS) o.modules $(LIBS) -o lisp


alllisp : $(LISPFILES)
	$(TOUCH) alllisp

lisp.config : lisp.cfgacorn
	$(CP) lisp.cfgacorn lisp.config

mem.interpre : lisp $(LISPFILES)
	-$(RM) mem.interpre
	/@.lisp -m 750KW -B . -Efile UTF-8 -norc -x "(load \"init.lisp\") (sys::%saveinitmem) (exit)"
	$(MV) mem.lispimag mem.interpre

fas.init : lisp.init lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c init.lisp

fas.defseq : lisp.defseq lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c defseq.lisp

fas.backquote : lisp.backquote lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c backquote.lisp

fas.defmacro : lisp.defmacro lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c defmacro.lisp

fas.macros1 : lisp.macros1 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c macros1.lisp

fas.macros2 : lisp.macros2 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c macros2.lisp

fas.defs1 : lisp.defs1 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c defs1.lisp

fas.timezone : lisp.timezone lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c timezone.lisp

fas.places : lisp.places lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c places.lisp

fas.floatprint : lisp.floatprint lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c floatprint.lisp

fas.type : lisp.type lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c type.lisp

fas.defstruct : lisp.defstruct lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c defstruct.lisp

fas.format : lisp.format lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c format.lisp

fas.savemem : lisp.savemem lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c savemem.lisp

fas.trace : lisp.trace lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c trace.lisp

fas.compiler : lisp.compiler lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c compiler.lisp

fas.disassem : lisp.disassem lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c disassem.lisp

fas.defs2 : lisp.defs2 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c defs2.lisp

fas.loop : lisp.loop lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c loop.lisp

fas.clos : lisp.clos lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c clos.lisp

fas.condition : lisp.condition lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c condition.lisp

fas.gstream : lisp.gstream lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c gstream.lisp

fas.xcharin : lisp.xcharin lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c xcharin.lisp

fas.keyboard : lisp.keyboard lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c keyboard.lisp

fas.screen : lisp.screen lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c screen.lisp

fas.beossock : lisp.beossock lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c beossock.lisp

fas.runprog : lisp.runprog lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c runprog.lisp

fas.query : lisp.query lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c query.lisp

fas.reploop : lisp.reploop lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c reploop.lisp

fas.dribble : lisp.dribble lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c dribble.lisp

fas.complete : lisp.complete lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c complete.lisp

fas.describe : lisp.describe lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c describe.lisp

fas.room : lisp.room lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c room.lisp

fas.edit : lisp.edit lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c edit.lisp

fas.macros3 : lisp.macros3 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c macros3.lisp

fas.posix : lisp.posix lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c posix.lisp

fas.foreign1 : lisp.foreign1 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c foreign1.lisp

fas.defs3 : lisp.defs3 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c defs3.lisp

fas.clhs : lisp.clhs lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c clhs.lisp

fas.inspect : lisp.inspect lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c inspect.lisp

fas.german : lisp.german lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c german.lisp

fas.french : lisp.french lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c french.lisp

fas.spanish : lisp.spanish lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c spanish.lisp

fas.dutch : lisp.dutch lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c dutch.lisp

fas.config : lisp.config lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -B . -Efile UTF-8 -norc -q -c config.lisp

mem.halfcomp : lisp $(LISPFILES) fas.compiler
	-$(RM) mem.interpre
	/@.lisp -m 750KW -B . -Efile UTF-8 -norc -x "(load \"init.lisp\") (sys::%saveinitmem) (exit)"
	$(MV) mem.lispimag mem.interpre
	$(TOUCH) mem.interpre
	$(TOUCH) fas.compiler
	$(TOUCH) mem.halfcomp

mem.lispinit : lisp $(FASFILES)
	-$(RM) mem.lispinit
	/@.lisp -B . -Efile UTF-8 -norc -x "(load \"init.fas\") (sys::%saveinitmem) (exit)"
	$(MV) mem.lispimag mem.lispinit


# Perform self-tests.
check : test
	$(TOUCH) check

# Test: recompile $(LISPFILES) and compare their contents.
test : mem.lispinit stage $(TESTLISPFILES) $(TESTFASFILES)
	echo "Compare the .fas files by hand."

stage :
	-mkdir stage

stage.lisp.init : lisp.init
	$(LN_S) lisp.init stage

stage.lisp.defseq : lisp.defseq
	$(LN_S) lisp.defseq stage

stage.lisp.backquote : lisp.backquote
	$(LN_S) lisp.backquote stage

stage.lisp.defmacro : lisp.defmacro
	$(LN_S) lisp.defmacro stage

stage.lisp.macros1 : lisp.macros1
	$(LN_S) lisp.macros1 stage

stage.lisp.macros2 : lisp.macros2
	$(LN_S) lisp.macros2 stage

stage.lisp.defs1 : lisp.defs1
	$(LN_S) lisp.defs1 stage

stage.lisp.timezone : lisp.timezone
	$(LN_S) lisp.timezone stage

stage.lisp.places : lisp.places
	$(LN_S) lisp.places stage

stage.lisp.floatprint : lisp.floatprint
	$(LN_S) lisp.floatprint stage

stage.lisp.type : lisp.type
	$(LN_S) lisp.type stage

stage.lisp.defstruct : lisp.defstruct
	$(LN_S) lisp.defstruct stage

stage.lisp.format : lisp.format
	$(LN_S) lisp.format stage

stage.lisp.savemem : lisp.savemem
	$(LN_S) lisp.savemem stage

stage.lisp.trace : lisp.trace
	$(LN_S) lisp.trace stage

stage.lisp.compiler : lisp.compiler
	$(LN_S) lisp.compiler stage

stage.lisp.disassem : lisp.disassem
	$(LN_S) lisp.disassem stage

stage.lisp.defs2 : lisp.defs2
	$(LN_S) lisp.defs2 stage

stage.lisp.loop : lisp.loop
	$(LN_S) lisp.loop stage

stage.lisp.clos : lisp.clos
	$(LN_S) lisp.clos stage

stage.lisp.condition : lisp.condition
	$(LN_S) lisp.condition stage

stage.lisp.gstream : lisp.gstream
	$(LN_S) lisp.gstream stage

stage.lisp.xcharin : lisp.xcharin
	$(LN_S) lisp.xcharin stage

stage.lisp.keyboard : lisp.keyboard
	$(LN_S) lisp.keyboard stage

stage.lisp.screen : lisp.screen
	$(LN_S) lisp.screen stage

stage.lisp.beossock : lisp.beossock
	$(LN_S) lisp.beossock stage

stage.lisp.runprog : lisp.runprog
	$(LN_S) lisp.runprog stage

stage.lisp.query : lisp.query
	$(LN_S) lisp.query stage

stage.lisp.reploop : lisp.reploop
	$(LN_S) lisp.reploop stage

stage.lisp.dribble : lisp.dribble
	$(LN_S) lisp.dribble stage

stage.lisp.complete : lisp.complete
	$(LN_S) lisp.complete stage

stage.lisp.describe : lisp.describe
	$(LN_S) lisp.describe stage

stage.lisp.room : lisp.room
	$(LN_S) lisp.room stage

stage.lisp.edit : lisp.edit
	$(LN_S) lisp.edit stage

stage.lisp.macros3 : lisp.macros3
	$(LN_S) lisp.macros3 stage

stage.lisp.posix : lisp.posix
	$(LN_S) lisp.posix stage

stage.lisp.foreign1 : lisp.foreign1
	$(LN_S) lisp.foreign1 stage

stage.lisp.defs3 : lisp.defs3
	$(LN_S) lisp.defs3 stage

stage.lisp.clhs : lisp.clhs
	$(LN_S) lisp.clhs stage

stage.lisp.inspect : lisp.inspect
	$(LN_S) lisp.inspect stage

stage.lisp.german : lisp.german
	$(LN_S) lisp.german stage

stage.lisp.french : lisp.french
	$(LN_S) lisp.french stage

stage.lisp.spanish : lisp.spanish
	$(LN_S) lisp.spanish stage

stage.lisp.dutch : lisp.dutch
	$(LN_S) lisp.dutch stage

stage.lisp.config : lisp.config
	$(LN_S) lisp.config stage

stage.fas.init : stage.lisp.init lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.init.lisp

stage.fas.defseq : stage.lisp.defseq lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.defseq.lisp

stage.fas.backquote : stage.lisp.backquote lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.backquote.lisp

stage.fas.defmacro : stage.lisp.defmacro lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.defmacro.lisp

stage.fas.macros1 : stage.lisp.macros1 lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.macros1.lisp

stage.fas.macros2 : stage.lisp.macros2 lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.macros2.lisp

stage.fas.defs1 : stage.lisp.defs1 lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.defs1.lisp

stage.fas.timezone : stage.lisp.timezone lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.timezone.lisp

stage.fas.places : stage.lisp.places lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.places.lisp

stage.fas.floatprint : stage.lisp.floatprint lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.floatprint.lisp

stage.fas.type : stage.lisp.type lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.type.lisp

stage.fas.defstruct : stage.lisp.defstruct lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.defstruct.lisp

stage.fas.format : stage.lisp.format lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.format.lisp

stage.fas.savemem : stage.lisp.savemem lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.savemem.lisp

stage.fas.trace : stage.lisp.trace lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.trace.lisp

stage.fas.compiler : stage.lisp.compiler lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.compiler.lisp

stage.fas.disassem : stage.lisp.disassem lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.disassem.lisp

stage.fas.defs2 : stage.lisp.defs2 lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.defs2.lisp

stage.fas.loop : stage.lisp.loop lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.loop.lisp

stage.fas.clos : stage.lisp.clos lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.clos.lisp

stage.fas.condition : stage.lisp.condition lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.condition.lisp

stage.fas.gstream : stage.lisp.gstream lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.gstream.lisp

stage.fas.xcharin : stage.lisp.xcharin lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.xcharin.lisp

stage.fas.keyboard : stage.lisp.keyboard lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.keyboard.lisp

stage.fas.screen : stage.lisp.screen lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.screen.lisp

stage.fas.beossock : stage.lisp.beossock lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.beossock.lisp

stage.fas.runprog : stage.lisp.runprog lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.runprog.lisp

stage.fas.query : stage.lisp.query lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.query.lisp

stage.fas.reploop : stage.lisp.reploop lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.reploop.lisp

stage.fas.dribble : stage.lisp.dribble lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.dribble.lisp

stage.fas.complete : stage.lisp.complete lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.complete.lisp

stage.fas.describe : stage.lisp.describe lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.describe.lisp

stage.fas.room : stage.lisp.room lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.room.lisp

stage.fas.edit : stage.lisp.edit lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.edit.lisp

stage.fas.macros3 : stage.lisp.macros3 lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.macros3.lisp

stage.fas.posix : stage.lisp.posix lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.posix.lisp

stage.fas.foreign1 : stage.lisp.foreign1 lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.foreign1.lisp

stage.fas.defs3 : stage.lisp.defs3 lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.defs3.lisp

stage.fas.clhs : stage.lisp.clhs lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.clhs.lisp

stage.fas.inspect : stage.lisp.inspect lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.inspect.lisp

stage.fas.german : stage.lisp.german lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.german.lisp

stage.fas.french : stage.lisp.french lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.french.lisp

stage.fas.spanish : stage.lisp.spanish lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.spanish.lisp

stage.fas.dutch : stage.lisp.dutch lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.dutch.lisp

stage.fas.config : stage.lisp.config lisp mem.lispinit
	/@.lisp -M mem.lispinit -B . -Efile UTF-8 -norc -q -c stage.config.lisp

mem.lispinit2 : lisp $(TESTFASFILES)
	/@.lisp -B . -Efile UTF-8 -norc -x "(cd \"stage.\") (load \"init.fas\") (cd \"^.\") (sys::%saveinitmem) (exit)"
	-$(RM) mem.lispinit2
	$(MV) mem.lispimag mem.lispinit2


READMES = ANNOUNCE COPYRIGHT GNU-GPL SUMMARY NEWS README README_de README_es
MANUALS = 1.clisp html.clisp $(TXTFILES) html.impnotes clisp.gif

html.impnotes : ^.doc.html.impnotes
	$(CP) ^.doc.html.impnotes html.impnotes

manual : $(READMES) $(MANUALS)
	$(TOUCH) manual

manualx : manual man.clisp dvi.clisp
	$(TOUCH) manualx

ANNOUNCE : ^.ANNOUNCE
	-$(LN_S) ^.ANNOUNCE ANNOUNCE

COPYRIGHT : ^.COPYRIGHT
	-$(LN_S) ^.COPYRIGHT COPYRIGHT

GNU-GPL : ^.GNU-GPL
	-$(LN_S) ^.GNU-GPL GNU-GPL

SUMMARY : ^.SUMMARY
	-$(LN_S) ^.SUMMARY SUMMARY

README : _README c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool _README_de _README_en txt2c
	$(TXT2C) < _README > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > README
	$(RM) c.text
	$(RM) text

README_de : _README_de c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool txt2c
	$(TXT2C) < _README_de > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > README_de
	$(RM) c.text
	$(RM) text

README_es : _README_es c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool txt2c
	$(TXT2C) < _README_es > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > README_es
	$(RM) c.text
	$(RM) text

1.clisp : 1._clisp c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool txt2c
	$(TXT2C) < 1._clisp > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > TMPPIPE1
	$(GREP) -v -f ^.acorn.in.grep < TMPPIPE1 > 1.clisp
	$(RM) TMPPIPE1
	$(RM) c.text
	$(RM) text

html.clisp : html._clisp c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.stdbool txt2c
	$(TXT2C) < html._clisp > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > TMPPIPE1
	sed -e 's,HREF="CLHSROOT/,HREF="http://www.lisp.org/HyperSpec/,' < TMPPIPE1 > html.clisp
	$(RM) TMPPIPE1
	$(RM) c.text
	$(RM) text

dvi.clisp : 1.clisp
	$(ROFF_DVI) 1.clisp > dvi.clisp

man.clisp : 1.clisp
	$(ROFF_MAN) 1.clisp > man.clisp

txt.LISP-tutorial : ^.doc.txt.LISP-tutorial
	-$(LN_S) ^.doc.txt.LISP-tutorial txt.LISP-tutorial

txt.CLOS-guide : ^.doc.txt.CLOS-guide
	-$(LN_S) ^.doc.txt.CLOS-guide txt.CLOS-guide

txt.editors : ^.doc.txt.editors
	-$(LN_S) ^.doc.txt.editors txt.editors


distrib : force all manualx
	-cdir ^.!Clisp
	$(CP) lisp ^.!lisp.Clisp
	squeeze ^.!lisp.Clisp
	-cdir ^.!Clisp.mem
	$(CP) mem.lispinit ^.!Clisp.mem.lispinit
	$(CP) ANNOUNCE ^.!Clisp.ANNOUNCE
	$(CP) COPYRIGHT ^.!Clisp.COPYRIGHT
	$(CP) GNU-GPL ^.!Clisp.GNU-GPL
	$(CP) SUMMARY ^.!Clisp.SUMMARY
	$(CP) NEWS ^.!Clisp.NEWS
	$(CP) README ^.!Clisp.README
	$(CP) README_de ^.!Clisp.README_de
	$(CP) README_es ^.!Clisp.README_es
	-cdir ^.!Clisp.1
	$(CP) 1.clisp ^.!Clisp.1.clisp
	-cdir ^.!Clisp.man
	$(CP) man.clisp ^.!Clisp.man.clisp
	-cdir ^.!Clisp.html
	$(CP) html.clisp ^.!Clisp.html.clisp
	$(CP) html.impnotes ^.!Clisp.html.impnotes
	settype ^.!Clisp.html.clisp FAF
	-cdir ^.!Clisp.txt
	$(CP) txt.LISP-tutor ^.!Clisp.txt.LISP-tutor
	$(CP) txt.CLOS-guide ^.!Clisp.txt.CLOS-guide
	$(CP) txt.editors ^.!Clisp.txt.editors
	-cdir ^.!Clisp.lisp
	$(CP) lisp.config ^.!Clisp.lisp.config
	$(CP) lisp.timezone ^.!Clisp.lisp.timezone
	$(CP) ^.acorn.!Run ^.!Clisp.!Run
	settype ^.!Clisp.!Run Obey
	$(CP) ^.acorn.!Sprites ^.!Clisp.!Sprites
	settype ^.!Clisp.!Sprites Sprite

# clean0 is harmless: removes only superfluous things: temporary files.
clean0 : force
	-$(RM) core c.ansidecl c.varbrace c.ccmp2c c.modprep genclisph wgenclisph linkkit c.text text

# clean1 removes everything that becomes obsolete once lisp is recompiled
# without changing the bytecode format and the tables in
# constobj.d, constpack.d, constsym.d, subr.d, fsubr.d, pseudofun.d.
clean1 : clean0
	-$(RM) h.lispbibl h.clisp *.i *.s *.o *.a lisp clisp-link makevars stage.* suite.*
	-$(RM) libsigsegv.* libiconv.* libavcall.* libcallback.*
	-rmdir stage
	-rmdir suite
	-$(RM) README README_de README_es 1.clisp man.clisp dvi.clisp html.clisp html.impnotes c.clisp distmakefile $(TXTFILES) clreadline.3 man.clreadline html.clreadline dvi.clreadline dvi.readline

# clean2 removes everything that becomes obsolete once lisp is recompiled
# without changing the bytecode format.
clean2 : clean1
	-$(RM) mem.interpre mem.halfcomp mem.lispinit mem.lispinit2

# clean3 removes everything that becomes obsolete once lisp is recompiled.
# It leaves everything generated by "make allc".
clean3 : clean2
	-$(RM) $(FASFILES) *.lib

# clean4 removes everything that becomes obsolete
# when switching to a new version of the C compiler.
# It leaves everything generated by "make init".
clean4 : clean3
	-$(RM) $(CFILES)
	-$(RM) h.stdbool

# clean5 even undoes "make init".
clean5 : clean4
	-$(RM) ANNOUNCE COPYRIGHT GNU-GPL SUMMARY
	-$(RM) lisp.config
	-$(RM) comment5 ansidecl ccpaux deema txt2c ccmp2c modprep

# clean6 lets us go back to "makemake > Makefile".
clean6 : clean5
	-$(RM) Makefile

# clean7 lets us go back to the main "configure".
clean7 : clean6
	-$(RM) config.status config.log config.cache h.intparam h.unixconf makemake

# clean8 moreover cleans up the SRCDIR.
clean8 : clean7

# The normal "start over" command:
mostlyclean : clean4

# Clear all files that are built by "make ...":
clean : clean5

# Make "clear for distribution":
distclean : clean7

# Remove everything that can be generated otherwise:
maintainer-clean : clean8


.SUFFIXES:
	$(TOUCH) .SUFFIXES

force:
	$(TOUCH) force

