/*
 * Copyright (C) 1999-2001 Free Software Foundation, Inc.
 * This file is part of the GNU LIBICONV Library.
 *
 * The GNU LIBICONV Library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The GNU LIBICONV Library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the GNU LIBICONV Library; see the file COPYING.LIB.
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place -
 * Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * CNS 11643-1992 plane 6
 */

static const unsigned short cns11643_6_2uni_page21[6388] = {
  /* 0x21 */
  0x31fd, 0x3262, 0x0005, 0x3288, 0x32d0, 0x32cf, 0x331e, 0x331f,
  0x3320, 0x3b0e, 0x3b2c, 0x3261, 0x3204, 0x3205, 0x3203, 0x31fd,
  0x31fd, 0x327d, 0x328d, 0x33a3, 0x33a4, 0x36db, 0x3700, 0x31fd,
  0x38a3, 0x3a32, 0x013f, 0x3cd4, 0x3cd5, 0x4d23, 0x542c, 0x547a,
  0x3703, 0x3207, 0x3208, 0x328f, 0x329c, 0x32d5, 0x3312, 0x3313,
  0x3314, 0x3321, 0x33a8, 0x33a6, 0x3676, 0x3701, 0x373d, 0x31fd,
  0x373e, 0x3829, 0x3877, 0x3878, 0x38a6, 0x38a9, 0x38ac, 0x3a34,
  0x3704, 0x3b7b, 0x3c10, 0x382f, 0x3cd7, 0x3d1c, 0x3d1f, 0x3d1a,
  0x31fd, 0x3d1e, 0x3d9e, 0x3d9a, 0x42a0, 0x42a1, 0x46d2, 0x46d3,
  0x4ab9, 0x4c1d, 0x4c55, 0x4dff, 0x50e7, 0x042a, 0x5111, 0x5113,
  0x5112, 0x52af, 0x52b1, 0x31fd, 0x542d, 0x547b, 0x549d, 0x549a,
  0x04a7, 0x549f, 0x54a0, 0x549c, 0x55bd, 0x04fa,
  /* 0x22 */
  0x56aa, 0x616c, 0x6191, 0x6c74, 0x746a, 0x31fd, 0x8505, 0x8e6b,
  0x8e6a, 0x32e0, 0x3212, 0x0000, 0x327f, 0x32a0, 0x3299, 0x3295,
  0x329e, 0x32df, 0x32de, 0x33af, 0x33ad, 0x33b0, 0x36df, 0x3743,
  0x3741, 0x3748, 0x3775, 0x31fd, 0x3832, 0x387b, 0x3879, 0x38b3,
  0x00db, 0x3da7, 0x38b2, 0x38b0, 0x38b4, 0x31fd, 0x3acd, 0x3ace,
  0x31fd, 0x3b10, 0x3b80, 0x3bd3, 0x3c30, 0x3298, 0x3c2f, 0x3c31,
  0x3cda, 0x3cd9, 0x3d27, 0x3d28, 0x3d21, 0x3d25, 0x3da6, 0x3da2,
  0x3da1, 0x3da4, 0x31fd, 0x3daa, 0x3da5, 0x3da3, 0x3264, 0x433f,
  0x4344, 0x461b, 0x4653, 0x4684, 0x4686, 0x46d5, 0x31fd, 0x4a3e,
  0x4a40, 0x4cca, 0x4cc9, 0x4d26, 0x4e00, 0x4e31, 0x4e3c, 0x4e30,
  0x4e33, 0x4e32, 0x4e38, 0x5134, 0x5153, 0x5154, 0x52b4, 0x52b2,
  0x542f, 0x54a5, 0x54a7, 0x54a4, 0x54a8, 0x54a9,
  /* 0x23 */
  0x54a2, 0x54a3, 0x54a6, 0x5581, 0x5580, 0x56ad, 0x5b24, 0x5b65,
  0x5b68, 0x5b69, 0x623c, 0x623b, 0x645d, 0x6944, 0x7082, 0x73f1,
  0x746b, 0x761b, 0x77eb, 0x7aba, 0x7ad3, 0x7c13, 0x8822, 0x96f4,
  0xaa0f, 0xaa10, 0x3707, 0xc00b, 0xc00a, 0x3219, 0x321a, 0x3218,
  0x3266, 0x3282, 0x32a8, 0x32e5, 0x32e7, 0x32e4, 0x3315, 0x3323,
  0x3324, 0x3343, 0x33c3, 0x33bc, 0x33bb, 0x0038, 0x33b7, 0x33b9,
  0x33cf, 0x31fd, 0x367a, 0x367b, 0x36e1, 0x36e0, 0x3709, 0x374d,
  0x31fd, 0x374b, 0x3779, 0x37b1, 0x3836, 0x3835, 0x3837, 0x3838,
  0x387f, 0x3880, 0x3881, 0x9553, 0x387e, 0x38cd, 0x38bf, 0x38be,
  0x38c2, 0x38b8, 0x38c1, 0x1f30, 0x3b31, 0x3b2f, 0x3b6f, 0x3b82,
  0x013a, 0x3b87, 0x3b86, 0x3b8d, 0x3b94, 0x3bd7, 0x3bd4, 0x3bd8,
  0x3c16, 0x3c14, 0x3c2e, 0x3c36, 0x3c37, 0x50ee,
  /* 0x24 */
  0x3ce0, 0x3ce5, 0x3cdf, 0x3d2b, 0x3d29, 0x3d2d, 0x3d2f, 0x3db7,
  0x3dc9, 0x3dc1, 0x3dca, 0x3db2, 0x3dac, 0x3dae, 0x42b2, 0x42a8,
  0x42b0, 0x42a7, 0x31fd, 0x4352, 0x434a, 0x4656, 0x4655, 0x465f,
  0x465e, 0x4688, 0x31fd, 0x46dd, 0x46e2, 0x46e1, 0x46df, 0x46e0,
  0x47af, 0x47b1, 0x47ba, 0x4a45, 0x4a43, 0x4abd, 0x4ac8, 0x31fd,
  0x4abe, 0x4abf, 0x31fd, 0x4c59, 0x4d29, 0x4d2c, 0x4d2f, 0x4d2d,
  0x4d2e, 0x4e04, 0x4e02, 0x4e01, 0x4e40, 0x4e4a, 0x4e3f, 0x4e4f,
  0x4e41, 0x4e4e, 0x50eb, 0x50ec, 0x32ac, 0x515b, 0x5163, 0x515a,
  0x5159, 0x52dc, 0x52db, 0x52d9, 0x52e0, 0x52dd, 0x3220, 0x54b0,
  0x54b1, 0x54b2, 0x54b6, 0x5551, 0x5552, 0x5550, 0x5584, 0x04c9,
  0x5583, 0x56c3, 0x56b8, 0x56b9, 0x56b2, 0x5a90, 0x5b26, 0x5b29,
  0x5b6e, 0x6240, 0x623e, 0x6241, 0x645e, 0x64bb,
  /* 0x25 */
  0x64bc, 0x64b9, 0x31fd, 0x6880, 0x084f, 0x6945, 0x69ba, 0x69bd,
  0x6c56, 0x6c55, 0x6c75, 0x6c77, 0x6c81, 0x31fd, 0x6c83, 0x6c8b,
  0x6c84, 0x7086, 0x7083, 0x708b, 0x746d, 0x7516, 0x7628, 0x77ea,
  0x7ad4, 0x7b03, 0x7c15, 0x7e3d, 0x7e3e, 0x8316, 0x31fd, 0x8506,
  0x864d, 0x8e22, 0x8e73, 0x8e6d, 0x8e6e, 0x90b1, 0x374e, 0x922d,
  0x0fcd, 0x94f9, 0x9552, 0x9700, 0x96fc, 0x96fa, 0x1092, 0x96f7,
  0x96f8, 0x31fd, 0x31fd, 0xa527, 0xaa11, 0x32ae, 0xac50, 0xac4f,
  0xac4d, 0xae71, 0x31fd, 0xae72, 0xb418, 0x3c44, 0x3221, 0x3267,
  0x32af, 0x32b0, 0x3229, 0x3317, 0x3322, 0x31fd, 0x3225, 0x3328,
  0x33ff, 0x33d9, 0x33db, 0x33de, 0x33f2, 0x33fe, 0x33f4, 0x33dd,
  0x0045, 0x31fd, 0x3401, 0x33dc, 0x367d, 0x3681, 0x367e, 0x367f,
  0x36e5, 0x370f, 0x00b5, 0x370a, 0x00b6, 0x370b,
  /* 0x26 */
  0x3751, 0x3752, 0x3750, 0x37b8, 0x383d, 0x383e, 0x383c, 0x3887,
  0x38d7, 0x38db, 0x38cf, 0x38e0, 0x3a4c, 0x3a42, 0x3ad4, 0x3b11,
  0x3b14, 0x3b15, 0x3b12, 0x3b33, 0x3b35, 0x0137, 0x3b71, 0x0130,
  0x3b91, 0x3b93, 0x3b95, 0x3bdc, 0x3c42, 0x3c40, 0x82a6, 0x3ce6,
  0x438f, 0x3d32, 0x31fd, 0x3d31, 0x3df5, 0x3dcd, 0x3dde, 0x3dd5,
  0x3dda, 0x3dee, 0x3dec, 0x3dcf, 0x3dce, 0x31fd, 0x3dcc, 0x3df3,
  0x42c1, 0x42c4, 0x42c6, 0x42b4, 0x42c3, 0x42b8, 0x42bb, 0x42b7,
  0x42bc, 0x42bf, 0x42c7, 0x42be, 0x4360, 0x435d, 0x4376, 0x436c,
  0x4375, 0x435b, 0x4371, 0x4373, 0x4361, 0x435a, 0x4362, 0x4372,
  0x435f, 0x4358, 0x461e, 0x4658, 0x468b, 0x468a, 0x46f4, 0x46f0,
  0x47d2, 0x47cd, 0x47ce, 0x47bc, 0x47d0, 0x4a46, 0x4a47, 0x033e,
  0x034d, 0x0351, 0x4ace, 0x4acf, 0x4acc, 0x4acb,
  /* 0x27 */
  0x31fd, 0x4c60, 0x4c5f, 0x4c5d, 0x4cd4, 0x4d3a, 0x4d38, 0x4d3c,
  0x4d36, 0x4e08, 0x4e7e, 0x4e5e, 0x4e6e, 0x4e53, 0x4e70, 0x4e57,
  0x4e5d, 0x4e63, 0x4e7a, 0x4e79, 0x4e93, 0x31fd, 0x511d, 0x5168,
  0x5173, 0x5174, 0x5166, 0x516f, 0x5175, 0x517a, 0x5170, 0x516d,
  0x5165, 0x528a, 0x52ed, 0x52e9, 0x52e3, 0x52ef, 0x0473, 0x52ea,
  0x5431, 0x31fd, 0x5438, 0x9720, 0x5435, 0x543a, 0x5481, 0x5480,
  0x54b8, 0x54c1, 0x54ba, 0x5588, 0x55cf, 0x55ca, 0x55c7, 0x55c5,
  0x55c8, 0x55d0, 0x55c9, 0x56bb, 0x56b6, 0x56bd, 0x31fd, 0x56b4,
  0x56c1, 0x56d1, 0x56d2, 0x56cc, 0x56d4, 0x56cb, 0x56ce, 0x56d5,
  0x56d8, 0x5a95, 0x5a93, 0x5a99, 0x5a96, 0x05be, 0x5b89, 0x5b94,
  0x5b91, 0x5b8f, 0x5b84, 0x5b97, 0x5b86, 0x5b85, 0x5b8c, 0x5ff2,
  0x5fed, 0x5fef, 0x61d9, 0x6246, 0x6247, 0x624b,
  /* 0x28 */
  0x6250, 0x624a, 0x624e, 0x624c, 0x6248, 0x6463, 0x6461, 0x6462,
  0x6460, 0x64c3, 0x64c5, 0x64c1, 0x64d0, 0x31fd, 0x6882, 0x081e,
  0x6886, 0x6884, 0x694c, 0x6948, 0x69b8, 0x69bf, 0x69c1, 0x69c6,
  0x69c5, 0x69c7, 0x69c0, 0x69c3, 0x6aed, 0x6b03, 0x6b22, 0x6b21,
  0x6c9f, 0x6c90, 0x6c9e, 0x08c8, 0x6ca0, 0x6c94, 0x6c95, 0x6ca1,
  0x08c3, 0x08c7, 0x709a, 0x7090, 0x73f2, 0x73f3, 0x746e, 0x74ab,
  0x74a9, 0x751a, 0x7518, 0x751b, 0x7660, 0x764c, 0x7642, 0x7633,
  0x763f, 0x763e, 0x7638, 0x7643, 0x7646, 0x7636, 0x77ee, 0x77f5,
  0x77f4, 0x0b56, 0x7b1b, 0x0140, 0x7c2b, 0x7c29, 0x7c2a, 0x7c2e,
  0x7f3f, 0x7fe6, 0x82a7, 0x82a8, 0x8318, 0x8508, 0x8650, 0x8653,
  0x8956, 0x8955, 0x8e6f, 0x8e7f, 0x90b3, 0x923a, 0x9238, 0x9237,
  0x9236, 0x3754, 0x31fd, 0x94dd, 0x94fc, 0x94fa,
  /* 0x29 */
  0x9533, 0x9704, 0x9707, 0x9708, 0x9706, 0x9709, 0x31fd, 0x31fd,
  0x9c1e, 0x31fd, 0xac0b, 0xac43, 0xac52, 0xac58, 0xac5e, 0xae68,
  0xae8d, 0xae82, 0xae7b, 0xb258, 0x15bd, 0x31fd, 0x322c, 0x322e,
  0x470b, 0x322d, 0x3269, 0x32b2, 0x32b6, 0x32a9, 0x32ed, 0x3319,
  0x334f, 0x3416, 0x3403, 0x340e, 0x3404, 0x3407, 0x3410, 0x3427,
  0x3428, 0x340d, 0x3429, 0x340f, 0x3422, 0x3411, 0x3685, 0x3684,
  0x3683, 0x368a, 0x3686, 0x3710, 0x3758, 0x375a, 0x390c, 0x37c4,
  0x37c5, 0x3847, 0x3849, 0x384a, 0x384b, 0x52bb, 0x388d, 0x388b,
  0x3907, 0x3906, 0x31fd, 0x38ef, 0x38f0, 0x38ed, 0x38f9, 0x3902,
  0x38e7, 0x38f4, 0x38f7, 0x38f1, 0x3a53, 0x3a55, 0x011a, 0x3ada,
  0x3ad9, 0x012c, 0x3b38, 0x3b99, 0x3ba2, 0x3b9c, 0x3b9a, 0x3b9b,
  0x3be5, 0x3be3, 0x3be1, 0x3be0, 0x3be2, 0x3be4,
  /* 0x2a */
  0x31fd, 0x3be8, 0x31fd, 0x3c13, 0x3c56, 0x3c4b, 0x3c4a, 0x3c4d,
  0x3c4c, 0x0149, 0x3cea, 0x3ce9, 0x3ceb, 0x3cec, 0x3d3a, 0x3d3c,
  0x3d39, 0x3d3b, 0x3e14, 0x3e0e, 0x3e35, 0x3e0a, 0x3e3f, 0x3e38,
  0x017c, 0x3e4e, 0x3e17, 0x31fd, 0x3e1e, 0x42b6, 0x42ce, 0x42ca,
  0x42cb, 0x42cc, 0x42c9, 0x43b4, 0x43ac, 0x4388, 0x4386, 0x438c,
  0x4393, 0x438a, 0x43a4, 0x4387, 0x43a5, 0x43a6, 0x4385, 0x43a3,
  0x438e, 0x461f, 0x4663, 0x468d, 0x46fa, 0x46fb, 0x4709, 0x46fe,
  0x46ff, 0x4702, 0x4704, 0x46fd, 0x4705, 0x47f9, 0x47f7, 0x47db,
  0x47da, 0x4a51, 0x4a50, 0x4a57, 0x4ae2, 0x4ad8, 0x4ada, 0x4adc,
  0x4c20, 0x4c1f, 0x4c69, 0x4cdd, 0x4d40, 0x4d41, 0x4d43, 0x4e0d,
  0x4e0c, 0x4e87, 0x4ea9, 0x4e92, 0x4e85, 0x03bf, 0x4e8c, 0x4ea2,
  0x4e8f, 0x4e8a, 0x03ba, 0x4e8d, 0x50f1, 0x5137,
  /* 0x2b */
  0x518b, 0x5187, 0x5182, 0x528e, 0x52bc, 0x52f8, 0x52fa, 0x52eb,
  0x52f9, 0x52fc, 0x5305, 0x541b, 0x541d, 0x541e, 0x31fd, 0x543c,
  0x543e, 0x5484, 0x54c8, 0x54c9, 0x54d3, 0x54c7, 0x54d2, 0x5555,
  0x31fd, 0x558c, 0x558a, 0x55d5, 0x55d3, 0x04d8, 0x55d8, 0x56d0,
  0x56ee, 0x56f1, 0x56fb, 0x56d3, 0x56ec, 0x56cd, 0x5715, 0x5726,
  0x570e, 0x5727, 0x572a, 0x5700, 0x5704, 0x5728, 0x5708, 0x5714,
  0x5a9b, 0x05b2, 0x5aa1, 0x5a9d, 0x5aa0, 0x5a9e, 0x5aa2, 0x5a9c,
  0x5b32, 0x5b34, 0x5b93, 0x5b96, 0x5b90, 0x5bb4, 0x5bb5, 0x31fd,
  0x5bb6, 0x5bc2, 0x31fd, 0x5bba, 0x5b92, 0x5ffb, 0x6005, 0x5ff3,
  0x5ffe, 0x5ffd, 0x745d, 0x5ffa, 0x6143, 0x6195, 0x6194, 0x06c4,
  0x626f, 0x6273, 0x625c, 0x625b, 0x6266, 0x6274, 0x6263, 0x6267,
  0x6260, 0x6262, 0x6271, 0x6272, 0x625e, 0x6423,
  /* 0x2c */
  0x6426, 0x6464, 0x31fd, 0x64f2, 0x6501, 0x64dd, 0x64dc, 0x64db,
  0x64f3, 0x64fd, 0x64d8, 0x64f8, 0x64fb, 0x6883, 0x688c, 0x688e,
  0x6949, 0x6954, 0x6952, 0x694e, 0x6958, 0x6951, 0x6955, 0x6953,
  0x6957, 0x6950, 0x694f, 0x694d, 0x69d2, 0x69d3, 0x69c9, 0x69d4,
  0x6aef, 0x31fd, 0x32b1, 0x6b05, 0x6b04, 0x6b2e, 0x6b2d, 0x6c45,
  0x6c5b, 0x6c5a, 0x6c59, 0x6c9d, 0x6c8e, 0x6cbc, 0x6cdd, 0x6cba,
  0x31fd, 0x6cd8, 0x6ccb, 0x6cd9, 0x6cda, 0x6cc4, 0x6cb8, 0x6cbf,
  0x6cdb, 0x6cc1, 0x31fd, 0x6cc5, 0x31fd, 0x70b1, 0x70af, 0x31fd,
  0x73f7, 0x73f6, 0x73f8, 0x7450, 0x7451, 0x7471, 0x7470, 0x74b0,
  0x74af, 0x74ae, 0x74ad, 0x7525, 0x752c, 0x7522, 0x7533, 0x7534,
  0x0a2b, 0x763a, 0x7640, 0x7668, 0x0a61, 0x7664, 0x765c, 0x7657,
  0x7653, 0x764f, 0x7651, 0x7654, 0x7666, 0x22dd,
  /* 0x2d */
  0x0ab2, 0x780d, 0x7808, 0x31fd, 0x77fa, 0x79ea, 0x7a2a, 0x7abb,
  0x7ad5, 0x7ad7, 0x4ea4, 0x32f0, 0x32b5, 0x7b06, 0x7b28, 0x7b22,
  0x7b21, 0x5556, 0x7b23, 0x42cd, 0x7c30, 0x7c34, 0x7ec9, 0x7eca,
  0x7ec8, 0x31fd, 0x7f44, 0x7ff3, 0x31fd, 0x7ff8, 0x7ffc, 0x7ff6,
  0x7ffb, 0x7ff7, 0x8000, 0x8002, 0x31fd, 0x31fd, 0x8324, 0x850d,
  0x0d29, 0x8662, 0x8830, 0x882b, 0x882a, 0x0d92, 0x882d, 0x89da,
  0x8b28, 0x8c86, 0x8e77, 0x8e7c, 0x8f50, 0x8f4e, 0x8ff2, 0x90b2,
  0x90ce, 0x90cf, 0x90e5, 0x6507, 0x9135, 0x9131, 0x9213, 0x922b,
  0x922c, 0x9245, 0x9260, 0x9241, 0x9258, 0x9247, 0x925b, 0x9250,
  0x31fd, 0x925f, 0x924a, 0x9256, 0x9243, 0x9244, 0x9251, 0x94fd,
  0x9534, 0x9535, 0x9554, 0x9555, 0x960c, 0x960b, 0x960a, 0x96f9,
  0x9735, 0x9724, 0x9713, 0x971c, 0x9769, 0x9725,
  /* 0x2e */
  0x9721, 0x31fd, 0x31fd, 0x31fd, 0x9c20, 0x9ea9, 0x9ea8, 0x9ede,
  0x9f09, 0x9f0a, 0x9f0b, 0xa0e3, 0xa107, 0xa1b2, 0xa1b3, 0xa25d,
  0xa758, 0xa786, 0xa787, 0xa8b9, 0xa8b8, 0xac0c, 0xac44, 0xac66,
  0xac80, 0xac75, 0xac6d, 0xac7e, 0xac67, 0xac81, 0xac77, 0xaea8,
  0xaea2, 0xaea5, 0xae9b, 0xb257, 0xb40f, 0xb432, 0xb42c, 0xb433,
  0xb7e7, 0x326e, 0x32b7, 0x32f6, 0x32f2, 0x32f3, 0x3717, 0x3330,
  0x3354, 0x3353, 0x3452, 0x343d, 0x343c, 0x3434, 0x3433, 0x3454,
  0x342f, 0x0058, 0x3455, 0x343f, 0x3437, 0x3456, 0x3461, 0x3458,
  0x31fd, 0x343b, 0x3432, 0x342e, 0x343e, 0x323b, 0x368c, 0x368d,
  0x3713, 0x3716, 0x3712, 0x375b, 0x378a, 0x37d7, 0x37ce, 0x3850,
  0x3851, 0x384f, 0x388e, 0x388f, 0x38f2, 0x31fd, 0x3928, 0x391a,
  0x3925, 0x391d, 0x3914, 0x3920, 0x391f, 0x391b,
  /* 0x2f */
  0x3917, 0x3915, 0x391c, 0x3913, 0x31fd, 0x3a60, 0x011c, 0x3a66,
  0x3ae3, 0x3ade, 0x3ae0, 0x3ae1, 0x3b1a, 0x3b1b, 0x3b18, 0x3b1c,
  0x3b19, 0x3b42, 0x3b40, 0x3b3e, 0x3b44, 0x3b74, 0x3b43, 0x31fd,
  0x3bf2, 0x3c1b, 0x3c19, 0x3c1e, 0x31fd, 0x3c5e, 0x3c66, 0x3c5d,
  0x3c5a, 0x3c5f, 0x3c60, 0x3c5b, 0x3c5c, 0x3c59, 0x3cf0, 0x3cf1,
  0x3d43, 0x3d40, 0x3d42, 0x3d41, 0x3d3f, 0x3e57, 0x3e69, 0x3e6f,
  0x3eab, 0x3e71, 0x3e93, 0x3e56, 0x3e90, 0x3e6d, 0x3e6c, 0x3e70,
  0x3e66, 0x3e67, 0x42d7, 0x42b5, 0x42db, 0x42d8, 0x42d5, 0x42d4,
  0x43ba, 0x43b7, 0x43be, 0x43b9, 0x0237, 0x43e0, 0x43dd, 0x43de,
  0x7818, 0x43d8, 0x43bd, 0x43db, 0x461d, 0x4625, 0x4821, 0x480c,
  0x4829, 0x482d, 0x481b, 0x480e, 0x481f, 0x4804, 0x481c, 0x4805,
  0x4806, 0x4820, 0x480d, 0x482a, 0x4823, 0x4811,
  /* 0x30 */
  0x4a5c, 0x4a66, 0x4a5b, 0x4a4f, 0x4a5e, 0x4a5d, 0x4af1, 0x4aea,
  0x4af4, 0x4aeb, 0x4af0, 0x4afa, 0x4afb, 0x4c28, 0x4c2c, 0x4c6b,
  0x4c2a, 0x4c6a, 0x4c6f, 0x4cdb, 0x4ce0, 0x7ed1, 0x4ce3, 0x4ce5,
  0x4ce7, 0x4d4d, 0x4d55, 0x4d54, 0x4d53, 0x4d52, 0x4d4e, 0x4d60,
  0x52c0, 0x4e0f, 0x4e11, 0x4e13, 0x4ec6, 0x4eb3, 0x4ec7, 0x4ed2,
  0x4eb8, 0x4eac, 0x4eae, 0x4ecf, 0x4ec5, 0x31fd, 0x4ecc, 0x4eab,
  0x4ec9, 0x4eb9, 0x50fb, 0x50f8, 0x50f7, 0x50f9, 0x5120, 0x513b,
  0x5139, 0x519e, 0x519a, 0x51aa, 0x51ab, 0x51af, 0x5196, 0x51a9,
  0x51a6, 0x5191, 0x0443, 0x51ae, 0x519f, 0x51ac, 0x51a0, 0x5292,
  0x5291, 0x52bf, 0x5317, 0x530a, 0x530c, 0x544a, 0x5446, 0x5434,
  0x5445, 0x5443, 0x5444, 0x31fd, 0x5487, 0x5486, 0x548a, 0x54da,
  0x54d8, 0x04b4, 0x3718, 0x3334, 0x54d6, 0x54d4,
  /* 0x31 */
  0x5554, 0x5559, 0x555a, 0x5557, 0x04e0, 0x55dd, 0x55e9, 0x55e0,
  0x5705, 0x5712, 0x5713, 0x5707, 0x5716, 0x5723, 0x5702, 0x31fd,
  0x574a, 0x5736, 0x5740, 0x5756, 0x5743, 0x31fd, 0x574b, 0x5746,
  0x573e, 0x5749, 0x5aa7, 0x5ab6, 0x5aa6, 0x5aa8, 0x5aac, 0x5aa9,
  0x5aab, 0x5b38, 0x5b37, 0x5b39, 0x5b41, 0x5b3e, 0x5bc0, 0x5bbb,
  0x5bbf, 0x5bbd, 0x5bfe, 0x5c1e, 0x5bee, 0x5bfc, 0x31fd, 0x5bf9,
  0x5c06, 0x5be4, 0x5be9, 0x5be5, 0x5c03, 0x5bfd, 0x5c49, 0x5fbe,
  0x600a, 0x8526, 0x6018, 0x600d, 0x600f, 0x600e, 0x6020, 0x6171,
  0x6199, 0x61e2, 0x61df, 0x61de, 0x6278, 0x6279, 0x06e4, 0x627c,
  0x627d, 0x6284, 0x628b, 0x628a, 0x31fd, 0x6289, 0x642c, 0x6429,
  0x646c, 0x2004, 0x6509, 0x6508, 0x650c, 0x650d, 0x6510, 0x0826,
  0x689f, 0x6898, 0x68a2, 0x689a, 0x69d5, 0x69e2,
  /* 0x32 */
  0x69f0, 0x69ea, 0x69eb, 0x69ed, 0x69e8, 0x69e0, 0x6a85, 0x6a86,
  0x6af0, 0x4f46, 0x6b45, 0x6b38, 0x6b3e, 0x6b42, 0x6b40, 0x6c47,
  0x6c5c, 0x6c5e, 0x6cb4, 0x6cc2, 0x6d14, 0x6ce5, 0x6d15, 0x6d11,
  0x31fd, 0x6cee, 0x6ce7, 0x6cf5, 0x6cf4, 0x6ce8, 0x6d01, 0x6cef,
  0x6cf1, 0x31fd, 0x70db, 0x70bf, 0x70da, 0x70c7, 0x70dd, 0x31fd,
  0x70eb, 0x70e1, 0x70c1, 0x70bd, 0x7407, 0x73fd, 0x7401, 0x740a,
  0x7403, 0x7472, 0x7474, 0x7475, 0x74b2, 0x74b1, 0x74b4, 0x754c,
  0x7542, 0x7540, 0x7549, 0x753c, 0x754d, 0x754a, 0x753b, 0x7661,
  0x7674, 0x31fd, 0x767f, 0x767a, 0x7688, 0x767c, 0x0a6f, 0x7670,
  0x780f, 0x7828, 0x7813, 0x782a, 0x79ed, 0x79ef, 0x7a2e, 0x7ac1,
  0x7add, 0x3d47, 0x7b2d, 0x7b2b, 0x7b35, 0x7b2f, 0x7b31, 0x7b34,
  0x31fd, 0x7b30, 0x7c3a, 0x7c39, 0x7c37, 0x7c4b,
  /* 0x33 */
  0x7c54, 0x7c4d, 0x7c51, 0x7c47, 0x7e27, 0x7e50, 0x7e4d, 0x7e4e,
  0x7e54, 0x7ed2, 0x7ece, 0x7f4b, 0x7f49, 0x8005, 0x800f, 0x8019,
  0x31fd, 0x8006, 0x800c, 0x8029, 0x8004, 0x8008, 0x8025, 0x0c1c,
  0x8003, 0x8027, 0x8010, 0x800a, 0x31fd, 0x975d, 0x82aa, 0x82ab,
  0x82a9, 0x8341, 0x833a, 0x833c, 0x832b, 0x8349, 0x8515, 0x0d00,
  0x8516, 0x31fd, 0x8531, 0x6c4a, 0x863c, 0x867c, 0x866d, 0x866a,
  0x8663, 0x866b, 0x867b, 0x8664, 0x867a, 0x8669, 0x866f, 0x8837,
  0x8835, 0x883c, 0x8836, 0x883d, 0x883e, 0x89e1, 0x89e0, 0x8b2d,
  0x8b2b, 0x8c8d, 0x8c92, 0x0eb6, 0x8c8e, 0x31fd, 0x8c91, 0x8c96,
  0x8e7b, 0x8e78, 0x8e81, 0x8e96, 0x8ea3, 0x8e95, 0x8e97, 0x8f54,
  0x8f52, 0x8ff5, 0x9000, 0x8ffb, 0x8ff4, 0x8ff6, 0x90e8, 0x90ea,
  0x923e, 0x923d, 0x923b, 0x9280, 0x0fe4, 0x9288,
  /* 0x34 */
  0x9281, 0x9282, 0x92ce, 0x9283, 0x9277, 0x9279, 0x9273, 0x926d,
  0x9270, 0x928d, 0x9275, 0x928c, 0x926a, 0x9291, 0x9289, 0x928e,
  0x43dc, 0x94ff, 0x9559, 0x95c7, 0x9612, 0x9614, 0x9613, 0x96cb,
  0x9742, 0x10ad, 0x973d, 0x29ff, 0x9740, 0x9744, 0x9762, 0x9743,
  0x973f, 0x9745, 0x973c, 0x31fd, 0x9746, 0x9747, 0x31fd, 0x9b9e,
  0x9b9d, 0x9c2c, 0x9c29, 0x9c2f, 0x9c2e, 0x9c30, 0x9ee1, 0x9ee2,
  0x9f0e, 0x9f19, 0x9f12, 0xa1b4, 0xa4da, 0xa626, 0xa759, 0xa75a,
  0xa788, 0xa8c0, 0xa8ba, 0xaaa0, 0x31fd, 0xaaa2, 0xac86, 0x2eec,
  0xac9d, 0xac88, 0xac8f, 0xac8e, 0xac9b, 0xaec1, 0xaec3, 0xaec4,
  0xae96, 0xaec7, 0xaec6, 0xaebf, 0x14c3, 0xb10f, 0xb455, 0xb442,
  0xb446, 0xb44b, 0xb443, 0xb453, 0xb448, 0xb449, 0xb44a, 0xb44e,
  0x7ade, 0x3891, 0xba4b, 0xbc80, 0xbc81, 0xbc83,
  /* 0x35 */
  0x348a, 0xbc82, 0x5442, 0x3b22, 0x3270, 0x3271, 0x32bc, 0x4e18,
  0x32be, 0x32ba, 0x32f8, 0x3337, 0x3335, 0x3cfc, 0x3356, 0x3359,
  0x335e, 0x346d, 0x3491, 0x3492, 0x3468, 0x3466, 0x3473, 0x0067,
  0x3496, 0x348b, 0x348c, 0x3696, 0x36ee, 0x371c, 0x371a, 0x3719,
  0x371b, 0x375d, 0x375e, 0x31fd, 0x37dc, 0x37e2, 0x3852, 0x3892,
  0x3930, 0x3952, 0x3942, 0x3941, 0x3945, 0x3937, 0x3940, 0x393f,
  0x393d, 0x3938, 0x393a, 0x3949, 0x3a6b, 0x3a78, 0x3a79, 0x31fd,
  0x3a6c, 0x3ae9, 0x3ae6, 0x3ae5, 0x3aea, 0x3ae7, 0x3ae8, 0x3b1f,
  0x3b4b, 0x3b4a, 0x3b53, 0x3b76, 0x3ba3, 0x3ba4, 0x3bf6, 0x3bf3,
  0x3bf9, 0x3bf7, 0x3bfc, 0x3c1d, 0x3c6d, 0x3c71, 0x3c6c, 0x3c6e,
  0x3c70, 0x3c6f, 0x3c67, 0x3c68, 0x3cfa, 0x3cf9, 0x3d4e, 0x19de,
  0x3d4d, 0x3d4f, 0x3d4a, 0x3d4c, 0x0196, 0x31fd,
  /* 0x36 */
  0x3eee, 0x3eb2, 0x3ec0, 0x3ec1, 0x3ef4, 0x3ec8, 0x3ec5, 0x3ec6,
  0x3ead, 0x42e2, 0x42ea, 0x42e3, 0x42e1, 0x43f7, 0x4401, 0x4412,
  0x43f6, 0x43f1, 0x441f, 0x43ee, 0x31fd, 0x43f3, 0x4415, 0x4416,
  0x4417, 0x43f8, 0x4419, 0x43f2, 0x43f4, 0x43f5, 0x4413, 0x4406,
  0x4626, 0x4624, 0x465a, 0x5fc8, 0x4697, 0x4695, 0x469a, 0x471f,
  0x3cfb, 0x4729, 0x4720, 0x31fd, 0x31fd, 0x484c, 0x4830, 0x4838,
  0x483d, 0x4851, 0x484f, 0x484a, 0x4834, 0x4836, 0x1b30, 0x4a6a,
  0x4a68, 0x4b1c, 0x4b0e, 0x4b1e, 0x0359, 0x4b09, 0x4b08, 0x4b13,
  0x4b01, 0x4b0f, 0x4b14, 0x4b06, 0x4b07, 0x1cb2, 0x31fd, 0x0376,
  0x4c79, 0x4cea, 0x4ced, 0x4ce9, 0x4cee, 0x4d68, 0x4d64, 0x4d67,
  0x4d72, 0x4d62, 0x4d74, 0x4d79, 0x4e19, 0x4e17, 0x4e15, 0x4e16,
  0x4ee6, 0x8ea4, 0x4eee, 0x03d2, 0x4edf, 0x4ee4,
  /* 0x37 */
  0x4eda, 0x4eea, 0x4eed, 0x4ee3, 0x4ee9, 0x50fd, 0x3857, 0x5121,
  0x51c6, 0x51b8, 0x51cb, 0x31fd, 0x51bd, 0x51b5, 0x51bb, 0x51bf,
  0x51be, 0x51b2, 0x51c1, 0x51c2, 0x5299, 0x52c6, 0x532c, 0x532d,
  0x5325, 0x531e, 0x531f, 0x5323, 0x5450, 0x544e, 0x544d, 0x5452,
  0x54e9, 0x54ec, 0x54e8, 0x5558, 0x555c, 0x555b, 0x558f, 0x6972,
  0x55f6, 0x5600, 0x55fc, 0x55f8, 0x55ea, 0x55fe, 0x55f7, 0x55fd,
  0x5770, 0x5762, 0x5744, 0x0520, 0x574d, 0x574c, 0x573f, 0x5766,
  0x5735, 0x0529, 0x5734, 0x578d, 0x5784, 0x0538, 0x5786, 0x5789,
  0x5787, 0x5783, 0x5775, 0x5779, 0x57af, 0x57b0, 0x5ab7, 0x5abb,
  0x5ab9, 0x5b46, 0x5b47, 0x5b45, 0x5bea, 0x5bf6, 0x5c68, 0x5c39,
  0x31fd, 0x5c3d, 0x5c3b, 0x5c4d, 0x5c30, 0x5c4a, 0x5c3e, 0x5c40,
  0x5c4c, 0x5c47, 0x5c38, 0x5c52, 0x5c3a, 0x5c53,
  /* 0x38 */
  0x5fc4, 0x5fc1, 0x601c, 0x601d, 0x602a, 0x601e, 0x602f, 0x6022,
  0x602e, 0x6025, 0x0689, 0x06b0, 0x614a, 0x614b, 0x6176, 0x06bf,
  0x61e8, 0x61ef, 0x61e9, 0x06c5, 0x61ea, 0x31fd, 0x06ea, 0x629b,
  0x629e, 0x6293, 0x62a7, 0x629c, 0x62a0, 0x629a, 0x62ab, 0x62be,
  0x62a9, 0x642d, 0x646e, 0x6544, 0x653d, 0x653a, 0x6568, 0x653c,
  0x656a, 0x31fd, 0x6538, 0x6565, 0x6539, 0x656d, 0x6536, 0x31fd,
  0x653e, 0x657e, 0x6537, 0x6899, 0x68a9, 0x68ad, 0x68a7, 0x68a8,
  0x6966, 0x6969, 0x696d, 0x6967, 0x696b, 0x696a, 0x69ee, 0x6a01,
  0x6a03, 0x69f4, 0x69fb, 0x0837, 0x69f6, 0x69fc, 0x6af4, 0x6b08,
  0x6b0a, 0x6b09, 0x6b6d, 0x6b62, 0x6b41, 0x6b5e, 0x6b5c, 0x6cf3,
  0x6d26, 0x08e4, 0x6d39, 0x31fd, 0x6d6c, 0x6d2b, 0x6d2e, 0x6d3b,
  0x6d5e, 0x6dfb, 0x6d27, 0x6d24, 0x6d69, 0x6d30,
  /* 0x39 */
  0x31fd, 0x6d62, 0x6d38, 0x6d35, 0x6d2a, 0x6d2c, 0x6d68, 0x6d31,
  0x6d2f, 0x6d2d, 0x6d3a, 0x6d36, 0x31fd, 0x6d21, 0x6d3c, 0x6d20,
  0x6d64, 0x6d3e, 0x08e8, 0x70f7, 0x7112, 0x70f1, 0x70f5, 0x7122,
  0x70f2, 0x70df, 0x7115, 0x7116, 0x747a, 0x7476, 0x74be, 0x0a20,
  0x74bd, 0x7509, 0x7508, 0x7557, 0x76a3, 0x76bf, 0x76b8, 0x76af,
  0x769c, 0x76a5, 0x7672, 0x7675, 0x769d, 0x7699, 0x76b9, 0x784e,
  0x7839, 0x783b, 0x7835, 0x783c, 0x7855, 0x79f0, 0x79f3, 0x79f4,
  0x7a3b, 0x7a3c, 0x7a3a, 0x7a36, 0x7b07, 0x3eeb, 0x7b55, 0x7b50,
  0x7b4f, 0x7b52, 0x7b56, 0x32bd, 0x7b32, 0x7c63, 0x7c6b, 0x7c66,
  0x7c57, 0x7c5d, 0x0b86, 0x7c6d, 0x7c61, 0x7c69, 0x7c5a, 0x7c5c,
  0x7c62, 0x7e2a, 0x7e29, 0x7e58, 0x7e5a, 0x7ed7, 0x7edb, 0x7edc,
  0x7edd, 0x7ed8, 0x7f54, 0x7f5b, 0x7f5c, 0x7f53,
  /* 0x3a */
  0x7f4f, 0x7f56, 0x7f50, 0x7f5a, 0x7f6b, 0x8036, 0x8053, 0x803a,
  0x803c, 0x803e, 0x8049, 0x8040, 0x31fd, 0x31fd, 0x8264, 0x8265,
  0x82b5, 0x82b6, 0x82b2, 0x8348, 0x834a, 0x8372, 0x8369, 0x835a,
  0x834c, 0x852c, 0x8530, 0x854b, 0x8549, 0x8542, 0x8544, 0x854a,
  0x854f, 0x8692, 0x31fd, 0x8697, 0x8680, 0x8682, 0x8686, 0x8853,
  0x885e, 0x8852, 0x885b, 0x884e, 0x896d, 0x896e, 0x89fa, 0x89f6,
  0x89fb, 0x8b33, 0x8b3d, 0x8b37, 0x8b3e, 0x8b35, 0x8c9a, 0x8cab,
  0x8ca6, 0x8cb0, 0x8c99, 0x8ca0, 0x8c9e, 0x8ca8, 0x8ca1, 0x8caa,
  0x8cad, 0x8cbb, 0x8c9c, 0x8ca5, 0x32b3, 0x8e27, 0x8e8d, 0x8e8e,
  0x8e8f, 0x8e92, 0x0f56, 0x8e91, 0x8ead, 0x8f57, 0x8f58, 0x8f5e,
  0x8f5d, 0x8f5c, 0x8f5b, 0x0f67, 0x900a, 0x9003, 0x900e, 0x90b8,
  0x914d, 0x913f, 0x9147, 0x914b, 0x914a, 0x913d,
  /* 0x3b */
  0x2738, 0x9141, 0x914c, 0x2781, 0x9262, 0x9269, 0x9261, 0x0fd1,
  0x92aa, 0x92a6, 0x92ac, 0x92bd, 0x92bb, 0x92a4, 0x92ba, 0x929a,
  0x0feb, 0x92a1, 0x92c1, 0x94e0, 0x950a, 0x9503, 0x9506, 0x9539,
  0x953a, 0x9536, 0x955b, 0x955f, 0x955e, 0x9567, 0x9561, 0x9562,
  0x955d, 0x95ca, 0x95cc, 0x95ce, 0x9618, 0x961d, 0x961f, 0x9620,
  0x9617, 0x9615, 0x971f, 0x9727, 0x9726, 0x4f10, 0x978b, 0x97ae,
  0x978a, 0x31fd, 0x9792, 0x9789, 0x9787, 0x10b6, 0x978f, 0x9784,
  0x9783, 0x978c, 0x9793, 0x978d, 0x9798, 0x977d, 0x977e, 0x97d2,
  0x9780, 0x9799, 0x9bac, 0x9c50, 0x9c55, 0x9c42, 0x9c3f, 0x9c3c,
  0x11a3, 0x9c4c, 0x9c49, 0x9c57, 0x9c58, 0x9c4f, 0x9c5c, 0x9c47,
  0x31fd, 0x9eab, 0x1210, 0x9eaf, 0x9ead, 0x9ee8, 0x9ee7, 0x9f30,
  0x9f26, 0x9f2f, 0x9f28, 0x9f2b, 0x9f1d, 0x9f2d,
  /* 0x3c */
  0x9f20, 0x9f2a, 0x9f2c, 0x9f35, 0x9f21, 0x9f23, 0x9f24, 0x9f36,
  0x9f37, 0xa0e9, 0xa1ba, 0xa1b8, 0x31fd, 0xa26d, 0xa26a, 0xa268,
  0xa269, 0xa26b, 0xa261, 0xa4dc, 0xa4db, 0xa52d, 0xa52c, 0xa5a2,
  0xa62b, 0xa632, 0x31fd, 0xa794, 0xa792, 0xa790, 0xa8c9, 0xa8c4,
  0xa8c1, 0xa8c3, 0xa8cd, 0xaa14, 0xaaa7, 0xaaaf, 0xaaaa, 0xac0d,
  0xac54, 0xac5b, 0xac61, 0xacae, 0xacb3, 0xacc0, 0xacc4, 0xacbf,
  0xaccb, 0xacad, 0xaca7, 0xaca4, 0xacbd, 0xacaf, 0xacb2, 0xaca5,
  0xaee7, 0xaee0, 0xaece, 0xaede, 0xaed5, 0xaedf, 0xaed9, 0xaff2,
  0xb123, 0xb140, 0x151b, 0xb13e, 0x1587, 0xb2cf, 0x3d54, 0xb45b,
  0xb458, 0xb462, 0xb45f, 0xb467, 0xb463, 0xb45e, 0xb460, 0xb585,
  0xb586, 0xb587, 0xb7e8, 0xb7e6, 0xbc71, 0xbc85, 0x31fd, 0xbc86,
  0xbd10, 0x3bf8, 0x32bf, 0x3d61, 0x32fe, 0x32fc,
  /* 0x3d */
  0x3339, 0x3361, 0x3360, 0x34e2, 0x34ea, 0x34e3, 0x34b4, 0x34ae,
  0x34be, 0x34b8, 0x34a8, 0x34aa, 0x34a9, 0x34b3, 0x34d5, 0x34ad,
  0x34b9, 0x34bb, 0x34b1, 0x34c2, 0x31fd, 0x34eb, 0x34ba, 0x34d2,
  0x34d4, 0x36f1, 0x371d, 0x31fd, 0x3762, 0x378c, 0x37e6, 0x37e7,
  0x385a, 0x3858, 0x3859, 0x3896, 0x3897, 0x3961, 0x3967, 0x3971,
  0x3965, 0x397d, 0x397e, 0x3a7d, 0x3a84, 0x3a7c, 0x3a7e, 0x3a7f,
  0x3a80, 0x3aef, 0x3af4, 0x3b1e, 0x3b4e, 0x3bfb, 0x3bfa, 0x3bfd,
  0x31fd, 0x31fd, 0x3c79, 0x3c7c, 0x3c7d, 0x3c84, 0x3c7b, 0x3c78,
  0x0157, 0x3d5e, 0x3d5a, 0x3d5c, 0x3d59, 0x3d55, 0x3d63, 0x3d56,
  0x3d5f, 0x3d60, 0x3d5b, 0x3f4a, 0x3f65, 0x3fb3, 0x3f2c, 0x3f77,
  0x3f3d, 0x3f52, 0x3f61, 0x3f2a, 0x3f3e, 0x3f34, 0x3f29, 0x3fb2,
  0x3fad, 0x3f40, 0x3f53, 0x31fd, 0x3f3f, 0x3f41,
  /* 0x3e */
  0x3f72, 0x42f6, 0x42f5, 0x42f4, 0x42f2, 0x42f9, 0x4427, 0x4454,
  0x4455, 0x442e, 0x31fd, 0x31fd, 0x442c, 0x4438, 0x4439, 0x4431,
  0x444f, 0x4473, 0x4430, 0x442b, 0x4451, 0x462c, 0x465b, 0x465c,
  0x4668, 0x466c, 0x466b, 0x4669, 0x469f, 0x4738, 0x473c, 0x473a,
  0x4735, 0x029d, 0x4739, 0x4736, 0x473b, 0x4860, 0x4861, 0x4863,
  0x4864, 0x4894, 0x4893, 0x485e, 0x4868, 0x486a, 0x4865, 0x31fd,
  0x4890, 0x485f, 0x4872, 0x31fd, 0x4b3c, 0x4b27, 0x4b24, 0x4b26,
  0x4b25, 0x035f, 0x4b28, 0x4b36, 0x4c31, 0x4c30, 0x4c34, 0x4c81,
  0x4c7d, 0x4c82, 0x4c80, 0x0379, 0x34d3, 0x4cf2, 0x4d66, 0x4d8c,
  0x4d7b, 0x4d83, 0x0398, 0x4d8e, 0x4d7a, 0x4d92, 0x4d91, 0x4d82,
  0x4e1b, 0x4e1c, 0x4f27, 0x4f21, 0x03dc, 0x31fd, 0x4f43, 0x03df,
  0x4f18, 0x4f7b, 0x4f1a, 0x4f4b, 0x4f4a, 0x4f4d,
  /* 0x3f */
  0x4f4f, 0x4f19, 0x4f35, 0x4f13, 0x4f52, 0x4f14, 0x4f1e, 0x4f2c,
  0x4f20, 0x4f22, 0x4f12, 0x4f1f, 0x5100, 0x5123, 0x5140, 0x5143,
  0x51e4, 0x51db, 0x51ea, 0x51dd, 0x51cc, 0x51d9, 0x51e8, 0x51f6,
  0x51e3, 0x51d3, 0x51da, 0x51d6, 0x51e7, 0x533a, 0x533f, 0x5340,
  0x5348, 0x5359, 0x5337, 0x5344, 0x31fd, 0x31fd, 0x5355, 0x5339,
  0x5454, 0x5455, 0x5456, 0x5457, 0x5458, 0x5459, 0x548d, 0x54f2,
  0x54f8, 0x54f5, 0x54f6, 0x54fc, 0x54fe, 0x54f1, 0x54fd, 0x555e,
  0x5596, 0x5597, 0x559c, 0x559b, 0x5595, 0x31fd, 0x561a, 0x5609,
  0x5604, 0x560e, 0x561c, 0x5618, 0x560d, 0x5610, 0x560c, 0x5603,
  0x577b, 0x57a6, 0x5777, 0x5788, 0x5774, 0x57da, 0x5776, 0x5778,
  0x578a, 0x578f, 0x577d, 0x5790, 0x57ed, 0x57d9, 0x57d0, 0x581a,
  0x57d7, 0x57e2, 0x57e1, 0x57c5, 0x57e0, 0x57ca,
  /* 0x40 */
  0x5825, 0x57cc, 0x31fd, 0x5ac6, 0x5ac1, 0x5b4d, 0x5c4b, 0x5c64,
  0x5c95, 0x5c99, 0x31fd, 0x5c94, 0x5ca2, 0x5cae, 0x5c9e, 0x5ca7,
  0x5c86, 0x05fd, 0x5ca4, 0x5c91, 0x5c93, 0x31fd, 0x5c88, 0x5fcd,
  0x5fca, 0x603f, 0x6040, 0x6046, 0x6041, 0x6045, 0x6058, 0x603b,
  0x6048, 0x614e, 0x6152, 0x614f, 0x617b, 0x617a, 0x61a0, 0x619f,
  0x61fb, 0x61f7, 0x62b8, 0x62b9, 0x62bb, 0x62b7, 0x06f4, 0x62ba,
  0x06ef, 0x62da, 0x62b5, 0x62bf, 0x62bc, 0x62c0, 0x31fd, 0x31fd,
  0x6475, 0x6479, 0x6476, 0x6535, 0x6540, 0x65c0, 0x6581, 0x65ad,
  0x65af, 0x65ac, 0x658f, 0x65a8, 0x65aa, 0x65a9, 0x6588, 0x657f,
  0x6580, 0x65bc, 0x68ae, 0x68bb, 0x68bd, 0x0831, 0x6978, 0x6974,
  0x6a0c, 0x6a11, 0x6a08, 0x6a06, 0x6a10, 0x6a8f, 0x6a90, 0x6a8d,
  0x6a8e, 0x6a96, 0x6a95, 0x6b0b, 0x6b0c, 0x6b7c,
  /* 0x41 */
  0x6b73, 0x6b75, 0x6b76, 0x6b7d, 0x6b78, 0x6b71, 0x6c4b, 0x6c4e,
  0x6d33, 0x6d32, 0x0903, 0x6d91, 0x6de7, 0x6de9, 0x6da2, 0x6d94,
  0x6d87, 0x6da3, 0x6ddd, 0x6d7b, 0x6d83, 0x6d81, 0x6ddf, 0x6d7c,
  0x6de4, 0x6de2, 0x6d93, 0x6d7d, 0x6dbf, 0x6d9b, 0x6d8e, 0x6d9f,
  0x0909, 0x6d8c, 0x6d7f, 0x6d9c, 0x6d84, 0x6d42, 0x6de6, 0x7151,
  0x714a, 0x7164, 0x7125, 0x712f, 0x712e, 0x712b, 0x7128, 0x7132,
  0x712d, 0x7131, 0x7139, 0x712c, 0x7161, 0x7411, 0x7410, 0x7412,
  0x7453, 0x7455, 0x747b, 0x7481, 0x747d, 0x747c, 0x74c2, 0x74c5,
  0x31fd, 0x74c4, 0x31fd, 0x756b, 0x7568, 0x0a3e, 0x755c, 0x755d,
  0x756a, 0x31fd, 0x7b76, 0x7676, 0x0a77, 0x76c4, 0x76cb, 0x76c8,
  0x76d4, 0x76d5, 0x76c9, 0x76d7, 0x0a7b, 0x7878, 0x785a, 0x785b,
  0x785c, 0x7856, 0x7858, 0x7871, 0x95d4, 0x7a40,
  /* 0x42 */
  0x31fd, 0x7a3f, 0x7a43, 0x7a41, 0x7ae2, 0x7ae0, 0x7ae3, 0x7b66,
  0x7b73, 0x7b6c, 0x7b71, 0x7b6a, 0x7b6d, 0x7b6e, 0x7b6b, 0x7c8c,
  0x7c77, 0x31fd, 0x7c7f, 0x7c89, 0x7c7a, 0x7c85, 0x7c78, 0x7c8a,
  0x7c86, 0x7e2c, 0x7e67, 0x7e5b, 0x7ee5, 0x7ee1, 0x7f61, 0x7f69,
  0x7f6a, 0x8065, 0x806d, 0x8063, 0x8086, 0x805c, 0x8062, 0x31fd,
  0x8079, 0x8069, 0x8070, 0x8076, 0x805d, 0x8087, 0x806e, 0x8071,
  0x807c, 0x8073, 0x805b, 0x806b, 0x82bf, 0x82c1, 0x82bd, 0x82c9,
  0x82bc, 0x82c2, 0x82c0, 0x8392, 0x83a9, 0x838f, 0x8376, 0x837b,
  0x8375, 0x83a4, 0x8564, 0x863d, 0x86af, 0x0d3a, 0x31fd, 0x869d,
  0x8699, 0x86b1, 0x8863, 0x8862, 0x8864, 0x8869, 0x0da0, 0x8975,
  0x8973, 0x8971, 0x8974, 0x8a0c, 0x8a16, 0x0de5, 0x8a11, 0x8a1f,
  0x8a1a, 0x8a0d, 0x8a1b, 0x8a13, 0x8b4e, 0x8b55,
  /* 0x43 */
  0x8b50, 0x0e7d, 0x8cd2, 0x8cd3, 0x8cd1, 0x8cf1, 0x8cdc, 0x8cc8,
  0x8ccc, 0x8cd0, 0x8ccf, 0x8cdf, 0x8e2b, 0x8e2e, 0x8e2d, 0x8e9d,
  0x8e9e, 0x8e9f, 0x8ea9, 0x8ea0, 0x8e98, 0x8ea1, 0x8eab, 0x8eaf,
  0x8f6e, 0x8f5f, 0x8f5a, 0x0f6d, 0x8f65, 0x8f68, 0x8f72, 0x9017,
  0x9016, 0x9018, 0x9019, 0x901a, 0x9022, 0x901b, 0x901c, 0x90be,
  0x90ee, 0x915a, 0x9150, 0x9158, 0x9154, 0x9157, 0x9156, 0x9215,
  0x929b, 0x9293, 0x9292, 0x9272, 0x9298, 0x9299, 0x92df, 0x0ff8,
  0x92d5, 0x2858, 0x92d4, 0x92f3, 0x92f4, 0x92e7, 0x92e1, 0x92e6,
  0x92eb, 0x92ec, 0x34db, 0x1050, 0x950d, 0x950c, 0x4c2f, 0x9568,
  0x9565, 0x956b, 0x9569, 0x95d1, 0x95d3, 0x9627, 0x9628, 0x1068,
  0x1067, 0x9624, 0x96d7, 0x97ca, 0x97c7, 0x31fd, 0x97d8, 0x97e1,
  0x97c6, 0x97f8, 0x97c3, 0x97f4, 0x9817, 0x97ea,
  /* 0x44 */
  0x97cb, 0x9786, 0x97c4, 0x97d9, 0x9819, 0x97c2, 0x97e2, 0x10cf,
  0x97de, 0x97ed, 0x31fd, 0x10cd, 0x981d, 0x97dd, 0x97db, 0x97e8,
  0x97e9, 0x97bf, 0x97e0, 0x97d1, 0x97dc, 0x97ce, 0x981e, 0x97cc,
  0x97f2, 0x97f3, 0x31fd, 0x31fd, 0x31fd, 0x31fd, 0x9bab, 0x9baa,
  0x9ba7, 0x9ba9, 0x9c88, 0x9c75, 0x9c60, 0x9c6c, 0x9c73, 0x11ab,
  0x9c6e, 0x9c74, 0x9c76, 0x9c68, 0x9c77, 0x9c86, 0x9eea, 0x9f51,
  0x9f50, 0x9f58, 0x9f4d, 0x9f4f, 0x9f4e, 0x9f5c, 0x9f52, 0x9f44,
  0x9f4a, 0x9f4b, 0xa0ea, 0xa110, 0xa111, 0xa1cd, 0xa1bf, 0xa1c4,
  0xa1d0, 0xa1ce, 0xa1c0, 0xa1c2, 0xa1cf, 0xa1c9, 0xa1bb, 0xa297,
  0xa292, 0xa26f, 0xa27e, 0xa29a, 0x12c1, 0xa286, 0xa273, 0x2c24,
  0xa277, 0xa28f, 0xa270, 0xa281, 0xa282, 0xa299, 0xa27d, 0xa27f,
  0xa27b, 0xa287, 0xa4b2, 0xa52f, 0xa534, 0xa52e,
  /* 0x45 */
  0xa532, 0x1347, 0xa5aa, 0x1357, 0xa5a9, 0xa638, 0xa636, 0xa637,
  0xa647, 0xa633, 0xa639, 0xa635, 0xa644, 0xa7a5, 0xa7a6, 0xa79e,
  0xa8e3, 0xa8df, 0xa8d3, 0xa8f1, 0xa8e4, 0xa8e0, 0xa8d6, 0x2dc3,
  0xa8e6, 0xa8d8, 0xa8de, 0xa8db, 0xa8dc, 0xaa1b, 0xaa1f, 0xaa1d,
  0xaa1c, 0xaa1e, 0xaa20, 0xaa21, 0x144e, 0xaab6, 0xaabc, 0xaac6,
  0xaac7, 0xaaba, 0xaabe, 0xaabd, 0xaab5, 0xaab4, 0xac0f, 0xac62,
  0xaceb, 0xacd9, 0xace4, 0xacd7, 0xacd8, 0xacd6, 0xacce, 0xacdd,
  0xace7, 0xacd2, 0xacc5, 0xacc9, 0xacdb, 0xae92, 0xae8a, 0xae8b,
  0xae89, 0xaf08, 0xaf03, 0xaf06, 0xaf05, 0xaef5, 0xaf0b, 0xaefb,
  0xaffc, 0xb001, 0xb002, 0xaffa, 0xb008, 0xaff7, 0xb000, 0xafff,
  0xb006, 0xaff6, 0xaffb, 0xb00a, 0xb125, 0xb143, 0xb144, 0xb264,
  0xb262, 0xb25e, 0xb25b, 0xb2d6, 0x3272, 0x32c2,
  /* 0x46 */
  0xb477, 0xb482, 0xb47c, 0xb47d, 0xb486, 0xb481, 0xb484, 0xb476,
  0xb483, 0xb47f, 0xb47e, 0xb588, 0xb58d, 0xb58b, 0xb591, 0xb58f,
  0xb67c, 0xb679, 0xb67a, 0xb7ea, 0xba4c, 0xbb99, 0x34d1, 0xbc8b,
  0xbc8d, 0xbc8a, 0xbc8e, 0xbd11, 0x5356, 0x31fd, 0x3274, 0x32c3,
  0x32c4, 0x331b, 0x335f, 0x336a, 0x3369, 0x336b, 0x350c, 0x34f6,
  0x34ed, 0x3529, 0x34fe, 0x34f1, 0x3517, 0x34ff, 0x34ee, 0x34fd,
  0x351c, 0x34fc, 0x3500, 0x3520, 0x0077, 0x34f9, 0x3567, 0x3508,
  0x369e, 0x36f3, 0x3725, 0x3727, 0x371f, 0x3765, 0x3763, 0x3794,
  0x3797, 0x37f1, 0x385f, 0x3862, 0x18f2, 0x3860, 0x31fd, 0x398c,
  0x3982, 0x3990, 0x398b, 0x398d, 0x3981, 0x399d, 0x3a8e, 0x3a8f,
  0x3a92, 0x3b23, 0x3b52, 0x31fd, 0x3c00, 0x3c01, 0x3c02, 0x3c1f,
  0x3c8c, 0x3c89, 0x3c8b, 0x3c88, 0x3c8d, 0x3c8f,
  /* 0x47 */
  0x8f85, 0x3d00, 0x3d05, 0x3d01, 0x3d68, 0x3d6e, 0x3d67, 0x3d75,
  0x1ab6, 0x31fd, 0x3fd7, 0x31fd, 0x3248, 0x3fd4, 0x3fd8, 0x31fd,
  0x31fd, 0x3fba, 0x31fd, 0x3fdb, 0x3fbf, 0x4035, 0x3fbc, 0x3fd9,
  0x01c4, 0x3fdd, 0x4000, 0x3fd5, 0x4030, 0x3fbd, 0x3fdc, 0x42fd,
  0x42fe, 0x4307, 0x7417, 0x446f, 0x4469, 0x4470, 0x4467, 0x44a9,
  0x4495, 0x4490, 0x446c, 0x4497, 0x4471, 0x0252, 0x4474, 0x446d,
  0x448e, 0x462f, 0xc51b, 0x46a9, 0x474e, 0x31fd, 0x475a, 0x4748,
  0x4755, 0x474c, 0x4749, 0x474f, 0x474a, 0x48d6, 0x48a0, 0x48a9,
  0x31fd, 0x489d, 0x48d4, 0x48a4, 0x48a8, 0x48a6, 0x48e6, 0x4a7d,
  0x4a77, 0x4a7a, 0x4b41, 0x4b49, 0x4b59, 0x4b45, 0x4b48, 0x4b40,
  0x4c8e, 0x4c95, 0x4c90, 0x4cf7, 0x4cf8, 0x4cf6, 0x4cfb, 0x4d9e,
  0x4d9d, 0x4d99, 0x31fd, 0x4da3, 0x4da9, 0x4d98,
  /* 0x48 */
  0x4da0, 0x4d96, 0x4d94, 0x4d95, 0x4d9f, 0x4da1, 0x4e21, 0x4e1d,
  0x4e1f, 0x4f6d, 0x31fd, 0x4f9a, 0x4f92, 0x4f7a, 0x4f7d, 0x4fa1,
  0x4f9d, 0x4f99, 0x4f6b, 0x4f6e, 0x31fd, 0x5145, 0x31fd, 0x51fb,
  0x51eb, 0x51f2, 0x51f9, 0x31fd, 0x51f8, 0x51ed, 0x5201, 0x51f7,
  0x5206, 0x529b, 0x52ca, 0x046b, 0x1dc3, 0x536b, 0x536c, 0x5374,
  0x5367, 0x535b, 0x5360, 0x5376, 0x5363, 0x5361, 0x5428, 0x545b,
  0x545e, 0x5460, 0x545d, 0x545c, 0x54f4, 0x5500, 0x5508, 0x5507,
  0x5501, 0x5505, 0x5564, 0x5563, 0x559e, 0x55a0, 0x55a1, 0x559f,
  0x5626, 0x562d, 0x5628, 0x561d, 0x57ec, 0x57e3, 0x57eb, 0x5816,
  0x57c8, 0x921b, 0x57e9, 0x57e4, 0x5824, 0x57d1, 0x0541, 0x57dd,
  0x57c2, 0x57cb, 0x57c7, 0x57e7, 0x0550, 0x57ea, 0x584b, 0x31fd,
  0x5860, 0x587d, 0x583e, 0x31fd, 0x5852, 0x584e,
  /* 0x49 */
  0x583c, 0x5832, 0x5830, 0x5823, 0x5aca, 0x5acb, 0x5ac9, 0x5ac8,
  0x5acd, 0x5c98, 0x5ca0, 0x5c9f, 0x5c9c, 0x5ca3, 0x5c97, 0x31fd,
  0x5cf1, 0x5d09, 0x5d03, 0x5cea, 0x5d45, 0x5ced, 0x5d05, 0x5d1a,
  0x5d15, 0x5d01, 0x5cec, 0x5d0e, 0x5d17, 0x5d42, 0x5d12, 0x5d10,
  0x5cef, 0x5cff, 0x5d00, 0x5d0c, 0x5d0f, 0x5d04, 0x5d08, 0x5d14,
  0x5d43, 0x31fd, 0x5d1b, 0x5d11, 0x5d13, 0x5fcf, 0x5fce, 0x606f,
  0x606e, 0x607a, 0x6070, 0x6064, 0x605e, 0x606c, 0x31fd, 0x605b,
  0x6061, 0x6065, 0x617f, 0x6180, 0x617c, 0x61a7, 0x61a6, 0x61a1,
  0x06c0, 0x61a8, 0x61a3, 0x61a2, 0x61ad, 0x61a5, 0x6201, 0x61ff,
  0x61fc, 0x6200, 0x6235, 0x62ee, 0x62ef, 0x62f6, 0x62e8, 0x62ea,
  0x62e3, 0x631f, 0x06fc, 0x62e4, 0x62fa, 0x62f1, 0x62fb, 0x31fd,
  0x643d, 0x643c, 0x0079, 0x6478, 0x6477, 0x100b,
  /* 0x4a */
  0x65d1, 0x65c7, 0x65df, 0x65d0, 0x65e0, 0x65d6, 0x65d8, 0x6616,
  0x660e, 0x65d9, 0x660f, 0x6611, 0x65cd, 0x6589, 0x65ce, 0x6614,
  0x65da, 0x6612, 0x65d3, 0x65c2, 0x65e1, 0x65e9, 0x65ea, 0x65de,
  0x6615, 0x68d9, 0x68d6, 0x68cd, 0x68d0, 0x68d3, 0x31fd, 0x6982,
  0x6985, 0x697f, 0x697d, 0x6981, 0x6983, 0x6984, 0xaca0, 0x6a28,
  0x6a0f, 0x6a17, 0x6a1a, 0x6a25, 0x31fd, 0x6a9b, 0x6a99, 0x6b92,
  0x6b8c, 0x6b95, 0x6b8d, 0x6ba3, 0x6b93, 0x6b91, 0x6ddb, 0x6d99,
  0x6d9a, 0x6e08, 0x6e4c, 0x6e0d, 0x6e01, 0x6e4e, 0x6e02, 0x6e4d,
  0x6e21, 0x6dfc, 0x31fd, 0x6d8a, 0x31fd, 0x6d95, 0x6e11, 0x6e12,
  0x6e46, 0x6e1c, 0x6e49, 0x6e0c, 0x091e, 0x6e13, 0x6e16, 0x6dfd,
  0x6e0f, 0x6e1f, 0x7130, 0x716e, 0x716b, 0x719b, 0x717b, 0x7163,
  0x7197, 0x716d, 0x719c, 0x7198, 0x716f, 0x7167,
  /* 0x4b */
  0x7169, 0x7415, 0x7463, 0x7486, 0x748a, 0x7487, 0x7488, 0x7485,
  0x7489, 0x74ca, 0x74c7, 0x74cb, 0x74cc, 0x74c9, 0x750d, 0x7583,
  0x7584, 0x7578, 0x7582, 0x7573, 0x7579, 0x758c, 0x76d0, 0x76cf,
  0x76d2, 0x76d9, 0x76cc, 0x76eb, 0x76fd, 0x76ec, 0x76e8, 0x76f8,
  0x76fa, 0x31fd, 0x0a85, 0x76e1, 0x76fb, 0x77e7, 0x31fd, 0x78a5,
  0x7891, 0x78a6, 0x787c, 0x7892, 0x78a2, 0x78a0, 0x79fc, 0x79fe,
  0x7a57, 0x7a53, 0x7a58, 0x7ae7, 0x7b8e, 0x31fd, 0x7b83, 0x7b8b,
  0x7b84, 0x0b97, 0x7ca2, 0x7cb7, 0x7ca9, 0x7ca5, 0x7c9f, 0x7caa,
  0x7c97, 0x7ca1, 0x7c9e, 0x7cab, 0x7c99, 0x7ca3, 0x7e30, 0x7e32,
  0x7e2f, 0x7e70, 0x7e6c, 0x7e6f, 0x7ee8, 0x7eee, 0x7eea, 0x7f6d,
  0x7f76, 0x7f70, 0x7f71, 0x7f6c, 0x80eb, 0x80b5, 0x8096, 0x8090,
  0x808d, 0x31fd, 0x80a2, 0x80b0, 0x8092, 0x80a0,
  /* 0x4c */
  0x8093, 0x80c3, 0x808e, 0x80b6, 0x809d, 0x8095, 0x80b3, 0x80a4,
  0x8270, 0x82d4, 0x0c93, 0x82cf, 0x3370, 0x8394, 0x2461, 0x83c0,
  0x83b4, 0x83c1, 0x0cb2, 0x83bd, 0x83af, 0x8577, 0x8578, 0x856b,
  0x856d, 0x856e, 0x8572, 0x856f, 0x8571, 0x61ab, 0x858c, 0x863f,
  0x86b6, 0x86b7, 0x31fd, 0x86bb, 0x86b8, 0x399c, 0x86b9, 0x2501,
  0x888b, 0x887a, 0x8884, 0x8888, 0x8891, 0x8879, 0x888e, 0x8880,
  0x8882, 0x887c, 0x0da4, 0x8984, 0x897f, 0x0df2, 0x8a3b, 0x8a71,
  0x8a3d, 0x8a30, 0x0df1, 0x8a3e, 0x8a38, 0x8b5e, 0x8b64, 0x0e81,
  0x8b5d, 0x8b6d, 0x8b4f, 0x8b62, 0x8b5f, 0x8cec, 0x8cf2, 0x8cf4,
  0x8cf7, 0x8cf6, 0x8d07, 0x8ced, 0x8cea, 0x8cf0, 0x8cf8, 0x8cf3,
  0x0edc, 0x31fd, 0x8e31, 0x8e2f, 0x8eb6, 0x8eae, 0x8eaa, 0x8ebf,
  0x8ecc, 0x8ec7, 0x9883, 0x8f80, 0x8f7b, 0x8f7f,
  /* 0x4d */
  0x8f7d, 0x8f83, 0x31fd, 0x9046, 0x902d, 0x9025, 0x9026, 0x902c,
  0x9037, 0x9031, 0x9033, 0x9032, 0x9027, 0x902a, 0x902e, 0x902f,
  0x90c0, 0x9171, 0x9161, 0x9162, 0x9166, 0x9218, 0x92c5, 0x92c3,
  0x92c4, 0x92c2, 0x92ae, 0x9310, 0x9308, 0x931f, 0x933a, 0x933b,
  0x9336, 0x930c, 0x9306, 0x932a, 0x9357, 0x9350, 0x9320, 0x31fd,
  0x932c, 0x9321, 0x930b, 0x9319, 0x9335, 0x9318, 0x930f, 0x9313,
  0x9355, 0x9339, 0x931a, 0x100c, 0x9317, 0x94e4, 0x94e9, 0x748b,
  0x9510, 0x9512, 0x953f, 0x956e, 0x7418, 0x31fd, 0x95d6, 0x95d5,
  0x95d7, 0x3d02, 0x106d, 0x9631, 0x9630, 0x963a, 0x9785, 0x976b,
  0x9848, 0x984b, 0x9837, 0x987b, 0x986c, 0x9885, 0x9865, 0x9836,
  0x9886, 0x9834, 0x9868, 0x985a, 0x9858, 0x9872, 0x986a, 0x97d3,
  0x983c, 0x9833, 0x983b, 0x984d, 0x984f, 0x987c,
  /* 0x4e */
  0x98b0, 0x985b, 0x9855, 0x9864, 0x986b, 0x9853, 0x10e6, 0x9857,
  0x985e, 0x986d, 0x9835, 0x9869, 0x9859, 0x9866, 0x9850, 0x9851,
  0x985c, 0x995d, 0x9887, 0x9878, 0x9849, 0x984e, 0x97f1, 0x9873,
  0x9888, 0x97cf, 0x31fd, 0x9bb1, 0x9bb3, 0x9c9c, 0x9ca4, 0x9c90,
  0x9cb8, 0x9ca0, 0x9c9d, 0x9ca8, 0x9ca9, 0x31fd, 0x9cb1, 0x9c93,
  0x9c9b, 0x9ca2, 0x9ca1, 0x9cb0, 0x9ca7, 0x9eb3, 0x2a49, 0x9eb4,
  0x9ef1, 0x9eed, 0x9eec, 0x9f68, 0x9f75, 0x9f6a, 0x9f62, 0x9f67,
  0x9f60, 0x9f77, 0x9f5f, 0x9f79, 0xa123, 0xa121, 0xa11c, 0x2b99,
  0xa11f, 0xa11e, 0xa1d6, 0xa1d3, 0xa1d9, 0xa1d7, 0xa1d4, 0xa1dc,
  0xa1d8, 0xa2a3, 0x12d1, 0xa2be, 0xa2a9, 0xa2a1, 0xa2a0, 0xa2ab,
  0xa2a2, 0xa2ba, 0xa2c2, 0xa29c, 0xa2bb, 0xa2aa, 0xa2ac, 0xa2a5,
  0xa2c1, 0x132c, 0xa4e2, 0xa536, 0xa53d, 0xa53a,
  /* 0x4f */
  0x5561, 0xa548, 0xa53c, 0xa5b7, 0xa5ac, 0xa5b3, 0xa5b6, 0xa5b2,
  0x136e, 0xa65d, 0xa649, 0xa64e, 0xa64f, 0xa64d, 0xa65c, 0xa75d,
  0xa7bb, 0xa7ce, 0xa7bf, 0xa7ba, 0xa7c3, 0x13e5, 0xa906, 0xa8f8,
  0xa8fe, 0xa913, 0xa8f6, 0x13e6, 0xaa34, 0xaa2d, 0xaa2a, 0xaa35,
  0xaa2c, 0xaad4, 0xaada, 0xaad3, 0xaad2, 0xaace, 0xaacf, 0x149f,
  0xacfd, 0xad0b, 0xacfe, 0xacf8, 0xacf7, 0xad17, 0xacfa, 0xacf9,
  0xad00, 0xacf5, 0xacf1, 0xad03, 0xad05, 0xad1c, 0xaeac, 0xae9a,
  0xaead, 0xaea0, 0xaf1b, 0xaf25, 0xaf24, 0xaf26, 0xaf27, 0xaf28,
  0xaf2a, 0xaf1a, 0xaf2e, 0xaf15, 0xb015, 0xb014, 0xb017, 0xb018,
  0xb00f, 0xb013, 0xb00b, 0xb022, 0x447a, 0xb126, 0x2f1f, 0xb151,
  0xb14d, 0xb14e, 0xb14a, 0xb14b, 0xb14c, 0xb150, 0xb162, 0xb14f,
  0xb152, 0xb268, 0xb269, 0xb2e5, 0xb2f0, 0xb2e1,
  /* 0x50 */
  0xb2e2, 0x31fd, 0xb4a5, 0xb4a9, 0xb4a4, 0xb4af, 0xb4ac, 0xb4ae,
  0xb4aa, 0xb595, 0xb599, 0xb593, 0xb59d, 0xb598, 0xb59c, 0xb597,
  0x160d, 0xb689, 0xb687, 0xb7d7, 0xb7ed, 0xb7f1, 0xb7f0, 0xb805,
  0xb803, 0xb804, 0xb85f, 0xba57, 0xbb9c, 0xbba1, 0xbb9a, 0xbc8f,
  0xbc93, 0xbc9e, 0xbca3, 0xbc98, 0xbc99, 0xbc95, 0xbd6e, 0xbd6a,
  0xbef4, 0xbef7, 0xc079, 0xc28f, 0xc291, 0xc30b, 0xc702, 0x3284,
  0x3304, 0x3380, 0x352f, 0x353f, 0x353b, 0x3562, 0x3544, 0x3533,
  0x355f, 0x352b, 0x31fd, 0x3539, 0x3536, 0x3548, 0x3535, 0x356c,
  0x3558, 0x353a, 0x36a8, 0x36f4, 0x3729, 0x379a, 0x3800, 0x39bb,
  0x39bd, 0x39b7, 0x39b2, 0x00f8, 0x39a8, 0x39ab, 0x39a6, 0x39bc,
  0x3a97, 0x3a96, 0x3af8, 0x1913, 0x3b51, 0x0133, 0x3bb5, 0x3bb4,
  0x3bb6, 0x013c, 0x3bb7, 0x3c05, 0x3c23, 0x3c95,
  /* 0x51 */
  0x3c98, 0x014f, 0x3c94, 0x3c93, 0x3d07, 0x3d73, 0x3d71, 0x3d72,
  0x3d78, 0x405f, 0x406a, 0x4067, 0x406b, 0x4069, 0x408e, 0x4049,
  0x4080, 0x01dc, 0x4044, 0x408f, 0x4045, 0x31fd, 0x404f, 0x4063,
  0x4036, 0x4048, 0x405c, 0x4093, 0x4061, 0x4060, 0x404e, 0x405e,
  0x403f, 0x40a4, 0x1ae0, 0x4068, 0x430b, 0x4311, 0x430d, 0x430e,
  0x44c2, 0x31fd, 0x44b0, 0x44c3, 0x44c8, 0x4465, 0x44d7, 0x44bd,
  0x44b8, 0x44b6, 0x44c7, 0x44bc, 0x44b1, 0x44af, 0x31fd, 0x4635,
  0x4630, 0x465d, 0x3d76, 0x466f, 0x46b0, 0x31fd, 0x46b4, 0x475c,
  0x475d, 0x4908, 0x48ee, 0x490b, 0x48f2, 0x48fd, 0x48f1, 0x4910,
  0x31fd, 0x4914, 0x4a8b, 0x4a8c, 0x4a85, 0x4b7a, 0x4b6c, 0x4b60,
  0x4b67, 0x4b66, 0x4b6a, 0x4b5f, 0x4b6d, 0x4b68, 0x4b64, 0x4c3a,
  0x4c3b, 0x4c39, 0x4d02, 0x4d04, 0x4d03, 0x4db4,
  /* 0x52 */
  0x4db3, 0x4dbb, 0x4dac, 0x4db6, 0x4db1, 0x4daf, 0x4db5, 0x4dbe,
  0x4db2, 0x4e24, 0x4fb6, 0x4fb9, 0x4fac, 0x4fb0, 0x4fd7, 0x4fbb,
  0x4ffe, 0x4fcb, 0x31fd, 0x03f5, 0x4fb3, 0x4fbe, 0x4fcd, 0x4fbc,
  0x4fba, 0x4fc7, 0x5216, 0x521b, 0x5217, 0x5215, 0x529f, 0x31fd,
  0x5382, 0x5383, 0x538e, 0x536a, 0x5389, 0x5394, 0x5386, 0x5390,
  0x5462, 0x5490, 0x550c, 0x550f, 0x04c3, 0x55a5, 0x55a7, 0x55a6,
  0x55a4, 0x5635, 0x5638, 0x5636, 0x5643, 0x5647, 0x5637, 0x5843,
  0x58a2, 0x5851, 0x5872, 0x586d, 0x582f, 0x5854, 0x586e, 0x5855,
  0x5837, 0x584f, 0x5850, 0x1e39, 0x589e, 0x31fd, 0x58b3, 0x58a7,
  0x0571, 0x58f9, 0x5891, 0x31fd, 0x58b6, 0x58dd, 0x5899, 0x5adf,
  0x5ad5, 0x76f5, 0x5d28, 0x5d40, 0x5d71, 0x5d98, 0x5d95, 0x5d65,
  0x5d78, 0x5d7f, 0x5d60, 0x5d7c, 0x5d96, 0x5d6a,
  /* 0x53 */
  0x5d79, 0x5d73, 0x5d72, 0x5d7b, 0x5d70, 0x5fd5, 0x5fd7, 0x608f,
  0x6089, 0x609e, 0x6087, 0x60a0, 0x608d, 0x6088, 0x607f, 0x608c,
  0x6093, 0x6159, 0xbbb0, 0x61b1, 0x80f4, 0x61af, 0x61b2, 0x6208,
  0x620a, 0x6236, 0x6237, 0x31fd, 0x0701, 0x6336, 0x6329, 0x634a,
  0x6326, 0x6328, 0x6324, 0x632a, 0x6348, 0x6444, 0x6484, 0x648c,
  0x65c4, 0x65dc, 0x6687, 0x6653, 0x667f, 0x6631, 0x6651, 0x664b,
  0x6652, 0x6680, 0x66a5, 0x6681, 0x6643, 0x6634, 0x6636, 0x6632,
  0x6648, 0x6649, 0x663c, 0x664d, 0x664a, 0x31fd, 0x668a, 0x6646,
  0x663e, 0x6683, 0x6650, 0x66b4, 0x68f0, 0x68e4, 0x68e3, 0x68e5,
  0x68e6, 0x68e7, 0x68e1, 0x68ef, 0x68e8, 0x68dd, 0x6903, 0x6988,
  0x6a26, 0x6a16, 0x6a3b, 0x6a2f, 0x6a39, 0x6a34, 0x31fd, 0x6a35,
  0x6a31, 0x6a38, 0x3d81, 0x6aaa, 0x6aa3, 0x6aa4,
  /* 0x54 */
  0x6aa0, 0x6aa1, 0x6aa9, 0x6aa5, 0x6baf, 0x6bb1, 0x6bab, 0x6bae,
  0x6bb0, 0x6bb3, 0x6bac, 0x6ba9, 0x6bb2, 0x6ba8, 0x6bb4, 0x6bc2,
  0x6c4f, 0x6c66, 0x6e1e, 0x6e15, 0x6e10, 0x6e7f, 0x6e7e, 0x6e60,
  0x6ecc, 0x6eb2, 0x6e62, 0x6e8d, 0x6e8e, 0x6e77, 0x6e7c, 0x6e8f,
  0x6e5d, 0x6e6d, 0x6e63, 0x6eaf, 0x6e90, 0x6e7d, 0x6e7a, 0x6e06,
  0x31fd, 0x6e68, 0x6eb4, 0x6e78, 0x6eb1, 0x21d7, 0x31fd, 0x0941,
  0x71e8, 0x71e9, 0x71c0, 0x09d7, 0x71ea, 0x71b7, 0x71ba, 0x71b5,
  0x31fd, 0x71b4, 0x71bc, 0x71c6, 0x71b8, 0x71bd, 0x71c2, 0x724d,
  0x71f0, 0x71c7, 0x71c1, 0x71c3, 0x71f1, 0x71ec, 0x31fd, 0x741c,
  0x7420, 0x7458, 0x7465, 0x7464, 0x748c, 0x748d, 0x74d9, 0x74e0,
  0x7510, 0x7594, 0x7592, 0x7596, 0x7595, 0x75bf, 0x75a0, 0x0a45,
  0x76f4, 0x76f6, 0x76dc, 0x233d, 0x7716, 0x7715,
  /* 0x55 */
  0x771c, 0x770f, 0x772c, 0x7714, 0x7725, 0x7717, 0x7712, 0x771e,
  0x7880, 0x78a8, 0x78af, 0x78d6, 0x78e2, 0x78b4, 0x78b3, 0x78b0,
  0x78b2, 0x78a1, 0x7a60, 0x7a66, 0x7a61, 0x7a4e, 0x7a5d, 0x7a63,
  0x7ae6, 0x7aef, 0x7aec, 0x7b98, 0x7ba7, 0x7b94, 0x7b95, 0x7b91,
  0x7b9d, 0x7b99, 0x7b9b, 0x7b9c, 0x7c1d, 0x7c1c, 0x7cd0, 0x7ce0,
  0x7ccb, 0x7cdb, 0x7cda, 0x7cc2, 0x7cd3, 0x7ce5, 0x7e7d, 0x7e7b,
  0x7eff, 0x0bf2, 0x7ef9, 0x7f77, 0x7f7c, 0x7f78, 0x7f7b, 0x7f7a,
  0x80d2, 0x80cb, 0x80c9, 0x80ce, 0x80e4, 0x80ca, 0x80d0, 0x60a5,
  0x0c49, 0x80d9, 0x80ee, 0x80dd, 0x8100, 0x80e1, 0x82de, 0x82e2,
  0x82da, 0x83ce, 0x31fd, 0x83cf, 0x83da, 0x83d1, 0x83d4, 0x83ed,
  0x83cb, 0x83d5, 0x83f1, 0x859c, 0x8588, 0x8641, 0x86d0, 0x86f7,
  0x86cf, 0x86d1, 0x86db, 0x86de, 0x86f8, 0x86dc,
  /* 0x56 */
  0x86d9, 0x88a0, 0x88b2, 0x88a1, 0x88aa, 0x88a9, 0x0da9, 0x88a6,
  0x889c, 0x88b5, 0x88a7, 0x898e, 0x8990, 0x8991, 0x8a85, 0x8a5b,
  0x8a70, 0x8a64, 0x8a67, 0x8a63, 0x8a77, 0x8a68, 0x8a65, 0x8a6a,
  0x8a78, 0x8a66, 0x8b88, 0x8b9e, 0x8b74, 0x8b7a, 0x8b79, 0x8b8b,
  0x8b7f, 0x8d13, 0x8d1e, 0x8d17, 0x8d1a, 0x8d22, 0x8d43, 0x8d19,
  0x8d1f, 0x8d27, 0x8d12, 0x8d24, 0x8d25, 0x355e, 0x8e35, 0x8e34,
  0x8ed1, 0x8ec4, 0x8eca, 0x8ec6, 0x8ecb, 0x8ecd, 0x8ee2, 0x8f89,
  0x8f8b, 0x8f86, 0x8f88, 0x8f8d, 0x903b, 0x903c, 0x903d, 0x90f5,
  0x9179, 0x9175, 0x9182, 0x917f, 0x9185, 0x9176, 0x917c, 0x917e,
  0x917b, 0x9180, 0x917a, 0x5648, 0x0fcb, 0x921d, 0x92f6, 0x92f7,
  0x92f9, 0x9363, 0x936c, 0x936e, 0x9314, 0x100d, 0x9367, 0x936f,
  0x9369, 0x9376, 0x9395, 0x9371, 0x9361, 0x9378,
  /* 0x57 */
  0x936b, 0x9385, 0x9384, 0x9514, 0x9576, 0x88b6, 0x9575, 0x9574,
  0x95e2, 0x963f, 0x9644, 0x963d, 0x9647, 0x9648, 0x96db, 0x96dc,
  0x96dd, 0x97e5, 0x97e6, 0x98c2, 0x992e, 0x991d, 0x98f8, 0x98f0,
  0x98f6, 0x98c5, 0x98c6, 0x98fc, 0x9952, 0x992f, 0x9910, 0x98f3,
  0x98d2, 0x98ea, 0x98dc, 0x991b, 0x98fb, 0x98c3, 0x9916, 0x9907,
  0x98c9, 0x98d8, 0x9930, 0x9913, 0x9931, 0x98fa, 0x98f2, 0x99e3,
  0x98d5, 0x9901, 0x98f1, 0x991c, 0x98d6, 0x9908, 0x990b, 0x9917,
  0x9920, 0x98ca, 0x9932, 0x9905, 0x98e4, 0x98ce, 0x9933, 0x9902,
  0x9919, 0x991e, 0x98d3, 0x98f7, 0x98e8, 0x991f, 0x98f4, 0x99d8,
  0x9bbf, 0x9bbe, 0x9bbd, 0x9cdc, 0x9cdd, 0x9cab, 0x9cc9, 0x9cc8,
  0x9cdf, 0x9cd9, 0x9cdb, 0x9ccc, 0x9ce0, 0x9cef, 0x9cf3, 0x9cae,
  0x9d01, 0x9eb7, 0x9eb9, 0x9eb6, 0x9eb8, 0x9ef6,
  /* 0x58 */
  0x9ef3, 0x9ef5, 0x9ef2, 0x9f91, 0x9f9d, 0x9f9b, 0x9f92, 0x9f8d,
  0x9f9e, 0x9f8c, 0x1231, 0x31fd, 0x9f95, 0x31fd, 0x9f8a, 0x9f8e,
  0x9f9c, 0xa0ef, 0xa12d, 0xa152, 0xa135, 0xa128, 0xa12e, 0xa1e5,
  0xa2ea, 0xa2f1, 0xa2eb, 0xa2d8, 0xa2d0, 0xa2f3, 0xa2db, 0xa2ce,
  0x12d5, 0xa2da, 0xa2d7, 0xa2e1, 0xa2f2, 0xa2c8, 0xa2d9, 0xa2de,
  0xa2d1, 0xa2e7, 0xa2cf, 0xa4b7, 0xa547, 0xa542, 0xa543, 0x31fd,
  0xa5c3, 0xa5c1, 0xa5c7, 0xa664, 0xa66a, 0xa666, 0xa650, 0xa66e,
  0xa665, 0x68ec, 0xa67f, 0x31fd, 0xa69a, 0xa669, 0xa672, 0xa66f,
  0xa67d, 0xa670, 0xa760, 0xa7c2, 0xa7e7, 0xa7d1, 0xa7eb, 0xa7d4,
  0xa7dc, 0xa7db, 0xa937, 0xa925, 0xa91f, 0xa91e, 0xa921, 0xa91b,
  0xa917, 0xa922, 0xa92a, 0xa91a, 0xa92d, 0xa923, 0xa926, 0xa936,
  0xa8ff, 0xaa3a, 0xaa40, 0xaa42, 0xaa38, 0xaa3b,
  /* 0x59 */
  0xaa3c, 0xaa43, 0xaae8, 0x1456, 0xaaf9, 0xaaeb, 0xaaf1, 0xaae9,
  0xaaec, 0xac15, 0xac47, 0xac46, 0xac45, 0xad24, 0xad56, 0xad21,
  0xad27, 0xad4d, 0xad31, 0xad1e, 0xad2c, 0xad4f, 0xad2b, 0xad53,
  0xad51, 0xad54, 0xad29, 0xad50, 0xad1f, 0xad32, 0xad2a, 0xad1d,
  0xad28, 0xad2e, 0xad2d, 0xaebc, 0xaebb, 0xaebd, 0x31fd, 0xaf47,
  0xaf41, 0x31fd, 0xaf49, 0x14f4, 0xb02e, 0xb027, 0xb16a, 0xb17b,
  0xb173, 0xb175, 0xb169, 0xb179, 0xb172, 0xb276, 0xb277, 0xb274,
  0xb273, 0xb302, 0xb2fe, 0xb301, 0xb2f9, 0xb2f4, 0xb4d3, 0xb4d5,
  0xb4d8, 0xb4c3, 0xb4ca, 0xb4d0, 0xb4cb, 0xb4ce, 0xb4c5, 0xb4e6,
  0xb4c4, 0xb4c0, 0xb4d4, 0xb4e8, 0xb576, 0xb5a2, 0xb5ae, 0xb5a8,
  0xb5a3, 0xb5a7, 0xb596, 0xb5a9, 0xb5a5, 0xb5af, 0xb5a4, 0xb5ab,
  0xb5aa, 0xb5a6, 0xb5a0, 0xb698, 0xb7db, 0xb7f6,
  /* 0x5a */
  0xb7f5, 0xb80c, 0xb80a, 0x3075, 0xb868, 0xb863, 0xb866, 0x1658,
  0xb864, 0xb86a, 0xb869, 0xb995, 0xba02, 0xba6a, 0xba5e, 0xba68,
  0xba69, 0xba65, 0x31fd, 0xbba7, 0xbbae, 0xbba8, 0xbbb3, 0xbc9c,
  0xbca9, 0xbcb6, 0xbcb3, 0xbcb2, 0x31fd, 0xbcb8, 0xbcc0, 0xbcbf,
  0xbcba, 0xbca8, 0xbd3c, 0xbd72, 0xbd71, 0xbd75, 0xbd73, 0xbe17,
  0xbe15, 0xbe16, 0xbe1b, 0xbefa, 0xbef9, 0xc02c, 0xc085, 0xc082,
  0xc07f, 0xc07d, 0xc088, 0x71f3, 0xc14e, 0xc150, 0xc293, 0xc297,
  0xc298, 0xc29b, 0xc29c, 0xc296, 0xc48b, 0xc4fd, 0xc4fc, 0x31fd,
  0x698b, 0x3308, 0x3307, 0x3573, 0x35a2, 0x35af, 0x3582, 0x357b,
  0x3574, 0x35b0, 0x3576, 0x35b9, 0x359e, 0x35b1, 0x35a1, 0x35b2,
  0x356e, 0x31fd, 0x0087, 0x3578, 0x357a, 0x3583, 0x359a, 0x36f8,
  0x3731, 0x3769, 0x3768, 0x379c, 0x3804, 0x3899,
  /* 0x5b */
  0x39c7, 0x39c6, 0x39dc, 0x39c4, 0x39d8, 0x39d4, 0x39df, 0x39d1,
  0x39d0, 0x39d6, 0x39cf, 0x3aad, 0x3aaf, 0x3aa7, 0x3afd, 0x3b5b,
  0x3b5a, 0x3c07, 0x3c9d, 0x3c9b, 0x3cab, 0x3ca4, 0x3c9c, 0x3c9e,
  0x3ca5, 0x3caa, 0x3ca6, 0x3d0e, 0x3d7e, 0x3d7c, 0x40ee, 0x40d5,
  0x40e9, 0x4042, 0x40e2, 0x4123, 0x40d9, 0x40d4, 0x40e3, 0x4115,
  0x40ef, 0x40f0, 0x40d6, 0x40dd, 0x40f6, 0x411c, 0x40d8, 0x40db,
  0x40da, 0x40ed, 0x4511, 0x4315, 0x4318, 0x431a, 0x431f, 0x4316,
  0x31fd, 0x4319, 0x31fd, 0x44f0, 0x4509, 0x451b, 0xa4e7, 0x44f6,
  0x44f4, 0x44b5, 0x4510, 0x44f2, 0x4515, 0x44f3, 0x44f8, 0x4639,
  0x463b, 0x4636, 0x450e, 0x4672, 0x4674, 0x46b9, 0x46b7, 0x46b8,
  0x4772, 0x476b, 0x491d, 0x4937, 0x4922, 0x4943, 0x494d, 0x4938,
  0x495b, 0x4979, 0x491b, 0x48f3, 0x4a91, 0x4b7b,
  /* 0x5c */
  0x4b94, 0x31fd, 0x4b96, 0x4b7f, 0x4b8f, 0x4b84, 0x4b7c, 0x4b8e,
  0x4b90, 0x4b98, 0x4b83, 0x4b80, 0x4b93, 0x4b82, 0x31fd, 0x4c3d,
  0x4c41, 0x4ca1, 0x4c9f, 0x4d0a, 0x4d0d, 0x4dc8, 0x4dc9, 0x4dc7,
  0x4dcd, 0x4e25, 0x4fb1, 0x4fdc, 0x31fd, 0x4fe5, 0x4ff4, 0x4fbf,
  0x4fdb, 0x4fea, 0x4ff2, 0x03fa, 0x4ff1, 0x4fed, 0x4fe6, 0x5102,
  0x31fd, 0x5225, 0x5218, 0x521f, 0x5220, 0x52cf, 0x539d, 0x5399,
  0x53a8, 0x5468, 0x5466, 0x5467, 0x5491, 0x5513, 0x5515, 0x551d,
  0x5516, 0x5519, 0x556b, 0x5568, 0x556a, 0x556d, 0x5569, 0x55aa,
  0x5657, 0x5652, 0x5650, 0x565f, 0x5667, 0x564f, 0x04f2, 0x565b,
  0x565c, 0x565d, 0x591f, 0x589d, 0x58b1, 0x58b0, 0x5894, 0x58c3,
  0x58af, 0x58a8, 0x58dc, 0x5898, 0x58c4, 0x58a4, 0x58ab, 0x58aa,
  0x58a5, 0x5921, 0x58eb, 0x58e6, 0x58f7, 0x58f8,
  /* 0x5d */
  0x58fc, 0x58fa, 0x58e0, 0x31fd, 0x58f6, 0x31fd, 0x58e1, 0x5aec,
  0x5ae2, 0x5ae4, 0x5af9, 0x5d6f, 0x6a4c, 0x5dbb, 0x5de1, 0x5e00,
  0x5dd8, 0x062f, 0x5dd6, 0x5de2, 0x5dc3, 0x5db3, 0x5dd2, 0x31fd,
  0x5dce, 0x5dd0, 0x5dd5, 0x5db9, 0x5dba, 0x5dcf, 0x5dbd, 0x5fdb,
  0x60aa, 0x60ad, 0x60b8, 0x60b6, 0x60b5, 0x60af, 0x60b4, 0x60b7,
  0x60a8, 0x60b9, 0x60be, 0x6182, 0x61bc, 0x61b8, 0x61b6, 0x61b9,
  0x06c1, 0x6210, 0x6327, 0x6369, 0x6370, 0x6356, 0x636b, 0x637a,
  0x636c, 0x636d, 0x31fd, 0x93c1, 0x648d, 0x6490, 0x66b6, 0x6710,
  0x6712, 0x66ba, 0x66bd, 0x6705, 0x66c2, 0x6707, 0x66f5, 0x31fd,
  0x66af, 0x66f4, 0x66f7, 0x66f8, 0x6711, 0x68f6, 0x68f5, 0x68fb,
  0x6901, 0x6900, 0x6902, 0x68fe, 0x68fa, 0x68fd, 0x0840, 0x6a37,
  0x6a49, 0x6a4b, 0x6a46, 0x6a47, 0x6ab3, 0x6ab2,
  /* 0x5e */
  0x6ab0, 0x6ab7, 0x6b11, 0x6bcc, 0x6bdf, 0x6bd3, 0x6bd5, 0x6bdb,
  0x6bc5, 0x6bc8, 0x6bc9, 0x6be2, 0x6bca, 0x6bd1, 0x6bd2, 0x6bdd,
  0x6e6c, 0x6e73, 0x6f21, 0x6ef0, 0x6f1f, 0x6f3b, 0x6f22, 0x6f23,
  0x6ee8, 0x6edd, 0x093f, 0x6f1b, 0x6eed, 0x31fd, 0x6ef2, 0x0946,
  0x6edc, 0x6ee9, 0x6f1d, 0x6eda, 0x6ee6, 0x7213, 0x7215, 0x7216,
  0x723c, 0x720b, 0x721c, 0x723a, 0x723d, 0x729a, 0x721d, 0x7209,
  0x7208, 0x723b, 0x7422, 0x7426, 0x7425, 0x7424, 0x359b, 0x748f,
  0x7490, 0x74e6, 0x74e3, 0x74e5, 0x7511, 0x31fd, 0x75ae, 0x75be,
  0x75b4, 0x75b3, 0x75af, 0x7591, 0x75c2, 0x75b6, 0x75b2, 0x7757,
  0x773b, 0x7758, 0x7751, 0x7741, 0x7739, 0x0a8f, 0x7759, 0x7745,
  0x7761, 0x77e8, 0x78fa, 0x78ea, 0x78ef, 0x78f2, 0x78f0, 0x7a08,
  0x7a70, 0x7a6a, 0x7a73, 0x7a68, 0x7ac8, 0x7af2,
  /* 0x5f */
  0x3d7b, 0x7bae, 0x7bab, 0x7bb5, 0x7baf, 0x7bb2, 0x7bb6, 0x7bb0,
  0x7c1e, 0x7d03, 0x7d06, 0x7d1f, 0x0bac, 0x7d0f, 0x7d02, 0x7d19,
  0x7d18, 0x7d22, 0x7d15, 0x7d07, 0x7d0d, 0x7d24, 0x7d0c, 0x7d1e,
  0x7e89, 0x7e8a, 0x7f0a, 0x7f0b, 0x7f07, 0x7f04, 0x7f09, 0x7f84,
  0x7f83, 0x8118, 0x8114, 0x8105, 0x8116, 0x810e, 0x8111, 0x8108,
  0x810b, 0x8115, 0x7f85, 0x8137, 0x812a, 0x810d, 0x810f, 0x827e,
  0x8276, 0x8277, 0x82ec, 0x83fc, 0x8408, 0x83ff, 0x8403, 0x8410,
  0x8405, 0x8406, 0x83fa, 0x85c7, 0x85c0, 0x85c3, 0x85a7, 0x85a8,
  0x85ab, 0x85c1, 0x85aa, 0x85c8, 0x8643, 0x8702, 0x870e, 0x8701,
  0x86fe, 0x8703, 0x0d68, 0x8722, 0x8721, 0x8707, 0x8708, 0x870c,
  0x88ca, 0x88bc, 0x88be, 0x88bd, 0x31fd, 0x88bb, 0x88b9, 0x0dab,
  0x88c5, 0x8999, 0x8a6b, 0x8a93, 0x8a94, 0x8aa9,
  /* 0x60 */
  0x8aa0, 0x8aa6, 0x31fd, 0x8aab, 0x8a9e, 0x8a9b, 0x8a91, 0x8a99,
  0x8bb6, 0x8bb8, 0x8b9a, 0x0e91, 0x8b98, 0x8b9b, 0x8bb3, 0x8ba2,
  0x53aa, 0x8ba0, 0x8b9f, 0x8d5b, 0x8d70, 0x8d54, 0x8d71, 0x8d65,
  0x8d51, 0x8d9d, 0x8d61, 0x8d5a, 0x8d74, 0x8d4c, 0x8d4b, 0x8d5e,
  0x8d58, 0x8d53, 0x8d52, 0x8e3b, 0x8e39, 0x8ed6, 0x8ee7, 0x8ed7,
  0x8ed8, 0x8ed9, 0x8eda, 0x8edb, 0x8edc, 0x8ee0, 0x8ee4, 0x8edd,
  0x8ef5, 0x8ef1, 0x8f98, 0x8f9d, 0x8f99, 0x9050, 0x9049, 0x26e4,
  0x9062, 0x90d7, 0x9101, 0x90f7, 0x31fd, 0x918c, 0x919c, 0x2788,
  0x921f, 0x921e, 0x933d, 0x933f, 0x9311, 0x9359, 0x933e, 0x9358,
  0x9400, 0x939e, 0x93b6, 0x93aa, 0x93af, 0x93ac, 0x1030, 0x93c0,
  0x93a9, 0x3d10, 0x94ee, 0x9577, 0x9579, 0x957a, 0x957d, 0x957f,
  0x9583, 0x9578, 0x957e, 0x95e4, 0x95e6, 0x95e5,
  /* 0x61 */
  0x105d, 0x964e, 0x9659, 0x1075, 0x31fd, 0x964f, 0x964a, 0x96e3,
  0x96de, 0x96e2, 0x9874, 0x98ac, 0x9861, 0x9862, 0x9876, 0x987a,
  0x9879, 0x9860, 0x9964, 0x9a81, 0x99df, 0x9984, 0x998a, 0x9992,
  0x9979, 0x99de, 0x9998, 0x996c, 0x99e1, 0x31fd, 0x997c, 0x9972,
  0x9981, 0x99e0, 0x9965, 0x10ff, 0x996a, 0x9997, 0x99aa, 0x99d3,
  0x99ab, 0x996e, 0x99ac, 0x9976, 0x997b, 0x99ad, 0x31fd, 0x9994,
  0x99d7, 0x9970, 0x99d5, 0x99f1, 0x997a, 0x9968, 0x9996, 0x110b,
  0x9973, 0x99ae, 0x99dd, 0x99da, 0x99af, 0x99b0, 0x99db, 0x9962,
  0x99f8, 0x9bc2, 0x9bc7, 0x9bc8, 0x9bc5, 0x9bc3, 0x9bc6, 0x9cde,
  0x11c8, 0x9d11, 0x9d15, 0x9d28, 0x9d21, 0x9d2d, 0x9d51, 0x9d2b,
  0x9d16, 0x9d24, 0x9d35, 0x9d1f, 0x9d12, 0x9d10, 0x9d80, 0x9d3b,
  0x9d29, 0x9d2a, 0x9d1b, 0x9d18, 0x9d20, 0x9d3f,
  /* 0x62 */
  0x9d1c, 0x9d26, 0x9d0b, 0x9ebe, 0x9ec4, 0x9ebd, 0x9efa, 0x9efb,
  0x9fb1, 0x9fb2, 0x9fb0, 0x9fb9, 0x9fa6, 0x9fbd, 0x9fb6, 0x9fb8,
  0x9fb4, 0x9fb3, 0x9fa7, 0x9fae, 0x9fbc, 0xa0f2, 0xa0f3, 0xa0f4,
  0xa13b, 0xa140, 0xa146, 0xa1f0, 0xa1ee, 0xa1e8, 0xa1f1, 0xa1eb,
  0xa1ef, 0xa2fc, 0xa320, 0xa309, 0xa306, 0xa303, 0x31fd, 0xa319,
  0xa324, 0xa31b, 0xa31d, 0xa2fd, 0xa31e, 0xa2f4, 0xa301, 0xa308,
  0xa305, 0xa323, 0xa2ff, 0xa4ea, 0xa54d, 0xa54e, 0xa556, 0xa557,
  0xa551, 0xa555, 0xa554, 0xa5cb, 0xa5d4, 0xa5d1, 0xa5cf, 0xa5d2,
  0xa5ca, 0xa5d6, 0xa68b, 0xa688, 0xa685, 0xa689, 0x4b9b, 0xa6bb,
  0xa68c, 0x1374, 0xa699, 0xa68a, 0xa7ec, 0xa7ef, 0xa7f9, 0xa809,
  0xa7f8, 0xa7f3, 0xa800, 0xa81d, 0x13ac, 0xa7fd, 0xa948, 0xa95c,
  0xa955, 0xa95e, 0xa949, 0xa963, 0xa960, 0xa953,
  /* 0x63 */
  0xa962, 0xa940, 0xaa49, 0xaa4a, 0xaa4c, 0xaa4d, 0xab0a, 0xab06,
  0xab2f, 0xab21, 0xab07, 0xab09, 0xab02, 0xab16, 0xab03, 0xab0b,
  0xab0f, 0xad60, 0xad68, 0xad5e, 0xad5d, 0xad63, 0xad5f, 0xad64,
  0xad78, 0xad61, 0xad69, 0xad65, 0xaeda, 0xaee6, 0xaedb, 0xaedc,
  0xaf39, 0xaf57, 0xaf55, 0xaf65, 0xaf61, 0xaf54, 0xb045, 0xb041,
  0xb03e, 0xb037, 0xb112, 0xb113, 0xb12c, 0xb196, 0x31fd, 0xb19c,
  0xb19d, 0xb185, 0x31fd, 0xb19f, 0xb1a3, 0xb282, 0xb283, 0x31fd,
  0xb31d, 0xb314, 0xb31f, 0xb320, 0xb447, 0xb480, 0xb4c9, 0xb4f9,
  0xb506, 0xb4f0, 0xb4f8, 0xb4ef, 0xb4fd, 0xb4f1, 0xb4fe, 0xb5b8,
  0xb5c0, 0xb5c3, 0xb5b5, 0xb5b6, 0xb5c9, 0x31fd, 0xb5bd, 0xb5ba,
  0xb5bf, 0xb5b3, 0xb5c6, 0xb5b2, 0xb5bc, 0xb5b7, 0xb5b9, 0xb5c8,
  0xb6b5, 0xb6b3, 0x1616, 0xb6ac, 0xb6a9, 0xb6ad,
  /* 0x64 */
  0xb811, 0xb80d, 0xb816, 0xb889, 0xb87c, 0xb88b, 0xb87b, 0xb888,
  0xb884, 0xb99d, 0xb998, 0xba88, 0xba86, 0xba82, 0xba8b, 0x31fd,
  0xba71, 0xba72, 0xba81, 0xba8c, 0xba80, 0xba89, 0xbbbb, 0xbbc1,
  0xbbbe, 0x31fd, 0xbbbd, 0xbcc1, 0xbcb4, 0xbcb7, 0xbcc8, 0x173b,
  0xbcd3, 0xbcd0, 0xbcb0, 0xbcca, 0xbccd, 0xbd15, 0xbd19, 0xbd17,
  0xbd3f, 0xbd40, 0xbd44, 0xbd7c, 0xbd78, 0xbd79, 0xbd88, 0x31fd,
  0xbd89, 0xbd7d, 0xbe23, 0xbe24, 0xbe26, 0xbe22, 0xbe27, 0xbe1f,
  0xbec9, 0xbec3, 0xbf0a, 0xbf0b, 0xbf04, 0x17ef, 0xbf03, 0xbf01,
  0xbf09, 0xc00f, 0xc02e, 0xc02d, 0xc091, 0xc099, 0xc09e, 0xc090,
  0xc094, 0xc09d, 0xc098, 0xc09b, 0xc09c, 0xc09a, 0xc154, 0xc29d,
  0xc29f, 0xc2a3, 0xc2a4, 0xc2a5, 0xc502, 0xc617, 0xc61b, 0xc619,
  0xc6d1, 0x4637,
};

static const ucs4_t cns11643_6_2uni_upages[200] = {
  0x03400, 0x03500, 0x03600, 0x03700, 0x03800, 0x03900, 0x03a00, 0x03b00,
  0x03c00, 0x03d00, 0x03e00, 0x03f00, 0x04000, 0x04100, 0x04200, 0x04300,
  0x04400, 0x04500, 0x04600, 0x04700, 0x04800, 0x04900, 0x04a00, 0x04b00,
  0x05100, 0x05300, 0x05500, 0x05a00, 0x05b00, 0x05e00, 0x06100, 0x06500,
  0x06800, 0x06e00, 0x07200, 0x07300, 0x07800, 0x07a00, 0x07f00, 0x08000,
  0x08100, 0x08200, 0x08800, 0x08900, 0x08a00, 0x08d00, 0x08f00, 0x09200,
  0x09700, 0x0ff00, 0x20000, 0x20100, 0x20200, 0x20300, 0x20400, 0x20500,
  0x20600, 0x20700, 0x20800, 0x20900, 0x20a00, 0x20b00, 0x20c00, 0x20d00,
  0x20e00, 0x20f00, 0x21100, 0x21200, 0x21300, 0x21400, 0x21500, 0x21600,
  0x21700, 0x21800, 0x21900, 0x21a00, 0x21b00, 0x21c00, 0x21d00, 0x21e00,
  0x21f00, 0x22000, 0x22100, 0x22200, 0x22300, 0x22400, 0x22500, 0x22600,
  0x22700, 0x22800, 0x22900, 0x22a00, 0x22b00, 0x22c00, 0x22d00, 0x22e00,
  0x22f00, 0x23000, 0x23100, 0x23200, 0x23300, 0x23400, 0x23500, 0x23600,
  0x23800, 0x23900, 0x23a00, 0x23b00, 0x23c00, 0x23d00, 0x23e00, 0x23f00,
  0x24100, 0x24200, 0x24300, 0x24400, 0x24500, 0x24600, 0x24700, 0x24800,
  0x24900, 0x24a00, 0x24b00, 0x24c00, 0x24d00, 0x24e00, 0x24f00, 0x25000,
  0x25100, 0x25200, 0x25300, 0x25400, 0x25500, 0x25600, 0x25700, 0x25800,
  0x25900, 0x25a00, 0x25b00, 0x25e00, 0x25f00, 0x26000, 0x26200, 0x26300,
  0x26400, 0x26500, 0x26600, 0x26700, 0x26800, 0x26900, 0x26a00, 0x26b00,
  0x26c00, 0x26d00, 0x26e00, 0x27100, 0x27200, 0x27300, 0x27500, 0x27600,
  0x27700, 0x27800, 0x27900, 0x27a00, 0x27b00, 0x27c00, 0x27d00, 0x27e00,
  0x27f00, 0x28000, 0x28200, 0x28300, 0x28400, 0x28500, 0x28600, 0x28700,
  0x28800, 0x28900, 0x28c00, 0x28d00, 0x28e00, 0x28f00, 0x29000, 0x29100,
  0x29200, 0x29300, 0x29400, 0x29500, 0x29600, 0x29800, 0x29a00, 0x29b00,
  0x29c00, 0x29d00, 0x29f00, 0x2a000, 0x2a200, 0x2a300, 0x2a400, 0x2a500,
};

static int
cns11643_6_mbtowc (conv_t conv, ucs4_t *pwc, const unsigned char *s, int n)
{
  unsigned char c1 = s[0];
  if ((c1 >= 0x21 && c1 <= 0x64)) {
    if (n >= 2) {
      unsigned char c2 = s[1];
      if (c2 >= 0x21 && c2 < 0x7f) {
        unsigned int i = 94 * (c1 - 0x21) + (c2 - 0x21);
        ucs4_t wc = 0xfffd;
        unsigned short swc;
        {
          if (i < 6388)
            swc = cns11643_6_2uni_page21[i],
            wc = cns11643_6_2uni_upages[swc>>8] | (swc & 0xff);
        }
        if (wc != 0xfffd) {
          *pwc = wc;
          return 2;
        }
      }
      return RET_ILSEQ;
    }
    return RET_TOOFEW(0);
  }
  return RET_ILSEQ;
}

