/* AMD pp. 128 - 134: unbalanced layout  */

#include <dap.h>

void main()
{
  infile("amd128.dat", " ")
    {
    char treat[7], block[7];
    double y;
    input("treat block y");
    outset("amd128", "treat block y");
    skip(1);
    while (step())
      output();
    }
  
  sort("amd128", "treat block", "");
  means("amd128.srt", "y", "N MEAN VAR", "treat block");
  
  /* Set up the model for F-tests and perform the F-test on the model */
  effects("amd128.srt.mns", "y treat block", "treat block treat*block", "");
  
  title("Testing interaction");
  ftest("amd128.srt.mns.con", "y treat block", "treat*block", "", "");
  
  title("Testing treatment");
  ftest("amd128.srt.mns.con", "y treat block", "treat", "", "");
  lsmeans("amd128.srt.mns.tst", "LSD", 0.05,
                            "y treat block", "treat", "", "8.4");
  
  title("Testing block");
  ftest("amd128.srt.mns.con", "y treat block", "block", "", "");
  lsmeans("amd128.srt.mns.tst", "TUKEY", 0.05,
                            "y treat block", "block", "", "8.4");
}
