/**
 * Windows API header module
 *
 * Translated from MinGW Windows headers
 *
 * License: $(LINK2 http://www.boost.org/LICENSE_1_0.txt, Boost License 1.0)
 * Source: $(DRUNTIMESRC core/sys/windows/_winerror.d)
 */
module core.sys.windows.winerror;
version (Windows):

/* Comments from the Mingw header:
 * WAIT_TIMEOUT is also defined in winbase.h
 */

import core.sys.windows.windef;

alias int SCODE; // was in core.sys.windows.wtypes.

enum : uint {
    ERROR_SUCCESS                                         =     0,
    NO_ERROR                                              =     0,
    ERROR_INVALID_FUNCTION,
    ERROR_FILE_NOT_FOUND,
    ERROR_PATH_NOT_FOUND,
    ERROR_TOO_MANY_OPEN_FILES,
    ERROR_ACCESS_DENIED,
    ERROR_INVALID_HANDLE,
    ERROR_ARENA_TRASHED,
    ERROR_NOT_ENOUGH_MEMORY,
    ERROR_INVALID_BLOCK,
    ERROR_BAD_ENVIRONMENT,
    ERROR_BAD_FORMAT,
    ERROR_INVALID_ACCESS,
    ERROR_INVALID_DATA,
    ERROR_OUTOFMEMORY,
    ERROR_INVALID_DRIVE,
    ERROR_CURRENT_DIRECTORY,
    ERROR_NOT_SAME_DEVICE,
    ERROR_NO_MORE_FILES,
    ERROR_WRITE_PROTECT,
    ERROR_BAD_UNIT,
    ERROR_NOT_READY,
    ERROR_BAD_COMMAND,
    ERROR_CRC,
    ERROR_BAD_LENGTH,
    ERROR_SEEK,
    ERROR_NOT_DOS_DISK,
    ERROR_SECTOR_NOT_FOUND,
    ERROR_OUT_OF_PAPER,
    ERROR_WRITE_FAULT,
    ERROR_READ_FAULT,
    ERROR_GEN_FAILURE,
    ERROR_SHARING_VIOLATION,
    ERROR_LOCK_VIOLATION,
    ERROR_WRONG_DISK,                                  // =    34
    ERROR_SHARING_BUFFER_EXCEEDED                         =    36,
    ERROR_HANDLE_EOF                                      =    38,
    ERROR_HANDLE_DISK_FULL,                            // =    39
    ERROR_NOT_SUPPORTED                                   =    50,
    ERROR_REM_NOT_LIST,
    ERROR_DUP_NAME,
    ERROR_BAD_NETPATH,
    ERROR_NETWORK_BUSY,
    ERROR_DEV_NOT_EXIST,
    ERROR_TOO_MANY_CMDS,
    ERROR_ADAP_HDW_ERR,
    ERROR_BAD_NET_RESP,
    ERROR_UNEXP_NET_ERR,
    ERROR_BAD_REM_ADAP,
    ERROR_PRINTQ_FULL,
    ERROR_NO_SPOOL_SPACE,
    ERROR_PRINT_CANCELLED,
    ERROR_NETNAME_DELETED,
    ERROR_NETWORK_ACCESS_DENIED,
    ERROR_BAD_DEV_TYPE,
    ERROR_BAD_NET_NAME,
    ERROR_TOO_MANY_NAMES,
    ERROR_TOO_MANY_SESS,
    ERROR_SHARING_PAUSED,
    ERROR_REQ_NOT_ACCEP,
    ERROR_REDIR_PAUSED,                                // =    72
    ERROR_FILE_EXISTS                                     =    80,
    ERROR_CANNOT_MAKE                                     =    82,
    ERROR_FAIL_I24,
    ERROR_OUT_OF_STRUCTURES,
    ERROR_ALREADY_ASSIGNED,
    ERROR_INVALID_PASSWORD,
    ERROR_INVALID_PARAMETER,
    ERROR_NET_WRITE_FAULT,
    ERROR_NO_PROC_SLOTS,                               // =    89
    ERROR_TOO_MANY_SEMAPHORES                             =   100,
    ERROR_EXCL_SEM_ALREADY_OWNED,
    ERROR_SEM_IS_SET,
    ERROR_TOO_MANY_SEM_REQUESTS,
    ERROR_INVALID_AT_INTERRUPT_TIME,
    ERROR_SEM_OWNER_DIED,
    ERROR_SEM_USER_LIMIT,
    ERROR_DISK_CHANGE,
    ERROR_DRIVE_LOCKED,
    ERROR_BROKEN_PIPE,
    ERROR_OPEN_FAILED,
    ERROR_BUFFER_OVERFLOW,
    ERROR_DISK_FULL,
    ERROR_NO_MORE_SEARCH_HANDLES,
    ERROR_INVALID_TARGET_HANDLE,                       // =   114
    ERROR_INVALID_CATEGORY                                =   117,
    ERROR_INVALID_VERIFY_SWITCH,
    ERROR_BAD_DRIVER_LEVEL,
    ERROR_CALL_NOT_IMPLEMENTED,
    ERROR_SEM_TIMEOUT,
    ERROR_INSUFFICIENT_BUFFER,
    ERROR_INVALID_NAME,
    ERROR_INVALID_LEVEL,
    ERROR_NO_VOLUME_LABEL,
    ERROR_MOD_NOT_FOUND,
    ERROR_PROC_NOT_FOUND,
    ERROR_WAIT_NO_CHILDREN,
    ERROR_CHILD_NOT_COMPLETE,
    ERROR_DIRECT_ACCESS_HANDLE,
    ERROR_NEGATIVE_SEEK,
    ERROR_SEEK_ON_DEVICE,
    ERROR_IS_JOIN_TARGET,
    ERROR_IS_JOINED,
    ERROR_IS_SUBSTED,
    ERROR_NOT_JOINED,
    ERROR_NOT_SUBSTED,
    ERROR_JOIN_TO_JOIN,
    ERROR_SUBST_TO_SUBST,
    ERROR_JOIN_TO_SUBST,
    ERROR_SUBST_TO_JOIN,
    ERROR_BUSY_DRIVE,
    ERROR_SAME_DRIVE,
    ERROR_DIR_NOT_ROOT,
    ERROR_DIR_NOT_EMPTY,
    ERROR_IS_SUBST_PATH,
    ERROR_IS_JOIN_PATH,
    ERROR_PATH_BUSY,
    ERROR_IS_SUBST_TARGET,
    ERROR_SYSTEM_TRACE,
    ERROR_INVALID_EVENT_COUNT,
    ERROR_TOO_MANY_MUXWAITERS,
    ERROR_INVALID_LIST_FORMAT,
    ERROR_LABEL_TOO_LONG,
    ERROR_TOO_MANY_TCBS,
    ERROR_SIGNAL_REFUSED,
    ERROR_DISCARDED,
    ERROR_NOT_LOCKED,
    ERROR_BAD_THREADID_ADDR,
    ERROR_BAD_ARGUMENTS,
    ERROR_BAD_PATHNAME,
    ERROR_SIGNAL_PENDING,                              // =   162
    ERROR_MAX_THRDS_REACHED                               =   164,
    ERROR_LOCK_FAILED                                     =   167,
    ERROR_BUSY                                            =   170,
    ERROR_CANCEL_VIOLATION                                =   173,
    ERROR_ATOMIC_LOCKS_NOT_SUPPORTED,                  // =   174
    ERROR_INVALID_SEGMENT_NUMBER                          =   180,
    ERROR_INVALID_ORDINAL                                 =   182,
    ERROR_ALREADY_EXISTS,                              // =   183
    ERROR_INVALID_FLAG_NUMBER                             =   186,
    ERROR_SEM_NOT_FOUND,
    ERROR_INVALID_STARTING_CODESEG,
    ERROR_INVALID_STACKSEG,
    ERROR_INVALID_MODULETYPE,
    ERROR_INVALID_EXE_SIGNATURE,
    ERROR_EXE_MARKED_INVALID,
    ERROR_BAD_EXE_FORMAT,
    ERROR_ITERATED_DATA_EXCEEDS_64k,
    ERROR_INVALID_MINALLOCSIZE,
    ERROR_DYNLINK_FROM_INVALID_RING,
    ERROR_IOPL_NOT_ENABLED,
    ERROR_INVALID_SEGDPL,
    ERROR_AUTODATASEG_EXCEEDS_64k,
    ERROR_RING2SEG_MUST_BE_MOVABLE,
    ERROR_RELOC_CHAIN_XEEDS_SEGLIM,
    ERROR_INFLOOP_IN_RELOC_CHAIN,
    ERROR_ENVVAR_NOT_FOUND,                            // =   203
    ERROR_NO_SIGNAL_SENT                                  =   205,
    ERROR_FILENAME_EXCED_RANGE,
    ERROR_RING2_STACK_IN_USE,
    ERROR_META_EXPANSION_TOO_LONG,
    ERROR_INVALID_SIGNAL_NUMBER,
    ERROR_THREAD_1_INACTIVE,                           // =   210
    ERROR_LOCKED                                          =   212,
    ERROR_TOO_MANY_MODULES                                =   214,
    ERROR_NESTING_NOT_ALLOWED,
    ERROR_EXE_MACHINE_TYPE_MISMATCH,
    ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY,
    ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY,      // =   218
    ERROR_BAD_PIPE                                        =   230,
    ERROR_PIPE_BUSY,
    ERROR_NO_DATA,
    ERROR_PIPE_NOT_CONNECTED,
    ERROR_MORE_DATA,                                   // =   234
    ERROR_VC_DISCONNECTED                                 =   240,
    ERROR_INVALID_EA_NAME                                 =   254,
    ERROR_EA_LIST_INCONSISTENT,                        // =   255
    WAIT_TIMEOUT                                          =   258,
    ERROR_NO_MORE_ITEMS,                               // =   259
    ERROR_CANNOT_COPY                                     =   266,
    ERROR_DIRECTORY,                                   // =   267
    ERROR_EAS_DIDNT_FIT                                   =   275,
    ERROR_EA_FILE_CORRUPT,
    ERROR_EA_TABLE_FULL,
    ERROR_INVALID_EA_HANDLE,                           // =   278
    ERROR_EAS_NOT_SUPPORTED                               =   282,
    ERROR_NOT_OWNER                                       =   288,
    ERROR_TOO_MANY_POSTS                                  =   298,
    ERROR_PARTIAL_COPY,
    ERROR_OPLOCK_NOT_GRANTED,
    ERROR_INVALID_OPLOCK_PROTOCOL,
    ERROR_DISK_TOO_FRAGMENTED,
    ERROR_DELETE_PENDING,                              // =   303
    ERROR_MR_MID_NOT_FOUND                                =   317,
    ERROR_SCOPE_NOT_FOUND,                             // =   318
    ERROR_INVALID_ADDRESS                                 =   487,
    ERROR_ARITHMETIC_OVERFLOW                             =   534,
    ERROR_PIPE_CONNECTED,
    ERROR_PIPE_LISTENING,                              // =   536
    ERROR_EA_ACCESS_DENIED                                =   994,
    ERROR_OPERATION_ABORTED,
    ERROR_IO_INCOMPLETE,
    ERROR_IO_PENDING,
    ERROR_NOACCESS,
    ERROR_SWAPERROR,                                   // =   999
    ERROR_STACK_OVERFLOW                                  =  1001,
    ERROR_INVALID_MESSAGE,
    ERROR_CAN_NOT_COMPLETE,
    ERROR_INVALID_FLAGS,
    ERROR_UNRECOGNIZED_VOLUME,
    ERROR_FILE_INVALID,
    ERROR_FULLSCREEN_MODE,
    ERROR_NO_TOKEN,
    ERROR_BADDB,
    ERROR_BADKEY,
    ERROR_CANTOPEN,
    ERROR_CANTREAD,
    ERROR_CANTWRITE,
    ERROR_REGISTRY_RECOVERED,
    ERROR_REGISTRY_CORRUPT,
    ERROR_REGISTRY_IO_FAILED,
    ERROR_NOT_REGISTRY_FILE,
    ERROR_KEY_DELETED,
    ERROR_NO_LOG_SPACE,
    ERROR_KEY_HAS_CHILDREN,
    ERROR_CHILD_MUST_BE_VOLATILE,
    ERROR_NOTIFY_ENUM_DIR,                             // =  1022
    ERROR_DEPENDENT_SERVICES_RUNNING                      =  1051,
    ERROR_INVALID_SERVICE_CONTROL,
    ERROR_SERVICE_REQUEST_TIMEOUT,
    ERROR_SERVICE_NO_THREAD,
    ERROR_SERVICE_DATABASE_LOCKED,
    ERROR_SERVICE_ALREADY_RUNNING,
    ERROR_INVALID_SERVICE_ACCOUNT,
    ERROR_SERVICE_DISABLED,
    ERROR_CIRCULAR_DEPENDENCY,
    ERROR_SERVICE_DOES_NOT_EXIST,
    ERROR_SERVICE_CANNOT_ACCEPT_CTRL,
    ERROR_SERVICE_NOT_ACTIVE,
    ERROR_FAILED_SERVICE_CONTROLLER_CONNECT,
    ERROR_EXCEPTION_IN_SERVICE,
    ERROR_DATABASE_DOES_NOT_EXIST,
    ERROR_SERVICE_SPECIFIC_ERROR,
    ERROR_PROCESS_ABORTED,
    ERROR_SERVICE_DEPENDENCY_FAIL,
    ERROR_SERVICE_LOGON_FAILED,
    ERROR_SERVICE_START_HANG,
    ERROR_INVALID_SERVICE_LOCK,
    ERROR_SERVICE_MARKED_FOR_DELETE,
    ERROR_SERVICE_EXISTS,
    ERROR_ALREADY_RUNNING_LKG,
    ERROR_SERVICE_DEPENDENCY_DELETED,
    ERROR_BOOT_ALREADY_ACCEPTED,
    ERROR_SERVICE_NEVER_STARTED,
    ERROR_DUPLICATE_SERVICE_NAME,
    ERROR_DIFFERENT_SERVICE_ACCOUNT,
    ERROR_CANNOT_DETECT_DRIVER_FAILURE,
    ERROR_CANNOT_DETECT_PROCESS_ABORT,
    ERROR_NO_RECOVERY_PROGRAM,
    ERROR_SERVICE_NOT_IN_EXE,
    ERROR_NOT_SAFEBOOT_SERVICE,                        // =  1084
    ERROR_END_OF_MEDIA                                    =  1100,
    ERROR_FILEMARK_DETECTED,
    ERROR_BEGINNING_OF_MEDIA,
    ERROR_SETMARK_DETECTED,
    ERROR_NO_DATA_DETECTED,
    ERROR_PARTITION_FAILURE,
    ERROR_INVALID_BLOCK_LENGTH,
    ERROR_DEVICE_NOT_PARTITIONED,
    ERROR_UNABLE_TO_LOCK_MEDIA,
    ERROR_UNABLE_TO_UNLOAD_MEDIA,
    ERROR_MEDIA_CHANGED,
    ERROR_BUS_RESET,
    ERROR_NO_MEDIA_IN_DRIVE,
    ERROR_NO_UNICODE_TRANSLATION,
    ERROR_DLL_INIT_FAILED,
    ERROR_SHUTDOWN_IN_PROGRESS,
    ERROR_NO_SHUTDOWN_IN_PROGRESS,
    ERROR_IO_DEVICE,
    ERROR_SERIAL_NO_DEVICE,
    ERROR_IRQ_BUSY,
    ERROR_MORE_WRITES,
    ERROR_COUNTER_TIMEOUT,
    ERROR_FLOPPY_ID_MARK_NOT_FOUND,
    ERROR_FLOPPY_WRONG_CYLINDER,
    ERROR_FLOPPY_UNKNOWN_ERROR,
    ERROR_FLOPPY_BAD_REGISTERS,
    ERROR_DISK_RECALIBRATE_FAILED,
    ERROR_DISK_OPERATION_FAILED,
    ERROR_DISK_RESET_FAILED,
    ERROR_EOM_OVERFLOW,
    ERROR_NOT_ENOUGH_SERVER_MEMORY,
    ERROR_POSSIBLE_DEADLOCK,
    ERROR_MAPPED_ALIGNMENT,                            // =  1132
    ERROR_SET_POWER_STATE_VETOED                          =  1140,
    ERROR_SET_POWER_STATE_FAILED,
    ERROR_TOO_MANY_LINKS,                              // =  1142
    ERROR_OLD_WIN_VERSION                                 =  1150,
    ERROR_APP_WRONG_OS,
    ERROR_SINGLE_INSTANCE_APP,
    ERROR_RMODE_APP,
    ERROR_INVALID_DLL,
    ERROR_NO_ASSOCIATION,
    ERROR_DDE_FAIL,
    ERROR_DLL_NOT_FOUND,
    ERROR_NO_MORE_USER_HANDLES,
    ERROR_MESSAGE_SYNC_ONLY,
    ERROR_SOURCE_ELEMENT_EMPTY,
    ERROR_DESTINATION_ELEMENT_FULL,
    ERROR_ILLEGAL_ELEMENT_ADDRESS,
    ERROR_MAGAZINE_NOT_PRESENT,
    ERROR_DEVICE_REINITIALIZATION_NEEDED,
    ERROR_DEVICE_REQUIRES_CLEANING,
    ERROR_DEVICE_DOOR_OPEN,
    ERROR_DEVICE_NOT_CONNECTED,
    ERROR_NOT_FOUND,
    ERROR_NO_MATCH,
    ERROR_SET_NOT_FOUND,
    ERROR_POINT_NOT_FOUND,
    ERROR_NO_TRACKING_SERVICE,
    ERROR_NO_VOLUME_ID,                                // =  1173
    ERROR_UNABLE_TO_REMOVE_REPLACED                       =  1175,
    ERROR_UNABLE_TO_MOVE_REPLACEMENT,
    ERROR_UNABLE_TO_MOVE_REPLACEMENT_2,
    ERROR_JOURNAL_DELETE_IN_PROGRESS,
    ERROR_JOURNAL_NOT_ACTIVE,
    ERROR_POTENTIAL_FILE_FOUND,
    ERROR_JOURNAL_ENTRY_DELETED,                       // =  1181
    ERROR_BAD_DEVICE                                      =  1200,
    ERROR_CONNECTION_UNAVAIL,
    ERROR_DEVICE_ALREADY_REMEMBERED,
    ERROR_NO_NET_OR_BAD_PATH,
    ERROR_BAD_PROVIDER,
    ERROR_CANNOT_OPEN_PROFILE,
    ERROR_BAD_PROFILE,
    ERROR_NOT_CONTAINER,
    ERROR_EXTENDED_ERROR,
    ERROR_INVALID_GROUPNAME,
    ERROR_INVALID_COMPUTERNAME,
    ERROR_INVALID_EVENTNAME,
    ERROR_INVALID_DOMAINNAME,
    ERROR_INVALID_SERVICENAME,
    ERROR_INVALID_NETNAME,
    ERROR_INVALID_SHARENAME,
    ERROR_INVALID_PASSWORDNAME,
    ERROR_INVALID_MESSAGENAME,
    ERROR_INVALID_MESSAGEDEST,
    ERROR_SESSION_CREDENTIAL_CONFLICT,
    ERROR_REMOTE_SESSION_LIMIT_EXCEEDED,
    ERROR_DUP_DOMAINNAME,
    ERROR_NO_NETWORK,
    ERROR_CANCELLED,
    ERROR_USER_MAPPED_FILE,
    ERROR_CONNECTION_REFUSED,
    ERROR_GRACEFUL_DISCONNECT,
    ERROR_ADDRESS_ALREADY_ASSOCIATED,
    ERROR_ADDRESS_NOT_ASSOCIATED,
    ERROR_CONNECTION_INVALID,
    ERROR_CONNECTION_ACTIVE,
    ERROR_NETWORK_UNREACHABLE,
    ERROR_HOST_UNREACHABLE,
    ERROR_PROTOCOL_UNREACHABLE,
    ERROR_PORT_UNREACHABLE,
    ERROR_REQUEST_ABORTED,
    ERROR_CONNECTION_ABORTED,
    ERROR_RETRY,
    ERROR_CONNECTION_COUNT_LIMIT,
    ERROR_LOGIN_TIME_RESTRICTION,
    ERROR_LOGIN_WKSTA_RESTRICTION,
    ERROR_INCORRECT_ADDRESS,
    ERROR_ALREADY_REGISTERED,
    ERROR_SERVICE_NOT_FOUND,
    ERROR_NOT_AUTHENTICATED,
    ERROR_NOT_LOGGED_ON,
    ERROR_CONTINUE,
    ERROR_ALREADY_INITIALIZED,
    ERROR_NO_MORE_DEVICES,
    ERROR_NO_SUCH_SITE,
    ERROR_DOMAIN_CONTROLLER_EXISTS,
    ERROR_ONLY_IF_CONNECTED,
    ERROR_OVERRIDE_NOCHANGES,
    ERROR_BAD_USER_PROFILE,
    ERROR_NOT_SUPPORTED_ON_SBS,
    ERROR_SERVER_SHUTDOWN_IN_PROGRESS,
    ERROR_HOST_DOWN,
    ERROR_NON_ACCOUNT_SID,
    ERROR_NON_DOMAIN_SID,
    ERROR_APPHELP_BLOCK,
    ERROR_ACCESS_DISABLED_BY_POLICY,
    ERROR_REG_NAT_CONSUMPTION,
    ERROR_CSCSHARE_OFFLINE,
    ERROR_PKINIT_FAILURE,
    ERROR_SMARTCARD_SUBSYSTEM_FAILURE,
    ERROR_DOWNGRADE_DETECTED,
    SEC_E_SMARTCARD_CERT_REVOKED,
    SEC_E_ISSUING_CA_UNTRUSTED,
    SEC_E_REVOCATION_OFFLINE_C,
    SEC_E_PKINIT_CLIENT_FAILUR,
    SEC_E_SMARTCARD_CERT_EXPIRED,
    ERROR_MACHINE_LOCKED,                              // =  1271
    ERROR_CALLBACK_SUPPLIED_INVALID_DATA                  =  1273,
    ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED,
    ERROR_DRIVER_BLOCKED,
    ERROR_INVALID_IMPORT_OF_NON_DLL,
    ERROR_ACCESS_DISABLED_WEBBLADE,
    ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER,
    ERROR_RECOVERY_FAILURE,
    ERROR_ALREADY_FIBER,
    ERROR_ALREADY_THREAD,
    ERROR_STACK_BUFFER_OVERRUN,
    ERROR_PARAMETER_QUOTA_EXCEEDED,
    ERROR_DEBUGGER_INACTIVE,                           // =  1284
    ERROR_NOT_ALL_ASSIGNED                                =  1300,
    ERROR_SOME_NOT_MAPPED,
    ERROR_NO_QUOTAS_FOR_ACCOUNT,
    ERROR_LOCAL_USER_SESSION_KEY,
    ERROR_NULL_LM_PASSWORD,
    ERROR_UNKNOWN_REVISION,
    ERROR_REVISION_MISMATCH,
    ERROR_INVALID_OWNER,
    ERROR_INVALID_PRIMARY_GROUP,
    ERROR_NO_IMPERSONATION_TOKEN,
    ERROR_CANT_DISABLE_MANDATORY,
    ERROR_NO_LOGON_SERVERS,
    ERROR_NO_SUCH_LOGON_SESSION,
    ERROR_NO_SUCH_PRIVILEGE,
    ERROR_PRIVILEGE_NOT_HELD,
    ERROR_INVALID_ACCOUNT_NAME,
    ERROR_USER_EXISTS,
    ERROR_NO_SUCH_USER,
    ERROR_GROUP_EXISTS,
    ERROR_NO_SUCH_GROUP,
    ERROR_MEMBER_IN_GROUP,
    ERROR_MEMBER_NOT_IN_GROUP,
    ERROR_LAST_ADMIN,
    ERROR_WRONG_PASSWORD,
    ERROR_ILL_FORMED_PASSWORD,
    ERROR_PASSWORD_RESTRICTION,
    ERROR_LOGON_FAILURE,
    ERROR_ACCOUNT_RESTRICTION,
    ERROR_INVALID_LOGON_HOURS,
    ERROR_INVALID_WORKSTATION,
    ERROR_PASSWORD_EXPIRED,
    ERROR_ACCOUNT_DISABLED,
    ERROR_NONE_MAPPED,
    ERROR_TOO_MANY_LUIDS_REQUESTED,
    ERROR_LUIDS_EXHAUSTED,
    ERROR_INVALID_SUB_AUTHORITY,
    ERROR_INVALID_ACL,
    ERROR_INVALID_SID,
    ERROR_INVALID_SECURITY_DESCR,                      // =  1338
    ERROR_BAD_INHERITANCE_ACL                             =  1340,
    ERROR_SERVER_DISABLED,
    ERROR_SERVER_NOT_DISABLED,
    ERROR_INVALID_ID_AUTHORITY,
    ERROR_ALLOTTED_SPACE_EXCEEDED,
    ERROR_INVALID_GROUP_ATTRIBUTES,
    ERROR_BAD_IMPERSONATION_LEVEL,
    ERROR_CANT_OPEN_ANONYMOUS,
    ERROR_BAD_VALIDATION_CLASS,
    ERROR_BAD_TOKEN_TYPE,
    ERROR_NO_SECURITY_ON_OBJECT,
    ERROR_CANT_ACCESS_DOMAIN_INFO,
    ERROR_INVALID_SERVER_STATE,
    ERROR_INVALID_DOMAIN_STATE,
    ERROR_INVALID_DOMAIN_ROLE,
    ERROR_NO_SUCH_DOMAIN,
    ERROR_DOMAIN_EXISTS,
    ERROR_DOMAIN_LIMIT_EXCEEDED,
    ERROR_INTERNAL_DB_CORRUPTION,
    ERROR_INTERNAL_ERROR,
    ERROR_GENERIC_NOT_MAPPED,
    ERROR_BAD_DESCRIPTOR_FORMAT,
    ERROR_NOT_LOGON_PROCESS,
    ERROR_LOGON_SESSION_EXISTS,
    ERROR_NO_SUCH_PACKAGE,
    ERROR_BAD_LOGON_SESSION_STATE,
    ERROR_LOGON_SESSION_COLLISION,
    ERROR_INVALID_LOGON_TYPE,
    ERROR_CANNOT_IMPERSONATE,
    ERROR_RXACT_INVALID_STATE,
    ERROR_RXACT_COMMIT_FAILURE,
    ERROR_SPECIAL_ACCOUNT,
    ERROR_SPECIAL_GROUP,
    ERROR_SPECIAL_USER,
    ERROR_MEMBERS_PRIMARY_GROUP,
    ERROR_TOKEN_ALREADY_IN_USE,
    ERROR_NO_SUCH_ALIAS,
    ERROR_MEMBER_NOT_IN_ALIAS,
    ERROR_MEMBER_IN_ALIAS,
    ERROR_ALIAS_EXISTS,
    ERROR_LOGON_NOT_GRANTED,
    ERROR_TOO_MANY_SECRETS,
    ERROR_SECRET_TOO_LONG,
    ERROR_INTERNAL_DB_ERROR,
    ERROR_TOO_MANY_CONTEXT_IDS,
    ERROR_LOGON_TYPE_NOT_GRANTED,
    ERROR_NT_CROSS_ENCRYPTION_REQUIRED,
    ERROR_NO_SUCH_MEMBER,
    ERROR_INVALID_MEMBER,
    ERROR_TOO_MANY_SIDS,
    ERROR_LM_CROSS_ENCRYPTION_REQUIRED,
    ERROR_NO_INHERITANCE,
    ERROR_FILE_CORRUPT,
    ERROR_DISK_CORRUPT,
    ERROR_NO_USER_SESSION_KEY,
    ERROR_LICENSE_QUOTA_EXCEEDED,
    ERROR_WRONG_TARGET_NAME,
    ERROR_MUTUAL_AUTH_FAILED,
    ERROR_TIME_SKEW,
    ERROR_CURRENT_DOMAIN_NOT_ALLOWED,
    ERROR_INVALID_WINDOW_HANDLE,
    ERROR_INVALID_MENU_HANDLE,
    ERROR_INVALID_CURSOR_HANDLE,
    ERROR_INVALID_ACCEL_HANDLE,
    ERROR_INVALID_HOOK_HANDLE,
    ERROR_INVALID_DWP_HANDLE,
    ERROR_TLW_WITH_WSCHILD,
    ERROR_CANNOT_FIND_WND_CLASS,
    ERROR_WINDOW_OF_OTHER_THREAD,
    ERROR_HOTKEY_ALREADY_REGISTERED,
    ERROR_CLASS_ALREADY_EXISTS,
    ERROR_CLASS_DOES_NOT_EXIST,
    ERROR_CLASS_HAS_WINDOWS,
    ERROR_INVALID_INDEX,
    ERROR_INVALID_ICON_HANDLE,
    ERROR_PRIVATE_DIALOG_INDEX,
    ERROR_LISTBOX_ID_NOT_FOUND,
    ERROR_NO_WILDCARD_CHARACTERS,
    ERROR_CLIPBOARD_NOT_OPEN,
    ERROR_HOTKEY_NOT_REGISTERED,
    ERROR_WINDOW_NOT_DIALOG,
    ERROR_CONTROL_ID_NOT_FOUND,
    ERROR_INVALID_COMBOBOX_MESSAGE,
    ERROR_WINDOW_NOT_COMBOBOX,
    ERROR_INVALID_EDIT_HEIGHT,
    ERROR_DC_NOT_FOUND,
    ERROR_INVALID_HOOK_FILTER,
    ERROR_INVALID_FILTER_PROC,
    ERROR_HOOK_NEEDS_HMOD,
    ERROR_GLOBAL_ONLY_HOOK,
    ERROR_JOURNAL_HOOK_SET,
    ERROR_HOOK_NOT_INSTALLED,
    ERROR_INVALID_LB_MESSAGE,
    ERROR_SETCOUNT_ON_BAD_LB,
    ERROR_LB_WITHOUT_TABSTOPS,
    ERROR_DESTROY_OBJECT_OF_OTHER_THREAD,
    ERROR_CHILD_WINDOW_MENU,
    ERROR_NO_SYSTEM_MENU,
    ERROR_INVALID_MSGBOX_STYLE,
    ERROR_INVALID_SPI_VALUE,
    ERROR_SCREEN_ALREADY_LOCKED,
    ERROR_HWNDS_HAVE_DIFF_PARENT,
    ERROR_NOT_CHILD_WINDOW,
    ERROR_INVALID_GW_COMMAND,
    ERROR_INVALID_THREAD_ID,
    ERROR_NON_MDICHILD_WINDOW,
    ERROR_POPUP_ALREADY_ACTIVE,
    ERROR_NO_SCROLLBARS,
    ERROR_INVALID_SCROLLBAR_RANGE,
    ERROR_INVALID_SHOWWIN_COMMAND,
    ERROR_NO_SYSTEM_RESOURCES,
    ERROR_NONPAGED_SYSTEM_RESOURCES,
    ERROR_PAGED_SYSTEM_RESOURCES,
    ERROR_WORKING_SET_QUOTA,
    ERROR_PAGEFILE_QUOTA,
    ERROR_COMMITMENT_LIMIT,
    ERROR_MENU_ITEM_NOT_FOUND,
    ERROR_INVALID_KEYBOARD_HANDLE,
    ERROR_HOOK_TYPE_NOT_ALLOWED,
    ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION,
    ERROR_TIMEOUT,
    ERROR_INVALID_MONITOR_HANDLE,                      // =  1461
    ERROR_EVENTLOG_FILE_CORRUPT                           =  1500,
    ERROR_EVENTLOG_CANT_START,
    ERROR_LOG_FILE_FULL,
    ERROR_EVENTLOG_FILE_CHANGED,                       // =  1503
    ERROR_INSTALL_SERVICE_FAILURE                         =  1601,
    ERROR_INSTALL_USEREXIT,
    ERROR_INSTALL_FAILURE,
    ERROR_INSTALL_SUSPEND,
    ERROR_UNKNOWN_PRODUCT,
    ERROR_UNKNOWN_FEATURE,
    ERROR_UNKNOWN_COMPONENT,
    ERROR_UNKNOWN_PROPERTY,
    ERROR_INVALID_HANDLE_STATE,
    ERROR_BAD_CONFIGURATION,
    ERROR_INDEX_ABSENT,
    ERROR_INSTALL_SOURCE_ABSENT,
    ERROR_INSTALL_PACKAGE_VERSION,
    ERROR_PRODUCT_UNINSTALLED,
    ERROR_BAD_QUERY_SYNTAX,
    ERROR_INVALID_FIELD,
    ERROR_DEVICE_REMOVED,
    ERROR_INSTALL_ALREADY_RUNNING,
    ERROR_INSTALL_PACKAGE_OPEN_FAILED,
    ERROR_INSTALL_PACKAGE_INVALID,
    ERROR_INSTALL_UI_FAILURE,
    ERROR_INSTALL_LOG_FAILURE,
    ERROR_INSTALL_LANGUAGE_UNSUPPORTED,
    ERROR_INSTALL_TRANSFORM_FAILURE,
    ERROR_INSTALL_PACKAGE_REJECTED,
    ERROR_FUNCTION_NOT_CALLED,
    ERROR_FUNCTION_FAILED,
    ERROR_INVALID_TABLE,
    ERROR_DATATYPE_MISMATCH,
    ERROR_UNSUPPORTED_TYPE,
    ERROR_CREATE_FAILED,
    ERROR_INSTALL_TEMP_UNWRITABLE,
    ERROR_INSTALL_PLATFORM_UNSUPPORTED,
    ERROR_INSTALL_NOTUSED,
    ERROR_PATCH_PACKAGE_OPEN_FAILED,
    ERROR_PATCH_PACKAGE_INVALID,
    ERROR_PATCH_PACKAGE_UNSUPPORTED,
    ERROR_PRODUCT_VERSION,
    ERROR_INVALID_COMMAND_LINE,
    ERROR_INSTALL_REMOTE_DISALLOWED,
    ERROR_SUCCESS_REBOOT_INITIATED,
    ERROR_PATCH_TARGET_NOT_FOUND,
    ERROR_PATCH_PACKAGE_REJECTED,
    ERROR_INSTALL_TRANSFORM_REJECTED,
    ERROR_INSTALL_REMOTE_PROHIBITED,                   // =  1645
    RPC_S_INVALID_STRING_BINDING                          =  1700,
    RPC_S_WRONG_KIND_OF_BINDING,
    RPC_S_INVALID_BINDING,
    RPC_S_PROTSEQ_NOT_SUPPORTED,
    RPC_S_INVALID_RPC_PROTSEQ,
    RPC_S_INVALID_STRING_UUID,
    RPC_S_INVALID_ENDPOINT_FORMAT,
    RPC_S_INVALID_NET_ADDR,
    RPC_S_NO_ENDPOINT_FOUND,
    RPC_S_INVALID_TIMEOUT,
    RPC_S_OBJECT_NOT_FOUND,
    RPC_S_ALREADY_REGISTERED,
    RPC_S_TYPE_ALREADY_REGISTERED,
    RPC_S_ALREADY_LISTENING,
    RPC_S_NO_PROTSEQS_REGISTERED,
    RPC_S_NOT_LISTENING,
    RPC_S_UNKNOWN_MGR_TYPE,
    RPC_S_UNKNOWN_IF,
    RPC_S_NO_BINDINGS,
    RPC_S_NO_PROTSEQS,
    RPC_S_CANT_CREATE_ENDPOINT,
    RPC_S_OUT_OF_RESOURCES,
    RPC_S_SERVER_UNAVAILABLE,
    RPC_S_SERVER_TOO_BUSY,
    RPC_S_INVALID_NETWORK_OPTIONS,
    RPC_S_NO_CALL_ACTIVE,
    RPC_S_CALL_FAILED,
    RPC_S_CALL_FAILED_DNE,
    RPC_S_PROTOCOL_ERROR,                              // =  1728
    RPC_S_UNSUPPORTED_TRANS_SYN                           =  1730,
    RPC_S_UNSUPPORTED_TYPE                                =  1732,
    RPC_S_INVALID_TAG,
    RPC_S_INVALID_BOUND,
    RPC_S_NO_ENTRY_NAME,
    RPC_S_INVALID_NAME_SYNTAX,
    RPC_S_UNSUPPORTED_NAME_SYNTAX,                     // =  1737
    RPC_S_UUID_NO_ADDRESS                                 =  1739,
    RPC_S_DUPLICATE_ENDPOINT,
    RPC_S_UNKNOWN_AUTHN_TYPE,
    RPC_S_MAX_CALLS_TOO_SMALL,
    RPC_S_STRING_TOO_LONG,
    RPC_S_PROTSEQ_NOT_FOUND,
    RPC_S_PROCNUM_OUT_OF_RANGE,
    RPC_S_BINDING_HAS_NO_AUTH,
    RPC_S_UNKNOWN_AUTHN_SERVICE,
    RPC_S_UNKNOWN_AUTHN_LEVEL,
    RPC_S_INVALID_AUTH_IDENTITY,
    RPC_S_UNKNOWN_AUTHZ_SERVICE,
    EPT_S_INVALID_ENTRY,
    EPT_S_CANT_PERFORM_OP,
    EPT_S_NOT_REGISTERED,
    RPC_S_NOTHING_TO_EXPORT,
    RPC_S_INCOMPLETE_NAME,
    RPC_S_INVALID_VERS_OPTION,
    RPC_S_NO_MORE_MEMBERS,
    RPC_S_NOT_ALL_OBJS_UNEXPORTED,
    RPC_S_INTERFACE_NOT_FOUND,
    RPC_S_ENTRY_ALREADY_EXISTS,
    RPC_S_ENTRY_NOT_FOUND,
    RPC_S_NAME_SERVICE_UNAVAILABLE,
    RPC_S_INVALID_NAF_ID,
    RPC_S_CANNOT_SUPPORT,
    RPC_S_NO_CONTEXT_AVAILABLE,
    RPC_S_INTERNAL_ERROR,
    RPC_S_ZERO_DIVIDE,
    RPC_S_ADDRESS_ERROR,
    RPC_S_FP_DIV_ZERO,
    RPC_S_FP_UNDERFLOW,
    RPC_S_FP_OVERFLOW,
    RPC_X_NO_MORE_ENTRIES,
    RPC_X_SS_CHAR_TRANS_OPEN_FAIL,
    RPC_X_SS_CHAR_TRANS_SHORT_FILE,
    RPC_X_SS_IN_NULL_CONTEXT,                          // =  1775
    RPC_X_SS_CONTEXT_DAMAGED                              =  1777,
    RPC_X_SS_HANDLES_MISMATCH,
    RPC_X_SS_CANNOT_GET_CALL_HANDLE,
    RPC_X_NULL_REF_POINTER,
    RPC_X_ENUM_VALUE_OUT_OF_RANGE,
    RPC_X_BYTE_COUNT_TOO_SMALL,
    RPC_X_BAD_STUB_DATA,
    ERROR_INVALID_USER_BUFFER,
    ERROR_UNRECOGNIZED_MEDIA,
    ERROR_NO_TRUST_LSA_SECRET,
    ERROR_NO_TRUST_SAM_ACCOUNT,
    ERROR_TRUSTED_DOMAIN_FAILURE,
    ERROR_TRUSTED_RELATIONSHIP_FAILURE,
    ERROR_TRUST_FAILURE,
    RPC_S_CALL_IN_PROGRESS,
    ERROR_NETLOGON_NOT_STARTED,
    ERROR_ACCOUNT_EXPIRED,
    ERROR_REDIRECTOR_HAS_OPEN_HANDLES,
    ERROR_PRINTER_DRIVER_ALREADY_INSTALLED,
    ERROR_UNKNOWN_PORT,
    ERROR_UNKNOWN_PRINTER_DRIVER,
    ERROR_UNKNOWN_PRINTPROCESSOR,
    ERROR_INVALID_SEPARATOR_FILE,
    ERROR_INVALID_PRIORITY,
    ERROR_INVALID_PRINTER_NAME,
    ERROR_PRINTER_ALREADY_EXISTS,
    ERROR_INVALID_PRINTER_COMMAND,
    ERROR_INVALID_DATATYPE,
    ERROR_INVALID_ENVIRONMENT,
    RPC_S_NO_MORE_BINDINGS,
    ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT,
    ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT,
    ERROR_NOLOGON_SERVER_TRUST_ACCOUNT,
    ERROR_DOMAIN_TRUST_INCONSISTENT,
    ERROR_SERVER_HAS_OPEN_HANDLES,
    ERROR_RESOURCE_DATA_NOT_FOUND,
    ERROR_RESOURCE_TYPE_NOT_FOUND,
    ERROR_RESOURCE_NAME_NOT_FOUND,
    ERROR_RESOURCE_LANG_NOT_FOUND,
    ERROR_NOT_ENOUGH_QUOTA,
    RPC_S_NO_INTERFACES,
    RPC_S_CALL_CANCELLED,
    RPC_S_BINDING_INCOMPLETE,
    RPC_S_COMM_FAILURE,
    RPC_S_UNSUPPORTED_AUTHN_LEVEL,
    RPC_S_NO_PRINC_NAME,
    RPC_S_NOT_RPC_ERROR,
    RPC_S_UUID_LOCAL_ONLY,
    RPC_S_SEC_PKG_ERROR,
    RPC_S_NOT_CANCELLED,
    RPC_X_INVALID_ES_ACTION,
    RPC_X_WRONG_ES_VERSION,
    RPC_X_WRONG_STUB_VERSION,
    RPC_X_INVALID_PIPE_OBJECT,
    RPC_X_WRONG_PIPE_ORDER,
    RPC_X_WRONG_PIPE_VERSION,                          // =  1832
    RPC_S_GROUP_MEMBER_NOT_FOUND                          =  1898,
    EPT_S_CANT_CREATE,
    RPC_S_INVALID_OBJECT,
    ERROR_INVALID_TIME,
    ERROR_INVALID_FORM_NAME,
    ERROR_INVALID_FORM_SIZE,
    ERROR_ALREADY_WAITING,
    ERROR_PRINTER_DELETED,
    ERROR_INVALID_PRINTER_STATE,
    ERROR_PASSWORD_MUST_CHANGE,
    ERROR_DOMAIN_CONTROLLER_NOT_FOUND,
    ERROR_ACCOUNT_LOCKED_OUT,
    OR_INVALID_OXID,
    OR_INVALID_OID,
    OR_INVALID_SET,
    RPC_S_SEND_INCOMPLETE,
    RPC_S_INVALID_ASYNC_HANDLE,
    RPC_S_INVALID_ASYNC_CALL,
    RPC_X_PIPE_CLOSED,
    RPC_X_PIPE_DISCIPLINE_ERROR,
    RPC_X_PIPE_EMPTY,
    ERROR_NO_SITENAME,
    ERROR_CANT_ACCESS_FILE,
    ERROR_CANT_RESOLVE_FILENAME,
    RPC_S_ENTRY_TYPE_MISMATCH,
    RPC_S_NOT_ALL_OBJS_EXPORTED,
    RPC_S_INTERFACE_NOT_EXPORTED,
    RPC_S_PROFILE_NOT_ADDED,
    RPC_S_PRF_ELT_NOT_ADDED,
    RPC_S_PRF_ELT_NOT_REMOVED,
    RPC_S_GRP_ELT_NOT_ADDED,
    RPC_S_GRP_ELT_NOT_REMOVED,
    ERROR_KM_DRIVER_BLOCKED,
    ERROR_CONTEXT_EXPIRED,
    ERROR_PER_USER_TRUST_QUOTA_EXCEEDED,
    ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED,
    ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED,            // =  1934
    ERROR_INVALID_PIXEL_FORMAT                            =  2000,
    ERROR_BAD_DRIVER,
    ERROR_INVALID_WINDOW_STYLE,
    ERROR_METAFILE_NOT_SUPPORTED,
    ERROR_TRANSFORM_NOT_SUPPORTED,
    ERROR_CLIPPING_NOT_SUPPORTED,                      // =  2005
    ERROR_INVALID_CMM                                     =  2010,
    ERROR_INVALID_PROFILE,
    ERROR_TAG_NOT_FOUND,
    ERROR_TAG_NOT_PRESENT,
    ERROR_DUPLICATE_TAG,
    ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE,
    ERROR_PROFILE_NOT_FOUND,
    ERROR_INVALID_COLORSPACE,
    ERROR_ICM_NOT_ENABLED,
    ERROR_DELETING_ICM_XFORM,
    ERROR_INVALID_TRANSFORM,
    ERROR_COLORSPACE_MISMATCH,
    ERROR_INVALID_COLORINDEX,                          // =  2022
    ERROR_CONNECTED_OTHER_PASSWORD                        =  2108,
    ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT,            // =  2109
    ERROR_BAD_USERNAME                                    =  2202,
    ERROR_NOT_CONNECTED                                   =  2250,
    ERROR_OPEN_FILES                                      =  2401,
    ERROR_ACTIVE_CONNECTIONS,                          // =  2402
    ERROR_DEVICE_IN_USE                                   =  2404,
    ERROR_UNKNOWN_PRINT_MONITOR                           =  3000,
    ERROR_PRINTER_DRIVER_IN_USE,
    ERROR_SPOOL_FILE_NOT_FOUND,
    ERROR_SPL_NO_STARTDOC,
    ERROR_SPL_NO_ADDJOB,
    ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED,
    ERROR_PRINT_MONITOR_ALREADY_INSTALLED,
    ERROR_INVALID_PRINT_MONITOR,
    ERROR_PRINT_MONITOR_IN_USE,
    ERROR_PRINTER_HAS_JOBS_QUEUED,
    ERROR_SUCCESS_REBOOT_REQUIRED,
    ERROR_SUCCESS_RESTART_REQUIRED,
    ERROR_PRINTER_NOT_FOUND,
    ERROR_PRINTER_DRIVER_WARNED,
    ERROR_PRINTER_DRIVER_BLOCKED,                      // =  3014
    ERROR_WINS_INTERNAL                                   =  4000,
    ERROR_CAN_NOT_DEL_LOCAL_WINS,
    ERROR_STATIC_INIT,
    ERROR_INC_BACKUP,
    ERROR_FULL_BACKUP,
    ERROR_REC_NON_EXISTENT,
    ERROR_RPL_NOT_ALLOWED,                             // =  4006
    ERROR_DHCP_ADDRESS_CONFLICT                           =  4100,
    ERROR_WMI_GUID_NOT_FOUND                              =  4200,
    ERROR_WMI_INSTANCE_NOT_FOUND,
    ERROR_WMI_ITEMID_NOT_FOUND,
    ERROR_WMI_TRY_AGAIN,
    ERROR_WMI_DP_NOT_FOUND,
    ERROR_WMI_UNRESOLVED_INSTANCE_REF,
    ERROR_WMI_ALREADY_ENABLED,
    ERROR_WMI_GUID_DISCONNECTED,
    ERROR_WMI_SERVER_UNAVAILABLE,
    ERROR_WMI_DP_FAILED,
    ERROR_WMI_INVALID_MOF,
    ERROR_WMI_INVALID_REGINFO,
    ERROR_WMI_ALREADY_DISABLED,
    ERROR_WMI_READ_ONLY,
    ERROR_WMI_SET_FAILURE,                             // =  4214
    ERROR_INVALID_MEDIA                                   =  4300,
    ERROR_INVALID_LIBRARY,
    ERROR_INVALID_MEDIA_POOL,
    ERROR_DRIVE_MEDIA_MISMATCH,
    ERROR_MEDIA_OFFLINE,
    ERROR_LIBRARY_OFFLINE,
    ERROR_EMPTY,
    ERROR_NOT_EMPTY,
    ERROR_MEDIA_UNAVAILABLE,
    ERROR_RESOURCE_DISABLED,
    ERROR_INVALID_CLEANER,
    ERROR_UNABLE_TO_CLEAN,
    ERROR_OBJECT_NOT_FOUND,
    ERROR_DATABASE_FAILURE,
    ERROR_DATABASE_FULL,
    ERROR_MEDIA_INCOMPATIBLE,
    ERROR_RESOURCE_NOT_PRESENT,
    ERROR_INVALID_OPERATION,
    ERROR_MEDIA_NOT_AVAILABLE,
    ERROR_DEVICE_NOT_AVAILABLE,
    ERROR_REQUEST_REFUSED,
    ERROR_INVALID_DRIVE_OBJECT,
    ERROR_LIBRARY_FULL,
    ERROR_MEDIUM_NOT_ACCESSIBLE,
    ERROR_UNABLE_TO_LOAD_MEDIUM,
    ERROR_UNABLE_TO_INVENTORY_DRIVE,
    ERROR_UNABLE_TO_INVENTORY_SLOT,
    ERROR_UNABLE_TO_INVENTORY_TRANSPORT,
    ERROR_TRANSPORT_FULL,
    ERROR_CONTROLLING_IEPORT,
    ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA,
    ERROR_CLEANER_SLOT_SET,
    ERROR_CLEANER_SLOT_NOT_SET,
    ERROR_CLEANER_CARTRIDGE_SPENT,
    ERROR_UNEXPECTED_OMID,
    ERROR_CANT_DELETE_LAST_ITEM,
    ERROR_MESSAGE_EXCEEDS_MAX_SIZE,
    ERROR_VOLUME_CONTAINS_SYS_FILES,
    ERROR_INDIGENOUS_TYPE,
    ERROR_NO_SUPPORTING_DRIVES,
    ERROR_CLEANER_CARTRIDGE_INSTALLED,                 // =  4340
    ERROR_FILE_OFFLINE                                    =  4350,
    ERROR_REMOTE_STORAGE_NOT_ACTIVE,
    ERROR_REMOTE_STORAGE_MEDIA_ERROR,                  // =  4352
    ERROR_NOT_A_REPARSE_POINT                             =  4390,
    ERROR_REPARSE_ATTRIBUTE_CONFLICT,
    ERROR_INVALID_REPARSE_DATA,
    ERROR_REPARSE_TAG_INVALID,
    ERROR_REPARSE_TAG_MISMATCH,                        // =  4394
    ERROR_VOLUME_NOT_SIS_ENABLED                          =  4500,
    ERROR_DEPENDENT_RESOURCE_EXISTS                       =  5001,
    ERROR_DEPENDENCY_NOT_FOUND,
    ERROR_DEPENDENCY_ALREADY_EXISTS,
    ERROR_RESOURCE_NOT_ONLINE,
    ERROR_HOST_NODE_NOT_AVAILABLE,
    ERROR_RESOURCE_NOT_AVAILABLE,
    ERROR_RESOURCE_NOT_FOUND,
    ERROR_SHUTDOWN_CLUSTER,
    ERROR_CANT_EVICT_ACTIVE_NODE,
    ERROR_OBJECT_ALREADY_EXISTS,
    ERROR_OBJECT_IN_LIST,
    ERROR_GROUP_NOT_AVAILABLE,
    ERROR_GROUP_NOT_FOUND,
    ERROR_GROUP_NOT_ONLINE,
    ERROR_HOST_NODE_NOT_RESOURCE_OWNER,
    ERROR_HOST_NODE_NOT_GROUP_OWNER,
    ERROR_RESMON_CREATE_FAILED,
    ERROR_RESMON_ONLINE_FAILED,
    ERROR_RESOURCE_ONLINE,
    ERROR_QUORUM_RESOURCE,
    ERROR_NOT_QUORUM_CAPABLE,
    ERROR_CLUSTER_SHUTTING_DOWN,
    ERROR_INVALID_STATE,
    ERROR_RESOURCE_PROPERTIES_STORED,
    ERROR_NOT_QUORUM_CLASS,
    ERROR_CORE_RESOURCE,
    ERROR_QUORUM_RESOURCE_ONLINE_FAILED,
    ERROR_QUORUMLOG_OPEN_FAILED,
    ERROR_CLUSTERLOG_CORRUPT,
    ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE,
    ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE,
    ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND,
    ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE,
    ERROR_QUORUM_OWNER_ALIVE,
    ERROR_NETWORK_NOT_AVAILABLE,
    ERROR_NODE_NOT_AVAILABLE,
    ERROR_ALL_NODES_NOT_AVAILABLE,
    ERROR_RESOURCE_FAILED,
    ERROR_CLUSTER_INVALID_NODE,
    ERROR_CLUSTER_NODE_EXISTS,
    ERROR_CLUSTER_JOIN_IN_PROGRESS,
    ERROR_CLUSTER_NODE_NOT_FOUND,
    ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND,
    ERROR_CLUSTER_NETWORK_EXISTS,
    ERROR_CLUSTER_NETWORK_NOT_FOUND,
    ERROR_CLUSTER_NETINTERFACE_EXISTS,
    ERROR_CLUSTER_NETINTERFACE_NOT_FOUND,
    ERROR_CLUSTER_INVALID_REQUEST,
    ERROR_CLUSTER_INVALID_NETWORK_PROVIDER,
    ERROR_CLUSTER_NODE_DOWN,
    ERROR_CLUSTER_NODE_UNREACHABLE,
    ERROR_CLUSTER_NODE_NOT_MEMBER,
    ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS,
    ERROR_CLUSTER_INVALID_NETWORK,                     // =  5054
    ERROR_CLUSTER_NODE_UP                                 =  5056,
    ERROR_CLUSTER_IPADDR_IN_USE,
    ERROR_CLUSTER_NODE_NOT_PAUSED,
    ERROR_CLUSTER_NO_SECURITY_CONTEXT,
    ERROR_CLUSTER_NETWORK_NOT_INTERNAL,
    ERROR_CLUSTER_NODE_ALREADY_UP,
    ERROR_CLUSTER_NODE_ALREADY_DOWN,
    ERROR_CLUSTER_NETWORK_ALREADY_ONLINE,
    ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE,
    ERROR_CLUSTER_NODE_ALREADY_MEMBER,
    ERROR_CLUSTER_LAST_INTERNAL_NETWORK,
    ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS,
    ERROR_INVALID_OPERATION_ON_QUORUM,
    ERROR_DEPENDENCY_NOT_ALLOWED,
    ERROR_CLUSTER_NODE_PAUSED,
    ERROR_NODE_CANT_HOST_RESOURCE,
    ERROR_CLUSTER_NODE_NOT_READY,
    ERROR_CLUSTER_NODE_SHUTTING_DOWN,
    ERROR_CLUSTER_JOIN_ABORTED,
    ERROR_CLUSTER_INCOMPATIBLE_VERSIONS,
    ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED,
    ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED,
    ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND,
    ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED,
    ERROR_CLUSTER_RESNAME_NOT_FOUND,
    ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED,
    ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST,
    ERROR_CLUSTER_DATABASE_SEQMISMATCH,
    ERROR_RESMON_INVALID_STATE,
    ERROR_CLUSTER_GUM_NOT_LOCKER,
    ERROR_QUORUM_DISK_NOT_FOUND,
    ERROR_DATABASE_BACKUP_CORRUPT,
    ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT,
    ERROR_RESOURCE_PROPERTY_UNCHANGEABLE,              // =  5089
    ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE                =  5890,
    ERROR_CLUSTER_QUORUMLOG_NOT_FOUND,
    ERROR_CLUSTER_MEMBERSHIP_HALT,
    ERROR_CLUSTER_INSTANCE_ID_MISMATCH,
    ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP,
    ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH,
    ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP,
    ERROR_CLUSTER_PARAMETER_MISMATCH,
    ERROR_NODE_CANNOT_BE_CLUSTERED,
    ERROR_CLUSTER_WRONG_OS_VERSION,
    ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME,
    ERROR_CLUSCFG_ALREADY_COMMITTED,
    ERROR_CLUSCFG_ROLLBACK_FAILED,
    ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT,
    ERROR_CLUSTER_OLD_VERSION,
    ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME,       // =  5905
    ERROR_ENCRYPTION_FAILED                               =  6000,
    ERROR_DECRYPTION_FAILED,
    ERROR_FILE_ENCRYPTED,
    ERROR_NO_RECOVERY_POLICY,
    ERROR_NO_EFS,
    ERROR_WRONG_EFS,
    ERROR_NO_USER_KEYS,
    ERROR_FILE_NOT_ENCRYPTED,
    ERROR_NOT_EXPORT_FORMAT,
    ERROR_FILE_READ_ONLY,
    ERROR_DIR_EFS_DISALLOWED,
    ERROR_EFS_SERVER_NOT_TRUSTED,
    ERROR_BAD_RECOVERY_POLICY,
    ERROR_EFS_ALG_BLOB_TOO_BIG,
    ERROR_VOLUME_NOT_SUPPORT_EFS,
    ERROR_EFS_DISABLED,
    ERROR_EFS_VERSION_NOT_SUPPORT,                     // =  6016
    ERROR_NO_BROWSER_SERVERS_FOUND                        =  6118,
    SCHED_E_SERVICE_NOT_LOCALSYSTEM                       =  6200,

    ERROR_CTX_WINSTATION_NAME_INVALID                     =  7001,
    ERROR_CTX_INVALID_PD,
    ERROR_CTX_PD_NOT_FOUND,
    ERROR_CTX_WD_NOT_FOUND,
    ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY,
    ERROR_CTX_SERVICE_NAME_COLLISION,
    ERROR_CTX_CLOSE_PENDING,
    ERROR_CTX_NO_OUTBUF,
    ERROR_CTX_MODEM_INF_NOT_FOUND,
    ERROR_CTX_INVALID_MODEMNAME,
    ERROR_CTX_MODEM_RESPONSE_ERROR,
    ERROR_CTX_MODEM_RESPONSE_TIMEOUT,
    ERROR_CTX_MODEM_RESPONSE_NO_CARRIER,
    ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE,
    ERROR_CTX_MODEM_RESPONSE_BUSY,
    ERROR_CTX_MODEM_RESPONSE_VOICE,
    ERROR_CTX_TD_ERROR,                                // =  7017
    ERROR_CTX_WINSTATION_NOT_FOUND                        =  7022,
    ERROR_CTX_WINSTATION_ALREADY_EXISTS,
    ERROR_CTX_WINSTATION_BUSY,
    ERROR_CTX_BAD_VIDEO_MODE,                          // =  7025
    ERROR_CTX_GRAPHICS_INVALID                            =  7035,
    ERROR_CTX_LOGON_DISABLED                              =  7037,
    ERROR_CTX_NOT_CONSOLE,                             // =  7038
    ERROR_CTX_CLIENT_QUERY_TIMEOUT                        =  7040,
    ERROR_CTX_CONSOLE_DISCONNECT,
    ERROR_CTX_CONSOLE_CONNECT,                         // =  7042
    ERROR_CTX_SHADOW_DENIED                               =  7044,
    ERROR_CTX_WINSTATION_ACCESS_DENIED,                // =  7045
    ERROR_CTX_INVALID_WD                                  =  7049,
    ERROR_CTX_SHADOW_INVALID,
    ERROR_CTX_SHADOW_DISABLED,
    ERROR_CTX_CLIENT_LICENSE_IN_USE,
    ERROR_CTX_CLIENT_LICENSE_NOT_SET,
    ERROR_CTX_LICENSE_NOT_AVAILABLE,
    ERROR_CTX_LICENSE_CLIENT_INVALID,
    ERROR_CTX_LICENSE_EXPIRED,
    ERROR_CTX_SHADOW_NOT_RUNNING,
    ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE,
    ERROR_ACTIVATION_COUNT_EXCEEDED,                   // =  7059

    FRS_ERR_INVALID_API_SEQUENCE                          =  8001,
    FRS_ERR_STARTING_SERVICE,
    FRS_ERR_STOPPING_SERVICE,
    FRS_ERR_INTERNAL_API,
    FRS_ERR_INTERNAL,
    FRS_ERR_SERVICE_COMM,
    FRS_ERR_INSUFFICIENT_PRIV,
    FRS_ERR_AUTHENTICATION,
    FRS_ERR_PARENT_INSUFFICIENT_PRIV,
    FRS_ERR_PARENT_AUTHENTICATION,
    FRS_ERR_CHILD_TO_PARENT_COMM,
    FRS_ERR_PARENT_TO_CHILD_COMM,
    FRS_ERR_SYSVOL_POPULATE,
    FRS_ERR_SYSVOL_POPULATE_TIMEOUT,
    FRS_ERR_SYSVOL_IS_BUSY,
    FRS_ERR_SYSVOL_DEMOTE,
    FRS_ERR_INVALID_SERVICE_PARAMETER,                 // =  8017
    ERROR_DS_NOT_INSTALLED                                =  8200,
    ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY,
    ERROR_DS_NO_ATTRIBUTE_OR_VALUE,
    ERROR_DS_INVALID_ATTRIBUTE_SYNTAX,
    ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED,
    ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS,
    ERROR_DS_BUSY,
    ERROR_DS_UNAVAILABLE,
    ERROR_DS_NO_RIDS_ALLOCATED,
    ERROR_DS_NO_MORE_RIDS,
    ERROR_DS_INCORRECT_ROLE_OWNER,
    ERROR_DS_RIDMGR_INIT_ERROR,
    ERROR_DS_OBJ_CLASS_VIOLATION,
    ERROR_DS_CANT_ON_NON_LEAF,
    ERROR_DS_CANT_ON_RDN,
    ERROR_DS_CANT_MOD_OBJ_CLASS,
    ERROR_DS_CROSS_DOM_MOVE_ERROR,
    ERROR_DS_GC_NOT_AVAILABLE,
    ERROR_SHARED_POLICY,
    ERROR_POLICY_OBJECT_NOT_FOUND,
    ERROR_POLICY_ONLY_IN_DS,
    ERROR_PROMOTION_ACTIVE,
    ERROR_NO_PROMOTION_ACTIVE,                         // =  8222
    ERROR_DS_OPERATIONS_ERROR                             =  8224,
    ERROR_DS_PROTOCOL_ERROR,
    ERROR_DS_TIMELIMIT_EXCEEDED,
    ERROR_DS_SIZELIMIT_EXCEEDED,
    ERROR_DS_ADMIN_LIMIT_EXCEEDED,
    ERROR_DS_COMPARE_FALSE,
    ERROR_DS_COMPARE_TRUE,
    ERROR_DS_AUTH_METHOD_NOT_SUPPORTED,
    ERROR_DS_STRONG_AUTH_REQUIRED,
    ERROR_DS_INAPPROPRIATE_AUTH,
    ERROR_DS_AUTH_UNKNOWN,
    ERROR_DS_REFERRAL,
    ERROR_DS_UNAVAILABLE_CRIT_EXTENSION,
    ERROR_DS_CONFIDENTIALITY_REQUIRED,
    ERROR_DS_INAPPROPRIATE_MATCHING,
    ERROR_DS_CONSTRAINT_VIOLATION,
    ERROR_DS_NO_SUCH_OBJECT,
    ERROR_DS_ALIAS_PROBLEM,
    ERROR_DS_INVALID_DN_SYNTAX,
    ERROR_DS_IS_LEAF,
    ERROR_DS_ALIAS_DEREF_PROBLEM,
    ERROR_DS_UNWILLING_TO_PERFORM,
    ERROR_DS_LOOP_DETECT,
    ERROR_DS_NAMING_VIOLATION,
    ERROR_DS_OBJECT_RESULTS_TOO_LARGE,
    ERROR_DS_AFFECTS_MULTIPLE_DSAS,
    ERROR_DS_SERVER_DOWN,
    ERROR_DS_LOCAL_ERROR,
    ERROR_DS_ENCODING_ERROR,
    ERROR_DS_DECODING_ERROR,
    ERROR_DS_FILTER_UNKNOWN,
    ERROR_DS_PARAM_ERROR,
    ERROR_DS_NOT_SUPPORTED,
    ERROR_DS_NO_RESULTS_RETURNED,
    ERROR_DS_CONTROL_NOT_FOUND,
    ERROR_DS_CLIENT_LOOP,
    ERROR_DS_REFERRAL_LIMIT_EXCEEDED,
    ERROR_DS_SORT_CONTROL_MISSING,
    ERROR_DS_OFFSET_RANGE_ERROR,                       // =  8262
    ERROR_DS_ROOT_MUST_BE_NC                              =  8301,
    ERROR_DS_ADD_REPLICA_INHIBITED,
    ERROR_DS_ATT_NOT_DEF_IN_SCHEMA,
    ERROR_DS_MAX_OBJ_SIZE_EXCEEDED,
    ERROR_DS_OBJ_STRING_NAME_EXISTS,
    ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA,
    ERROR_DS_RDN_DOESNT_MATCH_SCHEMA,
    ERROR_DS_NO_REQUESTED_ATTS_FOUND,
    ERROR_DS_USER_BUFFER_TO_SMALL,
    ERROR_DS_ATT_IS_NOT_ON_OBJ,
    ERROR_DS_ILLEGAL_MOD_OPERATION,
    ERROR_DS_OBJ_TOO_LARGE,
    ERROR_DS_BAD_INSTANCE_TYPE,
    ERROR_DS_MASTERDSA_REQUIRED,
    ERROR_DS_OBJECT_CLASS_REQUIRED,
    ERROR_DS_MISSING_REQUIRED_ATT,
    ERROR_DS_ATT_NOT_DEF_FOR_CLASS,
    ERROR_DS_ATT_ALREADY_EXISTS,                       // =  8318
    ERROR_DS_CANT_ADD_ATT_VALUES                          =  8320,
    ERROR_DS_SINGLE_VALUE_CONSTRAINT,
    ERROR_DS_RANGE_CONSTRAINT,
    ERROR_DS_ATT_VAL_ALREADY_EXISTS,
    ERROR_DS_CANT_REM_MISSING_ATT,
    ERROR_DS_CANT_REM_MISSING_ATT_VAL,
    ERROR_DS_ROOT_CANT_BE_SUBREF,
    ERROR_DS_NO_CHAINING,
    ERROR_DS_NO_CHAINED_EVAL,
    ERROR_DS_NO_PARENT_OBJECT,
    ERROR_DS_PARENT_IS_AN_ALIAS,
    ERROR_DS_CANT_MIX_MASTER_AND_REPS,
    ERROR_DS_CHILDREN_EXIST,
    ERROR_DS_OBJ_NOT_FOUND,
    ERROR_DS_ALIASED_OBJ_MISSING,
    ERROR_DS_BAD_NAME_SYNTAX,
    ERROR_DS_ALIAS_POINTS_TO_ALIAS,
    ERROR_DS_CANT_DEREF_ALIAS,
    ERROR_DS_OUT_OF_SCOPE,
    ERROR_DS_OBJECT_BEING_REMOVED,
    ERROR_DS_CANT_DELETE_DSA_OBJ,
    ERROR_DS_GENERIC_ERROR,
    ERROR_DS_DSA_MUST_BE_INT_MASTER,
    ERROR_DS_CLASS_NOT_DSA,
    ERROR_DS_INSUFF_ACCESS_RIGHTS,
    ERROR_DS_ILLEGAL_SUPERIOR,
    ERROR_DS_ATTRIBUTE_OWNED_BY_SAM,
    ERROR_DS_NAME_TOO_MANY_PARTS,
    ERROR_DS_NAME_TOO_LONG,
    ERROR_DS_NAME_VALUE_TOO_LONG,
    ERROR_DS_NAME_UNPARSEABLE,
    ERROR_DS_NAME_TYPE_UNKNOWN,
    ERROR_DS_NOT_AN_OBJECT,
    ERROR_DS_SEC_DESC_TOO_SHORT,
    ERROR_DS_SEC_DESC_INVALID,
    ERROR_DS_NO_DELETED_NAME,
    ERROR_DS_SUBREF_MUST_HAVE_PARENT,
    ERROR_DS_NCNAME_MUST_BE_NC,
    ERROR_DS_CANT_ADD_SYSTEM_ONLY,
    ERROR_DS_CLASS_MUST_BE_CONCRETE,
    ERROR_DS_INVALID_DMD,
    ERROR_DS_OBJ_GUID_EXISTS,
    ERROR_DS_NOT_ON_BACKLINK,
    ERROR_DS_NO_CROSSREF_FOR_NC,
    ERROR_DS_SHUTTING_DOWN,
    ERROR_DS_UNKNOWN_OPERATION,
    ERROR_DS_INVALID_ROLE_OWNER,
    ERROR_DS_COULDNT_CONTACT_FSMO,
    ERROR_DS_CROSS_NC_DN_RENAME,
    ERROR_DS_CANT_MOD_SYSTEM_ONLY,
    ERROR_DS_REPLICATOR_ONLY,
    ERROR_DS_OBJ_CLASS_NOT_DEFINED,
    ERROR_DS_OBJ_CLASS_NOT_SUBCLASS,
    ERROR_DS_NAME_REFERENCE_INVALID,
    ERROR_DS_CROSS_REF_EXISTS,
    ERROR_DS_CANT_DEL_MASTER_CROSSREF,
    ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD,
    ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX,
    ERROR_DS_DUP_RDN,
    ERROR_DS_DUP_OID,
    ERROR_DS_DUP_MAPI_ID,
    ERROR_DS_DUP_SCHEMA_ID_GUID,
    ERROR_DS_DUP_LDAP_DISPLAY_NAME,
    ERROR_DS_SEMANTIC_ATT_TEST,
    ERROR_DS_SYNTAX_MISMATCH,
    ERROR_DS_EXISTS_IN_MUST_HAVE,
    ERROR_DS_EXISTS_IN_MAY_HAVE,
    ERROR_DS_NONEXISTENT_MAY_HAVE,
    ERROR_DS_NONEXISTENT_MUST_HAVE,
    ERROR_DS_AUX_CLS_TEST_FAIL,
    ERROR_DS_NONEXISTENT_POSS_SUP,
    ERROR_DS_SUB_CLS_TEST_FAIL,
    ERROR_DS_BAD_RDN_ATT_ID_SYNTAX,
    ERROR_DS_EXISTS_IN_AUX_CLS,
    ERROR_DS_EXISTS_IN_SUB_CLS,
    ERROR_DS_EXISTS_IN_POSS_SUP,
    ERROR_DS_RECALCSCHEMA_FAILED,
    ERROR_DS_TREE_DELETE_NOT_FINISHED,
    ERROR_DS_CANT_DELETE,
    ERROR_DS_ATT_SCHEMA_REQ_ID,
    ERROR_DS_BAD_ATT_SCHEMA_SYNTAX,
    ERROR_DS_CANT_CACHE_ATT,
    ERROR_DS_CANT_CACHE_CLASS,
    ERROR_DS_CANT_REMOVE_ATT_CACHE,
    ERROR_DS_CANT_REMOVE_CLASS_CACHE,
    ERROR_DS_CANT_RETRIEVE_DN,
    ERROR_DS_MISSING_SUPREF,
    ERROR_DS_CANT_RETRIEVE_INSTANCE,
    ERROR_DS_CODE_INCONSISTENCY,
    ERROR_DS_DATABASE_ERROR,
    ERROR_DS_GOVERNSID_MISSING,
    ERROR_DS_MISSING_EXPECTED_ATT,
    ERROR_DS_NCNAME_MISSING_CR_REF,
    ERROR_DS_SECURITY_CHECKING_ERROR,
    ERROR_DS_SCHEMA_NOT_LOADED,
    ERROR_DS_SCHEMA_ALLOC_FAILED,
    ERROR_DS_ATT_SCHEMA_REQ_SYNTAX,
    ERROR_DS_GCVERIFY_ERROR,
    ERROR_DS_DRA_SCHEMA_MISMATCH,
    ERROR_DS_CANT_FIND_DSA_OBJ,
    ERROR_DS_CANT_FIND_EXPECTED_NC,
    ERROR_DS_CANT_FIND_NC_IN_CACHE,
    ERROR_DS_CANT_RETRIEVE_CHILD,
    ERROR_DS_SECURITY_ILLEGAL_MODIFY,
    ERROR_DS_CANT_REPLACE_HIDDEN_REC,
    ERROR_DS_BAD_HIERARCHY_FILE,
    ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED,
    ERROR_DS_CONFIG_PARAM_MISSING,
    ERROR_DS_COUNTING_AB_INDICES_FAILED,
    ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED,
    ERROR_DS_INTERNAL_FAILURE,
    ERROR_DS_UNKNOWN_ERROR,
    ERROR_DS_ROOT_REQUIRES_CLASS_TOP,
    ERROR_DS_REFUSING_FSMO_ROLES,
    ERROR_DS_MISSING_FSMO_SETTINGS,
    ERROR_DS_UNABLE_TO_SURRENDER_ROLES,
    ERROR_DS_DRA_GENERIC,
    ERROR_DS_DRA_INVALID_PARAMETER,
    ERROR_DS_DRA_BUSY,
    ERROR_DS_DRA_BAD_DN,
    ERROR_DS_DRA_BAD_NC,
    ERROR_DS_DRA_DN_EXISTS,
    ERROR_DS_DRA_INTERNAL_ERROR,
    ERROR_DS_DRA_INCONSISTENT_DIT,
    ERROR_DS_DRA_CONNECTION_FAILED,
    ERROR_DS_DRA_BAD_INSTANCE_TYPE,
    ERROR_DS_DRA_OUT_OF_MEM,
    ERROR_DS_DRA_MAIL_PROBLEM,
    ERROR_DS_DRA_REF_ALREADY_EXISTS,
    ERROR_DS_DRA_REF_NOT_FOUND,
    ERROR_DS_DRA_OBJ_IS_REP_SOURCE,
    ERROR_DS_DRA_DB_ERROR,
    ERROR_DS_DRA_NO_REPLICA,
    ERROR_DS_DRA_ACCESS_DENIED,
    ERROR_DS_DRA_NOT_SUPPORTED,
    ERROR_DS_DRA_RPC_CANCELLED,
    ERROR_DS_DRA_SOURCE_DISABLED,
    ERROR_DS_DRA_SINK_DISABLED,
    ERROR_DS_DRA_NAME_COLLISION,
    ERROR_DS_DRA_SOURCE_REINSTALLED,
    ERROR_DS_DRA_MISSING_PARENT,
    ERROR_DS_DRA_PREEMPTED,
    ERROR_DS_DRA_ABANDON_SYNC,
    ERROR_DS_DRA_SHUTDOWN,
    ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET,
    ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA,
    ERROR_DS_DRA_EXTN_CONNECTION_FAILED,
    ERROR_DS_INSTALL_SCHEMA_MISMATCH,
    ERROR_DS_DUP_LINK_ID,
    ERROR_DS_NAME_ERROR_RESOLVING,
    ERROR_DS_NAME_ERROR_NOT_FOUND,
    ERROR_DS_NAME_ERROR_NOT_UNIQUE,
    ERROR_DS_NAME_ERROR_NO_MAPPING,
    ERROR_DS_NAME_ERROR_DOMAIN_ONLY,
    ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING,
    ERROR_DS_CONSTRUCTED_ATT_MOD,
    ERROR_DS_WRONG_OM_OBJ_CLASS,
    ERROR_DS_DRA_REPL_PENDING,
    ERROR_DS_DS_REQUIRED,
    ERROR_DS_INVALID_LDAP_DISPLAY_NAME,
    ERROR_DS_NON_BASE_SEARCH,
    ERROR_DS_CANT_RETRIEVE_ATTS,
    ERROR_DS_BACKLINK_WITHOUT_LINK,
    ERROR_DS_EPOCH_MISMATCH,
    ERROR_DS_SRC_NAME_MISMATCH,
    ERROR_DS_SRC_AND_DST_NC_IDENTICAL,
    ERROR_DS_DST_NC_MISMATCH,
    ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC,
    ERROR_DS_SRC_GUID_MISMATCH,
    ERROR_DS_CANT_MOVE_DELETED_OBJECT,
    ERROR_DS_PDC_OPERATION_IN_PROGRESS,
    ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD,
    ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION,
    ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS,
    ERROR_DS_NC_MUST_HAVE_NC_PARENT,
    ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE,
    ERROR_DS_DST_DOMAIN_NOT_NATIVE,
    ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER,
    ERROR_DS_CANT_MOVE_ACCOUNT_GROUP,
    ERROR_DS_CANT_MOVE_RESOURCE_GROUP,
    ERROR_DS_INVALID_SEARCH_FLAG,
    ERROR_DS_NO_TREE_DELETE_ABOVE_NC,
    ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE,
    ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE,
    ERROR_DS_SAM_INIT_FAILURE,
    ERROR_DS_SENSITIVE_GROUP_VIOLATION,
    ERROR_DS_CANT_MOD_PRIMARYGROUPID,
    ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD,
    ERROR_DS_NONSAFE_SCHEMA_CHANGE,
    ERROR_DS_SCHEMA_UPDATE_DISALLOWED,
    ERROR_DS_CANT_CREATE_UNDER_SCHEMA,
    ERROR_DS_INSTALL_NO_SRC_SCH_VERSION,
    ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE,
    ERROR_DS_INVALID_GROUP_TYPE,
    ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN,
    ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN,
    ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER,
    ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER,
    ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER,
    ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER,
    ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER,
    ERROR_DS_HAVE_PRIMARY_MEMBERS,
    ERROR_DS_STRING_SD_CONVERSION_FAILED,
    ERROR_DS_NAMING_MASTER_GC,
    ERROR_DS_LOOKUP_FAILURE,
    ERROR_DS_COULDNT_UPDATE_SPNS,
    ERROR_DS_CANT_RETRIEVE_SD,
    ERROR_DS_KEY_NOT_UNIQUE,
    ERROR_DS_WRONG_LINKED_ATT_SYNTAX,
    ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD,
    ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY,
    ERROR_DS_CANT_START,
    ERROR_DS_INIT_FAILURE,
    ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION,
    ERROR_DS_SOURCE_DOMAIN_IN_FOREST,
    ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST,
    ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED,
    ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN,
    ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER,
    ERROR_DS_SRC_SID_EXISTS_IN_FOREST,
    ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH,
    ERROR_SAM_INIT_FAILURE,
    ERROR_DS_DRA_SCHEMA_INFO_SHIP,
    ERROR_DS_DRA_SCHEMA_CONFLICT,
    ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT,
    ERROR_DS_DRA_OBJ_NC_MISMATCH,
    ERROR_DS_NC_STILL_HAS_DSAS,
    ERROR_DS_GC_REQUIRED,
    ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY,
    ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS,
    ERROR_DS_CANT_ADD_TO_GC,
    ERROR_DS_NO_CHECKPOINT_WITH_PDC,
    ERROR_DS_SOURCE_AUDITING_NOT_ENABLED,
    ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC,
    ERROR_DS_INVALID_NAME_FOR_SPN,
    ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS,
    ERROR_DS_UNICODEPWD_NOT_IN_QUOTES,
    ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED,
    ERROR_DS_MUST_BE_RUN_ON_DST_DC,
    ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER,
    ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ,
    ERROR_DS_INIT_FAILURE_CONSOLE,
    ERROR_DS_SAM_INIT_FAILURE_CONSOLE,
    ERROR_DS_FOREST_VERSION_TOO_HIGH,
    ERROR_DS_DOMAIN_VERSION_TOO_HIGH,
    ERROR_DS_FOREST_VERSION_TOO_LOW,
    ERROR_DS_DOMAIN_VERSION_TOO_LOW,
    ERROR_DS_INCOMPATIBLE_VERSION,
    ERROR_DS_LOW_DSA_VERSION,
    ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN,
    ERROR_DS_NOT_SUPPORTED_SORT_ORDER,
    ERROR_DS_NAME_NOT_UNIQUE,
    ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4,
    ERROR_DS_OUT_OF_VERSION_STORE,
    ERROR_DS_INCOMPATIBLE_CONTROLS_USED,
    ERROR_DS_NO_REF_DOMAIN,
    ERROR_DS_RESERVED_LINK_ID,
    ERROR_DS_LINK_ID_NOT_AVAILABLE,
    ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER,
    ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE,
    ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC,
    ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG,
    ERROR_DS_MODIFYDN_WRONG_GRANDPARENT,
    ERROR_DS_NAME_ERROR_TRUST_REFERRAL,
    ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER,
    ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD,
    ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2,
    ERROR_DS_THREAD_LIMIT_EXCEEDED,
    ERROR_DS_NOT_CLOSEST,
    ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF,
    ERROR_DS_SINGLE_USER_MODE_FAILED,
    ERROR_DS_NTDSCRIPT_SYNTAX_ERROR,
    ERROR_DS_NTDSCRIPT_PROCESS_ERROR,
    ERROR_DS_DIFFERENT_REPL_EPOCHS,
    ERROR_DS_DRS_EXTENSIONS_CHANGED,
    ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR,
    ERROR_DS_NO_MSDS_INTID,
    ERROR_DS_DUP_MSDS_INTID,
    ERROR_DS_EXISTS_IN_RDNATTID,
    ERROR_DS_AUTHORIZATION_FAILED,
    ERROR_DS_INVALID_SCRIPT,
    ERROR_DS_REMOTE_CROSSREF_OP_FAILED,
    ERROR_DS_CROSS_REF_BUSY,
    ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN,
    ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC,
    ERROR_DS_DUPLICATE_ID_FOUND,
    ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT,
    ERROR_DS_GROUP_CONVERSION_ERROR,
    ERROR_DS_CANT_MOVE_APP_BASIC_GROUP,
    ERROR_DS_CANT_MOVE_APP_QUERY_GROUP,
    ERROR_DS_ROLE_NOT_VERIFIED,
    ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL,
    ERROR_DS_DOMAIN_RENAME_IN_PROGRESS,
    ERROR_DS_EXISTING_AD_CHILD_NC,                     // =  8613
    DNS_ERROR_RCODE_FORMAT_ERROR                          =  9001,
    DNS_ERROR_RCODE_SERVER_FAILURE,
    DNS_ERROR_RCODE_NAME_ERROR,
    DNS_ERROR_RCODE_NOT_IMPLEMENTED,
    DNS_ERROR_RCODE_REFUSED,
    DNS_ERROR_RCODE_YXDOMAIN,
    DNS_ERROR_RCODE_YXRRSET,
    DNS_ERROR_RCODE_NXRRSET,
    DNS_ERROR_RCODE_NOTAUTH,
    DNS_ERROR_RCODE_NOTZONE,                           // =  9010
    DNS_ERROR_RCODE_BADSIG                                =  9016,
    DNS_ERROR_RCODE_BADKEY,
    DNS_ERROR_RCODE_BADTIME,                           // =  9018
    DNS_INFO_NO_RECORDS                                   =  9501,
    DNS_ERROR_BAD_PACKET,
    DNS_ERROR_NO_PACKET,
    DNS_ERROR_RCODE,
    DNS_ERROR_UNSECURE_PACKET,                         // =  9505
    DNS_ERROR_INVALID_TYPE                                =  9551,
    DNS_ERROR_INVALID_IP_ADDRESS,
    DNS_ERROR_INVALID_PROPERTY,
    DNS_ERROR_TRY_AGAIN_LATER,
    DNS_ERROR_NOT_UNIQUE,
    DNS_ERROR_NON_RFC_NAME,
    DNS_STATUS_FQDN,
    DNS_STATUS_DOTTED_NAME,
    DNS_STATUS_SINGLE_PART_NAME,
    DNS_ERROR_INVALID_NAME_CHAR,
    DNS_ERROR_NUMERIC_NAME,
    DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER,
    DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION,
    DNS_ERROR_CANNOT_FIND_ROOT_HINTS,
    DNS_ERROR_INCONSISTENT_ROOT_HINTS,                 // =  9565
    DNS_ERROR_ZONE_DOES_NOT_EXIST                         =  9601,
    DNS_ERROR_NO_ZONE_INFO,
    DNS_ERROR_INVALID_ZONE_OPERATION,
    DNS_ERROR_ZONE_CONFIGURATION_ERROR,
    DNS_ERROR_ZONE_HAS_NO_SOA_RECORD,
    DNS_ERROR_ZONE_HAS_NO_NS_RECORDS,
    DNS_ERROR_ZONE_LOCKED,
    DNS_ERROR_ZONE_CREATION_FAILED,
    DNS_ERROR_ZONE_ALREADY_EXISTS,
    DNS_ERROR_AUTOZONE_ALREADY_EXISTS,
    DNS_ERROR_INVALID_ZONE_TYPE,
    DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP,
    DNS_ERROR_ZONE_NOT_SECONDARY,
    DNS_ERROR_NEED_SECONDARY_ADDRESSES,
    DNS_ERROR_WINS_INIT_FAILED,
    DNS_ERROR_NEED_WINS_SERVERS,
    DNS_ERROR_NBSTAT_INIT_FAILED,
    DNS_ERROR_SOA_DELETE_INVALID,
    DNS_ERROR_FORWARDER_ALREADY_EXISTS,
    DNS_ERROR_ZONE_REQUIRES_MASTER_IP,
    DNS_ERROR_ZONE_IS_SHUTDOWN,                        // =  9621
    DNS_ERROR_PRIMARY_REQUIRES_DATAFILE                   =  9651,
    DNS_ERROR_INVALID_DATAFILE_NAME,
    DNS_ERROR_DATAFILE_OPEN_FAILURE,
    DNS_ERROR_FILE_WRITEBACK_FAILED,
    DNS_ERROR_DATAFILE_PARSING,                        // =  9655
    DNS_ERROR_RECORD_DOES_NOT_EXIST                       =  9701,
    DNS_ERROR_RECORD_FORMAT,
    DNS_ERROR_NODE_CREATION_FAILED,
    DNS_ERROR_UNKNOWN_RECORD_TYPE,
    DNS_ERROR_RECORD_TIMED_OUT,
    DNS_ERROR_NAME_NOT_IN_ZONE,
    DNS_ERROR_CNAME_LOOP,
    DNS_ERROR_NODE_IS_CNAME,
    DNS_ERROR_CNAME_COLLISION,
    DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT,
    DNS_ERROR_RECORD_ALREADY_EXISTS,
    DNS_ERROR_SECONDARY_DATA,
    DNS_ERROR_NO_CREATE_CACHE_DATA,
    DNS_ERROR_NAME_DOES_NOT_EXIST,
    DNS_WARNING_PTR_CREATE_FAILED,
    DNS_WARNING_DOMAIN_UNDELETED,
    DNS_ERROR_DS_UNAVAILABLE,
    DNS_ERROR_DS_ZONE_ALREADY_EXISTS,
    DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE,                  // =  9719
    DNS_INFO_AXFR_COMPLETE                                =  9751,
    DNS_ERROR_AXFR,
    DNS_INFO_ADDED_LOCAL_WINS,                         // =  9753
    DNS_STATUS_CONTINUE_NEEDED                            =  9801,
    DNS_ERROR_NO_TCPIP                                    =  9851,
    DNS_ERROR_NO_DNS_SERVERS,                          // =  9852
    DNS_ERROR_DP_DOES_NOT_EXIST                           =  9901,
    DNS_ERROR_DP_ALREADY_EXISTS,
    DNS_ERROR_DP_NOT_ENLISTED,
    DNS_ERROR_DP_ALREADY_ENLISTED,
    DNS_ERROR_DP_NOT_AVAILABLE,                        // =  9905

/+  already in winsock2.d defined!

    WSABASEERR                                            = 10000,
    WSAEINTR                                              = 10004,
    WSAEBADF                                              = 10009,
    WSAEACCES                                             = 10013,
    WSAEFAULT,                                         // = 10014
    WSAEINVAL                                             = 10022,
    WSAEMFILE                                             = 10024,
    WSAEWOULDBLOCK                                        = 10035,
    WSAEINPROGRESS,
    WSAEALREADY,
    WSAENOTSOCK,
    WSAEDESTADDRREQ,
    WSAEMSGSIZE,
    WSAEPROTOTYPE,
    WSAENOPROTOOPT,
    WSAEPROTONOSUPPORT,
    WSAESOCKTNOSUPPORT,
    WSAEOPNOTSUPP,
    WSAEPFNOSUPPORT,
    WSAEAFNOSUPPORT,
    WSAEADDRINUSE,
    WSAEADDRNOTAVAIL,
    WSAENETDOWN,
    WSAENETUNREACH,
    WSAENETRESET,
    WSAECONNABORTED,
    WSAECONNRESET,
    WSAENOBUFS,
    WSAEISCONN,
    WSAENOTCONN,
    WSAESHUTDOWN,
    WSAETOOMANYREFS,
    WSAETIMEDOUT,
    WSAECONNREFUSED,
    WSAELOOP,
    WSAENAMETOOLONG,
    WSAEHOSTDOWN,
    WSAEHOSTUNREACH,
    WSAENOTEMPTY,
    WSAEPROCLIM,
    WSAEUSERS,
    WSAEDQUOT,
    WSAESTALE,
    WSAEREMOTE,                                        // = 10071
    WSASYSNOTREADY                                        = 10091,
    WSAVERNOTSUPPORTED,
    WSANOTINITIALISED,                                 // = 10093
    WSAEDISCON                                            = 10101,
    WSAENOMORE,
    WSAECANCELLED,
    WSAEINVALIDPROCTABLE,
    WSAEINVALIDPROVIDER,
    WSAEPROVIDERFAILEDINIT,
    WSASYSCALLFAILURE,
    WSASERVICE_NOT_FOUND,
    WSATYPE_NOT_FOUND,
    WSA_E_NO_MORE,
    WSA_E_CANCELLED,
    WSAEREFUSED,                                       // = 10112
    WSAHOST_NOT_FOUND                                     = 11001,
    WSATRY_AGAIN,
    WSANO_RECOVERY,
    WSANO_DATA,
    WSA_QOS_RECEIVERS,
    WSA_QOS_SENDERS,
    WSA_QOS_NO_SENDERS,
    WSA_QOS_NO_RECEIVERS,
    WSA_QOS_REQUEST_CONFIRMED,
    WSA_QOS_ADMISSION_FAILURE,
    WSA_QOS_POLICY_FAILURE,
    WSA_QOS_BAD_STYLE,
    WSA_QOS_BAD_OBJECT,
    WSA_QOS_TRAFFIC_CTRL_ERROR,
    WSA_QOS_GENERIC_ERROR,
    WSA_QOS_ESERVICETYPE,
    WSA_QOS_EFLOWSPEC,
    WSA_QOS_EPROVSPECBUF,
    WSA_QOS_EFILTERSTYLE,
    WSA_QOS_EFILTERTYPE,
    WSA_QOS_EFILTERCOUNT,
    WSA_QOS_EOBJLENGTH,
    WSA_QOS_EFLOWCOUNT,
    WSA_QOS_EUNKNOWNPSOBJ,
    WSA_QOS_EPOLICYOBJ,
    WSA_QOS_EFLOWDESC,
    WSA_QOS_EPSFLOWSPEC,
    WSA_QOS_EPSFILTERSPEC,
    WSA_QOS_ESDMODEOBJ,
    WSA_QOS_ESHAPERATEOBJ,
    WSA_QOS_RESERVED_PETYPE,                           // = 11031

+/

    ERROR_IPSEC_QM_POLICY_EXISTS                          = 13000,
    ERROR_IPSEC_QM_POLICY_NOT_FOUND,
    ERROR_IPSEC_QM_POLICY_IN_USE,
    ERROR_IPSEC_MM_POLICY_EXISTS,
    ERROR_IPSEC_MM_POLICY_NOT_FOUND,
    ERROR_IPSEC_MM_POLICY_IN_USE,
    ERROR_IPSEC_MM_FILTER_EXISTS,
    ERROR_IPSEC_MM_FILTER_NOT_FOUND,
    ERROR_IPSEC_TRANSPORT_FILTER_EXISTS,
    ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND,
    ERROR_IPSEC_MM_AUTH_EXISTS,
    ERROR_IPSEC_MM_AUTH_NOT_FOUND,
    ERROR_IPSEC_MM_AUTH_IN_USE,
    ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND,
    ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND,
    ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND,
    ERROR_IPSEC_TUNNEL_FILTER_EXISTS,
    ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND,
    ERROR_IPSEC_MM_FILTER_PENDING_DELETION,
    ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION,
    ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION,
    ERROR_IPSEC_MM_POLICY_PENDING_DELETION,
    ERROR_IPSEC_MM_AUTH_PENDING_DELETION,
    ERROR_IPSEC_QM_POLICY_PENDING_DELETION,
    WARNING_IPSEC_MM_POLICY_PRUNED,
    WARNING_IPSEC_QM_POLICY_PRUNED,                    // = 13025
    ERROR_IPSEC_IKE_AUTH_FAIL                             = 13801,
    ERROR_IPSEC_IKE_ATTRIB_FAIL,
    ERROR_IPSEC_IKE_NEGOTIATION_PENDING,
    ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR,
    ERROR_IPSEC_IKE_TIMED_OUT,
    ERROR_IPSEC_IKE_NO_CERT,
    ERROR_IPSEC_IKE_SA_DELETED,
    ERROR_IPSEC_IKE_SA_REAPED,
    ERROR_IPSEC_IKE_MM_ACQUIRE_DROP,
    ERROR_IPSEC_IKE_QM_ACQUIRE_DROP,
    ERROR_IPSEC_IKE_QUEUE_DROP_MM,
    ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM,
    ERROR_IPSEC_IKE_DROP_NO_RESPONSE,
    ERROR_IPSEC_IKE_MM_DELAY_DROP,
    ERROR_IPSEC_IKE_QM_DELAY_DROP,
    ERROR_IPSEC_IKE_ERROR,
    ERROR_IPSEC_IKE_CRL_FAILED,
    ERROR_IPSEC_IKE_INVALID_KEY_USAGE,
    ERROR_IPSEC_IKE_INVALID_CERT_TYPE,
    ERROR_IPSEC_IKE_NO_PRIVATE_KEY,                    // = 13820
    ERROR_IPSEC_IKE_DH_FAIL                               = 13822,
    ERROR_IPSEC_IKE_INVALID_HEADER                        = 13824,
    ERROR_IPSEC_IKE_NO_POLICY,
    ERROR_IPSEC_IKE_INVALID_SIGNATURE,
    ERROR_IPSEC_IKE_KERBEROS_ERROR,
    ERROR_IPSEC_IKE_NO_PUBLIC_KEY,
    ERROR_IPSEC_IKE_PROCESS_ERR,
    ERROR_IPSEC_IKE_PROCESS_ERR_SA,
    ERROR_IPSEC_IKE_PROCESS_ERR_PROP,
    ERROR_IPSEC_IKE_PROCESS_ERR_TRANS,
    ERROR_IPSEC_IKE_PROCESS_ERR_KE,
    ERROR_IPSEC_IKE_PROCESS_ERR_ID,
    ERROR_IPSEC_IKE_PROCESS_ERR_CERT,
    ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ,
    ERROR_IPSEC_IKE_PROCESS_ERR_HASH,
    ERROR_IPSEC_IKE_PROCESS_ERR_SIG,
    ERROR_IPSEC_IKE_PROCESS_ERR_NONCE,
    ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY,
    ERROR_IPSEC_IKE_PROCESS_ERR_DELETE,
    ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR,
    ERROR_IPSEC_IKE_INVALID_PAYLOAD,
    ERROR_IPSEC_IKE_LOAD_SOFT_SA,
    ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN,
    ERROR_IPSEC_IKE_INVALID_COOKIE,
    ERROR_IPSEC_IKE_NO_PEER_CERT,
    ERROR_IPSEC_IKE_PEER_CRL_FAILED,
    ERROR_IPSEC_IKE_POLICY_CHANGE,
    ERROR_IPSEC_IKE_NO_MM_POLICY,
    ERROR_IPSEC_IKE_NOTCBPRIV,
    ERROR_IPSEC_IKE_SECLOADFAIL,
    ERROR_IPSEC_IKE_FAILSSPINIT,
    ERROR_IPSEC_IKE_FAILQUERYSSP,
    ERROR_IPSEC_IKE_SRVACQFAIL,
    ERROR_IPSEC_IKE_SRVQUERYCRED,
    ERROR_IPSEC_IKE_GETSPIFAIL,
    ERROR_IPSEC_IKE_INVALID_FILTER,
    ERROR_IPSEC_IKE_OUT_OF_MEMORY,
    ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED,
    ERROR_IPSEC_IKE_INVALID_POLICY,
    ERROR_IPSEC_IKE_UNKNOWN_DOI,
    ERROR_IPSEC_IKE_INVALID_SITUATION,
    ERROR_IPSEC_IKE_DH_FAILURE,
    ERROR_IPSEC_IKE_INVALID_GROUP,
    ERROR_IPSEC_IKE_ENCRYPT,
    ERROR_IPSEC_IKE_DECRYPT,
    ERROR_IPSEC_IKE_POLICY_MATCH,
    ERROR_IPSEC_IKE_UNSUPPORTED_ID,
    ERROR_IPSEC_IKE_INVALID_HASH,
    ERROR_IPSEC_IKE_INVALID_HASH_ALG,
    ERROR_IPSEC_IKE_INVALID_HASH_SIZE,
    ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG,
    ERROR_IPSEC_IKE_INVALID_AUTH_ALG,
    ERROR_IPSEC_IKE_INVALID_SIG,
    ERROR_IPSEC_IKE_LOAD_FAILED,
    ERROR_IPSEC_IKE_RPC_DELETE,
    ERROR_IPSEC_IKE_BENIGN_REINIT,
    ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY, // = 13879
    ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN                   = 13881,
    ERROR_IPSEC_IKE_MM_LIMIT,
    ERROR_IPSEC_IKE_NEGOTIATION_DISABLED,
    ERROR_IPSEC_IKE_NEG_STATUS_END,
    ERROR_SXS_SECTION_NOT_FOUND,
    ERROR_SXS_CANT_GEN_ACTCTX,
    ERROR_SXS_INVALID_ACTCTXDATA_FORMAT,
    ERROR_SXS_ASSEMBLY_NOT_FOUND,
    ERROR_SXS_MANIFEST_FORMAT_ERROR,
    ERROR_SXS_MANIFEST_PARSE_ERROR,
    ERROR_SXS_ACTIVATION_CONTEXT_DISABLED,
    ERROR_SXS_KEY_NOT_FOUND,
    ERROR_SXS_VERSION_CONFLICT,
    ERROR_SXS_WRONG_SECTION_TYPE,
    ERROR_SXS_THREAD_QUERIES_DISABLED,
    ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET,
    ERROR_SXS_UNKNOWN_ENCODING_GROUP,
    ERROR_SXS_UNKNOWN_ENCODING,
    ERROR_SXS_INVALID_XML_NAMESPACE_URI,
    ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED,
    ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED,
    ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE,
    ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE,
    ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE,
    ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT,
    ERROR_SXS_DUPLICATE_DLL_NAME,
    ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME,
    ERROR_SXS_DUPLICATE_CLSID,
    ERROR_SXS_DUPLICATE_IID,
    ERROR_SXS_DUPLICATE_TLBID,
    ERROR_SXS_DUPLICATE_PROGID,
    ERROR_SXS_DUPLICATE_ASSEMBLY_NAME,
    ERROR_SXS_FILE_HASH_MISMATCH,
    ERROR_SXS_POLICY_PARSE_ERROR,
    ERROR_SXS_XML_E_MISSINGQUOTE,
    ERROR_SXS_XML_E_COMMENTSYNTAX,
    ERROR_SXS_XML_E_BADSTARTNAMECHAR,
    ERROR_SXS_XML_E_BADNAMECHAR,
    ERROR_SXS_XML_E_BADCHARINSTRING,
    ERROR_SXS_XML_E_XMLDECLSYNTAX,
    ERROR_SXS_XML_E_BADCHARDATA,
    ERROR_SXS_XML_E_MISSINGWHITESPACE,
    ERROR_SXS_XML_E_EXPECTINGTAGEND,
    ERROR_SXS_XML_E_MISSINGSEMICOLON,
    ERROR_SXS_XML_E_UNBALANCEDPAREN,
    ERROR_SXS_XML_E_INTERNALERROR,
    ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE,
    ERROR_SXS_XML_E_INCOMPLETE_ENCODING,
    ERROR_SXS_XML_E_MISSING_PAREN,
    ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE,
    ERROR_SXS_XML_E_MULTIPLE_COLONS,
    ERROR_SXS_XML_E_INVALID_DECIMAL,
    ERROR_SXS_XML_E_INVALID_HEXIDECIMAL,
    ERROR_SXS_XML_E_INVALID_UNICODE,
    ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK,
    ERROR_SXS_XML_E_UNEXPECTEDENDTAG,
    ERROR_SXS_XML_E_UNCLOSEDTAG,
    ERROR_SXS_XML_E_DUPLICATEATTRIBUTE,
    ERROR_SXS_XML_E_MULTIPLEROOTS,
    ERROR_SXS_XML_E_INVALIDATROOTLEVEL,
    ERROR_SXS_XML_E_BADXMLDECL,
    ERROR_SXS_XML_E_MISSINGROOT,
    ERROR_SXS_XML_E_UNEXPECTEDEOF,
    ERROR_SXS_XML_E_BADPEREFINSUBSET,
    ERROR_SXS_XML_E_UNCLOSEDSTARTTAG,
    ERROR_SXS_XML_E_UNCLOSEDENDTAG,
    ERROR_SXS_XML_E_UNCLOSEDSTRING,
    ERROR_SXS_XML_E_UNCLOSEDCOMMENT,
    ERROR_SXS_XML_E_UNCLOSEDDECL,
    ERROR_SXS_XML_E_UNCLOSEDCDATA,
    ERROR_SXS_XML_E_RESERVEDNAMESPACE,
    ERROR_SXS_XML_E_INVALIDENCODING,
    ERROR_SXS_XML_E_INVALIDSWITCH,
    ERROR_SXS_XML_E_BADXMLCASE,
    ERROR_SXS_XML_E_INVALID_STANDALONE,
    ERROR_SXS_XML_E_UNEXPECTED_STANDALONE,
    ERROR_SXS_XML_E_INVALID_VERSION,
    ERROR_SXS_XML_E_MISSINGEQUALS,
    ERROR_SXS_PROTECTION_RECOVERY_FAILED,
    ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT,
    ERROR_SXS_PROTECTION_CATALOG_NOT_VALID,
    ERROR_SXS_UNTRANSLATABLE_HRESULT,
    ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING,
    ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE,
    ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME // = 14080
}

enum : HRESULT {
    S_OK                                   = 0x00000000,
    S_FALSE                                = 0x00000001,

    NOERROR                                = 0x00000000,

    E_PENDING                              = 0x8000000A,
    E_NOTIMPL                              = 0x80004001,
    E_NOINTERFACE                          = 0x80004002,
    E_POINTER                              = 0x80004003,
    E_ABORT                                = 0x80004004,
    E_FAIL                                 = 0x80004005,
    E_ACCESSDENIED                         = 0x80070005,
    E_HANDLE                               = 0x80070006,
    E_OUTOFMEMORY                          = 0x8007000E,
    E_INVALIDARG                           = 0x80070057,
    E_UNEXPECTED                           = 0x8000FFFF,

    CO_E_INIT_TLS                          = 0x80004006,
    CO_E_INIT_SHARED_ALLOCATOR             = 0x80004007,
    CO_E_INIT_MEMORY_ALLOCATOR             = 0x80004008,
    CO_E_INIT_CLASS_CACHE                  = 0x80004009,
    CO_E_INIT_RPC_CHANNEL                  = 0x8000400A,
    CO_E_INIT_TLS_SET_CHANNEL_CONTROL      = 0x8000400B,
    CO_E_INIT_TLS_CHANNEL_CONTROL          = 0x8000400C,
    CO_E_INIT_UNACCEPTED_USER_ALLOCATOR    = 0x8000400D,
    CO_E_INIT_SCM_MUTEX_EXISTS             = 0x8000400E,
    CO_E_INIT_SCM_FILE_MAPPING_EXISTS      = 0x8000400F,
    CO_E_INIT_SCM_MAP_VIEW_OF_FILE         = 0x80004010,
    CO_E_INIT_SCM_EXEC_FAILURE             = 0x80004011,
    CO_E_INIT_ONLY_SINGLE_THREADED         = 0x80004012,

    RPC_E_CALL_REJECTED                    = 0x80010001,
    RPC_E_CALL_CANCELED                    = 0x80010002,
    RPC_E_CANTPOST_INSENDCALL              = 0x80010003,
    RPC_E_CANTCALLOUT_INASYNCCALL          = 0x80010004,
    RPC_E_CANTCALLOUT_INEXTERNALCALL       = 0x80010005,
    RPC_E_CONNECTION_TERMINATED            = 0x80010006,
    RPC_E_SERVER_DIED                      = 0x80010007,
    RPC_E_CLIENT_DIED                      = 0x80010008,
    RPC_E_INVALID_DATAPACKET               = 0x80010009,
    RPC_E_CANTTRANSMIT_CALL                = 0x8001000A,
    RPC_E_CLIENT_CANTMARSHAL_DATA          = 0x8001000B,
    RPC_E_CLIENT_CANTUNMARSHAL_DATA        = 0x8001000C,
    RPC_E_SERVER_CANTMARSHAL_DATA          = 0x8001000D,
    RPC_E_SERVER_CANTUNMARSHAL_DATA        = 0x8001000E,
    RPC_E_INVALID_DATA                     = 0x8001000F,
    RPC_E_INVALID_PARAMETER                = 0x80010010,
    RPC_E_CANTCALLOUT_AGAIN                = 0x80010011,
    RPC_E_SERVER_DIED_DNE                  = 0x80010012,
    RPC_E_SYS_CALL_FAILED                  = 0x80010100,
    RPC_E_OUT_OF_RESOURCES                 = 0x80010101,
    RPC_E_ATTEMPTED_MULTITHREAD            = 0x80010102,
    RPC_E_NOT_REGISTERED                   = 0x80010103,
    RPC_E_FAULT                            = 0x80010104,
    RPC_E_SERVERFAULT                      = 0x80010105,
    RPC_E_CHANGED_MODE                     = 0x80010106,
    RPC_E_INVALIDMETHOD                    = 0x80010107,
    RPC_E_DISCONNECTED                     = 0x80010108,
    RPC_E_RETRY                            = 0x80010109,
    RPC_E_SERVERCALL_RETRYLATER            = 0x8001010A,
    RPC_E_SERVERCALL_REJECTED              = 0x8001010B,
    RPC_E_INVALID_CALLDATA                 = 0x8001010C,
    RPC_E_CANTCALLOUT_ININPUTSYNCCALL      = 0x8001010D,
    RPC_E_WRONG_THREAD                     = 0x8001010E,
    RPC_E_THREAD_NOT_INIT                  = 0x8001010F,
    RPC_E_UNEXPECTED                       = 0x8001FFFF,

    DISP_E_UNKNOWNINTERFACE                = 0x80020001,
    DISP_E_MEMBERNOTFOUND                  = 0x80020003,
    DISP_E_PARAMNOTFOUND                   = 0x80020004,
    DISP_E_TYPEMISMATCH                    = 0x80020005,
    DISP_E_UNKNOWNNAME                     = 0x80020006,
    DISP_E_NONAMEDARGS                     = 0x80020007,
    DISP_E_BADVARTYPE                      = 0x80020008,
    DISP_E_EXCEPTION                       = 0x80020009,
    DISP_E_OVERFLOW                        = 0x8002000A,
    DISP_E_BADINDEX                        = 0x8002000B,
    DISP_E_UNKNOWNLCID                     = 0x8002000C,
    DISP_E_ARRAYISLOCKED                   = 0x8002000D,
    DISP_E_BADPARAMCOUNT                   = 0x8002000E,
    DISP_E_PARAMNOTOPTIONAL                = 0x8002000F,
    DISP_E_BADCALLEE                       = 0x80020010,
    DISP_E_NOTACOLLECTION                  = 0x80020011,
    DISP_E_DIVBYZERO                       = 0x80020012,

    TYPE_E_BUFFERTOOSMALL                  = 0x80028016,
    TYPE_E_INVDATAREAD                     = 0x80028018,
    TYPE_E_UNSUPFORMAT                     = 0x80028019,
    TYPE_E_REGISTRYACCESS                  = 0x8002801C,
    TYPE_E_LIBNOTREGISTERED                = 0x8002801D,
    TYPE_E_UNDEFINEDTYPE                   = 0x80028027,
    TYPE_E_QUALIFIEDNAMEDISALLOWED         = 0x80028028,
    TYPE_E_INVALIDSTATE                    = 0x80028029,
    TYPE_E_WRONGTYPEKIND                   = 0x8002802A,
    TYPE_E_ELEMENTNOTFOUND                 = 0x8002802B,
    TYPE_E_AMBIGUOUSNAME                   = 0x8002802C,
    TYPE_E_NAMECONFLICT                    = 0x8002802D,
    TYPE_E_UNKNOWNLCID                     = 0x8002802E,
    TYPE_E_DLLFUNCTIONNOTFOUND             = 0x8002802F,
    TYPE_E_BADMODULEKIND                   = 0x800288BD,
    TYPE_E_SIZETOOBIG                      = 0x800288C5,
    TYPE_E_DUPLICATEID                     = 0x800288C6,
    TYPE_E_INVALIDID                       = 0x800288CF,
    TYPE_E_TYPEMISMATCH                    = 0x80028CA0,
    TYPE_E_OUTOFBOUNDS                     = 0x80028CA1,
    TYPE_E_IOERROR                         = 0x80028CA2,
    TYPE_E_CANTCREATETMPFILE               = 0x80028CA3,
    TYPE_E_CANTLOADLIBRARY                 = 0x80029C4A,
    TYPE_E_INCONSISTENTPROPFUNCS           = 0x80029C83,
    TYPE_E_CIRCULARTYPE                    = 0x80029C84,

    STG_E_INVALIDFUNCTION                  = 0x80030001,
    STG_E_FILENOTFOUND                     = 0x80030002,
    STG_E_PATHNOTFOUND                     = 0x80030003,
    STG_E_TOOMANYOPENFILES                 = 0x80030004,
    STG_E_ACCESSDENIED                     = 0x80030005,
    STG_E_INVALIDHANDLE                    = 0x80030006,
    STG_E_INSUFFICIENTMEMORY               = 0x80030008,
    STG_E_INVALIDPOINTER                   = 0x80030009,
    STG_E_NOMOREFILES                      = 0x80030012,
    STG_E_DISKISWRITEPROTECTED             = 0x80030013,
    STG_E_SEEKERROR                        = 0x80030019,
    STG_E_WRITEFAULT                       = 0x8003001D,
    STG_E_READFAULT                        = 0x8003001E,
    STG_E_SHAREVIOLATION                   = 0x80030020,
    STG_E_LOCKVIOLATION                    = 0x80030021,
    STG_E_FILEALREADYEXISTS                = 0x80030050,
    STG_E_INVALIDPARAMETER                 = 0x80030057,
    STG_E_MEDIUMFULL                       = 0x80030070,
    STG_E_ABNORMALAPIEXIT                  = 0x800300FA,
    STG_E_INVALIDHEADER                    = 0x800300FB,
    STG_E_INVALIDNAME                      = 0x800300FC,
    STG_E_UNKNOWN                          = 0x800300FD,
    STG_E_UNIMPLEMENTEDFUNCTION            = 0x800300FE,
    STG_E_INVALIDFLAG                      = 0x800300FF,
    STG_E_INUSE                            = 0x80030100,
    STG_E_NOTCURRENT                       = 0x80030101,
    STG_E_REVERTED                         = 0x80030102,
    STG_E_CANTSAVE                         = 0x80030103,
    STG_E_OLDFORMAT                        = 0x80030104,
    STG_E_OLDDLL                           = 0x80030105,
    STG_E_SHAREREQUIRED                    = 0x80030106,
    STG_E_NOTFILEBASEDSTORAGE              = 0x80030107,
    STG_E_EXTANTMARSHALLINGS               = 0x80030108,
    STG_S_CONVERTED                        = 0x00030200,

    OLE_E_FIRST                            = 0x80040000,
    OLE_S_FIRST                            = 0x00040000,
    OLE_E_OLEVERB                          = 0x80040000,
    OLE_S_USEREG                           = 0x00040000,
    OLE_E_ADVF                             = 0x80040001,
    OLE_S_STATIC                           = 0x00040001,
    OLE_E_ENUM_NOMORE                      = 0x80040002,
    OLE_S_MAC_CLIPFORMAT                   = 0x00040002,
    OLE_E_ADVISENOTSUPPORTED               = 0x80040003,
    OLE_E_NOCONNECTION                     = 0x80040004,
    OLE_E_NOTRUNNING                       = 0x80040005,
    OLE_E_NOCACHE                          = 0x80040006,
    OLE_E_BLANK                            = 0x80040007,
    OLE_E_CLASSDIFF                        = 0x80040008,
    OLE_E_CANT_GETMONIKER                  = 0x80040009,
    OLE_E_CANT_BINDTOSOURCE                = 0x8004000A,
    OLE_E_STATIC                           = 0x8004000B,
    OLE_E_PROMPTSAVECANCELLED              = 0x8004000C,
    OLE_E_INVALIDRECT                      = 0x8004000D,
    OLE_E_WRONGCOMPOBJ                     = 0x8004000E,
    OLE_E_INVALIDHWND                      = 0x8004000F,
    OLE_E_NOT_INPLACEACTIVE                = 0x80040010,
    OLE_E_CANTCONVERT                      = 0x80040011,
    OLE_E_NOSTORAGE                        = 0x80040012,

    DV_E_FORMATETC                         = 0x80040064,
    DV_E_DVTARGETDEVICE                    = 0x80040065,
    DV_E_STGMEDIUM                         = 0x80040066,
    DV_E_STATDATA                          = 0x80040067,
    DV_E_LINDEX                            = 0x80040068,
    DV_E_TYMED                             = 0x80040069,
    DV_E_CLIPFORMAT                        = 0x8004006A,
    DV_E_DVASPECT                          = 0x8004006B,
    DV_E_DVTARGETDEVICE_SIZE               = 0x8004006C,
    DV_E_NOIVIEWOBJECT                     = 0x8004006D,

    OLE_E_LAST                             = 0x800400FF,
    OLE_S_LAST                             = 0x000400FF,
    DRAGDROP_E_FIRST                       = 0x80040100,
    DRAGDROP_S_FIRST                       = 0x00040100,
    DRAGDROP_E_NOTREGISTERED               = 0x80040100,
    DRAGDROP_S_DROP                        = 0x00040100,
    DRAGDROP_E_ALREADYREGISTERED           = 0x80040101,
    DRAGDROP_S_CANCEL                      = 0x00040101,
    DRAGDROP_E_INVALIDHWND                 = 0x80040102,
    DRAGDROP_S_USEDEFAULTCURSORS           = 0x00040102,
    DRAGDROP_E_LAST                        = 0x8004010F,
    DRAGDROP_S_LAST                        = 0x0004010F,
    CLASSFACTORY_E_FIRST                   = 0x80040110,
    CLASSFACTORY_S_FIRST                   = 0x00040110,
    CLASS_E_NOAGGREGATION                  = 0x80040110,
    CLASS_E_CLASSNOTAVAILABLE              = 0x80040111,
    CLASSFACTORY_E_LAST                    = 0x8004011F,
    CLASSFACTORY_S_LAST                    = 0x0004011F,
    MARSHAL_E_FIRST                        = 0x80040120,
    MARSHAL_S_FIRST                        = 0x00040120,
    MARSHAL_E_LAST                         = 0x8004012F,
    MARSHAL_S_LAST                         = 0x0004012F,
    DATA_E_FIRST                           = 0x80040130,
    DATA_S_FIRST                           = 0x00040130,
    DATA_S_SAMEFORMATETC                   = 0x00040130,
    DATA_E_LAST                            = 0x8004013F,
    DATA_S_LAST                            = 0x0004013F,
    VIEW_E_FIRST                           = 0x80040140,
    VIEW_S_FIRST                           = 0x00040140,
    VIEW_E_DRAW                            = 0x80040140,
    VIEW_S_ALREADY_FROZEN                  = 0x00040140,
    VIEW_E_LAST                            = 0x8004014F,
    VIEW_S_LAST                            = 0x0004014F,
    REGDB_E_FIRST                          = 0x80040150,
    REGDB_S_FIRST                          = 0x00040150,
    REGDB_E_READREGDB                      = 0x80040150,
    REGDB_E_WRITEREGDB                     = 0x80040151,
    REGDB_E_KEYMISSING                     = 0x80040152,
    REGDB_E_INVALIDVALUE                   = 0x80040153,
    REGDB_E_CLASSNOTREG                    = 0x80040154,
    REGDB_E_IIDNOTREG                      = 0x80040155,
    REGDB_E_LAST                           = 0x8004015F,
    REGDB_S_LAST                           = 0x0004015F,
    CACHE_E_FIRST                          = 0x80040170,
    CACHE_S_FIRST                          = 0x00040170,
    CACHE_E_NOCACHE_UPDATED                = 0x80040170,
    CACHE_S_FORMATETC_NOTSUPPORTED         = 0x00040170,
    CACHE_S_SAMECACHE                      = 0x00040171,
    CACHE_S_SOMECACHES_NOTUPDATED          = 0x00040172,
    CACHE_E_LAST                           = 0x8004017F,
    CACHE_S_LAST                           = 0x0004017F,
    OLEOBJ_E_FIRST                         = 0x80040180,
    OLEOBJ_S_FIRST                         = 0x00040180,
    OLEOBJ_E_NOVERBS                       = 0x80040180,
    OLEOBJ_S_INVALIDVERB                   = 0x00040180,
    OLEOBJ_E_INVALIDVERB                   = 0x80040181,
    OLEOBJ_S_CANNOT_DOVERB_NOW             = 0x00040181,
    OLEOBJ_S_INVALIDHWND                   = 0x00040182,
    OLEOBJ_E_LAST                          = 0x8004018F,
    OLEOBJ_S_LAST                          = 0x0004018F,
    CLIENTSITE_E_FIRST                     = 0x80040190,
    CLIENTSITE_S_FIRST                     = 0x00040190,
    CLIENTSITE_E_LAST                      = 0x8004019F,
    CLIENTSITE_S_LAST                      = 0x0004019F,
    INPLACE_E_NOTUNDOABLE                  = 0x800401A0,
    INPLACE_E_FIRST                        = 0x800401A0,
    INPLACE_S_FIRST                        = 0x000401A0,
    INPLACE_S_TRUNCATED                    = 0x000401A0,
    INPLACE_E_NOTOOLSPACE                  = 0x800401A1,
    INPLACE_E_LAST                         = 0x800401AF,
    INPLACE_S_LAST                         = 0x000401AF,
    ENUM_E_FIRST                           = 0x800401B0,
    ENUM_S_FIRST                           = 0x000401B0,
    ENUM_E_LAST                            = 0x800401BF,
    ENUM_S_LAST                            = 0x000401BF,
    CONVERT10_E_FIRST                      = 0x800401C0,
    CONVERT10_S_FIRST                      = 0x000401C0,
    CONVERT10_E_OLESTREAM_GET              = 0x800401C0,
    CONVERT10_S_NO_PRESENTATION            = 0x000401C0,
    CONVERT10_E_OLESTREAM_PUT              = 0x800401C1,
    CONVERT10_E_OLESTREAM_FMT              = 0x800401C2,
    CONVERT10_E_OLESTREAM_BITMAP_TO_DIB    = 0x800401C3,
    CONVERT10_E_STG_FMT                    = 0x800401C4,
    CONVERT10_E_STG_NO_STD_STREAM          = 0x800401C5,
    CONVERT10_E_STG_DIB_TO_BITMAP          = 0x800401C6,
    CONVERT10_E_LAST                       = 0x800401CF,
    CONVERT10_S_LAST                       = 0x000401CF,
    CLIPBRD_E_FIRST                        = 0x800401D0,
    CLIPBRD_S_FIRST                        = 0x000401D0,
    CLIPBRD_E_CANT_OPEN                    = 0x800401D0,
    CLIPBRD_E_CANT_EMPTY                   = 0x800401D1,
    CLIPBRD_E_CANT_SET                     = 0x800401D2,
    CLIPBRD_E_BAD_DATA                     = 0x800401D3,
    CLIPBRD_E_CANT_CLOSE                   = 0x800401D4,
    CLIPBRD_E_LAST                         = 0x800401DF,
    CLIPBRD_S_LAST                         = 0x000401DF,
    MK_E_FIRST                             = 0x800401E0,
    MK_S_FIRST                             = 0x000401E0,
    MK_E_CONNECTMANUALLY                   = 0x800401E0,
    MK_E_EXCEEDEDDEADLINE                  = 0x800401E1,
    MK_E_NEEDGENERIC                       = 0x800401E2,
    MK_S_REDUCED_TO_SELF                   = 0x000401E2,
    MK_E_UNAVAILABLE                       = 0x800401E3,
    MK_E_SYNTAX                            = 0x800401E4,
    MK_S_ME                                = 0x000401E4,
    MK_E_NOOBJECT                          = 0x800401E5,
    MK_S_HIM                               = 0x000401E5,
    MK_E_INVALIDEXTENSION                  = 0x800401E6,
    MK_S_US                                = 0x000401E6,
    MK_E_INTERMEDIATEINTERFACENOTSUPPORTED = 0x800401E7,
    MK_S_MONIKERALREADYREGISTERED          = 0x000401E7,
    MK_E_NOTBINDABLE                       = 0x800401E8,
    MK_E_NOTBOUND                          = 0x800401E9,
    MK_E_CANTOPENFILE                      = 0x800401EA,
    MK_E_MUSTBOTHERUSER                    = 0x800401EB,
    MK_E_NOINVERSE                         = 0x800401EC,
    MK_E_NOSTORAGE                         = 0x800401ED,
    MK_E_NOPREFIX                          = 0x800401EE,
    MK_E_LAST                              = 0x800401EF,
    MK_S_LAST                              = 0x000401EF,
    MK_E_ENUMERATION_FAILED                = 0x800401EF,
    CO_E_FIRST                             = 0x800401F0,
    CO_S_FIRST                             = 0x000401F0,
    CO_E_NOTINITIALIZED                    = 0x800401F0,
    CO_E_ALREADYINITIALIZED                = 0x800401F1,
    CO_E_CANTDETERMINECLASS                = 0x800401F2,
    CO_E_CLASSSTRING                       = 0x800401F3,
    CO_E_IIDSTRING                         = 0x800401F4,
    CO_E_APPNOTFOUND                       = 0x800401F5,
    CO_E_APPSINGLEUSE                      = 0x800401F6,
    CO_E_ERRORINAPP                        = 0x800401F7,
    CO_E_DLLNOTFOUND                       = 0x800401F8,
    CO_E_ERRORINDLL                        = 0x800401F9,
    CO_E_WRONGOSFORAPP                     = 0x800401FA,
    CO_E_OBJNOTREG                         = 0x800401FB,
    CO_E_OBJISREG                          = 0x800401FC,
    CO_E_OBJNOTCONNECTED                   = 0x800401FD,
    CO_E_APPDIDNTREG                       = 0x800401FE,
    CO_E_LAST                              = 0x800401FF,
    CO_S_LAST                              = 0x000401FF,
    CO_E_RELEASED                          = 0x800401FF,

    CO_E_CLASS_CREATE_FAILED               = 0x80080001,
    CO_E_SCM_ERROR                         = 0x80080002,
    CO_E_SCM_RPC_FAILURE                   = 0x80080003,
    CO_E_BAD_PATH                          = 0x80080004,
    CO_E_SERVER_EXEC_FAILURE               = 0x80080005,
    CO_E_OBJSRV_RPC_FAILURE                = 0x80080006,
    MK_E_NO_NORMALIZED                     = 0x80080007,
    CO_E_SERVER_STOPPING                   = 0x80080008,
    MEM_E_INVALID_ROOT                     = 0x80080009,
    MEM_E_INVALID_LINK                     = 0x80080010,
    MEM_E_INVALID_SIZE                     = 0x80080011,
    CO_S_NOTALLINTERFACES                  = 0x00080012,

    NTE_BAD_UID                            = 0x80090001,
    NTE_BAD_HASH                           = 0x80090002,
    NTE_BAD_KEY                            = 0x80090003,
    NTE_BAD_LEN                            = 0x80090004,
    NTE_BAD_DATA                           = 0x80090005,
    NTE_BAD_SIGNATURE                      = 0x80090006,
    NTE_BAD_VER                            = 0x80090007,
    NTE_BAD_ALGID                          = 0x80090008,
    NTE_BAD_FLAGS                          = 0x80090009,
    NTE_BAD_TYPE                           = 0x8009000A,
    NTE_BAD_KEY_STATE                      = 0x8009000B,
    NTE_BAD_HASH_STATE                     = 0x8009000C,
    NTE_NO_KEY                             = 0x8009000D,
    NTE_NO_MEMORY                          = 0x8009000E,
    NTE_EXISTS                             = 0x8009000F,
    NTE_PERM                               = 0x80090010,
    NTE_NOT_FOUND                          = 0x80090011,
    NTE_DOUBLE_ENCRYPT                     = 0x80090012,
    NTE_BAD_PROVIDER                       = 0x80090013,
    NTE_BAD_PROV_TYPE                      = 0x80090014,
    NTE_BAD_PUBLIC_KEY                     = 0x80090015,
    NTE_BAD_KEYSET                         = 0x80090016,
    NTE_PROV_TYPE_NOT_DEF                  = 0x80090017,
    NTE_PROV_TYPE_ENTRY_BAD                = 0x80090018,
    NTE_KEYSET_NOT_DEF                     = 0x80090019,
    NTE_KEYSET_ENTRY_BAD                   = 0x8009001A,
    NTE_PROV_TYPE_NO_MATCH                 = 0x8009001B,
    NTE_SIGNATURE_FILE_BAD                 = 0x8009001C,
    NTE_PROVIDER_DLL_FAIL                  = 0x8009001D,
    NTE_PROV_DLL_NOT_FOUND                 = 0x8009001E,
    NTE_BAD_KEYSET_PARAM                   = 0x8009001F,
    NTE_FAIL                               = 0x80090020,
    NTE_SYS_ERR                            = 0x80090021
}


enum : uint {
    SEVERITY_SUCCESS = 0,
    SEVERITY_ERROR   = 1
}

enum : uint {
    FACILITY_NULL     =   0,
    FACILITY_RPC,
    FACILITY_DISPATCH,
    FACILITY_STORAGE,
    FACILITY_ITF,  // =   4
    FACILITY_WIN32    =   7,
    FACILITY_WINDOWS  =   8,
    FACILITY_CONTROL  =  10,
    FACILITY_NT_BIT   = 0x10000000
}

// C Macros

pure nothrow @nogc {
    bool SUCCEEDED(HRESULT Status) {
        return Status >= 0;
    }

    bool FAILED(HRESULT Status) {
        return Status < 0;
    }

    bool IS_ERROR(HRESULT Status) {
        return (Status >>> 31) == SEVERITY_ERROR;
    }

    ushort HRESULT_CODE(HRESULT r) {
        return cast(ushort) (r & 0xFFFF);
    }

    ushort SCODE_CODE(SCODE r) {
        return cast(ushort) (r & 0xFFFF);
    }

    ushort HRESULT_FACILITY(HRESULT r) {
        return cast(ushort) ((r>>16) & 0x1fff);
    }

    ushort SCODE_FACILITY(SCODE r) {
        return cast(ushort) ((r>>16) & 0x1fff);
    }

    ushort HRESULT_SEVERITY(HRESULT r) {
        return cast(ushort) ((r>>31) & 0x1);
    }

    ushort SCODE_SEVERITY(SCODE r) {
        return cast(ushort) ((r>>31) & 0x1);
    }

    HRESULT MAKE_HRESULT(bool s, uint f, uint c) {
        return (s << 31) | (f << 16) | c;
    }

    SCODE MAKE_SCODE(bool s, uint f, uint c) {
        return (s << 31) | (f << 16) | c;
    }

    SCODE GetScode(HRESULT hr) {
        return hr;
    }

    HRESULT ResultFromScode(SCODE c) {
        return c;
    }

    HRESULT HRESULT_FROM_NT(HRESULT x) {
        return x | FACILITY_NT_BIT;
    }

    HRESULT HRESULT_FROM_WIN32(HRESULT x) {
        return  x ? (x & 0x0000FFFF) | (FACILITY_WIN32 << 16) | 0x80000000 : 0;
    }

    HRESULT PropagateResult(HRESULT hrPrevious, SCODE scBase) {
        return scBase;
    }
}
