;;;
;;; Help the Windows installer
;;;


;; In the final destination bin directory, make a Bourne shell script
;; to launch GCL.

(defun kill-backs ( s )
  (let ((pos (search "\\" s)))
    (if pos 
	(let ((start (subseq s 0 pos))
	      (finish (subseq s (1+ pos))))
	  (kill-backs (concatenate 'string start "/" finish)))
      s)))

(defun kill-double-forwards ( s )
  (let ((pos (search "//" s)))
    (if pos 
	(let ((start (subseq s 0 pos))
	      (finish (subseq s (+ pos 2))))
	  (kill-double-forwards (concatenate 'string start "/" finish)))
      s)))

(defun kill-forwards ( s )
  (let ((pos (search "/" s)))
    (if pos 
	(let ((start (subseq s 0 pos))
	      (finish (subseq s (1+ pos))))
	  (kill-forwards (concatenate 'string start "\\" finish)))
      s)))

(defun kill-double-backs ( s )
  (let ((pos (search "\\\\" s)))
    (if pos 
	(let ((start (subseq s 0 pos))
	      (finish (subseq s (+ pos 2))))
	  (kill-double-backs (concatenate 'string start "\\" finish)))
      s)))

(defun split-by-one-fs (string)
    (loop for i = 0 then (1+ j)
          as j = (position #\/ string :start i)
          collect (subseq string i j)
          while j))


; Remove dos colon for MSYS and \\
(defun msysarise (s)
  (if (equal (char s 1) #\:)
      (kill-double-forwards (kill-backs (concatenate 'string "/" (subseq s 0 1) (subseq s 2))))
    (kill-double-forwards (kill-backs s))))

(setq *msys-system-directory* (msysarise *system-directory*))

(setq *root-directory* 
      (kill-double-forwards (kill-backs (subseq *system-directory* 0 (- (length *system-directory*) 23)))))

(setq *msys-root-directory* 
      (kill-double-forwards (kill-backs (subseq *system-directory* 0 (- (length *msys-system-directory*) 23)))))

(setq *lib-directory* 
      (format nil "~a~a" *root-directory* "lib/gcl-2.5.0/"))

(setq *h-directory* 
      (format nil "~a~a" *msys-root-directory* "/lib/gcl-2.5.0/h"))

(setq *bin-directory* 
      (format nil "~a~a" *root-directory* "bin/"))

(setq gclscript (format nil "~a~a" *bin-directory* "gcl"))

(with-open-file (s gclscript :direction :output :if-exists :supersede)
		(format s "#!/bin/sh~%")
		(format s "export C_INCLUDE_PATH=~a~%" *h-directory* )
		(format s "export PATH=~a/mingw/bin:${PATH}~%" *msys-root-directory* )
		(format s "exec ~asaved_gcl.exe -dir ~a -libdir ~a -eval \"(setq si::*allow-gzipped-file* t)\" \"$@\""
			*msys-system-directory*
			(kill-double-forwards *system-directory*)
			*lib-directory* ))

(setq *dos-system-directory* (kill-double-backs (kill-forwards  *system-directory*)))

(setq *dos-root-directory* 
      (subseq *dos-system-directory* 0 (- (length *dos-system-directory*) 23)))

(setq *dos-h-directory* 
      (format nil "~a~a" *dos-root-directory* "lib\\gcl-2.5.0\\h"))

(setq *dos-bin-directory* 
      (format nil "~a~a" *dos-root-directory* "bin\\"))

(setq gclbatch (format nil "~a~a" *bin-directory* "gcl.bat"))

(with-open-file (s gclbatch :direction :output :if-exists :supersede)
		(format s "@echo off~%")
		(format s "set C_INCLUDE_PATH=~a~%" *dos-h-directory* )
		(format s "path ~amingw\\bin;%PATH%~%" *dos-root-directory* )
		(format s "start ~asaved_gcl.exe -dir ~a -libdir ~a -eval \"(setq si::*allow-gzipped-file* t)\" %1 %2 %3 %4 %5 %6 %7 %8 %9~%"
			*dos-system-directory*
			(kill-double-forwards *system-directory*)
			*lib-directory* ))

(quit)
