/*
 Copyright (C) 1994 M. Hagiya, W. Schelter, T. Yuasa

This file is part of GNU Common Lisp, herein referred to as GCL

GCL is free software; you can redistribute it and/or modify it under
the terms of the GNU LIBRARY GENERAL PUBLIC LICENSE as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GCL is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
License for more details.

You should have received a copy of the GNU Library General Public License 
along with GCL; see the file COPYING.  If not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

*/


#include <dlfcn.h>
#ifdef HAVE_ELF
#include <elf.h>
#endif

/* cc -DVOL=volatile -G 0 -c foo.c ; ld  -shared foo.o -o jim.o ; cat foo.data >> jim.o */
int did_a_dynamic_load;

fasload(faslfile)
     object faslfile;
{ void *dlp ;
  int (*fptr)();
  char buf[200];
  static count=0;
  object memory;
  object data;
  char filename[MAXPATHLEN];
  coerce_to_filename(truename(faslfile), filename);
  sprintf(buf,"/tmp/ufas%dxXXXXXX",count++);
  /* this is just to allow reloading in the same file twice.
   */
  mktemp(buf);
  symlink(filename,buf);
  dlp = dlopen(buf,RTLD_NOW);
  if (dlp ==0)
    FEerror("Cant open for dynamic link ~a",1,make_simple_string(faslfile));
  fptr = (int (*)())dlsym(dlp, "init_code");
  if (fptr == 0)
    { FEerror("Cant find init_code in ~a",1,make_simple_string(faslfile));}
  faslfile = open_stream(faslfile, smm_input, Cnil, sKerror);
  SEEK_TO_END_OFILE(faslfile->sm.sm_fp);
  data = read_fasl_vector(faslfile);
  memory = alloc_object(t_cfdata);
  memory->cfd.cfd_self = NULL;
  memory->cfd.cfd_start = NULL;
  memory->cfd.cfd_size = 0;
  if(symbol_value(sLAload_verboseA)!=Cnil)	
    printf(" start address (dynamic) 0x%x ",fptr);
  call_init(0,memory,data,fptr);
  unlink(buf);
  did_a_dynamic_load = 1;
  return memory->cfd.cfd_size;
}

  
  

  
  

  
