/*
 * File automatically generated by
 * gengen 0.5 by Lorenzo Bettini <bettini@gnu.org>
 * http://www.lorenzobettini.it/software/gengen
 */

#ifndef FLOAT_OPT_ARG_GEN_CLASS_H
#define FLOAT_OPT_ARG_GEN_CLASS_H

#include <string>
#include <iostream>

using std::string;
using std::ostream;

class float_opt_arg_gen_class
{
 protected:
  string cast;
  string opt_var;
  string optarg;
  string structure;

 public:
  float_opt_arg_gen_class()
  {
  }

  float_opt_arg_gen_class(const string &_cast, const string &_opt_var, const string &_optarg, const string &_structure) :
    cast (_cast), opt_var (_opt_var), optarg (_optarg), structure (_structure)
  {
  }

  static void
  generate_string(const string &s, ostream &stream, unsigned int indent)
  {
    if (!indent || s.find('\n') == string::npos)
      {
        stream << s;
        return;
      }
  
    string::size_type pos;
    string::size_type start = 0;
    string ind (indent, ' ');
    while ( (pos=s.find('\n', start)) != string::npos)
      {
        stream << s.substr (start, (pos+1)-start);
        start = pos+1;
        if (start+1 <= s.size ())
          stream << ind;      
      }
    if (start+1 <= s.size ())
      stream << s.substr (start);
  }
  
  void set_cast(const string &_cast)
  {
    cast = _cast;
  }

  void set_opt_var(const string &_opt_var)
  {
    opt_var = _opt_var;
  }

  void set_optarg(const string &_optarg)
  {
    optarg = _optarg;
  }

  void set_structure(const string &_structure)
  {
    structure = _structure;
  }

  void generate_float_opt_arg(ostream &stream, unsigned int indent = 0);
  
};

#endif // FLOAT_OPT_ARG_GEN_CLASS_H
