/* gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 32
#define GMP_LIMB_BYTES 4

/* 1500 MHz Cortex-A5 (odroid c1) */
/* FFT tuning limit = 18,235,562 */
/* Generated by tuneup.c, 2019-10-22, gcc 4.9 */

#define MOD_1_NORM_THRESHOLD                 0  /* always */
#define MOD_1_UNNORM_THRESHOLD               0  /* always */
#define MOD_1N_TO_MOD_1_1_THRESHOLD          7
#define MOD_1U_TO_MOD_1_1_THRESHOLD          7
#define MOD_1_1_TO_MOD_1_2_THRESHOLD         8
#define MOD_1_2_TO_MOD_1_4_THRESHOLD     MP_SIZE_T_MAX
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD     23
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1N_PI1_METHOD                 1  /* 132.79% faster than 2 */
#define DIV_QR_1_NORM_THRESHOLD          MP_SIZE_T_MAX  /* never */
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           52

#define DIV_1_VS_MUL_1_PERCENT             213

#define MUL_TOOM22_THRESHOLD                48
#define MUL_TOOM33_THRESHOLD               143
#define MUL_TOOM44_THRESHOLD               262
#define MUL_TOOM6H_THRESHOLD               414
#define MUL_TOOM8H_THRESHOLD               527

#define MUL_TOOM32_TO_TOOM43_THRESHOLD     153
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     168
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     152
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     180
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     226

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 66
#define SQR_TOOM3_THRESHOLD                149
#define SQR_TOOM4_THRESHOLD                348
#define SQR_TOOM6_THRESHOLD                517
#define SQR_TOOM8_THRESHOLD                608

#define MULMID_TOOM42_THRESHOLD             70

#define MULMOD_BNM1_THRESHOLD               26
#define SQRMOD_BNM1_THRESHOLD               28

#define MUL_FFT_MODF_THRESHOLD             660  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    660, 5}, {     29, 6}, {     15, 5}, {     33, 6}, \
    {     17, 5}, {     35, 6}, {     29, 7}, {     15, 6}, \
    {     37, 7}, {     19, 6}, {     40, 7}, {     21, 6}, \
    {     43, 7}, {     37, 8}, {     19, 7}, {     43, 8}, \
    {     23, 7}, {     51, 8}, {     27, 7}, {     55, 8}, \
    {     31, 7}, {     63, 8}, {     43, 9}, {     23, 8}, \
    {     55, 9}, {     31, 8}, {     71, 9}, {     39, 8}, \
    {     83, 9}, {     47, 8}, {     99, 9}, {     55,10}, \
    {     31, 9}, {     63, 8}, {    127, 9}, {     79,10}, \
    {     47, 9}, {    103,11}, {     31,10}, {     63, 9}, \
    {    135,10}, {     79, 9}, {    167,10}, {     95, 9}, \
    {    191,10}, {    111,11}, {     63,10}, {    159,11}, \
    {     95,10}, {    191, 9}, {    383,12}, {     63,11}, \
    {    127,10}, {    255, 9}, {    511,10}, {    271,11}, \
    {    159,10}, {    319, 9}, {    639,10}, {    335, 9}, \
    {    671,11}, {    191,10}, {    383, 9}, {    767,10}, \
    {    399, 9}, {    799,10}, {    415,11}, {    223,12}, \
    {    127,11}, {    255,10}, {    511, 9}, {   1023,10}, \
    {    543,11}, {    287,10}, {    607,11}, {    319,10}, \
    {    671,11}, {    351,12}, {    191,11}, {    383,10}, \
    {    799,11}, {    415,10}, {    831,13}, {    127,12}, \
    {    255,11}, {    511,10}, {   1023,11}, {    543,10}, \
    {   1087,11}, {    575,10}, {   1151,11}, {    607,12}, \
    {    319,11}, {    703,12}, {    383,11}, {    831,12}, \
    {    447,11}, {    895,13}, {    255,12}, {    511,11}, \
    {   1087,12}, {    575,11}, {   1183,12}, {    639,11}, \
    {   1279,12}, {    703,13}, {    383,12}, {    767,11}, \
    {   1535,12}, {    895,14}, {    255,13}, {    511,12}, \
    {   1151,13}, {    639,12}, {   1407,13}, {    767,12}, \
    {   1599,13}, {    895,12}, {   1791,14}, {    511,13}, \
    {   1023,12}, {   2111,13}, {   1151,12}, {   2367,13}, \
    {   1279,12}, {   2559,13}, {   1407,14}, {    767,13}, \
    {   1535,12}, {   3071,13}, {   1663,12}, {   3327,13}, \
    {   1791,15}, {    511,14}, {   1023,13}, {   2175,12}, \
    {   4351,13}, {   8192,14}, {  16384,15}, {  32768,16} }
#define MUL_FFT_TABLE3_SIZE 140
#define MUL_FFT_THRESHOLD                 7552

#define SQR_FFT_MODF_THRESHOLD             590  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    590, 5}, {     33, 6}, {     17, 5}, {     35, 6}, \
    {     36, 7}, {     19, 6}, {     40, 7}, {     21, 6}, \
    {     43, 7}, {     23, 6}, {     47, 7}, {     37, 8}, \
    {     19, 7}, {     43, 8}, {     23, 7}, {     49, 8}, \
    {     27, 7}, {     55, 8}, {     31, 7}, {     63, 8}, \
    {     43, 9}, {     23, 8}, {     55, 9}, {     31, 8}, \
    {     67, 9}, {     39, 8}, {     83, 9}, {     47, 8}, \
    {     95, 9}, {     55,10}, {     31, 9}, {     79,10}, \
    {     47, 9}, {    103,11}, {     31,10}, {     63, 9}, \
    {    135,10}, {     79, 9}, {    167,10}, {     95, 9}, \
    {    191,10}, {    111,11}, {     63,10}, {    159,11}, \
    {     95,10}, {    191, 9}, {    383,12}, {     63,11}, \
    {    127,10}, {    255, 9}, {    511,10}, {    271, 9}, \
    {    543,11}, {    159,10}, {    319, 9}, {    639,10}, \
    {    335, 9}, {    671,10}, {    351,11}, {    191,10}, \
    {    383, 9}, {    767,10}, {    415,12}, {    127,11}, \
    {    255,10}, {    511, 9}, {   1023,10}, {    543, 9}, \
    {   1087,11}, {    287,10}, {    575, 9}, {   1151,10}, \
    {    607,11}, {    319,10}, {    671,11}, {    351,12}, \
    {    191,11}, {    383,10}, {    799,11}, {    415,10}, \
    {    831,13}, {    127,12}, {    255,11}, {    511,10}, \
    {   1023,11}, {    543,10}, {   1087,11}, {    575,10}, \
    {   1151,11}, {    607,12}, {    319,11}, {    735,12}, \
    {    383,11}, {    831,12}, {    447,11}, {    927,13}, \
    {    255,12}, {    511,11}, {   1087,12}, {    575,11}, \
    {   1151,12}, {    639,11}, {   1279,12}, {    703,13}, \
    {    383,12}, {    767,11}, {   1535,12}, {    831,11}, \
    {   1663,12}, {    895,11}, {   1791,12}, {    959,14}, \
    {    255,13}, {    511,12}, {   1023,11}, {   2047,12}, \
    {   1151,13}, {    639,12}, {   1407,13}, {    767,12}, \
    {   1599,13}, {    895,12}, {   1791,14}, {    511,13}, \
    {   1023,12}, {   2111,13}, {   1151,12}, {   2367,13}, \
    {   1279,12}, {   2559,13}, {   1407,14}, {    767,13}, \
    {   1535,12}, {   3071,13}, {   1663,12}, {   3327,13}, \
    {   1791,15}, {    511,14}, {   1023,13}, {   2175,12}, \
    {   4351,13}, {   8192,14}, {  16384,15}, {  32768,16} }
#define SQR_FFT_TABLE3_SIZE 144
#define SQR_FFT_THRESHOLD                 5760

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  39
#define MULLO_MUL_N_THRESHOLD            14709
#define SQRLO_BASECASE_THRESHOLD             8
#define SQRLO_DC_THRESHOLD                  33
#define SQRLO_SQR_THRESHOLD              11278

#define DC_DIV_QR_THRESHOLD                 36
#define DC_DIVAPPR_Q_THRESHOLD             116
#define DC_BDIV_QR_THRESHOLD                48
#define DC_BDIV_Q_THRESHOLD                140

#define INV_MULMOD_BNM1_THRESHOLD           95
#define INV_NEWTON_THRESHOLD               181
#define INV_APPR_THRESHOLD                 125

#define BINV_NEWTON_THRESHOLD              327
#define REDC_1_TO_REDC_2_THRESHOLD           0  /* always */
#define REDC_2_TO_REDC_N_THRESHOLD         152

#define MU_DIV_QR_THRESHOLD               2350
#define MU_DIVAPPR_Q_THRESHOLD            2130
#define MUPI_DIV_QR_THRESHOLD               98
#define MU_BDIV_QR_THRESHOLD              1970
#define MU_BDIV_Q_THRESHOLD               2172

#define POWM_SEC_TABLE  6,37,108,624,2351

#define GET_STR_DC_THRESHOLD                28
#define GET_STR_PRECOMPUTE_THRESHOLD        44
#define SET_STR_DC_THRESHOLD               309
#define SET_STR_PRECOMPUTE_THRESHOLD       762

#define FAC_DSC_THRESHOLD                  236
#define FAC_ODD_THRESHOLD                   29

#define MATRIX22_STRASSEN_THRESHOLD         25
#define HGCD2_DIV1_METHOD                    5  /* 2.92% faster than 3 */
#define HGCD_THRESHOLD                      70
#define HGCD_APPR_THRESHOLD                 59
#define HGCD_REDUCE_THRESHOLD             4120
#define GCD_DC_THRESHOLD                   229
#define GCDEXT_DC_THRESHOLD                233
#define JACOBI_BASE_METHOD                   1  /* 17.07% faster than 4 */

/* Tuneup completed successfully, took 47845 seconds */
