

module halfband_decim
  (input clock, input reset, input enable, input strobe_in, input strobe_out,
   input wire [15:0] data_in, output wire [15:0] data_out);

   reg [3:0] wr_addr;
   reg [3:0] rd_addr_even, rd_addr_odd;
   
   always @(posedge clock)
     if(reset)
       wr_addr <= #1 4'd0;
     else if(strobe_in & strobe_out)
       wr_addr <= #1 wr_addr + 4'd1;
   
   ram16 ram16_even(.clock(clock),.write(strobe_in & ~strobe_out),
		    .rd_addr(rd_addr_even),.rd_data(rd_data_even),
		    .wr_addr(wr_addr),.wr_data(data_in));

   ram16 ram16_odd(.clock(clock),.write(strobe_in & strobe_out),
		    .rd_addr(wr_addr+4'd8),.rd_data(rd_data_odd),
		    .wr_addr(wr_addr),.wr_data(data_in));
   
   mac mac(.clock(clock),.reset(reset),.enable(enable),.clear(clear),
	   .x(rd_data_even),.y(coeff),.shift(8'd8),.z(data_out));
      
   always @(posedge clock)
     if(reset)
       rd_addr_even <= #1 4'd0;
     else if(strobe_out)
       rd_addr_even <= wr_addr;
     else if(rd_addr_even != (wr_addr+4'd1))
       rd_addr_even <= #1 rd_addr - 4'd1;

endmodule // halfband_decim
