.TH GROFF_TMAC @MAN5EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff_tmac \- macro files in the roff typesetting system
.SH DESCRIPTION
.\" The .SH was moved to this place to make `apropos' happy.
.
.
.\" --------------------------------------------------------------------
.\" Legalize
.\" --------------------------------------------------------------------
.
.ig
groff_tmac.5

File position: <groff-source>/man/groff_tmac.man

Last update: 15 Jul 2003

This file is part of groff, the GNU roff type-setting system.

Copyright (C) 2000, 2001, 2002, 2003 Free Software Foundation, Inc.
written by Bernd Warken <bwarken@mayn.de> and Werner Lemberg
<wl@gnu.org>

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.1 or
any later version published by the Free Software Foundation; with the
Invariant Sections being this .ig-section and AUTHOR, with no
Front-Cover Texts, and with no Back-Cover Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.
..
.
.\" --------------------------------------------------------------------
.\" Setup
.\" --------------------------------------------------------------------
.
.do nr groff_tmac_C \n[.C]
.cp 0
.
.mso www.tmac
.
.if n \{\
.  mso tty-char.tmac
.  ftr CR R
.  ftr CI I
.  ftr CB B
.\}
.
.ds Ellipsis \&.\|.\|.\&\"
.
.\" Global static variables for inter-macro communication
.rr @+Example_font
.
.\" --------------------------------------------------------------------
.\" setup for the macro definitions below
.\"
.\" naming:  namespace:cathegory_macro.variable_name  (experimental)
.
.\" --------------------------------------------------------------------
.\" configuration of prompt for `.Shell_cmd'* macros
.ds groffer:Shell_cmd.prompt_text sh#\"    prompt for shell commands
.ds groffer:Shell_cmd+.prompt_text >\"     prompt on continuation lines
.ds groffer:Shell_cmd_base.prompt_font I\" font for prompts
.
.\" automatically determine setup from the configuration above
.als @f groffer:Shell_cmd_base.prompt_font\"
.als @t groffer:Shell_cmd.prompt_text\"
.als @t+ groffer:Shell_cmd+.prompt_text\"
.ds groffer:Shell_cmd.prompt \f[\*[@f]]\*[@t]\f[]\"            needed
.ds groffer:Shell_cmd+.prompt \f[\*[@f]]\*[@t+]\f[]\"          needed
.nr @w \w'\*[groffer:Shell_cmd.prompt]'\"
.nr @w+ \w'\*[groffer:Shell_cmd+.prompt]'\"
.ft \*[@f]
.\" Full prompt width is maximum of texts plus 1m
.nr groffer:Shell_cmd_base.prompt_width (\n[@w]>?\n[@w+]+1m)\" needed
.ft
.rm @f
.rm @f+
.rm @t
.rm @t+
.rr @w
.rr @w+
.
.\"--------------------------------------------------------------------
.\" Ignore all arguments like a comment, even after a .eo call.
.de c
..
.c --------------------------------------------------------------------
.de BIR
.  ie (\\n[.$] < 3) \
.    BI \\$@
.  el \{\
.    ds @tmp@ \fB\\$1\f[]\fI\\$2\f[]
.    shift 2
.    Text \\*[@tmp@]\fR\\$*\f[]
.    rm @tmp@
.  \}
..
.c --------------------------------------------------------------------
.c .Env_var  (<env_var_name> [<punct>])
.c
.c Display an environment variable, with optional punctuation.
.c
.de Env_var
.  nh
.  SM
.  Text \f[CB]\\$1\f[]\\$2
.  hy
..
.c --------------------------------------------------------------------
.c .Error  (<text>...)
.c
.c Print error message to terminal and abort.
.c
.de Error
.  tm \\$*
.  ab
..
.c --------------------------------------------------------------------
.de Example
.  if r@+Example_font \
.    Error previous .Example was not terminated by a ./Example
.  nr @+Example_font \\n[.f]
.  nh
.  nf
.  RS
.  ft CR
..
.c --------------------------------------------------------------------
.de /Example
.  if !r@+Example_font \
.    Error no previous call to .Example
.  ft \\n[@+Example_font]
.  RE
.  fi
.  hy
.  rr @+Example_font
..
.
.c --------------------------------------------------------------------
.c .Shell_cmd  (<CR> [<CI>] ...)
.c
.c A shell command line; display args alternating in fonts CR and CI.
.c
.c Examples:
.c   .Shell_cmd "groffer --dpi 100 file"
.c     result: `sh#  groffer --dpi 100 file'
.c             with 'sh#' in font I, the rest in CR
.c
.c   .Shell_cmd groffer\~--dpi\~100\~file
.c     result: the same as above
.c
.c   .Shell_cmd "groffer --dpi=" value " file"
.c     result: sh#  groffer --dpi=value file
.c             with `groffer --dpi=' and `file' in CR; `value' in CI
.c
.c   .Shell_cmd groffer\~--dpi= value \~file
.c     result: the same as the previous example
.c
.de Shell_cmd
.  groffer:Shell_cmd_base "\*[groffer:Shell_cmd.prompt]" \\$@
..
.c --------------------------------------------------------------------
.c .Shell_cmd+  (<CR> [<CI>] ...)
.c
.c A continuation line for .Shell_cmd.
.c
.de Shell_cmd+
.  groffer:Shell_cmd_base "\*[groffer:Shell_cmd+.prompt]" \\$@
..
.c --------------------------------------------------------------------
.c .Shell_cmd_base  (<prompt> [<CR> [<CI>] ...])
.c
.c A shell command line; display args alternating in fonts CR and CI.
.c Internal, do not use directly.
.c
.c Globals: read-only register @.Shell_cmd_width
.c
.de groffer:Shell_cmd_base
.  if (\\n[.$] <= 0) \
.    return
.  nr @+font \\n[.f]\"
.  ds @prompt \\$1\"
.  ft CR
.  c gap between prompt and command
.  nr @+gap \\n[groffer:Shell_cmd_base.prompt_width]-\\w'\\*[@prompt]'\"
.  ds @res \\*[@prompt]\h'\\n[@+gap]u'\"
.  shift
.  ds @cf CR\"
.  while (\\n[.$] > 0) \{\
.    as @res \\f[\\*[@cf]]\\$1\"
.    shift
.    ie '\\*[@cf]'CR' \
.      ds @cf I\"
.    el \
.      ds @cf CR\"
.  \}
.  br
.  ad l
.  nh
.  nf
.  Text \\*[@res]\"
.  fi
.  hy
.  ad
.  br
.  ft \\n[@+font]
.  rr @+font
.  rr @+gap
.  rm @cf
.  rm @res
..
.c --------------------------------------------------------------------
.c .Text  (<text>...)
.c
.c Treat the arguments as text, no matter how they look.
.c
.de Text
.  if (\\n[.$] == 0) \
.    return
.  nop \)\\$*\)
..
.c --------------------------------------------------------------------
.c .Topic  ([<indent>])
.c
.c A bulleted paragraph
.c
.de Topic
.  ie (\\n[.$] = 0) \
.    ds @indent 2m\"
.  el \
.    ds @indent \\$1\"
.  TP \\*[@indent]
.  Text \[bu]
.  rm @indent
..
.c --------------------------------------------------------------------
.c .TP+  ()
.c
.c Continuation line for .TP header.
.c
.de TP+
.  br
.  ns
.  TP \\$1
..
.c --------------------------------------------------------------------
.de 'char
.  ds @tmp@ `\f(CR\\$1\f[]'
.  shift
.  Text \\*[@tmp@]\\$*
.  rm @tmp@
..
.c --------------------------------------------------------------------
.de option
.  ds @tmp@ \f(CB\\$1\f[]
.  shift 1
.  Text \\*[@tmp@]\\$*
.  rm @tmp@
..
.c --------------------------------------------------------------------
.de argument
.  ds @tmp@ \f(CI\\$1\f[]
.  shift 1
.  Text \\*[@tmp@]\\$*
.  rm @tmp@
..
.c --------------------------------------------------------------------
.de request
.  ds @tmp@ \f(CB\\$1\f[]
.  shift 1
.  Text .\\*[@tmp@]\\$*
.  rm @tmp@
..
.c --------------------------------------------------------------------
.de escape
.  ds @tmp@ \f[CB]\\$1\f[]
.  shift 1
.  Text \[rs]\\*[@tmp@]\\$*
.  rm @tmp@
..
.\" --------------------------------------------------------------------
.\" SH DESCRIPTION
.\" --------------------------------------------------------------------
.
The
.BR roff (@MAN7EXT@)
type-setting system provides a set of macro packages suitable for
special kinds of documents.
.
Each macro package stores its macros and definitions in a file called
the package's
.BR "tmac file" .
The name is deduced from
.RB ` T\c
.IB roff MAC\c
.IR ros '.
.
.P
The tmac files are normal roff source documents, except that they
usually contain only definitions and setup commands, but no text.
.
All tmac files are kept in a single or a small number of directories,
the
.B tmac
directories.
.
.
.\" --------------------------------------------------------------------
.SH "GROFF MACRO PACKAGES"
.\" --------------------------------------------------------------------
.
.I groff
provides all classical macro packages, some more full packages, and
some secondary packages for special purposes.
.
Note that it is not possible to use multiple primary macro packages at the
same time; saying e.g.\&
.
.IP
.Shell_cmd "groff \-m man \-m ms foo"
.
.P
or
.
.IP
.Shell_cmd "groff \-m man foo \-m ms bar"
.
.P
will fail.
.
.
.\" --------------------------------------------------------------------
.SS "Man\~Pages"
.\" --------------------------------------------------------------------
.
.TP
.B man
This is the classical macro package for UNIX manual pages
(man\~pages); it is quite handy and easy to use; see
.BR groff_man (@MAN7EXT@).
.
.TP
.B doc
.TP+
.B mdoc
An alternative macro package for man\~pages mainly used in BSD
systems; it provides many new features, but it is not the standard for
man\~pages; see
.BR groff_mdoc (@MAN7EXT@).
.
.
.\" --------------------------------------------------------------------
.SS "Full Packages"
.\" --------------------------------------------------------------------
.
The packages in this section provide a complete set of macros for
writing documents of any kind, up to whole books.
.
They are similar in functionality; it is a matter of taste which one
to use.
.
.
.TP
.B me
The classical
.I me
macro package; see
.BR groff_me (@MAN7EXT@).
.
.
.TP
.B mm
The semi-classical
.I mm
macro package; see
.BR groff_mm (@MAN7EXT@).
.
.
.TP
.B mom
The new
.I mom
macro package, only available in groff.
.
As this is not based on other packages, it can be freely designed.
.
So it is expected to become quite a nice, modern macro package.
.
See
.BR groff_mom (@MAN7EXT@).
.
.
.TP
.B ms
The classical
.I ms
macro package; see
.BR groff_ms (@MAN7EXT@).
.
.
.\" --------------------------------------------------------------------
.SS "Special Packages"
.\" --------------------------------------------------------------------
.
The macro packages in this section are not intended for stand-alone
usage, but can be used to add special functionality to any other
macro package or to plain groff.
.
.
.TP
.B papersize
This macro file is already loaded at start-up by
.B @g@troff
so it isn't necessary to call it explicitly.
.
It provides an interface to set the paper size on the command line with
the option \f[B]\%\-dpaper=\f[]\f[I]size\f[].
.
Possible values for
.I size
are the same as the predefined
.B papersize
values in the DESC file (only lowercase; see
.BR groff_font (@MAN5EXT@)
for more) except
.BR a7 - d7 .
.
An appended
.B l
(ell) character denotes landscape orientation.
.
Examples:
.BR a4 ,
.BR c3l ,
.BR letterl .
.
.IP
Most output drivers need additional command line switches
.B \-p
and
.B \-l
to override the default paper length and orientation as set in the driver
specific DESC file.
.
For example, use the following for PS output on A4 paper in landscape
orientation:
.
.IP
.Shell_cmd "groff \-Tps \-dpaper=a4l \-P\-pa4 \-P\-l \-ms foo.ms > foo.ps"
.
.
.TP
.B pspic
A single macro is provided in this file,
.BR PSPIC ,
to include a PostScript graphic in a document.
.
It makes only sense for output devices which support inclusion of PS
images:
.BR \-Tps ,
.BR \-Tdvi ,
and
.BR \-Thtml ;
the file is then loaded automatically.
.
Syntax:
.RS
.IP
\&\fB.PSPIC\fP [\fB\-L\fP|\fB-R\fP|\fB\-I\fP \fIn\fP]\ \fI\|file\fP [\fIwidth\fP [\fIheight\fP]]
.RE
.
.IP
.I file
is the name of the file containing the illustration;
.I width
and
.I height
give the desired width and height of the graphic.
.
The
.I width
and
.I height
arguments may have scaling indicators attached;
the default scaling indicator is\~\c
.BR i .
.
This macro will scale the graphic uniformly
in the x and y\~directions so that it is no more than
.I width
wide
and
.I height
high.
.
By default, the graphic will be horizontally centered.
.
The
.BI \-L
and
.BI \-R
options cause the graphic to be left-aligned and right-aligned,
respectively.
.
The
.B \-I
option causes the graphic to be indented by\~\c
.I n
(default scaling indicator is\~\c
.BR m ).
.
.TP
.B tty-char
Overrides the definition of standard troff characters and some groff
characters for tty devices.
.
The optical appearance is intentionally inferior compared to that of
normal tty formatting to allow processing with critical equipment.
.
.
.TP
.B www
Additions of elements known from the html format, as being used in the
internet (World Wide Web) pages; this includes URL links and mail
addresses; see
.BR groff_www (@MAN7EXT@).
.
.
.\" --------------------------------------------------------------------
.SH NAMING
.\" --------------------------------------------------------------------
.
In classical roff systems, there was a funny naming scheme for macro
packages, due to a simplistic design in option parsing.
.
Macro packages were always included by option
.option -m;
when this option was directly followed by its argument without an
intervening space, this looked like a long option preceded by a single
minus \[em] a sensation in the computer stone age.
.
To make this optically working for macro package names, all classical
macro packages choose a name that started with the letter
.'char m ,
which was omitted in the naming of the macro file.
.
.
.P
For example, the macro package for the man pages was called
.IR man ,
while its macro file
.IR tmac.an .
So it could be activated by the argument
.I an
to option
.option -m ,
or
.option -man
for short.
.
.
.P
For similar reasons, macro packages that did not start with an
.'char m
had a leading
.'char m
added in the documentation and in talking; for example, the package
corresponding to
.I tmac.doc
was called
.I mdoc
in the documentation, although a more suitable name would be
.IR doc .
For, when omitting the space between the option and its argument, the
command line option for activating this package reads
.option "-mdoc" .
.
.
.P
To cope with all situations, actual versions of
.BR groff (@MAN1EXT@)
are smart about both naming schemes by providing two macro files
for the inflicted macro packages; one with a leading
.'char m ,
the other one without it.
.
So in
.IR groff ,
the
.I man
macro package may be specified as on of the following four methods:
.
.IP
.Shell_cmd "groff\~\-m\~man"
.Shell_cmd "groff\~\-man"
.Shell_cmd "groff\~\-mman"
.Shell_cmd "groff\~\-m\~an"
.
.
.P
Recent packages that do not start with
.'char m
do not use an additional
.'char m
in the documentation.
.
For example, the
.I www
macro package may be specified only as one of the two methods:
.
.IP
.Shell_cmd "groff\~\-m\~www"
.Shell_cmd "groff\~\-mwww"
.
.
.P
Obviously, variants like
.I -mmwww
would not make much sense.
.
.
.P
A second strange feature of classical troff was to name macro files
according to
.BIR tmac. name .
In modern operating systems, the type of a file is specified as
postfix, the file name extension.
.
Again, groff copes with this situation by searching both
.IB anything .tmac
and
.BI tmac. anything
if only
.I anything
is specified.
.
.
.P
The easiest way to find out which macro packages are available on a
system is to check the man\~page
.BR groff (@MAN1EXT@),
or the contents of the
.I tmac
directories.
.
.
.P
In
.IR groff ,
most macro packages are described in\~man pages called
.BR groff_\f[I]name\f[] (@MAN7EXT@),
with a leading
.'char m
for the classical packages.
.
.
.\" --------------------------------------------------------------------
.SH INCLUSION
.\" --------------------------------------------------------------------
.
There are several ways to use a macro package in a document.
.
The classical way is to specify the troff/groff option
.option \-m
.argument name
at run-time; this makes the contents of the macro package
.I name
available.
.
In groff, the file
.IB name .tmac
is searched within the tmac path; if not found,
.BI tmac. name
will be searched for instead.
.
.
.P
Alternatively, it is also possible to include a macro file by adding
the request
.request so
.I filename
into the document; the argument must be the full file name of an
existing file, possibly with the directory where it is kept.
.
In groff, this was improved by the similar request
.request mso
.IR package ,
which added searching in the tmac path, just like option
.option -m
does.
.
.
.P
Note that in order to resolve the
.request so
and
.request mso
requests, the roff preprocessor
.BR soelim (@MAN1EXT@)
must be called if the files to be included need preprocessing.
.
This can be done either directly by a pipeline on the command line or
by using the troff/groff option
.option \-s .
.
.I man
calls soelim automatically.
.
.
.P
For example, suppose a macro file is stored as
.I @MACRODIR@/macros.tmac
and is used in some document called
.IR docu.roff .
.
.
.P
At run-time, the formatter call for this is
.
.IP
.Shell_cmd "groff\~\-m\~" "macrofile\~document.roff"
.
.
.P
To include the macro file directly in the document either
.
.IP
.Example
.  Text .mso macrofile.tmac
./Example
.
.P
is used or
.
.IP
.Example
.  Text .so @MACRODIR@/macros.tmac
./Example
.
.
.P
In both cases, the formatter is called with
.IP
.Shell_cmd "groff\~\-s\~" docu.roff
.
.
.P
If you want to write your own groff macro file, call it
.IB whatever .tmac
and put it in some directory of the tmac path, see section
.BR FILES .
Then documents can include it with the
.request mso
request or the option
.option -m .
.
.
.ig
.\" --------------------------------------------------------------------
.SH CONVENTION
.\" --------------------------------------------------------------------
.
.\" This section does not fit into the framework of this document.
.
There is a convention that is supported by many modern roff
type-setters and
.BR man (1)
programs, the
.I preprocessor word
described in the following.
.
.P
If the first line in a document is a comment, the first word (after the
comment characters and a blank) constitutes the
.B preprocessor
.BR word .
That means that the letters of this word are interpreted as
abbreviations for those preprocessor commands that should be run
when formatting the document.
.
Mostly, only the letters corresponding to the options for the
preprocessors are recognized,
.'char e
(for
.BR eqn ),
.\" 'char G ,
.\" 'char g ,
.'char p ,
(for
.BR pic ),
.'char R
(for
.BR refer ),
.'char s
(for
.BR soelim ),
and
.'char t
(for
.BR tbl ).
(see
.BR roff (@MAN7EXT@)).
.
.
.P
Besides being a good reminder for the user, some formatters (like the
.BR man (1)
program) are even able to automatically start the preprocessors
specified in the preprocessor word, but do not bet on this.
.
.
.P
The
.I man
program handles some preprocessors automatically, such that in
man\~pages only the following characters should be used:
.'char e ,
.'char p ,
and
.'char t .
.
.
..
.\" --------------------------------------------------------------------
.SH "WRITING MACROS"
.\" --------------------------------------------------------------------
.
A
.BR roff (@MAN7EXT@)
document is a text file that is enriched by predefined formatting
constructs, such as requests, escape sequences, strings, numeric
registers, and macros from a macro package.
.
These elements are described in
.BR roff (@MAN7EXT@).
.
.
.P
To give a document a personal style, it is most useful to extend the
existing elements by defining some macros for repeating tasks; the best
place for this is near the beginning of the document or in a separate
file.
.
.
.P
Macros without arguments are just like strings.
.
But the full power of macros reveals when arguments are passed with a
macro call.
.
Within the macro definition, the arguments are available as the escape
sequences
.BR $1 ,
\*[Ellipsis],
.BR $9 ,
.BR $[ \*[Ellipsis] ] ,
.BR $* ,
and
.BR $@ ,
the name under which the macro was called is in
.BR $0 ,
and the number of arguments is in register
.BR \n[.$] ;
see
.BR groff (@MAN7EXT@).
.
.
.\" --------------------------------------------------------------------
.SS "Copy-in Mode"
.\" --------------------------------------------------------------------
.
The phase when groff reads a macro is called
.I "copy-in mode"
in roff-talk.
.
This is comparable to the C\~preprocessing phase during the development
of a program written in the C\~language.
.
.
.P
In this phase, groff interprets all backslashes; that means that all
escape sequences in the macro body are interpreted and replaced by
their value.
.
For constant expression, this is wanted, but strings and registers
that might change between calls of the macro must be protected from
being evaluated.
.
This is most easily done by doubling the backslash that introduces the
escape sequence.
.
This doubling is most important for the positional parameters.
.
For example, to print information on the arguments that were passed to
the macro to the terminal, define a macro named `.print_args',
say.
.
.
.P
.ds @1 \[rs]f[I]\[rs]\[rs]$0\[rs]f[]\"
.ds @2 arguments:\"
.Example
.  Text .ds midpart was called with
.  Text .de print_args
.  Text .\~\~tm\~\*[@1]\~\[rs]\[rs]*[midpart]\~\[rs]\[rs]n[.$]\~\*[@2]
.  Text .\~\~tm\~\[rs]\[rs]$*
.  Text ..
./Example
.rm @1
.rm @2
.
.
.P
When calling this macro by
.
.P
.Example
.  Text .print_args arg1 arg2
./Example
.
.P
the following text is printed to the terminal:
.
.P
.Example
.  Text \f[CI]print_args\f[] was called with the following 2 arguments:
arg1 arg2
./Example
.
.
.P
Let's analyze each backslash in the macro definition.
.
As the positional parameters and the number of arguments will change
with each call of the macro their leading backslash must be doubled,
which results in
.I \[rs]\[rs]$*
and
.IR \[rs]\[rs][.$] .
The same applies to the macro name because it could be called with an
alias name, so
.IR \[rs]\[rs]$0 .
.
.
.P
On the other hand,
.I midpart
is a constant string, it will not change, so no doubling for
.IR \[rs]*[midpart] .
The
.I \[rs]f
escape sequences are predefined groff elements for setting the font
within the text.
.
Of course, this behavior will not change, so no doubling with
.I \[rs]f[I]
and
.IR \[rs]f[] .
.
.
.\" --------------------------------------------------------------------
.SS "Draft Mode"
.\" --------------------------------------------------------------------
.
Writing groff macros is easy when the escaping mechanism is temporarily
disabled.
.
In groff, this is done by enclosing the macro definition(s) into a
pair of
.B .eo
and
.B .ec
requests.
.
Then the body in the macro definition is just like a normal part of
the document \[em] text enhanced by calls of requests, macros,
strings, registers, etc.
.
For example, the code above can be written in a simpler way by
.
.
.P
.ds @1 \[rs]f[I]\[rs]$0\[rs]f[]\"
.ds @2 arguments:\"
.Example
.  Text .eo
.  Text .ds midpart was called with
.  Text .de print_args
.  Text .\~\~tm\~\*[@1]\~\[rs]*[midpart]\~\[rs]n[.$]\~\*[@2]
.  Text .\~\~tm\~\[rs]$*
.  Text ..
.  Text .ec
./Example
.rm @1
.rm @2
.
.
.P
Unfortunately, draft mode cannot be used universally.
.
Although it is good enough for defining normal macros, draft mode
will fail with advanced applications, such as indirectly defined
strings, registers, etc.
.
An optimal way is to define and test all macros in draft mode and then
do the backslash doubling as a final step; do not forget to remove the
.I .eo
request.
.
.
.\" --------------------------------------------------------------------
.SS "Tips for Macro Definitions"
.\" --------------------------------------------------------------------
.
.Topic
Start every line with a dot, for example, by using the groff request
.B .nop
for text lines, or write your own macro that handles also text lines
with a leading dot.
.
.IP
.Example
.  Text .de Text
.  Text .\~\~if (\[rs]\[rs]n[.$] == 0)\~\[rs]
.  Text .\~\~\~\~return
.  Text .\~nop\~\[rs])\[rs]\[rs]$*[rs]\)
.  Text ..
./Example
.
.Topic
Write a comment macro that works both for copy-in and draft mode; for
as escaping is off in draft mode, trouble might occur when normal
comments are used.
.
For example, the following macro just ignores its arguments, so it
acts like a comment line:
.
.IP
.Example
.  Text .de\~c
.  Text ..
.  Text .c\~This\~is\~like\~a\~comment\~line.
./Example
.
.Topic
In long macro definitions, make ample use of comment lines or empty
lines for a better structuring.
.
.Topic
To increase readability, use groff's indentation facility for requests
and macro calls (arbitrary whitespace after the leading dot).
.
.
.\" --------------------------------------------------------------------
.SS "Diversions"
.\" --------------------------------------------------------------------
.
Diversions can be used to realize quite advanced programming
constructs.
.
They are comparable to pointers to large data structures in the
C\~programming language, but their usage is quite different.
.
.
.P
In their simplest form, diversions are multi-line strings, but
they get their power when diversions are used dynamically within macros.
.
The information stored in a diversion can be retrieved by calling the
diversion just like a macro.
.
.
.P
Most of the problems arising with diversions can be avoided if you are
conscious about the fact that diversions always deal with complete
lines.
.
If diversions are used when the line buffer has not been flashed,
strange results are produced; not knowing this, many people get
desperate about diversions.
.
To ensure that a diversion works, line breaks should be added at the
right places.
.
To be on the secure side, enclose everything that has to do with
diversions into a pair of line breaks; for example, by amply using
.B .br
requests.
.
This rule should be applied to diversion definition, both inside and
outside, and to all calls of diversions.
.
This is a bit of overkill, but it works nicely.
.
.
.P
[If you really need diversions which should ignore the current partial
line, use environments to save the current partial line and/\:or use the
.B .box
request.]
.
.
.P
The most powerful feature using diversions is to start a diversion
within a macro definition and end it within another macro.
.
Then everything between each call of this macro pair is stored within
the diversion and can be manipulated from within the macros.
.
.
.\" --------------------------------------------------------------------
.SH FILES
.\" --------------------------------------------------------------------
.
All macro names must be named
.IB name .tmac
to fully use the tmac mechanism.
.
.BI tmac. name
as with classical packages is possible as well, but deprecated.
.
.
.P
The macro files are kept in the
.IR "tmac directories" ;
a colon separated list of these constitutes the
.IR "tmac path" .
.
.
.P
The search sequence for macro files is (in that order):
.
.Topic
the directories specified with troff/groff's
.B \-M
command line option
.
.Topic
the directories given in the
.Env_var $GROFF_TMAC_PATH
environment variable
.
.Topic
the current directory (only if in unsafe mode, which is enabled by the
.B \-U
command line switch)
.
.Topic
the home directory
.
.Topic
a platform-specific directory, being
.B @SYSTEMMACRODIR@
in this installation
.
.Topic
a site-specific (platform-independent) directory, being
.B @LOCALMACRODIR@
in this installation
.
.Topic
the main tmac directory, being
.B @MACRODIR@
in this installation
.
.
.\" --------------------------------------------------------------------
.SH ENVIRONMENT
.\" --------------------------------------------------------------------
.
.TP
.Env_var $GROFF_TMAC_PATH
A colon separated list of additional tmac directories in which to search
for macro files.
.
See the previous section for a detailed description.
.
.
.\" --------------------------------------------------------------------
.SH AUTHOR
.\" --------------------------------------------------------------------
.
Copyright (C) 2000, 2001, 2002, 2003 Free Software Foundation, Inc.
.
.P
This document is distributed under the terms of the FDL (GNU Free
Documentation License) version 1.1 or later.
.
You should have received a copy of the FDL on your system, it is also
available on-line at the
.URL http://\:www.gnu.org/\:copyleft/\:fdl.html "GNU copyleft site" .
.
.P
This document is part of
.IR groff ,
the GNU roff distribution.
.
It was written by
.MTO bwarken@mayn.de "Bernd Warken" ;
it is maintained by
.MTO wl@gnu.org "Werner Lemberg" .
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
A complete reference for all parts of the groff system is found in the
groff
.BR info (1)
file.
.
.TP
.BR groff (@MAN1EXT@)
an overview of the groff system.
.
.TP
.BR groff_man (@MAN7EXT@),
.TP+
.BR groff_mdoc (@MAN7EXT@),
.TP+
.BR groff_me (@MAN7EXT@),
.TP+
.BR groff_mm (@MAN7EXT@),
.TP+
.BR groff_mom (@MAN7EXT@),
.TP+
.BR groff_ms (@MAN7EXT@),
.TP+
.BR groff_www (@MAN7EXT@).
the groff tmac macro packages.
.
.TP
.BR groff (@MAN7EXT@)
the groff language.
.
.
.P
The Filesystem Hierarchy Standard is available at the
.URL http://\:www.pathname.com/\:fhs/ "FHS web site" .
.
.cp \n[groff_tmac_C]
.
.\" Local Variables:
.\" mode: nroff
.\" End:
