/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.DVMap;
import gnu.jel.LocalField;
import gnu.jel.LocalMethod;
import gnu.jel.OP;
import gnu.jel.debug.Debug;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Library {
    private HashMap<String, HashMap<String, Member>> names;
    private HashMap<Member, Integer> dynIDs;
    private HashMap<Member, Boolean> stateless;
    private HashMap<Class<?>, HashMap<String, HashMap<String, Member>>> dotClasses;
    private boolean noDotSecurity = false;
    public DVMap resolver;
    public HashMap<String, Class<?>> cnmap;

    public Library(Class<?>[] staticLib, Class<?>[] dynamicLib, Class<?>[] dotClasses, DVMap resolver, HashMap<String, Class<?>> cnmap) {
        this.cnmap = cnmap;
        this.resolver = resolver;
        if (dotClasses == null) {
            this.dotClasses = null;
        } else {
            this.noDotSecurity = dotClasses.length == 0;
            this.dotClasses = new HashMap();
            Class[] temp = new Class[1];
            for (int i = 0; i < dotClasses.length; ++i) {
                this.rehash(dotClasses[i]);
            }
        }
        this.names = new HashMap();
        this.dynIDs = new HashMap();
        this.stateless = new HashMap();
        if (staticLib != null) {
            Library.rehash(staticLib, this.names, null, this.stateless);
        }
        if (dynamicLib != null) {
            Library.rehash(dynamicLib, this.names, this.dynIDs, null);
        }
    }

    private void rehash(Class<?> cls) {
        HashMap<String, HashMap<String, Member>> tempNames = new HashMap<String, HashMap<String, Member>>();
        Class[] temp = new Class[]{cls};
        Library.rehash(temp, tempNames, new HashMap<Member, Integer>(), null);
        this.dotClasses.put(cls, tempNames);
    }

    private static void rehash(Class<?>[] arr, HashMap<String, HashMap<String, Member>> hashedNames, HashMap<Member, Integer> dynIDs, HashMap<Member, Boolean> stateless) {
        for (int i = 0; i < arr.length; ++i) {
            Integer dynID = new Integer(i);
            Method[] marr = arr[i].getMethods();
            Field[] farr = arr[i].getFields();
            int totalMethods = marr.length;
            int totalMembers = totalMethods + farr.length;
            for (int j = 0; j < totalMembers; ++j) {
                Member m = (Member)((Object)(j < totalMethods ? marr[j] : farr[j - totalMethods]));
                if ((m.getModifiers() & 8) > 0) {
                    if (stateless == null || !Library.rehash(hashedNames, m)) continue;
                    stateless.put(m, Boolean.TRUE);
                    continue;
                }
                if (dynIDs == null || !Library.rehash(hashedNames, m)) continue;
                dynIDs.put(m, dynID);
            }
        }
    }

    private static boolean rehash(HashMap<String, HashMap<String, Member>> hashedNames, Member m) {
        HashMap<String, Member> signatures;
        String name = m.getName();
        String signature = Library.getSignature(m);
        if (Library.isField(m)) {
            signature = "()" + signature;
        }
        if ((signatures = hashedNames.get(name)) == null) {
            HashMap<String, Member> signatures_new = new HashMap<String, Member>();
            signatures_new.put(signature, m);
            hashedNames.put(name, signatures_new);
            return true;
        }
        Member conflicting_method = signatures.get(signature);
        if (conflicting_method == null) {
            signatures.put(signature, m);
            return true;
        }
        return false;
    }

    public void markStateDependent(String name, Class<?>[] params) throws CompilationException {
        Member m = this.getMember(null, name, params);
        Boolean removed = this.stateless.remove(m);
        Debug.check(removed != null, "State dependent methos \"" + m + "\"is made state dependend again.");
    }

    public boolean isStateless(Member o) {
        return this.stateless.containsKey(o);
    }

    public Member getMember(Class<?> container, String name, Class<?>[] params) throws CompilationException {
        HashMap<String, Member> signatures;
        HashMap<String, HashMap<String, Member>> hashedMembers = this.names;
        if (container != null) {
            if (this.dotClasses == null) {
                throw new CompilationException(11, null);
            }
            if (!this.noDotSecurity && !this.dotClasses.containsKey(container)) {
                Object[] paramsExc = new Object[]{container};
                throw new CompilationException(12, paramsExc);
            }
            hashedMembers = this.dotClasses.get(container);
            if (hashedMembers == null) {
                this.rehash(container);
                hashedMembers = this.dotClasses.get(container);
            }
        }
        if ((signatures = hashedMembers.get(name)) == null) {
            Object[] paramsExc = new Object[]{name, container};
            throw new CompilationException(container == null ? 5 : 6, paramsExc);
        }
        List<Member> applicable_methods = this.getApplicable(container, name, params, signatures, -1);
        if (applicable_methods.size() == 0) {
            List<Member> applicable_methods_with_varargs = this.getApplicable(container, name, params, signatures, params.length);
            if (applicable_methods_with_varargs.size() == 0) {
                Object[] paramsExc = new Object[]{name, Library.describe(name, params), container};
                throw new CompilationException(container == null ? 7 : 8, paramsExc);
            }
            return this.getMostSpecific(container, name, params, applicable_methods_with_varargs, params.length);
        }
        return this.getMostSpecific(container, name, params, applicable_methods, -1);
    }

    protected List<Member> getApplicable(Class<?> container, String name, Class<?>[] params, HashMap<String, Member> signatures, int np) {
        Debug.check(np == -1 || np == params.length);
        ArrayList<Member> applicable_methods = new ArrayList<Member>();
        for (Member cm : signatures.values()) {
            Class<?>[] cp = Library.getParameterTypes(cm, np);
            boolean applicable = false;
            if (params != null) {
                if (cp.length == params.length) {
                    applicable = true;
                    for (int i = 0; i < cp.length && applicable; ++i) {
                        applicable = OP.isWidening(params[i], cp[i]);
                    }
                }
            } else {
                boolean bl = applicable = cp.length == 0;
            }
            if (!applicable) continue;
            applicable_methods.add(cm);
        }
        return applicable_methods;
    }

    protected Member getMostSpecific(Class<?> container, String name, Class<?>[] params, List<Member> applicable_methods, int np) throws CompilationException {
        Debug.check(np == -1 || np == params.length);
        Iterator<Member> e = applicable_methods.iterator();
        Member most_specific = e.next();
        Class<?>[] most_specific_params = Library.getParameterTypes(most_specific, np);
        while (e.hasNext()) {
            Member cm = e.next();
            Class<?>[] cp = Library.getParameterTypes(cm, np);
            boolean moreSpecific = true;
            boolean lessSpecific = true;
            for (int i = 0; i < cp.length; ++i) {
                moreSpecific = moreSpecific && OP.isWidening(cp[i], most_specific_params[i]);
                lessSpecific = lessSpecific && OP.isWidening(most_specific_params[i], cp[i]);
            }
            if (moreSpecific && !lessSpecific) {
                most_specific = cm;
                most_specific_params = cp;
            }
            if (moreSpecific ^ lessSpecific) continue;
            Object[] paramsExc = new Object[]{Library.describe(name, most_specific_params), Library.describe(name, cp), Library.describe(name, params), container};
            throw new CompilationException(container == null ? 9 : 10, paramsExc);
        }
        return most_specific;
    }

    protected static String describe(String name, Class<?>[] params) {
        StringBuilder invp = new StringBuilder();
        invp.append(name);
        invp.append('(');
        if (params != null) {
            for (int k = 0; k < params.length; ++k) {
                if (k != 0) {
                    invp.append(',');
                }
                invp.append(params[k].toString());
            }
        }
        invp.append(')');
        return invp.toString();
    }

    public int getDynamicMethodClassID(Member m) {
        Integer id = this.dynIDs.get(m);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public static Class<?> getType(Member m) {
        if (m instanceof Method) {
            return ((Method)m).getReturnType();
        }
        if (m instanceof Field) {
            return ((Field)m).getType();
        }
        if (m instanceof LocalField) {
            return ((LocalField)m).getType();
        }
        Debug.check(m instanceof Constructor);
        return OP.specialTypes[9];
    }

    public static Class<?>[] getParameterTypes(Member m, int np) {
        Class<?>[] params = null;
        if (m instanceof Method) {
            params = ((Method)m).getParameterTypes();
        }
        if (m instanceof LocalMethod) {
            params = ((LocalMethod)m).getParameterTypes();
        }
        if (m instanceof Constructor) {
            params = ((Constructor)m).getParameterTypes();
        }
        if (params != null) {
            int i;
            if (np < params.length || params.length == 0 || !params[params.length - 1].isArray()) {
                return params;
            }
            Class[] newparams = new Class[np];
            for (i = 0; i < params.length - 1; ++i) {
                newparams[i] = params[i];
            }
            for (i = params.length - 1; i < np; ++i) {
                newparams[i] = params[params.length - 1].getComponentType();
            }
            return newparams;
        }
        Debug.check(m instanceof Field || m instanceof LocalField);
        return new Class[0];
    }

    public static String getSignature(Member m) {
        StringBuilder signature = new StringBuilder();
        if (!Library.isField(m)) {
            Class<?>[] parameters = Library.getParameterTypes(m, -1);
            signature.append('(');
            for (int i = 0; i < parameters.length; ++i) {
                Library.appendSignature(signature, parameters[i]);
            }
            signature.append(')');
        }
        Library.appendSignature(signature, Library.getType(m));
        return signature.toString();
    }

    public static boolean isField(Member m) {
        return m instanceof Field || m instanceof LocalField && !(m instanceof LocalMethod);
    }

    public static String getSignature(Class<?> cls) {
        return Library.appendSignature(new StringBuilder(), cls).toString();
    }

    private static StringBuilder appendSignature(StringBuilder buff, Class<?> cls) {
        if (cls.isPrimitive()) {
            int tid = OP.typeID(cls);
            buff.append(tid > 9 ? (char)'L' : "ZBCSIJFDLV".charAt(tid));
        } else if (cls.isArray()) {
            buff.append('[');
            Library.appendSignature(buff, cls.getComponentType());
        } else {
            buff.append('L');
            Library.appendHistoricalForm(buff, cls.getName());
            buff.append(';');
        }
        return buff;
    }

    public static String toHistoricalForm(String className) {
        return Library.appendHistoricalForm(new StringBuilder(), className).toString();
    }

    private static StringBuilder appendHistoricalForm(StringBuilder buff, String className) {
        int namelen = className.length();
        for (int i = 0; i < className.length(); ++i) {
            char cch = className.charAt(i);
            if (cch == '.') {
                cch = '/';
            }
            buff.append(cch);
        }
        return buff;
    }
}

