/* -*-c-*- ---------------- mixgtk_mixal.h :
 * Declarations for functions displaying the mixal source file
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: <2001-04-21 23:54:18 jao>
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */


#ifndef MIXGTK_MIXAL_H
#define MIXGTK_MIXAL_H

#include <gtk/gtk.h>
#include <mixlib/mix_vm.h>

/* the possible colorised elements */
typedef enum {
  MIXAL_LINE_BREAK,
  MIXAL_LINE_LOC,
  MIXAL_LINE_PLAIN
} mixal_line_t;

typedef enum {
  MIXAL_LINE_BG,
  MIXAL_LINE_FG
} mixal_line_zone_t;


/* initialise the mixal widget */
extern gboolean
mixgtk_mixal_init (mix_vm_t *vm);

/* set the plain, location pointer and break colors */
extern void
mixgtk_mixal_set_color (mixal_line_t line, mixal_line_zone_t zone,
			const GdkColor *color);

extern const GdkColor *
mixgtk_mixal_get_color (mixal_line_t line, mixal_line_zone_t zone);


/* load the corresponding mixal file */
extern void
mixgtk_mixal_load_file (void);

/* update the widget */
extern void
mixgtk_mixal_update (void);

/* breakpoints */
extern void
mixgtk_mixal_update_bp_at_address (guint addr);

extern void
mixgtk_mixal_update_bp_at_line (guint line);

extern void
mixgtk_mixal_update_bp_all (void);


/* callbacks */
extern void
on_mixal_select_row (GtkWidget *w, gint row, gint col, GdkEventButton *e,
		     gpointer data);

#endif /* MIXGTK_MIXAL_H */

