## Copyright (C) 2013-2017 Vytautas Jančauskas
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or (at
## your option) any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, see
## <http://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @deftypefn  {} {@var{value} =} get (@var{player}, @var{name})
## @deftypefnx {} {@var{values} =} get (@var{player})
## Return the @var{value} of the property identified by @var{name}.
##
## If @var{name} is a cell array return the values of the properties
## identified by the elements of the cell array.  Given only the player
## object, return a scalar structure with values of all properties of
## @var{player}.  The field names of the structure correspond to property
## names.
## @end deftypefn

function retval = get (varargin)

  if (nargin < 1 || nargin > 2)
    print_usage ();
  endif

  properties = __get_properties__ (varargin{1});

  if (nargin == 1)
    retval = properties;
  elseif (nargin == 2)
    pnames = varargin{2};
    if (ischar (pnames))
      retval = getfield (properties, pnames);
    elseif (iscellstr (pnames))
      retval = cell (size (pnames));
      for i = 1:numel (pnames)
        retval{i} = getfield (properties, pnames{i});
      endfor
    else
      error ("@audioplayer/get: invalid name argument");
    endif
  endif

endfunction
