indexing
   description: "configuration file scanner"
   author: "Julien Lemoine <speedblue@happycoders.org>"
   --| Copyright (C) 2002-2004 Julien Lemoine
   --| This program is free software; you can redistribute it and/or modify
   --| it under the terms of the GNU General Public License as published by
   --| the Free Software Foundation; either version 2 of the License, or
   --| (at your option) any later version.
   --| 
   --| This program is distributed in the hope that it will be useful,
   --| but WITHOUT ANY WARRANTY; without even the implied warranty of
   --| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   --| GNU General Public License for more details.
   --|
   --| You should have received a copy of the GNU General Public License
   --| along with this program; if not, write to the Free Software
   --| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

class SCANNER
   inherit
   YY_COMPRESSED_SCANNER_SKELETON
      rename
	 make as make_compressed_scanner_skeleton,
	 reset as reset_compressed_scanner_skeleton
      end
   
   TOKENS
      export {NONE} all end
      
      UT_CHARACTER_CODES
      export {NONE} all end
      
      KL_IMPORTED_INTEGER_ROUTINES
      KL_IMPORTED_STRING_ROUTINES
      KL_SHARED_PLATFORM
      
creation
   make


feature -- Status report

	valid_start_condition (sc: INTEGER): BOOLEAN is
			-- Is `sc' a valid start condition?
		do
			Result := (sc = INITIAL)
		end

feature {NONE} -- Implementation

	yy_build_tables is
			-- Build scanner tables.
		do
			yy_nxt ?= yy_nxt_template
			yy_chk ?= yy_chk_template
			yy_base ?= yy_base_template
			yy_def ?= yy_def_template
			yy_ec ?= yy_ec_template
			yy_meta ?= yy_meta_template
			yy_accept ?= yy_accept_template
		end

	yy_execute_action (yy_act: INTEGER) is
			-- Execute semantic action.
		do
if yy_act <= 10 then
if yy_act <= 5 then
if yy_act <= 3 then
if yy_act <= 2 then
if yy_act = 1 then
--|#line 47 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 47")
end
-- Ignore separators
else
--|#line 48 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 48")
end
eif_lineno := eif_lineno + text_count
end
else
--|#line 49 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 49")
end
-- Ignore comments
end
else
if yy_act = 4 then
--|#line 51 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 51")
end
last_token := T_XML
else
--|#line 52 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 52")
end
last_token := T_HTML
end
end
else
if yy_act <= 8 then
if yy_act <= 7 then
if yy_act = 6 then
--|#line 53 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 53")
end
last_token := T_BIBTEX
else
--|#line 54 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 54")
end
last_token := T_LATEX
end
else
--|#line 55 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 55")
end
last_token := T_INPUT
end
else
if yy_act = 9 then
--|#line 56 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 56")
end
last_token := T_OUTPUT
else
--|#line 57 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 57")
end
last_token := T_PRIVATE
end
end
end
else
if yy_act <= 15 then
if yy_act <= 13 then
if yy_act <= 12 then
if yy_act = 11 then
--|#line 58 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 58")
end
last_token := T_MODE
else
--|#line 59 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 59")
end
last_token := T_REC
end
else
--|#line 60 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 60")
end
last_token := T_TEMPLATE
end
else
if yy_act = 14 then
--|#line 61 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 61")
end
last_token := T_HTTPDPATH
else
--|#line 62 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 62")
end
last_token := T_TRUE
end
end
else
if yy_act <= 18 then
if yy_act <= 17 then
if yy_act = 16 then
--|#line 63 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 63")
end
last_token := T_FALSE
else
--|#line 64 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 64")
end
last_token := T_EQUAL
end
else
--|#line 65 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 65")
end

			  last_token := T_INTEGER
			  last_value := text.to_integer
			
end
else
if yy_act = 19 then
--|#line 69 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 69")
end

			  last_token := T_STRING			
			  last_value := text
			
else
--|#line 0 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 0")
end
default_action
end
end
end
end
		end

	yy_execute_eof_action (yy_sc: INTEGER) is
			-- Execute EOF semantic action.
		do
			inspect yy_sc
when 0 then
--|#line 0 "scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'scanner.l' at line 0")
end
terminate
			else
				terminate
			end
		end

feature {NONE} -- Table templates

	yy_nxt_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    4,    5,    6,    7,    8,    9,    9,    9,   10,
			    8,   11,    8,   12,   13,   14,   15,   16,   17,   18,
			    8,   19,    8,   20,    8,   21,    8,    8,    8,    8,
			    8,   13,    8,    8,    8,    8,    8,    8,    8,    8,
			    8,   22,    8,    8,    8,   27,   27,   27,   30,   37,
			   37,   27,   27,   27,   42,   43,   50,   55,   38,   63,
			   68,   44,   26,   25,   30,   25,  128,   37,   37,  127,
			  126,   42,  125,  124,   50,   55,   63,   68,  123,  122,
			  121,  120,  119,  118,  117,  116,  115,  114,  113,  112,
			  111,  110,  109,  108,  107,  106,  105,  104,  103,  102,

			  101,  100,   99,   98,   97,   96,   95,   94,   93,   92,
			   91,   90,   89,   88,   87,   86,   85,   84,   83,   82,
			   81,   80,   79,   78,   77,   76,   75,   74,   73,   72,
			   71,   70,   69,   67,   66,   65,   64,   62,   61,   60,
			   59,   58,   57,   56,   54,   53,   52,   51,   49,   48,
			   47,   46,   45,   41,   40,   24,   23,   39,   36,   35,
			   34,   33,   32,   31,   29,   28,   24,   23,  129,    3,
			  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,
			  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,
			  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,

			  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,
			  129,  129,  129,  129>>)
		end

	yy_chk_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    9,    9,    9,   13,   20,
			   22,   27,   27,   27,   30,   31,   37,   42,   20,   50,
			   55,   31,  131,  130,   13,  130,  127,   20,   22,  126,
			  125,   30,  122,  121,   37,   42,   50,   55,  120,  119,
			  118,  116,  115,  113,  111,  108,  107,  106,  105,  104,
			  103,  102,  101,  100,   98,   97,   95,   94,   93,   92,

			   91,   90,   89,   88,   87,   86,   85,   84,   83,   82,
			   81,   80,   79,   78,   77,   76,   75,   74,   73,   72,
			   71,   70,   69,   67,   66,   65,   64,   62,   61,   59,
			   58,   57,   56,   54,   53,   52,   51,   49,   48,   47,
			   46,   45,   44,   43,   41,   40,   39,   38,   36,   35,
			   34,   33,   32,   29,   28,   24,   23,   21,   19,   18,
			   17,   16,   15,   14,   12,   11,    6,    5,    3,  129,
			  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,
			  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,
			  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,

			  129,  129,  129,  129,  129,  129,  129,  129,  129,  129,
			  129,  129,  129,  129>>)
		end

	yy_base_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,  168,  169,  165,  163,    0,    0,   39,
			  169,  132,  128,   38,  122,  126,  135,  123,  117,  128,
			   28,  122,   29,  154,  152,    0,    0,   45,  127,  127,
			   37,   20,  114,  128,  121,  108,  120,   32,  112,  112,
			  122,  117,   35,  109,  104,   99,  110,  109,  100,   95,
			   46,   98,  121,  104,   99,   47,  118,  102,   89,   85,
			    0,   86,   88,    0,   92,   92,   80,   93,    0,   89,
			  109,  100,  105,   77,   77,   90,   81,  100,   93,   78,
			   74,   84,   76,   88,   74,   65,   75,   71,   64,   72,
			   73,   59,   65,   72,   54,   66,    0,   61,   61,    0,

			   73,   60,   61,   49,   59,   68,   57,   43,   59,    0,
			    0,   52,    0,   57,    0,   56,   40,    0,   39,   38,
			   46,   41,   42,    0,    0,   58,   32,   38,    0,  169,
			   62,   59>>)
		end

	yy_def_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,  129,    1,  129,  129,  129,  129,  130,  131,  131,
			  129,  131,  131,  131,  131,  131,  131,  131,  131,  131,
			  131,  131,  131,  129,  129,  130,  131,  131,  131,  131,
			  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
			  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
			  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
			  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
			  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
			  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
			  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,

			  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
			  131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
			  131,  131,  131,  131,  131,  131,  131,  131,  131,    0,
			  129,  129>>)
		end

	yy_ec_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    2,
			    3,    1,    1,    2,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    2,    1,    1,    4,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    5,    5,    5,    6,    6,
			    6,    7,    8,    6,    6,    6,    6,    6,    5,    1,
			    1,    9,    1,    1,    1,   10,   11,    5,   12,   13,
			   14,    5,   15,   16,    5,    5,   17,   18,    5,   19,
			   20,    5,   21,   22,   23,   24,    5,    5,   25,    5,
			    5,    1,    1,    1,    1,    5,    1,   26,   27,   28,

			   29,   30,   31,    5,   32,   33,    5,    5,   34,   35,
			   36,   37,   38,    5,   39,   40,   41,   42,   43,    5,
			   44,    5,    5,    1,    1,    1,    5,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1>>)
		end

	yy_meta_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    2,    1,    3,    3,    3,    3,    1,
			    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
			    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
			    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
			    3,    3,    3,    3,    3>>)
		end

	yy_accept_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,   21,   20,    1,    2,    3,   19,   18,
			   17,   19,   19,   19,   19,   19,   19,   19,   19,   19,
			   19,   19,   19,    1,    2,    3,   19,   18,   19,   19,
			   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
			   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
			   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
			   11,   19,   19,   15,   19,   19,   19,   19,   16,   19,
			   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
			   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
			   19,   19,   19,   19,   19,   19,    4,   19,   19,    5,

			   19,   19,   19,   19,   19,   19,   19,   19,   19,    8,
			    7,   19,   12,   19,    6,   19,   19,    9,   19,   19,
			   19,   19,   19,   14,   13,   19,   19,   19,   10,    0>>)
		end

feature {NONE} -- Constants

	yyJam_base: INTEGER is 169
			-- Position in `yy_nxt'/`yy_chk' tables
			-- where default jam table starts

	yyJam_state: INTEGER is 129
			-- State id corresponding to jam state

	yyTemplate_mark: INTEGER is 130
			-- Mark between normal states and templates

	yyNull_equiv_class: INTEGER is 1
			-- Equivalence code for NULL character

	yyReject_used: BOOLEAN is false
			-- Is `reject' called?

	yyVariable_trail_context: BOOLEAN is false
			-- Is there a regular expression with
			-- both leading and trailing parts having
			-- variable length?

	yyReject_or_variable_trail_context: BOOLEAN is false
			-- Is `reject' called or is there a
			-- regular expression with both leading
			-- and trailing parts having variable length?

	yyNb_rules: INTEGER is 20
			-- Number of rules

	yyEnd_of_buffer: INTEGER is 21
			-- End of buffer rule code

	yyLine_used: BOOLEAN is false
			-- Are line and column numbers used?

	yyPosition_used: BOOLEAN is false
			-- Is `position' used?

	INITIAL: INTEGER is 0
			-- Start condition codes

feature -- User-defined features



feature {NONE}
   make is
      do
	 make_with_buffer(Empty_buffer)
	 eif_buffer := STRING_.make (Init_buffer_size)
	 eif_lineno := 1
      end
   
   reset is -- Reset scanner before scanning next input
      do
	 reset_compressed_scanner_skeleton
	 eif_lineno := 1
	 eif_buffer.wipe_out
      end
   
feature -- Access
   last_value : ANY
   eif_buffer : STRING
   eif_lineno : INTEGER
   
feature {NONE} -- constants
   Init_buffer_size: INTEGER is 256

end -- class SCANNER
